#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Hamilton: The Dating Sim
# send your bug reports to contact@dotslashplay.it
###

script_version=20240912.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='hamilton-the-dating-sim'
GAME_NAME='Hamilton: The Dating Sim'

ARCHIVE_BASE_0_NAME='HamiltonTheDatingSim-2.1.1-linux.tar.bz2'
ARCHIVE_BASE_0_MD5='764b130ee2b0a940c4977295eff994cb'
ARCHIVE_BASE_0_SIZE='73000'
ARCHIVE_BASE_0_VERSION='2.1.1-itch.2019.08.23'
ARCHIVE_BASE_0_URL='https://timidsquid.itch.io/hamilton-the-dating-sim'

CONTENT_PATH_DEFAULT='HamiltonTheDatingSim-2.1.1-linux/game'
CONTENT_GAME_MAIN_FILES='
cache
gui
images
tl
Aaronclocktick.mp3
script_version.txt
*.rpy
*.rpyc'

APP_MAIN_TYPE='renpy'

## Ensure easy upgrades from packages generated with pre-20240912.1 game scripts
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
hamilton-the-dating-sim-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Write launchers

## Use the default Ren'Py icon
desktop_field_icon() {
	printf 'renpy'
}

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
