/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html;

import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.xiphias.dom.CharacterDataImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;

public class EditorInstruction {

	private NodeImpl current;
	private NodeImpl parent;
	private HtmlElement htmlElement;
	private CharacterDataImpl characterDataNode;
	private boolean doIgnore = false;
	private boolean doTraverse = true;
	private Script script;

	public EditorInstruction(Script script) {
		this.script = script;
	}

	public boolean doIgnore() {
		return doIgnore;
	}

	public void doIgnore(boolean ignore) {
		this.doIgnore = ignore;
	}

	public boolean doTraverse() {
		return doTraverse;
	}

	public void doTraverse(boolean traverse) {
		this.doTraverse = traverse;
	}

	public HtmlElement getHtmlElement() {
		return htmlElement;
	}

	public NodeImpl getCurrent() {
		return current;
	}

	public NodeImpl getParent() {
		return parent;
	}

	public CharacterDataImpl getCharacterDataNode() {

		return characterDataNode;
	}

	public void setHtmlElement(HtmlElement htmlElement) {
		this.htmlElement = htmlElement;
	}

	public void setCurrent(NodeImpl current) {
		this.current = current;
	}

	public void setParent(NodeImpl targetNode) {
		this.parent = targetNode;
	}

	public void setCharacterDataNode(CharacterDataImpl characterDataNode) {

		this.characterDataNode = characterDataNode;
	}

	@Override
	public String toString() {

		String buffer = "";

		buffer += ("\nEditor values:\n" + "current.........: " + current + "\n"
				+ "parent..........: " + parent + "\n" + "child...........: "
				+ htmlElement + "\n" +"do ignore.......: " + doIgnore + "\n"
				+ "do traverse.....: " + doTraverse + "\n");

		return buffer;
	}

	public Script getScript() {
		return script;
	}
}
