/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineLocationImpl;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemBuilder;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.error.PSystemErrorPreprocessor;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc2.PreprocessorModeSet;
import net.sourceforge.plantuml.tim.TimLoader;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.Version;

public class BlockUml {
    private final List<StringLocated> rawSource;
    private final List<StringLocated> data;
    private List<StringLocated> debug;
    private Diagram system;
    private final Defines localDefines;
    private final ISkinSimple skinParam;
    private final Set<FileWithSuffix> included = new HashSet<FileWithSuffix>();
    private boolean preprocessorError;

    public Set<FileWithSuffix> getIncluded() {
        return Collections.unmodifiableSet(this.included);
    }

    BlockUml(String ... strings) {
        this(BlockUml.convert(strings), Defines.createEmpty(), null, null);
    }

    public String getEncodedUrl() throws IOException {
        Transcoder transcoder = TranscoderUtil.getDefaultTranscoder();
        String source = this.getDiagram().getSource().getPlainString();
        String encoded = transcoder.encode(source);
        return encoded;
    }

    public String getFlashData() {
        StringBuilder sb = new StringBuilder();
        for (StringLocated line : this.data) {
            sb.append(line.getString());
            sb.append('\r');
            sb.append('\n');
        }
        return sb.toString();
    }

    public static List<StringLocated> convert(String ... strings) {
        return BlockUml.convert(Arrays.asList(strings));
    }

    public static List<StringLocated> convert(List<String> strings) {
        ArrayList<StringLocated> result = new ArrayList<StringLocated>();
        LineLocationImpl location = new LineLocationImpl("block", null);
        for (String s : strings) {
            location = location.oneLineRead();
            result.add(new StringLocated(s, location));
        }
        return result;
    }

    public BlockUml(List<StringLocated> strings, Defines defines, ISkinSimple skinParam, PreprocessorModeSet mode) {
        this.rawSource = new ArrayList<StringLocated>(strings);
        this.localDefines = defines;
        this.skinParam = skinParam;
        String s0 = strings.get(0).getTrimmed().getString();
        if (!StartUtils.startsWithSymbolAnd("start", s0)) {
            throw new IllegalArgumentException();
        }
        if (mode == null) {
            this.data = new ArrayList<StringLocated>(strings);
        } else {
            TimLoader timLoader = new TimLoader(mode.getImportedFiles(), defines, mode.getCharset(), (DefinitionsContainer)mode);
            this.included.addAll(timLoader.load(strings));
            this.data = timLoader.getResultList();
            this.debug = timLoader.getDebug();
            this.preprocessorError = timLoader.isPreprocessorError();
        }
    }

    public String getFileOrDirname() {
        if (OptionFlags.getInstance().isWord()) {
            return null;
        }
        Matcher2 m = StartUtils.patternFilename.matcher(StringUtils.trin(this.data.get(0).getString()));
        boolean ok = m.find();
        if (!ok) {
            return null;
        }
        String result = m.group(1);
        int x = result.indexOf(44);
        if (x != -1) {
            result = result.substring(0, x);
        }
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if ("<>|".indexOf(c) == -1) continue;
            return null;
        }
        if (result.startsWith("file://")) {
            result = result.substring("file://".length());
        }
        result = result.replaceAll("\\.\\w\\w\\w$", "");
        return result;
    }

    public Diagram getDiagram() {
        if (this.system == null) {
            this.system = this.preprocessorError ? new PSystemErrorPreprocessor(this.data, this.debug) : new PSystemBuilder().createPSystem(this.skinParam, this.data, this.rawSource);
        }
        return this.system;
    }

    public final List<StringLocated> getData() {
        return this.data;
    }

    private String internalEtag() {
        try {
            AsciiEncoder coder = new AsciiEncoder();
            MessageDigest msgDigest = MessageDigest.getInstance("MD5");
            for (StringLocated s : this.data) {
                msgDigest.update(s.getString().getBytes("UTF-8"));
            }
            byte[] digest = msgDigest.digest();
            return coder.encode(digest);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "NOETAG";
        }
    }

    public String etag() {
        return Version.etag() + this.internalEtag();
    }

    public long lastModified() {
        return Version.compileTime() / 1000L / 60L * 1000L * 60L + (long)Version.beta() * 1000L * 3600L;
    }

    public boolean isStartDef(String name) {
        String signature = "@startdef(id=" + name + ")";
        return this.data.get(0).getString().equalsIgnoreCase(signature);
    }

    public List<String> getDefinition(boolean withHeader) {
        ArrayList<String> result = new ArrayList<String>();
        for (StringLocated s : this.data) {
            result.add(s.getString());
        }
        if (withHeader) {
            return Collections.unmodifiableList(result);
        }
        return Collections.unmodifiableList(result.subList(1, result.size() - 1));
    }

    public Defines getLocalDefines() {
        return this.localDefines;
    }
}

