// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UMLAL2_2D_TRACE_AARCH64_H_
#define VIXL_SIM_UMLAL2_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_umlal2_2D[] = {
  0x00003ffd00090000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000001,
  0x00000000007ffd00, 0x0000000000000001,
  0x0000000000fffa00, 0x0000000000000001,
  0x000000000fffa000, 0x0000000000000001,
  0x000000003e7e8900, 0x0000000000000001,
  0x000000003efe8600, 0x0000000000000001,
  0x000000003f7e8300, 0x0000000000000001,
  0x0000003ffd000900, 0x0000000000000001,
  0x0000003ffd800600, 0x0000000000000001,
  0x0000003ffe000300, 0x0000000000000001,
  0x001998ffffe66700, 0x0000000000000001,
  0x002aa9aaaa800100, 0x0000000000000001,
  0x003ffe7ffe800900, 0x0000000000000001,
  0x003ffe7fff000600, 0x0000000000000001,
  0x003ffe7fff800300, 0x0000000000000001,
  0x003ffe8000000000, 0x0000000000000001,
  0x003ffe80007ffd00, 0x0000000000000001,
  0x0055535555000200, 0x0000000000000001,
  0x006663ffff999c00, 0x0000000000000001,
  0x007ffcc001800000, 0x0000000000000001,
  0x007ffcc001fffd00, 0x0000000000000001,
  0x007ffcc0027ffa00, 0x0000000000000001,
  0x007ffcc002fff700, 0x0000000000000001,
  0x007ffcffc0018000, 0x0000000000000001,
  0x007ffcffc0817d00, 0x0000000000000001,
  0x007ffcffc1017a00, 0x0000000000000001,
  0x007ffcffc1817700, 0x0000000000000001,
  0x007ffcfff0006000, 0x0000000000000001,
  0x007ffcfffe800900, 0x0000000000000001,
  0x007ffcffff000600, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000021,
  0x0000000000000000, 0x000000000000007e,
  0x0000000000000000, 0x000000000000007f,
  0x0000000000000000, 0x0000000000000080,
  0x0000000000000000, 0x0000000000007ffe,
  0x0000000000000000, 0x0000000000007fff,
  0x0000000000000000, 0x0000000000008000,
  0x0000000000000000, 0x0000000033333334,
  0x0000000000000000, 0x0000000055555556,
  0x0000000000000000, 0x000000007ffffffe,
  0x0000000000000000, 0x000000007fffffff,
  0x0000000000000000, 0x0000000080000000,
  0x0000000000000000, 0x0000000080000001,
  0x0000000000000000, 0x0000000080000002,
  0x0000000000000000, 0x00000000aaaaaaab,
  0x0000000000000000, 0x00000000cccccccd,
  0x0000000000000000, 0x00000000ffff8001,
  0x0000000000000000, 0x00000000ffff8002,
  0x0000000000000000, 0x00000000ffff8003,
  0x0000000000000000, 0x00000000ffff8004,
  0x0000000000000000, 0x00000000ffffff81,
  0x0000000000000000, 0x00000000ffffff82,
  0x0000000000000000, 0x00000000ffffff83,
  0x0000000000000000, 0x00000000ffffff84,
  0x0000000000000000, 0x00000000ffffffe1,
  0x0000000000000000, 0x00000000fffffffe,
  0x0000000000000000, 0x00000000ffffffff,
  0x0000000000000000, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000001, 0x0000000000000005,
  0x0000000000000002, 0x0000000000000041,
  0x0000000000000020, 0x00000000000000fb,
  0x000000000000007d, 0x00000000000000fd,
  0x000000000000007e, 0x00000000000000ff,
  0x000000000000007f, 0x000000000000fffb,
  0x0000000000007ffd, 0x000000000000fffd,
  0x0000000000007ffe, 0x000000000000ffff,
  0x0000000000007fff, 0x0000000066666667,
  0x0000000033333333, 0x00000000aaaaaaab,
  0x0000000055555555, 0x00000000fffffffb,
  0x000000007ffffffd, 0x00000000fffffffd,
  0x000000007ffffffe, 0x00000000ffffffff,
  0x000000007fffffff, 0x0000000100000001,
  0x0000000080000000, 0x0000000100000003,
  0x0000000080000001, 0x0000000155555555,
  0x00000000aaaaaaaa, 0x0000000199999999,
  0x00000000cccccccc, 0x00000001ffff0001,
  0x00000000ffff8000, 0x00000001ffff0003,
  0x00000000ffff8001, 0x00000001ffff0005,
  0x00000000ffff8002, 0x00000001ffff0007,
  0x00000000ffff8003, 0x00000001ffffff01,
  0x00000000ffffff80, 0x00000001ffffff03,
  0x00000000ffffff81, 0x00000001ffffff05,
  0x00000000ffffff82, 0x00000001ffffff07,
  0x00000000ffffff83, 0x00000001ffffffc1,
  0x00000000ffffffe0, 0x00000001fffffffb,
  0x00000000fffffffd, 0x00000001fffffffd,
  0x00000000fffffffe, 0x00000001ffffffff,
  0x00000001fffffffe, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000021,
  0x0000000000000002, 0x0000000000000041,
  0x0000000000000004, 0x0000000000000401,
  0x0000000000000040, 0x0000000000000fa1,
  0x00000000000000fa, 0x0000000000000fc1,
  0x00000000000000fc, 0x0000000000000fe1,
  0x00000000000000fe, 0x00000000000fffa1,
  0x000000000000fffa, 0x00000000000fffc1,
  0x000000000000fffc, 0x00000000000fffe1,
  0x000000000000fffe, 0x0000000666666661,
  0x0000000066666666, 0x0000000aaaaaaaa1,
  0x00000000aaaaaaaa, 0x0000000fffffffa1,
  0x00000000fffffffa, 0x0000000fffffffc1,
  0x00000000fffffffc, 0x0000000fffffffe1,
  0x00000000fffffffe, 0x0000001000000001,
  0x0000000100000000, 0x0000001000000021,
  0x0000000100000002, 0x0000001555555541,
  0x0000000155555554, 0x0000001999999981,
  0x0000000199999998, 0x0000001ffff00001,
  0x00000001ffff0000, 0x0000001ffff00021,
  0x00000001ffff0002, 0x0000001ffff00041,
  0x00000001ffff0004, 0x0000001ffff00061,
  0x00000001ffff0006, 0x0000001ffffff001,
  0x00000001ffffff00, 0x0000001ffffff021,
  0x00000001ffffff02, 0x0000001ffffff041,
  0x00000001ffffff04, 0x0000001ffffff061,
  0x00000001ffffff06, 0x0000001ffffffc01,
  0x00000001ffffffc0, 0x0000001fffffffa1,
  0x00000001fffffffa, 0x0000001fffffffc1,
  0x00000001fffffffc, 0x0000001fffffffe1,
  0x0000001fffffffe0, 0x0000000000000001,
  0x0000000000000000, 0x000000000000007e,
  0x0000000000000020, 0x00000000000000fb,
  0x0000000000000040, 0x0000000000000fa1,
  0x0000000000000400, 0x0000000000003d0a,
  0x0000000000000fa0, 0x0000000000003d87,
  0x0000000000000fc0, 0x0000000000003e04,
  0x0000000000000fe0, 0x00000000003e7e8a,
  0x00000000000fffa0, 0x00000000003e7f07,
  0x00000000000fffc0, 0x00000000003e7f84,
  0x00000000000fffe0, 0x00000018ffffffe8,
  0x0000000666666660, 0x00000029aaaaaa82,
  0x0000000aaaaaaaa0, 0x0000003e7ffffe8a,
  0x0000000fffffffa0, 0x0000003e7fffff07,
  0x0000000fffffffc0, 0x0000003e7fffff84,
  0x0000000fffffffe0, 0x0000003e80000001,
  0x0000001000000000, 0x0000003e8000007e,
  0x0000001000000020, 0x0000005355555503,
  0x0000001555555540, 0x00000063ffffff9d,
  0x0000001999999980, 0x0000007cffc18001,
  0x0000001ffff00000, 0x0000007cffc1807e,
  0x0000001ffff00020, 0x0000007cffc180fb,
  0x0000001ffff00040, 0x0000007cffc18178,
  0x0000001ffff00060, 0x0000007cffffc181,
  0x0000001ffffff000, 0x0000007cffffc1fe,
  0x0000001ffffff020, 0x0000007cffffc27b,
  0x0000001ffffff040, 0x0000007cffffc2f8,
  0x0000001ffffff060, 0x0000007cfffff061,
  0x0000001ffffffc00, 0x0000007cfffffe8a,
  0x0000001fffffffa0, 0x0000007cffffff07,
  0x0000001fffffffc0, 0x0000007cffffff84,
  0x0000007cffffff83, 0x0000000000000001,
  0x0000000000000000, 0x000000000000007f,
  0x000000000000007d, 0x00000000000000fd,
  0x00000000000000fa, 0x0000000000000fc1,
  0x0000000000000fa0, 0x0000000000003d87,
  0x0000000000003d09, 0x0000000000003e05,
  0x0000000000003d86, 0x0000000000003e83,
  0x0000000000003e03, 0x00000000003efe87,
  0x00000000003e7e89, 0x00000000003eff05,
  0x00000000003e7f06, 0x00000000003eff83,
  0x00000000003e7f83, 0x000000193333331b,
  0x00000018ffffffe7, 0x00000029ffffffd7,
  0x00000029aaaaaa81, 0x0000003efffffe87,
  0x0000003e7ffffe89, 0x0000003effffff05,
  0x0000003e7fffff06, 0x0000003effffff83,
  0x0000003e7fffff83, 0x0000003f00000001,
  0x0000003e80000000, 0x0000003f0000007f,
  0x0000003e8000007d, 0x00000053ffffffad,
  0x0000005355555502, 0x00000064cccccc69,
  0x00000063ffffff9c, 0x0000007dffc10001,
  0x0000007cffc18000, 0x0000007dffc1007f,
  0x0000007cffc1807d, 0x0000007dffc100fd,
  0x0000007cffc180fa, 0x0000007dffc1017b,
  0x0000007cffc18177, 0x0000007dffffc101,
  0x0000007cffffc180, 0x0000007dffffc17f,
  0x0000007cffffc1fd, 0x0000007dffffc1fd,
  0x0000007cffffc27a, 0x0000007dffffc27b,
  0x0000007cffffc2f7, 0x0000007dfffff041,
  0x0000007cfffff060, 0x0000007dfffffe87,
  0x0000007cfffffe89, 0x0000007dffffff05,
  0x0000007cffffff06, 0x0000007dffffff83,
  0x0000007dffffff82, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000080,
  0x000000000000007e, 0x00000000000000ff,
  0x00000000000000fc, 0x0000000000000fe1,
  0x0000000000000fc0, 0x0000000000003e04,
  0x0000000000003d86, 0x0000000000003e83,
  0x0000000000003e04, 0x0000000000003f02,
  0x0000000000003e82, 0x00000000003f7e84,
  0x00000000003efe86, 0x00000000003f7f03,
  0x00000000003eff04, 0x00000000003f7f82,
  0x00000000003eff82, 0x000000196666664e,
  0x000000193333331a, 0x0000002a5555552c,
  0x00000029ffffffd6, 0x0000003f7ffffe84,
  0x0000003efffffe86, 0x0000003f7fffff03,
  0x0000003effffff04, 0x0000003f7fffff82,
  0x0000003effffff82, 0x0000003f80000001,
  0x0000003f00000000, 0x0000003f80000080,
  0x0000003f0000007e, 0x00000054aaaaaa57,
  0x00000053ffffffac, 0x0000006599999935,
  0x00000064cccccc68, 0x0000007effc08001,
  0x0000007dffc10000, 0x0000007effc08080,
  0x0000007dffc1007e, 0x0000007effc080ff,
  0x0000007dffc100fc, 0x0000007effc0817e,
  0x0000007dffc1017a, 0x0000007effffc081,
  0x0000007dffffc100, 0x0000007effffc100,
  0x0000007dffffc17e, 0x0000007effffc17f,
  0x0000007dffffc1fc, 0x0000007effffc1fe,
  0x0000007dffffc27a, 0x0000007efffff021,
  0x0000007dfffff040, 0x0000007efffffe84,
  0x0000007dfffffe86, 0x0000007effffff03,
  0x0000007dffffff04, 0x0000007effffff82,
  0x0000007effffff81, 0x0000000000000001,
  0x0000000000000000, 0x0000000000007ffe,
  0x000000000000007f, 0x000000000000fffb,
  0x00000000000000fe, 0x00000000000fffa1,
  0x0000000000000fe0, 0x00000000003e7e8a,
  0x0000000000003e03, 0x00000000003efe87,
  0x0000000000003e82, 0x00000000003f7e84,
  0x0000000000003f01, 0x000000003ffd000a,
  0x00000000003f7e83, 0x000000003ffd8007,
  0x00000000003f7f02, 0x000000003ffe0004,
  0x00000000003f7f81, 0x00001998ffffe668,
  0x000000196666664d, 0x00002aa9aaaa8002,
  0x0000002a5555552b, 0x00003ffe7ffe800a,
  0x0000003f7ffffe83, 0x00003ffe7fff0007,
  0x0000003f7fffff02, 0x00003ffe7fff8004,
  0x0000003f7fffff81, 0x00003ffe80000001,
  0x0000003f80000000, 0x00003ffe80007ffe,
  0x0000003f8000007f, 0x0000555355550003,
  0x00000054aaaaaa56, 0x00006663ffff999d,
  0x0000006599999934, 0x00007ffcc0018001,
  0x0000007effc08000, 0x00007ffcc001fffe,
  0x0000007effc0807f, 0x00007ffcc0027ffb,
  0x0000007effc080fe, 0x00007ffcc002fff8,
  0x0000007effc0817d, 0x00007ffcffc00181,
  0x0000007effffc080, 0x00007ffcffc0817e,
  0x0000007effffc0ff, 0x00007ffcffc1017b,
  0x0000007effffc17e, 0x00007ffcffc18178,
  0x0000007effffc1fd, 0x00007ffcfff00061,
  0x0000007efffff020, 0x00007ffcfffe800a,
  0x0000007efffffe83, 0x00007ffcffff0007,
  0x0000007effffff02, 0x00007ffcffff8004,
  0x00007ffcffff8003, 0x0000000000000001,
  0x0000000000000000, 0x0000000000007fff,
  0x0000000000007ffd, 0x000000000000fffd,
  0x000000000000fffa, 0x00000000000fffc1,
  0x00000000000fffa0, 0x00000000003e7f07,
  0x00000000003e7e89, 0x00000000003eff05,
  0x00000000003efe86, 0x00000000003f7f03,
  0x00000000003f7e83, 0x000000003ffd8007,
  0x000000003ffd0009, 0x000000003ffe0005,
  0x000000003ffd8006, 0x000000003ffe8003,
  0x000000003ffe0003, 0x000019993333199b,
  0x00001998ffffe667, 0x00002aa9ffffd557,
  0x00002aa9aaaa8001, 0x00003ffefffe8007,
  0x00003ffe7ffe8009, 0x00003ffeffff0005,
  0x00003ffe7fff0006, 0x00003ffeffff8003,
  0x00003ffe7fff8003, 0x00003fff00000001,
  0x00003ffe80000000, 0x00003fff00007fff,
  0x00003ffe80007ffd, 0x00005553ffffaaad,
  0x0000555355550002, 0x00006664cccc6669,
  0x00006663ffff999c, 0x00007ffdc0010001,
  0x00007ffcc0018000, 0x00007ffdc0017fff,
  0x00007ffcc001fffd, 0x00007ffdc001fffd,
  0x00007ffcc0027ffa, 0x00007ffdc0027ffb,
  0x00007ffcc002fff7, 0x00007ffdffc00101,
  0x00007ffcffc00180, 0x00007ffdffc080ff,
  0x00007ffcffc0817d, 0x00007ffdffc100fd,
  0x00007ffcffc1017a, 0x00007ffdffc180fb,
  0x00007ffcffc18177, 0x00007ffdfff00041,
  0x00007ffcfff00060, 0x00007ffdfffe8007,
  0x00007ffcfffe8009, 0x00007ffdffff0005,
  0x00007ffcffff0006, 0x00007ffdffff8003,
  0x00007ffdffff8002, 0x0000000000000001,
  0x0000000000000000, 0x0000000000008000,
  0x0000000000007ffe, 0x000000000000ffff,
  0x000000000000fffc, 0x00000000000fffe1,
  0x00000000000fffc0, 0x00000000003e7f84,
  0x00000000003e7f06, 0x00000000003eff83,
  0x00000000003eff04, 0x00000000003f7f82,
  0x00000000003f7f02, 0x000000003ffe0004,
  0x000000003ffd8006, 0x000000003ffe8003,
  0x000000003ffe0004, 0x000000003fff0002,
  0x000000003ffe8002, 0x0000199966664cce,
  0x000019993333199a, 0x00002aaa55552aac,
  0x00002aa9ffffd556, 0x00003fff7ffe8004,
  0x00003ffefffe8006, 0x00003fff7fff0003,
  0x00003ffeffff0004, 0x00003fff7fff8002,
  0x00003ffeffff8002, 0x00003fff80000001,
  0x00003fff00000000, 0x00003fff80008000,
  0x00003fff00007ffe, 0x00005554aaaa5557,
  0x00005553ffffaaac, 0x0000666599993335,
  0x00006664cccc6668, 0x00007ffec0008001,
  0x00007ffdc0010000, 0x00007ffec0010000,
  0x00007ffdc0017ffe, 0x00007ffec0017fff,
  0x00007ffdc001fffc, 0x00007ffec001fffe,
  0x00007ffdc0027ffa, 0x00007ffeffc00081,
  0x00007ffdffc00100, 0x00007ffeffc08080,
  0x00007ffdffc080fe, 0x00007ffeffc1007f,
  0x00007ffdffc100fc, 0x00007ffeffc1807e,
  0x00007ffdffc180fa, 0x00007ffefff00021,
  0x00007ffdfff00040, 0x00007ffefffe8004,
  0x00007ffdfffe8006, 0x00007ffeffff0003,
  0x00007ffdffff0004, 0x00007ffeffff8002,
  0x00007ffeffff8001, 0x0000000000000001,
  0x0000000000000000, 0x0000000033333334,
  0x0000000000007fff, 0x0000000066666667,
  0x000000000000fffe, 0x0000000666666661,
  0x00000000000fffe0, 0x00000018ffffffe8,
  0x00000000003e7f83, 0x000000193333331b,
  0x00000000003eff82, 0x000000196666664e,
  0x00000000003f7f81, 0x00001998ffffe668,
  0x000000003ffe0003, 0x000019993333199b,
  0x000000003ffe8002, 0x0000199966664cce,
  0x000000003fff0001, 0x0a3d70a3c28f5c2a,
  0x0000199966664ccd, 0x11111110eeeeeef0,
  0x00002aaa55552aab, 0x19999998e6666668,
  0x00003fff7ffe8003, 0x199999991999999b,
  0x00003fff7fff0002, 0x199999994cccccce,
  0x00003fff7fff8001, 0x1999999980000001,
  0x00003fff80000000, 0x19999999b3333334,
  0x00003fff80007fff, 0x22222221dddddddf,
  0x00005554aaaa5556, 0x28f5c28f0a3d70a5,
  0x0000666599993334, 0x3333199966668001,
  0x00007ffec0008000, 0x333319999999b334,
  0x00007ffec000ffff, 0x33331999cccce667,
  0x00007ffec0017ffe, 0x3333199a0000199a,
  0x00007ffec001fffd, 0x3333331966666681,
  0x00007ffeffc00080, 0x33333319999999b4,
  0x00007ffeffc0807f, 0x33333319cccccce7,
  0x00007ffeffc1007e, 0x3333331a0000001a,
  0x00007ffeffc1807d, 0x3333332c999999a1,
  0x00007ffefff00020, 0x3333333266666668,
  0x00007ffefffe8003, 0x333333329999999b,
  0x00007ffeffff0002, 0x33333332ccccccce,
  0x33333332cccccccd, 0x0000000000000001,
  0x0000000000000000, 0x0000000055555556,
  0x0000000033333333, 0x00000000aaaaaaab,
  0x0000000066666666, 0x0000000aaaaaaaa1,
  0x0000000666666660, 0x00000029aaaaaa82,
  0x00000018ffffffe7, 0x00000029ffffffd7,
  0x000000193333331a, 0x0000002a5555552c,
  0x000000196666664d, 0x00002aa9aaaa8002,
  0x00001998ffffe667, 0x00002aa9ffffd557,
  0x000019993333199a, 0x00002aaa55552aac,
  0x0000199966664ccd, 0x11111110eeeeeef0,
  0x0a3d70a3c28f5c29, 0x1c71c71c38e38e3a,
  0x11111110eeeeeeef, 0x2aaaaaa980000002,
  0x19999998e6666667, 0x2aaaaaa9d5555557,
  0x199999991999999a, 0x2aaaaaaa2aaaaaac,
  0x199999994ccccccd, 0x2aaaaaaa80000001,
  0x1999999980000000, 0x2aaaaaaad5555556,
  0x19999999b3333333, 0x38e38e3871c71c73,
  0x22222221ddddddde, 0x44444443bbbbbbbd,
  0x28f5c28f0a3d70a4, 0x55552aaa55558001,
  0x3333199966668000, 0x55552aaaaaaad556,
  0x333319999999b333, 0x55552aab00002aab,
  0x33331999cccce666, 0x55552aab55558000,
  0x3333199a00001999, 0x5555552a55555581,
  0x3333331966666680, 0x5555552aaaaaaad6,
  0x33333319999999b3, 0x5555552b0000002b,
  0x33333319cccccce6, 0x5555552b55555580,
  0x3333331a00000019, 0x5555554a55555561,
  0x3333332c999999a0, 0x5555555400000002,
  0x3333333266666667, 0x5555555455555557,
  0x333333329999999a, 0x55555554aaaaaaac,
  0x55555554aaaaaaab, 0x0000000000000001,
  0x0000000000000000, 0x000000007ffffffe,
  0x0000000055555555, 0x00000000fffffffb,
  0x00000000aaaaaaaa, 0x0000000fffffffa1,
  0x0000000aaaaaaaa0, 0x0000003e7ffffe8a,
  0x00000029aaaaaa81, 0x0000003efffffe87,
  0x00000029ffffffd6, 0x0000003f7ffffe84,
  0x0000002a5555552b, 0x00003ffe7ffe800a,
  0x00002aa9aaaa8001, 0x00003ffefffe8007,
  0x00002aa9ffffd556, 0x00003fff7ffe8004,
  0x00002aaa55552aab, 0x19999998e6666668,
  0x11111110eeeeeeef, 0x2aaaaaa980000002,
  0x1c71c71c38e38e39, 0x3ffffffd0000000a,
  0x2aaaaaa980000001, 0x3ffffffd80000007,
  0x2aaaaaa9d5555556, 0x3ffffffe00000004,
  0x2aaaaaaa2aaaaaab, 0x3ffffffe80000001,
  0x2aaaaaaa80000000, 0x3ffffffefffffffe,
  0x2aaaaaaad5555555, 0x5555555300000003,
  0x38e38e3871c71c72, 0x666666639999999d,
  0x44444443bbbbbbbc, 0x7fffbffd00018001,
  0x55552aaa55558000, 0x7fffbffd80017ffe,
  0x55552aaaaaaad555, 0x7fffbffe00017ffb,
  0x55552aab00002aaa, 0x7fffbffe80017ff8,
  0x55552aab55557fff, 0x7fffffbd00000181,
  0x5555552a55555580, 0x7fffffbd8000017e,
  0x5555552aaaaaaad5, 0x7fffffbe0000017b,
  0x5555552b0000002a, 0x7fffffbe80000178,
  0x5555552b5555557f, 0x7fffffed00000061,
  0x5555554a55555560, 0x7ffffffb8000000a,
  0x5555555400000001, 0x7ffffffc00000007,
  0x5555555455555556, 0x7ffffffc80000004,
  0x7ffffffc80000003, 0x0000000000000001,
  0x0000000000000000, 0x000000007fffffff,
  0x000000007ffffffd, 0x00000000fffffffd,
  0x00000000fffffffa, 0x0000000fffffffc1,
  0x0000000fffffffa0, 0x0000003e7fffff07,
  0x0000003e7ffffe89, 0x0000003effffff05,
  0x0000003efffffe86, 0x0000003f7fffff03,
  0x0000003f7ffffe83, 0x00003ffe7fff0007,
  0x00003ffe7ffe8009, 0x00003ffeffff0005,
  0x00003ffefffe8006, 0x00003fff7fff0003,
  0x00003fff7ffe8003, 0x199999991999999b,
  0x19999998e6666667, 0x2aaaaaa9d5555557,
  0x2aaaaaa980000001, 0x3ffffffd80000007,
  0x3ffffffd00000009, 0x3ffffffe00000005,
  0x3ffffffd80000006, 0x3ffffffe80000003,
  0x3ffffffe00000003, 0x3fffffff00000001,
  0x3ffffffe80000000, 0x3fffffff7fffffff,
  0x3ffffffefffffffd, 0x55555553aaaaaaad,
  0x5555555300000002, 0x6666666466666669,
  0x666666639999999c, 0x7fffbffe00010001,
  0x7fffbffd00018000, 0x7fffbffe8000ffff,
  0x7fffbffd80017ffd, 0x7fffbfff0000fffd,
  0x7fffbffe00017ffa, 0x7fffbfff8000fffb,
  0x7fffbffe80017ff7, 0x7fffffbe00000101,
  0x7fffffbd00000180, 0x7fffffbe800000ff,
  0x7fffffbd8000017d, 0x7fffffbf000000fd,
  0x7fffffbe0000017a, 0x7fffffbf800000fb,
  0x7fffffbe80000177, 0x7fffffee00000041,
  0x7fffffed00000060, 0x7ffffffc80000007,
  0x7ffffffb80000009, 0x7ffffffd00000005,
  0x7ffffffc00000006, 0x7ffffffd80000003,
  0x7ffffffd80000002, 0x0000000000000001,
  0x0000000000000000, 0x0000000080000000,
  0x000000007ffffffe, 0x00000000ffffffff,
  0x00000000fffffffc, 0x0000000fffffffe1,
  0x0000000fffffffc0, 0x0000003e7fffff84,
  0x0000003e7fffff06, 0x0000003effffff83,
  0x0000003effffff04, 0x0000003f7fffff82,
  0x0000003f7fffff02, 0x00003ffe7fff8004,
  0x00003ffe7fff0006, 0x00003ffeffff8003,
  0x00003ffeffff0004, 0x00003fff7fff8002,
  0x00003fff7fff0002, 0x199999994cccccce,
  0x199999991999999a, 0x2aaaaaaa2aaaaaac,
  0x2aaaaaa9d5555556, 0x3ffffffe00000004,
  0x3ffffffd80000006, 0x3ffffffe80000003,
  0x3ffffffe00000004, 0x3fffffff00000002,
  0x3ffffffe80000002, 0x3fffffff80000001,
  0x3fffffff00000000, 0x4000000000000000,
  0x3fffffff7ffffffe, 0x5555555455555557,
  0x55555553aaaaaaac, 0x6666666533333335,
  0x6666666466666668, 0x7fffbfff00008001,
  0x7fffbffe00010000, 0x7fffbfff80008000,
  0x7fffbffe8000fffe, 0x7fffc00000007fff,
  0x7fffbfff0000fffc, 0x7fffc00080007ffe,
  0x7fffbfff8000fffa, 0x7fffffbf00000081,
  0x7fffffbe00000100, 0x7fffffbf80000080,
  0x7fffffbe800000fe, 0x7fffffc00000007f,
  0x7fffffbf000000fc, 0x7fffffc08000007e,
  0x7fffffbf800000fa, 0x7fffffef00000021,
  0x7fffffee00000040, 0x7ffffffd80000004,
  0x7ffffffc80000006, 0x7ffffffe00000003,
  0x7ffffffd00000004, 0x7ffffffe80000002,
  0x7ffffffe80000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000080000001,
  0x000000007fffffff, 0x0000000100000001,
  0x00000000fffffffe, 0x0000001000000001,
  0x0000000fffffffe0, 0x0000003e80000001,
  0x0000003e7fffff83, 0x0000003f00000001,
  0x0000003effffff82, 0x0000003f80000001,
  0x0000003f7fffff81, 0x00003ffe80000001,
  0x00003ffe7fff8003, 0x00003fff00000001,
  0x00003ffeffff8002, 0x00003fff80000001,
  0x00003fff7fff8001, 0x1999999980000001,
  0x199999994ccccccd, 0x2aaaaaaa80000001,
  0x2aaaaaaa2aaaaaab, 0x3ffffffe80000001,
  0x3ffffffe00000003, 0x3fffffff00000001,
  0x3ffffffe80000002, 0x3fffffff80000001,
  0x3fffffff00000001, 0x4000000000000001,
  0x3fffffff80000000, 0x4000000080000001,
  0x3fffffffffffffff, 0x5555555500000001,
  0x5555555455555556, 0x6666666600000001,
  0x6666666533333334, 0x7fffc00000000001,
  0x7fffbfff00008000, 0x7fffc00080000001,
  0x7fffbfff80007fff, 0x7fffc00100000001,
  0x7fffc00000007ffe, 0x7fffc00180000001,
  0x7fffc00080007ffd, 0x7fffffc000000001,
  0x7fffffbf00000080, 0x7fffffc080000001,
  0x7fffffbf8000007f, 0x7fffffc100000001,
  0x7fffffc00000007e, 0x7fffffc180000001,
  0x7fffffc08000007d, 0x7ffffff000000001,
  0x7fffffef00000020, 0x7ffffffe80000001,
  0x7ffffffd80000003, 0x7fffffff00000001,
  0x7ffffffe00000002, 0x7fffffff80000001,
  0x7fffffff80000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000080000002,
  0x0000000080000000, 0x0000000100000003,
  0x0000000100000000, 0x0000001000000021,
  0x0000001000000000, 0x0000003e8000007e,
  0x0000003e80000000, 0x0000003f0000007f,
  0x0000003f00000000, 0x0000003f80000080,
  0x0000003f80000000, 0x00003ffe80007ffe,
  0x00003ffe80000000, 0x00003fff00007fff,
  0x00003fff00000000, 0x00003fff80008000,
  0x00003fff80000000, 0x19999999b3333334,
  0x1999999980000000, 0x2aaaaaaad5555556,
  0x2aaaaaaa80000000, 0x3ffffffefffffffe,
  0x3ffffffe80000000, 0x3fffffff7fffffff,
  0x3fffffff00000000, 0x4000000000000000,
  0x3fffffff80000000, 0x4000000080000001,
  0x4000000000000000, 0x4000000100000002,
  0x4000000080000000, 0x55555555aaaaaaab,
  0x5555555500000000, 0x66666666cccccccd,
  0x6666666600000000, 0x7fffc000ffff8001,
  0x7fffc00000000000, 0x7fffc0017fff8002,
  0x7fffc00080000000, 0x7fffc001ffff8003,
  0x7fffc00100000000, 0x7fffc0027fff8004,
  0x7fffc00180000000, 0x7fffffc0ffffff81,
  0x7fffffc000000000, 0x7fffffc17fffff82,
  0x7fffffc080000000, 0x7fffffc1ffffff83,
  0x7fffffc100000000, 0x7fffffc27fffff84,
  0x7fffffc180000000, 0x7ffffff0ffffffe1,
  0x7ffffff000000000, 0x7fffffff7ffffffe,
  0x7ffffffe80000000, 0x7fffffffffffffff,
  0x7fffffff00000000, 0x8000000080000000,
  0x800000007fffffff, 0x0000000000000001,
  0x0000000000000000, 0x00000000aaaaaaab,
  0x0000000080000001, 0x0000000155555555,
  0x0000000100000002, 0x0000001555555541,
  0x0000001000000020, 0x0000005355555503,
  0x0000003e8000007d, 0x00000053ffffffad,
  0x0000003f0000007e, 0x00000054aaaaaa57,
  0x0000003f8000007f, 0x0000555355550003,
  0x00003ffe80007ffd, 0x00005553ffffaaad,
  0x00003fff00007ffe, 0x00005554aaaa5557,
  0x00003fff80007fff, 0x22222221dddddddf,
  0x19999999b3333333, 0x38e38e3871c71c73,
  0x2aaaaaaad5555555, 0x5555555300000003,
  0x3ffffffefffffffd, 0x55555553aaaaaaad,
  0x3fffffff7ffffffe, 0x5555555455555557,
  0x3fffffffffffffff, 0x5555555500000001,
  0x4000000080000000, 0x55555555aaaaaaab,
  0x4000000100000001, 0x71c71c70e38e38e5,
  0x55555555aaaaaaaa, 0x8888888777777779,
  0x66666666cccccccc, 0xaaaa5554aaab0001,
  0x7fffc000ffff8000, 0xaaaa55555555aaab,
  0x7fffc0017fff8001, 0xaaaa555600005555,
  0x7fffc001ffff8002, 0xaaaa5556aaaaffff,
  0x7fffc0027fff8003, 0xaaaaaa54aaaaab01,
  0x7fffffc0ffffff80, 0xaaaaaa55555555ab,
  0x7fffffc17fffff81, 0xaaaaaa5600000055,
  0x7fffffc1ffffff82, 0xaaaaaa56aaaaaaff,
  0x7fffffc27fffff83, 0xaaaaaa94aaaaaac1,
  0x7ffffff0ffffffe0, 0xaaaaaaa800000003,
  0x7fffffff7ffffffd, 0xaaaaaaa8aaaaaaad,
  0x7ffffffffffffffe, 0xaaaaaaa955555557,
  0xaaaaaaa955555556, 0x0000000000000001,
  0x0000000000000000, 0x00000000cccccccd,
  0x00000000aaaaaaaa, 0x0000000199999999,
  0x0000000155555554, 0x0000001999999981,
  0x0000001555555540, 0x00000063ffffff9d,
  0x0000005355555502, 0x00000064cccccc69,
  0x00000053ffffffac, 0x0000006599999935,
  0x00000054aaaaaa56, 0x00006663ffff999d,
  0x0000555355550002, 0x00006664cccc6669,
  0x00005553ffffaaac, 0x0000666599993335,
  0x00005554aaaa5556, 0x28f5c28f0a3d70a5,
  0x22222221ddddddde, 0x44444443bbbbbbbd,
  0x38e38e3871c71c72, 0x666666639999999d,
  0x5555555300000002, 0x6666666466666669,
  0x55555553aaaaaaac, 0x6666666533333335,
  0x5555555455555556, 0x6666666600000001,
  0x5555555500000000, 0x66666666cccccccd,
  0x55555555aaaaaaaa, 0x8888888777777779,
  0x71c71c70e38e38e4, 0xa3d70a3c28f5c291,
  0x8888888777777778, 0xcccc6665999a0001,
  0xaaaa5554aaab0000, 0xcccc66666666cccd,
  0xaaaa55555555aaaa, 0xcccc666733339999,
  0xaaaa555600005554, 0xcccc666800006665,
  0xaaaa5556aaaafffe, 0xcccccc6599999a01,
  0xaaaaaa54aaaaab00, 0xcccccc66666666cd,
  0xaaaaaa55555555aa, 0xcccccc6733333399,
  0xaaaaaa5600000054, 0xcccccc6800000065,
  0xaaaaaa56aaaaaafe, 0xccccccb266666681,
  0xaaaaaa94aaaaaac0, 0xccccccc99999999d,
  0xaaaaaaa800000002, 0xccccccca66666669,
  0xaaaaaaa8aaaaaaac, 0xcccccccb33333335,
  0xcccccccb33333334, 0x0000000000000001,
  0x0000000000000000, 0x00000000ffff8001,
  0x00000000cccccccc, 0x00000001ffff0001,
  0x0000000199999998, 0x0000001ffff00001,
  0x0000001999999980, 0x0000007cffc18001,
  0x00000063ffffff9c, 0x0000007dffc10001,
  0x00000064cccccc68, 0x0000007effc08001,
  0x0000006599999934, 0x00007ffcc0018001,
  0x00006663ffff999c, 0x00007ffdc0010001,
  0x00006664cccc6668, 0x00007ffec0008001,
  0x0000666599993334, 0x3333199966668001,
  0x28f5c28f0a3d70a4, 0x55552aaa55558001,
  0x44444443bbbbbbbc, 0x7fffbffd00018001,
  0x666666639999999c, 0x7fffbffe00010001,
  0x6666666466666668, 0x7fffbfff00008001,
  0x6666666533333334, 0x7fffc00000000001,
  0x6666666600000000, 0x7fffc000ffff8001,
  0x66666666cccccccc, 0xaaaa5554aaab0001,
  0x8888888777777778, 0xcccc6665999a0001,
  0xa3d70a3c28f5c290, 0xffff000040000001,
  0xcccc6665999a0000, 0xffff00013fff8001,
  0xcccc66666666cccc, 0xffff00023fff0001,
  0xcccc666733339998, 0xffff00033ffe8001,
  0xcccc666800006664, 0xffff7f8000400001,
  0xcccccc6599999a00, 0xffff7f81003f8001,
  0xcccccc66666666cc, 0xffff7f82003f0001,
  0xcccccc6733333398, 0xffff7f83003e8001,
  0xcccccc6800000064, 0xffff7fe000100001,
  0xccccccb266666680, 0xffff7ffd00018001,
  0xccccccc99999999c, 0xffff7ffe00010001,
  0xccccccca66666668, 0xffff7fff00008001,
  0xffff7fff00008000, 0x0000000000000001,
  0x0000000000000000, 0x00000000ffff8002,
  0x00000000ffff8000, 0x00000001ffff0003,
  0x00000001ffff0000, 0x0000001ffff00021,
  0x0000001ffff00000, 0x0000007cffc1807e,
  0x0000007cffc18000, 0x0000007dffc1007f,
  0x0000007dffc10000, 0x0000007effc08080,
  0x0000007effc08000, 0x00007ffcc001fffe,
  0x00007ffcc0018000, 0x00007ffdc0017fff,
  0x00007ffdc0010000, 0x00007ffec0010000,
  0x00007ffec0008000, 0x333319999999b334,
  0x3333199966668000, 0x55552aaaaaaad556,
  0x55552aaa55558000, 0x7fffbffd80017ffe,
  0x7fffbffd00018000, 0x7fffbffe8000ffff,
  0x7fffbffe00010000, 0x7fffbfff80008000,
  0x7fffbfff00008000, 0x7fffc00080000001,
  0x7fffc00000000000, 0x7fffc0017fff8002,
  0x7fffc000ffff8000, 0xaaaa55555555aaab,
  0xaaaa5554aaab0000, 0xcccc66666666cccd,
  0xcccc6665999a0000, 0xffff00013fff8001,
  0xffff000040000000, 0xffff00023fff0002,
  0xffff00013fff8000, 0xffff00033ffe8003,
  0xffff00023fff0000, 0xffff00043ffe0004,
  0xffff00033ffe8000, 0xffff7f81003fff81,
  0xffff7f8000400000, 0xffff7f82003f7f82,
  0xffff7f81003f8000, 0xffff7f83003eff83,
  0xffff7f82003f0000, 0xffff7f84003e7f84,
  0xffff7f83003e8000, 0xffff7fe1000fffe1,
  0xffff7fe000100000, 0xffff7ffe00017ffe,
  0xffff7ffd00018000, 0xffff7fff0000ffff,
  0xffff7ffe00010000, 0xffff800000008000,
  0xffff800000007fff, 0x0000000000000001,
  0x0000000000000000, 0x00000000ffff8003,
  0x00000000ffff8001, 0x00000001ffff0005,
  0x00000001ffff0002, 0x0000001ffff00041,
  0x0000001ffff00020, 0x0000007cffc180fb,
  0x0000007cffc1807d, 0x0000007dffc100fd,
  0x0000007dffc1007e, 0x0000007effc080ff,
  0x0000007effc0807f, 0x00007ffcc0027ffb,
  0x00007ffcc001fffd, 0x00007ffdc001fffd,
  0x00007ffdc0017ffe, 0x00007ffec0017fff,
  0x00007ffec000ffff, 0x33331999cccce667,
  0x333319999999b333, 0x55552aab00002aab,
  0x55552aaaaaaad555, 0x7fffbffe00017ffb,
  0x7fffbffd80017ffd, 0x7fffbfff0000fffd,
  0x7fffbffe8000fffe, 0x7fffc00000007fff,
  0x7fffbfff80007fff, 0x7fffc00100000001,
  0x7fffc00080000000, 0x7fffc001ffff8003,
  0x7fffc0017fff8001, 0xaaaa555600005555,
  0xaaaa55555555aaaa, 0xcccc666733339999,
  0xcccc66666666cccc, 0xffff00023fff0001,
  0xffff00013fff8000, 0xffff00033ffe8003,
  0xffff00023fff0001, 0xffff00043ffe0005,
  0xffff00033ffe8002, 0xffff00053ffd8007,
  0xffff00043ffe0003, 0xffff7f82003fff01,
  0xffff7f81003fff80, 0xffff7f83003f7f03,
  0xffff7f82003f7f81, 0xffff7f84003eff05,
  0xffff7f83003eff82, 0xffff7f85003e7f07,
  0xffff7f84003e7f83, 0xffff7fe2000fffc1,
  0xffff7fe1000fffe0, 0xffff7fff00017ffb,
  0xffff7ffe00017ffd, 0xffff80000000fffd,
  0xffff7fff0000fffe, 0xffff800100007fff,
  0xffff800100007ffe, 0x0000000000000001,
  0x0000000000000000, 0x00000000ffff8004,
  0x00000000ffff8002, 0x00000001ffff0007,
  0x00000001ffff0004, 0x0000001ffff00061,
  0x0000001ffff00040, 0x0000007cffc18178,
  0x0000007cffc180fa, 0x0000007dffc1017b,
  0x0000007dffc100fc, 0x0000007effc0817e,
  0x0000007effc080fe, 0x00007ffcc002fff8,
  0x00007ffcc0027ffa, 0x00007ffdc0027ffb,
  0x00007ffdc001fffc, 0x00007ffec001fffe,
  0x00007ffec0017ffe, 0x3333199a0000199a,
  0x33331999cccce666, 0x55552aab55558000,
  0x55552aab00002aaa, 0x7fffbffe80017ff8,
  0x7fffbffe00017ffa, 0x7fffbfff8000fffb,
  0x7fffbfff0000fffc, 0x7fffc00080007ffe,
  0x7fffc00000007ffe, 0x7fffc00180000001,
  0x7fffc00100000000, 0x7fffc0027fff8004,
  0x7fffc001ffff8002, 0xaaaa5556aaaaffff,
  0xaaaa555600005554, 0xcccc666800006665,
  0xcccc666733339998, 0xffff00033ffe8001,
  0xffff00023fff0000, 0xffff00043ffe0004,
  0xffff00033ffe8002, 0xffff00053ffd8007,
  0xffff00043ffe0004, 0xffff00063ffd000a,
  0xffff00053ffd8006, 0xffff7f83003ffe81,
  0xffff7f82003fff00, 0xffff7f84003f7e84,
  0xffff7f83003f7f02, 0xffff7f85003efe87,
  0xffff7f84003eff04, 0xffff7f86003e7e8a,
  0xffff7f85003e7f06, 0xffff7fe3000fffa1,
  0xffff7fe2000fffc0, 0xffff800000017ff8,
  0xffff7fff00017ffa, 0xffff80010000fffb,
  0xffff80000000fffc, 0xffff800200007ffe,
  0xffff800200007ffd, 0x0000000000000001,
  0x0000000000000000, 0x00000000ffffff81,
  0x00000000ffff8003, 0x00000001ffffff01,
  0x00000001ffff0006, 0x0000001ffffff001,
  0x0000001ffff00060, 0x0000007cffffc181,
  0x0000007cffc18177, 0x0000007dffffc101,
  0x0000007dffc1017a, 0x0000007effffc081,
  0x0000007effc0817d, 0x00007ffcffc00181,
  0x00007ffcc002fff7, 0x00007ffdffc00101,
  0x00007ffdc0027ffa, 0x00007ffeffc00081,
  0x00007ffec001fffd, 0x3333331966666681,
  0x3333199a00001999, 0x5555552a55555581,
  0x55552aab55557fff, 0x7fffffbd00000181,
  0x7fffbffe80017ff7, 0x7fffffbe00000101,
  0x7fffbfff8000fffa, 0x7fffffbf00000081,
  0x7fffc00080007ffd, 0x7fffffc000000001,
  0x7fffc00180000000, 0x7fffffc0ffffff81,
  0x7fffc0027fff8003, 0xaaaaaa54aaaaab01,
  0xaaaa5556aaaafffe, 0xcccccc6599999a01,
  0xcccc666800006664, 0xffff7f8000400001,
  0xffff00033ffe8000, 0xffff7f81003fff81,
  0xffff00043ffe0003, 0xffff7f82003fff01,
  0xffff00053ffd8006, 0xffff7f83003ffe81,
  0xffff00063ffd0009, 0xffffff0000004001,
  0xffff7f83003ffe80, 0xffffff0100003f81,
  0xffff7f84003f7e83, 0xffffff0200003f01,
  0xffff7f85003efe86, 0xffffff0300003e81,
  0xffff7f86003e7e89, 0xffffff6000001001,
  0xffff7fe3000fffa0, 0xffffff7d00000181,
  0xffff800000017ff7, 0xffffff7e00000101,
  0xffff80010000fffa, 0xffffff7f00000081,
  0xffffff7f00000080, 0x0000000000000001,
  0x0000000000000000, 0x00000000ffffff82,
  0x00000000ffffff80, 0x00000001ffffff03,
  0x00000001ffffff00, 0x0000001ffffff021,
  0x0000001ffffff000, 0x0000007cffffc1fe,
  0x0000007cffffc180, 0x0000007dffffc17f,
  0x0000007dffffc100, 0x0000007effffc100,
  0x0000007effffc080, 0x00007ffcffc0817e,
  0x00007ffcffc00180, 0x00007ffdffc080ff,
  0x00007ffdffc00100, 0x00007ffeffc08080,
  0x00007ffeffc00080, 0x33333319999999b4,
  0x3333331966666680, 0x5555552aaaaaaad6,
  0x5555552a55555580, 0x7fffffbd8000017e,
  0x7fffffbd00000180, 0x7fffffbe800000ff,
  0x7fffffbe00000100, 0x7fffffbf80000080,
  0x7fffffbf00000080, 0x7fffffc080000001,
  0x7fffffc000000000, 0x7fffffc17fffff82,
  0x7fffffc0ffffff80, 0xaaaaaa55555555ab,
  0xaaaaaa54aaaaab00, 0xcccccc66666666cd,
  0xcccccc6599999a00, 0xffff7f81003f8001,
  0xffff7f8000400000, 0xffff7f82003f7f82,
  0xffff7f81003fff80, 0xffff7f83003f7f03,
  0xffff7f82003fff00, 0xffff7f84003f7e84,
  0xffff7f83003ffe80, 0xffffff0100003f81,
  0xffffff0000004000, 0xffffff0200003f02,
  0xffffff0100003f80, 0xffffff0300003e83,
  0xffffff0200003f00, 0xffffff0400003e04,
  0xffffff0300003e80, 0xffffff6100000fe1,
  0xffffff6000001000, 0xffffff7e0000017e,
  0xffffff7d00000180, 0xffffff7f000000ff,
  0xffffff7e00000100, 0xffffff8000000080,
  0xffffff800000007f, 0x0000000000000001,
  0x0000000000000000, 0x00000000ffffff83,
  0x00000000ffffff81, 0x00000001ffffff05,
  0x00000001ffffff02, 0x0000001ffffff041,
  0x0000001ffffff020, 0x0000007cffffc27b,
  0x0000007cffffc1fd, 0x0000007dffffc1fd,
  0x0000007dffffc17e, 0x0000007effffc17f,
  0x0000007effffc0ff, 0x00007ffcffc1017b,
  0x00007ffcffc0817d, 0x00007ffdffc100fd,
  0x00007ffdffc080fe, 0x00007ffeffc1007f,
  0x00007ffeffc0807f, 0x33333319cccccce7,
  0x33333319999999b3, 0x5555552b0000002b,
  0x5555552aaaaaaad5, 0x7fffffbe0000017b,
  0x7fffffbd8000017d, 0x7fffffbf000000fd,
  0x7fffffbe800000fe, 0x7fffffc00000007f,
  0x7fffffbf8000007f, 0x7fffffc100000001,
  0x7fffffc080000000, 0x7fffffc1ffffff83,
  0x7fffffc17fffff81, 0xaaaaaa5600000055,
  0xaaaaaa55555555aa, 0xcccccc6733333399,
  0xcccccc66666666cc, 0xffff7f82003f0001,
  0xffff7f81003f8000, 0xffff7f83003eff83,
  0xffff7f82003f7f81, 0xffff7f84003eff05,
  0xffff7f83003f7f02, 0xffff7f85003efe87,
  0xffff7f84003f7e83, 0xffffff0200003f01,
  0xffffff0100003f80, 0xffffff0300003e83,
  0xffffff0200003f01, 0xffffff0400003e05,
  0xffffff0300003e82, 0xffffff0500003d87,
  0xffffff0400003e03, 0xffffff6200000fc1,
  0xffffff6100000fe0, 0xffffff7f0000017b,
  0xffffff7e0000017d, 0xffffff80000000fd,
  0xffffff7f000000fe, 0xffffff810000007f,
  0xffffff810000007e, 0x0000000000000001,
  0x0000000000000000, 0x00000000ffffff84,
  0x00000000ffffff82, 0x00000001ffffff07,
  0x00000001ffffff04, 0x0000001ffffff061,
  0x0000001ffffff040, 0x0000007cffffc2f8,
  0x0000007cffffc27a, 0x0000007dffffc27b,
  0x0000007dffffc1fc, 0x0000007effffc1fe,
  0x0000007effffc17e, 0x00007ffcffc18178,
  0x00007ffcffc1017a, 0x00007ffdffc180fb,
  0x00007ffdffc100fc, 0x00007ffeffc1807e,
  0x00007ffeffc1007e, 0x3333331a0000001a,
  0x33333319cccccce6, 0x5555552b55555580,
  0x5555552b0000002a, 0x7fffffbe80000178,
  0x7fffffbe0000017a, 0x7fffffbf800000fb,
  0x7fffffbf000000fc, 0x7fffffc08000007e,
  0x7fffffc00000007e, 0x7fffffc180000001,
  0x7fffffc100000000, 0x7fffffc27fffff84,
  0x7fffffc1ffffff82, 0xaaaaaa56aaaaaaff,
  0xaaaaaa5600000054, 0xcccccc6800000065,
  0xcccccc6733333398, 0xffff7f83003e8001,
  0xffff7f82003f0000, 0xffff7f84003e7f84,
  0xffff7f83003eff82, 0xffff7f85003e7f07,
  0xffff7f84003eff04, 0xffff7f86003e7e8a,
  0xffff7f85003efe86, 0xffffff0300003e81,
  0xffffff0200003f00, 0xffffff0400003e04,
  0xffffff0300003e82, 0xffffff0500003d87,
  0xffffff0400003e04, 0xffffff0600003d0a,
  0xffffff0500003d86, 0xffffff6300000fa1,
  0xffffff6200000fc0, 0xffffff8000000178,
  0xffffff7f0000017a, 0xffffff81000000fb,
  0xffffff80000000fc, 0xffffff820000007e,
  0xffffff820000007d, 0x0000000000000001,
  0x0000000000000000, 0x00000000ffffffe1,
  0x00000000ffffff83, 0x00000001ffffffc1,
  0x00000001ffffff06, 0x0000001ffffffc01,
  0x0000001ffffff060, 0x0000007cfffff061,
  0x0000007cffffc2f7, 0x0000007dfffff041,
  0x0000007dffffc27a, 0x0000007efffff021,
  0x0000007effffc1fd, 0x00007ffcfff00061,
  0x00007ffcffc18177, 0x00007ffdfff00041,
  0x00007ffdffc180fa, 0x00007ffefff00021,
  0x00007ffeffc1807d, 0x3333332c999999a1,
  0x3333331a00000019, 0x5555554a55555561,
  0x5555552b5555557f, 0x7fffffed00000061,
  0x7fffffbe80000177, 0x7fffffee00000041,
  0x7fffffbf800000fa, 0x7fffffef00000021,
  0x7fffffc08000007d, 0x7ffffff000000001,
  0x7fffffc180000000, 0x7ffffff0ffffffe1,
  0x7fffffc27fffff83, 0xaaaaaa94aaaaaac1,
  0xaaaaaa56aaaaaafe, 0xccccccb266666681,
  0xcccccc6800000064, 0xffff7fe000100001,
  0xffff7f83003e8000, 0xffff7fe1000fffe1,
  0xffff7f84003e7f83, 0xffff7fe2000fffc1,
  0xffff7f85003e7f06, 0xffff7fe3000fffa1,
  0xffff7f86003e7e89, 0xffffff6000001001,
  0xffffff0300003e80, 0xffffff6100000fe1,
  0xffffff0400003e03, 0xffffff6200000fc1,
  0xffffff0500003d86, 0xffffff6300000fa1,
  0xffffff0600003d09, 0xffffffc000000401,
  0xffffff6300000fa0, 0xffffffdd00000061,
  0xffffff8000000177, 0xffffffde00000041,
  0xffffff81000000fa, 0xffffffdf00000021,
  0xffffffdf00000020, 0x0000000000000001,
  0x0000000000000000, 0x00000000fffffffe,
  0x00000000ffffffe0, 0x00000001fffffffb,
  0x00000001ffffffc0, 0x0000001fffffffa1,
  0x0000001ffffffc00, 0x0000007cfffffe8a,
  0x0000007cfffff060, 0x0000007dfffffe87,
  0x0000007dfffff040, 0x0000007efffffe84,
  0x0000007efffff020, 0x00007ffcfffe800a,
  0x00007ffcfff00060, 0x00007ffdfffe8007,
  0x00007ffdfff00040, 0x00007ffefffe8004,
  0x00007ffefff00020, 0x3333333266666668,
  0x3333332c999999a0, 0x5555555400000002,
  0x5555554a55555560, 0x7ffffffb8000000a,
  0x7fffffed00000060, 0x7ffffffc80000007,
  0x7fffffee00000040, 0x7ffffffd80000004,
  0x7fffffef00000020, 0x7ffffffe80000001,
  0x7ffffff000000000, 0x7fffffff7ffffffe,
  0x7ffffff0ffffffe0, 0xaaaaaaa800000003,
  0xaaaaaa94aaaaaac0, 0xccccccc99999999d,
  0xccccccb266666680, 0xffff7ffd00018001,
  0xffff7fe000100000, 0xffff7ffe00017ffe,
  0xffff7fe1000fffe0, 0xffff7fff00017ffb,
  0xffff7fe2000fffc0, 0xffff800000017ff8,
  0xffff7fe3000fffa0, 0xffffff7d00000181,
  0xffffff6000001000, 0xffffff7e0000017e,
  0xffffff6100000fe0, 0xffffff7f0000017b,
  0xffffff6200000fc0, 0xffffff8000000178,
  0xffffff6300000fa0, 0xffffffdd00000061,
  0xffffffc000000400, 0xfffffffa0000000a,
  0xffffffdd00000060, 0xfffffffb00000007,
  0xffffffde00000040, 0xfffffffc00000004,
  0xfffffffc00000003, 0x0000000000000001,
  0x0000000000000000, 0x00000000ffffffff,
  0x00000000fffffffd, 0x00000001fffffffd,
  0x00000001fffffffa, 0x0000001fffffffc1,
  0x0000001fffffffa0, 0x0000007cffffff07,
  0x0000007cfffffe89, 0x0000007dffffff05,
  0x0000007dfffffe86, 0x0000007effffff03,
  0x0000007efffffe83, 0x00007ffcffff0007,
  0x00007ffcfffe8009, 0x00007ffdffff0005,
  0x00007ffdfffe8006, 0x00007ffeffff0003,
  0x00007ffefffe8003, 0x333333329999999b,
  0x3333333266666667, 0x5555555455555557,
  0x5555555400000001, 0x7ffffffc00000007,
  0x7ffffffb80000009, 0x7ffffffd00000005,
  0x7ffffffc80000006, 0x7ffffffe00000003,
  0x7ffffffd80000003, 0x7fffffff00000001,
  0x7ffffffe80000000, 0x7fffffffffffffff,
  0x7fffffff7ffffffd, 0xaaaaaaa8aaaaaaad,
  0xaaaaaaa800000002, 0xccccccca66666669,
  0xccccccc99999999c, 0xffff7ffe00010001,
  0xffff7ffd00018000, 0xffff7fff0000ffff,
  0xffff7ffe00017ffd, 0xffff80000000fffd,
  0xffff7fff00017ffa, 0xffff80010000fffb,
  0xffff800000017ff7, 0xffffff7e00000101,
  0xffffff7d00000180, 0xffffff7f000000ff,
  0xffffff7e0000017d, 0xffffff80000000fd,
  0xffffff7f0000017a, 0xffffff81000000fb,
  0xffffff8000000177, 0xffffffde00000041,
  0xffffffdd00000060, 0xfffffffb00000007,
  0xfffffffa00000009, 0xfffffffc00000005,
  0xfffffffb00000006, 0xfffffffd00000003,
  0xfffffffd00000002, 0x0000000000000001,
  0x0000000000000000, 0x0000000100000000,
  0x00000000fffffffe, 0x00000001ffffffff,
  0x00000001fffffffc, 0x0000001fffffffe1,
  0x0000001fffffffc0, 0x0000007cffffff84,
  0x0000007cffffff06, 0x0000007dffffff83,
  0x0000007dffffff04, 0x0000007effffff82,
  0x0000007effffff02, 0x00007ffcffff8004,
  0x00007ffcffff0006, 0x00007ffdffff8003,
  0x00007ffdffff0004, 0x00007ffeffff8002,
  0x00007ffeffff0002, 0x33333332ccccccce,
  0x333333329999999a, 0x55555554aaaaaaac,
  0x5555555455555556, 0x7ffffffc80000004,
  0x7ffffffc00000006, 0x7ffffffd80000003,
  0x7ffffffd00000004, 0x7ffffffe80000002,
  0x7ffffffe00000002, 0x7fffffff80000001,
  0x7fffffff00000000, 0x8000000080000000,
  0x7ffffffffffffffe, 0xaaaaaaa955555557,
  0xaaaaaaa8aaaaaaac, 0xcccccccb33333335,
  0xccccccca66666668, 0xffff7fff00008001,
  0xffff7ffe00010000, 0xffff800000008000,
  0xffff7fff0000fffe, 0xffff800100007fff,
  0xffff80000000fffc, 0xffff800200007ffe,
  0xffff80010000fffa, 0xffffff7f00000081,
  0xffffff7e00000100, 0xffffff8000000080,
  0xffffff7f000000fe, 0xffffff810000007f,
  0xffffff80000000fc, 0xffffff820000007e,
  0xffffff81000000fa, 0xffffffdf00000021,
  0xffffffde00000040, 0xfffffffc00000004,
  0xfffffffb00000006, 0xfffffffd00000003,
  0xfffffffc00000004, 0xfffffffe00000002,
};
const unsigned kExpectedCount_NEON_umlal2_2D = 961;

#endif  // VIXL_SIM_UMLAL2_2D_TRACE_AARCH64_H_
