pem
===

A Rust library for parsing and encoding PEM-encoded data.

![Build Status](https://github.com/github/docs/actions/workflows/ci.yml/badge.svg)


### Documentation
[Module documentation with examples](https://docs.rs/pem/)

### Usage

Add this to your `Cargo.toml`:

```toml
[dependencies]
pem = "3.0"
```

Here is a simple example that parse PEM-encoded data and prints the tag:

```rust
use pem::parse;

const SAMPLE: &'static str = "-----BEGIN RSA PRIVATE KEY-----
MIIBPQIBAAJBAOsfi5AGYhdRs/x6q5H7kScxA0Kzzqe6WI6gf6+tc6IvKQJo5rQc
dWWSQ0nRGt2hOPDO+35NKhQEjBQxPh/v7n0CAwEAAQJBAOGaBAyuw0ICyENy5NsO
2gkT00AWTSzM9Zns0HedY31yEabkuFvrMCHjscEF7u3Y6PB7An3IzooBHchsFDei
AAECIQD/JahddzR5K3A6rzTidmAf1PBtqi7296EnWv8WvpfAAQIhAOvowIXZI4Un
DXjgZ9ekuUjZN+GUQRAVlkEEohGLVy59AiEA90VtqDdQuWWpvJX0cM08V10tLXrT
TTGsEtITid1ogAECIQDAaFl90ZgS5cMrL3wCeatVKzVUmuJmB/VAmlLFFGzK0QIh
ANJGc7AFk4fyFD/OezhwGHbWmo/S+bfeAiIh2Ss2FxKJ
-----END RSA PRIVATE KEY-----
";

let pem = parse(SAMPLE)?;
println!("PEM tag: {}", pem.tag);

```
