/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMRecord;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;

public class BamIndexValidator {
    public static int exhaustivelyTestIndex(SamReader reader) {
        if (reader.indexing().hasBrowseableIndex()) {
            CachingBAMFileIndex existingIndex = (CachingBAMFileIndex)reader.indexing().getBrowseableIndex();
            int n_ref = existingIndex.getNumberOfReferences();
            int chunkCount = 0;
            int indexCount = 0;
            for (int i = 0; i < n_ref; ++i) {
                BAMIndexContent content = existingIndex.getQueryResults(i);
                for (Chunk c : content.getAllChunks()) {
                    SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(c));
                    ++chunkCount;
                    BAMRecord b = null;
                    try {
                        b = (BAMRecord)iter.next();
                        iter.close();
                    }
                    catch (Exception e) {
                        throw new SAMException("Exception in BamIndexValidator. Last good record " + b + " in chunk " + c + " chunkCount=" + chunkCount, e);
                    }
                }
                LinearIndex linearIndex = content.getLinearIndex();
                for (long l : linearIndex.getIndexEntries()) {
                    try {
                        if (l == 0L) continue;
                        SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(new Chunk(l, l + 1L)));
                        BAMRecord b = (BAMRecord)iter.next();
                        ++indexCount;
                        iter.close();
                    }
                    catch (Exception e) {
                        throw new SAMException("Exception in BamIndexValidator. Linear index access failure " + l + " indexCount=" + indexCount, e);
                    }
                }
            }
            return chunkCount;
        }
        return 0;
    }
}

