/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.core.matcher.JButtonMatcher;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JFileChooserApproveButtonTextQuery;
import org.fest.swing.driver.JFileChooserCancelButtonTextQuery;
import org.fest.swing.driver.JFileChooserSelectFileTask;
import org.fest.swing.driver.JFileChooserSetCurrentDirectoryTask;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.util.Arrays;
import org.fest.util.Strings;

public class JFileChooserDriver
extends JComponentDriver {
    private static final String APPROVE_BUTTON = "Approve";
    private static final String CANCEL_BUTTON = "Cancel";

    public JFileChooserDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void selectFile(JFileChooser fileChooser, File file) {
        if (file == null) {
            throw new NullPointerException("The file to select should not be null");
        }
        JFileChooserSelectFileTask.validateAndSelectFile(fileChooser, file);
    }

    public void selectFiles(JFileChooser fileChooser, File[] files) {
        if (files == null) {
            throw new NullPointerException("The files to select should not be null");
        }
        if (Arrays.isEmpty((Object[])files)) {
            throw new IllegalArgumentException("The array of files to select should not be empty");
        }
        for (File file : files) {
            if (file != null) continue;
            throw new NullPointerException("The array of files to select should not contain null elements");
        }
        JFileChooserSelectFileTask.validateAndSelectFiles(fileChooser, files);
    }

    @RunsInEDT
    public void setCurrentDirectory(JFileChooser fileChooser, File dir) {
        JFileChooserSetCurrentDirectoryTask.validateAndSetCurrentDirectory(fileChooser, dir);
    }

    @RunsInEDT
    public JTextField fileNameTextBox(JFileChooser fileChooser) {
        return this.robot.finder().findByType(fileChooser, JTextField.class);
    }

    @RunsInEDT
    public void clickCancelButton(JFileChooser fileChooser) {
        this.click(this.cancelButton(fileChooser));
    }

    @RunsInEDT
    public JButton cancelButton(JFileChooser fileChooser) {
        return this.findButton(fileChooser, CANCEL_BUTTON, JFileChooserCancelButtonTextQuery.cancelButtonText());
    }

    @RunsInEDT
    public void clickApproveButton(JFileChooser fileChooser) {
        this.click(this.approveButton(fileChooser));
    }

    @RunsInEDT
    public JButton approveButton(JFileChooser fileChooser) {
        return this.findButton(fileChooser, APPROVE_BUTTON, JFileChooserApproveButtonTextQuery.approveButtonTextFrom(fileChooser));
    }

    @RunsInEDT
    private JButton findButton(JFileChooser fileChooser, String logicalName, String text) {
        JButton button = this.robot.finder().find((Container)fileChooser, JButtonMatcher.withText(text).andShowing());
        if (button == null) {
            throw this.cannotFindButton(logicalName, text);
        }
        return button;
    }

    private ComponentLookupException cannotFindButton(String name, String text) {
        throw new ComponentLookupException(Strings.concat((Object[])new Object[]{"Unable to find ", Strings.quote((String)name), " button with text ", Strings.quote((String)text)}));
    }
}

