#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Warhammer 40k: Gladius expansions:
# - Tyranids
# - Chaos Space Marines
# - T'au
# - Craftworld Aeldari
# - Adeptus Mechanicus
# - Adepta Sororitas
# - Drukhari
###

script_version=20231222.2

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='warhammer-40k-gladius'
GAME_NAME='Warhammer 40,000: Gladius'

EXPANSION_ID_TYRANIDS='tyranids'
EXPANSION_NAME_TYRANIDS='Tyranids'

EXPANSION_ID_CHAOS='chaos-space-marines'
EXPANSION_NAME_CHAOS='Chaos Space Marines'

EXPANSION_ID_TAU='tau'
EXPANSION_NAME_TAU='Tʼau'

EXPANSION_ID_AELDARI='craftworld-aeldari'
EXPANSION_NAME_AELDARI='Craftworld Aeldari'

EXPANSION_ID_MECHANICUS='adeptus-mechanicus'
EXPANSION_NAME_MECHANICUS='Adeptus Mechanicus'

EXPANSION_ID_SORORITAS='adepta-sororitas'
EXPANSION_NAME_SORORITAS='Adepta Sororitas'

EXPANSION_ID_DRUKHARI='drukhari'
EXPANSION_NAME_DRUKHARI='Drukhari'

# Archives

## Tyranids

ARCHIVE_BASE_TYRANIDS_17_NAME='warhammer_40_000_gladius_tyranids_1_13_02_69663.sh'
ARCHIVE_BASE_TYRANIDS_17_MD5='56d9a21d1b66074e6e2ac2258dae1b1d'
ARCHIVE_BASE_TYRANIDS_17_SIZE='1086'
ARCHIVE_BASE_TYRANIDS_17_VERSION='1.13.2-gog69663'
ARCHIVE_BASE_TYRANIDS_17_URL='https://www.gog.com/game/warhammer_40000_gladius_tyranids'

ARCHIVE_BASE_TYRANIDS_16_NAME='warhammer_40_000_gladius_tyranids_1_13_01_69403.sh'
ARCHIVE_BASE_TYRANIDS_16_MD5='1c9c6cd6c02b4ac7eb0b2b1c619a8e0b'
ARCHIVE_BASE_TYRANIDS_16_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_16_VERSION='1.13.1-gog69403'

ARCHIVE_BASE_TYRANIDS_15_NAME='warhammer_40_000_gladius_tyranids_1_12_03_67548.sh'
ARCHIVE_BASE_TYRANIDS_15_MD5='6fd672b4230bceebc496e7ce7aa455b4'
ARCHIVE_BASE_TYRANIDS_15_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_15_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_TYRANIDS_12_NAME='warhammer_40_000_gladius_tyranids_1_11_04_64361.sh'
ARCHIVE_BASE_TYRANIDS_12_MD5='53da0257c7ae0ca6c4b2712a70f8b666'
ARCHIVE_BASE_TYRANIDS_12_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_12_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_TYRANIDS_7_NAME='warhammer_40_000_gladius_tyranids_1_10_01_00_57375.sh'
ARCHIVE_BASE_TYRANIDS_7_MD5='30934475a2b0c8f794234d5e38f504cc'
ARCHIVE_BASE_TYRANIDS_7_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_7_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_TYRANIDS_5_NAME='warhammer_40_000_gladius_tyranids_v1_09_03_00_54377.sh'
ARCHIVE_BASE_TYRANIDS_5_MD5='ac2e7f57d90a405688304573e6332443'
ARCHIVE_BASE_TYRANIDS_5_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_5_VERSION='1.9.3.0-gog54377'

ARCHIVE_BASE_TYRANIDS_3_NAME='warhammer_40_000_gladius_tyranids_1_08_04_01_49548.sh'
ARCHIVE_BASE_TYRANIDS_3_MD5='a6e5921db60b6a366619354b1eb47d23'
ARCHIVE_BASE_TYRANIDS_3_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_3_VERSION='1.8.4.1-gog49548'

ARCHIVE_BASE_TYRANIDS_0_NAME='warhammer_40_000_gladius_tyranids_1_07_04_44200.sh'
ARCHIVE_BASE_TYRANIDS_0_MD5='c6c04852f1a3128dbfa267c89f1c9626'
ARCHIVE_BASE_TYRANIDS_0_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_0_VERSION='1.7.4-gog44200'

## Chaos Space Marines

ARCHIVE_BASE_CHAOS_16_NAME='warhammer_40_000_gladius_chaos_space_marines_1_13_02_69663.sh'
ARCHIVE_BASE_CHAOS_16_MD5='7646dcfb05aaca5b3d6e736af0b8d559'
ARCHIVE_BASE_CHAOS_16_SIZE='1086'
ARCHIVE_BASE_CHAOS_16_VERSION='1.13.2-gog69663'
ARCHIVE_BASE_CHAOS_16_URL='https://www.gog.com/game/warhammer_40000_gladius_chaos_space_marines'

ARCHIVE_BASE_CHAOS_15_NAME='warhammer_40_000_gladius_chaos_space_marines_1_13_01_69403.sh'
ARCHIVE_BASE_CHAOS_15_MD5='48ac8b9902efc357916d0c09ac5b55cb'
ARCHIVE_BASE_CHAOS_15_SIZE='1400'
ARCHIVE_BASE_CHAOS_15_VERSION='1.13.1-gog69403'

ARCHIVE_BASE_CHAOS_14_NAME='warhammer_40_000_gladius_chaos_space_marines_1_12_03_67548.sh'
ARCHIVE_BASE_CHAOS_14_MD5='5103e5a13f5e04f6a0d4ce2124ae9b8f'
ARCHIVE_BASE_CHAOS_14_SIZE='1400'
ARCHIVE_BASE_CHAOS_14_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_CHAOS_11_NAME='warhammer_40_000_gladius_chaos_space_marines_1_11_04_64361.sh'
ARCHIVE_BASE_CHAOS_11_MD5='2c613e93f92197efb004a4d590f6412e'
ARCHIVE_BASE_CHAOS_11_SIZE='1400'
ARCHIVE_BASE_CHAOS_11_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_CHAOS_6_NAME='warhammer_40_000_gladius_chaos_space_marines_1_10_01_00_57375.sh'
ARCHIVE_BASE_CHAOS_6_MD5='88542a8341638e1d51e2758c9886e2c6'
ARCHIVE_BASE_CHAOS_6_SIZE='1400'
ARCHIVE_BASE_CHAOS_6_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_CHAOS_4_NAME='warhammer_40_000_gladius_chaos_space_marines_v1_09_03_00_54377.sh'
ARCHIVE_BASE_CHAOS_4_MD5='ed2c64df977669d9413648347c883a35'
ARCHIVE_BASE_CHAOS_4_SIZE='1400'
ARCHIVE_BASE_CHAOS_4_VERSION='1.9.3.0-gog54377'

ARCHIVE_BASE_CHAOS_2_NAME='warhammer_40_000_gladius_chaos_space_marines_1_08_04_01_49548.sh'
ARCHIVE_BASE_CHAOS_2_MD5='37894d5cd89aaa67dc841d2f5023ebf2'
ARCHIVE_BASE_CHAOS_2_SIZE='1400'
ARCHIVE_BASE_CHAOS_2_VERSION='1.8.4.1-gog49548'

## T'au

ARCHIVE_BASE_TAU_13_NAME='warhammer_40_000_gladius_t_au_1_13_02_69663.sh'
ARCHIVE_BASE_TAU_13_MD5='307b4cfe83e697ced5bb43d6f0b281f0'
ARCHIVE_BASE_TAU_13_SIZE='1086'
ARCHIVE_BASE_TAU_13_VERSION='1.13.2-gog69663'
ARCHIVE_BASE_TAU_13_URL='https://www.gog.com/game/warhammer_40000_gladius_tau'

ARCHIVE_BASE_TAU_12_NAME='warhammer_40_000_gladius_t_au_1_13_01_69403.sh'
ARCHIVE_BASE_TAU_12_MD5='fdd2242b5c21206b00281c077907e337'
ARCHIVE_BASE_TAU_12_SIZE='1396'
ARCHIVE_BASE_TAU_12_VERSION='1.13.1-gog69403'

ARCHIVE_BASE_TAU_11_NAME='warhammer_40_000_gladius_t_au_1_12_03_67548.sh'
ARCHIVE_BASE_TAU_11_MD5='c0dd6e15c253f1b58a0d596fec8d1531'
ARCHIVE_BASE_TAU_11_SIZE='1396'
ARCHIVE_BASE_TAU_11_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_TAU_8_NAME='warhammer_40_000_gladius_t_au_1_11_04_64361.sh'
ARCHIVE_BASE_TAU_8_MD5='b8d20922d142704e61dbb8dbe83ce2b0'
ARCHIVE_BASE_TAU_8_SIZE='1400'
ARCHIVE_BASE_TAU_8_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_TAU_3_NAME='warhammer_40_000_gladius_t_au_1_10_01_00_57375.sh'
ARCHIVE_BASE_TAU_3_MD5='1f7770a75d1c846aca32f905cd4ce51f'
ARCHIVE_BASE_TAU_3_SIZE='1400'
ARCHIVE_BASE_TAU_3_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_TAU_1_NAME='warhammer_40_000_gladius_t_au_v1_09_03_00_54377.sh'
ARCHIVE_BASE_TAU_1_MD5='22b575c6ce8da35f7d57335662de4747'
ARCHIVE_BASE_TAU_1_SIZE='1400'
ARCHIVE_BASE_TAU_1_VERSION='1.9.3.0-gog54377'

## Craftworld Aeldari

ARCHIVE_BASE_AELDARI_11_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_13_02_69663.sh'
ARCHIVE_BASE_AELDARI_11_MD5='b78e818ea0eafd6a3f55f27780a32e41'
ARCHIVE_BASE_AELDARI_11_SIZE='1086'
ARCHIVE_BASE_AELDARI_11_VERSION='1.13.2-gog69663'
ARCHIVE_BASE_AELDARI_11_URL='https://www.gog.com/game/warhammer_40000_gladius_craftworld_aeldari'

ARCHIVE_BASE_AELDARI_10_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_13_01_69403.sh'
ARCHIVE_BASE_AELDARI_10_MD5='4cd9164d99f7313f05b1a68e9a1db71c'
ARCHIVE_BASE_AELDARI_10_SIZE='1400'
ARCHIVE_BASE_AELDARI_10_VERSION='1.13.1-gog69403'

ARCHIVE_BASE_AELDARI_9_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_12_03_67548.sh'
ARCHIVE_BASE_AELDARI_9_MD5='a9ed6a70658299ab82d2934f7b572151'
ARCHIVE_BASE_AELDARI_9_SIZE='1400'
ARCHIVE_BASE_AELDARI_9_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_AELDARI_6_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_11_04_64361.sh'
ARCHIVE_BASE_AELDARI_6_MD5='2c2b76c50ee3d7c29fd24c8aea0fe6e0'
ARCHIVE_BASE_AELDARI_6_SIZE='1400'
ARCHIVE_BASE_AELDARI_6_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_AELDARI_1_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_10_01_00_57375.sh'
ARCHIVE_BASE_AELDARI_1_MD5='b3698a59f99611fb8431a76ea50ef35d'
ARCHIVE_BASE_AELDARI_1_SIZE='1400'
ARCHIVE_BASE_AELDARI_1_VERSION='1.10.01-gog57375'

## Adeptus Mechanicus

ARCHIVE_BASE_MECHANICUS_4_NAME='warhammer_40_000_gladius_adeptus_mechanicus_1_13_02_69663.sh'
ARCHIVE_BASE_MECHANICUS_4_MD5='08f664202c9b6e59c7b32a1a0020576a'
ARCHIVE_BASE_MECHANICUS_4_SIZE='1086'
ARCHIVE_BASE_MECHANICUS_4_VERSION='1.13.2-gog69663'
ARCHIVE_BASE_MECHANICUS_4_URL='https://www.gog.com/game/warhammer_40000_gladius_adeptus_mechanicus'

ARCHIVE_BASE_MECHANICUS_3_NAME='warhammer_40_000_gladius_adeptus_mechanicus_1_13_01_69403.sh'
ARCHIVE_BASE_MECHANICUS_3_MD5='dbff85c0663d5f00e56bba5888843030'
ARCHIVE_BASE_MECHANICUS_3_SIZE='1400'
ARCHIVE_BASE_MECHANICUS_3_VERSION='1.13.1-gog69403'

ARCHIVE_BASE_MECHANICUS_2_NAME='warhammer_40_000_gladius_adeptus_mechanicus_1_12_03_67548.sh'
ARCHIVE_BASE_MECHANICUS_2_MD5='0be493045812d7ee50c5c7846b60151e'
ARCHIVE_BASE_MECHANICUS_2_SIZE='1400'
ARCHIVE_BASE_MECHANICUS_2_VERSION='1.12.3-gog67548'

## Adepta Sororitas

ARCHIVE_BASE_SORORITAS_3_NAME='warhammer_40_000_gladius_adepta_sororitas_1_13_02_69663.sh'
ARCHIVE_BASE_SORORITAS_3_MD5='d8c0a5bc12a9397f52df156dc60e71ac'
ARCHIVE_BASE_SORORITAS_3_SIZE='1086'
ARCHIVE_BASE_SORORITAS_3_VERSION='1.13.2-gog69663'
ARCHIVE_BASE_SORORITAS_3_URL='https://www.gog.com/game/warhammer_40000_gladius_adepta_sororitas'

ARCHIVE_BASE_SORORITAS_2_NAME='warhammer_40_000_gladius_adepta_sororitas_1_13_01_69403.sh'
ARCHIVE_BASE_SORORITAS_2_MD5='a15dd3488b8bb46616cd2091c9bc659c'
ARCHIVE_BASE_SORORITAS_2_SIZE='1400'
ARCHIVE_BASE_SORORITAS_2_VERSION='1.13.1-gog69403'

ARCHIVE_BASE_SORORITAS_1_NAME='warhammer_40_000_gladius_adepta_sororitas_1_12_03_67548.sh'
ARCHIVE_BASE_SORORITAS_1_MD5='1c69d1ce8301b0fb42f10718a4271761'
ARCHIVE_BASE_SORORITAS_1_SIZE='1400'
ARCHIVE_BASE_SORORITAS_1_VERSION='1.12.3-gog67548'

## Drukhari

ARCHIVE_BASE_DRUKHARI_0_NAME='warhammer_40_000_gladius_drukhari_1_13_02_69663.sh'
ARCHIVE_BASE_DRUKHARI_0_MD5='0573455b94bb4af75b2a5bfbf2a02a82'
ARCHIVE_BASE_DRUKHARI_0_SIZE='1086'
ARCHIVE_BASE_DRUKHARI_0_VERSION='1.13.2-gog69663'
ARCHIVE_BASE_DRUKHARI_0_URL='https://www.gog.com/game/warhammer_40000_gladius_drukhari'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
Data/*.dlc'

PKG_MAIN_DEPS="$GAME_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
