#![no_std]
#![allow(bad_style)]
#![deny(missing_docs)]
#![deny(missing_debug_implementations)]
#![allow(unused)]

//! Bindings to Gl 4.6
//!
//! Generated by [phosphorus](https://docs.rs/phosphorus/0.0.22/phosphorus/) and then slightly post-edited by hand.
//!
//! Included Extensions (activate via cargo feature):
//! * `GL_ARB_base_instance`
//! * `GL_ARB_buffer_storage`
//! * `GL_ARB_compute_shader`
//! * `GL_ARB_copy_buffer`
//! * `GL_ARB_debug_output`
//! * `GL_ARB_draw_elements_base_vertex`
//! * `GL_ARB_draw_instanced`
//! * `GL_ARB_framebuffer_object`
//! * `GL_ARB_framebuffer_sRGB`
//! * `GL_ARB_instanced_arrays`
//! * `GL_ARB_parallel_shader_compile`
//! * `GL_ARB_program_interface_query`
//! * `GL_ARB_sampler_objects`
//! * `GL_ARB_sync`
//! * `GL_ARB_tessellation_shader`
//! * `GL_ARB_texture_filter_anisotropic`
//! * `GL_ARB_texture_storage`
//! * `GL_ARB_uniform_buffer_object`
//! * `GL_ARB_vertex_array_object`
//! * `GL_EXT_buffer_storage`
//! * `GL_EXT_draw_buffers2`
//! * `GL_EXT_texture_filter_anisotropic`
//! * `GL_KHR_debug`
//! * `GL_KHR_parallel_shader_compile`
//! * `GL_NV_copy_buffer`
//!
//! Supported Features:
//! * `debug_trace_calls`: if cfg!(debug_assertions), any call to a GL function
//!   will `trace!` what was called and with what args.
//! * `debug_automatic_glGetError`: If cfg!(debug_assertions), this will
//!   automatically call `glGetError` after every call to any *other* GL
//!   function. If an error code occurs it's shown via `error!` along with the
//!   name of the function that had the error.
//! * `log`: imports `trace!` and `error!` macros from the `log` crate.
//!   Otherwise they just call `println!` and `eprintln!` respectively.
//! * `chlorine`: gets all C types from the `chlorine` crate (which is `no_std`
//!   friendly). Otherwise they will be imported from `std::os::raw`.
//! * `bytemuck`: Adds support for the `bytemuck` crate, mostly in the form of
//!   `bytemuck::Zeroable` on `GlFns`.
//! * `inline`: Tags all GL calls as `#[inline]`.
//! * `inline_always`: Tags all GL calls as `#[inline(always)]`. This will
//!   effectively override the `inline` feature.
//!
//! The crate is `no_std` friendly by default, but features above can end up
//! requiring `std` to be available.
//!
//! # GL Loaders
//! The docs for this crate hosted on docs.rs generate **both** the
//! `global_loader` and `struct_loader` documentation for sake of completeness.
//!
//! However, you are generally expected to use **only one** loader style in any
//! particular project.
//!
//! Each loader style has its own small advantages:
//! * The `global_loader` stores the GL function pointers in static `AtomicPtr`
//!   values.
//!   * Call [`load_global_gl_with`] to initialize the pointers.
//!   * Each GL function is available as a global function under its standard
//!     name, eg `glGetError()`.
//!   * This lets you call GL functions from anywhere at all, and it's how you
//!     might expect to use GL if you have a C background.
//!   * Being able to call GL from anywhere makes it easy to write Drop impls,
//!     among other things.
//! * The `struct_loader` stores all the function pointers in the fields of a
//!   [`GlFns`] struct.
//!   * Call [`GlFns::load_with`] to make a `GlFns` value.
//!   * Each GL function is available as a method on the struct with the `gl`
//!     prefix removed. It's presumed that you'll call the struct itself `gl`,
//!     so calls will look something like `gl.GetError()`.
//!   * This is closer to how WebGL works on WASM targets, and so this is how
//!     the [`glow`](https://docs.rs/glow) crate works to maintain consistency
//!     across desktop and web.
//!   * Also, if you want to do any sort of "live code reloading" you'll have to
//!     use the struct loader. DLLs don't share their static values with the
//!     main program, so if the DLL uses the global loader functions the
//!     pointers won't be loaded and calling any GL function from the DLL will
//!     panic. Instead, if you just pass a `&GlFns` to your DLL it can call the
//!     GL methods just fine.
//!
//! In both styles, if you call a function that isn't loaded you will get a
//! panic. This generally only happens if the context doesn't fully support
//! the GL version. You can check if a GL command is loaded or not before
//! actually calling it by adding `_is_loaded` to the name of the command. In
//! other words, `glGetError_is_loaded` to check if `glGetError` is globally
//! loaded, and `gl.GetError_is_loaded` to check if it's loaded in a `GlFns`.
//! All of the "`_is_loaded`" functions are hidden in the generated docs just
//! to keep things tidy, but they're there.
//!
//! # Safety
//! In general, there's many ways that GL can go wrong.
//!
//! For the purposes of this library, it's important to focus on the fact that:
//! * Initially all functions are null pointers. If a function is called when it's in a null state then you'll get a panic (reminder: a panic is safe).
//! * You can load pointers from the current GL context (described above).
//!   * These pointers are technically context specific, though in practice different contexts for the same graphics driver often all share the same function pointers.
//!   * The loader has no way to verify that pointers it gets are actually pointers to the correct functions, it just trusts what you tell it.
//! * Since loading a function pointer transitions the world from "it will definitely (safely) panic to call that GL command" to "it might be UB to call that GL command (even with the correct arguments)", the act of simply loading a function pointer is itself considered to be `unsafe`.
//! * Individual GL commands are generally safe to use once they've been properly loaded for the current context, but this crate doesn't attempt to sort out what is safe and what's not. All GL commands are blanket marked as being `unsafe`.
//! It's up to you to try and manage this unsafety! Sorry, but this crate just does what you tell it to.

#[cfg(any(
    all(
        not(feature = "log"),
        any(feature = "debug_trace_calls", feature = "debug_automatic_glGetError")
    ),
    not(feature = "chlorine"),
))]
extern crate std;

#[cfg(feature = "chlorine")]
use chlorine::*;
use std::os::raw::*;

#[cfg(feature = "log")]
#[allow(unused)]
use log::{error, trace};
#[cfg(all(not(feature = "log"), feature = "debug_trace_calls"))]
macro_rules! trace { ($($arg:tt)*) => { std::println!($($arg)*) } }
#[cfg(all(not(feature = "log"), feature = "debug_automatic_glGetError"))]
macro_rules! error { ($($arg:tt)*) => { std::eprintln!($($arg)*) } }

use core::{
    mem::transmute,
    ptr::null_mut,
    sync::atomic::{AtomicPtr, Ordering},
};
#[allow(dead_code)]
const RELAX: Ordering = Ordering::Relaxed;
#[allow(dead_code)]
type APcv = AtomicPtr<c_void>;
#[cfg(feature = "global_loader")]
const fn ap_null() -> APcv {
    AtomicPtr::new(null_mut())
}

pub use types::*;
#[allow(missing_docs)]
pub mod types {
    //! Contains all the GL types.
    use super::*;
    pub type GLenum = c_uint;
    pub type GLboolean = c_uchar;
    pub type GLbitfield = c_uint;
    pub type GLvoid = c_void;
    pub type GLbyte = i8;
    pub type GLubyte = u8;
    pub type GLshort = i16;
    pub type GLushort = u16;
    pub type GLint = c_int;
    pub type GLuint = c_uint;
    pub type GLclampx = i32;
    pub type GLsizei = c_int;
    pub type GLfloat = c_float;
    pub type GLclampf = c_float;
    pub type GLdouble = c_double;
    pub type GLclampd = c_double;
    pub type GLeglClientBufferEXT = *mut c_void;
    pub type GLeglImageOES = *mut c_void;
    pub type GLchar = c_char;
    pub type GLcharARB = c_char;
    #[cfg(any(target_os = "macos", target_os = "ios"))]
    pub type GLhandleARB = *mut c_void;
    #[cfg(not(any(target_os = "macos", target_os = "ios")))]
    pub type GLhandleARB = c_uint;
    pub type GLhalf = u16;
    pub type GLhalfARB = u16;
    pub type GLfixed = i32;
    pub type GLintptr = isize;
    pub type GLintptrARB = isize;
    pub type GLsizeiptr = isize;
    pub type GLsizeiptrARB = isize;
    pub type GLint64 = i64;
    pub type GLint64EXT = i64;
    pub type GLuint64 = u64;
    pub type GLuint64EXT = u64;
    #[doc(hidden)]
    pub struct __GLsync {
        _priv: u8,
    }
    impl core::fmt::Debug for __GLsync {
        fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
            write!(f, "__GLsync")
        }
    }
    pub type GLsync = *mut __GLsync;
    pub struct _cl_context {
        _priv: u8,
    }
    impl core::fmt::Debug for _cl_context {
        fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
            write!(f, "_cl_context")
        }
    }
    pub struct _cl_event {
        _priv: u8,
    }
    impl core::fmt::Debug for _cl_event {
        fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
            write!(f, "_cl_event")
        }
    }
    pub type GLDEBUGPROC = Option<
        unsafe extern "system" fn(
            source: GLenum,
            gltype: GLenum,
            id: GLuint,
            severity: GLenum,
            length: GLsizei,
            message: *const GLchar,
            userParam: *mut c_void,
        ),
    >;
    pub type GLDEBUGPROCARB = Option<
        extern "system" fn(
            source: GLenum,
            gltype: GLenum,
            id: GLuint,
            severity: GLenum,
            length: GLsizei,
            message: *const GLchar,
            userParam: *mut c_void,
        ),
    >;
    pub type GLDEBUGPROCKHR = Option<
        extern "system" fn(
            source: GLenum,
            gltype: GLenum,
            id: GLuint,
            severity: GLenum,
            length: GLsizei,
            message: *const GLchar,
            userParam: *mut c_void,
        ),
    >;
    pub type GLDEBUGPROCAMD = Option<
        extern "system" fn(
            id: GLuint,
            category: GLenum,
            severity: GLenum,
            length: GLsizei,
            message: *const GLchar,
            userParam: *mut c_void,
        ),
    >;
    pub type GLhalfNV = c_ushort;
    pub type GLvdpauSurfaceNV = GLintptr;
    pub type GLVULKANPROCNV = Option<extern "system" fn()>;
}

pub use enums::*;
pub mod enums {
    //! Contains all the GL enumerated values.
    //!
    //! In C these are called 'enums', but in Rust we call them a 'const'. Whatever.
    use super::*;
    #[doc = "`GL_ACTIVE_ATOMIC_COUNTER_BUFFERS: GLenum = 0x92D9`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_ACTIVE_ATOMIC_COUNTER_BUFFERS: GLenum = 0x92D9;
    #[doc = "`GL_ACTIVE_ATTRIBUTES: GLenum = 0x8B89`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_ACTIVE_ATTRIBUTES: GLenum = 0x8B89;
    #[doc = "`GL_ACTIVE_ATTRIBUTE_MAX_LENGTH: GLenum = 0x8B8A`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_ACTIVE_ATTRIBUTE_MAX_LENGTH: GLenum = 0x8B8A;
    #[doc = "`GL_ACTIVE_PROGRAM: GLenum = 0x8259`"]
    #[doc = "* **Group:** PipelineParameterName"]
    pub const GL_ACTIVE_PROGRAM: GLenum = 0x8259;
    #[doc = "`GL_ACTIVE_RESOURCES: GLenum = 0x92F5`"]
    #[doc = "* **Group:** ProgramInterfacePName"]
    pub const GL_ACTIVE_RESOURCES: GLenum = 0x92F5;
    #[doc = "`GL_ACTIVE_SUBROUTINES: GLenum = 0x8DE5`"]
    #[doc = "* **Group:** ProgramStagePName"]
    pub const GL_ACTIVE_SUBROUTINES: GLenum = 0x8DE5;
    #[doc = "`GL_ACTIVE_SUBROUTINE_MAX_LENGTH: GLenum = 0x8E48`"]
    #[doc = "* **Group:** ProgramStagePName"]
    pub const GL_ACTIVE_SUBROUTINE_MAX_LENGTH: GLenum = 0x8E48;
    #[doc = "`GL_ACTIVE_SUBROUTINE_UNIFORMS: GLenum = 0x8DE6`"]
    #[doc = "* **Group:** ProgramStagePName"]
    pub const GL_ACTIVE_SUBROUTINE_UNIFORMS: GLenum = 0x8DE6;
    #[doc = "`GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS: GLenum = 0x8E47`"]
    #[doc = "* **Group:** ProgramStagePName"]
    pub const GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS: GLenum = 0x8E47;
    #[doc = "`GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH: GLenum = 0x8E49`"]
    #[doc = "* **Group:** ProgramStagePName"]
    pub const GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH: GLenum = 0x8E49;
    #[doc = "`GL_ACTIVE_TEXTURE: GLenum = 0x84E0`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_ACTIVE_TEXTURE: GLenum = 0x84E0;
    #[doc = "`GL_ACTIVE_UNIFORMS: GLenum = 0x8B86`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_ACTIVE_UNIFORMS: GLenum = 0x8B86;
    #[doc = "`GL_ACTIVE_UNIFORM_BLOCKS: GLenum = 0x8A36`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_ACTIVE_UNIFORM_BLOCKS: GLenum = 0x8A36;
    #[doc = "`GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH: GLenum = 0x8A35`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH: GLenum = 0x8A35;
    #[doc = "`GL_ACTIVE_UNIFORM_MAX_LENGTH: GLenum = 0x8B87`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_ACTIVE_UNIFORM_MAX_LENGTH: GLenum = 0x8B87;
    #[doc = "`GL_ACTIVE_VARIABLES: GLenum = 0x9305`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_ACTIVE_VARIABLES: GLenum = 0x9305;
    #[doc = "`GL_ALIASED_LINE_WIDTH_RANGE: GLenum = 0x846E`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_ALIASED_LINE_WIDTH_RANGE: GLenum = 0x846E;
    #[doc = "`GL_ALIASED_POINT_SIZE_RANGE: GLenum = 0x846D`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_ALIASED_POINT_SIZE_RANGE: GLenum = 0x846D;
    #[doc = "`GL_ALL_BARRIER_BITS: GLbitfield = 0xFFFFFFFF`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_ALL_BARRIER_BITS: GLbitfield = 0xFFFFFFFF;
    #[doc = "`GL_ALL_SHADER_BITS: GLbitfield = 0xFFFFFFFF`"]
    #[doc = "* **Group:** UseProgramStageMask"]
    pub const GL_ALL_SHADER_BITS: GLbitfield = 0xFFFFFFFF;
    #[doc = "`GL_ALPHA: GLenum = 0x1906`"]
    #[doc = "* **Groups:** TextureSwizzle, CombinerPortionNV, PathColorFormat, CombinerComponentUsageNV, PixelFormat"]
    pub const GL_ALPHA: GLenum = 0x1906;
    #[doc = "`GL_ALPHA_BITS: GLenum = 0x0D55`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_ALPHA_BITS: GLenum = 0x0D55;
    #[doc = "`GL_ALREADY_SIGNALED: GLenum = 0x911A`"]
    #[doc = "* **Group:** SyncStatus"]
    pub const GL_ALREADY_SIGNALED: GLenum = 0x911A;
    #[doc = "`GL_ALWAYS: GLenum = 0x0207`"]
    #[doc = "* **Groups:** StencilFunction, IndexFunctionEXT, AlphaFunction, DepthFunction"]
    pub const GL_ALWAYS: GLenum = 0x0207;
    #[doc = "`GL_AND: GLenum = 0x1501`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_AND: GLenum = 0x1501;
    #[doc = "`GL_AND_INVERTED: GLenum = 0x1504`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_AND_INVERTED: GLenum = 0x1504;
    #[doc = "`GL_AND_REVERSE: GLenum = 0x1502`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_AND_REVERSE: GLenum = 0x1502;
    #[doc = "`GL_ANY_SAMPLES_PASSED: GLenum = 0x8C2F`"]
    #[doc = "* **Group:** QueryTarget"]
    pub const GL_ANY_SAMPLES_PASSED: GLenum = 0x8C2F;
    #[doc = "`GL_ANY_SAMPLES_PASSED_CONSERVATIVE: GLenum = 0x8D6A`"]
    #[doc = "* **Group:** QueryTarget"]
    pub const GL_ANY_SAMPLES_PASSED_CONSERVATIVE: GLenum = 0x8D6A;
    #[doc = "`GL_ARRAY_BUFFER: GLenum = 0x8892`"]
    #[doc = "* **Groups:** CopyBufferSubDataTarget, BufferTargetARB, BufferStorageTarget"]
    pub const GL_ARRAY_BUFFER: GLenum = 0x8892;
    #[doc = "`GL_ARRAY_BUFFER_BINDING: GLenum = 0x8894`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_ARRAY_BUFFER_BINDING: GLenum = 0x8894;
    #[doc = "`GL_ARRAY_SIZE: GLenum = 0x92FB`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_ARRAY_SIZE: GLenum = 0x92FB;
    #[doc = "`GL_ARRAY_STRIDE: GLenum = 0x92FE`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_ARRAY_STRIDE: GLenum = 0x92FE;
    #[doc = "`GL_ATOMIC_COUNTER_BARRIER_BIT: GLbitfield = 0x00001000`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_ATOMIC_COUNTER_BARRIER_BIT: GLbitfield = 0x00001000;
    #[doc = "`GL_ATOMIC_COUNTER_BUFFER: GLenum = 0x92C0`"]
    #[doc = "* **Groups:** CopyBufferSubDataTarget, BufferTargetARB, BufferStorageTarget"]
    pub const GL_ATOMIC_COUNTER_BUFFER: GLenum = 0x92C0;
    #[doc = "`GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS: GLenum = 0x92C5`"]
    #[doc = "* **Group:** AtomicCounterBufferPName"]
    pub const GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS: GLenum = 0x92C5;
    #[doc = "`GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES: GLenum = 0x92C6`"]
    #[doc = "* **Group:** AtomicCounterBufferPName"]
    pub const GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES: GLenum = 0x92C6;
    #[doc = "`GL_ATOMIC_COUNTER_BUFFER_BINDING: GLenum = 0x92C1`"]
    #[doc = "* **Group:** AtomicCounterBufferPName"]
    pub const GL_ATOMIC_COUNTER_BUFFER_BINDING: GLenum = 0x92C1;
    #[doc = "`GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE: GLenum = 0x92C4`"]
    #[doc = "* **Group:** AtomicCounterBufferPName"]
    pub const GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE: GLenum = 0x92C4;
    #[doc = "`GL_ATOMIC_COUNTER_BUFFER_INDEX: GLenum = 0x9301`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_ATOMIC_COUNTER_BUFFER_INDEX: GLenum = 0x9301;
    #[doc = "`GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER: GLenum = 0x90ED`"]
    #[doc = "* **Group:** AtomicCounterBufferPName"]
    pub const GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER: GLenum = 0x90ED;
    #[doc = "`GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER: GLenum = 0x92CB`"]
    #[doc = "* **Group:** AtomicCounterBufferPName"]
    pub const GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER: GLenum = 0x92CB;
    #[doc = "`GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER: GLenum = 0x92CA`"]
    #[doc = "* **Group:** AtomicCounterBufferPName"]
    pub const GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER: GLenum = 0x92CA;
    #[doc = "`GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER: GLenum = 0x92C8`"]
    #[doc = "* **Group:** AtomicCounterBufferPName"]
    pub const GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER: GLenum = 0x92C8;
    #[doc = "`GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER: GLenum = 0x92C9`"]
    #[doc = "* **Group:** AtomicCounterBufferPName"]
    pub const GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER: GLenum = 0x92C9;
    #[doc = "`GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER: GLenum = 0x92C7`"]
    #[doc = "* **Group:** AtomicCounterBufferPName"]
    pub const GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER: GLenum = 0x92C7;
    #[doc = "`GL_ATOMIC_COUNTER_BUFFER_SIZE: GLenum = 0x92C3`"]
    pub const GL_ATOMIC_COUNTER_BUFFER_SIZE: GLenum = 0x92C3;
    #[doc = "`GL_ATOMIC_COUNTER_BUFFER_START: GLenum = 0x92C2`"]
    pub const GL_ATOMIC_COUNTER_BUFFER_START: GLenum = 0x92C2;
    #[doc = "`GL_ATTACHED_SHADERS: GLenum = 0x8B85`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_ATTACHED_SHADERS: GLenum = 0x8B85;
    #[doc = "`GL_AUTO_GENERATE_MIPMAP: GLenum = 0x8295`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_AUTO_GENERATE_MIPMAP: GLenum = 0x8295;
    #[doc = "`GL_BACK: GLenum = 0x0405`"]
    #[doc = "* **Groups:** ColorBuffer, ColorMaterialFace, CullFaceMode, DrawBufferMode, ReadBufferMode, StencilFaceDirection, MaterialFace"]
    pub const GL_BACK: GLenum = 0x0405;
    #[doc = "`GL_BACK_LEFT: GLenum = 0x0402`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode"]
    pub const GL_BACK_LEFT: GLenum = 0x0402;
    #[doc = "`GL_BACK_RIGHT: GLenum = 0x0403`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode"]
    pub const GL_BACK_RIGHT: GLenum = 0x0403;
    #[doc = "`GL_BGR: GLenum = 0x80E0`"]
    #[doc = "* **Group:** PixelFormat"]
    pub const GL_BGR: GLenum = 0x80E0;
    #[doc = "`GL_BGRA: GLenum = 0x80E1`"]
    #[doc = "* **Group:** PixelFormat"]
    pub const GL_BGRA: GLenum = 0x80E1;
    #[doc = "`GL_BGRA_INTEGER: GLenum = 0x8D9B`"]
    #[doc = "* **Group:** PixelFormat"]
    pub const GL_BGRA_INTEGER: GLenum = 0x8D9B;
    #[doc = "`GL_BGR_INTEGER: GLenum = 0x8D9A`"]
    #[doc = "* **Group:** PixelFormat"]
    pub const GL_BGR_INTEGER: GLenum = 0x8D9A;
    #[doc = "`GL_BLEND: GLenum = 0x0BE2`"]
    #[doc = "* **Groups:** TextureEnvMode, EnableCap, GetPName"]
    pub const GL_BLEND: GLenum = 0x0BE2;
    #[doc = "`GL_BLEND_COLOR: GLenum = 0x8005`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_BLEND_COLOR: GLenum = 0x8005;
    #[doc = "`GL_BLEND_DST: GLenum = 0x0BE0`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_BLEND_DST: GLenum = 0x0BE0;
    #[doc = "`GL_BLEND_DST_ALPHA: GLenum = 0x80CA`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_BLEND_DST_ALPHA: GLenum = 0x80CA;
    #[doc = "`GL_BLEND_DST_RGB: GLenum = 0x80C8`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_BLEND_DST_RGB: GLenum = 0x80C8;
    #[doc = "`GL_BLEND_EQUATION: GLenum = 0x8009`"]
    pub const GL_BLEND_EQUATION: GLenum = 0x8009;
    #[doc = "`GL_BLEND_EQUATION_ALPHA: GLenum = 0x883D`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_BLEND_EQUATION_ALPHA: GLenum = 0x883D;
    #[doc = "`GL_BLEND_EQUATION_RGB: GLenum = 0x8009`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_BLEND_EQUATION_RGB: GLenum = 0x8009;
    #[doc = "`GL_BLEND_SRC: GLenum = 0x0BE1`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_BLEND_SRC: GLenum = 0x0BE1;
    #[doc = "`GL_BLEND_SRC_ALPHA: GLenum = 0x80CB`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_BLEND_SRC_ALPHA: GLenum = 0x80CB;
    #[doc = "`GL_BLEND_SRC_RGB: GLenum = 0x80C9`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_BLEND_SRC_RGB: GLenum = 0x80C9;
    #[doc = "`GL_BLOCK_INDEX: GLenum = 0x92FD`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_BLOCK_INDEX: GLenum = 0x92FD;
    #[doc = "`GL_BLUE: GLenum = 0x1905`"]
    #[doc = "* **Groups:** TextureSwizzle, CombinerComponentUsageNV, PixelFormat"]
    pub const GL_BLUE: GLenum = 0x1905;
    #[doc = "`GL_BLUE_BITS: GLenum = 0x0D54`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_BLUE_BITS: GLenum = 0x0D54;
    #[doc = "`GL_BLUE_INTEGER: GLenum = 0x8D96`"]
    #[doc = "* **Group:** PixelFormat"]
    pub const GL_BLUE_INTEGER: GLenum = 0x8D96;
    #[doc = "`GL_BOOL: GLenum = 0x8B56`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_BOOL: GLenum = 0x8B56;
    #[doc = "`GL_BOOL_VEC2: GLenum = 0x8B57`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_BOOL_VEC2: GLenum = 0x8B57;
    #[doc = "`GL_BOOL_VEC3: GLenum = 0x8B58`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_BOOL_VEC3: GLenum = 0x8B58;
    #[doc = "`GL_BOOL_VEC4: GLenum = 0x8B59`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_BOOL_VEC4: GLenum = 0x8B59;
    #[doc = "`GL_BUFFER: GLenum = 0x82E0`"]
    #[doc = "* **Group:** ObjectIdentifier"]
    pub const GL_BUFFER: GLenum = 0x82E0;
    #[doc = "`GL_BUFFER_ACCESS: GLenum = 0x88BB`"]
    #[doc = "* **Groups:** VertexBufferObjectParameter, BufferPNameARB"]
    pub const GL_BUFFER_ACCESS: GLenum = 0x88BB;
    #[doc = "`GL_BUFFER_ACCESS_FLAGS: GLenum = 0x911F`"]
    #[doc = "* **Groups:** VertexBufferObjectParameter, BufferPNameARB"]
    pub const GL_BUFFER_ACCESS_FLAGS: GLenum = 0x911F;
    #[doc = "`GL_BUFFER_BINDING: GLenum = 0x9302`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_BUFFER_BINDING: GLenum = 0x9302;
    #[doc = "`GL_BUFFER_DATA_SIZE: GLenum = 0x9303`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_BUFFER_DATA_SIZE: GLenum = 0x9303;
    #[doc = "`GL_BUFFER_IMMUTABLE_STORAGE: GLenum = 0x821F`"]
    #[doc = "* **Groups:** VertexBufferObjectParameter, BufferPNameARB"]
    pub const GL_BUFFER_IMMUTABLE_STORAGE: GLenum = 0x821F;
    #[doc = "`GL_BUFFER_IMMUTABLE_STORAGE_EXT: GLenum = 0x821F`"]

    pub const GL_BUFFER_IMMUTABLE_STORAGE_EXT: GLenum = 0x821F;
    #[doc = "`GL_BUFFER_KHR: GLenum = 0x82E0`"]

    pub const GL_BUFFER_KHR: GLenum = 0x82E0;
    #[doc = "`GL_BUFFER_MAPPED: GLenum = 0x88BC`"]
    #[doc = "* **Groups:** VertexBufferObjectParameter, BufferPNameARB"]
    pub const GL_BUFFER_MAPPED: GLenum = 0x88BC;
    #[doc = "`GL_BUFFER_MAP_LENGTH: GLenum = 0x9120`"]
    #[doc = "* **Groups:** VertexBufferObjectParameter, BufferPNameARB"]
    pub const GL_BUFFER_MAP_LENGTH: GLenum = 0x9120;
    #[doc = "`GL_BUFFER_MAP_OFFSET: GLenum = 0x9121`"]
    #[doc = "* **Groups:** VertexBufferObjectParameter, BufferPNameARB"]
    pub const GL_BUFFER_MAP_OFFSET: GLenum = 0x9121;
    #[doc = "`GL_BUFFER_MAP_POINTER: GLenum = 0x88BD`"]
    #[doc = "* **Group:** BufferPointerNameARB"]
    pub const GL_BUFFER_MAP_POINTER: GLenum = 0x88BD;
    #[doc = "`GL_BUFFER_SIZE: GLenum = 0x8764`"]
    #[doc = "* **Groups:** VertexBufferObjectParameter, BufferPNameARB"]
    pub const GL_BUFFER_SIZE: GLenum = 0x8764;
    #[doc = "`GL_BUFFER_STORAGE_FLAGS: GLenum = 0x8220`"]
    #[doc = "* **Groups:** VertexBufferObjectParameter, BufferPNameARB"]
    pub const GL_BUFFER_STORAGE_FLAGS: GLenum = 0x8220;
    #[doc = "`GL_BUFFER_STORAGE_FLAGS_EXT: GLenum = 0x8220`"]

    pub const GL_BUFFER_STORAGE_FLAGS_EXT: GLenum = 0x8220;
    #[doc = "`GL_BUFFER_UPDATE_BARRIER_BIT: GLbitfield = 0x00000200`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_BUFFER_UPDATE_BARRIER_BIT: GLbitfield = 0x00000200;
    #[doc = "`GL_BUFFER_USAGE: GLenum = 0x8765`"]
    #[doc = "* **Groups:** VertexBufferObjectParameter, BufferPNameARB"]
    pub const GL_BUFFER_USAGE: GLenum = 0x8765;
    #[doc = "`GL_BUFFER_VARIABLE: GLenum = 0x92E5`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_BUFFER_VARIABLE: GLenum = 0x92E5;
    #[doc = "`GL_BYTE: GLenum = 0x1400`"]
    #[doc = "* **Groups:** VertexAttribIType, WeightPointerTypeARB, TangentPointerTypeEXT, BinormalPointerTypeEXT, ColorPointerType, ListNameType, NormalPointerType, PixelType, VertexAttribType, VertexAttribPointerType"]
    pub const GL_BYTE: GLenum = 0x1400;
    #[doc = "`GL_CAVEAT_SUPPORT: GLenum = 0x82B8`"]
    pub const GL_CAVEAT_SUPPORT: GLenum = 0x82B8;
    #[doc = "`GL_CCW: GLenum = 0x0901`"]
    #[doc = "* **Group:** FrontFaceDirection"]
    pub const GL_CCW: GLenum = 0x0901;
    #[doc = "`GL_CLAMP_READ_COLOR: GLenum = 0x891C`"]
    #[doc = "* **Group:** ClampColorTargetARB"]
    pub const GL_CLAMP_READ_COLOR: GLenum = 0x891C;
    #[doc = "`GL_CLAMP_TO_BORDER: GLenum = 0x812D`"]
    #[doc = "* **Group:** TextureWrapMode"]
    pub const GL_CLAMP_TO_BORDER: GLenum = 0x812D;
    #[doc = "`GL_CLAMP_TO_EDGE: GLenum = 0x812F`"]
    #[doc = "* **Group:** TextureWrapMode"]
    pub const GL_CLAMP_TO_EDGE: GLenum = 0x812F;
    #[doc = "`GL_CLEAR: GLenum = 0x1500`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_CLEAR: GLenum = 0x1500;
    #[doc = "`GL_CLEAR_BUFFER: GLenum = 0x82B4`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_CLEAR_BUFFER: GLenum = 0x82B4;
    #[doc = "`GL_CLEAR_TEXTURE: GLenum = 0x9365`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_CLEAR_TEXTURE: GLenum = 0x9365;
    #[doc = "`GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT: GLbitfield = 0x00004000`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT: GLbitfield = 0x00004000;
    #[doc = "`GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT_EXT: GLbitfield = 0x00004000`"]
    #[doc = "* **Group:** MemoryBarrierMask"]

    pub const GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT_EXT: GLbitfield = 0x00004000;
    #[doc = "`GL_CLIENT_STORAGE_BIT: GLbitfield = 0x0200`"]
    #[doc = "* **Group:** BufferStorageMask"]
    pub const GL_CLIENT_STORAGE_BIT: GLbitfield = 0x0200;
    #[doc = "`GL_CLIENT_STORAGE_BIT_EXT: GLbitfield = 0x0200`"]
    #[doc = "* **Group:** BufferStorageMask"]

    pub const GL_CLIENT_STORAGE_BIT_EXT: GLbitfield = 0x0200;
    #[doc = "`GL_CLIPPING_INPUT_PRIMITIVES: GLenum = 0x82F6`"]
    pub const GL_CLIPPING_INPUT_PRIMITIVES: GLenum = 0x82F6;
    #[doc = "`GL_CLIPPING_OUTPUT_PRIMITIVES: GLenum = 0x82F7`"]
    pub const GL_CLIPPING_OUTPUT_PRIMITIVES: GLenum = 0x82F7;
    #[doc = "`GL_CLIP_DEPTH_MODE: GLenum = 0x935D`"]
    pub const GL_CLIP_DEPTH_MODE: GLenum = 0x935D;
    #[doc = "`GL_CLIP_DISTANCE0: GLenum = 0x3000`"]
    #[doc = "* **Groups:** EnableCap, ClipPlaneName"]
    #[doc = "* **Alias Of:** `GL_CLIP_PLANE0`"]
    pub const GL_CLIP_DISTANCE0: GLenum = 0x3000;
    #[doc = "`GL_CLIP_DISTANCE1: GLenum = 0x3001`"]
    #[doc = "* **Groups:** EnableCap, ClipPlaneName"]
    #[doc = "* **Alias Of:** `GL_CLIP_PLANE1`"]
    pub const GL_CLIP_DISTANCE1: GLenum = 0x3001;
    #[doc = "`GL_CLIP_DISTANCE2: GLenum = 0x3002`"]
    #[doc = "* **Groups:** EnableCap, ClipPlaneName"]
    #[doc = "* **Alias Of:** `GL_CLIP_PLANE2`"]
    pub const GL_CLIP_DISTANCE2: GLenum = 0x3002;
    #[doc = "`GL_CLIP_DISTANCE3: GLenum = 0x3003`"]
    #[doc = "* **Groups:** EnableCap, ClipPlaneName"]
    #[doc = "* **Alias Of:** `GL_CLIP_PLANE3`"]
    pub const GL_CLIP_DISTANCE3: GLenum = 0x3003;
    #[doc = "`GL_CLIP_DISTANCE4: GLenum = 0x3004`"]
    #[doc = "* **Groups:** EnableCap, ClipPlaneName"]
    #[doc = "* **Alias Of:** `GL_CLIP_PLANE4`"]
    pub const GL_CLIP_DISTANCE4: GLenum = 0x3004;
    #[doc = "`GL_CLIP_DISTANCE5: GLenum = 0x3005`"]
    #[doc = "* **Groups:** EnableCap, ClipPlaneName"]
    #[doc = "* **Alias Of:** `GL_CLIP_PLANE5`"]
    pub const GL_CLIP_DISTANCE5: GLenum = 0x3005;
    #[doc = "`GL_CLIP_DISTANCE6: GLenum = 0x3006`"]
    #[doc = "* **Groups:** EnableCap, ClipPlaneName"]
    pub const GL_CLIP_DISTANCE6: GLenum = 0x3006;
    #[doc = "`GL_CLIP_DISTANCE7: GLenum = 0x3007`"]
    #[doc = "* **Groups:** EnableCap, ClipPlaneName"]
    pub const GL_CLIP_DISTANCE7: GLenum = 0x3007;
    #[doc = "`GL_CLIP_ORIGIN: GLenum = 0x935C`"]
    pub const GL_CLIP_ORIGIN: GLenum = 0x935C;
    #[doc = "`GL_COLOR: GLenum = 0x1800`"]
    #[doc = "* **Groups:** Buffer, PixelCopyType, InvalidateFramebufferAttachment"]
    pub const GL_COLOR: GLenum = 0x1800;
    #[doc = "`GL_COLORBURN: GLenum = 0x929A`"]
    pub const GL_COLORBURN: GLenum = 0x929A;
    #[doc = "`GL_COLORDODGE: GLenum = 0x9299`"]
    pub const GL_COLORDODGE: GLenum = 0x9299;
    #[doc = "`GL_COLOR_ATTACHMENT0: GLenum = 0x8CE0`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT0: GLenum = 0x8CE0;
    #[doc = "`GL_COLOR_ATTACHMENT1: GLenum = 0x8CE1`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT1: GLenum = 0x8CE1;
    #[doc = "`GL_COLOR_ATTACHMENT10: GLenum = 0x8CEA`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT10: GLenum = 0x8CEA;
    #[doc = "`GL_COLOR_ATTACHMENT11: GLenum = 0x8CEB`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT11: GLenum = 0x8CEB;
    #[doc = "`GL_COLOR_ATTACHMENT12: GLenum = 0x8CEC`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT12: GLenum = 0x8CEC;
    #[doc = "`GL_COLOR_ATTACHMENT13: GLenum = 0x8CED`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT13: GLenum = 0x8CED;
    #[doc = "`GL_COLOR_ATTACHMENT14: GLenum = 0x8CEE`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT14: GLenum = 0x8CEE;
    #[doc = "`GL_COLOR_ATTACHMENT15: GLenum = 0x8CEF`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT15: GLenum = 0x8CEF;
    #[doc = "`GL_COLOR_ATTACHMENT16: GLenum = 0x8CF0`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT16: GLenum = 0x8CF0;
    #[doc = "`GL_COLOR_ATTACHMENT17: GLenum = 0x8CF1`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT17: GLenum = 0x8CF1;
    #[doc = "`GL_COLOR_ATTACHMENT18: GLenum = 0x8CF2`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT18: GLenum = 0x8CF2;
    #[doc = "`GL_COLOR_ATTACHMENT19: GLenum = 0x8CF3`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT19: GLenum = 0x8CF3;
    #[doc = "`GL_COLOR_ATTACHMENT2: GLenum = 0x8CE2`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT2: GLenum = 0x8CE2;
    #[doc = "`GL_COLOR_ATTACHMENT20: GLenum = 0x8CF4`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT20: GLenum = 0x8CF4;
    #[doc = "`GL_COLOR_ATTACHMENT21: GLenum = 0x8CF5`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT21: GLenum = 0x8CF5;
    #[doc = "`GL_COLOR_ATTACHMENT22: GLenum = 0x8CF6`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT22: GLenum = 0x8CF6;
    #[doc = "`GL_COLOR_ATTACHMENT23: GLenum = 0x8CF7`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT23: GLenum = 0x8CF7;
    #[doc = "`GL_COLOR_ATTACHMENT24: GLenum = 0x8CF8`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT24: GLenum = 0x8CF8;
    #[doc = "`GL_COLOR_ATTACHMENT25: GLenum = 0x8CF9`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT25: GLenum = 0x8CF9;
    #[doc = "`GL_COLOR_ATTACHMENT26: GLenum = 0x8CFA`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT26: GLenum = 0x8CFA;
    #[doc = "`GL_COLOR_ATTACHMENT27: GLenum = 0x8CFB`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT27: GLenum = 0x8CFB;
    #[doc = "`GL_COLOR_ATTACHMENT28: GLenum = 0x8CFC`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT28: GLenum = 0x8CFC;
    #[doc = "`GL_COLOR_ATTACHMENT29: GLenum = 0x8CFD`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT29: GLenum = 0x8CFD;
    #[doc = "`GL_COLOR_ATTACHMENT3: GLenum = 0x8CE3`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT3: GLenum = 0x8CE3;
    #[doc = "`GL_COLOR_ATTACHMENT30: GLenum = 0x8CFE`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT30: GLenum = 0x8CFE;
    #[doc = "`GL_COLOR_ATTACHMENT31: GLenum = 0x8CFF`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT31: GLenum = 0x8CFF;
    #[doc = "`GL_COLOR_ATTACHMENT4: GLenum = 0x8CE4`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT4: GLenum = 0x8CE4;
    #[doc = "`GL_COLOR_ATTACHMENT5: GLenum = 0x8CE5`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT5: GLenum = 0x8CE5;
    #[doc = "`GL_COLOR_ATTACHMENT6: GLenum = 0x8CE6`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT6: GLenum = 0x8CE6;
    #[doc = "`GL_COLOR_ATTACHMENT7: GLenum = 0x8CE7`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT7: GLenum = 0x8CE7;
    #[doc = "`GL_COLOR_ATTACHMENT8: GLenum = 0x8CE8`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT8: GLenum = 0x8CE8;
    #[doc = "`GL_COLOR_ATTACHMENT9: GLenum = 0x8CE9`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode, FramebufferAttachment, InvalidateFramebufferAttachment"]
    pub const GL_COLOR_ATTACHMENT9: GLenum = 0x8CE9;
    #[doc = "`GL_COLOR_BUFFER_BIT: GLbitfield = 0x00004000`"]
    #[doc = "* **Groups:** ClearBufferMask, AttribMask"]
    pub const GL_COLOR_BUFFER_BIT: GLbitfield = 0x00004000;
    #[doc = "`GL_COLOR_CLEAR_VALUE: GLenum = 0x0C22`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_COLOR_CLEAR_VALUE: GLenum = 0x0C22;
    #[doc = "`GL_COLOR_COMPONENTS: GLenum = 0x8283`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_COLOR_COMPONENTS: GLenum = 0x8283;
    #[doc = "`GL_COLOR_ENCODING: GLenum = 0x8296`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_COLOR_ENCODING: GLenum = 0x8296;
    #[doc = "`GL_COLOR_LOGIC_OP: GLenum = 0x0BF2`"]
    #[doc = "* **Groups:** GetPName, EnableCap"]
    pub const GL_COLOR_LOGIC_OP: GLenum = 0x0BF2;
    #[doc = "`GL_COLOR_RENDERABLE: GLenum = 0x8286`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_COLOR_RENDERABLE: GLenum = 0x8286;
    #[doc = "`GL_COLOR_WRITEMASK: GLenum = 0x0C23`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_COLOR_WRITEMASK: GLenum = 0x0C23;
    #[doc = "`GL_COMMAND_BARRIER_BIT: GLbitfield = 0x00000040`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_COMMAND_BARRIER_BIT: GLbitfield = 0x00000040;
    #[doc = "`GL_COMPARE_REF_TO_TEXTURE: GLenum = 0x884E`"]
    #[doc = "* **Group:** TextureCompareMode"]
    #[doc = "* **Alias Of:** `GL_COMPARE_R_TO_TEXTURE`"]
    pub const GL_COMPARE_REF_TO_TEXTURE: GLenum = 0x884E;
    #[doc = "`GL_COMPATIBLE_SUBROUTINES: GLenum = 0x8E4B`"]
    #[doc = "* **Groups:** ProgramResourceProperty, SubroutineParameterName"]
    pub const GL_COMPATIBLE_SUBROUTINES: GLenum = 0x8E4B;
    #[doc = "`GL_COMPILE_STATUS: GLenum = 0x8B81`"]
    #[doc = "* **Group:** ShaderParameterName"]
    pub const GL_COMPILE_STATUS: GLenum = 0x8B81;
    #[doc = "`GL_COMPLETION_STATUS_ARB: GLenum = 0x91B1`"]
    #[doc = "* **Alias Of:** `GL_COMPLETION_STATUS_KHR`"]

    pub const GL_COMPLETION_STATUS_ARB: GLenum = 0x91B1;
    #[doc = "`GL_COMPLETION_STATUS_KHR: GLenum = 0x91B1`"]

    pub const GL_COMPLETION_STATUS_KHR: GLenum = 0x91B1;
    #[doc = "`GL_COMPRESSED_R11_EAC: GLenum = 0x9270`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_R11_EAC: GLenum = 0x9270;
    #[doc = "`GL_COMPRESSED_RED: GLenum = 0x8225`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RED: GLenum = 0x8225;
    #[doc = "`GL_COMPRESSED_RED_RGTC1: GLenum = 0x8DBB`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RED_RGTC1: GLenum = 0x8DBB;
    #[doc = "`GL_COMPRESSED_RG: GLenum = 0x8226`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RG: GLenum = 0x8226;
    #[doc = "`GL_COMPRESSED_RG11_EAC: GLenum = 0x9272`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RG11_EAC: GLenum = 0x9272;
    #[doc = "`GL_COMPRESSED_RGB: GLenum = 0x84ED`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGB: GLenum = 0x84ED;
    #[doc = "`GL_COMPRESSED_RGB8_ETC2: GLenum = 0x9274`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGB8_ETC2: GLenum = 0x9274;
    #[doc = "`GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2: GLenum = 0x9276`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2: GLenum = 0x9276;
    #[doc = "`GL_COMPRESSED_RGBA: GLenum = 0x84EE`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA: GLenum = 0x84EE;
    #[doc = "`GL_COMPRESSED_RGBA8_ETC2_EAC: GLenum = 0x9278`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA8_ETC2_EAC: GLenum = 0x9278;
    #[doc = "`GL_COMPRESSED_RGBA_ASTC_10x10: GLenum = 0x93BB`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_ASTC_10x10: GLenum = 0x93BB;
    #[doc = "`GL_COMPRESSED_RGBA_ASTC_10x5: GLenum = 0x93B8`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_ASTC_10x5: GLenum = 0x93B8;
    #[doc = "`GL_COMPRESSED_RGBA_ASTC_10x6: GLenum = 0x93B9`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_ASTC_10x6: GLenum = 0x93B9;
    #[doc = "`GL_COMPRESSED_RGBA_ASTC_10x8: GLenum = 0x93BA`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_ASTC_10x8: GLenum = 0x93BA;
    #[doc = "`GL_COMPRESSED_RGBA_ASTC_12x10: GLenum = 0x93BC`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_ASTC_12x10: GLenum = 0x93BC;
    #[doc = "`GL_COMPRESSED_RGBA_ASTC_12x12: GLenum = 0x93BD`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_ASTC_12x12: GLenum = 0x93BD;
    #[doc = "`GL_COMPRESSED_RGBA_ASTC_4x4: GLenum = 0x93B0`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_ASTC_4x4: GLenum = 0x93B0;
    #[doc = "`GL_COMPRESSED_RGBA_ASTC_5x4: GLenum = 0x93B1`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_ASTC_5x4: GLenum = 0x93B1;
    #[doc = "`GL_COMPRESSED_RGBA_ASTC_5x5: GLenum = 0x93B2`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_ASTC_5x5: GLenum = 0x93B2;
    #[doc = "`GL_COMPRESSED_RGBA_ASTC_6x5: GLenum = 0x93B3`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_ASTC_6x5: GLenum = 0x93B3;
    #[doc = "`GL_COMPRESSED_RGBA_ASTC_6x6: GLenum = 0x93B4`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_ASTC_6x6: GLenum = 0x93B4;
    #[doc = "`GL_COMPRESSED_RGBA_ASTC_8x5: GLenum = 0x93B5`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_ASTC_8x5: GLenum = 0x93B5;
    #[doc = "`GL_COMPRESSED_RGBA_ASTC_8x6: GLenum = 0x93B6`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_ASTC_8x6: GLenum = 0x93B6;
    #[doc = "`GL_COMPRESSED_RGBA_ASTC_8x8: GLenum = 0x93B7`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_ASTC_8x8: GLenum = 0x93B7;
    #[doc = "`GL_COMPRESSED_RGBA_BPTC_UNORM: GLenum = 0x8E8C`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGBA_BPTC_UNORM: GLenum = 0x8E8C;
    #[doc = "`GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT: GLenum = 0x8E8E`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT: GLenum = 0x8E8E;
    #[doc = "`GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT: GLenum = 0x8E8F`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT: GLenum = 0x8E8F;
    #[doc = "`GL_COMPRESSED_RG_RGTC2: GLenum = 0x8DBD`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_RG_RGTC2: GLenum = 0x8DBD;
    #[doc = "`GL_COMPRESSED_SIGNED_R11_EAC: GLenum = 0x9271`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SIGNED_R11_EAC: GLenum = 0x9271;
    #[doc = "`GL_COMPRESSED_SIGNED_RED_RGTC1: GLenum = 0x8DBC`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SIGNED_RED_RGTC1: GLenum = 0x8DBC;
    #[doc = "`GL_COMPRESSED_SIGNED_RG11_EAC: GLenum = 0x9273`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SIGNED_RG11_EAC: GLenum = 0x9273;
    #[doc = "`GL_COMPRESSED_SIGNED_RG_RGTC2: GLenum = 0x8DBE`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SIGNED_RG_RGTC2: GLenum = 0x8DBE;
    #[doc = "`GL_COMPRESSED_SRGB: GLenum = 0x8C48`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB: GLenum = 0x8C48;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10: GLenum = 0x93DB`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10: GLenum = 0x93DB;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5: GLenum = 0x93D8`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5: GLenum = 0x93D8;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6: GLenum = 0x93D9`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6: GLenum = 0x93D9;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8: GLenum = 0x93DA`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8: GLenum = 0x93DA;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10: GLenum = 0x93DC`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10: GLenum = 0x93DC;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12: GLenum = 0x93DD`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12: GLenum = 0x93DD;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4: GLenum = 0x93D0`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4: GLenum = 0x93D0;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4: GLenum = 0x93D1`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4: GLenum = 0x93D1;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5: GLenum = 0x93D2`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5: GLenum = 0x93D2;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5: GLenum = 0x93D3`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5: GLenum = 0x93D3;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6: GLenum = 0x93D4`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6: GLenum = 0x93D4;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5: GLenum = 0x93D5`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5: GLenum = 0x93D5;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6: GLenum = 0x93D6`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6: GLenum = 0x93D6;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8: GLenum = 0x93D7`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8: GLenum = 0x93D7;
    #[doc = "`GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC: GLenum = 0x9279`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC: GLenum = 0x9279;
    #[doc = "`GL_COMPRESSED_SRGB8_ETC2: GLenum = 0x9275`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_ETC2: GLenum = 0x9275;
    #[doc = "`GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2: GLenum = 0x9277`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2: GLenum = 0x9277;
    #[doc = "`GL_COMPRESSED_SRGB_ALPHA: GLenum = 0x8C49`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB_ALPHA: GLenum = 0x8C49;
    #[doc = "`GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM: GLenum = 0x8E8D`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM: GLenum = 0x8E8D;
    #[doc = "`GL_COMPRESSED_TEXTURE_FORMATS: GLenum = 0x86A3`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_COMPRESSED_TEXTURE_FORMATS: GLenum = 0x86A3;
    #[doc = "`GL_COMPUTE_SHADER: GLenum = 0x91B9`"]
    #[doc = "* **Group:** ShaderType"]
    pub const GL_COMPUTE_SHADER: GLenum = 0x91B9;
    #[doc = "`GL_COMPUTE_SHADER_BIT: GLbitfield = 0x00000020`"]
    #[doc = "* **Group:** UseProgramStageMask"]
    pub const GL_COMPUTE_SHADER_BIT: GLbitfield = 0x00000020;
    #[doc = "`GL_COMPUTE_SHADER_INVOCATIONS: GLenum = 0x82F5`"]
    pub const GL_COMPUTE_SHADER_INVOCATIONS: GLenum = 0x82F5;
    #[doc = "`GL_COMPUTE_SUBROUTINE: GLenum = 0x92ED`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_COMPUTE_SUBROUTINE: GLenum = 0x92ED;
    #[doc = "`GL_COMPUTE_SUBROUTINE_UNIFORM: GLenum = 0x92F3`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_COMPUTE_SUBROUTINE_UNIFORM: GLenum = 0x92F3;
    #[doc = "`GL_COMPUTE_TEXTURE: GLenum = 0x82A0`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_COMPUTE_TEXTURE: GLenum = 0x82A0;
    #[doc = "`GL_COMPUTE_WORK_GROUP_SIZE: GLenum = 0x8267`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_COMPUTE_WORK_GROUP_SIZE: GLenum = 0x8267;
    #[doc = "`GL_CONDITION_SATISFIED: GLenum = 0x911C`"]
    #[doc = "* **Group:** SyncStatus"]
    pub const GL_CONDITION_SATISFIED: GLenum = 0x911C;
    #[doc = "`GL_CONSTANT_ALPHA: GLenum = 0x8003`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_CONSTANT_ALPHA: GLenum = 0x8003;
    #[doc = "`GL_CONSTANT_COLOR: GLenum = 0x8001`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_CONSTANT_COLOR: GLenum = 0x8001;
    #[doc = "`GL_CONTEXT_COMPATIBILITY_PROFILE_BIT: GLbitfield = 0x00000002`"]
    #[doc = "* **Group:** ContextProfileMask"]
    pub const GL_CONTEXT_COMPATIBILITY_PROFILE_BIT: GLbitfield = 0x00000002;
    #[doc = "`GL_CONTEXT_CORE_PROFILE_BIT: GLbitfield = 0x00000001`"]
    #[doc = "* **Group:** ContextProfileMask"]
    pub const GL_CONTEXT_CORE_PROFILE_BIT: GLbitfield = 0x00000001;
    #[doc = "`GL_CONTEXT_FLAGS: GLenum = 0x821E`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_CONTEXT_FLAGS: GLenum = 0x821E;
    #[doc = "`GL_CONTEXT_FLAG_DEBUG_BIT: GLbitfield = 0x00000002`"]
    #[doc = "* **Group:** ContextFlagMask"]
    pub const GL_CONTEXT_FLAG_DEBUG_BIT: GLbitfield = 0x00000002;
    #[doc = "`GL_CONTEXT_FLAG_DEBUG_BIT_KHR: GLbitfield = 0x00000002`"]
    #[doc = "* **Group:** ContextFlagMask"]

    pub const GL_CONTEXT_FLAG_DEBUG_BIT_KHR: GLbitfield = 0x00000002;
    #[doc = "`GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT: GLbitfield = 0x00000001`"]
    #[doc = "* **Group:** ContextFlagMask"]
    pub const GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT: GLbitfield = 0x00000001;
    #[doc = "`GL_CONTEXT_FLAG_NO_ERROR_BIT: GLbitfield = 0x00000008`"]
    #[doc = "* **Group:** ContextFlagMask"]
    pub const GL_CONTEXT_FLAG_NO_ERROR_BIT: GLbitfield = 0x00000008;
    #[doc = "`GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT: GLbitfield = 0x00000004`"]
    #[doc = "* **Group:** ContextFlagMask"]
    pub const GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT: GLbitfield = 0x00000004;
    #[doc = "`GL_CONTEXT_LOST: GLenum = 0x0507`"]
    pub const GL_CONTEXT_LOST: GLenum = 0x0507;
    #[doc = "`GL_CONTEXT_PROFILE_MASK: GLenum = 0x9126`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_CONTEXT_PROFILE_MASK: GLenum = 0x9126;
    #[doc = "`GL_CONTEXT_RELEASE_BEHAVIOR: GLenum = 0x82FB`"]
    pub const GL_CONTEXT_RELEASE_BEHAVIOR: GLenum = 0x82FB;
    #[doc = "`GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH: GLenum = 0x82FC`"]
    pub const GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH: GLenum = 0x82FC;
    #[doc = "`GL_COPY: GLenum = 0x1503`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_COPY: GLenum = 0x1503;
    #[doc = "`GL_COPY_INVERTED: GLenum = 0x150C`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_COPY_INVERTED: GLenum = 0x150C;
    #[doc = "`GL_COPY_READ_BUFFER: GLenum = 0x8F36`"]
    #[doc = "* **Groups:** CopyBufferSubDataTarget, BufferTargetARB, BufferStorageTarget"]
    pub const GL_COPY_READ_BUFFER: GLenum = 0x8F36;
    #[doc = "`GL_COPY_READ_BUFFER_BINDING: GLenum = 0x8F36`"]
    #[doc = "* **Alias Of:** `GL_COPY_READ_BUFFER`"]
    pub const GL_COPY_READ_BUFFER_BINDING: GLenum = 0x8F36;
    #[doc = "`GL_COPY_READ_BUFFER_NV: GLenum = 0x8F36`"]

    pub const GL_COPY_READ_BUFFER_NV: GLenum = 0x8F36;
    #[doc = "`GL_COPY_WRITE_BUFFER: GLenum = 0x8F37`"]
    #[doc = "* **Groups:** CopyBufferSubDataTarget, BufferTargetARB, BufferStorageTarget"]
    pub const GL_COPY_WRITE_BUFFER: GLenum = 0x8F37;
    #[doc = "`GL_COPY_WRITE_BUFFER_BINDING: GLenum = 0x8F37`"]
    #[doc = "* **Alias Of:** `GL_COPY_WRITE_BUFFER`"]
    pub const GL_COPY_WRITE_BUFFER_BINDING: GLenum = 0x8F37;
    #[doc = "`GL_COPY_WRITE_BUFFER_NV: GLenum = 0x8F37`"]

    pub const GL_COPY_WRITE_BUFFER_NV: GLenum = 0x8F37;
    #[doc = "`GL_CULL_FACE: GLenum = 0x0B44`"]
    #[doc = "* **Groups:** GetPName, EnableCap"]
    pub const GL_CULL_FACE: GLenum = 0x0B44;
    #[doc = "`GL_CULL_FACE_MODE: GLenum = 0x0B45`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_CULL_FACE_MODE: GLenum = 0x0B45;
    #[doc = "`GL_CURRENT_PROGRAM: GLenum = 0x8B8D`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_CURRENT_PROGRAM: GLenum = 0x8B8D;
    #[doc = "`GL_CURRENT_QUERY: GLenum = 0x8865`"]
    #[doc = "* **Group:** QueryParameterName"]
    pub const GL_CURRENT_QUERY: GLenum = 0x8865;
    #[doc = "`GL_CURRENT_VERTEX_ATTRIB: GLenum = 0x8626`"]
    #[doc = "* **Groups:** VertexAttribEnum, VertexAttribPropertyARB"]
    pub const GL_CURRENT_VERTEX_ATTRIB: GLenum = 0x8626;
    #[doc = "`GL_CW: GLenum = 0x0900`"]
    #[doc = "* **Group:** FrontFaceDirection"]
    pub const GL_CW: GLenum = 0x0900;
    #[doc = "`GL_DARKEN: GLenum = 0x9297`"]
    pub const GL_DARKEN: GLenum = 0x9297;
    #[doc = "`GL_DEBUG_CALLBACK_FUNCTION: GLenum = 0x8244`"]
    #[doc = "* **Group:** GetPointervPName"]
    pub const GL_DEBUG_CALLBACK_FUNCTION: GLenum = 0x8244;
    #[doc = "`GL_DEBUG_CALLBACK_FUNCTION_ARB: GLenum = 0x8244`"]

    pub const GL_DEBUG_CALLBACK_FUNCTION_ARB: GLenum = 0x8244;
    #[doc = "`GL_DEBUG_CALLBACK_FUNCTION_KHR: GLenum = 0x8244`"]

    pub const GL_DEBUG_CALLBACK_FUNCTION_KHR: GLenum = 0x8244;
    #[doc = "`GL_DEBUG_CALLBACK_USER_PARAM: GLenum = 0x8245`"]
    #[doc = "* **Group:** GetPointervPName"]
    pub const GL_DEBUG_CALLBACK_USER_PARAM: GLenum = 0x8245;
    #[doc = "`GL_DEBUG_CALLBACK_USER_PARAM_ARB: GLenum = 0x8245`"]

    pub const GL_DEBUG_CALLBACK_USER_PARAM_ARB: GLenum = 0x8245;
    #[doc = "`GL_DEBUG_CALLBACK_USER_PARAM_KHR: GLenum = 0x8245`"]

    pub const GL_DEBUG_CALLBACK_USER_PARAM_KHR: GLenum = 0x8245;
    #[doc = "`GL_DEBUG_GROUP_STACK_DEPTH: GLenum = 0x826D`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_DEBUG_GROUP_STACK_DEPTH: GLenum = 0x826D;
    #[doc = "`GL_DEBUG_GROUP_STACK_DEPTH_KHR: GLenum = 0x826D`"]

    pub const GL_DEBUG_GROUP_STACK_DEPTH_KHR: GLenum = 0x826D;
    #[doc = "`GL_DEBUG_LOGGED_MESSAGES: GLenum = 0x9145`"]
    pub const GL_DEBUG_LOGGED_MESSAGES: GLenum = 0x9145;
    #[doc = "`GL_DEBUG_LOGGED_MESSAGES_ARB: GLenum = 0x9145`"]

    pub const GL_DEBUG_LOGGED_MESSAGES_ARB: GLenum = 0x9145;
    #[doc = "`GL_DEBUG_LOGGED_MESSAGES_KHR: GLenum = 0x9145`"]

    pub const GL_DEBUG_LOGGED_MESSAGES_KHR: GLenum = 0x9145;
    #[doc = "`GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH: GLenum = 0x8243`"]
    pub const GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH: GLenum = 0x8243;
    #[doc = "`GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB: GLenum = 0x8243`"]

    pub const GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB: GLenum = 0x8243;
    #[doc = "`GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR: GLenum = 0x8243`"]

    pub const GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR: GLenum = 0x8243;
    #[doc = "`GL_DEBUG_OUTPUT: GLenum = 0x92E0`"]
    #[doc = "* **Group:** EnableCap"]
    pub const GL_DEBUG_OUTPUT: GLenum = 0x92E0;
    #[doc = "`GL_DEBUG_OUTPUT_KHR: GLenum = 0x92E0`"]

    pub const GL_DEBUG_OUTPUT_KHR: GLenum = 0x92E0;
    #[doc = "`GL_DEBUG_OUTPUT_SYNCHRONOUS: GLenum = 0x8242`"]
    #[doc = "* **Group:** EnableCap"]
    pub const GL_DEBUG_OUTPUT_SYNCHRONOUS: GLenum = 0x8242;
    #[doc = "`GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB: GLenum = 0x8242`"]

    pub const GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB: GLenum = 0x8242;
    #[doc = "`GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR: GLenum = 0x8242`"]

    pub const GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR: GLenum = 0x8242;
    #[doc = "`GL_DEBUG_SEVERITY_HIGH: GLenum = 0x9146`"]
    #[doc = "* **Group:** DebugSeverity"]
    pub const GL_DEBUG_SEVERITY_HIGH: GLenum = 0x9146;
    #[doc = "`GL_DEBUG_SEVERITY_HIGH_ARB: GLenum = 0x9146`"]

    pub const GL_DEBUG_SEVERITY_HIGH_ARB: GLenum = 0x9146;
    #[doc = "`GL_DEBUG_SEVERITY_HIGH_KHR: GLenum = 0x9146`"]

    pub const GL_DEBUG_SEVERITY_HIGH_KHR: GLenum = 0x9146;
    #[doc = "`GL_DEBUG_SEVERITY_LOW: GLenum = 0x9148`"]
    #[doc = "* **Group:** DebugSeverity"]
    pub const GL_DEBUG_SEVERITY_LOW: GLenum = 0x9148;
    #[doc = "`GL_DEBUG_SEVERITY_LOW_ARB: GLenum = 0x9148`"]

    pub const GL_DEBUG_SEVERITY_LOW_ARB: GLenum = 0x9148;
    #[doc = "`GL_DEBUG_SEVERITY_LOW_KHR: GLenum = 0x9148`"]

    pub const GL_DEBUG_SEVERITY_LOW_KHR: GLenum = 0x9148;
    #[doc = "`GL_DEBUG_SEVERITY_MEDIUM: GLenum = 0x9147`"]
    #[doc = "* **Group:** DebugSeverity"]
    pub const GL_DEBUG_SEVERITY_MEDIUM: GLenum = 0x9147;
    #[doc = "`GL_DEBUG_SEVERITY_MEDIUM_ARB: GLenum = 0x9147`"]

    pub const GL_DEBUG_SEVERITY_MEDIUM_ARB: GLenum = 0x9147;
    #[doc = "`GL_DEBUG_SEVERITY_MEDIUM_KHR: GLenum = 0x9147`"]

    pub const GL_DEBUG_SEVERITY_MEDIUM_KHR: GLenum = 0x9147;
    #[doc = "`GL_DEBUG_SEVERITY_NOTIFICATION: GLenum = 0x826B`"]
    #[doc = "* **Group:** DebugSeverity"]
    pub const GL_DEBUG_SEVERITY_NOTIFICATION: GLenum = 0x826B;
    #[doc = "`GL_DEBUG_SEVERITY_NOTIFICATION_KHR: GLenum = 0x826B`"]

    pub const GL_DEBUG_SEVERITY_NOTIFICATION_KHR: GLenum = 0x826B;
    #[doc = "`GL_DEBUG_SOURCE_API: GLenum = 0x8246`"]
    #[doc = "* **Group:** DebugSource"]
    pub const GL_DEBUG_SOURCE_API: GLenum = 0x8246;
    #[doc = "`GL_DEBUG_SOURCE_API_ARB: GLenum = 0x8246`"]

    pub const GL_DEBUG_SOURCE_API_ARB: GLenum = 0x8246;
    #[doc = "`GL_DEBUG_SOURCE_API_KHR: GLenum = 0x8246`"]

    pub const GL_DEBUG_SOURCE_API_KHR: GLenum = 0x8246;
    #[doc = "`GL_DEBUG_SOURCE_APPLICATION: GLenum = 0x824A`"]
    #[doc = "* **Group:** DebugSource"]
    pub const GL_DEBUG_SOURCE_APPLICATION: GLenum = 0x824A;
    #[doc = "`GL_DEBUG_SOURCE_APPLICATION_ARB: GLenum = 0x824A`"]

    pub const GL_DEBUG_SOURCE_APPLICATION_ARB: GLenum = 0x824A;
    #[doc = "`GL_DEBUG_SOURCE_APPLICATION_KHR: GLenum = 0x824A`"]

    pub const GL_DEBUG_SOURCE_APPLICATION_KHR: GLenum = 0x824A;
    #[doc = "`GL_DEBUG_SOURCE_OTHER: GLenum = 0x824B`"]
    #[doc = "* **Group:** DebugSource"]
    pub const GL_DEBUG_SOURCE_OTHER: GLenum = 0x824B;
    #[doc = "`GL_DEBUG_SOURCE_OTHER_ARB: GLenum = 0x824B`"]

    pub const GL_DEBUG_SOURCE_OTHER_ARB: GLenum = 0x824B;
    #[doc = "`GL_DEBUG_SOURCE_OTHER_KHR: GLenum = 0x824B`"]

    pub const GL_DEBUG_SOURCE_OTHER_KHR: GLenum = 0x824B;
    #[doc = "`GL_DEBUG_SOURCE_SHADER_COMPILER: GLenum = 0x8248`"]
    #[doc = "* **Group:** DebugSource"]
    pub const GL_DEBUG_SOURCE_SHADER_COMPILER: GLenum = 0x8248;
    #[doc = "`GL_DEBUG_SOURCE_SHADER_COMPILER_ARB: GLenum = 0x8248`"]

    pub const GL_DEBUG_SOURCE_SHADER_COMPILER_ARB: GLenum = 0x8248;
    #[doc = "`GL_DEBUG_SOURCE_SHADER_COMPILER_KHR: GLenum = 0x8248`"]

    pub const GL_DEBUG_SOURCE_SHADER_COMPILER_KHR: GLenum = 0x8248;
    #[doc = "`GL_DEBUG_SOURCE_THIRD_PARTY: GLenum = 0x8249`"]
    #[doc = "* **Group:** DebugSource"]
    pub const GL_DEBUG_SOURCE_THIRD_PARTY: GLenum = 0x8249;
    #[doc = "`GL_DEBUG_SOURCE_THIRD_PARTY_ARB: GLenum = 0x8249`"]

    pub const GL_DEBUG_SOURCE_THIRD_PARTY_ARB: GLenum = 0x8249;
    #[doc = "`GL_DEBUG_SOURCE_THIRD_PARTY_KHR: GLenum = 0x8249`"]

    pub const GL_DEBUG_SOURCE_THIRD_PARTY_KHR: GLenum = 0x8249;
    #[doc = "`GL_DEBUG_SOURCE_WINDOW_SYSTEM: GLenum = 0x8247`"]
    #[doc = "* **Group:** DebugSource"]
    pub const GL_DEBUG_SOURCE_WINDOW_SYSTEM: GLenum = 0x8247;
    #[doc = "`GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB: GLenum = 0x8247`"]

    pub const GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB: GLenum = 0x8247;
    #[doc = "`GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR: GLenum = 0x8247`"]

    pub const GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR: GLenum = 0x8247;
    #[doc = "`GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR: GLenum = 0x824D`"]
    #[doc = "* **Group:** DebugType"]
    pub const GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR: GLenum = 0x824D;
    #[doc = "`GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB: GLenum = 0x824D`"]

    pub const GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB: GLenum = 0x824D;
    #[doc = "`GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR: GLenum = 0x824D`"]

    pub const GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR: GLenum = 0x824D;
    #[doc = "`GL_DEBUG_TYPE_ERROR: GLenum = 0x824C`"]
    #[doc = "* **Group:** DebugType"]
    pub const GL_DEBUG_TYPE_ERROR: GLenum = 0x824C;
    #[doc = "`GL_DEBUG_TYPE_ERROR_ARB: GLenum = 0x824C`"]

    pub const GL_DEBUG_TYPE_ERROR_ARB: GLenum = 0x824C;
    #[doc = "`GL_DEBUG_TYPE_ERROR_KHR: GLenum = 0x824C`"]

    pub const GL_DEBUG_TYPE_ERROR_KHR: GLenum = 0x824C;
    #[doc = "`GL_DEBUG_TYPE_MARKER: GLenum = 0x8268`"]
    #[doc = "* **Group:** DebugType"]
    pub const GL_DEBUG_TYPE_MARKER: GLenum = 0x8268;
    #[doc = "`GL_DEBUG_TYPE_MARKER_KHR: GLenum = 0x8268`"]

    pub const GL_DEBUG_TYPE_MARKER_KHR: GLenum = 0x8268;
    #[doc = "`GL_DEBUG_TYPE_OTHER: GLenum = 0x8251`"]
    #[doc = "* **Group:** DebugType"]
    pub const GL_DEBUG_TYPE_OTHER: GLenum = 0x8251;
    #[doc = "`GL_DEBUG_TYPE_OTHER_ARB: GLenum = 0x8251`"]

    pub const GL_DEBUG_TYPE_OTHER_ARB: GLenum = 0x8251;
    #[doc = "`GL_DEBUG_TYPE_OTHER_KHR: GLenum = 0x8251`"]

    pub const GL_DEBUG_TYPE_OTHER_KHR: GLenum = 0x8251;
    #[doc = "`GL_DEBUG_TYPE_PERFORMANCE: GLenum = 0x8250`"]
    #[doc = "* **Group:** DebugType"]
    pub const GL_DEBUG_TYPE_PERFORMANCE: GLenum = 0x8250;
    #[doc = "`GL_DEBUG_TYPE_PERFORMANCE_ARB: GLenum = 0x8250`"]

    pub const GL_DEBUG_TYPE_PERFORMANCE_ARB: GLenum = 0x8250;
    #[doc = "`GL_DEBUG_TYPE_PERFORMANCE_KHR: GLenum = 0x8250`"]

    pub const GL_DEBUG_TYPE_PERFORMANCE_KHR: GLenum = 0x8250;
    #[doc = "`GL_DEBUG_TYPE_POP_GROUP: GLenum = 0x826A`"]
    #[doc = "* **Group:** DebugType"]
    pub const GL_DEBUG_TYPE_POP_GROUP: GLenum = 0x826A;
    #[doc = "`GL_DEBUG_TYPE_POP_GROUP_KHR: GLenum = 0x826A`"]

    pub const GL_DEBUG_TYPE_POP_GROUP_KHR: GLenum = 0x826A;
    #[doc = "`GL_DEBUG_TYPE_PORTABILITY: GLenum = 0x824F`"]
    #[doc = "* **Group:** DebugType"]
    pub const GL_DEBUG_TYPE_PORTABILITY: GLenum = 0x824F;
    #[doc = "`GL_DEBUG_TYPE_PORTABILITY_ARB: GLenum = 0x824F`"]

    pub const GL_DEBUG_TYPE_PORTABILITY_ARB: GLenum = 0x824F;
    #[doc = "`GL_DEBUG_TYPE_PORTABILITY_KHR: GLenum = 0x824F`"]

    pub const GL_DEBUG_TYPE_PORTABILITY_KHR: GLenum = 0x824F;
    #[doc = "`GL_DEBUG_TYPE_PUSH_GROUP: GLenum = 0x8269`"]
    #[doc = "* **Group:** DebugType"]
    pub const GL_DEBUG_TYPE_PUSH_GROUP: GLenum = 0x8269;
    #[doc = "`GL_DEBUG_TYPE_PUSH_GROUP_KHR: GLenum = 0x8269`"]

    pub const GL_DEBUG_TYPE_PUSH_GROUP_KHR: GLenum = 0x8269;
    #[doc = "`GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR: GLenum = 0x824E`"]
    #[doc = "* **Group:** DebugType"]
    pub const GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR: GLenum = 0x824E;
    #[doc = "`GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB: GLenum = 0x824E`"]

    pub const GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB: GLenum = 0x824E;
    #[doc = "`GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR: GLenum = 0x824E`"]

    pub const GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR: GLenum = 0x824E;
    #[doc = "`GL_DECR: GLenum = 0x1E03`"]
    #[doc = "* **Group:** StencilOp"]
    pub const GL_DECR: GLenum = 0x1E03;
    #[doc = "`GL_DECR_WRAP: GLenum = 0x8508`"]
    #[doc = "* **Group:** StencilOp"]
    pub const GL_DECR_WRAP: GLenum = 0x8508;
    #[doc = "`GL_DELETE_STATUS: GLenum = 0x8B80`"]
    #[doc = "* **Groups:** ProgramPropertyARB, ShaderParameterName"]
    pub const GL_DELETE_STATUS: GLenum = 0x8B80;
    #[doc = "`GL_DEPTH: GLenum = 0x1801`"]
    #[doc = "* **Groups:** Buffer, PixelCopyType, InvalidateFramebufferAttachment"]
    pub const GL_DEPTH: GLenum = 0x1801;
    #[doc = "`GL_DEPTH24_STENCIL8: GLenum = 0x88F0`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_DEPTH24_STENCIL8: GLenum = 0x88F0;
    #[doc = "`GL_DEPTH32F_STENCIL8: GLenum = 0x8CAD`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_DEPTH32F_STENCIL8: GLenum = 0x8CAD;
    #[doc = "`GL_DEPTH_ATTACHMENT: GLenum = 0x8D00`"]
    #[doc = "* **Groups:** InvalidateFramebufferAttachment, FramebufferAttachment"]
    pub const GL_DEPTH_ATTACHMENT: GLenum = 0x8D00;
    #[doc = "`GL_DEPTH_BITS: GLenum = 0x0D56`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_DEPTH_BITS: GLenum = 0x0D56;
    #[doc = "`GL_DEPTH_BUFFER_BIT: GLbitfield = 0x00000100`"]
    #[doc = "* **Groups:** ClearBufferMask, AttribMask"]
    pub const GL_DEPTH_BUFFER_BIT: GLbitfield = 0x00000100;
    #[doc = "`GL_DEPTH_CLAMP: GLenum = 0x864F`"]
    #[doc = "* **Group:** EnableCap"]
    pub const GL_DEPTH_CLAMP: GLenum = 0x864F;
    #[doc = "`GL_DEPTH_CLEAR_VALUE: GLenum = 0x0B73`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_DEPTH_CLEAR_VALUE: GLenum = 0x0B73;
    #[doc = "`GL_DEPTH_COMPONENT: GLenum = 0x1902`"]
    #[doc = "* **Groups:** InternalFormat, PixelFormat"]
    pub const GL_DEPTH_COMPONENT: GLenum = 0x1902;
    #[doc = "`GL_DEPTH_COMPONENT16: GLenum = 0x81A5`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_DEPTH_COMPONENT16: GLenum = 0x81A5;
    #[doc = "`GL_DEPTH_COMPONENT24: GLenum = 0x81A6`"]
    pub const GL_DEPTH_COMPONENT24: GLenum = 0x81A6;
    #[doc = "`GL_DEPTH_COMPONENT32: GLenum = 0x81A7`"]
    pub const GL_DEPTH_COMPONENT32: GLenum = 0x81A7;
    #[doc = "`GL_DEPTH_COMPONENT32F: GLenum = 0x8CAC`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_DEPTH_COMPONENT32F: GLenum = 0x8CAC;
    #[doc = "`GL_DEPTH_COMPONENTS: GLenum = 0x8284`"]
    pub const GL_DEPTH_COMPONENTS: GLenum = 0x8284;
    #[doc = "`GL_DEPTH_FUNC: GLenum = 0x0B74`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_DEPTH_FUNC: GLenum = 0x0B74;
    #[doc = "`GL_DEPTH_RANGE: GLenum = 0x0B70`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_DEPTH_RANGE: GLenum = 0x0B70;
    #[doc = "`GL_DEPTH_RENDERABLE: GLenum = 0x8287`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_DEPTH_RENDERABLE: GLenum = 0x8287;
    #[doc = "`GL_DEPTH_STENCIL: GLenum = 0x84F9`"]
    #[doc = "* **Groups:** InternalFormat, PixelFormat"]
    pub const GL_DEPTH_STENCIL: GLenum = 0x84F9;
    #[doc = "`GL_DEPTH_STENCIL_ATTACHMENT: GLenum = 0x821A`"]
    #[doc = "* **Group:** InvalidateFramebufferAttachment"]
    pub const GL_DEPTH_STENCIL_ATTACHMENT: GLenum = 0x821A;
    #[doc = "`GL_DEPTH_STENCIL_TEXTURE_MODE: GLenum = 0x90EA`"]
    #[doc = "* **Group:** TextureParameterName"]
    pub const GL_DEPTH_STENCIL_TEXTURE_MODE: GLenum = 0x90EA;
    #[doc = "`GL_DEPTH_TEST: GLenum = 0x0B71`"]
    #[doc = "* **Groups:** GetPName, EnableCap"]
    pub const GL_DEPTH_TEST: GLenum = 0x0B71;
    #[doc = "`GL_DEPTH_WRITEMASK: GLenum = 0x0B72`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_DEPTH_WRITEMASK: GLenum = 0x0B72;
    #[doc = "`GL_DIFFERENCE: GLenum = 0x929E`"]
    pub const GL_DIFFERENCE: GLenum = 0x929E;
    #[doc = "`GL_DISPATCH_INDIRECT_BUFFER: GLenum = 0x90EE`"]
    #[doc = "* **Groups:** CopyBufferSubDataTarget, BufferTargetARB, BufferStorageTarget"]
    pub const GL_DISPATCH_INDIRECT_BUFFER: GLenum = 0x90EE;
    #[doc = "`GL_DISPATCH_INDIRECT_BUFFER_BINDING: GLenum = 0x90EF`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_DISPATCH_INDIRECT_BUFFER_BINDING: GLenum = 0x90EF;
    #[doc = "`GL_DITHER: GLenum = 0x0BD0`"]
    #[doc = "* **Groups:** GetPName, EnableCap"]
    pub const GL_DITHER: GLenum = 0x0BD0;
    #[doc = "`GL_DONT_CARE: GLenum = 0x1100`"]
    #[doc = "* **Groups:** DebugSeverity, HintMode, DebugSource, DebugType"]
    pub const GL_DONT_CARE: GLenum = 0x1100;
    #[doc = "`GL_DOUBLE: GLenum = 0x140A`"]
    #[doc = "* **Groups:** VertexAttribLType, MapTypeNV, SecondaryColorPointerTypeIBM, WeightPointerTypeARB, TangentPointerTypeEXT, BinormalPointerTypeEXT, FogCoordinatePointerType, FogPointerTypeEXT, FogPointerTypeIBM, IndexPointerType, NormalPointerType, TexCoordPointerType, VertexPointerType, VertexAttribType, AttributeType, UniformType, VertexAttribPointerType, GlslTypeToken"]
    pub const GL_DOUBLE: GLenum = 0x140A;
    #[doc = "`GL_DOUBLEBUFFER: GLenum = 0x0C32`"]
    #[doc = "* **Groups:** GetFramebufferParameter, GetPName"]
    pub const GL_DOUBLEBUFFER: GLenum = 0x0C32;
    #[doc = "`GL_DOUBLE_MAT2: GLenum = 0x8F46`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_DOUBLE_MAT2: GLenum = 0x8F46;
    #[doc = "`GL_DOUBLE_MAT2x3: GLenum = 0x8F49`"]
    #[doc = "* **Groups:** UniformType, AttributeType"]
    pub const GL_DOUBLE_MAT2x3: GLenum = 0x8F49;
    #[doc = "`GL_DOUBLE_MAT2x4: GLenum = 0x8F4A`"]
    #[doc = "* **Groups:** UniformType, AttributeType"]
    pub const GL_DOUBLE_MAT2x4: GLenum = 0x8F4A;
    #[doc = "`GL_DOUBLE_MAT3: GLenum = 0x8F47`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_DOUBLE_MAT3: GLenum = 0x8F47;
    #[doc = "`GL_DOUBLE_MAT3x2: GLenum = 0x8F4B`"]
    #[doc = "* **Groups:** UniformType, AttributeType"]
    pub const GL_DOUBLE_MAT3x2: GLenum = 0x8F4B;
    #[doc = "`GL_DOUBLE_MAT3x4: GLenum = 0x8F4C`"]
    #[doc = "* **Groups:** UniformType, AttributeType"]
    pub const GL_DOUBLE_MAT3x4: GLenum = 0x8F4C;
    #[doc = "`GL_DOUBLE_MAT4: GLenum = 0x8F48`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_DOUBLE_MAT4: GLenum = 0x8F48;
    #[doc = "`GL_DOUBLE_MAT4x2: GLenum = 0x8F4D`"]
    #[doc = "* **Groups:** UniformType, AttributeType"]
    pub const GL_DOUBLE_MAT4x2: GLenum = 0x8F4D;
    #[doc = "`GL_DOUBLE_MAT4x3: GLenum = 0x8F4E`"]
    #[doc = "* **Groups:** UniformType, AttributeType"]
    pub const GL_DOUBLE_MAT4x3: GLenum = 0x8F4E;
    #[doc = "`GL_DOUBLE_VEC2: GLenum = 0x8FFC`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_DOUBLE_VEC2: GLenum = 0x8FFC;
    #[doc = "`GL_DOUBLE_VEC3: GLenum = 0x8FFD`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_DOUBLE_VEC3: GLenum = 0x8FFD;
    #[doc = "`GL_DOUBLE_VEC4: GLenum = 0x8FFE`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_DOUBLE_VEC4: GLenum = 0x8FFE;
    #[doc = "`GL_DRAW_BUFFER: GLenum = 0x0C01`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_DRAW_BUFFER: GLenum = 0x0C01;
    #[doc = "`GL_DRAW_BUFFER0: GLenum = 0x8825`"]
    pub const GL_DRAW_BUFFER0: GLenum = 0x8825;
    #[doc = "`GL_DRAW_BUFFER1: GLenum = 0x8826`"]
    pub const GL_DRAW_BUFFER1: GLenum = 0x8826;
    #[doc = "`GL_DRAW_BUFFER10: GLenum = 0x882F`"]
    pub const GL_DRAW_BUFFER10: GLenum = 0x882F;
    #[doc = "`GL_DRAW_BUFFER11: GLenum = 0x8830`"]
    pub const GL_DRAW_BUFFER11: GLenum = 0x8830;
    #[doc = "`GL_DRAW_BUFFER12: GLenum = 0x8831`"]
    pub const GL_DRAW_BUFFER12: GLenum = 0x8831;
    #[doc = "`GL_DRAW_BUFFER13: GLenum = 0x8832`"]
    pub const GL_DRAW_BUFFER13: GLenum = 0x8832;
    #[doc = "`GL_DRAW_BUFFER14: GLenum = 0x8833`"]
    pub const GL_DRAW_BUFFER14: GLenum = 0x8833;
    #[doc = "`GL_DRAW_BUFFER15: GLenum = 0x8834`"]
    pub const GL_DRAW_BUFFER15: GLenum = 0x8834;
    #[doc = "`GL_DRAW_BUFFER2: GLenum = 0x8827`"]
    pub const GL_DRAW_BUFFER2: GLenum = 0x8827;
    #[doc = "`GL_DRAW_BUFFER3: GLenum = 0x8828`"]
    pub const GL_DRAW_BUFFER3: GLenum = 0x8828;
    #[doc = "`GL_DRAW_BUFFER4: GLenum = 0x8829`"]
    pub const GL_DRAW_BUFFER4: GLenum = 0x8829;
    #[doc = "`GL_DRAW_BUFFER5: GLenum = 0x882A`"]
    pub const GL_DRAW_BUFFER5: GLenum = 0x882A;
    #[doc = "`GL_DRAW_BUFFER6: GLenum = 0x882B`"]
    pub const GL_DRAW_BUFFER6: GLenum = 0x882B;
    #[doc = "`GL_DRAW_BUFFER7: GLenum = 0x882C`"]
    pub const GL_DRAW_BUFFER7: GLenum = 0x882C;
    #[doc = "`GL_DRAW_BUFFER8: GLenum = 0x882D`"]
    pub const GL_DRAW_BUFFER8: GLenum = 0x882D;
    #[doc = "`GL_DRAW_BUFFER9: GLenum = 0x882E`"]
    pub const GL_DRAW_BUFFER9: GLenum = 0x882E;
    #[doc = "`GL_DRAW_FRAMEBUFFER: GLenum = 0x8CA9`"]
    #[doc = "* **Groups:** CheckFramebufferStatusTarget, FramebufferTarget"]
    pub const GL_DRAW_FRAMEBUFFER: GLenum = 0x8CA9;
    #[doc = "`GL_DRAW_FRAMEBUFFER_BINDING: GLenum = 0x8CA6`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_DRAW_FRAMEBUFFER_BINDING: GLenum = 0x8CA6;
    #[doc = "`GL_DRAW_INDIRECT_BUFFER: GLenum = 0x8F3F`"]
    #[doc = "* **Groups:** CopyBufferSubDataTarget, BufferTargetARB, BufferStorageTarget"]
    pub const GL_DRAW_INDIRECT_BUFFER: GLenum = 0x8F3F;
    #[doc = "`GL_DRAW_INDIRECT_BUFFER_BINDING: GLenum = 0x8F43`"]
    pub const GL_DRAW_INDIRECT_BUFFER_BINDING: GLenum = 0x8F43;
    #[doc = "`GL_DST_ALPHA: GLenum = 0x0304`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_DST_ALPHA: GLenum = 0x0304;
    #[doc = "`GL_DST_COLOR: GLenum = 0x0306`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_DST_COLOR: GLenum = 0x0306;
    #[doc = "`GL_DYNAMIC_COPY: GLenum = 0x88EA`"]
    #[doc = "* **Groups:** VertexBufferObjectUsage, BufferUsageARB"]
    pub const GL_DYNAMIC_COPY: GLenum = 0x88EA;
    #[doc = "`GL_DYNAMIC_DRAW: GLenum = 0x88E8`"]
    #[doc = "* **Groups:** VertexBufferObjectUsage, BufferUsageARB"]
    pub const GL_DYNAMIC_DRAW: GLenum = 0x88E8;
    #[doc = "`GL_DYNAMIC_READ: GLenum = 0x88E9`"]
    #[doc = "* **Groups:** VertexBufferObjectUsage, BufferUsageARB"]
    pub const GL_DYNAMIC_READ: GLenum = 0x88E9;
    #[doc = "`GL_DYNAMIC_STORAGE_BIT: GLbitfield = 0x0100`"]
    #[doc = "* **Group:** BufferStorageMask"]
    pub const GL_DYNAMIC_STORAGE_BIT: GLbitfield = 0x0100;
    #[doc = "`GL_DYNAMIC_STORAGE_BIT_EXT: GLbitfield = 0x0100`"]
    #[doc = "* **Group:** BufferStorageMask"]

    pub const GL_DYNAMIC_STORAGE_BIT_EXT: GLbitfield = 0x0100;
    #[doc = "`GL_ELEMENT_ARRAY_BARRIER_BIT: GLbitfield = 0x00000002`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_ELEMENT_ARRAY_BARRIER_BIT: GLbitfield = 0x00000002;
    #[doc = "`GL_ELEMENT_ARRAY_BUFFER: GLenum = 0x8893`"]
    #[doc = "* **Groups:** CopyBufferSubDataTarget, BufferTargetARB, BufferStorageTarget"]
    pub const GL_ELEMENT_ARRAY_BUFFER: GLenum = 0x8893;
    #[doc = "`GL_ELEMENT_ARRAY_BUFFER_BINDING: GLenum = 0x8895`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_ELEMENT_ARRAY_BUFFER_BINDING: GLenum = 0x8895;
    #[doc = "`GL_EQUAL: GLenum = 0x0202`"]
    #[doc = "* **Groups:** StencilFunction, IndexFunctionEXT, AlphaFunction, DepthFunction"]
    pub const GL_EQUAL: GLenum = 0x0202;
    #[doc = "`GL_EQUIV: GLenum = 0x1509`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_EQUIV: GLenum = 0x1509;
    #[doc = "`GL_EXCLUSION: GLenum = 0x92A0`"]
    pub const GL_EXCLUSION: GLenum = 0x92A0;
    #[doc = "`GL_EXTENSIONS: GLenum = 0x1F03`"]
    #[doc = "* **Group:** StringName"]
    pub const GL_EXTENSIONS: GLenum = 0x1F03;
    #[doc = "`GL_FALSE: GLenum = 0`"]
    #[doc = "* **Groups:** Boolean, VertexShaderWriteMaskEXT, ClampColorModeARB"]
    pub const GL_FALSE: GLenum = 0;
    #[doc = "`GL_FASTEST: GLenum = 0x1101`"]
    #[doc = "* **Group:** HintMode"]
    pub const GL_FASTEST: GLenum = 0x1101;
    #[doc = "`GL_FILL: GLenum = 0x1B02`"]
    #[doc = "* **Groups:** PolygonMode, MeshMode2"]
    pub const GL_FILL: GLenum = 0x1B02;
    #[doc = "`GL_FILTER: GLenum = 0x829A`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_FILTER: GLenum = 0x829A;
    #[doc = "`GL_FIRST_VERTEX_CONVENTION: GLenum = 0x8E4D`"]
    #[doc = "* **Group:** VertexProvokingMode"]
    pub const GL_FIRST_VERTEX_CONVENTION: GLenum = 0x8E4D;
    #[doc = "`GL_FIXED: GLenum = 0x140C`"]
    #[doc = "* **Groups:** VertexAttribPointerType, VertexAttribType"]
    pub const GL_FIXED: GLenum = 0x140C;
    #[doc = "`GL_FIXED_ONLY: GLenum = 0x891D`"]
    #[doc = "* **Group:** ClampColorModeARB"]
    pub const GL_FIXED_ONLY: GLenum = 0x891D;
    #[doc = "`GL_FLOAT: GLenum = 0x1406`"]
    #[doc = "* **Groups:** GlslTypeToken, MapTypeNV, SecondaryColorPointerTypeIBM, WeightPointerTypeARB, VertexWeightPointerTypeEXT, TangentPointerTypeEXT, BinormalPointerTypeEXT, FogCoordinatePointerType, FogPointerTypeEXT, FogPointerTypeIBM, IndexPointerType, ListNameType, NormalPointerType, PixelType, TexCoordPointerType, VertexPointerType, VertexAttribType, AttributeType, UniformType, VertexAttribPointerType"]
    pub const GL_FLOAT: GLenum = 0x1406;
    #[doc = "`GL_FLOAT_32_UNSIGNED_INT_24_8_REV: GLenum = 0x8DAD`"]
    pub const GL_FLOAT_32_UNSIGNED_INT_24_8_REV: GLenum = 0x8DAD;
    #[doc = "`GL_FLOAT_MAT2: GLenum = 0x8B5A`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_FLOAT_MAT2: GLenum = 0x8B5A;
    #[doc = "`GL_FLOAT_MAT2x3: GLenum = 0x8B65`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_FLOAT_MAT2x3: GLenum = 0x8B65;
    #[doc = "`GL_FLOAT_MAT2x4: GLenum = 0x8B66`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_FLOAT_MAT2x4: GLenum = 0x8B66;
    #[doc = "`GL_FLOAT_MAT3: GLenum = 0x8B5B`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_FLOAT_MAT3: GLenum = 0x8B5B;
    #[doc = "`GL_FLOAT_MAT3x2: GLenum = 0x8B67`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_FLOAT_MAT3x2: GLenum = 0x8B67;
    #[doc = "`GL_FLOAT_MAT3x4: GLenum = 0x8B68`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_FLOAT_MAT3x4: GLenum = 0x8B68;
    #[doc = "`GL_FLOAT_MAT4: GLenum = 0x8B5C`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_FLOAT_MAT4: GLenum = 0x8B5C;
    #[doc = "`GL_FLOAT_MAT4x2: GLenum = 0x8B69`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_FLOAT_MAT4x2: GLenum = 0x8B69;
    #[doc = "`GL_FLOAT_MAT4x3: GLenum = 0x8B6A`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_FLOAT_MAT4x3: GLenum = 0x8B6A;
    #[doc = "`GL_FLOAT_VEC2: GLenum = 0x8B50`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_FLOAT_VEC2: GLenum = 0x8B50;
    #[doc = "`GL_FLOAT_VEC3: GLenum = 0x8B51`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_FLOAT_VEC3: GLenum = 0x8B51;
    #[doc = "`GL_FLOAT_VEC4: GLenum = 0x8B52`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_FLOAT_VEC4: GLenum = 0x8B52;
    #[doc = "`GL_FRACTIONAL_EVEN: GLenum = 0x8E7C`"]
    pub const GL_FRACTIONAL_EVEN: GLenum = 0x8E7C;
    #[doc = "`GL_FRACTIONAL_ODD: GLenum = 0x8E7B`"]
    pub const GL_FRACTIONAL_ODD: GLenum = 0x8E7B;
    #[doc = "`GL_FRAGMENT_INTERPOLATION_OFFSET_BITS: GLenum = 0x8E5D`"]
    pub const GL_FRAGMENT_INTERPOLATION_OFFSET_BITS: GLenum = 0x8E5D;
    #[doc = "`GL_FRAGMENT_SHADER: GLenum = 0x8B30`"]
    #[doc = "* **Groups:** PipelineParameterName, ShaderType"]
    pub const GL_FRAGMENT_SHADER: GLenum = 0x8B30;
    #[doc = "`GL_FRAGMENT_SHADER_BIT: GLbitfield = 0x00000002`"]
    #[doc = "* **Group:** UseProgramStageMask"]
    pub const GL_FRAGMENT_SHADER_BIT: GLbitfield = 0x00000002;
    #[doc = "`GL_FRAGMENT_SHADER_DERIVATIVE_HINT: GLenum = 0x8B8B`"]
    #[doc = "* **Groups:** HintTarget, GetPName"]
    pub const GL_FRAGMENT_SHADER_DERIVATIVE_HINT: GLenum = 0x8B8B;
    #[doc = "`GL_FRAGMENT_SHADER_INVOCATIONS: GLenum = 0x82F4`"]
    pub const GL_FRAGMENT_SHADER_INVOCATIONS: GLenum = 0x82F4;
    #[doc = "`GL_FRAGMENT_SUBROUTINE: GLenum = 0x92EC`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_FRAGMENT_SUBROUTINE: GLenum = 0x92EC;
    #[doc = "`GL_FRAGMENT_SUBROUTINE_UNIFORM: GLenum = 0x92F2`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_FRAGMENT_SUBROUTINE_UNIFORM: GLenum = 0x92F2;
    #[doc = "`GL_FRAGMENT_TEXTURE: GLenum = 0x829F`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_FRAGMENT_TEXTURE: GLenum = 0x829F;
    #[doc = "`GL_FRAMEBUFFER: GLenum = 0x8D40`"]
    #[doc = "* **Groups:** ObjectIdentifier, FramebufferTarget, CheckFramebufferStatusTarget"]
    pub const GL_FRAMEBUFFER: GLenum = 0x8D40;
    #[doc = "`GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE: GLenum = 0x8215`"]
    #[doc = "* **Group:** FramebufferAttachmentParameterName"]
    pub const GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE: GLenum = 0x8215;
    #[doc = "`GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE: GLenum = 0x8214`"]
    #[doc = "* **Group:** FramebufferAttachmentParameterName"]
    pub const GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE: GLenum = 0x8214;
    #[doc = "`GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING: GLenum = 0x8210`"]
    #[doc = "* **Group:** FramebufferAttachmentParameterName"]
    pub const GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING: GLenum = 0x8210;
    #[doc = "`GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE: GLenum = 0x8211`"]
    #[doc = "* **Group:** FramebufferAttachmentParameterName"]
    pub const GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE: GLenum = 0x8211;
    #[doc = "`GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE: GLenum = 0x8216`"]
    #[doc = "* **Group:** FramebufferAttachmentParameterName"]
    pub const GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE: GLenum = 0x8216;
    #[doc = "`GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE: GLenum = 0x8213`"]
    #[doc = "* **Group:** FramebufferAttachmentParameterName"]
    pub const GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE: GLenum = 0x8213;
    #[doc = "`GL_FRAMEBUFFER_ATTACHMENT_LAYERED: GLenum = 0x8DA7`"]
    #[doc = "* **Group:** FramebufferAttachmentParameterName"]
    pub const GL_FRAMEBUFFER_ATTACHMENT_LAYERED: GLenum = 0x8DA7;
    #[doc = "`GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: GLenum = 0x8CD1`"]
    #[doc = "* **Group:** FramebufferAttachmentParameterName"]
    pub const GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: GLenum = 0x8CD1;
    #[doc = "`GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: GLenum = 0x8CD0`"]
    #[doc = "* **Group:** FramebufferAttachmentParameterName"]
    pub const GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: GLenum = 0x8CD0;
    #[doc = "`GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE: GLenum = 0x8212`"]
    #[doc = "* **Group:** FramebufferAttachmentParameterName"]
    pub const GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE: GLenum = 0x8212;
    #[doc = "`GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE: GLenum = 0x8217`"]
    #[doc = "* **Group:** FramebufferAttachmentParameterName"]
    pub const GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE: GLenum = 0x8217;
    #[doc = "`GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: GLenum = 0x8CD3`"]
    #[doc = "* **Group:** FramebufferAttachmentParameterName"]
    pub const GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: GLenum = 0x8CD3;
    #[doc = "`GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER: GLenum = 0x8CD4`"]
    #[doc = "* **Group:** FramebufferAttachmentParameterName"]
    pub const GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER: GLenum = 0x8CD4;
    #[doc = "`GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: GLenum = 0x8CD2`"]
    #[doc = "* **Group:** FramebufferAttachmentParameterName"]
    pub const GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: GLenum = 0x8CD2;
    #[doc = "`GL_FRAMEBUFFER_BARRIER_BIT: GLbitfield = 0x00000400`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_FRAMEBUFFER_BARRIER_BIT: GLbitfield = 0x00000400;
    #[doc = "`GL_FRAMEBUFFER_BINDING: GLenum = 0x8CA6`"]
    pub const GL_FRAMEBUFFER_BINDING: GLenum = 0x8CA6;
    #[doc = "`GL_FRAMEBUFFER_BLEND: GLenum = 0x828B`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_FRAMEBUFFER_BLEND: GLenum = 0x828B;
    #[doc = "`GL_FRAMEBUFFER_COMPLETE: GLenum = 0x8CD5`"]
    #[doc = "* **Group:** FramebufferStatus"]
    pub const GL_FRAMEBUFFER_COMPLETE: GLenum = 0x8CD5;
    #[doc = "`GL_FRAMEBUFFER_DEFAULT: GLenum = 0x8218`"]
    pub const GL_FRAMEBUFFER_DEFAULT: GLenum = 0x8218;
    #[doc = "`GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS: GLenum = 0x9314`"]
    #[doc = "* **Groups:** GetFramebufferParameter, FramebufferParameterName"]
    pub const GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS: GLenum = 0x9314;
    #[doc = "`GL_FRAMEBUFFER_DEFAULT_HEIGHT: GLenum = 0x9311`"]
    #[doc = "* **Groups:** GetFramebufferParameter, FramebufferParameterName"]
    pub const GL_FRAMEBUFFER_DEFAULT_HEIGHT: GLenum = 0x9311;
    #[doc = "`GL_FRAMEBUFFER_DEFAULT_LAYERS: GLenum = 0x9312`"]
    #[doc = "* **Groups:** GetFramebufferParameter, FramebufferParameterName"]
    pub const GL_FRAMEBUFFER_DEFAULT_LAYERS: GLenum = 0x9312;
    #[doc = "`GL_FRAMEBUFFER_DEFAULT_SAMPLES: GLenum = 0x9313`"]
    #[doc = "* **Groups:** GetFramebufferParameter, FramebufferParameterName"]
    pub const GL_FRAMEBUFFER_DEFAULT_SAMPLES: GLenum = 0x9313;
    #[doc = "`GL_FRAMEBUFFER_DEFAULT_WIDTH: GLenum = 0x9310`"]
    #[doc = "* **Groups:** GetFramebufferParameter, FramebufferParameterName"]
    pub const GL_FRAMEBUFFER_DEFAULT_WIDTH: GLenum = 0x9310;
    #[doc = "`GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT: GLenum = 0x8CD6`"]
    #[doc = "* **Group:** FramebufferStatus"]
    pub const GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT: GLenum = 0x8CD6;
    #[doc = "`GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS: GLenum = 0x8CD9`"]
    pub const GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS: GLenum = 0x8CD9;
    #[doc = "`GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER: GLenum = 0x8CDB`"]
    #[doc = "* **Group:** FramebufferStatus"]
    pub const GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER: GLenum = 0x8CDB;
    #[doc = "`GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS: GLenum = 0x8DA8`"]
    #[doc = "* **Group:** FramebufferStatus"]
    pub const GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS: GLenum = 0x8DA8;
    #[doc = "`GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: GLenum = 0x8CD7`"]
    #[doc = "* **Group:** FramebufferStatus"]
    pub const GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: GLenum = 0x8CD7;
    #[doc = "`GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE: GLenum = 0x8D56`"]
    #[doc = "* **Group:** FramebufferStatus"]
    pub const GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE: GLenum = 0x8D56;
    #[doc = "`GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER: GLenum = 0x8CDC`"]
    #[doc = "* **Group:** FramebufferStatus"]
    pub const GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER: GLenum = 0x8CDC;
    #[doc = "`GL_FRAMEBUFFER_RENDERABLE: GLenum = 0x8289`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_FRAMEBUFFER_RENDERABLE: GLenum = 0x8289;
    #[doc = "`GL_FRAMEBUFFER_RENDERABLE_LAYERED: GLenum = 0x828A`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_FRAMEBUFFER_RENDERABLE_LAYERED: GLenum = 0x828A;
    #[doc = "`GL_FRAMEBUFFER_SRGB: GLenum = 0x8DB9`"]
    #[doc = "* **Group:** EnableCap"]
    pub const GL_FRAMEBUFFER_SRGB: GLenum = 0x8DB9;
    #[doc = "`GL_FRAMEBUFFER_UNDEFINED: GLenum = 0x8219`"]
    #[doc = "* **Group:** FramebufferStatus"]
    pub const GL_FRAMEBUFFER_UNDEFINED: GLenum = 0x8219;
    #[doc = "`GL_FRAMEBUFFER_UNSUPPORTED: GLenum = 0x8CDD`"]
    #[doc = "* **Group:** FramebufferStatus"]
    pub const GL_FRAMEBUFFER_UNSUPPORTED: GLenum = 0x8CDD;
    #[doc = "`GL_FRONT: GLenum = 0x0404`"]
    #[doc = "* **Groups:** ColorBuffer, ColorMaterialFace, CullFaceMode, DrawBufferMode, ReadBufferMode, StencilFaceDirection, MaterialFace"]
    pub const GL_FRONT: GLenum = 0x0404;
    #[doc = "`GL_FRONT_AND_BACK: GLenum = 0x0408`"]
    #[doc = "* **Groups:** ColorBuffer, ColorMaterialFace, CullFaceMode, DrawBufferMode, StencilFaceDirection, MaterialFace"]
    pub const GL_FRONT_AND_BACK: GLenum = 0x0408;
    #[doc = "`GL_FRONT_FACE: GLenum = 0x0B46`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_FRONT_FACE: GLenum = 0x0B46;
    #[doc = "`GL_FRONT_LEFT: GLenum = 0x0400`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode"]
    pub const GL_FRONT_LEFT: GLenum = 0x0400;
    #[doc = "`GL_FRONT_RIGHT: GLenum = 0x0401`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode"]
    pub const GL_FRONT_RIGHT: GLenum = 0x0401;
    #[doc = "`GL_FULL_SUPPORT: GLenum = 0x82B7`"]
    pub const GL_FULL_SUPPORT: GLenum = 0x82B7;
    #[doc = "`GL_FUNC_ADD: GLenum = 0x8006`"]
    #[doc = "* **Group:** BlendEquationModeEXT"]
    pub const GL_FUNC_ADD: GLenum = 0x8006;
    #[doc = "`GL_FUNC_REVERSE_SUBTRACT: GLenum = 0x800B`"]
    #[doc = "* **Group:** BlendEquationModeEXT"]
    pub const GL_FUNC_REVERSE_SUBTRACT: GLenum = 0x800B;
    #[doc = "`GL_FUNC_SUBTRACT: GLenum = 0x800A`"]
    #[doc = "* **Group:** BlendEquationModeEXT"]
    pub const GL_FUNC_SUBTRACT: GLenum = 0x800A;
    #[doc = "`GL_GENERATE_MIPMAP_HINT: GLenum = 0x8192`"]
    #[doc = "* **Group:** HintTarget"]
    pub const GL_GENERATE_MIPMAP_HINT: GLenum = 0x8192;
    #[doc = "`GL_GEOMETRY_INPUT_TYPE: GLenum = 0x8917`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_GEOMETRY_INPUT_TYPE: GLenum = 0x8917;
    #[doc = "`GL_GEOMETRY_OUTPUT_TYPE: GLenum = 0x8918`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_GEOMETRY_OUTPUT_TYPE: GLenum = 0x8918;
    #[doc = "`GL_GEOMETRY_SHADER: GLenum = 0x8DD9`"]
    #[doc = "* **Groups:** PipelineParameterName, ShaderType"]
    pub const GL_GEOMETRY_SHADER: GLenum = 0x8DD9;
    #[doc = "`GL_GEOMETRY_SHADER_BIT: GLbitfield = 0x00000004`"]
    #[doc = "* **Group:** UseProgramStageMask"]
    pub const GL_GEOMETRY_SHADER_BIT: GLbitfield = 0x00000004;
    #[doc = "`GL_GEOMETRY_SHADER_INVOCATIONS: GLenum = 0x887F`"]
    pub const GL_GEOMETRY_SHADER_INVOCATIONS: GLenum = 0x887F;
    #[doc = "`GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED: GLenum = 0x82F3`"]
    pub const GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED: GLenum = 0x82F3;
    #[doc = "`GL_GEOMETRY_SUBROUTINE: GLenum = 0x92EB`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_GEOMETRY_SUBROUTINE: GLenum = 0x92EB;
    #[doc = "`GL_GEOMETRY_SUBROUTINE_UNIFORM: GLenum = 0x92F1`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_GEOMETRY_SUBROUTINE_UNIFORM: GLenum = 0x92F1;
    #[doc = "`GL_GEOMETRY_TEXTURE: GLenum = 0x829E`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_GEOMETRY_TEXTURE: GLenum = 0x829E;
    #[doc = "`GL_GEOMETRY_VERTICES_OUT: GLenum = 0x8916`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_GEOMETRY_VERTICES_OUT: GLenum = 0x8916;
    #[doc = "`GL_GEQUAL: GLenum = 0x0206`"]
    #[doc = "* **Groups:** StencilFunction, IndexFunctionEXT, AlphaFunction, DepthFunction"]
    pub const GL_GEQUAL: GLenum = 0x0206;
    #[doc = "`GL_GET_TEXTURE_IMAGE_FORMAT: GLenum = 0x8291`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_GET_TEXTURE_IMAGE_FORMAT: GLenum = 0x8291;
    #[doc = "`GL_GET_TEXTURE_IMAGE_TYPE: GLenum = 0x8292`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_GET_TEXTURE_IMAGE_TYPE: GLenum = 0x8292;
    #[doc = "`GL_GREATER: GLenum = 0x0204`"]
    #[doc = "* **Groups:** StencilFunction, IndexFunctionEXT, AlphaFunction, DepthFunction"]
    pub const GL_GREATER: GLenum = 0x0204;
    #[doc = "`GL_GREEN: GLenum = 0x1904`"]
    #[doc = "* **Groups:** TextureSwizzle, PixelFormat"]
    pub const GL_GREEN: GLenum = 0x1904;
    #[doc = "`GL_GREEN_BITS: GLenum = 0x0D53`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_GREEN_BITS: GLenum = 0x0D53;
    #[doc = "`GL_GREEN_INTEGER: GLenum = 0x8D95`"]
    #[doc = "* **Group:** PixelFormat"]
    pub const GL_GREEN_INTEGER: GLenum = 0x8D95;
    #[doc = "`GL_GUILTY_CONTEXT_RESET: GLenum = 0x8253`"]
    #[doc = "* **Group:** GraphicsResetStatus"]
    pub const GL_GUILTY_CONTEXT_RESET: GLenum = 0x8253;
    #[doc = "`GL_HALF_FLOAT: GLenum = 0x140B`"]
    #[doc = "* **Groups:** VertexAttribPointerType, VertexAttribType"]
    pub const GL_HALF_FLOAT: GLenum = 0x140B;
    #[doc = "`GL_HARDLIGHT: GLenum = 0x929B`"]
    pub const GL_HARDLIGHT: GLenum = 0x929B;
    #[doc = "`GL_HIGH_FLOAT: GLenum = 0x8DF2`"]
    #[doc = "* **Group:** PrecisionType"]
    pub const GL_HIGH_FLOAT: GLenum = 0x8DF2;
    #[doc = "`GL_HIGH_INT: GLenum = 0x8DF5`"]
    #[doc = "* **Group:** PrecisionType"]
    pub const GL_HIGH_INT: GLenum = 0x8DF5;
    #[doc = "`GL_HSL_COLOR: GLenum = 0x92AF`"]
    pub const GL_HSL_COLOR: GLenum = 0x92AF;
    #[doc = "`GL_HSL_HUE: GLenum = 0x92AD`"]
    pub const GL_HSL_HUE: GLenum = 0x92AD;
    #[doc = "`GL_HSL_LUMINOSITY: GLenum = 0x92B0`"]
    pub const GL_HSL_LUMINOSITY: GLenum = 0x92B0;
    #[doc = "`GL_HSL_SATURATION: GLenum = 0x92AE`"]
    pub const GL_HSL_SATURATION: GLenum = 0x92AE;
    #[doc = "`GL_IMAGE_1D: GLenum = 0x904C`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_IMAGE_1D: GLenum = 0x904C;
    #[doc = "`GL_IMAGE_1D_ARRAY: GLenum = 0x9052`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_IMAGE_1D_ARRAY: GLenum = 0x9052;
    #[doc = "`GL_IMAGE_2D: GLenum = 0x904D`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_IMAGE_2D: GLenum = 0x904D;
    #[doc = "`GL_IMAGE_2D_ARRAY: GLenum = 0x9053`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_IMAGE_2D_ARRAY: GLenum = 0x9053;
    #[doc = "`GL_IMAGE_2D_MULTISAMPLE: GLenum = 0x9055`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_IMAGE_2D_MULTISAMPLE: GLenum = 0x9055;
    #[doc = "`GL_IMAGE_2D_MULTISAMPLE_ARRAY: GLenum = 0x9056`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_IMAGE_2D_MULTISAMPLE_ARRAY: GLenum = 0x9056;
    #[doc = "`GL_IMAGE_2D_RECT: GLenum = 0x904F`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_IMAGE_2D_RECT: GLenum = 0x904F;
    #[doc = "`GL_IMAGE_3D: GLenum = 0x904E`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_IMAGE_3D: GLenum = 0x904E;
    #[doc = "`GL_IMAGE_BINDING_ACCESS: GLenum = 0x8F3E`"]
    pub const GL_IMAGE_BINDING_ACCESS: GLenum = 0x8F3E;
    #[doc = "`GL_IMAGE_BINDING_FORMAT: GLenum = 0x906E`"]
    pub const GL_IMAGE_BINDING_FORMAT: GLenum = 0x906E;
    #[doc = "`GL_IMAGE_BINDING_LAYER: GLenum = 0x8F3D`"]
    pub const GL_IMAGE_BINDING_LAYER: GLenum = 0x8F3D;
    #[doc = "`GL_IMAGE_BINDING_LAYERED: GLenum = 0x8F3C`"]
    pub const GL_IMAGE_BINDING_LAYERED: GLenum = 0x8F3C;
    #[doc = "`GL_IMAGE_BINDING_LEVEL: GLenum = 0x8F3B`"]
    pub const GL_IMAGE_BINDING_LEVEL: GLenum = 0x8F3B;
    #[doc = "`GL_IMAGE_BINDING_NAME: GLenum = 0x8F3A`"]
    pub const GL_IMAGE_BINDING_NAME: GLenum = 0x8F3A;
    #[doc = "`GL_IMAGE_BUFFER: GLenum = 0x9051`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_IMAGE_BUFFER: GLenum = 0x9051;
    #[doc = "`GL_IMAGE_CLASS_10_10_10_2: GLenum = 0x82C3`"]
    pub const GL_IMAGE_CLASS_10_10_10_2: GLenum = 0x82C3;
    #[doc = "`GL_IMAGE_CLASS_11_11_10: GLenum = 0x82C2`"]
    pub const GL_IMAGE_CLASS_11_11_10: GLenum = 0x82C2;
    #[doc = "`GL_IMAGE_CLASS_1_X_16: GLenum = 0x82BE`"]
    pub const GL_IMAGE_CLASS_1_X_16: GLenum = 0x82BE;
    #[doc = "`GL_IMAGE_CLASS_1_X_32: GLenum = 0x82BB`"]
    pub const GL_IMAGE_CLASS_1_X_32: GLenum = 0x82BB;
    #[doc = "`GL_IMAGE_CLASS_1_X_8: GLenum = 0x82C1`"]
    pub const GL_IMAGE_CLASS_1_X_8: GLenum = 0x82C1;
    #[doc = "`GL_IMAGE_CLASS_2_X_16: GLenum = 0x82BD`"]
    pub const GL_IMAGE_CLASS_2_X_16: GLenum = 0x82BD;
    #[doc = "`GL_IMAGE_CLASS_2_X_32: GLenum = 0x82BA`"]
    pub const GL_IMAGE_CLASS_2_X_32: GLenum = 0x82BA;
    #[doc = "`GL_IMAGE_CLASS_2_X_8: GLenum = 0x82C0`"]
    pub const GL_IMAGE_CLASS_2_X_8: GLenum = 0x82C0;
    #[doc = "`GL_IMAGE_CLASS_4_X_16: GLenum = 0x82BC`"]
    pub const GL_IMAGE_CLASS_4_X_16: GLenum = 0x82BC;
    #[doc = "`GL_IMAGE_CLASS_4_X_32: GLenum = 0x82B9`"]
    pub const GL_IMAGE_CLASS_4_X_32: GLenum = 0x82B9;
    #[doc = "`GL_IMAGE_CLASS_4_X_8: GLenum = 0x82BF`"]
    pub const GL_IMAGE_CLASS_4_X_8: GLenum = 0x82BF;
    #[doc = "`GL_IMAGE_COMPATIBILITY_CLASS: GLenum = 0x82A8`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_IMAGE_COMPATIBILITY_CLASS: GLenum = 0x82A8;
    #[doc = "`GL_IMAGE_CUBE: GLenum = 0x9050`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_IMAGE_CUBE: GLenum = 0x9050;
    #[doc = "`GL_IMAGE_CUBE_MAP_ARRAY: GLenum = 0x9054`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_IMAGE_CUBE_MAP_ARRAY: GLenum = 0x9054;
    #[doc = "`GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS: GLenum = 0x90C9`"]
    pub const GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS: GLenum = 0x90C9;
    #[doc = "`GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE: GLenum = 0x90C8`"]
    pub const GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE: GLenum = 0x90C8;
    #[doc = "`GL_IMAGE_FORMAT_COMPATIBILITY_TYPE: GLenum = 0x90C7`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_IMAGE_FORMAT_COMPATIBILITY_TYPE: GLenum = 0x90C7;
    #[doc = "`GL_IMAGE_PIXEL_FORMAT: GLenum = 0x82A9`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_IMAGE_PIXEL_FORMAT: GLenum = 0x82A9;
    #[doc = "`GL_IMAGE_PIXEL_TYPE: GLenum = 0x82AA`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_IMAGE_PIXEL_TYPE: GLenum = 0x82AA;
    #[doc = "`GL_IMAGE_TEXEL_SIZE: GLenum = 0x82A7`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_IMAGE_TEXEL_SIZE: GLenum = 0x82A7;
    #[doc = "`GL_IMPLEMENTATION_COLOR_READ_FORMAT: GLenum = 0x8B9B`"]
    #[doc = "* **Groups:** GetFramebufferParameter, GetPName"]
    pub const GL_IMPLEMENTATION_COLOR_READ_FORMAT: GLenum = 0x8B9B;
    #[doc = "`GL_IMPLEMENTATION_COLOR_READ_TYPE: GLenum = 0x8B9A`"]
    #[doc = "* **Groups:** GetFramebufferParameter, GetPName"]
    pub const GL_IMPLEMENTATION_COLOR_READ_TYPE: GLenum = 0x8B9A;
    #[doc = "`GL_INCR: GLenum = 0x1E02`"]
    #[doc = "* **Group:** StencilOp"]
    pub const GL_INCR: GLenum = 0x1E02;
    #[doc = "`GL_INCR_WRAP: GLenum = 0x8507`"]
    #[doc = "* **Group:** StencilOp"]
    pub const GL_INCR_WRAP: GLenum = 0x8507;
    #[doc = "`GL_INFO_LOG_LENGTH: GLenum = 0x8B84`"]
    #[doc = "* **Groups:** ProgramPropertyARB, ShaderParameterName, PipelineParameterName"]
    pub const GL_INFO_LOG_LENGTH: GLenum = 0x8B84;
    #[doc = "`GL_INNOCENT_CONTEXT_RESET: GLenum = 0x8254`"]
    #[doc = "* **Group:** GraphicsResetStatus"]
    pub const GL_INNOCENT_CONTEXT_RESET: GLenum = 0x8254;
    #[doc = "`GL_INT: GLenum = 0x1404`"]
    #[doc = "* **Groups:** VertexAttribIType, SecondaryColorPointerTypeIBM, WeightPointerTypeARB, TangentPointerTypeEXT, BinormalPointerTypeEXT, IndexPointerType, ListNameType, NormalPointerType, PixelType, TexCoordPointerType, VertexPointerType, VertexAttribType, AttributeType, UniformType, VertexAttribPointerType, GlslTypeToken"]
    pub const GL_INT: GLenum = 0x1404;
    #[doc = "`GL_INTERLEAVED_ATTRIBS: GLenum = 0x8C8C`"]
    #[doc = "* **Group:** TransformFeedbackBufferMode"]
    pub const GL_INTERLEAVED_ATTRIBS: GLenum = 0x8C8C;
    #[doc = "`GL_INTERNALFORMAT_ALPHA_SIZE: GLenum = 0x8274`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_ALPHA_SIZE: GLenum = 0x8274;
    #[doc = "`GL_INTERNALFORMAT_ALPHA_TYPE: GLenum = 0x827B`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_ALPHA_TYPE: GLenum = 0x827B;
    #[doc = "`GL_INTERNALFORMAT_BLUE_SIZE: GLenum = 0x8273`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_BLUE_SIZE: GLenum = 0x8273;
    #[doc = "`GL_INTERNALFORMAT_BLUE_TYPE: GLenum = 0x827A`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_BLUE_TYPE: GLenum = 0x827A;
    #[doc = "`GL_INTERNALFORMAT_DEPTH_SIZE: GLenum = 0x8275`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_DEPTH_SIZE: GLenum = 0x8275;
    #[doc = "`GL_INTERNALFORMAT_DEPTH_TYPE: GLenum = 0x827C`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_DEPTH_TYPE: GLenum = 0x827C;
    #[doc = "`GL_INTERNALFORMAT_GREEN_SIZE: GLenum = 0x8272`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_GREEN_SIZE: GLenum = 0x8272;
    #[doc = "`GL_INTERNALFORMAT_GREEN_TYPE: GLenum = 0x8279`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_GREEN_TYPE: GLenum = 0x8279;
    #[doc = "`GL_INTERNALFORMAT_PREFERRED: GLenum = 0x8270`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_PREFERRED: GLenum = 0x8270;
    #[doc = "`GL_INTERNALFORMAT_RED_SIZE: GLenum = 0x8271`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_RED_SIZE: GLenum = 0x8271;
    #[doc = "`GL_INTERNALFORMAT_RED_TYPE: GLenum = 0x8278`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_RED_TYPE: GLenum = 0x8278;
    #[doc = "`GL_INTERNALFORMAT_SHARED_SIZE: GLenum = 0x8277`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_SHARED_SIZE: GLenum = 0x8277;
    #[doc = "`GL_INTERNALFORMAT_STENCIL_SIZE: GLenum = 0x8276`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_STENCIL_SIZE: GLenum = 0x8276;
    #[doc = "`GL_INTERNALFORMAT_STENCIL_TYPE: GLenum = 0x827D`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_STENCIL_TYPE: GLenum = 0x827D;
    #[doc = "`GL_INTERNALFORMAT_SUPPORTED: GLenum = 0x826F`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_INTERNALFORMAT_SUPPORTED: GLenum = 0x826F;
    #[doc = "`GL_INT_2_10_10_10_REV: GLenum = 0x8D9F`"]
    #[doc = "* **Groups:** VertexAttribPointerType, VertexAttribType"]
    pub const GL_INT_2_10_10_10_REV: GLenum = 0x8D9F;
    #[doc = "`GL_INT_IMAGE_1D: GLenum = 0x9057`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_INT_IMAGE_1D: GLenum = 0x9057;
    #[doc = "`GL_INT_IMAGE_1D_ARRAY: GLenum = 0x905D`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_INT_IMAGE_1D_ARRAY: GLenum = 0x905D;
    #[doc = "`GL_INT_IMAGE_2D: GLenum = 0x9058`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_INT_IMAGE_2D: GLenum = 0x9058;
    #[doc = "`GL_INT_IMAGE_2D_ARRAY: GLenum = 0x905E`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_INT_IMAGE_2D_ARRAY: GLenum = 0x905E;
    #[doc = "`GL_INT_IMAGE_2D_MULTISAMPLE: GLenum = 0x9060`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_INT_IMAGE_2D_MULTISAMPLE: GLenum = 0x9060;
    #[doc = "`GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY: GLenum = 0x9061`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY: GLenum = 0x9061;
    #[doc = "`GL_INT_IMAGE_2D_RECT: GLenum = 0x905A`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_INT_IMAGE_2D_RECT: GLenum = 0x905A;
    #[doc = "`GL_INT_IMAGE_3D: GLenum = 0x9059`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_INT_IMAGE_3D: GLenum = 0x9059;
    #[doc = "`GL_INT_IMAGE_BUFFER: GLenum = 0x905C`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_INT_IMAGE_BUFFER: GLenum = 0x905C;
    #[doc = "`GL_INT_IMAGE_CUBE: GLenum = 0x905B`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_INT_IMAGE_CUBE: GLenum = 0x905B;
    #[doc = "`GL_INT_IMAGE_CUBE_MAP_ARRAY: GLenum = 0x905F`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_INT_IMAGE_CUBE_MAP_ARRAY: GLenum = 0x905F;
    #[doc = "`GL_INT_SAMPLER_1D: GLenum = 0x8DC9`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_INT_SAMPLER_1D: GLenum = 0x8DC9;
    #[doc = "`GL_INT_SAMPLER_1D_ARRAY: GLenum = 0x8DCE`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_INT_SAMPLER_1D_ARRAY: GLenum = 0x8DCE;
    #[doc = "`GL_INT_SAMPLER_2D: GLenum = 0x8DCA`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_INT_SAMPLER_2D: GLenum = 0x8DCA;
    #[doc = "`GL_INT_SAMPLER_2D_ARRAY: GLenum = 0x8DCF`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_INT_SAMPLER_2D_ARRAY: GLenum = 0x8DCF;
    #[doc = "`GL_INT_SAMPLER_2D_MULTISAMPLE: GLenum = 0x9109`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_INT_SAMPLER_2D_MULTISAMPLE: GLenum = 0x9109;
    #[doc = "`GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY: GLenum = 0x910C`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY: GLenum = 0x910C;
    #[doc = "`GL_INT_SAMPLER_2D_RECT: GLenum = 0x8DCD`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_INT_SAMPLER_2D_RECT: GLenum = 0x8DCD;
    #[doc = "`GL_INT_SAMPLER_3D: GLenum = 0x8DCB`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_INT_SAMPLER_3D: GLenum = 0x8DCB;
    #[doc = "`GL_INT_SAMPLER_BUFFER: GLenum = 0x8DD0`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_INT_SAMPLER_BUFFER: GLenum = 0x8DD0;
    #[doc = "`GL_INT_SAMPLER_CUBE: GLenum = 0x8DCC`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_INT_SAMPLER_CUBE: GLenum = 0x8DCC;
    #[doc = "`GL_INT_SAMPLER_CUBE_MAP_ARRAY: GLenum = 0x900E`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_INT_SAMPLER_CUBE_MAP_ARRAY: GLenum = 0x900E;
    #[doc = "`GL_INT_VEC2: GLenum = 0x8B53`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_INT_VEC2: GLenum = 0x8B53;
    #[doc = "`GL_INT_VEC3: GLenum = 0x8B54`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_INT_VEC3: GLenum = 0x8B54;
    #[doc = "`GL_INT_VEC4: GLenum = 0x8B55`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_INT_VEC4: GLenum = 0x8B55;
    #[doc = "`GL_INVALID_ENUM: GLenum = 0x0500`"]
    #[doc = "* **Group:** ErrorCode"]
    pub const GL_INVALID_ENUM: GLenum = 0x0500;
    #[doc = "`GL_INVALID_FRAMEBUFFER_OPERATION: GLenum = 0x0506`"]
    #[doc = "* **Group:** ErrorCode"]
    pub const GL_INVALID_FRAMEBUFFER_OPERATION: GLenum = 0x0506;
    #[doc = "`GL_INVALID_INDEX: GLenum = 0xFFFFFFFF`"]
    pub const GL_INVALID_INDEX: GLenum = 0xFFFFFFFF;
    #[doc = "`GL_INVALID_OPERATION: GLenum = 0x0502`"]
    #[doc = "* **Group:** ErrorCode"]
    pub const GL_INVALID_OPERATION: GLenum = 0x0502;
    #[doc = "`GL_INVALID_VALUE: GLenum = 0x0501`"]
    #[doc = "* **Group:** ErrorCode"]
    pub const GL_INVALID_VALUE: GLenum = 0x0501;
    #[doc = "`GL_INVERT: GLenum = 0x150A`"]
    #[doc = "* **Groups:** PathFillMode, LogicOp, StencilOp"]
    pub const GL_INVERT: GLenum = 0x150A;
    #[doc = "`GL_ISOLINES: GLenum = 0x8E7A`"]
    pub const GL_ISOLINES: GLenum = 0x8E7A;
    #[doc = "`GL_IS_PER_PATCH: GLenum = 0x92E7`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_IS_PER_PATCH: GLenum = 0x92E7;
    #[doc = "`GL_IS_ROW_MAJOR: GLenum = 0x9300`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_IS_ROW_MAJOR: GLenum = 0x9300;
    #[doc = "`GL_KEEP: GLenum = 0x1E00`"]
    #[doc = "* **Group:** StencilOp"]
    pub const GL_KEEP: GLenum = 0x1E00;
    #[doc = "`GL_LAST_VERTEX_CONVENTION: GLenum = 0x8E4E`"]
    #[doc = "* **Group:** VertexProvokingMode"]
    pub const GL_LAST_VERTEX_CONVENTION: GLenum = 0x8E4E;
    #[doc = "`GL_LAYER_PROVOKING_VERTEX: GLenum = 0x825E`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_LAYER_PROVOKING_VERTEX: GLenum = 0x825E;
    #[doc = "`GL_LEFT: GLenum = 0x0406`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode"]
    pub const GL_LEFT: GLenum = 0x0406;
    #[doc = "`GL_LEQUAL: GLenum = 0x0203`"]
    #[doc = "* **Groups:** StencilFunction, IndexFunctionEXT, AlphaFunction, DepthFunction"]
    pub const GL_LEQUAL: GLenum = 0x0203;
    #[doc = "`GL_LESS: GLenum = 0x0201`"]
    #[doc = "* **Groups:** StencilFunction, IndexFunctionEXT, AlphaFunction, DepthFunction"]
    pub const GL_LESS: GLenum = 0x0201;
    #[doc = "`GL_LIGHTEN: GLenum = 0x9298`"]
    pub const GL_LIGHTEN: GLenum = 0x9298;
    #[doc = "`GL_LINE: GLenum = 0x1B01`"]
    #[doc = "* **Groups:** PolygonMode, MeshMode1, MeshMode2"]
    pub const GL_LINE: GLenum = 0x1B01;
    #[doc = "`GL_LINEAR: GLenum = 0x2601`"]
    #[doc = "* **Groups:** BlitFramebufferFilter, FogMode, TextureMagFilter, TextureMinFilter"]
    pub const GL_LINEAR: GLenum = 0x2601;
    #[doc = "`GL_LINEAR_MIPMAP_LINEAR: GLenum = 0x2703`"]
    #[doc = "* **Groups:** TextureWrapMode, TextureMinFilter"]
    pub const GL_LINEAR_MIPMAP_LINEAR: GLenum = 0x2703;
    #[doc = "`GL_LINEAR_MIPMAP_NEAREST: GLenum = 0x2701`"]
    #[doc = "* **Group:** TextureMinFilter"]
    pub const GL_LINEAR_MIPMAP_NEAREST: GLenum = 0x2701;
    #[doc = "`GL_LINES: GLenum = 0x0001`"]
    #[doc = "* **Group:** PrimitiveType"]
    pub const GL_LINES: GLenum = 0x0001;
    #[doc = "`GL_LINES_ADJACENCY: GLenum = 0x000A`"]
    #[doc = "* **Group:** PrimitiveType"]
    pub const GL_LINES_ADJACENCY: GLenum = 0x000A;
    #[doc = "`GL_LINE_LOOP: GLenum = 0x0002`"]
    #[doc = "* **Group:** PrimitiveType"]
    pub const GL_LINE_LOOP: GLenum = 0x0002;
    #[doc = "`GL_LINE_SMOOTH: GLenum = 0x0B20`"]
    #[doc = "* **Groups:** GetPName, EnableCap"]
    pub const GL_LINE_SMOOTH: GLenum = 0x0B20;
    #[doc = "`GL_LINE_SMOOTH_HINT: GLenum = 0x0C52`"]
    #[doc = "* **Groups:** HintTarget, GetPName"]
    pub const GL_LINE_SMOOTH_HINT: GLenum = 0x0C52;
    #[doc = "`GL_LINE_STRIP: GLenum = 0x0003`"]
    #[doc = "* **Group:** PrimitiveType"]
    pub const GL_LINE_STRIP: GLenum = 0x0003;
    #[doc = "`GL_LINE_STRIP_ADJACENCY: GLenum = 0x000B`"]
    #[doc = "* **Group:** PrimitiveType"]
    pub const GL_LINE_STRIP_ADJACENCY: GLenum = 0x000B;
    #[doc = "`GL_LINE_WIDTH: GLenum = 0x0B21`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_LINE_WIDTH: GLenum = 0x0B21;
    #[doc = "`GL_LINE_WIDTH_GRANULARITY: GLenum = 0x0B23`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_LINE_WIDTH_GRANULARITY: GLenum = 0x0B23;
    #[doc = "`GL_LINE_WIDTH_RANGE: GLenum = 0x0B22`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_LINE_WIDTH_RANGE: GLenum = 0x0B22;
    #[doc = "`GL_LINK_STATUS: GLenum = 0x8B82`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_LINK_STATUS: GLenum = 0x8B82;
    #[doc = "`GL_LOCATION: GLenum = 0x930E`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_LOCATION: GLenum = 0x930E;
    #[doc = "`GL_LOCATION_COMPONENT: GLenum = 0x934A`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_LOCATION_COMPONENT: GLenum = 0x934A;
    #[doc = "`GL_LOCATION_INDEX: GLenum = 0x930F`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_LOCATION_INDEX: GLenum = 0x930F;
    #[doc = "`GL_LOGIC_OP_MODE: GLenum = 0x0BF0`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_LOGIC_OP_MODE: GLenum = 0x0BF0;
    #[doc = "`GL_LOSE_CONTEXT_ON_RESET: GLenum = 0x8252`"]
    pub const GL_LOSE_CONTEXT_ON_RESET: GLenum = 0x8252;
    #[doc = "`GL_LOWER_LEFT: GLenum = 0x8CA1`"]
    #[doc = "* **Group:** ClipControlOrigin"]
    pub const GL_LOWER_LEFT: GLenum = 0x8CA1;
    #[doc = "`GL_LOW_FLOAT: GLenum = 0x8DF0`"]
    #[doc = "* **Group:** PrecisionType"]
    pub const GL_LOW_FLOAT: GLenum = 0x8DF0;
    #[doc = "`GL_LOW_INT: GLenum = 0x8DF3`"]
    #[doc = "* **Group:** PrecisionType"]
    pub const GL_LOW_INT: GLenum = 0x8DF3;
    #[doc = "`GL_LUMINANCE: GLenum = 0x1909`"]
    #[doc = "* **Groups:** PixelTexGenMode, PathColorFormat, PixelFormat"]
    pub const GL_LUMINANCE: GLenum = 0x1909;
    #[doc = "`GL_LUMINANCE_ALPHA: GLenum = 0x190A`"]
    #[doc = "* **Groups:** PixelTexGenMode, PathColorFormat, PixelFormat"]
    pub const GL_LUMINANCE_ALPHA: GLenum = 0x190A;
    #[doc = "`GL_MAJOR_VERSION: GLenum = 0x821B`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAJOR_VERSION: GLenum = 0x821B;
    #[doc = "`GL_MANUAL_GENERATE_MIPMAP: GLenum = 0x8294`"]
    pub const GL_MANUAL_GENERATE_MIPMAP: GLenum = 0x8294;
    #[doc = "`GL_MAP_COHERENT_BIT: GLbitfield = 0x0080`"]
    #[doc = "* **Groups:** MapBufferAccessMask, BufferStorageMask"]
    pub const GL_MAP_COHERENT_BIT: GLbitfield = 0x0080;
    #[doc = "`GL_MAP_COHERENT_BIT_EXT: GLbitfield = 0x0080`"]
    #[doc = "* **Groups:** MapBufferAccessMask, BufferStorageMask"]

    pub const GL_MAP_COHERENT_BIT_EXT: GLbitfield = 0x0080;
    #[doc = "`GL_MAP_FLUSH_EXPLICIT_BIT: GLbitfield = 0x0010`"]
    #[doc = "* **Group:** MapBufferAccessMask"]
    pub const GL_MAP_FLUSH_EXPLICIT_BIT: GLbitfield = 0x0010;
    #[doc = "`GL_MAP_INVALIDATE_BUFFER_BIT: GLbitfield = 0x0008`"]
    #[doc = "* **Group:** MapBufferAccessMask"]
    pub const GL_MAP_INVALIDATE_BUFFER_BIT: GLbitfield = 0x0008;
    #[doc = "`GL_MAP_INVALIDATE_RANGE_BIT: GLbitfield = 0x0004`"]
    #[doc = "* **Group:** MapBufferAccessMask"]
    pub const GL_MAP_INVALIDATE_RANGE_BIT: GLbitfield = 0x0004;
    #[doc = "`GL_MAP_PERSISTENT_BIT: GLbitfield = 0x0040`"]
    #[doc = "* **Groups:** MapBufferAccessMask, BufferStorageMask"]
    pub const GL_MAP_PERSISTENT_BIT: GLbitfield = 0x0040;
    #[doc = "`GL_MAP_PERSISTENT_BIT_EXT: GLbitfield = 0x0040`"]
    #[doc = "* **Groups:** MapBufferAccessMask, BufferStorageMask"]

    pub const GL_MAP_PERSISTENT_BIT_EXT: GLbitfield = 0x0040;
    #[doc = "`GL_MAP_READ_BIT: GLbitfield = 0x0001`"]
    #[doc = "* **Groups:** MapBufferAccessMask, BufferStorageMask"]
    pub const GL_MAP_READ_BIT: GLbitfield = 0x0001;
    #[doc = "`GL_MAP_UNSYNCHRONIZED_BIT: GLbitfield = 0x0020`"]
    #[doc = "* **Group:** MapBufferAccessMask"]
    pub const GL_MAP_UNSYNCHRONIZED_BIT: GLbitfield = 0x0020;
    #[doc = "`GL_MAP_WRITE_BIT: GLbitfield = 0x0002`"]
    #[doc = "* **Groups:** MapBufferAccessMask, BufferStorageMask"]
    pub const GL_MAP_WRITE_BIT: GLbitfield = 0x0002;
    #[doc = "`GL_MATRIX_STRIDE: GLenum = 0x92FF`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_MATRIX_STRIDE: GLenum = 0x92FF;
    #[doc = "`GL_MAX: GLenum = 0x8008`"]
    #[doc = "* **Group:** BlendEquationModeEXT"]
    pub const GL_MAX: GLenum = 0x8008;
    #[doc = "`GL_MAX_3D_TEXTURE_SIZE: GLenum = 0x8073`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_3D_TEXTURE_SIZE: GLenum = 0x8073;
    #[doc = "`GL_MAX_ARRAY_TEXTURE_LAYERS: GLenum = 0x88FF`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_ARRAY_TEXTURE_LAYERS: GLenum = 0x88FF;
    #[doc = "`GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS: GLenum = 0x92DC`"]
    pub const GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS: GLenum = 0x92DC;
    #[doc = "`GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE: GLenum = 0x92D8`"]
    pub const GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE: GLenum = 0x92D8;
    #[doc = "`GL_MAX_CLIP_DISTANCES: GLenum = 0x0D32`"]
    #[doc = "* **Group:** GetPName"]
    #[doc = "* **Alias Of:** `GL_MAX_CLIP_PLANES`"]
    pub const GL_MAX_CLIP_DISTANCES: GLenum = 0x0D32;
    #[doc = "`GL_MAX_COLOR_ATTACHMENTS: GLenum = 0x8CDF`"]
    pub const GL_MAX_COLOR_ATTACHMENTS: GLenum = 0x8CDF;
    #[doc = "`GL_MAX_COLOR_TEXTURE_SAMPLES: GLenum = 0x910E`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COLOR_TEXTURE_SAMPLES: GLenum = 0x910E;
    #[doc = "`GL_MAX_COMBINED_ATOMIC_COUNTERS: GLenum = 0x92D7`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMBINED_ATOMIC_COUNTERS: GLenum = 0x92D7;
    #[doc = "`GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS: GLenum = 0x92D1`"]
    pub const GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS: GLenum = 0x92D1;
    #[doc = "`GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES: GLenum = 0x82FA`"]
    pub const GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES: GLenum = 0x82FA;
    #[doc = "`GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS: GLenum = 0x8266`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS: GLenum = 0x8266;
    #[doc = "`GL_MAX_COMBINED_DIMENSIONS: GLenum = 0x8282`"]
    pub const GL_MAX_COMBINED_DIMENSIONS: GLenum = 0x8282;
    #[doc = "`GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS: GLenum = 0x8A33`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS: GLenum = 0x8A33;
    #[doc = "`GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS: GLenum = 0x8A32`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS: GLenum = 0x8A32;
    #[doc = "`GL_MAX_COMBINED_IMAGE_UNIFORMS: GLenum = 0x90CF`"]
    pub const GL_MAX_COMBINED_IMAGE_UNIFORMS: GLenum = 0x90CF;
    #[doc = "`GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS: GLenum = 0x8F39`"]
    pub const GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS: GLenum = 0x8F39;
    #[doc = "`GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES: GLenum = 0x8F39`"]
    #[doc = "* **Alias Of:** `GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS`"]
    pub const GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES: GLenum = 0x8F39;
    #[doc = "`GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS: GLenum = 0x90DC`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS: GLenum = 0x90DC;
    #[doc = "`GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS: GLenum = 0x8E1E`"]
    pub const GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS: GLenum = 0x8E1E;
    #[doc = "`GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS: GLenum = 0x8E1F`"]
    pub const GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS: GLenum = 0x8E1F;
    #[doc = "`GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS: GLenum = 0x8B4D`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS: GLenum = 0x8B4D;
    #[doc = "`GL_MAX_COMBINED_UNIFORM_BLOCKS: GLenum = 0x8A2E`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMBINED_UNIFORM_BLOCKS: GLenum = 0x8A2E;
    #[doc = "`GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS: GLenum = 0x8A31`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS: GLenum = 0x8A31;
    #[doc = "`GL_MAX_COMPUTE_ATOMIC_COUNTERS: GLenum = 0x8265`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMPUTE_ATOMIC_COUNTERS: GLenum = 0x8265;
    #[doc = "`GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS: GLenum = 0x8264`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS: GLenum = 0x8264;
    #[doc = "`GL_MAX_COMPUTE_IMAGE_UNIFORMS: GLenum = 0x91BD`"]
    pub const GL_MAX_COMPUTE_IMAGE_UNIFORMS: GLenum = 0x91BD;
    #[doc = "`GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS: GLenum = 0x90DB`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS: GLenum = 0x90DB;
    #[doc = "`GL_MAX_COMPUTE_SHARED_MEMORY_SIZE: GLenum = 0x8262`"]
    pub const GL_MAX_COMPUTE_SHARED_MEMORY_SIZE: GLenum = 0x8262;
    #[doc = "`GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS: GLenum = 0x91BC`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS: GLenum = 0x91BC;
    #[doc = "`GL_MAX_COMPUTE_UNIFORM_BLOCKS: GLenum = 0x91BB`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMPUTE_UNIFORM_BLOCKS: GLenum = 0x91BB;
    #[doc = "`GL_MAX_COMPUTE_UNIFORM_COMPONENTS: GLenum = 0x8263`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMPUTE_UNIFORM_COMPONENTS: GLenum = 0x8263;
    #[doc = "`GL_MAX_COMPUTE_WORK_GROUP_COUNT: GLenum = 0x91BE`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMPUTE_WORK_GROUP_COUNT: GLenum = 0x91BE;
    #[doc = "`GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS: GLenum = 0x90EB`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS: GLenum = 0x90EB;
    #[doc = "`GL_MAX_COMPUTE_WORK_GROUP_SIZE: GLenum = 0x91BF`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_COMPUTE_WORK_GROUP_SIZE: GLenum = 0x91BF;
    #[doc = "`GL_MAX_CUBE_MAP_TEXTURE_SIZE: GLenum = 0x851C`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_CUBE_MAP_TEXTURE_SIZE: GLenum = 0x851C;
    #[doc = "`GL_MAX_CULL_DISTANCES: GLenum = 0x82F9`"]
    pub const GL_MAX_CULL_DISTANCES: GLenum = 0x82F9;
    #[doc = "`GL_MAX_DEBUG_GROUP_STACK_DEPTH: GLenum = 0x826C`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_DEBUG_GROUP_STACK_DEPTH: GLenum = 0x826C;
    #[doc = "`GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR: GLenum = 0x826C`"]

    pub const GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR: GLenum = 0x826C;
    #[doc = "`GL_MAX_DEBUG_LOGGED_MESSAGES: GLenum = 0x9144`"]
    pub const GL_MAX_DEBUG_LOGGED_MESSAGES: GLenum = 0x9144;
    #[doc = "`GL_MAX_DEBUG_LOGGED_MESSAGES_ARB: GLenum = 0x9144`"]

    pub const GL_MAX_DEBUG_LOGGED_MESSAGES_ARB: GLenum = 0x9144;
    #[doc = "`GL_MAX_DEBUG_LOGGED_MESSAGES_KHR: GLenum = 0x9144`"]

    pub const GL_MAX_DEBUG_LOGGED_MESSAGES_KHR: GLenum = 0x9144;
    #[doc = "`GL_MAX_DEBUG_MESSAGE_LENGTH: GLenum = 0x9143`"]
    pub const GL_MAX_DEBUG_MESSAGE_LENGTH: GLenum = 0x9143;
    #[doc = "`GL_MAX_DEBUG_MESSAGE_LENGTH_ARB: GLenum = 0x9143`"]

    pub const GL_MAX_DEBUG_MESSAGE_LENGTH_ARB: GLenum = 0x9143;
    #[doc = "`GL_MAX_DEBUG_MESSAGE_LENGTH_KHR: GLenum = 0x9143`"]

    pub const GL_MAX_DEBUG_MESSAGE_LENGTH_KHR: GLenum = 0x9143;
    #[doc = "`GL_MAX_DEPTH: GLenum = 0x8280`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_MAX_DEPTH: GLenum = 0x8280;
    #[doc = "`GL_MAX_DEPTH_TEXTURE_SAMPLES: GLenum = 0x910F`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_DEPTH_TEXTURE_SAMPLES: GLenum = 0x910F;
    #[doc = "`GL_MAX_DRAW_BUFFERS: GLenum = 0x8824`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_DRAW_BUFFERS: GLenum = 0x8824;
    #[doc = "`GL_MAX_DUAL_SOURCE_DRAW_BUFFERS: GLenum = 0x88FC`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_DUAL_SOURCE_DRAW_BUFFERS: GLenum = 0x88FC;
    #[doc = "`GL_MAX_ELEMENTS_INDICES: GLenum = 0x80E9`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_ELEMENTS_INDICES: GLenum = 0x80E9;
    #[doc = "`GL_MAX_ELEMENTS_VERTICES: GLenum = 0x80E8`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_ELEMENTS_VERTICES: GLenum = 0x80E8;
    #[doc = "`GL_MAX_ELEMENT_INDEX: GLenum = 0x8D6B`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_ELEMENT_INDEX: GLenum = 0x8D6B;
    #[doc = "`GL_MAX_FRAGMENT_ATOMIC_COUNTERS: GLenum = 0x92D6`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_FRAGMENT_ATOMIC_COUNTERS: GLenum = 0x92D6;
    #[doc = "`GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS: GLenum = 0x92D0`"]
    pub const GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS: GLenum = 0x92D0;
    #[doc = "`GL_MAX_FRAGMENT_IMAGE_UNIFORMS: GLenum = 0x90CE`"]
    pub const GL_MAX_FRAGMENT_IMAGE_UNIFORMS: GLenum = 0x90CE;
    #[doc = "`GL_MAX_FRAGMENT_INPUT_COMPONENTS: GLenum = 0x9125`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_FRAGMENT_INPUT_COMPONENTS: GLenum = 0x9125;
    #[doc = "`GL_MAX_FRAGMENT_INTERPOLATION_OFFSET: GLenum = 0x8E5C`"]
    pub const GL_MAX_FRAGMENT_INTERPOLATION_OFFSET: GLenum = 0x8E5C;
    #[doc = "`GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS: GLenum = 0x90DA`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS: GLenum = 0x90DA;
    #[doc = "`GL_MAX_FRAGMENT_UNIFORM_BLOCKS: GLenum = 0x8A2D`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_FRAGMENT_UNIFORM_BLOCKS: GLenum = 0x8A2D;
    #[doc = "`GL_MAX_FRAGMENT_UNIFORM_COMPONENTS: GLenum = 0x8B49`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_FRAGMENT_UNIFORM_COMPONENTS: GLenum = 0x8B49;
    #[doc = "`GL_MAX_FRAGMENT_UNIFORM_VECTORS: GLenum = 0x8DFD`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_FRAGMENT_UNIFORM_VECTORS: GLenum = 0x8DFD;
    #[doc = "`GL_MAX_FRAMEBUFFER_HEIGHT: GLenum = 0x9316`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_FRAMEBUFFER_HEIGHT: GLenum = 0x9316;
    #[doc = "`GL_MAX_FRAMEBUFFER_LAYERS: GLenum = 0x9317`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_FRAMEBUFFER_LAYERS: GLenum = 0x9317;
    #[doc = "`GL_MAX_FRAMEBUFFER_SAMPLES: GLenum = 0x9318`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_FRAMEBUFFER_SAMPLES: GLenum = 0x9318;
    #[doc = "`GL_MAX_FRAMEBUFFER_WIDTH: GLenum = 0x9315`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_FRAMEBUFFER_WIDTH: GLenum = 0x9315;
    #[doc = "`GL_MAX_GEOMETRY_ATOMIC_COUNTERS: GLenum = 0x92D5`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_GEOMETRY_ATOMIC_COUNTERS: GLenum = 0x92D5;
    #[doc = "`GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS: GLenum = 0x92CF`"]
    pub const GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS: GLenum = 0x92CF;
    #[doc = "`GL_MAX_GEOMETRY_IMAGE_UNIFORMS: GLenum = 0x90CD`"]
    pub const GL_MAX_GEOMETRY_IMAGE_UNIFORMS: GLenum = 0x90CD;
    #[doc = "`GL_MAX_GEOMETRY_INPUT_COMPONENTS: GLenum = 0x9123`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_GEOMETRY_INPUT_COMPONENTS: GLenum = 0x9123;
    #[doc = "`GL_MAX_GEOMETRY_OUTPUT_COMPONENTS: GLenum = 0x9124`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_GEOMETRY_OUTPUT_COMPONENTS: GLenum = 0x9124;
    #[doc = "`GL_MAX_GEOMETRY_OUTPUT_VERTICES: GLenum = 0x8DE0`"]
    pub const GL_MAX_GEOMETRY_OUTPUT_VERTICES: GLenum = 0x8DE0;
    #[doc = "`GL_MAX_GEOMETRY_SHADER_INVOCATIONS: GLenum = 0x8E5A`"]
    pub const GL_MAX_GEOMETRY_SHADER_INVOCATIONS: GLenum = 0x8E5A;
    #[doc = "`GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS: GLenum = 0x90D7`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS: GLenum = 0x90D7;
    #[doc = "`GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS: GLenum = 0x8C29`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS: GLenum = 0x8C29;
    #[doc = "`GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS: GLenum = 0x8DE1`"]
    pub const GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS: GLenum = 0x8DE1;
    #[doc = "`GL_MAX_GEOMETRY_UNIFORM_BLOCKS: GLenum = 0x8A2C`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_GEOMETRY_UNIFORM_BLOCKS: GLenum = 0x8A2C;
    #[doc = "`GL_MAX_GEOMETRY_UNIFORM_COMPONENTS: GLenum = 0x8DDF`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_GEOMETRY_UNIFORM_COMPONENTS: GLenum = 0x8DDF;
    #[doc = "`GL_MAX_HEIGHT: GLenum = 0x827F`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_MAX_HEIGHT: GLenum = 0x827F;
    #[doc = "`GL_MAX_IMAGE_SAMPLES: GLenum = 0x906D`"]
    pub const GL_MAX_IMAGE_SAMPLES: GLenum = 0x906D;
    #[doc = "`GL_MAX_IMAGE_UNITS: GLenum = 0x8F38`"]
    pub const GL_MAX_IMAGE_UNITS: GLenum = 0x8F38;
    #[doc = "`GL_MAX_INTEGER_SAMPLES: GLenum = 0x9110`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_INTEGER_SAMPLES: GLenum = 0x9110;
    #[doc = "`GL_MAX_LABEL_LENGTH: GLenum = 0x82E8`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_LABEL_LENGTH: GLenum = 0x82E8;
    #[doc = "`GL_MAX_LABEL_LENGTH_KHR: GLenum = 0x82E8`"]

    pub const GL_MAX_LABEL_LENGTH_KHR: GLenum = 0x82E8;
    #[doc = "`GL_MAX_LAYERS: GLenum = 0x8281`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_MAX_LAYERS: GLenum = 0x8281;
    #[doc = "`GL_MAX_NAME_LENGTH: GLenum = 0x92F6`"]
    #[doc = "* **Group:** ProgramInterfacePName"]
    pub const GL_MAX_NAME_LENGTH: GLenum = 0x92F6;
    #[doc = "`GL_MAX_NUM_ACTIVE_VARIABLES: GLenum = 0x92F7`"]
    #[doc = "* **Group:** ProgramInterfacePName"]
    pub const GL_MAX_NUM_ACTIVE_VARIABLES: GLenum = 0x92F7;
    #[doc = "`GL_MAX_NUM_COMPATIBLE_SUBROUTINES: GLenum = 0x92F8`"]
    #[doc = "* **Group:** ProgramInterfacePName"]
    pub const GL_MAX_NUM_COMPATIBLE_SUBROUTINES: GLenum = 0x92F8;
    #[doc = "`GL_MAX_PATCH_VERTICES: GLenum = 0x8E7D`"]
    pub const GL_MAX_PATCH_VERTICES: GLenum = 0x8E7D;
    #[doc = "`GL_MAX_PROGRAM_TEXEL_OFFSET: GLenum = 0x8905`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_PROGRAM_TEXEL_OFFSET: GLenum = 0x8905;
    #[doc = "`GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET: GLenum = 0x8E5F`"]
    pub const GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET: GLenum = 0x8E5F;
    #[doc = "`GL_MAX_RECTANGLE_TEXTURE_SIZE: GLenum = 0x84F8`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_RECTANGLE_TEXTURE_SIZE: GLenum = 0x84F8;
    #[doc = "`GL_MAX_RENDERBUFFER_SIZE: GLenum = 0x84E8`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_RENDERBUFFER_SIZE: GLenum = 0x84E8;
    #[doc = "`GL_MAX_SAMPLES: GLenum = 0x8D57`"]
    pub const GL_MAX_SAMPLES: GLenum = 0x8D57;
    #[doc = "`GL_MAX_SAMPLE_MASK_WORDS: GLenum = 0x8E59`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_SAMPLE_MASK_WORDS: GLenum = 0x8E59;
    #[doc = "`GL_MAX_SERVER_WAIT_TIMEOUT: GLenum = 0x9111`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_SERVER_WAIT_TIMEOUT: GLenum = 0x9111;
    #[doc = "`GL_MAX_SHADER_COMPILER_THREADS_ARB: GLenum = 0x91B0`"]
    #[doc = "* **Alias Of:** `GL_MAX_SHADER_COMPILER_THREADS_KHR`"]

    pub const GL_MAX_SHADER_COMPILER_THREADS_ARB: GLenum = 0x91B0;
    #[doc = "`GL_MAX_SHADER_COMPILER_THREADS_KHR: GLenum = 0x91B0`"]

    pub const GL_MAX_SHADER_COMPILER_THREADS_KHR: GLenum = 0x91B0;
    #[doc = "`GL_MAX_SHADER_STORAGE_BLOCK_SIZE: GLenum = 0x90DE`"]
    pub const GL_MAX_SHADER_STORAGE_BLOCK_SIZE: GLenum = 0x90DE;
    #[doc = "`GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS: GLenum = 0x90DD`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS: GLenum = 0x90DD;
    #[doc = "`GL_MAX_SUBROUTINES: GLenum = 0x8DE7`"]
    pub const GL_MAX_SUBROUTINES: GLenum = 0x8DE7;
    #[doc = "`GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS: GLenum = 0x8DE8`"]
    pub const GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS: GLenum = 0x8DE8;
    #[doc = "`GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS: GLenum = 0x92D3`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS: GLenum = 0x92D3;
    #[doc = "`GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS: GLenum = 0x92CD`"]
    pub const GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS: GLenum = 0x92CD;
    #[doc = "`GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS: GLenum = 0x90CB`"]
    pub const GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS: GLenum = 0x90CB;
    #[doc = "`GL_MAX_TESS_CONTROL_INPUT_COMPONENTS: GLenum = 0x886C`"]
    pub const GL_MAX_TESS_CONTROL_INPUT_COMPONENTS: GLenum = 0x886C;
    #[doc = "`GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS: GLenum = 0x8E83`"]
    pub const GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS: GLenum = 0x8E83;
    #[doc = "`GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS: GLenum = 0x90D8`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS: GLenum = 0x90D8;
    #[doc = "`GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS: GLenum = 0x8E81`"]
    pub const GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS: GLenum = 0x8E81;
    #[doc = "`GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS: GLenum = 0x8E85`"]
    pub const GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS: GLenum = 0x8E85;
    #[doc = "`GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS: GLenum = 0x8E89`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS: GLenum = 0x8E89;
    #[doc = "`GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS: GLenum = 0x8E7F`"]
    pub const GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS: GLenum = 0x8E7F;
    #[doc = "`GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS: GLenum = 0x92D4`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS: GLenum = 0x92D4;
    #[doc = "`GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS: GLenum = 0x92CE`"]
    pub const GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS: GLenum = 0x92CE;
    #[doc = "`GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS: GLenum = 0x90CC`"]
    pub const GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS: GLenum = 0x90CC;
    #[doc = "`GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS: GLenum = 0x886D`"]
    pub const GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS: GLenum = 0x886D;
    #[doc = "`GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS: GLenum = 0x8E86`"]
    pub const GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS: GLenum = 0x8E86;
    #[doc = "`GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS: GLenum = 0x90D9`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS: GLenum = 0x90D9;
    #[doc = "`GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS: GLenum = 0x8E82`"]
    pub const GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS: GLenum = 0x8E82;
    #[doc = "`GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS: GLenum = 0x8E8A`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS: GLenum = 0x8E8A;
    #[doc = "`GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS: GLenum = 0x8E80`"]
    pub const GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS: GLenum = 0x8E80;
    #[doc = "`GL_MAX_TESS_GEN_LEVEL: GLenum = 0x8E7E`"]
    pub const GL_MAX_TESS_GEN_LEVEL: GLenum = 0x8E7E;
    #[doc = "`GL_MAX_TESS_PATCH_COMPONENTS: GLenum = 0x8E84`"]
    pub const GL_MAX_TESS_PATCH_COMPONENTS: GLenum = 0x8E84;
    #[doc = "`GL_MAX_TEXTURE_BUFFER_SIZE: GLenum = 0x8C2B`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_TEXTURE_BUFFER_SIZE: GLenum = 0x8C2B;
    #[doc = "`GL_MAX_TEXTURE_IMAGE_UNITS: GLenum = 0x8872`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_TEXTURE_IMAGE_UNITS: GLenum = 0x8872;
    #[doc = "`GL_MAX_TEXTURE_LOD_BIAS: GLenum = 0x84FD`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_TEXTURE_LOD_BIAS: GLenum = 0x84FD;
    #[doc = "`GL_MAX_TEXTURE_MAX_ANISOTROPY: GLenum = 0x84FF`"]
    pub const GL_MAX_TEXTURE_MAX_ANISOTROPY: GLenum = 0x84FF;
    #[doc = "`GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT: GLenum = 0x84FF`"]
    #[doc = "* **Alias Of:** `GL_MAX_TEXTURE_MAX_ANISOTROPY`"]

    pub const GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT: GLenum = 0x84FF;
    #[doc = "`GL_MAX_TEXTURE_SIZE: GLenum = 0x0D33`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_TEXTURE_SIZE: GLenum = 0x0D33;
    #[doc = "`GL_MAX_TRANSFORM_FEEDBACK_BUFFERS: GLenum = 0x8E70`"]
    pub const GL_MAX_TRANSFORM_FEEDBACK_BUFFERS: GLenum = 0x8E70;
    #[doc = "`GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS: GLenum = 0x8C8A`"]
    pub const GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS: GLenum = 0x8C8A;
    #[doc = "`GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS: GLenum = 0x8C8B`"]
    pub const GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS: GLenum = 0x8C8B;
    #[doc = "`GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS: GLenum = 0x8C80`"]
    pub const GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS: GLenum = 0x8C80;
    #[doc = "`GL_MAX_UNIFORM_BLOCK_SIZE: GLenum = 0x8A30`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_UNIFORM_BLOCK_SIZE: GLenum = 0x8A30;
    #[doc = "`GL_MAX_UNIFORM_BUFFER_BINDINGS: GLenum = 0x8A2F`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_UNIFORM_BUFFER_BINDINGS: GLenum = 0x8A2F;
    #[doc = "`GL_MAX_UNIFORM_LOCATIONS: GLenum = 0x826E`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_UNIFORM_LOCATIONS: GLenum = 0x826E;
    #[doc = "`GL_MAX_VARYING_COMPONENTS: GLenum = 0x8B4B`"]
    #[doc = "* **Group:** GetPName"]
    #[doc = "* **Alias Of:** `MAX_VARYING_FLOATS`"]
    pub const GL_MAX_VARYING_COMPONENTS: GLenum = 0x8B4B;
    #[doc = "`GL_MAX_VARYING_FLOATS: GLenum = 0x8B4B`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_VARYING_FLOATS: GLenum = 0x8B4B;
    #[doc = "`GL_MAX_VARYING_VECTORS: GLenum = 0x8DFC`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_VARYING_VECTORS: GLenum = 0x8DFC;
    #[doc = "`GL_MAX_VERTEX_ATOMIC_COUNTERS: GLenum = 0x92D2`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_VERTEX_ATOMIC_COUNTERS: GLenum = 0x92D2;
    #[doc = "`GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS: GLenum = 0x92CC`"]
    pub const GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS: GLenum = 0x92CC;
    #[doc = "`GL_MAX_VERTEX_ATTRIBS: GLenum = 0x8869`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_VERTEX_ATTRIBS: GLenum = 0x8869;
    #[doc = "`GL_MAX_VERTEX_ATTRIB_BINDINGS: GLenum = 0x82DA`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_VERTEX_ATTRIB_BINDINGS: GLenum = 0x82DA;
    #[doc = "`GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET: GLenum = 0x82D9`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET: GLenum = 0x82D9;
    #[doc = "`GL_MAX_VERTEX_ATTRIB_STRIDE: GLenum = 0x82E5`"]
    pub const GL_MAX_VERTEX_ATTRIB_STRIDE: GLenum = 0x82E5;
    #[doc = "`GL_MAX_VERTEX_IMAGE_UNIFORMS: GLenum = 0x90CA`"]
    pub const GL_MAX_VERTEX_IMAGE_UNIFORMS: GLenum = 0x90CA;
    #[doc = "`GL_MAX_VERTEX_OUTPUT_COMPONENTS: GLenum = 0x9122`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_VERTEX_OUTPUT_COMPONENTS: GLenum = 0x9122;
    #[doc = "`GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS: GLenum = 0x90D6`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS: GLenum = 0x90D6;
    #[doc = "`GL_MAX_VERTEX_STREAMS: GLenum = 0x8E71`"]
    pub const GL_MAX_VERTEX_STREAMS: GLenum = 0x8E71;
    #[doc = "`GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS: GLenum = 0x8B4C`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS: GLenum = 0x8B4C;
    #[doc = "`GL_MAX_VERTEX_UNIFORM_BLOCKS: GLenum = 0x8A2B`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_VERTEX_UNIFORM_BLOCKS: GLenum = 0x8A2B;
    #[doc = "`GL_MAX_VERTEX_UNIFORM_COMPONENTS: GLenum = 0x8B4A`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_VERTEX_UNIFORM_COMPONENTS: GLenum = 0x8B4A;
    #[doc = "`GL_MAX_VERTEX_UNIFORM_VECTORS: GLenum = 0x8DFB`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_VERTEX_UNIFORM_VECTORS: GLenum = 0x8DFB;
    #[doc = "`GL_MAX_VIEWPORTS: GLenum = 0x825B`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_VIEWPORTS: GLenum = 0x825B;
    #[doc = "`GL_MAX_VIEWPORT_DIMS: GLenum = 0x0D3A`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MAX_VIEWPORT_DIMS: GLenum = 0x0D3A;
    #[doc = "`GL_MAX_WIDTH: GLenum = 0x827E`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_MAX_WIDTH: GLenum = 0x827E;
    #[doc = "`GL_MEDIUM_FLOAT: GLenum = 0x8DF1`"]
    #[doc = "* **Group:** PrecisionType"]
    pub const GL_MEDIUM_FLOAT: GLenum = 0x8DF1;
    #[doc = "`GL_MEDIUM_INT: GLenum = 0x8DF4`"]
    #[doc = "* **Group:** PrecisionType"]
    pub const GL_MEDIUM_INT: GLenum = 0x8DF4;
    #[doc = "`GL_MIN: GLenum = 0x8007`"]
    #[doc = "* **Group:** BlendEquationModeEXT"]
    pub const GL_MIN: GLenum = 0x8007;
    #[doc = "`GL_MINOR_VERSION: GLenum = 0x821C`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MINOR_VERSION: GLenum = 0x821C;
    #[doc = "`GL_MIN_FRAGMENT_INTERPOLATION_OFFSET: GLenum = 0x8E5B`"]
    pub const GL_MIN_FRAGMENT_INTERPOLATION_OFFSET: GLenum = 0x8E5B;
    #[doc = "`GL_MIN_MAP_BUFFER_ALIGNMENT: GLenum = 0x90BC`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MIN_MAP_BUFFER_ALIGNMENT: GLenum = 0x90BC;
    #[doc = "`GL_MIN_PROGRAM_TEXEL_OFFSET: GLenum = 0x8904`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_MIN_PROGRAM_TEXEL_OFFSET: GLenum = 0x8904;
    #[doc = "`GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET: GLenum = 0x8E5E`"]
    pub const GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET: GLenum = 0x8E5E;
    #[doc = "`GL_MIN_SAMPLE_SHADING_VALUE: GLenum = 0x8C37`"]
    pub const GL_MIN_SAMPLE_SHADING_VALUE: GLenum = 0x8C37;
    #[doc = "`GL_MIPMAP: GLenum = 0x8293`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_MIPMAP: GLenum = 0x8293;
    #[doc = "`GL_MIRRORED_REPEAT: GLenum = 0x8370`"]
    #[doc = "* **Group:** TextureWrapMode"]
    pub const GL_MIRRORED_REPEAT: GLenum = 0x8370;
    #[doc = "`GL_MIRROR_CLAMP_TO_EDGE: GLenum = 0x8743`"]
    pub const GL_MIRROR_CLAMP_TO_EDGE: GLenum = 0x8743;
    #[doc = "`GL_MULTIPLY: GLenum = 0x9294`"]
    pub const GL_MULTIPLY: GLenum = 0x9294;
    #[doc = "`GL_MULTISAMPLE: GLenum = 0x809D`"]
    #[doc = "* **Group:** EnableCap"]
    pub const GL_MULTISAMPLE: GLenum = 0x809D;
    #[doc = "`GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY: GLenum = 0x9382`"]
    pub const GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY: GLenum = 0x9382;
    #[doc = "`GL_MULTISAMPLE_LINE_WIDTH_RANGE: GLenum = 0x9381`"]
    pub const GL_MULTISAMPLE_LINE_WIDTH_RANGE: GLenum = 0x9381;
    #[doc = "`GL_NAME_LENGTH: GLenum = 0x92F9`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_NAME_LENGTH: GLenum = 0x92F9;
    #[doc = "`GL_NAND: GLenum = 0x150E`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_NAND: GLenum = 0x150E;
    #[doc = "`GL_NEAREST: GLenum = 0x2600`"]
    #[doc = "* **Groups:** BlitFramebufferFilter, TextureMagFilter, TextureMinFilter"]
    pub const GL_NEAREST: GLenum = 0x2600;
    #[doc = "`GL_NEAREST_MIPMAP_LINEAR: GLenum = 0x2702`"]
    #[doc = "* **Group:** TextureMinFilter"]
    pub const GL_NEAREST_MIPMAP_LINEAR: GLenum = 0x2702;
    #[doc = "`GL_NEAREST_MIPMAP_NEAREST: GLenum = 0x2700`"]
    #[doc = "* **Group:** TextureMinFilter"]
    pub const GL_NEAREST_MIPMAP_NEAREST: GLenum = 0x2700;
    #[doc = "`GL_NEGATIVE_ONE_TO_ONE: GLenum = 0x935E`"]
    #[doc = "* **Group:** ClipControlDepth"]
    pub const GL_NEGATIVE_ONE_TO_ONE: GLenum = 0x935E;
    #[doc = "`GL_NEVER: GLenum = 0x0200`"]
    #[doc = "* **Groups:** StencilFunction, IndexFunctionEXT, AlphaFunction, DepthFunction"]
    pub const GL_NEVER: GLenum = 0x0200;
    #[doc = "`GL_NICEST: GLenum = 0x1102`"]
    #[doc = "* **Group:** HintMode"]
    pub const GL_NICEST: GLenum = 0x1102;
    #[doc = "`GL_NONE: GLenum = 0`"]
    #[doc = "* **Groups:** SyncBehaviorFlags, TextureCompareMode, PathColorFormat, CombinerBiasNV, CombinerScaleNV, DrawBufferMode, PixelTexGenMode, ReadBufferMode, ColorBuffer, PathGenMode, PathTransformType, PathFontStyle"]
    pub const GL_NONE: GLenum = 0;
    #[doc = "`GL_NOOP: GLenum = 0x1505`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_NOOP: GLenum = 0x1505;
    #[doc = "`GL_NOR: GLenum = 0x1508`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_NOR: GLenum = 0x1508;
    #[doc = "`GL_NOTEQUAL: GLenum = 0x0205`"]
    #[doc = "* **Groups:** StencilFunction, IndexFunctionEXT, AlphaFunction, DepthFunction"]
    pub const GL_NOTEQUAL: GLenum = 0x0205;
    #[doc = "`GL_NO_ERROR: GLenum = 0`"]
    #[doc = "* **Groups:** GraphicsResetStatus, ErrorCode"]
    pub const GL_NO_ERROR: GLenum = 0;
    #[doc = "`GL_NO_RESET_NOTIFICATION: GLenum = 0x8261`"]
    pub const GL_NO_RESET_NOTIFICATION: GLenum = 0x8261;
    #[doc = "`GL_NUM_ACTIVE_VARIABLES: GLenum = 0x9304`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_NUM_ACTIVE_VARIABLES: GLenum = 0x9304;
    #[doc = "`GL_NUM_COMPATIBLE_SUBROUTINES: GLenum = 0x8E4A`"]
    #[doc = "* **Groups:** ProgramResourceProperty, SubroutineParameterName"]
    pub const GL_NUM_COMPATIBLE_SUBROUTINES: GLenum = 0x8E4A;
    #[doc = "`GL_NUM_COMPRESSED_TEXTURE_FORMATS: GLenum = 0x86A2`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_NUM_COMPRESSED_TEXTURE_FORMATS: GLenum = 0x86A2;
    #[doc = "`GL_NUM_EXTENSIONS: GLenum = 0x821D`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_NUM_EXTENSIONS: GLenum = 0x821D;
    #[doc = "`GL_NUM_PROGRAM_BINARY_FORMATS: GLenum = 0x87FE`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_NUM_PROGRAM_BINARY_FORMATS: GLenum = 0x87FE;
    #[doc = "`GL_NUM_SAMPLE_COUNTS: GLenum = 0x9380`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_NUM_SAMPLE_COUNTS: GLenum = 0x9380;
    #[doc = "`GL_NUM_SHADER_BINARY_FORMATS: GLenum = 0x8DF9`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_NUM_SHADER_BINARY_FORMATS: GLenum = 0x8DF9;
    #[doc = "`GL_NUM_SHADING_LANGUAGE_VERSIONS: GLenum = 0x82E9`"]
    pub const GL_NUM_SHADING_LANGUAGE_VERSIONS: GLenum = 0x82E9;
    #[doc = "`GL_NUM_SPIR_V_EXTENSIONS: GLenum = 0x9554`"]
    pub const GL_NUM_SPIR_V_EXTENSIONS: GLenum = 0x9554;
    #[doc = "`GL_OBJECT_TYPE: GLenum = 0x9112`"]
    #[doc = "* **Group:** SyncParameterName"]
    pub const GL_OBJECT_TYPE: GLenum = 0x9112;
    #[doc = "`GL_OFFSET: GLenum = 0x92FC`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_OFFSET: GLenum = 0x92FC;
    #[doc = "`GL_ONE: GLenum = 1`"]
    #[doc = "* **Groups:** TextureSwizzle, BlendingFactor"]
    pub const GL_ONE: GLenum = 1;
    #[doc = "`GL_ONE_MINUS_CONSTANT_ALPHA: GLenum = 0x8004`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_ONE_MINUS_CONSTANT_ALPHA: GLenum = 0x8004;
    #[doc = "`GL_ONE_MINUS_CONSTANT_COLOR: GLenum = 0x8002`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_ONE_MINUS_CONSTANT_COLOR: GLenum = 0x8002;
    #[doc = "`GL_ONE_MINUS_DST_ALPHA: GLenum = 0x0305`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_ONE_MINUS_DST_ALPHA: GLenum = 0x0305;
    #[doc = "`GL_ONE_MINUS_DST_COLOR: GLenum = 0x0307`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_ONE_MINUS_DST_COLOR: GLenum = 0x0307;
    #[doc = "`GL_ONE_MINUS_SRC1_ALPHA: GLenum = 0x88FB`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_ONE_MINUS_SRC1_ALPHA: GLenum = 0x88FB;
    #[doc = "`GL_ONE_MINUS_SRC1_COLOR: GLenum = 0x88FA`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_ONE_MINUS_SRC1_COLOR: GLenum = 0x88FA;
    #[doc = "`GL_ONE_MINUS_SRC_ALPHA: GLenum = 0x0303`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_ONE_MINUS_SRC_ALPHA: GLenum = 0x0303;
    #[doc = "`GL_ONE_MINUS_SRC_COLOR: GLenum = 0x0301`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_ONE_MINUS_SRC_COLOR: GLenum = 0x0301;
    #[doc = "`GL_OR: GLenum = 0x1507`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_OR: GLenum = 0x1507;
    #[doc = "`GL_OR_INVERTED: GLenum = 0x150D`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_OR_INVERTED: GLenum = 0x150D;
    #[doc = "`GL_OR_REVERSE: GLenum = 0x150B`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_OR_REVERSE: GLenum = 0x150B;
    #[doc = "`GL_OUT_OF_MEMORY: GLenum = 0x0505`"]
    #[doc = "* **Group:** ErrorCode"]
    pub const GL_OUT_OF_MEMORY: GLenum = 0x0505;
    #[doc = "`GL_OVERLAY: GLenum = 0x9296`"]
    pub const GL_OVERLAY: GLenum = 0x9296;
    #[doc = "`GL_PACK_ALIGNMENT: GLenum = 0x0D05`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_PACK_ALIGNMENT: GLenum = 0x0D05;
    #[doc = "`GL_PACK_COMPRESSED_BLOCK_DEPTH: GLenum = 0x912D`"]
    pub const GL_PACK_COMPRESSED_BLOCK_DEPTH: GLenum = 0x912D;
    #[doc = "`GL_PACK_COMPRESSED_BLOCK_HEIGHT: GLenum = 0x912C`"]
    pub const GL_PACK_COMPRESSED_BLOCK_HEIGHT: GLenum = 0x912C;
    #[doc = "`GL_PACK_COMPRESSED_BLOCK_SIZE: GLenum = 0x912E`"]
    pub const GL_PACK_COMPRESSED_BLOCK_SIZE: GLenum = 0x912E;
    #[doc = "`GL_PACK_COMPRESSED_BLOCK_WIDTH: GLenum = 0x912B`"]
    pub const GL_PACK_COMPRESSED_BLOCK_WIDTH: GLenum = 0x912B;
    #[doc = "`GL_PACK_IMAGE_HEIGHT: GLenum = 0x806C`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_PACK_IMAGE_HEIGHT: GLenum = 0x806C;
    #[doc = "`GL_PACK_LSB_FIRST: GLenum = 0x0D01`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_PACK_LSB_FIRST: GLenum = 0x0D01;
    #[doc = "`GL_PACK_ROW_LENGTH: GLenum = 0x0D02`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_PACK_ROW_LENGTH: GLenum = 0x0D02;
    #[doc = "`GL_PACK_SKIP_IMAGES: GLenum = 0x806B`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_PACK_SKIP_IMAGES: GLenum = 0x806B;
    #[doc = "`GL_PACK_SKIP_PIXELS: GLenum = 0x0D04`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_PACK_SKIP_PIXELS: GLenum = 0x0D04;
    #[doc = "`GL_PACK_SKIP_ROWS: GLenum = 0x0D03`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_PACK_SKIP_ROWS: GLenum = 0x0D03;
    #[doc = "`GL_PACK_SWAP_BYTES: GLenum = 0x0D00`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_PACK_SWAP_BYTES: GLenum = 0x0D00;
    #[doc = "`GL_PARAMETER_BUFFER: GLenum = 0x80EE`"]
    #[doc = "* **Group:** BufferTargetARB"]
    pub const GL_PARAMETER_BUFFER: GLenum = 0x80EE;
    #[doc = "`GL_PARAMETER_BUFFER_BINDING: GLenum = 0x80EF`"]
    pub const GL_PARAMETER_BUFFER_BINDING: GLenum = 0x80EF;
    #[doc = "`GL_PATCHES: GLenum = 0x000E`"]
    #[doc = "* **Group:** PrimitiveType"]
    pub const GL_PATCHES: GLenum = 0x000E;
    #[doc = "`GL_PATCH_DEFAULT_INNER_LEVEL: GLenum = 0x8E73`"]
    #[doc = "* **Group:** PatchParameterName"]
    pub const GL_PATCH_DEFAULT_INNER_LEVEL: GLenum = 0x8E73;
    #[doc = "`GL_PATCH_DEFAULT_OUTER_LEVEL: GLenum = 0x8E74`"]
    #[doc = "* **Group:** PatchParameterName"]
    pub const GL_PATCH_DEFAULT_OUTER_LEVEL: GLenum = 0x8E74;
    #[doc = "`GL_PATCH_VERTICES: GLenum = 0x8E72`"]
    #[doc = "* **Group:** PatchParameterName"]
    pub const GL_PATCH_VERTICES: GLenum = 0x8E72;
    #[doc = "`GL_PIXEL_BUFFER_BARRIER_BIT: GLbitfield = 0x00000080`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_PIXEL_BUFFER_BARRIER_BIT: GLbitfield = 0x00000080;
    #[doc = "`GL_PIXEL_PACK_BUFFER: GLenum = 0x88EB`"]
    #[doc = "* **Groups:** CopyBufferSubDataTarget, BufferTargetARB, BufferStorageTarget"]
    pub const GL_PIXEL_PACK_BUFFER: GLenum = 0x88EB;
    #[doc = "`GL_PIXEL_PACK_BUFFER_BINDING: GLenum = 0x88ED`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_PIXEL_PACK_BUFFER_BINDING: GLenum = 0x88ED;
    #[doc = "`GL_PIXEL_UNPACK_BUFFER: GLenum = 0x88EC`"]
    #[doc = "* **Groups:** CopyBufferSubDataTarget, BufferTargetARB, BufferStorageTarget"]
    pub const GL_PIXEL_UNPACK_BUFFER: GLenum = 0x88EC;
    #[doc = "`GL_PIXEL_UNPACK_BUFFER_BINDING: GLenum = 0x88EF`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_PIXEL_UNPACK_BUFFER_BINDING: GLenum = 0x88EF;
    #[doc = "`GL_POINT: GLenum = 0x1B00`"]
    #[doc = "* **Groups:** PolygonMode, MeshMode1, MeshMode2"]
    pub const GL_POINT: GLenum = 0x1B00;
    #[doc = "`GL_POINTS: GLenum = 0x0000`"]
    #[doc = "* **Group:** PrimitiveType"]
    pub const GL_POINTS: GLenum = 0x0000;
    #[doc = "`GL_POINT_FADE_THRESHOLD_SIZE: GLenum = 0x8128`"]
    #[doc = "* **Groups:** PointParameterNameSGIS, PointParameterNameARB, GetPName"]
    pub const GL_POINT_FADE_THRESHOLD_SIZE: GLenum = 0x8128;
    #[doc = "`GL_POINT_SIZE: GLenum = 0x0B11`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_POINT_SIZE: GLenum = 0x0B11;
    #[doc = "`GL_POINT_SIZE_GRANULARITY: GLenum = 0x0B13`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_POINT_SIZE_GRANULARITY: GLenum = 0x0B13;
    #[doc = "`GL_POINT_SIZE_RANGE: GLenum = 0x0B12`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_POINT_SIZE_RANGE: GLenum = 0x0B12;
    #[doc = "`GL_POINT_SPRITE_COORD_ORIGIN: GLenum = 0x8CA0`"]
    pub const GL_POINT_SPRITE_COORD_ORIGIN: GLenum = 0x8CA0;
    #[doc = "`GL_POLYGON_MODE: GLenum = 0x0B40`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_POLYGON_MODE: GLenum = 0x0B40;
    #[doc = "`GL_POLYGON_OFFSET_CLAMP: GLenum = 0x8E1B`"]
    pub const GL_POLYGON_OFFSET_CLAMP: GLenum = 0x8E1B;
    #[doc = "`GL_POLYGON_OFFSET_FACTOR: GLenum = 0x8038`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_POLYGON_OFFSET_FACTOR: GLenum = 0x8038;
    #[doc = "`GL_POLYGON_OFFSET_FILL: GLenum = 0x8037`"]
    #[doc = "* **Groups:** GetPName, EnableCap"]
    pub const GL_POLYGON_OFFSET_FILL: GLenum = 0x8037;
    #[doc = "`GL_POLYGON_OFFSET_LINE: GLenum = 0x2A02`"]
    #[doc = "* **Groups:** GetPName, EnableCap"]
    pub const GL_POLYGON_OFFSET_LINE: GLenum = 0x2A02;
    #[doc = "`GL_POLYGON_OFFSET_POINT: GLenum = 0x2A01`"]
    #[doc = "* **Groups:** GetPName, EnableCap"]
    pub const GL_POLYGON_OFFSET_POINT: GLenum = 0x2A01;
    #[doc = "`GL_POLYGON_OFFSET_UNITS: GLenum = 0x2A00`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_POLYGON_OFFSET_UNITS: GLenum = 0x2A00;
    #[doc = "`GL_POLYGON_SMOOTH: GLenum = 0x0B41`"]
    #[doc = "* **Groups:** GetPName, EnableCap"]
    pub const GL_POLYGON_SMOOTH: GLenum = 0x0B41;
    #[doc = "`GL_POLYGON_SMOOTH_HINT: GLenum = 0x0C53`"]
    #[doc = "* **Groups:** HintTarget, GetPName"]
    pub const GL_POLYGON_SMOOTH_HINT: GLenum = 0x0C53;
    #[doc = "`GL_PRIMITIVES_GENERATED: GLenum = 0x8C87`"]
    #[doc = "* **Group:** QueryTarget"]
    pub const GL_PRIMITIVES_GENERATED: GLenum = 0x8C87;
    #[doc = "`GL_PRIMITIVES_SUBMITTED: GLenum = 0x82EF`"]
    #[doc = "* **Group:** QueryTarget"]
    pub const GL_PRIMITIVES_SUBMITTED: GLenum = 0x82EF;
    #[doc = "`GL_PRIMITIVE_BOUNDING_BOX: GLenum = 0x92BE`"]
    pub const GL_PRIMITIVE_BOUNDING_BOX: GLenum = 0x92BE;
    #[doc = "`GL_PRIMITIVE_RESTART: GLenum = 0x8F9D`"]
    #[doc = "* **Group:** EnableCap"]
    pub const GL_PRIMITIVE_RESTART: GLenum = 0x8F9D;
    #[doc = "`GL_PRIMITIVE_RESTART_FIXED_INDEX: GLenum = 0x8D69`"]
    #[doc = "* **Group:** EnableCap"]
    pub const GL_PRIMITIVE_RESTART_FIXED_INDEX: GLenum = 0x8D69;
    #[doc = "`GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED: GLenum = 0x8221`"]
    pub const GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED: GLenum = 0x8221;
    #[doc = "`GL_PRIMITIVE_RESTART_INDEX: GLenum = 0x8F9E`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_PRIMITIVE_RESTART_INDEX: GLenum = 0x8F9E;
    #[doc = "`GL_PROGRAM: GLenum = 0x82E2`"]
    #[doc = "* **Group:** ObjectIdentifier"]
    pub const GL_PROGRAM: GLenum = 0x82E2;
    #[doc = "`GL_PROGRAM_BINARY_FORMATS: GLenum = 0x87FF`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_PROGRAM_BINARY_FORMATS: GLenum = 0x87FF;
    #[doc = "`GL_PROGRAM_BINARY_LENGTH: GLenum = 0x8741`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_PROGRAM_BINARY_LENGTH: GLenum = 0x8741;
    #[doc = "`GL_PROGRAM_BINARY_RETRIEVABLE_HINT: GLenum = 0x8257`"]
    #[doc = "* **Groups:** ProgramParameterPName, HintTarget"]
    pub const GL_PROGRAM_BINARY_RETRIEVABLE_HINT: GLenum = 0x8257;
    #[doc = "`GL_PROGRAM_INPUT: GLenum = 0x92E3`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_PROGRAM_INPUT: GLenum = 0x92E3;
    #[doc = "`GL_PROGRAM_KHR: GLenum = 0x82E2`"]

    pub const GL_PROGRAM_KHR: GLenum = 0x82E2;
    #[doc = "`GL_PROGRAM_OUTPUT: GLenum = 0x92E4`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_PROGRAM_OUTPUT: GLenum = 0x92E4;
    #[doc = "`GL_PROGRAM_PIPELINE: GLenum = 0x82E4`"]
    #[doc = "* **Group:** ObjectIdentifier"]
    pub const GL_PROGRAM_PIPELINE: GLenum = 0x82E4;
    #[doc = "`GL_PROGRAM_PIPELINE_BINDING: GLenum = 0x825A`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_PROGRAM_PIPELINE_BINDING: GLenum = 0x825A;
    #[doc = "`GL_PROGRAM_PIPELINE_KHR: GLenum = 0x82E4`"]

    pub const GL_PROGRAM_PIPELINE_KHR: GLenum = 0x82E4;
    #[doc = "`GL_PROGRAM_POINT_SIZE: GLenum = 0x8642`"]
    #[doc = "* **Groups:** GetPName, EnableCap"]
    #[doc = "* **Alias Of:** `GL_VERTEX_PROGRAM_POINT_SIZE`"]
    pub const GL_PROGRAM_POINT_SIZE: GLenum = 0x8642;
    #[doc = "`GL_PROGRAM_SEPARABLE: GLenum = 0x8258`"]
    #[doc = "* **Group:** ProgramParameterPName"]
    pub const GL_PROGRAM_SEPARABLE: GLenum = 0x8258;
    #[doc = "`GL_PROVOKING_VERTEX: GLenum = 0x8E4F`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_PROVOKING_VERTEX: GLenum = 0x8E4F;
    #[doc = "`GL_PROXY_TEXTURE_1D: GLenum = 0x8063`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_PROXY_TEXTURE_1D: GLenum = 0x8063;
    #[doc = "`GL_PROXY_TEXTURE_1D_ARRAY: GLenum = 0x8C19`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_PROXY_TEXTURE_1D_ARRAY: GLenum = 0x8C19;
    #[doc = "`GL_PROXY_TEXTURE_2D: GLenum = 0x8064`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_PROXY_TEXTURE_2D: GLenum = 0x8064;
    #[doc = "`GL_PROXY_TEXTURE_2D_ARRAY: GLenum = 0x8C1B`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_PROXY_TEXTURE_2D_ARRAY: GLenum = 0x8C1B;
    #[doc = "`GL_PROXY_TEXTURE_2D_MULTISAMPLE: GLenum = 0x9101`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_PROXY_TEXTURE_2D_MULTISAMPLE: GLenum = 0x9101;
    #[doc = "`GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY: GLenum = 0x9103`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY: GLenum = 0x9103;
    #[doc = "`GL_PROXY_TEXTURE_3D: GLenum = 0x8070`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_PROXY_TEXTURE_3D: GLenum = 0x8070;
    #[doc = "`GL_PROXY_TEXTURE_CUBE_MAP: GLenum = 0x851B`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_PROXY_TEXTURE_CUBE_MAP: GLenum = 0x851B;
    #[doc = "`GL_PROXY_TEXTURE_CUBE_MAP_ARRAY: GLenum = 0x900B`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_PROXY_TEXTURE_CUBE_MAP_ARRAY: GLenum = 0x900B;
    #[doc = "`GL_PROXY_TEXTURE_RECTANGLE: GLenum = 0x84F7`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_PROXY_TEXTURE_RECTANGLE: GLenum = 0x84F7;
    #[doc = "`GL_QUADS: GLenum = 0x0007`"]
    #[doc = "* **Group:** PrimitiveType"]
    pub const GL_QUADS: GLenum = 0x0007;
    #[doc = "`GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION: GLenum = 0x8E4C`"]
    pub const GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION: GLenum = 0x8E4C;
    #[doc = "`GL_QUERY: GLenum = 0x82E3`"]
    #[doc = "* **Group:** ObjectIdentifier"]
    pub const GL_QUERY: GLenum = 0x82E3;
    #[doc = "`GL_QUERY_BUFFER: GLenum = 0x9192`"]
    #[doc = "* **Groups:** CopyBufferSubDataTarget, BufferTargetARB, BufferStorageTarget"]
    pub const GL_QUERY_BUFFER: GLenum = 0x9192;
    #[doc = "`GL_QUERY_BUFFER_BARRIER_BIT: GLbitfield = 0x00008000`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_QUERY_BUFFER_BARRIER_BIT: GLbitfield = 0x00008000;
    #[doc = "`GL_QUERY_BUFFER_BINDING: GLenum = 0x9193`"]
    pub const GL_QUERY_BUFFER_BINDING: GLenum = 0x9193;
    #[doc = "`GL_QUERY_BY_REGION_NO_WAIT: GLenum = 0x8E16`"]
    #[doc = "* **Group:** ConditionalRenderMode"]
    pub const GL_QUERY_BY_REGION_NO_WAIT: GLenum = 0x8E16;
    #[doc = "`GL_QUERY_BY_REGION_NO_WAIT_INVERTED: GLenum = 0x8E1A`"]
    #[doc = "* **Group:** ConditionalRenderMode"]
    pub const GL_QUERY_BY_REGION_NO_WAIT_INVERTED: GLenum = 0x8E1A;
    #[doc = "`GL_QUERY_BY_REGION_WAIT: GLenum = 0x8E15`"]
    #[doc = "* **Group:** ConditionalRenderMode"]
    pub const GL_QUERY_BY_REGION_WAIT: GLenum = 0x8E15;
    #[doc = "`GL_QUERY_BY_REGION_WAIT_INVERTED: GLenum = 0x8E19`"]
    #[doc = "* **Group:** ConditionalRenderMode"]
    pub const GL_QUERY_BY_REGION_WAIT_INVERTED: GLenum = 0x8E19;
    #[doc = "`GL_QUERY_COUNTER_BITS: GLenum = 0x8864`"]
    #[doc = "* **Group:** QueryParameterName"]
    pub const GL_QUERY_COUNTER_BITS: GLenum = 0x8864;
    #[doc = "`GL_QUERY_KHR: GLenum = 0x82E3`"]

    pub const GL_QUERY_KHR: GLenum = 0x82E3;
    #[doc = "`GL_QUERY_NO_WAIT: GLenum = 0x8E14`"]
    #[doc = "* **Group:** ConditionalRenderMode"]
    pub const GL_QUERY_NO_WAIT: GLenum = 0x8E14;
    #[doc = "`GL_QUERY_NO_WAIT_INVERTED: GLenum = 0x8E18`"]
    #[doc = "* **Group:** ConditionalRenderMode"]
    pub const GL_QUERY_NO_WAIT_INVERTED: GLenum = 0x8E18;
    #[doc = "`GL_QUERY_RESULT: GLenum = 0x8866`"]
    #[doc = "* **Group:** QueryObjectParameterName"]
    pub const GL_QUERY_RESULT: GLenum = 0x8866;
    #[doc = "`GL_QUERY_RESULT_AVAILABLE: GLenum = 0x8867`"]
    #[doc = "* **Group:** QueryObjectParameterName"]
    pub const GL_QUERY_RESULT_AVAILABLE: GLenum = 0x8867;
    #[doc = "`GL_QUERY_RESULT_NO_WAIT: GLenum = 0x9194`"]
    #[doc = "* **Group:** QueryObjectParameterName"]
    pub const GL_QUERY_RESULT_NO_WAIT: GLenum = 0x9194;
    #[doc = "`GL_QUERY_TARGET: GLenum = 0x82EA`"]
    #[doc = "* **Group:** QueryObjectParameterName"]
    pub const GL_QUERY_TARGET: GLenum = 0x82EA;
    #[doc = "`GL_QUERY_WAIT: GLenum = 0x8E13`"]
    #[doc = "* **Group:** ConditionalRenderMode"]
    pub const GL_QUERY_WAIT: GLenum = 0x8E13;
    #[doc = "`GL_QUERY_WAIT_INVERTED: GLenum = 0x8E17`"]
    #[doc = "* **Group:** ConditionalRenderMode"]
    pub const GL_QUERY_WAIT_INVERTED: GLenum = 0x8E17;
    #[doc = "`GL_R11F_G11F_B10F: GLenum = 0x8C3A`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_R11F_G11F_B10F: GLenum = 0x8C3A;
    #[doc = "`GL_R16: GLenum = 0x822A`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_R16: GLenum = 0x822A;
    #[doc = "`GL_R16F: GLenum = 0x822D`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_R16F: GLenum = 0x822D;
    #[doc = "`GL_R16I: GLenum = 0x8233`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_R16I: GLenum = 0x8233;
    #[doc = "`GL_R16UI: GLenum = 0x8234`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_R16UI: GLenum = 0x8234;
    #[doc = "`GL_R16_SNORM: GLenum = 0x8F98`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_R16_SNORM: GLenum = 0x8F98;
    #[doc = "`GL_R32F: GLenum = 0x822E`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_R32F: GLenum = 0x822E;
    #[doc = "`GL_R32I: GLenum = 0x8235`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_R32I: GLenum = 0x8235;
    #[doc = "`GL_R32UI: GLenum = 0x8236`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_R32UI: GLenum = 0x8236;
    #[doc = "`GL_R3_G3_B2: GLenum = 0x2A10`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_R3_G3_B2: GLenum = 0x2A10;
    #[doc = "`GL_R8: GLenum = 0x8229`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_R8: GLenum = 0x8229;
    #[doc = "`GL_R8I: GLenum = 0x8231`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_R8I: GLenum = 0x8231;
    #[doc = "`GL_R8UI: GLenum = 0x8232`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_R8UI: GLenum = 0x8232;
    #[doc = "`GL_R8_SNORM: GLenum = 0x8F94`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_R8_SNORM: GLenum = 0x8F94;
    #[doc = "`GL_RASTERIZER_DISCARD: GLenum = 0x8C89`"]
    #[doc = "* **Group:** EnableCap"]
    pub const GL_RASTERIZER_DISCARD: GLenum = 0x8C89;
    #[doc = "`GL_READ_BUFFER: GLenum = 0x0C02`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_READ_BUFFER: GLenum = 0x0C02;
    #[doc = "`GL_READ_FRAMEBUFFER: GLenum = 0x8CA8`"]
    #[doc = "* **Groups:** CheckFramebufferStatusTarget, FramebufferTarget"]
    pub const GL_READ_FRAMEBUFFER: GLenum = 0x8CA8;
    #[doc = "`GL_READ_FRAMEBUFFER_BINDING: GLenum = 0x8CAA`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_READ_FRAMEBUFFER_BINDING: GLenum = 0x8CAA;
    #[doc = "`GL_READ_ONLY: GLenum = 0x88B8`"]
    #[doc = "* **Group:** BufferAccessARB"]
    pub const GL_READ_ONLY: GLenum = 0x88B8;
    #[doc = "`GL_READ_PIXELS: GLenum = 0x828C`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_READ_PIXELS: GLenum = 0x828C;
    #[doc = "`GL_READ_PIXELS_FORMAT: GLenum = 0x828D`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_READ_PIXELS_FORMAT: GLenum = 0x828D;
    #[doc = "`GL_READ_PIXELS_TYPE: GLenum = 0x828E`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_READ_PIXELS_TYPE: GLenum = 0x828E;
    #[doc = "`GL_READ_WRITE: GLenum = 0x88BA`"]
    #[doc = "* **Group:** BufferAccessARB"]
    pub const GL_READ_WRITE: GLenum = 0x88BA;
    #[doc = "`GL_RED: GLenum = 0x1903`"]
    #[doc = "* **Groups:** TextureSwizzle, PixelFormat, InternalFormat"]
    pub const GL_RED: GLenum = 0x1903;
    #[doc = "`GL_RED_BITS: GLenum = 0x0D52`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_RED_BITS: GLenum = 0x0D52;
    #[doc = "`GL_RED_INTEGER: GLenum = 0x8D94`"]
    #[doc = "* **Group:** PixelFormat"]
    pub const GL_RED_INTEGER: GLenum = 0x8D94;
    #[doc = "`GL_REFERENCED_BY_COMPUTE_SHADER: GLenum = 0x930B`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_REFERENCED_BY_COMPUTE_SHADER: GLenum = 0x930B;
    #[doc = "`GL_REFERENCED_BY_FRAGMENT_SHADER: GLenum = 0x930A`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_REFERENCED_BY_FRAGMENT_SHADER: GLenum = 0x930A;
    #[doc = "`GL_REFERENCED_BY_GEOMETRY_SHADER: GLenum = 0x9309`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_REFERENCED_BY_GEOMETRY_SHADER: GLenum = 0x9309;
    #[doc = "`GL_REFERENCED_BY_TESS_CONTROL_SHADER: GLenum = 0x9307`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_REFERENCED_BY_TESS_CONTROL_SHADER: GLenum = 0x9307;
    #[doc = "`GL_REFERENCED_BY_TESS_EVALUATION_SHADER: GLenum = 0x9308`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_REFERENCED_BY_TESS_EVALUATION_SHADER: GLenum = 0x9308;
    #[doc = "`GL_REFERENCED_BY_VERTEX_SHADER: GLenum = 0x9306`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_REFERENCED_BY_VERTEX_SHADER: GLenum = 0x9306;
    #[doc = "`GL_RENDERBUFFER: GLenum = 0x8D41`"]
    #[doc = "* **Groups:** ObjectIdentifier, RenderbufferTarget, CopyImageSubDataTarget"]
    pub const GL_RENDERBUFFER: GLenum = 0x8D41;
    #[doc = "`GL_RENDERBUFFER_ALPHA_SIZE: GLenum = 0x8D53`"]
    #[doc = "* **Group:** RenderbufferParameterName"]
    pub const GL_RENDERBUFFER_ALPHA_SIZE: GLenum = 0x8D53;
    #[doc = "`GL_RENDERBUFFER_BINDING: GLenum = 0x8CA7`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_RENDERBUFFER_BINDING: GLenum = 0x8CA7;
    #[doc = "`GL_RENDERBUFFER_BLUE_SIZE: GLenum = 0x8D52`"]
    #[doc = "* **Group:** RenderbufferParameterName"]
    pub const GL_RENDERBUFFER_BLUE_SIZE: GLenum = 0x8D52;
    #[doc = "`GL_RENDERBUFFER_DEPTH_SIZE: GLenum = 0x8D54`"]
    #[doc = "* **Group:** RenderbufferParameterName"]
    pub const GL_RENDERBUFFER_DEPTH_SIZE: GLenum = 0x8D54;
    #[doc = "`GL_RENDERBUFFER_GREEN_SIZE: GLenum = 0x8D51`"]
    #[doc = "* **Group:** RenderbufferParameterName"]
    pub const GL_RENDERBUFFER_GREEN_SIZE: GLenum = 0x8D51;
    #[doc = "`GL_RENDERBUFFER_HEIGHT: GLenum = 0x8D43`"]
    #[doc = "* **Group:** RenderbufferParameterName"]
    pub const GL_RENDERBUFFER_HEIGHT: GLenum = 0x8D43;
    #[doc = "`GL_RENDERBUFFER_INTERNAL_FORMAT: GLenum = 0x8D44`"]
    #[doc = "* **Group:** RenderbufferParameterName"]
    pub const GL_RENDERBUFFER_INTERNAL_FORMAT: GLenum = 0x8D44;
    #[doc = "`GL_RENDERBUFFER_RED_SIZE: GLenum = 0x8D50`"]
    #[doc = "* **Group:** RenderbufferParameterName"]
    pub const GL_RENDERBUFFER_RED_SIZE: GLenum = 0x8D50;
    #[doc = "`GL_RENDERBUFFER_SAMPLES: GLenum = 0x8CAB`"]
    #[doc = "* **Group:** RenderbufferParameterName"]
    pub const GL_RENDERBUFFER_SAMPLES: GLenum = 0x8CAB;
    #[doc = "`GL_RENDERBUFFER_STENCIL_SIZE: GLenum = 0x8D55`"]
    #[doc = "* **Group:** RenderbufferParameterName"]
    pub const GL_RENDERBUFFER_STENCIL_SIZE: GLenum = 0x8D55;
    #[doc = "`GL_RENDERBUFFER_WIDTH: GLenum = 0x8D42`"]
    #[doc = "* **Group:** RenderbufferParameterName"]
    pub const GL_RENDERBUFFER_WIDTH: GLenum = 0x8D42;
    #[doc = "`GL_RENDERER: GLenum = 0x1F01`"]
    #[doc = "* **Group:** StringName"]
    pub const GL_RENDERER: GLenum = 0x1F01;
    #[doc = "`GL_REPEAT: GLenum = 0x2901`"]
    #[doc = "* **Group:** TextureWrapMode"]
    pub const GL_REPEAT: GLenum = 0x2901;
    #[doc = "`GL_REPLACE: GLenum = 0x1E01`"]
    #[doc = "* **Groups:** StencilOp, LightEnvModeSGIX"]
    pub const GL_REPLACE: GLenum = 0x1E01;
    #[doc = "`GL_RESET_NOTIFICATION_STRATEGY: GLenum = 0x8256`"]
    pub const GL_RESET_NOTIFICATION_STRATEGY: GLenum = 0x8256;
    #[doc = "`GL_RG: GLenum = 0x8227`"]
    #[doc = "* **Groups:** InternalFormat, PixelFormat"]
    pub const GL_RG: GLenum = 0x8227;
    #[doc = "`GL_RG16: GLenum = 0x822C`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RG16: GLenum = 0x822C;
    #[doc = "`GL_RG16F: GLenum = 0x822F`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RG16F: GLenum = 0x822F;
    #[doc = "`GL_RG16I: GLenum = 0x8239`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RG16I: GLenum = 0x8239;
    #[doc = "`GL_RG16UI: GLenum = 0x823A`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RG16UI: GLenum = 0x823A;
    #[doc = "`GL_RG16_SNORM: GLenum = 0x8F99`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RG16_SNORM: GLenum = 0x8F99;
    #[doc = "`GL_RG32F: GLenum = 0x8230`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RG32F: GLenum = 0x8230;
    #[doc = "`GL_RG32I: GLenum = 0x823B`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RG32I: GLenum = 0x823B;
    #[doc = "`GL_RG32UI: GLenum = 0x823C`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RG32UI: GLenum = 0x823C;
    #[doc = "`GL_RG8: GLenum = 0x822B`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RG8: GLenum = 0x822B;
    #[doc = "`GL_RG8I: GLenum = 0x8237`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RG8I: GLenum = 0x8237;
    #[doc = "`GL_RG8UI: GLenum = 0x8238`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RG8UI: GLenum = 0x8238;
    #[doc = "`GL_RG8_SNORM: GLenum = 0x8F95`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RG8_SNORM: GLenum = 0x8F95;
    #[doc = "`GL_RGB: GLenum = 0x1907`"]
    #[doc = "* **Groups:** PixelTexGenMode, CombinerPortionNV, PathColorFormat, CombinerComponentUsageNV, PixelFormat, InternalFormat"]
    pub const GL_RGB: GLenum = 0x1907;
    #[doc = "`GL_RGB10: GLenum = 0x8052`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB10: GLenum = 0x8052;
    #[doc = "`GL_RGB10_A2: GLenum = 0x8059`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB10_A2: GLenum = 0x8059;
    #[doc = "`GL_RGB10_A2UI: GLenum = 0x906F`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB10_A2UI: GLenum = 0x906F;
    #[doc = "`GL_RGB12: GLenum = 0x8053`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB12: GLenum = 0x8053;
    #[doc = "`GL_RGB16: GLenum = 0x8054`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB16: GLenum = 0x8054;
    #[doc = "`GL_RGB16F: GLenum = 0x881B`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB16F: GLenum = 0x881B;
    #[doc = "`GL_RGB16I: GLenum = 0x8D89`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB16I: GLenum = 0x8D89;
    #[doc = "`GL_RGB16UI: GLenum = 0x8D77`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB16UI: GLenum = 0x8D77;
    #[doc = "`GL_RGB16_SNORM: GLenum = 0x8F9A`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB16_SNORM: GLenum = 0x8F9A;
    #[doc = "`GL_RGB32F: GLenum = 0x8815`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB32F: GLenum = 0x8815;
    #[doc = "`GL_RGB32I: GLenum = 0x8D83`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB32I: GLenum = 0x8D83;
    #[doc = "`GL_RGB32UI: GLenum = 0x8D71`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB32UI: GLenum = 0x8D71;
    #[doc = "`GL_RGB4: GLenum = 0x804F`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB4: GLenum = 0x804F;
    #[doc = "`GL_RGB5: GLenum = 0x8050`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB5: GLenum = 0x8050;
    #[doc = "`GL_RGB565: GLenum = 0x8D62`"]
    pub const GL_RGB565: GLenum = 0x8D62;
    #[doc = "`GL_RGB5_A1: GLenum = 0x8057`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB5_A1: GLenum = 0x8057;
    #[doc = "`GL_RGB8: GLenum = 0x8051`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB8: GLenum = 0x8051;
    #[doc = "`GL_RGB8I: GLenum = 0x8D8F`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB8I: GLenum = 0x8D8F;
    #[doc = "`GL_RGB8UI: GLenum = 0x8D7D`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB8UI: GLenum = 0x8D7D;
    #[doc = "`GL_RGB8_SNORM: GLenum = 0x8F96`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB8_SNORM: GLenum = 0x8F96;
    #[doc = "`GL_RGB9_E5: GLenum = 0x8C3D`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGB9_E5: GLenum = 0x8C3D;
    #[doc = "`GL_RGBA: GLenum = 0x1908`"]
    #[doc = "* **Groups:** PixelTexGenMode, PathColorFormat, PixelFormat, InternalFormat"]
    pub const GL_RGBA: GLenum = 0x1908;
    #[doc = "`GL_RGBA12: GLenum = 0x805A`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGBA12: GLenum = 0x805A;
    #[doc = "`GL_RGBA16: GLenum = 0x805B`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGBA16: GLenum = 0x805B;
    #[doc = "`GL_RGBA16F: GLenum = 0x881A`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGBA16F: GLenum = 0x881A;
    #[doc = "`GL_RGBA16I: GLenum = 0x8D88`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGBA16I: GLenum = 0x8D88;
    #[doc = "`GL_RGBA16UI: GLenum = 0x8D76`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGBA16UI: GLenum = 0x8D76;
    #[doc = "`GL_RGBA16_SNORM: GLenum = 0x8F9B`"]
    pub const GL_RGBA16_SNORM: GLenum = 0x8F9B;
    #[doc = "`GL_RGBA2: GLenum = 0x8055`"]
    pub const GL_RGBA2: GLenum = 0x8055;
    #[doc = "`GL_RGBA32F: GLenum = 0x8814`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGBA32F: GLenum = 0x8814;
    #[doc = "`GL_RGBA32I: GLenum = 0x8D82`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGBA32I: GLenum = 0x8D82;
    #[doc = "`GL_RGBA32UI: GLenum = 0x8D70`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGBA32UI: GLenum = 0x8D70;
    #[doc = "`GL_RGBA4: GLenum = 0x8056`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGBA4: GLenum = 0x8056;
    #[doc = "`GL_RGBA8: GLenum = 0x8058`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGBA8: GLenum = 0x8058;
    #[doc = "`GL_RGBA8I: GLenum = 0x8D8E`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGBA8I: GLenum = 0x8D8E;
    #[doc = "`GL_RGBA8UI: GLenum = 0x8D7C`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGBA8UI: GLenum = 0x8D7C;
    #[doc = "`GL_RGBA8_SNORM: GLenum = 0x8F97`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_RGBA8_SNORM: GLenum = 0x8F97;
    #[doc = "`GL_RGBA_INTEGER: GLenum = 0x8D99`"]
    #[doc = "* **Group:** PixelFormat"]
    pub const GL_RGBA_INTEGER: GLenum = 0x8D99;
    #[doc = "`GL_RGB_INTEGER: GLenum = 0x8D98`"]
    #[doc = "* **Group:** PixelFormat"]
    pub const GL_RGB_INTEGER: GLenum = 0x8D98;
    #[doc = "`GL_RG_INTEGER: GLenum = 0x8228`"]
    #[doc = "* **Group:** PixelFormat"]
    pub const GL_RG_INTEGER: GLenum = 0x8228;
    #[doc = "`GL_RIGHT: GLenum = 0x0407`"]
    #[doc = "* **Groups:** ColorBuffer, DrawBufferMode, ReadBufferMode"]
    pub const GL_RIGHT: GLenum = 0x0407;
    #[doc = "`GL_SAMPLER: GLenum = 0x82E6`"]
    #[doc = "* **Group:** ObjectIdentifier"]
    pub const GL_SAMPLER: GLenum = 0x82E6;
    #[doc = "`GL_SAMPLER_1D: GLenum = 0x8B5D`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_1D: GLenum = 0x8B5D;
    #[doc = "`GL_SAMPLER_1D_ARRAY: GLenum = 0x8DC0`"]
    #[doc = "* **Groups:** GlslTypeToken, UniformType"]
    pub const GL_SAMPLER_1D_ARRAY: GLenum = 0x8DC0;
    #[doc = "`GL_SAMPLER_1D_ARRAY_SHADOW: GLenum = 0x8DC3`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_1D_ARRAY_SHADOW: GLenum = 0x8DC3;
    #[doc = "`GL_SAMPLER_1D_SHADOW: GLenum = 0x8B61`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_1D_SHADOW: GLenum = 0x8B61;
    #[doc = "`GL_SAMPLER_2D: GLenum = 0x8B5E`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_2D: GLenum = 0x8B5E;
    #[doc = "`GL_SAMPLER_2D_ARRAY: GLenum = 0x8DC1`"]
    #[doc = "* **Groups:** GlslTypeToken, UniformType"]
    pub const GL_SAMPLER_2D_ARRAY: GLenum = 0x8DC1;
    #[doc = "`GL_SAMPLER_2D_ARRAY_SHADOW: GLenum = 0x8DC4`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_2D_ARRAY_SHADOW: GLenum = 0x8DC4;
    #[doc = "`GL_SAMPLER_2D_MULTISAMPLE: GLenum = 0x9108`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_2D_MULTISAMPLE: GLenum = 0x9108;
    #[doc = "`GL_SAMPLER_2D_MULTISAMPLE_ARRAY: GLenum = 0x910B`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_2D_MULTISAMPLE_ARRAY: GLenum = 0x910B;
    #[doc = "`GL_SAMPLER_2D_RECT: GLenum = 0x8B63`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_2D_RECT: GLenum = 0x8B63;
    #[doc = "`GL_SAMPLER_2D_RECT_SHADOW: GLenum = 0x8B64`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_2D_RECT_SHADOW: GLenum = 0x8B64;
    #[doc = "`GL_SAMPLER_2D_SHADOW: GLenum = 0x8B62`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_2D_SHADOW: GLenum = 0x8B62;
    #[doc = "`GL_SAMPLER_3D: GLenum = 0x8B5F`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_3D: GLenum = 0x8B5F;
    #[doc = "`GL_SAMPLER_BINDING: GLenum = 0x8919`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_SAMPLER_BINDING: GLenum = 0x8919;
    #[doc = "`GL_SAMPLER_BUFFER: GLenum = 0x8DC2`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_BUFFER: GLenum = 0x8DC2;
    #[doc = "`GL_SAMPLER_CUBE: GLenum = 0x8B60`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_CUBE: GLenum = 0x8B60;
    #[doc = "`GL_SAMPLER_CUBE_MAP_ARRAY: GLenum = 0x900C`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_CUBE_MAP_ARRAY: GLenum = 0x900C;
    #[doc = "`GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW: GLenum = 0x900D`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW: GLenum = 0x900D;
    #[doc = "`GL_SAMPLER_CUBE_SHADOW: GLenum = 0x8DC5`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_SAMPLER_CUBE_SHADOW: GLenum = 0x8DC5;
    #[doc = "`GL_SAMPLER_KHR: GLenum = 0x82E6`"]

    pub const GL_SAMPLER_KHR: GLenum = 0x82E6;
    #[doc = "`GL_SAMPLES: GLenum = 0x80A9`"]
    #[doc = "* **Groups:** GetFramebufferParameter, GetPName, InternalFormatPName"]
    pub const GL_SAMPLES: GLenum = 0x80A9;
    #[doc = "`GL_SAMPLES_PASSED: GLenum = 0x8914`"]
    #[doc = "* **Group:** QueryTarget"]
    pub const GL_SAMPLES_PASSED: GLenum = 0x8914;
    #[doc = "`GL_SAMPLE_ALPHA_TO_COVERAGE: GLenum = 0x809E`"]
    #[doc = "* **Group:** EnableCap"]
    pub const GL_SAMPLE_ALPHA_TO_COVERAGE: GLenum = 0x809E;
    #[doc = "`GL_SAMPLE_ALPHA_TO_ONE: GLenum = 0x809F`"]
    #[doc = "* **Group:** EnableCap"]
    pub const GL_SAMPLE_ALPHA_TO_ONE: GLenum = 0x809F;
    #[doc = "`GL_SAMPLE_BUFFERS: GLenum = 0x80A8`"]
    #[doc = "* **Groups:** GetFramebufferParameter, GetPName"]
    pub const GL_SAMPLE_BUFFERS: GLenum = 0x80A8;
    #[doc = "`GL_SAMPLE_COVERAGE: GLenum = 0x80A0`"]
    #[doc = "* **Group:** EnableCap"]
    pub const GL_SAMPLE_COVERAGE: GLenum = 0x80A0;
    #[doc = "`GL_SAMPLE_COVERAGE_INVERT: GLenum = 0x80AB`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_SAMPLE_COVERAGE_INVERT: GLenum = 0x80AB;
    #[doc = "`GL_SAMPLE_COVERAGE_VALUE: GLenum = 0x80AA`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_SAMPLE_COVERAGE_VALUE: GLenum = 0x80AA;
    #[doc = "`GL_SAMPLE_MASK: GLenum = 0x8E51`"]
    #[doc = "* **Group:** EnableCap"]
    pub const GL_SAMPLE_MASK: GLenum = 0x8E51;
    #[doc = "`GL_SAMPLE_MASK_VALUE: GLenum = 0x8E52`"]
    pub const GL_SAMPLE_MASK_VALUE: GLenum = 0x8E52;
    #[doc = "`GL_SAMPLE_POSITION: GLenum = 0x8E50`"]
    #[doc = "* **Group:** GetMultisamplePNameNV"]
    pub const GL_SAMPLE_POSITION: GLenum = 0x8E50;
    #[doc = "`GL_SAMPLE_SHADING: GLenum = 0x8C36`"]
    #[doc = "* **Group:** EnableCap"]
    pub const GL_SAMPLE_SHADING: GLenum = 0x8C36;
    #[doc = "`GL_SCISSOR_BOX: GLenum = 0x0C10`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_SCISSOR_BOX: GLenum = 0x0C10;
    #[doc = "`GL_SCISSOR_TEST: GLenum = 0x0C11`"]
    #[doc = "* **Groups:** GetPName, EnableCap"]
    pub const GL_SCISSOR_TEST: GLenum = 0x0C11;
    #[doc = "`GL_SCREEN: GLenum = 0x9295`"]
    pub const GL_SCREEN: GLenum = 0x9295;
    #[doc = "`GL_SEPARATE_ATTRIBS: GLenum = 0x8C8D`"]
    #[doc = "* **Group:** TransformFeedbackBufferMode"]
    pub const GL_SEPARATE_ATTRIBS: GLenum = 0x8C8D;
    #[doc = "`GL_SET: GLenum = 0x150F`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_SET: GLenum = 0x150F;
    #[doc = "`GL_SHADER: GLenum = 0x82E1`"]
    #[doc = "* **Group:** ObjectIdentifier"]
    pub const GL_SHADER: GLenum = 0x82E1;
    #[doc = "`GL_SHADER_BINARY_FORMATS: GLenum = 0x8DF8`"]
    pub const GL_SHADER_BINARY_FORMATS: GLenum = 0x8DF8;
    #[doc = "`GL_SHADER_BINARY_FORMAT_SPIR_V: GLenum = 0x9551`"]
    #[doc = "* **Group:** ShaderBinaryFormat"]
    pub const GL_SHADER_BINARY_FORMAT_SPIR_V: GLenum = 0x9551;
    #[doc = "`GL_SHADER_COMPILER: GLenum = 0x8DFA`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_SHADER_COMPILER: GLenum = 0x8DFA;
    #[doc = "`GL_SHADER_IMAGE_ACCESS_BARRIER_BIT: GLbitfield = 0x00000020`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_SHADER_IMAGE_ACCESS_BARRIER_BIT: GLbitfield = 0x00000020;
    #[doc = "`GL_SHADER_IMAGE_ATOMIC: GLenum = 0x82A6`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_SHADER_IMAGE_ATOMIC: GLenum = 0x82A6;
    #[doc = "`GL_SHADER_IMAGE_LOAD: GLenum = 0x82A4`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_SHADER_IMAGE_LOAD: GLenum = 0x82A4;
    #[doc = "`GL_SHADER_IMAGE_STORE: GLenum = 0x82A5`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_SHADER_IMAGE_STORE: GLenum = 0x82A5;
    #[doc = "`GL_SHADER_KHR: GLenum = 0x82E1`"]

    pub const GL_SHADER_KHR: GLenum = 0x82E1;
    #[doc = "`GL_SHADER_SOURCE_LENGTH: GLenum = 0x8B88`"]
    #[doc = "* **Group:** ShaderParameterName"]
    pub const GL_SHADER_SOURCE_LENGTH: GLenum = 0x8B88;
    #[doc = "`GL_SHADER_STORAGE_BARRIER_BIT: GLbitfield = 0x00002000`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_SHADER_STORAGE_BARRIER_BIT: GLbitfield = 0x00002000;
    #[doc = "`GL_SHADER_STORAGE_BLOCK: GLenum = 0x92E6`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_SHADER_STORAGE_BLOCK: GLenum = 0x92E6;
    #[doc = "`GL_SHADER_STORAGE_BUFFER: GLenum = 0x90D2`"]
    #[doc = "* **Groups:** CopyBufferSubDataTarget, BufferTargetARB, BufferStorageTarget"]
    pub const GL_SHADER_STORAGE_BUFFER: GLenum = 0x90D2;
    #[doc = "`GL_SHADER_STORAGE_BUFFER_BINDING: GLenum = 0x90D3`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_SHADER_STORAGE_BUFFER_BINDING: GLenum = 0x90D3;
    #[doc = "`GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT: GLenum = 0x90DF`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT: GLenum = 0x90DF;
    #[doc = "`GL_SHADER_STORAGE_BUFFER_SIZE: GLenum = 0x90D5`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_SHADER_STORAGE_BUFFER_SIZE: GLenum = 0x90D5;
    #[doc = "`GL_SHADER_STORAGE_BUFFER_START: GLenum = 0x90D4`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_SHADER_STORAGE_BUFFER_START: GLenum = 0x90D4;
    #[doc = "`GL_SHADER_TYPE: GLenum = 0x8B4F`"]
    #[doc = "* **Group:** ShaderParameterName"]
    pub const GL_SHADER_TYPE: GLenum = 0x8B4F;
    #[doc = "`GL_SHADING_LANGUAGE_VERSION: GLenum = 0x8B8C`"]
    #[doc = "* **Group:** StringName"]
    pub const GL_SHADING_LANGUAGE_VERSION: GLenum = 0x8B8C;
    #[doc = "`GL_SHORT: GLenum = 0x1402`"]
    #[doc = "* **Groups:** VertexAttribIType, SecondaryColorPointerTypeIBM, WeightPointerTypeARB, TangentPointerTypeEXT, BinormalPointerTypeEXT, IndexPointerType, ListNameType, NormalPointerType, PixelType, TexCoordPointerType, VertexPointerType, VertexAttribType, VertexAttribPointerType"]
    pub const GL_SHORT: GLenum = 0x1402;
    #[doc = "`GL_SIGNALED: GLenum = 0x9119`"]
    pub const GL_SIGNALED: GLenum = 0x9119;
    #[doc = "`GL_SIGNED_NORMALIZED: GLenum = 0x8F9C`"]
    pub const GL_SIGNED_NORMALIZED: GLenum = 0x8F9C;
    #[doc = "`GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST: GLenum = 0x82AC`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST: GLenum = 0x82AC;
    #[doc = "`GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE: GLenum = 0x82AE`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE: GLenum = 0x82AE;
    #[doc = "`GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST: GLenum = 0x82AD`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST: GLenum = 0x82AD;
    #[doc = "`GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE: GLenum = 0x82AF`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE: GLenum = 0x82AF;
    #[doc = "`GL_SMOOTH_LINE_WIDTH_GRANULARITY: GLenum = 0x0B23`"]
    #[doc = "* **Group:** GetPName"]
    #[doc = "* **Alias Of:** `GL_LINE_WIDTH_GRANULARITY`"]
    pub const GL_SMOOTH_LINE_WIDTH_GRANULARITY: GLenum = 0x0B23;
    #[doc = "`GL_SMOOTH_LINE_WIDTH_RANGE: GLenum = 0x0B22`"]
    #[doc = "* **Group:** GetPName"]
    #[doc = "* **Alias Of:** `GL_LINE_WIDTH_RANGE`"]
    pub const GL_SMOOTH_LINE_WIDTH_RANGE: GLenum = 0x0B22;
    #[doc = "`GL_SMOOTH_POINT_SIZE_GRANULARITY: GLenum = 0x0B13`"]
    #[doc = "* **Group:** GetPName"]
    #[doc = "* **Alias Of:** `GL_POINT_SIZE_GRANULARITY`"]
    pub const GL_SMOOTH_POINT_SIZE_GRANULARITY: GLenum = 0x0B13;
    #[doc = "`GL_SMOOTH_POINT_SIZE_RANGE: GLenum = 0x0B12`"]
    #[doc = "* **Group:** GetPName"]
    #[doc = "* **Alias Of:** `GL_POINT_SIZE_RANGE`"]
    pub const GL_SMOOTH_POINT_SIZE_RANGE: GLenum = 0x0B12;
    #[doc = "`GL_SOFTLIGHT: GLenum = 0x929C`"]
    pub const GL_SOFTLIGHT: GLenum = 0x929C;
    #[doc = "`GL_SPIR_V_BINARY: GLenum = 0x9552`"]
    pub const GL_SPIR_V_BINARY: GLenum = 0x9552;
    #[doc = "`GL_SPIR_V_EXTENSIONS: GLenum = 0x9553`"]
    pub const GL_SPIR_V_EXTENSIONS: GLenum = 0x9553;
    #[doc = "`GL_SRC1_ALPHA: GLenum = 0x8589`"]
    #[doc = "* **Group:** BlendingFactor"]
    #[doc = "* **Alias Of:** `GL_SOURCE1_ALPHA`"]
    pub const GL_SRC1_ALPHA: GLenum = 0x8589;
    #[doc = "`GL_SRC1_COLOR: GLenum = 0x88F9`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_SRC1_COLOR: GLenum = 0x88F9;
    #[doc = "`GL_SRC_ALPHA: GLenum = 0x0302`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_SRC_ALPHA: GLenum = 0x0302;
    #[doc = "`GL_SRC_ALPHA_SATURATE: GLenum = 0x0308`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_SRC_ALPHA_SATURATE: GLenum = 0x0308;
    #[doc = "`GL_SRC_COLOR: GLenum = 0x0300`"]
    #[doc = "* **Group:** BlendingFactor"]
    pub const GL_SRC_COLOR: GLenum = 0x0300;
    #[doc = "`GL_SRGB: GLenum = 0x8C40`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_SRGB: GLenum = 0x8C40;
    #[doc = "`GL_SRGB8: GLenum = 0x8C41`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_SRGB8: GLenum = 0x8C41;
    #[doc = "`GL_SRGB8_ALPHA8: GLenum = 0x8C43`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_SRGB8_ALPHA8: GLenum = 0x8C43;
    #[doc = "`GL_SRGB_ALPHA: GLenum = 0x8C42`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_SRGB_ALPHA: GLenum = 0x8C42;
    #[doc = "`GL_SRGB_READ: GLenum = 0x8297`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_SRGB_READ: GLenum = 0x8297;
    #[doc = "`GL_SRGB_WRITE: GLenum = 0x8298`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_SRGB_WRITE: GLenum = 0x8298;
    #[doc = "`GL_STACK_OVERFLOW: GLenum = 0x0503`"]
    #[doc = "* **Group:** ErrorCode"]
    pub const GL_STACK_OVERFLOW: GLenum = 0x0503;
    #[doc = "`GL_STACK_OVERFLOW_KHR: GLenum = 0x0503`"]

    pub const GL_STACK_OVERFLOW_KHR: GLenum = 0x0503;
    #[doc = "`GL_STACK_UNDERFLOW: GLenum = 0x0504`"]
    #[doc = "* **Group:** ErrorCode"]
    pub const GL_STACK_UNDERFLOW: GLenum = 0x0504;
    #[doc = "`GL_STACK_UNDERFLOW_KHR: GLenum = 0x0504`"]

    pub const GL_STACK_UNDERFLOW_KHR: GLenum = 0x0504;
    #[doc = "`GL_STATIC_COPY: GLenum = 0x88E6`"]
    #[doc = "* **Groups:** VertexBufferObjectUsage, BufferUsageARB"]
    pub const GL_STATIC_COPY: GLenum = 0x88E6;
    #[doc = "`GL_STATIC_DRAW: GLenum = 0x88E4`"]
    #[doc = "* **Groups:** VertexBufferObjectUsage, BufferUsageARB"]
    pub const GL_STATIC_DRAW: GLenum = 0x88E4;
    #[doc = "`GL_STATIC_READ: GLenum = 0x88E5`"]
    #[doc = "* **Groups:** VertexBufferObjectUsage, BufferUsageARB"]
    pub const GL_STATIC_READ: GLenum = 0x88E5;
    #[doc = "`GL_STENCIL: GLenum = 0x1802`"]
    #[doc = "* **Groups:** Buffer, PixelCopyType, InvalidateFramebufferAttachment"]
    pub const GL_STENCIL: GLenum = 0x1802;
    #[doc = "`GL_STENCIL_ATTACHMENT: GLenum = 0x8D20`"]
    #[doc = "* **Group:** FramebufferAttachment"]
    pub const GL_STENCIL_ATTACHMENT: GLenum = 0x8D20;
    #[doc = "`GL_STENCIL_BACK_FAIL: GLenum = 0x8801`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_BACK_FAIL: GLenum = 0x8801;
    #[doc = "`GL_STENCIL_BACK_FUNC: GLenum = 0x8800`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_BACK_FUNC: GLenum = 0x8800;
    #[doc = "`GL_STENCIL_BACK_PASS_DEPTH_FAIL: GLenum = 0x8802`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_BACK_PASS_DEPTH_FAIL: GLenum = 0x8802;
    #[doc = "`GL_STENCIL_BACK_PASS_DEPTH_PASS: GLenum = 0x8803`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_BACK_PASS_DEPTH_PASS: GLenum = 0x8803;
    #[doc = "`GL_STENCIL_BACK_REF: GLenum = 0x8CA3`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_BACK_REF: GLenum = 0x8CA3;
    #[doc = "`GL_STENCIL_BACK_VALUE_MASK: GLenum = 0x8CA4`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_BACK_VALUE_MASK: GLenum = 0x8CA4;
    #[doc = "`GL_STENCIL_BACK_WRITEMASK: GLenum = 0x8CA5`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_BACK_WRITEMASK: GLenum = 0x8CA5;
    #[doc = "`GL_STENCIL_BITS: GLenum = 0x0D57`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_BITS: GLenum = 0x0D57;
    #[doc = "`GL_STENCIL_BUFFER_BIT: GLbitfield = 0x00000400`"]
    #[doc = "* **Groups:** ClearBufferMask, AttribMask"]
    pub const GL_STENCIL_BUFFER_BIT: GLbitfield = 0x00000400;
    #[doc = "`GL_STENCIL_CLEAR_VALUE: GLenum = 0x0B91`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_CLEAR_VALUE: GLenum = 0x0B91;
    #[doc = "`GL_STENCIL_COMPONENTS: GLenum = 0x8285`"]
    pub const GL_STENCIL_COMPONENTS: GLenum = 0x8285;
    #[doc = "`GL_STENCIL_FAIL: GLenum = 0x0B94`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_FAIL: GLenum = 0x0B94;
    #[doc = "`GL_STENCIL_FUNC: GLenum = 0x0B92`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_FUNC: GLenum = 0x0B92;
    #[doc = "`GL_STENCIL_INDEX: GLenum = 0x1901`"]
    #[doc = "* **Groups:** InternalFormat, PixelFormat"]
    pub const GL_STENCIL_INDEX: GLenum = 0x1901;
    #[doc = "`GL_STENCIL_INDEX1: GLenum = 0x8D46`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_STENCIL_INDEX1: GLenum = 0x8D46;
    #[doc = "`GL_STENCIL_INDEX16: GLenum = 0x8D49`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_STENCIL_INDEX16: GLenum = 0x8D49;
    #[doc = "`GL_STENCIL_INDEX4: GLenum = 0x8D47`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_STENCIL_INDEX4: GLenum = 0x8D47;
    #[doc = "`GL_STENCIL_INDEX8: GLenum = 0x8D48`"]
    #[doc = "* **Group:** InternalFormat"]
    pub const GL_STENCIL_INDEX8: GLenum = 0x8D48;
    #[doc = "`GL_STENCIL_PASS_DEPTH_FAIL: GLenum = 0x0B95`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_PASS_DEPTH_FAIL: GLenum = 0x0B95;
    #[doc = "`GL_STENCIL_PASS_DEPTH_PASS: GLenum = 0x0B96`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_PASS_DEPTH_PASS: GLenum = 0x0B96;
    #[doc = "`GL_STENCIL_REF: GLenum = 0x0B97`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_REF: GLenum = 0x0B97;
    #[doc = "`GL_STENCIL_RENDERABLE: GLenum = 0x8288`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_STENCIL_RENDERABLE: GLenum = 0x8288;
    #[doc = "`GL_STENCIL_TEST: GLenum = 0x0B90`"]
    #[doc = "* **Groups:** GetPName, EnableCap"]
    pub const GL_STENCIL_TEST: GLenum = 0x0B90;
    #[doc = "`GL_STENCIL_VALUE_MASK: GLenum = 0x0B93`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_VALUE_MASK: GLenum = 0x0B93;
    #[doc = "`GL_STENCIL_WRITEMASK: GLenum = 0x0B98`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_STENCIL_WRITEMASK: GLenum = 0x0B98;
    #[doc = "`GL_STEREO: GLenum = 0x0C33`"]
    #[doc = "* **Groups:** GetFramebufferParameter, GetPName"]
    pub const GL_STEREO: GLenum = 0x0C33;
    #[doc = "`GL_STREAM_COPY: GLenum = 0x88E2`"]
    #[doc = "* **Groups:** VertexBufferObjectUsage, BufferUsageARB"]
    pub const GL_STREAM_COPY: GLenum = 0x88E2;
    #[doc = "`GL_STREAM_DRAW: GLenum = 0x88E0`"]
    #[doc = "* **Groups:** VertexBufferObjectUsage, BufferUsageARB"]
    pub const GL_STREAM_DRAW: GLenum = 0x88E0;
    #[doc = "`GL_STREAM_READ: GLenum = 0x88E1`"]
    #[doc = "* **Groups:** VertexBufferObjectUsage, BufferUsageARB"]
    pub const GL_STREAM_READ: GLenum = 0x88E1;
    #[doc = "`GL_SUBPIXEL_BITS: GLenum = 0x0D50`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_SUBPIXEL_BITS: GLenum = 0x0D50;
    #[doc = "`GL_SYNC_CONDITION: GLenum = 0x9113`"]
    #[doc = "* **Group:** SyncParameterName"]
    pub const GL_SYNC_CONDITION: GLenum = 0x9113;
    #[doc = "`GL_SYNC_FENCE: GLenum = 0x9116`"]
    pub const GL_SYNC_FENCE: GLenum = 0x9116;
    #[doc = "`GL_SYNC_FLAGS: GLenum = 0x9115`"]
    #[doc = "* **Group:** SyncParameterName"]
    pub const GL_SYNC_FLAGS: GLenum = 0x9115;
    #[doc = "`GL_SYNC_FLUSH_COMMANDS_BIT: GLbitfield = 0x00000001`"]
    #[doc = "* **Group:** SyncObjectMask"]
    pub const GL_SYNC_FLUSH_COMMANDS_BIT: GLbitfield = 0x00000001;
    #[doc = "`GL_SYNC_GPU_COMMANDS_COMPLETE: GLenum = 0x9117`"]
    #[doc = "* **Group:** SyncCondition"]
    pub const GL_SYNC_GPU_COMMANDS_COMPLETE: GLenum = 0x9117;
    #[doc = "`GL_SYNC_STATUS: GLenum = 0x9114`"]
    #[doc = "* **Group:** SyncParameterName"]
    pub const GL_SYNC_STATUS: GLenum = 0x9114;
    #[doc = "`GL_TESS_CONTROL_OUTPUT_VERTICES: GLenum = 0x8E75`"]
    pub const GL_TESS_CONTROL_OUTPUT_VERTICES: GLenum = 0x8E75;
    #[doc = "`GL_TESS_CONTROL_SHADER: GLenum = 0x8E88`"]
    #[doc = "* **Groups:** PipelineParameterName, ShaderType"]
    pub const GL_TESS_CONTROL_SHADER: GLenum = 0x8E88;
    #[doc = "`GL_TESS_CONTROL_SHADER_BIT: GLbitfield = 0x00000008`"]
    #[doc = "* **Group:** UseProgramStageMask"]
    pub const GL_TESS_CONTROL_SHADER_BIT: GLbitfield = 0x00000008;
    #[doc = "`GL_TESS_CONTROL_SHADER_PATCHES: GLenum = 0x82F1`"]
    pub const GL_TESS_CONTROL_SHADER_PATCHES: GLenum = 0x82F1;
    #[doc = "`GL_TESS_CONTROL_SUBROUTINE: GLenum = 0x92E9`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_TESS_CONTROL_SUBROUTINE: GLenum = 0x92E9;
    #[doc = "`GL_TESS_CONTROL_SUBROUTINE_UNIFORM: GLenum = 0x92EF`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_TESS_CONTROL_SUBROUTINE_UNIFORM: GLenum = 0x92EF;
    #[doc = "`GL_TESS_CONTROL_TEXTURE: GLenum = 0x829C`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_TESS_CONTROL_TEXTURE: GLenum = 0x829C;
    #[doc = "`GL_TESS_EVALUATION_SHADER: GLenum = 0x8E87`"]
    #[doc = "* **Groups:** PipelineParameterName, ShaderType"]
    pub const GL_TESS_EVALUATION_SHADER: GLenum = 0x8E87;
    #[doc = "`GL_TESS_EVALUATION_SHADER_BIT: GLbitfield = 0x00000010`"]
    #[doc = "* **Group:** UseProgramStageMask"]
    pub const GL_TESS_EVALUATION_SHADER_BIT: GLbitfield = 0x00000010;
    #[doc = "`GL_TESS_EVALUATION_SHADER_INVOCATIONS: GLenum = 0x82F2`"]
    pub const GL_TESS_EVALUATION_SHADER_INVOCATIONS: GLenum = 0x82F2;
    #[doc = "`GL_TESS_EVALUATION_SUBROUTINE: GLenum = 0x92EA`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_TESS_EVALUATION_SUBROUTINE: GLenum = 0x92EA;
    #[doc = "`GL_TESS_EVALUATION_SUBROUTINE_UNIFORM: GLenum = 0x92F0`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_TESS_EVALUATION_SUBROUTINE_UNIFORM: GLenum = 0x92F0;
    #[doc = "`GL_TESS_EVALUATION_TEXTURE: GLenum = 0x829D`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_TESS_EVALUATION_TEXTURE: GLenum = 0x829D;
    #[doc = "`GL_TESS_GEN_MODE: GLenum = 0x8E76`"]
    pub const GL_TESS_GEN_MODE: GLenum = 0x8E76;
    #[doc = "`GL_TESS_GEN_POINT_MODE: GLenum = 0x8E79`"]
    pub const GL_TESS_GEN_POINT_MODE: GLenum = 0x8E79;
    #[doc = "`GL_TESS_GEN_SPACING: GLenum = 0x8E77`"]
    pub const GL_TESS_GEN_SPACING: GLenum = 0x8E77;
    #[doc = "`GL_TESS_GEN_VERTEX_ORDER: GLenum = 0x8E78`"]
    pub const GL_TESS_GEN_VERTEX_ORDER: GLenum = 0x8E78;
    #[doc = "`GL_TEXTURE: GLenum = 0x1702`"]
    #[doc = "* **Groups:** ObjectIdentifier, MatrixMode"]
    pub const GL_TEXTURE: GLenum = 0x1702;
    #[doc = "`GL_TEXTURE0: GLenum = 0x84C0`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE0: GLenum = 0x84C0;
    #[doc = "`GL_TEXTURE1: GLenum = 0x84C1`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE1: GLenum = 0x84C1;
    #[doc = "`GL_TEXTURE10: GLenum = 0x84CA`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE10: GLenum = 0x84CA;
    #[doc = "`GL_TEXTURE11: GLenum = 0x84CB`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE11: GLenum = 0x84CB;
    #[doc = "`GL_TEXTURE12: GLenum = 0x84CC`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE12: GLenum = 0x84CC;
    #[doc = "`GL_TEXTURE13: GLenum = 0x84CD`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE13: GLenum = 0x84CD;
    #[doc = "`GL_TEXTURE14: GLenum = 0x84CE`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE14: GLenum = 0x84CE;
    #[doc = "`GL_TEXTURE15: GLenum = 0x84CF`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE15: GLenum = 0x84CF;
    #[doc = "`GL_TEXTURE16: GLenum = 0x84D0`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE16: GLenum = 0x84D0;
    #[doc = "`GL_TEXTURE17: GLenum = 0x84D1`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE17: GLenum = 0x84D1;
    #[doc = "`GL_TEXTURE18: GLenum = 0x84D2`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE18: GLenum = 0x84D2;
    #[doc = "`GL_TEXTURE19: GLenum = 0x84D3`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE19: GLenum = 0x84D3;
    #[doc = "`GL_TEXTURE2: GLenum = 0x84C2`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE2: GLenum = 0x84C2;
    #[doc = "`GL_TEXTURE20: GLenum = 0x84D4`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE20: GLenum = 0x84D4;
    #[doc = "`GL_TEXTURE21: GLenum = 0x84D5`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE21: GLenum = 0x84D5;
    #[doc = "`GL_TEXTURE22: GLenum = 0x84D6`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE22: GLenum = 0x84D6;
    #[doc = "`GL_TEXTURE23: GLenum = 0x84D7`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE23: GLenum = 0x84D7;
    #[doc = "`GL_TEXTURE24: GLenum = 0x84D8`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE24: GLenum = 0x84D8;
    #[doc = "`GL_TEXTURE25: GLenum = 0x84D9`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE25: GLenum = 0x84D9;
    #[doc = "`GL_TEXTURE26: GLenum = 0x84DA`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE26: GLenum = 0x84DA;
    #[doc = "`GL_TEXTURE27: GLenum = 0x84DB`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE27: GLenum = 0x84DB;
    #[doc = "`GL_TEXTURE28: GLenum = 0x84DC`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE28: GLenum = 0x84DC;
    #[doc = "`GL_TEXTURE29: GLenum = 0x84DD`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE29: GLenum = 0x84DD;
    #[doc = "`GL_TEXTURE3: GLenum = 0x84C3`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE3: GLenum = 0x84C3;
    #[doc = "`GL_TEXTURE30: GLenum = 0x84DE`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE30: GLenum = 0x84DE;
    #[doc = "`GL_TEXTURE31: GLenum = 0x84DF`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE31: GLenum = 0x84DF;
    #[doc = "`GL_TEXTURE4: GLenum = 0x84C4`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE4: GLenum = 0x84C4;
    #[doc = "`GL_TEXTURE5: GLenum = 0x84C5`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE5: GLenum = 0x84C5;
    #[doc = "`GL_TEXTURE6: GLenum = 0x84C6`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE6: GLenum = 0x84C6;
    #[doc = "`GL_TEXTURE7: GLenum = 0x84C7`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE7: GLenum = 0x84C7;
    #[doc = "`GL_TEXTURE8: GLenum = 0x84C8`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE8: GLenum = 0x84C8;
    #[doc = "`GL_TEXTURE9: GLenum = 0x84C9`"]
    #[doc = "* **Group:** TextureUnit"]
    pub const GL_TEXTURE9: GLenum = 0x84C9;
    #[doc = "`GL_TEXTURE_1D: GLenum = 0x0DE0`"]
    #[doc = "* **Groups:** CopyImageSubDataTarget, EnableCap, GetPName, TextureTarget"]
    pub const GL_TEXTURE_1D: GLenum = 0x0DE0;
    #[doc = "`GL_TEXTURE_1D_ARRAY: GLenum = 0x8C18`"]
    #[doc = "* **Groups:** CopyImageSubDataTarget, TextureTarget"]
    pub const GL_TEXTURE_1D_ARRAY: GLenum = 0x8C18;
    #[doc = "`GL_TEXTURE_2D: GLenum = 0x0DE1`"]
    #[doc = "* **Groups:** CopyImageSubDataTarget, EnableCap, GetPName, TextureTarget"]
    pub const GL_TEXTURE_2D: GLenum = 0x0DE1;
    #[doc = "`GL_TEXTURE_2D_ARRAY: GLenum = 0x8C1A`"]
    #[doc = "* **Groups:** CopyImageSubDataTarget, TextureTarget"]
    pub const GL_TEXTURE_2D_ARRAY: GLenum = 0x8C1A;
    #[doc = "`GL_TEXTURE_2D_MULTISAMPLE: GLenum = 0x9100`"]
    #[doc = "* **Groups:** CopyImageSubDataTarget, TextureTarget"]
    pub const GL_TEXTURE_2D_MULTISAMPLE: GLenum = 0x9100;
    #[doc = "`GL_TEXTURE_2D_MULTISAMPLE_ARRAY: GLenum = 0x9102`"]
    #[doc = "* **Groups:** CopyImageSubDataTarget, TextureTarget"]
    pub const GL_TEXTURE_2D_MULTISAMPLE_ARRAY: GLenum = 0x9102;
    #[doc = "`GL_TEXTURE_3D: GLenum = 0x806F`"]
    #[doc = "* **Groups:** CopyImageSubDataTarget, TextureTarget"]
    pub const GL_TEXTURE_3D: GLenum = 0x806F;
    #[doc = "`GL_TEXTURE_ALPHA_SIZE: GLenum = 0x805F`"]
    #[doc = "* **Groups:** TextureParameterName, GetTextureParameter"]
    pub const GL_TEXTURE_ALPHA_SIZE: GLenum = 0x805F;
    #[doc = "`GL_TEXTURE_ALPHA_TYPE: GLenum = 0x8C13`"]
    pub const GL_TEXTURE_ALPHA_TYPE: GLenum = 0x8C13;
    #[doc = "`GL_TEXTURE_BASE_LEVEL: GLenum = 0x813C`"]
    #[doc = "* **Group:** TextureParameterName"]
    pub const GL_TEXTURE_BASE_LEVEL: GLenum = 0x813C;
    #[doc = "`GL_TEXTURE_BINDING_1D: GLenum = 0x8068`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_TEXTURE_BINDING_1D: GLenum = 0x8068;
    #[doc = "`GL_TEXTURE_BINDING_1D_ARRAY: GLenum = 0x8C1C`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_TEXTURE_BINDING_1D_ARRAY: GLenum = 0x8C1C;
    #[doc = "`GL_TEXTURE_BINDING_2D: GLenum = 0x8069`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_TEXTURE_BINDING_2D: GLenum = 0x8069;
    #[doc = "`GL_TEXTURE_BINDING_2D_ARRAY: GLenum = 0x8C1D`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_TEXTURE_BINDING_2D_ARRAY: GLenum = 0x8C1D;
    #[doc = "`GL_TEXTURE_BINDING_2D_MULTISAMPLE: GLenum = 0x9104`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_TEXTURE_BINDING_2D_MULTISAMPLE: GLenum = 0x9104;
    #[doc = "`GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY: GLenum = 0x9105`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY: GLenum = 0x9105;
    #[doc = "`GL_TEXTURE_BINDING_3D: GLenum = 0x806A`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_TEXTURE_BINDING_3D: GLenum = 0x806A;
    #[doc = "`GL_TEXTURE_BINDING_BUFFER: GLenum = 0x8C2C`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_TEXTURE_BINDING_BUFFER: GLenum = 0x8C2C;
    #[doc = "`GL_TEXTURE_BINDING_CUBE_MAP: GLenum = 0x8514`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_TEXTURE_BINDING_CUBE_MAP: GLenum = 0x8514;
    #[doc = "`GL_TEXTURE_BINDING_CUBE_MAP_ARRAY: GLenum = 0x900A`"]
    pub const GL_TEXTURE_BINDING_CUBE_MAP_ARRAY: GLenum = 0x900A;
    #[doc = "`GL_TEXTURE_BINDING_RECTANGLE: GLenum = 0x84F6`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_TEXTURE_BINDING_RECTANGLE: GLenum = 0x84F6;
    #[doc = "`GL_TEXTURE_BLUE_SIZE: GLenum = 0x805E`"]
    #[doc = "* **Groups:** TextureParameterName, GetTextureParameter"]
    pub const GL_TEXTURE_BLUE_SIZE: GLenum = 0x805E;
    #[doc = "`GL_TEXTURE_BLUE_TYPE: GLenum = 0x8C12`"]
    pub const GL_TEXTURE_BLUE_TYPE: GLenum = 0x8C12;
    #[doc = "`GL_TEXTURE_BORDER_COLOR: GLenum = 0x1004`"]
    #[doc = "* **Groups:** SamplerParameterF, GetTextureParameter, TextureParameterName"]
    pub const GL_TEXTURE_BORDER_COLOR: GLenum = 0x1004;
    #[doc = "`GL_TEXTURE_BUFFER: GLenum = 0x8C2A`"]
    #[doc = "* **Groups:** TextureTarget, CopyBufferSubDataTarget, BufferTargetARB, BufferStorageTarget"]
    pub const GL_TEXTURE_BUFFER: GLenum = 0x8C2A;
    #[doc = "`GL_TEXTURE_BUFFER_BINDING: GLenum = 0x8C2A`"]
    pub const GL_TEXTURE_BUFFER_BINDING: GLenum = 0x8C2A;
    #[doc = "`GL_TEXTURE_BUFFER_DATA_STORE_BINDING: GLenum = 0x8C2D`"]
    pub const GL_TEXTURE_BUFFER_DATA_STORE_BINDING: GLenum = 0x8C2D;
    #[doc = "`GL_TEXTURE_BUFFER_OFFSET: GLenum = 0x919D`"]
    pub const GL_TEXTURE_BUFFER_OFFSET: GLenum = 0x919D;
    #[doc = "`GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT: GLenum = 0x919F`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT: GLenum = 0x919F;
    #[doc = "`GL_TEXTURE_BUFFER_SIZE: GLenum = 0x919E`"]
    pub const GL_TEXTURE_BUFFER_SIZE: GLenum = 0x919E;
    #[doc = "`GL_TEXTURE_COMPARE_FUNC: GLenum = 0x884D`"]
    #[doc = "* **Groups:** SamplerParameterI, TextureParameterName"]
    pub const GL_TEXTURE_COMPARE_FUNC: GLenum = 0x884D;
    #[doc = "`GL_TEXTURE_COMPARE_MODE: GLenum = 0x884C`"]
    #[doc = "* **Groups:** SamplerParameterI, TextureParameterName"]
    pub const GL_TEXTURE_COMPARE_MODE: GLenum = 0x884C;
    #[doc = "`GL_TEXTURE_COMPRESSED: GLenum = 0x86A1`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_TEXTURE_COMPRESSED: GLenum = 0x86A1;
    #[doc = "`GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT: GLenum = 0x82B2`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT: GLenum = 0x82B2;
    #[doc = "`GL_TEXTURE_COMPRESSED_BLOCK_SIZE: GLenum = 0x82B3`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_TEXTURE_COMPRESSED_BLOCK_SIZE: GLenum = 0x82B3;
    #[doc = "`GL_TEXTURE_COMPRESSED_BLOCK_WIDTH: GLenum = 0x82B1`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_TEXTURE_COMPRESSED_BLOCK_WIDTH: GLenum = 0x82B1;
    #[doc = "`GL_TEXTURE_COMPRESSED_IMAGE_SIZE: GLenum = 0x86A0`"]
    pub const GL_TEXTURE_COMPRESSED_IMAGE_SIZE: GLenum = 0x86A0;
    #[doc = "`GL_TEXTURE_COMPRESSION_HINT: GLenum = 0x84EF`"]
    #[doc = "* **Groups:** HintTarget, GetPName"]
    pub const GL_TEXTURE_COMPRESSION_HINT: GLenum = 0x84EF;
    #[doc = "`GL_TEXTURE_CUBE_MAP: GLenum = 0x8513`"]
    #[doc = "* **Groups:** CopyImageSubDataTarget, TextureTarget"]
    pub const GL_TEXTURE_CUBE_MAP: GLenum = 0x8513;
    #[doc = "`GL_TEXTURE_CUBE_MAP_ARRAY: GLenum = 0x9009`"]
    #[doc = "* **Groups:** CopyImageSubDataTarget, TextureTarget"]
    pub const GL_TEXTURE_CUBE_MAP_ARRAY: GLenum = 0x9009;
    #[doc = "`GL_TEXTURE_CUBE_MAP_NEGATIVE_X: GLenum = 0x8516`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_TEXTURE_CUBE_MAP_NEGATIVE_X: GLenum = 0x8516;
    #[doc = "`GL_TEXTURE_CUBE_MAP_NEGATIVE_Y: GLenum = 0x8518`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_TEXTURE_CUBE_MAP_NEGATIVE_Y: GLenum = 0x8518;
    #[doc = "`GL_TEXTURE_CUBE_MAP_NEGATIVE_Z: GLenum = 0x851A`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_TEXTURE_CUBE_MAP_NEGATIVE_Z: GLenum = 0x851A;
    #[doc = "`GL_TEXTURE_CUBE_MAP_POSITIVE_X: GLenum = 0x8515`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_TEXTURE_CUBE_MAP_POSITIVE_X: GLenum = 0x8515;
    #[doc = "`GL_TEXTURE_CUBE_MAP_POSITIVE_Y: GLenum = 0x8517`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_TEXTURE_CUBE_MAP_POSITIVE_Y: GLenum = 0x8517;
    #[doc = "`GL_TEXTURE_CUBE_MAP_POSITIVE_Z: GLenum = 0x8519`"]
    #[doc = "* **Group:** TextureTarget"]
    pub const GL_TEXTURE_CUBE_MAP_POSITIVE_Z: GLenum = 0x8519;
    #[doc = "`GL_TEXTURE_CUBE_MAP_SEAMLESS: GLenum = 0x884F`"]
    #[doc = "* **Group:** EnableCap"]
    pub const GL_TEXTURE_CUBE_MAP_SEAMLESS: GLenum = 0x884F;
    #[doc = "`GL_TEXTURE_DEPTH: GLenum = 0x8071`"]
    pub const GL_TEXTURE_DEPTH: GLenum = 0x8071;
    #[doc = "`GL_TEXTURE_DEPTH_SIZE: GLenum = 0x884A`"]
    pub const GL_TEXTURE_DEPTH_SIZE: GLenum = 0x884A;
    #[doc = "`GL_TEXTURE_DEPTH_TYPE: GLenum = 0x8C16`"]
    pub const GL_TEXTURE_DEPTH_TYPE: GLenum = 0x8C16;
    #[doc = "`GL_TEXTURE_FETCH_BARRIER_BIT: GLbitfield = 0x00000008`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_TEXTURE_FETCH_BARRIER_BIT: GLbitfield = 0x00000008;
    #[doc = "`GL_TEXTURE_FIXED_SAMPLE_LOCATIONS: GLenum = 0x9107`"]
    pub const GL_TEXTURE_FIXED_SAMPLE_LOCATIONS: GLenum = 0x9107;
    #[doc = "`GL_TEXTURE_GATHER: GLenum = 0x82A2`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_TEXTURE_GATHER: GLenum = 0x82A2;
    #[doc = "`GL_TEXTURE_GATHER_SHADOW: GLenum = 0x82A3`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_TEXTURE_GATHER_SHADOW: GLenum = 0x82A3;
    #[doc = "`GL_TEXTURE_GREEN_SIZE: GLenum = 0x805D`"]
    #[doc = "* **Groups:** TextureParameterName, GetTextureParameter"]
    pub const GL_TEXTURE_GREEN_SIZE: GLenum = 0x805D;
    #[doc = "`GL_TEXTURE_GREEN_TYPE: GLenum = 0x8C11`"]
    pub const GL_TEXTURE_GREEN_TYPE: GLenum = 0x8C11;
    #[doc = "`GL_TEXTURE_HEIGHT: GLenum = 0x1001`"]
    #[doc = "* **Groups:** TextureParameterName, GetTextureParameter"]
    pub const GL_TEXTURE_HEIGHT: GLenum = 0x1001;
    #[doc = "`GL_TEXTURE_IMAGE_FORMAT: GLenum = 0x828F`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_TEXTURE_IMAGE_FORMAT: GLenum = 0x828F;
    #[doc = "`GL_TEXTURE_IMAGE_TYPE: GLenum = 0x8290`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_TEXTURE_IMAGE_TYPE: GLenum = 0x8290;
    #[doc = "`GL_TEXTURE_IMMUTABLE_FORMAT: GLenum = 0x912F`"]
    pub const GL_TEXTURE_IMMUTABLE_FORMAT: GLenum = 0x912F;
    #[doc = "`GL_TEXTURE_IMMUTABLE_LEVELS: GLenum = 0x82DF`"]
    pub const GL_TEXTURE_IMMUTABLE_LEVELS: GLenum = 0x82DF;
    #[doc = "`GL_TEXTURE_INTERNAL_FORMAT: GLenum = 0x1003`"]
    #[doc = "* **Groups:** TextureParameterName, GetTextureParameter"]
    pub const GL_TEXTURE_INTERNAL_FORMAT: GLenum = 0x1003;
    #[doc = "`GL_TEXTURE_LOD_BIAS: GLenum = 0x8501`"]
    #[doc = "* **Groups:** TextureParameterName, SamplerParameterF"]
    pub const GL_TEXTURE_LOD_BIAS: GLenum = 0x8501;
    #[doc = "`GL_TEXTURE_MAG_FILTER: GLenum = 0x2800`"]
    #[doc = "* **Groups:** SamplerParameterI, GetTextureParameter, TextureParameterName"]
    pub const GL_TEXTURE_MAG_FILTER: GLenum = 0x2800;
    #[doc = "`GL_TEXTURE_MAX_ANISOTROPY: GLenum = 0x84FE`"]
    #[doc = "* **Group:** SamplerParameterF"]
    pub const GL_TEXTURE_MAX_ANISOTROPY: GLenum = 0x84FE;
    #[doc = "`GL_TEXTURE_MAX_ANISOTROPY_EXT: GLenum = 0x84FE`"]
    #[doc = "* **Alias Of:** `GL_TEXTURE_MAX_ANISOTROPY`"]

    pub const GL_TEXTURE_MAX_ANISOTROPY_EXT: GLenum = 0x84FE;
    #[doc = "`GL_TEXTURE_MAX_LEVEL: GLenum = 0x813D`"]
    #[doc = "* **Group:** TextureParameterName"]
    pub const GL_TEXTURE_MAX_LEVEL: GLenum = 0x813D;
    #[doc = "`GL_TEXTURE_MAX_LOD: GLenum = 0x813B`"]
    #[doc = "* **Groups:** SamplerParameterF, TextureParameterName"]
    pub const GL_TEXTURE_MAX_LOD: GLenum = 0x813B;
    #[doc = "`GL_TEXTURE_MIN_FILTER: GLenum = 0x2801`"]
    #[doc = "* **Groups:** SamplerParameterI, GetTextureParameter, TextureParameterName"]
    pub const GL_TEXTURE_MIN_FILTER: GLenum = 0x2801;
    #[doc = "`GL_TEXTURE_MIN_LOD: GLenum = 0x813A`"]
    #[doc = "* **Groups:** SamplerParameterF, TextureParameterName"]
    pub const GL_TEXTURE_MIN_LOD: GLenum = 0x813A;
    #[doc = "`GL_TEXTURE_RECTANGLE: GLenum = 0x84F5`"]
    #[doc = "* **Groups:** CopyImageSubDataTarget, TextureTarget"]
    pub const GL_TEXTURE_RECTANGLE: GLenum = 0x84F5;
    #[doc = "`GL_TEXTURE_RED_SIZE: GLenum = 0x805C`"]
    #[doc = "* **Groups:** TextureParameterName, GetTextureParameter"]
    pub const GL_TEXTURE_RED_SIZE: GLenum = 0x805C;
    #[doc = "`GL_TEXTURE_RED_TYPE: GLenum = 0x8C10`"]
    pub const GL_TEXTURE_RED_TYPE: GLenum = 0x8C10;
    #[doc = "`GL_TEXTURE_SAMPLES: GLenum = 0x9106`"]
    pub const GL_TEXTURE_SAMPLES: GLenum = 0x9106;
    #[doc = "`GL_TEXTURE_SHADOW: GLenum = 0x82A1`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_TEXTURE_SHADOW: GLenum = 0x82A1;
    #[doc = "`GL_TEXTURE_SHARED_SIZE: GLenum = 0x8C3F`"]
    pub const GL_TEXTURE_SHARED_SIZE: GLenum = 0x8C3F;
    #[doc = "`GL_TEXTURE_STENCIL_SIZE: GLenum = 0x88F1`"]
    pub const GL_TEXTURE_STENCIL_SIZE: GLenum = 0x88F1;
    #[doc = "`GL_TEXTURE_SWIZZLE_A: GLenum = 0x8E45`"]
    #[doc = "* **Group:** TextureParameterName"]
    pub const GL_TEXTURE_SWIZZLE_A: GLenum = 0x8E45;
    #[doc = "`GL_TEXTURE_SWIZZLE_B: GLenum = 0x8E44`"]
    #[doc = "* **Group:** TextureParameterName"]
    pub const GL_TEXTURE_SWIZZLE_B: GLenum = 0x8E44;
    #[doc = "`GL_TEXTURE_SWIZZLE_G: GLenum = 0x8E43`"]
    #[doc = "* **Group:** TextureParameterName"]
    pub const GL_TEXTURE_SWIZZLE_G: GLenum = 0x8E43;
    #[doc = "`GL_TEXTURE_SWIZZLE_R: GLenum = 0x8E42`"]
    #[doc = "* **Group:** TextureParameterName"]
    pub const GL_TEXTURE_SWIZZLE_R: GLenum = 0x8E42;
    #[doc = "`GL_TEXTURE_SWIZZLE_RGBA: GLenum = 0x8E46`"]
    #[doc = "* **Group:** TextureParameterName"]
    pub const GL_TEXTURE_SWIZZLE_RGBA: GLenum = 0x8E46;
    #[doc = "`GL_TEXTURE_TARGET: GLenum = 0x1006`"]
    pub const GL_TEXTURE_TARGET: GLenum = 0x1006;
    #[doc = "`GL_TEXTURE_UPDATE_BARRIER_BIT: GLbitfield = 0x00000100`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_TEXTURE_UPDATE_BARRIER_BIT: GLbitfield = 0x00000100;
    #[doc = "`GL_TEXTURE_VIEW: GLenum = 0x82B5`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_TEXTURE_VIEW: GLenum = 0x82B5;
    #[doc = "`GL_TEXTURE_VIEW_MIN_LAYER: GLenum = 0x82DD`"]
    pub const GL_TEXTURE_VIEW_MIN_LAYER: GLenum = 0x82DD;
    #[doc = "`GL_TEXTURE_VIEW_MIN_LEVEL: GLenum = 0x82DB`"]
    pub const GL_TEXTURE_VIEW_MIN_LEVEL: GLenum = 0x82DB;
    #[doc = "`GL_TEXTURE_VIEW_NUM_LAYERS: GLenum = 0x82DE`"]
    pub const GL_TEXTURE_VIEW_NUM_LAYERS: GLenum = 0x82DE;
    #[doc = "`GL_TEXTURE_VIEW_NUM_LEVELS: GLenum = 0x82DC`"]
    pub const GL_TEXTURE_VIEW_NUM_LEVELS: GLenum = 0x82DC;
    #[doc = "`GL_TEXTURE_WIDTH: GLenum = 0x1000`"]
    #[doc = "* **Groups:** TextureParameterName, GetTextureParameter"]
    pub const GL_TEXTURE_WIDTH: GLenum = 0x1000;
    #[doc = "`GL_TEXTURE_WRAP_R: GLenum = 0x8072`"]
    #[doc = "* **Groups:** SamplerParameterI, TextureParameterName"]
    pub const GL_TEXTURE_WRAP_R: GLenum = 0x8072;
    #[doc = "`GL_TEXTURE_WRAP_S: GLenum = 0x2802`"]
    #[doc = "* **Groups:** SamplerParameterI, GetTextureParameter, TextureParameterName"]
    pub const GL_TEXTURE_WRAP_S: GLenum = 0x2802;
    #[doc = "`GL_TEXTURE_WRAP_T: GLenum = 0x2803`"]
    #[doc = "* **Groups:** SamplerParameterI, GetTextureParameter, TextureParameterName"]
    pub const GL_TEXTURE_WRAP_T: GLenum = 0x2803;
    #[doc = "`GL_TIMEOUT_EXPIRED: GLenum = 0x911B`"]
    #[doc = "* **Group:** SyncStatus"]
    pub const GL_TIMEOUT_EXPIRED: GLenum = 0x911B;
    #[doc = "`GL_TIMEOUT_IGNORED: u64 = 0xFFFFFFFFFFFFFFFF`"]
    pub const GL_TIMEOUT_IGNORED: u64 = 0xFFFFFFFFFFFFFFFF;
    #[doc = "`GL_TIMESTAMP: GLenum = 0x8E28`"]
    #[doc = "* **Groups:** QueryCounterTarget, GetPName"]
    pub const GL_TIMESTAMP: GLenum = 0x8E28;
    #[doc = "`GL_TIME_ELAPSED: GLenum = 0x88BF`"]
    #[doc = "* **Group:** QueryTarget"]
    pub const GL_TIME_ELAPSED: GLenum = 0x88BF;
    #[doc = "`GL_TOP_LEVEL_ARRAY_SIZE: GLenum = 0x930C`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_TOP_LEVEL_ARRAY_SIZE: GLenum = 0x930C;
    #[doc = "`GL_TOP_LEVEL_ARRAY_STRIDE: GLenum = 0x930D`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_TOP_LEVEL_ARRAY_STRIDE: GLenum = 0x930D;
    #[doc = "`GL_TRANSFORM_FEEDBACK: GLenum = 0x8E22`"]
    #[doc = "* **Groups:** ObjectIdentifier, BindTransformFeedbackTarget"]
    pub const GL_TRANSFORM_FEEDBACK: GLenum = 0x8E22;
    #[doc = "`GL_TRANSFORM_FEEDBACK_ACTIVE: GLenum = 0x8E24`"]
    #[doc = "* **Group:** TransformFeedbackPName"]
    #[doc = "* **Alias Of:** `GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE`"]
    pub const GL_TRANSFORM_FEEDBACK_ACTIVE: GLenum = 0x8E24;
    #[doc = "`GL_TRANSFORM_FEEDBACK_BARRIER_BIT: GLbitfield = 0x00000800`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_TRANSFORM_FEEDBACK_BARRIER_BIT: GLbitfield = 0x00000800;
    #[doc = "`GL_TRANSFORM_FEEDBACK_BINDING: GLenum = 0x8E25`"]
    pub const GL_TRANSFORM_FEEDBACK_BINDING: GLenum = 0x8E25;
    #[doc = "`GL_TRANSFORM_FEEDBACK_BUFFER: GLenum = 0x8C8E`"]
    #[doc = "* **Groups:** ProgramInterface, BufferTargetARB, BufferStorageTarget, CopyBufferSubDataTarget"]
    pub const GL_TRANSFORM_FEEDBACK_BUFFER: GLenum = 0x8C8E;
    #[doc = "`GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE: GLenum = 0x8E24`"]
    pub const GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE: GLenum = 0x8E24;
    #[doc = "`GL_TRANSFORM_FEEDBACK_BUFFER_BINDING: GLenum = 0x8C8F`"]
    #[doc = "* **Groups:** TransformFeedbackPName, GetPName"]
    pub const GL_TRANSFORM_FEEDBACK_BUFFER_BINDING: GLenum = 0x8C8F;
    #[doc = "`GL_TRANSFORM_FEEDBACK_BUFFER_INDEX: GLenum = 0x934B`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_TRANSFORM_FEEDBACK_BUFFER_INDEX: GLenum = 0x934B;
    #[doc = "`GL_TRANSFORM_FEEDBACK_BUFFER_MODE: GLenum = 0x8C7F`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_TRANSFORM_FEEDBACK_BUFFER_MODE: GLenum = 0x8C7F;
    #[doc = "`GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED: GLenum = 0x8E23`"]
    pub const GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED: GLenum = 0x8E23;
    #[doc = "`GL_TRANSFORM_FEEDBACK_BUFFER_SIZE: GLenum = 0x8C85`"]
    #[doc = "* **Groups:** TransformFeedbackPName, GetPName"]
    pub const GL_TRANSFORM_FEEDBACK_BUFFER_SIZE: GLenum = 0x8C85;
    #[doc = "`GL_TRANSFORM_FEEDBACK_BUFFER_START: GLenum = 0x8C84`"]
    #[doc = "* **Groups:** TransformFeedbackPName, GetPName"]
    pub const GL_TRANSFORM_FEEDBACK_BUFFER_START: GLenum = 0x8C84;
    #[doc = "`GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE: GLenum = 0x934C`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE: GLenum = 0x934C;
    #[doc = "`GL_TRANSFORM_FEEDBACK_OVERFLOW: GLenum = 0x82EC`"]
    #[doc = "* **Group:** QueryTarget"]
    pub const GL_TRANSFORM_FEEDBACK_OVERFLOW: GLenum = 0x82EC;
    #[doc = "`GL_TRANSFORM_FEEDBACK_PAUSED: GLenum = 0x8E23`"]
    #[doc = "* **Group:** TransformFeedbackPName"]
    #[doc = "* **Alias Of:** `GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED`"]
    pub const GL_TRANSFORM_FEEDBACK_PAUSED: GLenum = 0x8E23;
    #[doc = "`GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN: GLenum = 0x8C88`"]
    #[doc = "* **Group:** QueryTarget"]
    pub const GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN: GLenum = 0x8C88;
    #[doc = "`GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW: GLenum = 0x82ED`"]
    pub const GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW: GLenum = 0x82ED;
    #[doc = "`GL_TRANSFORM_FEEDBACK_VARYING: GLenum = 0x92F4`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_TRANSFORM_FEEDBACK_VARYING: GLenum = 0x92F4;
    #[doc = "`GL_TRANSFORM_FEEDBACK_VARYINGS: GLenum = 0x8C83`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_TRANSFORM_FEEDBACK_VARYINGS: GLenum = 0x8C83;
    #[doc = "`GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH: GLenum = 0x8C76`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH: GLenum = 0x8C76;
    #[doc = "`GL_TRIANGLES: GLenum = 0x0004`"]
    #[doc = "* **Group:** PrimitiveType"]
    pub const GL_TRIANGLES: GLenum = 0x0004;
    #[doc = "`GL_TRIANGLES_ADJACENCY: GLenum = 0x000C`"]
    #[doc = "* **Group:** PrimitiveType"]
    pub const GL_TRIANGLES_ADJACENCY: GLenum = 0x000C;
    #[doc = "`GL_TRIANGLE_FAN: GLenum = 0x0006`"]
    #[doc = "* **Group:** PrimitiveType"]
    pub const GL_TRIANGLE_FAN: GLenum = 0x0006;
    #[doc = "`GL_TRIANGLE_STRIP: GLenum = 0x0005`"]
    #[doc = "* **Group:** PrimitiveType"]
    pub const GL_TRIANGLE_STRIP: GLenum = 0x0005;
    #[doc = "`GL_TRIANGLE_STRIP_ADJACENCY: GLenum = 0x000D`"]
    #[doc = "* **Group:** PrimitiveType"]
    pub const GL_TRIANGLE_STRIP_ADJACENCY: GLenum = 0x000D;
    #[doc = "`GL_TRUE: GLenum = 1`"]
    #[doc = "* **Groups:** Boolean, VertexShaderWriteMaskEXT, ClampColorModeARB"]
    pub const GL_TRUE: GLenum = 1;
    #[doc = "`GL_TYPE: GLenum = 0x92FA`"]
    #[doc = "* **Group:** ProgramResourceProperty"]
    pub const GL_TYPE: GLenum = 0x92FA;
    #[doc = "`GL_UNDEFINED_VERTEX: GLenum = 0x8260`"]
    pub const GL_UNDEFINED_VERTEX: GLenum = 0x8260;
    #[doc = "`GL_UNIFORM: GLenum = 0x92E1`"]
    #[doc = "* **Groups:** ProgramResourceProperty, ProgramInterface"]
    pub const GL_UNIFORM: GLenum = 0x92E1;
    #[doc = "`GL_UNIFORM_ARRAY_STRIDE: GLenum = 0x8A3C`"]
    #[doc = "* **Group:** UniformPName"]
    pub const GL_UNIFORM_ARRAY_STRIDE: GLenum = 0x8A3C;
    #[doc = "`GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX: GLenum = 0x92DA`"]
    #[doc = "* **Group:** UniformPName"]
    pub const GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX: GLenum = 0x92DA;
    #[doc = "`GL_UNIFORM_BARRIER_BIT: GLbitfield = 0x00000004`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_UNIFORM_BARRIER_BIT: GLbitfield = 0x00000004;
    #[doc = "`GL_UNIFORM_BLOCK: GLenum = 0x92E2`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_UNIFORM_BLOCK: GLenum = 0x92E2;
    #[doc = "`GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS: GLenum = 0x8A42`"]
    #[doc = "* **Group:** UniformBlockPName"]
    pub const GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS: GLenum = 0x8A42;
    #[doc = "`GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES: GLenum = 0x8A43`"]
    #[doc = "* **Group:** UniformBlockPName"]
    pub const GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES: GLenum = 0x8A43;
    #[doc = "`GL_UNIFORM_BLOCK_BINDING: GLenum = 0x8A3F`"]
    #[doc = "* **Group:** UniformBlockPName"]
    pub const GL_UNIFORM_BLOCK_BINDING: GLenum = 0x8A3F;
    #[doc = "`GL_UNIFORM_BLOCK_DATA_SIZE: GLenum = 0x8A40`"]
    #[doc = "* **Group:** UniformBlockPName"]
    pub const GL_UNIFORM_BLOCK_DATA_SIZE: GLenum = 0x8A40;
    #[doc = "`GL_UNIFORM_BLOCK_INDEX: GLenum = 0x8A3A`"]
    #[doc = "* **Group:** UniformPName"]
    pub const GL_UNIFORM_BLOCK_INDEX: GLenum = 0x8A3A;
    #[doc = "`GL_UNIFORM_BLOCK_NAME_LENGTH: GLenum = 0x8A41`"]
    #[doc = "* **Group:** UniformBlockPName"]
    pub const GL_UNIFORM_BLOCK_NAME_LENGTH: GLenum = 0x8A41;
    #[doc = "`GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER: GLenum = 0x90EC`"]
    #[doc = "* **Group:** UniformBlockPName"]
    pub const GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER: GLenum = 0x90EC;
    #[doc = "`GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER: GLenum = 0x8A46`"]
    #[doc = "* **Group:** UniformBlockPName"]
    pub const GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER: GLenum = 0x8A46;
    #[doc = "`GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER: GLenum = 0x8A45`"]
    #[doc = "* **Group:** UniformBlockPName"]
    pub const GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER: GLenum = 0x8A45;
    #[doc = "`GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER: GLenum = 0x84F0`"]
    #[doc = "* **Group:** UniformBlockPName"]
    pub const GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER: GLenum = 0x84F0;
    #[doc = "`GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER: GLenum = 0x84F1`"]
    #[doc = "* **Group:** UniformBlockPName"]
    pub const GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER: GLenum = 0x84F1;
    #[doc = "`GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER: GLenum = 0x8A44`"]
    #[doc = "* **Group:** UniformBlockPName"]
    pub const GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER: GLenum = 0x8A44;
    #[doc = "`GL_UNIFORM_BUFFER: GLenum = 0x8A11`"]
    #[doc = "* **Groups:** CopyBufferSubDataTarget, BufferTargetARB, BufferStorageTarget"]
    pub const GL_UNIFORM_BUFFER: GLenum = 0x8A11;
    #[doc = "`GL_UNIFORM_BUFFER_BINDING: GLenum = 0x8A28`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_UNIFORM_BUFFER_BINDING: GLenum = 0x8A28;
    #[doc = "`GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT: GLenum = 0x8A34`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT: GLenum = 0x8A34;
    #[doc = "`GL_UNIFORM_BUFFER_SIZE: GLenum = 0x8A2A`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_UNIFORM_BUFFER_SIZE: GLenum = 0x8A2A;
    #[doc = "`GL_UNIFORM_BUFFER_START: GLenum = 0x8A29`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_UNIFORM_BUFFER_START: GLenum = 0x8A29;
    #[doc = "`GL_UNIFORM_IS_ROW_MAJOR: GLenum = 0x8A3E`"]
    #[doc = "* **Group:** UniformPName"]
    pub const GL_UNIFORM_IS_ROW_MAJOR: GLenum = 0x8A3E;
    #[doc = "`GL_UNIFORM_MATRIX_STRIDE: GLenum = 0x8A3D`"]
    #[doc = "* **Group:** UniformPName"]
    pub const GL_UNIFORM_MATRIX_STRIDE: GLenum = 0x8A3D;
    #[doc = "`GL_UNIFORM_NAME_LENGTH: GLenum = 0x8A39`"]
    #[doc = "* **Groups:** SubroutineParameterName, UniformPName"]
    pub const GL_UNIFORM_NAME_LENGTH: GLenum = 0x8A39;
    #[doc = "`GL_UNIFORM_OFFSET: GLenum = 0x8A3B`"]
    #[doc = "* **Group:** UniformPName"]
    pub const GL_UNIFORM_OFFSET: GLenum = 0x8A3B;
    #[doc = "`GL_UNIFORM_SIZE: GLenum = 0x8A38`"]
    #[doc = "* **Groups:** SubroutineParameterName, UniformPName"]
    pub const GL_UNIFORM_SIZE: GLenum = 0x8A38;
    #[doc = "`GL_UNIFORM_TYPE: GLenum = 0x8A37`"]
    #[doc = "* **Group:** UniformPName"]
    pub const GL_UNIFORM_TYPE: GLenum = 0x8A37;
    #[doc = "`GL_UNKNOWN_CONTEXT_RESET: GLenum = 0x8255`"]
    #[doc = "* **Group:** GraphicsResetStatus"]
    pub const GL_UNKNOWN_CONTEXT_RESET: GLenum = 0x8255;
    #[doc = "`GL_UNPACK_ALIGNMENT: GLenum = 0x0CF5`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_UNPACK_ALIGNMENT: GLenum = 0x0CF5;
    #[doc = "`GL_UNPACK_COMPRESSED_BLOCK_DEPTH: GLenum = 0x9129`"]
    pub const GL_UNPACK_COMPRESSED_BLOCK_DEPTH: GLenum = 0x9129;
    #[doc = "`GL_UNPACK_COMPRESSED_BLOCK_HEIGHT: GLenum = 0x9128`"]
    pub const GL_UNPACK_COMPRESSED_BLOCK_HEIGHT: GLenum = 0x9128;
    #[doc = "`GL_UNPACK_COMPRESSED_BLOCK_SIZE: GLenum = 0x912A`"]
    pub const GL_UNPACK_COMPRESSED_BLOCK_SIZE: GLenum = 0x912A;
    #[doc = "`GL_UNPACK_COMPRESSED_BLOCK_WIDTH: GLenum = 0x9127`"]
    pub const GL_UNPACK_COMPRESSED_BLOCK_WIDTH: GLenum = 0x9127;
    #[doc = "`GL_UNPACK_IMAGE_HEIGHT: GLenum = 0x806E`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_UNPACK_IMAGE_HEIGHT: GLenum = 0x806E;
    #[doc = "`GL_UNPACK_LSB_FIRST: GLenum = 0x0CF1`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_UNPACK_LSB_FIRST: GLenum = 0x0CF1;
    #[doc = "`GL_UNPACK_ROW_LENGTH: GLenum = 0x0CF2`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_UNPACK_ROW_LENGTH: GLenum = 0x0CF2;
    #[doc = "`GL_UNPACK_SKIP_IMAGES: GLenum = 0x806D`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_UNPACK_SKIP_IMAGES: GLenum = 0x806D;
    #[doc = "`GL_UNPACK_SKIP_PIXELS: GLenum = 0x0CF4`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_UNPACK_SKIP_PIXELS: GLenum = 0x0CF4;
    #[doc = "`GL_UNPACK_SKIP_ROWS: GLenum = 0x0CF3`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_UNPACK_SKIP_ROWS: GLenum = 0x0CF3;
    #[doc = "`GL_UNPACK_SWAP_BYTES: GLenum = 0x0CF0`"]
    #[doc = "* **Groups:** PixelStoreParameter, GetPName"]
    pub const GL_UNPACK_SWAP_BYTES: GLenum = 0x0CF0;
    #[doc = "`GL_UNSIGNALED: GLenum = 0x9118`"]
    pub const GL_UNSIGNALED: GLenum = 0x9118;
    #[doc = "`GL_UNSIGNED_BYTE: GLenum = 0x1401`"]
    #[doc = "* **Groups:** VertexAttribIType, ScalarType, ReplacementCodeTypeSUN, ElementPointerTypeATI, MatrixIndexPointerTypeARB, WeightPointerTypeARB, ColorPointerType, DrawElementsType, ListNameType, PixelType, VertexAttribType, VertexAttribPointerType"]
    pub const GL_UNSIGNED_BYTE: GLenum = 0x1401;
    #[doc = "`GL_UNSIGNED_BYTE_2_3_3_REV: GLenum = 0x8362`"]
    pub const GL_UNSIGNED_BYTE_2_3_3_REV: GLenum = 0x8362;
    #[doc = "`GL_UNSIGNED_BYTE_3_3_2: GLenum = 0x8032`"]
    #[doc = "* **Group:** PixelType"]
    pub const GL_UNSIGNED_BYTE_3_3_2: GLenum = 0x8032;
    #[doc = "`GL_UNSIGNED_INT: GLenum = 0x1405`"]
    #[doc = "* **Groups:** VertexAttribIType, ScalarType, ReplacementCodeTypeSUN, ElementPointerTypeATI, MatrixIndexPointerTypeARB, WeightPointerTypeARB, ColorPointerType, DrawElementsType, ListNameType, PixelFormat, PixelType, VertexAttribType, AttributeType, UniformType, VertexAttribPointerType, GlslTypeToken"]
    pub const GL_UNSIGNED_INT: GLenum = 0x1405;
    #[doc = "`GL_UNSIGNED_INT_10F_11F_11F_REV: GLenum = 0x8C3B`"]
    #[doc = "* **Groups:** VertexAttribPointerType, VertexAttribType"]
    pub const GL_UNSIGNED_INT_10F_11F_11F_REV: GLenum = 0x8C3B;
    #[doc = "`GL_UNSIGNED_INT_10_10_10_2: GLenum = 0x8036`"]
    #[doc = "* **Group:** PixelType"]
    pub const GL_UNSIGNED_INT_10_10_10_2: GLenum = 0x8036;
    #[doc = "`GL_UNSIGNED_INT_24_8: GLenum = 0x84FA`"]
    pub const GL_UNSIGNED_INT_24_8: GLenum = 0x84FA;
    #[doc = "`GL_UNSIGNED_INT_2_10_10_10_REV: GLenum = 0x8368`"]
    #[doc = "* **Groups:** VertexAttribPointerType, VertexAttribType"]
    pub const GL_UNSIGNED_INT_2_10_10_10_REV: GLenum = 0x8368;
    #[doc = "`GL_UNSIGNED_INT_5_9_9_9_REV: GLenum = 0x8C3E`"]
    pub const GL_UNSIGNED_INT_5_9_9_9_REV: GLenum = 0x8C3E;
    #[doc = "`GL_UNSIGNED_INT_8_8_8_8: GLenum = 0x8035`"]
    #[doc = "* **Group:** PixelType"]
    pub const GL_UNSIGNED_INT_8_8_8_8: GLenum = 0x8035;
    #[doc = "`GL_UNSIGNED_INT_8_8_8_8_REV: GLenum = 0x8367`"]
    pub const GL_UNSIGNED_INT_8_8_8_8_REV: GLenum = 0x8367;
    #[doc = "`GL_UNSIGNED_INT_ATOMIC_COUNTER: GLenum = 0x92DB`"]
    #[doc = "* **Group:** GlslTypeToken"]
    pub const GL_UNSIGNED_INT_ATOMIC_COUNTER: GLenum = 0x92DB;
    #[doc = "`GL_UNSIGNED_INT_IMAGE_1D: GLenum = 0x9062`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_UNSIGNED_INT_IMAGE_1D: GLenum = 0x9062;
    #[doc = "`GL_UNSIGNED_INT_IMAGE_1D_ARRAY: GLenum = 0x9068`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_UNSIGNED_INT_IMAGE_1D_ARRAY: GLenum = 0x9068;
    #[doc = "`GL_UNSIGNED_INT_IMAGE_2D: GLenum = 0x9063`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_UNSIGNED_INT_IMAGE_2D: GLenum = 0x9063;
    #[doc = "`GL_UNSIGNED_INT_IMAGE_2D_ARRAY: GLenum = 0x9069`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_UNSIGNED_INT_IMAGE_2D_ARRAY: GLenum = 0x9069;
    #[doc = "`GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE: GLenum = 0x906B`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE: GLenum = 0x906B;
    #[doc = "`GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY: GLenum = 0x906C`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY: GLenum = 0x906C;
    #[doc = "`GL_UNSIGNED_INT_IMAGE_2D_RECT: GLenum = 0x9065`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_UNSIGNED_INT_IMAGE_2D_RECT: GLenum = 0x9065;
    #[doc = "`GL_UNSIGNED_INT_IMAGE_3D: GLenum = 0x9064`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_UNSIGNED_INT_IMAGE_3D: GLenum = 0x9064;
    #[doc = "`GL_UNSIGNED_INT_IMAGE_BUFFER: GLenum = 0x9067`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_UNSIGNED_INT_IMAGE_BUFFER: GLenum = 0x9067;
    #[doc = "`GL_UNSIGNED_INT_IMAGE_CUBE: GLenum = 0x9066`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_UNSIGNED_INT_IMAGE_CUBE: GLenum = 0x9066;
    #[doc = "`GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY: GLenum = 0x906A`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType"]
    pub const GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY: GLenum = 0x906A;
    #[doc = "`GL_UNSIGNED_INT_SAMPLER_1D: GLenum = 0x8DD1`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_UNSIGNED_INT_SAMPLER_1D: GLenum = 0x8DD1;
    #[doc = "`GL_UNSIGNED_INT_SAMPLER_1D_ARRAY: GLenum = 0x8DD6`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_UNSIGNED_INT_SAMPLER_1D_ARRAY: GLenum = 0x8DD6;
    #[doc = "`GL_UNSIGNED_INT_SAMPLER_2D: GLenum = 0x8DD2`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_UNSIGNED_INT_SAMPLER_2D: GLenum = 0x8DD2;
    #[doc = "`GL_UNSIGNED_INT_SAMPLER_2D_ARRAY: GLenum = 0x8DD7`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_UNSIGNED_INT_SAMPLER_2D_ARRAY: GLenum = 0x8DD7;
    #[doc = "`GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE: GLenum = 0x910A`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE: GLenum = 0x910A;
    #[doc = "`GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY: GLenum = 0x910D`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY: GLenum = 0x910D;
    #[doc = "`GL_UNSIGNED_INT_SAMPLER_2D_RECT: GLenum = 0x8DD5`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_UNSIGNED_INT_SAMPLER_2D_RECT: GLenum = 0x8DD5;
    #[doc = "`GL_UNSIGNED_INT_SAMPLER_3D: GLenum = 0x8DD3`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_UNSIGNED_INT_SAMPLER_3D: GLenum = 0x8DD3;
    #[doc = "`GL_UNSIGNED_INT_SAMPLER_BUFFER: GLenum = 0x8DD8`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_UNSIGNED_INT_SAMPLER_BUFFER: GLenum = 0x8DD8;
    #[doc = "`GL_UNSIGNED_INT_SAMPLER_CUBE: GLenum = 0x8DD4`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_UNSIGNED_INT_SAMPLER_CUBE: GLenum = 0x8DD4;
    #[doc = "`GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY: GLenum = 0x900F`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY: GLenum = 0x900F;
    #[doc = "`GL_UNSIGNED_INT_VEC2: GLenum = 0x8DC6`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_UNSIGNED_INT_VEC2: GLenum = 0x8DC6;
    #[doc = "`GL_UNSIGNED_INT_VEC3: GLenum = 0x8DC7`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_UNSIGNED_INT_VEC3: GLenum = 0x8DC7;
    #[doc = "`GL_UNSIGNED_INT_VEC4: GLenum = 0x8DC8`"]
    #[doc = "* **Groups:** GlslTypeToken, AttributeType, UniformType"]
    pub const GL_UNSIGNED_INT_VEC4: GLenum = 0x8DC8;
    #[doc = "`GL_UNSIGNED_NORMALIZED: GLenum = 0x8C17`"]
    pub const GL_UNSIGNED_NORMALIZED: GLenum = 0x8C17;
    #[doc = "`GL_UNSIGNED_SHORT: GLenum = 0x1403`"]
    #[doc = "* **Groups:** VertexAttribIType, ScalarType, ReplacementCodeTypeSUN, ElementPointerTypeATI, MatrixIndexPointerTypeARB, WeightPointerTypeARB, ColorPointerType, DrawElementsType, ListNameType, PixelFormat, PixelType, VertexAttribType, VertexAttribPointerType"]
    pub const GL_UNSIGNED_SHORT: GLenum = 0x1403;
    #[doc = "`GL_UNSIGNED_SHORT_1_5_5_5_REV: GLenum = 0x8366`"]
    pub const GL_UNSIGNED_SHORT_1_5_5_5_REV: GLenum = 0x8366;
    #[doc = "`GL_UNSIGNED_SHORT_4_4_4_4: GLenum = 0x8033`"]
    #[doc = "* **Group:** PixelType"]
    pub const GL_UNSIGNED_SHORT_4_4_4_4: GLenum = 0x8033;
    #[doc = "`GL_UNSIGNED_SHORT_4_4_4_4_REV: GLenum = 0x8365`"]
    pub const GL_UNSIGNED_SHORT_4_4_4_4_REV: GLenum = 0x8365;
    #[doc = "`GL_UNSIGNED_SHORT_5_5_5_1: GLenum = 0x8034`"]
    #[doc = "* **Group:** PixelType"]
    pub const GL_UNSIGNED_SHORT_5_5_5_1: GLenum = 0x8034;
    #[doc = "`GL_UNSIGNED_SHORT_5_6_5: GLenum = 0x8363`"]
    pub const GL_UNSIGNED_SHORT_5_6_5: GLenum = 0x8363;
    #[doc = "`GL_UNSIGNED_SHORT_5_6_5_REV: GLenum = 0x8364`"]
    pub const GL_UNSIGNED_SHORT_5_6_5_REV: GLenum = 0x8364;
    #[doc = "`GL_UPPER_LEFT: GLenum = 0x8CA2`"]
    #[doc = "* **Group:** ClipControlOrigin"]
    pub const GL_UPPER_LEFT: GLenum = 0x8CA2;
    #[doc = "`GL_VALIDATE_STATUS: GLenum = 0x8B83`"]
    #[doc = "* **Group:** ProgramPropertyARB"]
    pub const GL_VALIDATE_STATUS: GLenum = 0x8B83;
    #[doc = "`GL_VENDOR: GLenum = 0x1F00`"]
    #[doc = "* **Group:** StringName"]
    pub const GL_VENDOR: GLenum = 0x1F00;
    #[doc = "`GL_VERSION: GLenum = 0x1F02`"]
    #[doc = "* **Group:** StringName"]
    pub const GL_VERSION: GLenum = 0x1F02;
    #[doc = "`GL_VERTEX_ARRAY: GLenum = 0x8074`"]
    #[doc = "* **Groups:** ObjectIdentifier, EnableCap, GetPName"]
    pub const GL_VERTEX_ARRAY: GLenum = 0x8074;
    #[doc = "`GL_VERTEX_ARRAY_BINDING: GLenum = 0x85B5`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_VERTEX_ARRAY_BINDING: GLenum = 0x85B5;
    #[doc = "`GL_VERTEX_ARRAY_KHR: GLenum = 0x8074`"]

    pub const GL_VERTEX_ARRAY_KHR: GLenum = 0x8074;
    #[doc = "`GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT: GLbitfield = 0x00000001`"]
    #[doc = "* **Group:** MemoryBarrierMask"]
    pub const GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT: GLbitfield = 0x00000001;
    #[doc = "`GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: GLenum = 0x889F`"]
    #[doc = "* **Groups:** VertexAttribEnum, VertexAttribPropertyARB"]
    pub const GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: GLenum = 0x889F;
    #[doc = "`GL_VERTEX_ATTRIB_ARRAY_DIVISOR: GLenum = 0x88FE`"]
    #[doc = "* **Groups:** VertexAttribEnum, VertexAttribPropertyARB, VertexArrayPName"]
    pub const GL_VERTEX_ATTRIB_ARRAY_DIVISOR: GLenum = 0x88FE;
    #[doc = "`GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB: GLenum = 0x88FE`"]

    pub const GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB: GLenum = 0x88FE;
    #[doc = "`GL_VERTEX_ATTRIB_ARRAY_ENABLED: GLenum = 0x8622`"]
    #[doc = "* **Groups:** VertexAttribEnum, VertexAttribPropertyARB, VertexArrayPName"]
    pub const GL_VERTEX_ATTRIB_ARRAY_ENABLED: GLenum = 0x8622;
    #[doc = "`GL_VERTEX_ATTRIB_ARRAY_INTEGER: GLenum = 0x88FD`"]
    #[doc = "* **Groups:** VertexAttribEnum, VertexAttribPropertyARB, VertexArrayPName"]
    pub const GL_VERTEX_ATTRIB_ARRAY_INTEGER: GLenum = 0x88FD;
    #[doc = "`GL_VERTEX_ATTRIB_ARRAY_LONG: GLenum = 0x874E`"]
    #[doc = "* **Groups:** VertexArrayPName, VertexAttribPropertyARB"]
    pub const GL_VERTEX_ATTRIB_ARRAY_LONG: GLenum = 0x874E;
    #[doc = "`GL_VERTEX_ATTRIB_ARRAY_NORMALIZED: GLenum = 0x886A`"]
    #[doc = "* **Groups:** VertexAttribEnum, VertexAttribPropertyARB, VertexArrayPName"]
    pub const GL_VERTEX_ATTRIB_ARRAY_NORMALIZED: GLenum = 0x886A;
    #[doc = "`GL_VERTEX_ATTRIB_ARRAY_POINTER: GLenum = 0x8645`"]
    #[doc = "* **Group:** VertexAttribPointerPropertyARB"]
    pub const GL_VERTEX_ATTRIB_ARRAY_POINTER: GLenum = 0x8645;
    #[doc = "`GL_VERTEX_ATTRIB_ARRAY_SIZE: GLenum = 0x8623`"]
    #[doc = "* **Groups:** VertexAttribEnum, VertexAttribPropertyARB, VertexArrayPName"]
    pub const GL_VERTEX_ATTRIB_ARRAY_SIZE: GLenum = 0x8623;
    #[doc = "`GL_VERTEX_ATTRIB_ARRAY_STRIDE: GLenum = 0x8624`"]
    #[doc = "* **Groups:** VertexAttribEnum, VertexAttribPropertyARB, VertexArrayPName"]
    pub const GL_VERTEX_ATTRIB_ARRAY_STRIDE: GLenum = 0x8624;
    #[doc = "`GL_VERTEX_ATTRIB_ARRAY_TYPE: GLenum = 0x8625`"]
    #[doc = "* **Groups:** VertexAttribEnum, VertexAttribPropertyARB, VertexArrayPName"]
    pub const GL_VERTEX_ATTRIB_ARRAY_TYPE: GLenum = 0x8625;
    #[doc = "`GL_VERTEX_ATTRIB_BINDING: GLenum = 0x82D4`"]
    #[doc = "* **Group:** VertexAttribPropertyARB"]
    pub const GL_VERTEX_ATTRIB_BINDING: GLenum = 0x82D4;
    #[doc = "`GL_VERTEX_ATTRIB_RELATIVE_OFFSET: GLenum = 0x82D5`"]
    #[doc = "* **Groups:** VertexArrayPName, VertexAttribPropertyARB"]
    pub const GL_VERTEX_ATTRIB_RELATIVE_OFFSET: GLenum = 0x82D5;
    #[doc = "`GL_VERTEX_BINDING_BUFFER: GLenum = 0x8F4F`"]
    pub const GL_VERTEX_BINDING_BUFFER: GLenum = 0x8F4F;
    #[doc = "`GL_VERTEX_BINDING_DIVISOR: GLenum = 0x82D6`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_VERTEX_BINDING_DIVISOR: GLenum = 0x82D6;
    #[doc = "`GL_VERTEX_BINDING_OFFSET: GLenum = 0x82D7`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_VERTEX_BINDING_OFFSET: GLenum = 0x82D7;
    #[doc = "`GL_VERTEX_BINDING_STRIDE: GLenum = 0x82D8`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_VERTEX_BINDING_STRIDE: GLenum = 0x82D8;
    #[doc = "`GL_VERTEX_PROGRAM_POINT_SIZE: GLenum = 0x8642`"]
    pub const GL_VERTEX_PROGRAM_POINT_SIZE: GLenum = 0x8642;
    #[doc = "`GL_VERTEX_SHADER: GLenum = 0x8B31`"]
    #[doc = "* **Groups:** PipelineParameterName, ShaderType"]
    pub const GL_VERTEX_SHADER: GLenum = 0x8B31;
    #[doc = "`GL_VERTEX_SHADER_BIT: GLbitfield = 0x00000001`"]
    #[doc = "* **Group:** UseProgramStageMask"]
    pub const GL_VERTEX_SHADER_BIT: GLbitfield = 0x00000001;
    #[doc = "`GL_VERTEX_SHADER_INVOCATIONS: GLenum = 0x82F0`"]
    #[doc = "* **Group:** QueryTarget"]
    pub const GL_VERTEX_SHADER_INVOCATIONS: GLenum = 0x82F0;
    #[doc = "`GL_VERTEX_SUBROUTINE: GLenum = 0x92E8`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_VERTEX_SUBROUTINE: GLenum = 0x92E8;
    #[doc = "`GL_VERTEX_SUBROUTINE_UNIFORM: GLenum = 0x92EE`"]
    #[doc = "* **Group:** ProgramInterface"]
    pub const GL_VERTEX_SUBROUTINE_UNIFORM: GLenum = 0x92EE;
    #[doc = "`GL_VERTEX_TEXTURE: GLenum = 0x829B`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_VERTEX_TEXTURE: GLenum = 0x829B;
    #[doc = "`GL_VERTICES_SUBMITTED: GLenum = 0x82EE`"]
    #[doc = "* **Group:** QueryTarget"]
    pub const GL_VERTICES_SUBMITTED: GLenum = 0x82EE;
    #[doc = "`GL_VIEWPORT: GLenum = 0x0BA2`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_VIEWPORT: GLenum = 0x0BA2;
    #[doc = "`GL_VIEWPORT_BOUNDS_RANGE: GLenum = 0x825D`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_VIEWPORT_BOUNDS_RANGE: GLenum = 0x825D;
    #[doc = "`GL_VIEWPORT_INDEX_PROVOKING_VERTEX: GLenum = 0x825F`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_VIEWPORT_INDEX_PROVOKING_VERTEX: GLenum = 0x825F;
    #[doc = "`GL_VIEWPORT_SUBPIXEL_BITS: GLenum = 0x825C`"]
    #[doc = "* **Group:** GetPName"]
    pub const GL_VIEWPORT_SUBPIXEL_BITS: GLenum = 0x825C;
    #[doc = "`GL_VIEW_CLASS_128_BITS: GLenum = 0x82C4`"]
    pub const GL_VIEW_CLASS_128_BITS: GLenum = 0x82C4;
    #[doc = "`GL_VIEW_CLASS_16_BITS: GLenum = 0x82CA`"]
    pub const GL_VIEW_CLASS_16_BITS: GLenum = 0x82CA;
    #[doc = "`GL_VIEW_CLASS_24_BITS: GLenum = 0x82C9`"]
    pub const GL_VIEW_CLASS_24_BITS: GLenum = 0x82C9;
    #[doc = "`GL_VIEW_CLASS_32_BITS: GLenum = 0x82C8`"]
    pub const GL_VIEW_CLASS_32_BITS: GLenum = 0x82C8;
    #[doc = "`GL_VIEW_CLASS_48_BITS: GLenum = 0x82C7`"]
    pub const GL_VIEW_CLASS_48_BITS: GLenum = 0x82C7;
    #[doc = "`GL_VIEW_CLASS_64_BITS: GLenum = 0x82C6`"]
    pub const GL_VIEW_CLASS_64_BITS: GLenum = 0x82C6;
    #[doc = "`GL_VIEW_CLASS_8_BITS: GLenum = 0x82CB`"]
    pub const GL_VIEW_CLASS_8_BITS: GLenum = 0x82CB;
    #[doc = "`GL_VIEW_CLASS_96_BITS: GLenum = 0x82C5`"]
    pub const GL_VIEW_CLASS_96_BITS: GLenum = 0x82C5;
    #[doc = "`GL_VIEW_CLASS_BPTC_FLOAT: GLenum = 0x82D3`"]
    pub const GL_VIEW_CLASS_BPTC_FLOAT: GLenum = 0x82D3;
    #[doc = "`GL_VIEW_CLASS_BPTC_UNORM: GLenum = 0x82D2`"]
    pub const GL_VIEW_CLASS_BPTC_UNORM: GLenum = 0x82D2;
    #[doc = "`GL_VIEW_CLASS_RGTC1_RED: GLenum = 0x82D0`"]
    pub const GL_VIEW_CLASS_RGTC1_RED: GLenum = 0x82D0;
    #[doc = "`GL_VIEW_CLASS_RGTC2_RG: GLenum = 0x82D1`"]
    pub const GL_VIEW_CLASS_RGTC2_RG: GLenum = 0x82D1;
    #[doc = "`GL_VIEW_CLASS_S3TC_DXT1_RGB: GLenum = 0x82CC`"]
    pub const GL_VIEW_CLASS_S3TC_DXT1_RGB: GLenum = 0x82CC;
    #[doc = "`GL_VIEW_CLASS_S3TC_DXT1_RGBA: GLenum = 0x82CD`"]
    pub const GL_VIEW_CLASS_S3TC_DXT1_RGBA: GLenum = 0x82CD;
    #[doc = "`GL_VIEW_CLASS_S3TC_DXT3_RGBA: GLenum = 0x82CE`"]
    pub const GL_VIEW_CLASS_S3TC_DXT3_RGBA: GLenum = 0x82CE;
    #[doc = "`GL_VIEW_CLASS_S3TC_DXT5_RGBA: GLenum = 0x82CF`"]
    pub const GL_VIEW_CLASS_S3TC_DXT5_RGBA: GLenum = 0x82CF;
    #[doc = "`GL_VIEW_COMPATIBILITY_CLASS: GLenum = 0x82B6`"]
    #[doc = "* **Group:** InternalFormatPName"]
    pub const GL_VIEW_COMPATIBILITY_CLASS: GLenum = 0x82B6;
    #[doc = "`GL_WAIT_FAILED: GLenum = 0x911D`"]
    #[doc = "* **Group:** SyncStatus"]
    pub const GL_WAIT_FAILED: GLenum = 0x911D;
    #[doc = "`GL_WRITE_ONLY: GLenum = 0x88B9`"]
    #[doc = "* **Group:** BufferAccessARB"]
    pub const GL_WRITE_ONLY: GLenum = 0x88B9;
    #[doc = "`GL_XOR: GLenum = 0x1506`"]
    #[doc = "* **Group:** LogicOp"]
    pub const GL_XOR: GLenum = 0x1506;
    #[doc = "`GL_ZERO: GLenum = 0`"]
    #[doc = "* **Groups:** TextureSwizzle, StencilOp, BlendingFactor"]
    pub const GL_ZERO: GLenum = 0;
    #[doc = "`GL_ZERO_TO_ONE: GLenum = 0x935F`"]
    #[doc = "* **Group:** ClipControlDepth"]
    pub const GL_ZERO_TO_ONE: GLenum = 0x935F;
}

/// This is called to panic when a not-loaded function is attempted.
///
/// Placing the panic mechanism in this cold function generally helps code generation for the hot path.
/// Or so the sages say, at least.
#[cold]
#[inline(never)]
#[allow(dead_code)]
fn go_panic_because_fn_not_loaded(name: &str) -> ! {
    panic!("called {name} but it was not loaded.", name = name)
}

/// Loads a function pointer.
/// Rejects suggested pointer addresses which are likely to be lies.
/// This function is used by both the global loader and struct loader.
/// We mark it as `inline(never)` to favor a small binary over initialization speed.
/// Returns if there's now a non-null value in the atomic pointer.
#[inline(never)]
#[allow(dead_code)]
fn load_dyn_name_atomic_ptr(
    get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
    fn_name: &[u8],
    ptr: &APcv,
) -> bool {
    // if this fails the code generator itself royally screwed up somehow,
    // and so it's only a debug assert.
    debug_assert_eq!(*fn_name.last().unwrap(), 0);
    let p: *mut c_void = get_proc_address(fn_name.as_ptr() as *const c_char);
    let p_usize = p as usize;
    // You *should* get null for failed lookups, but some systems have been
    // reported to give "error code" values such as -1 or small non-null values.
    // To help guard against this silliness, we consider these values to also
    // just be a result of null.
    if p_usize == core::usize::MAX || p_usize < 8 {
        ptr.store(null_mut(), RELAX);
        false
    } else {
        ptr.store(p, RELAX);
        true
    }
}

/// Returns if an error was printed.
#[cfg(feature = "debug_automatic_glGetError")]
#[inline(never)]
fn report_error_code_from(name: &str, err: GLenum) {
    match err {
        GL_NO_ERROR => return,
        GL_INVALID_ENUM => error!("Invalid Enum to {name}.", name = name),
        GL_INVALID_VALUE => error!("Invalid Value to {name}.", name = name),
        GL_INVALID_OPERATION => error!("Invalid Operation to {name}.", name = name),
        GL_INVALID_FRAMEBUFFER_OPERATION => {
            error!("Invalid Framebuffer Operation to {name}.", name = name)
        }
        GL_OUT_OF_MEMORY => error!("Out of Memory in {name}.", name = name),
        GL_STACK_UNDERFLOW => error!("Stack Underflow in {name}.", name = name),
        GL_STACK_OVERFLOW => error!("Stack Overflow in {name}.", name = name),
        unknown => error!(
            "Unknown error code {unknown} to {name}.",
            name = name,
            unknown = unknown
        ),
    }
}

#[inline(always)]
#[allow(dead_code)]
unsafe fn call_atomic_ptr_0arg<Ret>(name: &str, ptr: &APcv) -> Ret {
    let p = ptr.load(RELAX);
    match transmute::<*mut c_void, Option<extern "system" fn() -> Ret>>(p) {
        Some(fn_p) => fn_p(),
        None => go_panic_because_fn_not_loaded(name),
    }
}

#[inline(always)]
#[allow(dead_code)]
unsafe fn call_atomic_ptr_1arg<Ret, A>(name: &str, ptr: &APcv, a: A) -> Ret {
    let p = ptr.load(RELAX);
    match transmute::<*mut c_void, Option<extern "system" fn(A) -> Ret>>(p) {
        Some(fn_p) => fn_p(a),
        None => go_panic_because_fn_not_loaded(name),
    }
}

#[inline(always)]
#[allow(dead_code)]
unsafe fn call_atomic_ptr_2arg<Ret, A, B>(name: &str, ptr: &APcv, a: A, b: B) -> Ret {
    let p = ptr.load(RELAX);
    match transmute::<*mut c_void, Option<extern "system" fn(A, B) -> Ret>>(p) {
        Some(fn_p) => fn_p(a, b),
        None => go_panic_because_fn_not_loaded(name),
    }
}

#[inline(always)]
#[allow(dead_code)]
unsafe fn call_atomic_ptr_3arg<Ret, A, B, C>(name: &str, ptr: &APcv, a: A, b: B, c: C) -> Ret {
    let p = ptr.load(RELAX);
    match transmute::<*mut c_void, Option<extern "system" fn(A, B, C) -> Ret>>(p) {
        Some(fn_p) => fn_p(a, b, c),
        None => go_panic_because_fn_not_loaded(name),
    }
}

#[inline(always)]
#[allow(dead_code)]
unsafe fn call_atomic_ptr_4arg<Ret, A, B, C, D>(
    name: &str,
    ptr: &APcv,
    a: A,
    b: B,
    c: C,
    d: D,
) -> Ret {
    let p = ptr.load(RELAX);
    match transmute::<*mut c_void, Option<extern "system" fn(A, B, C, D) -> Ret>>(p) {
        Some(fn_p) => fn_p(a, b, c, d),
        None => go_panic_because_fn_not_loaded(name),
    }
}

#[inline(always)]
#[allow(dead_code)]
unsafe fn call_atomic_ptr_5arg<Ret, A, B, C, D, E>(
    name: &str,
    ptr: &APcv,
    a: A,
    b: B,
    c: C,
    d: D,
    e: E,
) -> Ret {
    let p = ptr.load(RELAX);
    match transmute::<*mut c_void, Option<extern "system" fn(A, B, C, D, E) -> Ret>>(p) {
        Some(fn_p) => fn_p(a, b, c, d, e),
        None => go_panic_because_fn_not_loaded(name),
    }
}

#[inline(always)]
#[allow(dead_code)]
unsafe fn call_atomic_ptr_6arg<Ret, A, B, C, D, E, F>(
    name: &str,
    ptr: &APcv,
    a: A,
    b: B,
    c: C,
    d: D,
    e: E,
    f: F,
) -> Ret {
    let p = ptr.load(RELAX);
    match transmute::<*mut c_void, Option<extern "system" fn(A, B, C, D, E, F) -> Ret>>(p) {
        Some(fn_p) => fn_p(a, b, c, d, e, f),
        None => go_panic_because_fn_not_loaded(name),
    }
}

#[inline(always)]
#[allow(dead_code)]
unsafe fn call_atomic_ptr_7arg<Ret, A, B, C, D, E, F, G>(
    name: &str,
    ptr: &APcv,
    a: A,
    b: B,
    c: C,
    d: D,
    e: E,
    f: F,
    g: G,
) -> Ret {
    let p = ptr.load(RELAX);
    match transmute::<*mut c_void, Option<extern "system" fn(A, B, C, D, E, F, G) -> Ret>>(p) {
        Some(fn_p) => fn_p(a, b, c, d, e, f, g),
        None => go_panic_because_fn_not_loaded(name),
    }
}

#[inline(always)]
#[allow(dead_code)]
unsafe fn call_atomic_ptr_8arg<Ret, A, B, C, D, E, F, G, H>(
    name: &str,
    ptr: &APcv,
    a: A,
    b: B,
    c: C,
    d: D,
    e: E,
    f: F,
    g: G,
    h: H,
) -> Ret {
    let p = ptr.load(RELAX);
    match transmute::<*mut c_void, Option<extern "system" fn(A, B, C, D, E, F, G, H) -> Ret>>(p) {
        Some(fn_p) => fn_p(a, b, c, d, e, f, g, h),
        None => go_panic_because_fn_not_loaded(name),
    }
}

#[inline(always)]
#[allow(dead_code)]
unsafe fn call_atomic_ptr_9arg<Ret, A, B, C, D, E, F, G, H, I>(
    name: &str,
    ptr: &APcv,
    a: A,
    b: B,
    c: C,
    d: D,
    e: E,
    f: F,
    g: G,
    h: H,
    i: I,
) -> Ret {
    let p = ptr.load(RELAX);
    match transmute::<*mut c_void, Option<extern "system" fn(A, B, C, D, E, F, G, H, I) -> Ret>>(p)
    {
        Some(fn_p) => fn_p(a, b, c, d, e, f, g, h, i),
        None => go_panic_because_fn_not_loaded(name),
    }
}

#[inline(always)]
#[allow(dead_code)]
unsafe fn call_atomic_ptr_10arg<Ret, A, B, C, D, E, F, G, H, I, J>(
    name: &str,
    ptr: &APcv,
    a: A,
    b: B,
    c: C,
    d: D,
    e: E,
    f: F,
    g: G,
    h: H,
    i: I,
    j: J,
) -> Ret {
    let p = ptr.load(RELAX);
    match transmute::<*mut c_void, Option<extern "system" fn(A, B, C, D, E, F, G, H, I, J) -> Ret>>(
        p,
    ) {
        Some(fn_p) => fn_p(a, b, c, d, e, f, g, h, i, j),
        None => go_panic_because_fn_not_loaded(name),
    }
}

#[inline(always)]
#[allow(dead_code)]
unsafe fn call_atomic_ptr_11arg<Ret, A, B, C, D, E, F, G, H, I, J, K>(
    name: &str,
    ptr: &APcv,
    a: A,
    b: B,
    c: C,
    d: D,
    e: E,
    f: F,
    g: G,
    h: H,
    i: I,
    j: J,
    k: K,
) -> Ret {
    let p = ptr.load(RELAX);
    match transmute::<*mut c_void, Option<extern "system" fn(A, B, C, D, E, F, G, H, I, J, K) -> Ret>>(
        p,
    ) {
        Some(fn_p) => fn_p(a, b, c, d, e, f, g, h, i, j, k),
        None => go_panic_because_fn_not_loaded(name),
    }
}

#[inline(always)]
#[allow(dead_code)]
unsafe fn call_atomic_ptr_12arg<Ret, A, B, C, D, E, F, G, H, I, J, K, L>(
    name: &str,
    ptr: &APcv,
    a: A,
    b: B,
    c: C,
    d: D,
    e: E,
    f: F,
    g: G,
    h: H,
    i: I,
    j: J,
    k: K,
    l: L,
) -> Ret {
    let p = ptr.load(RELAX);
    match transmute::<
        *mut c_void,
        Option<extern "system" fn(A, B, C, D, E, F, G, H, I, J, K, L) -> Ret>,
    >(p)
    {
        Some(fn_p) => fn_p(a, b, c, d, e, f, g, h, i, j, k, l),
        None => go_panic_because_fn_not_loaded(name),
    }
}

#[inline(always)]
#[allow(dead_code)]
unsafe fn call_atomic_ptr_15arg<Ret, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O>(
    name: &str,
    ptr: &APcv,
    a: A,
    b: B,
    c: C,
    d: D,
    e: E,
    f: F,
    g: G,
    h: H,
    i: I,
    j: J,
    k: K,
    l: L,
    m: M,
    n: N,
    o: O,
) -> Ret {
    let p = ptr.load(RELAX);
    match transmute::<
        *mut c_void,
        Option<extern "system" fn(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O) -> Ret>,
    >(p)
    {
        Some(fn_p) => fn_p(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o),
        None => go_panic_because_fn_not_loaded(name),
    }
}

pub use struct_commands::*;
pub mod struct_commands {
    //! Contains the [`GlFns`] type for using the struct GL loader.
    use super::*;
    impl GlFns {
        /// Constructs a new struct with all pointers loaded by the `get_proc_address` given.
        pub unsafe fn load_with<F>(mut get_proc_address: F) -> Self
        where
            F: FnMut(*const c_char) -> *mut c_void,
        {
            // Safety: The `GlFns` struct is nothing but `AtomicPtr` fields,
            // which can be safely constructed with `zeroed`.
            let out: Self = core::mem::zeroed();
            out.load_all_with_dyn(&mut get_proc_address);
            out
        }

        #[cfg(feature = "debug_automatic_glGetError")]
        #[inline(never)]
        unsafe fn automatic_glGetError(&self, name: &str) {
            let mut err = self.GetError();
            while err != GL_NO_ERROR {
                report_error_code_from(name, err);
                err = self.GetError();
            }
        }

        /// Loads all pointers using the `get_proc_address` given.
        #[doc(hidden)]
        #[inline(never)]
        pub unsafe fn load_all_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) {
            self.ActiveShaderProgram_load_with_dyn(get_proc_address);
            self.ActiveTexture_load_with_dyn(get_proc_address);
            self.AttachShader_load_with_dyn(get_proc_address);
            self.BeginConditionalRender_load_with_dyn(get_proc_address);
            self.BeginQuery_load_with_dyn(get_proc_address);
            self.BeginQueryIndexed_load_with_dyn(get_proc_address);
            self.BeginTransformFeedback_load_with_dyn(get_proc_address);
            self.BindAttribLocation_load_with_dyn(get_proc_address);
            self.BindBuffer_load_with_dyn(get_proc_address);
            self.BindBufferBase_load_with_dyn(get_proc_address);
            self.BindBufferRange_load_with_dyn(get_proc_address);
            self.BindBuffersBase_load_with_dyn(get_proc_address);
            self.BindBuffersRange_load_with_dyn(get_proc_address);
            self.BindFragDataLocation_load_with_dyn(get_proc_address);
            self.BindFragDataLocationIndexed_load_with_dyn(get_proc_address);
            self.BindFramebuffer_load_with_dyn(get_proc_address);
            self.BindImageTexture_load_with_dyn(get_proc_address);
            self.BindImageTextures_load_with_dyn(get_proc_address);
            self.BindProgramPipeline_load_with_dyn(get_proc_address);
            self.BindRenderbuffer_load_with_dyn(get_proc_address);
            self.BindSampler_load_with_dyn(get_proc_address);
            self.BindSamplers_load_with_dyn(get_proc_address);
            self.BindTexture_load_with_dyn(get_proc_address);
            self.BindTextureUnit_load_with_dyn(get_proc_address);
            self.BindTextures_load_with_dyn(get_proc_address);
            self.BindTransformFeedback_load_with_dyn(get_proc_address);
            self.BindVertexArray_load_with_dyn(get_proc_address);
            self.BindVertexBuffer_load_with_dyn(get_proc_address);
            self.BindVertexBuffers_load_with_dyn(get_proc_address);
            self.BlendBarrier_load_with_dyn(get_proc_address);
            self.BlendColor_load_with_dyn(get_proc_address);
            self.BlendEquation_load_with_dyn(get_proc_address);
            self.BlendEquationSeparate_load_with_dyn(get_proc_address);
            self.BlendEquationSeparatei_load_with_dyn(get_proc_address);
            self.BlendEquationi_load_with_dyn(get_proc_address);
            self.BlendFunc_load_with_dyn(get_proc_address);
            self.BlendFuncSeparate_load_with_dyn(get_proc_address);
            self.BlendFuncSeparatei_load_with_dyn(get_proc_address);
            self.BlendFunci_load_with_dyn(get_proc_address);
            self.BlitFramebuffer_load_with_dyn(get_proc_address);
            self.BlitNamedFramebuffer_load_with_dyn(get_proc_address);
            self.BufferData_load_with_dyn(get_proc_address);
            self.BufferStorage_load_with_dyn(get_proc_address);
            self.BufferStorageEXT_load_with_dyn(get_proc_address);
            self.BufferSubData_load_with_dyn(get_proc_address);
            self.CheckFramebufferStatus_load_with_dyn(get_proc_address);
            self.CheckNamedFramebufferStatus_load_with_dyn(get_proc_address);
            self.ClampColor_load_with_dyn(get_proc_address);
            self.Clear_load_with_dyn(get_proc_address);
            self.ClearBufferData_load_with_dyn(get_proc_address);
            self.ClearBufferSubData_load_with_dyn(get_proc_address);
            self.ClearBufferfi_load_with_dyn(get_proc_address);
            self.ClearBufferfv_load_with_dyn(get_proc_address);
            self.ClearBufferiv_load_with_dyn(get_proc_address);
            self.ClearBufferuiv_load_with_dyn(get_proc_address);
            self.ClearColor_load_with_dyn(get_proc_address);
            self.ClearDepth_load_with_dyn(get_proc_address);
            self.ClearDepthf_load_with_dyn(get_proc_address);
            self.ClearNamedBufferData_load_with_dyn(get_proc_address);
            self.ClearNamedBufferSubData_load_with_dyn(get_proc_address);
            self.ClearNamedFramebufferfi_load_with_dyn(get_proc_address);
            self.ClearNamedFramebufferfv_load_with_dyn(get_proc_address);
            self.ClearNamedFramebufferiv_load_with_dyn(get_proc_address);
            self.ClearNamedFramebufferuiv_load_with_dyn(get_proc_address);
            self.ClearStencil_load_with_dyn(get_proc_address);
            self.ClearTexImage_load_with_dyn(get_proc_address);
            self.ClearTexSubImage_load_with_dyn(get_proc_address);
            self.ClientWaitSync_load_with_dyn(get_proc_address);
            self.ClipControl_load_with_dyn(get_proc_address);
            self.ColorMask_load_with_dyn(get_proc_address);
            self.ColorMaskIndexedEXT_load_with_dyn(get_proc_address);
            self.ColorMaski_load_with_dyn(get_proc_address);
            self.CompileShader_load_with_dyn(get_proc_address);
            self.CompressedTexImage1D_load_with_dyn(get_proc_address);
            self.CompressedTexImage2D_load_with_dyn(get_proc_address);
            self.CompressedTexImage3D_load_with_dyn(get_proc_address);
            self.CompressedTexSubImage1D_load_with_dyn(get_proc_address);
            self.CompressedTexSubImage2D_load_with_dyn(get_proc_address);
            self.CompressedTexSubImage3D_load_with_dyn(get_proc_address);
            self.CompressedTextureSubImage1D_load_with_dyn(get_proc_address);
            self.CompressedTextureSubImage2D_load_with_dyn(get_proc_address);
            self.CompressedTextureSubImage3D_load_with_dyn(get_proc_address);
            self.CopyBufferSubData_load_with_dyn(get_proc_address);
            self.CopyBufferSubDataNV_load_with_dyn(get_proc_address);
            self.CopyImageSubData_load_with_dyn(get_proc_address);
            self.CopyNamedBufferSubData_load_with_dyn(get_proc_address);
            self.CopyTexImage1D_load_with_dyn(get_proc_address);
            self.CopyTexImage2D_load_with_dyn(get_proc_address);
            self.CopyTexSubImage1D_load_with_dyn(get_proc_address);
            self.CopyTexSubImage2D_load_with_dyn(get_proc_address);
            self.CopyTexSubImage3D_load_with_dyn(get_proc_address);
            self.CopyTextureSubImage1D_load_with_dyn(get_proc_address);
            self.CopyTextureSubImage2D_load_with_dyn(get_proc_address);
            self.CopyTextureSubImage3D_load_with_dyn(get_proc_address);
            self.CreateBuffers_load_with_dyn(get_proc_address);
            self.CreateFramebuffers_load_with_dyn(get_proc_address);
            self.CreateProgram_load_with_dyn(get_proc_address);
            self.CreateProgramPipelines_load_with_dyn(get_proc_address);
            self.CreateQueries_load_with_dyn(get_proc_address);
            self.CreateRenderbuffers_load_with_dyn(get_proc_address);
            self.CreateSamplers_load_with_dyn(get_proc_address);
            self.CreateShader_load_with_dyn(get_proc_address);
            self.CreateShaderProgramv_load_with_dyn(get_proc_address);
            self.CreateTextures_load_with_dyn(get_proc_address);
            self.CreateTransformFeedbacks_load_with_dyn(get_proc_address);
            self.CreateVertexArrays_load_with_dyn(get_proc_address);
            self.CullFace_load_with_dyn(get_proc_address);
            self.DebugMessageCallback_load_with_dyn(get_proc_address);
            self.DebugMessageCallbackARB_load_with_dyn(get_proc_address);
            self.DebugMessageCallbackKHR_load_with_dyn(get_proc_address);
            self.DebugMessageControl_load_with_dyn(get_proc_address);
            self.DebugMessageControlARB_load_with_dyn(get_proc_address);
            self.DebugMessageControlKHR_load_with_dyn(get_proc_address);
            self.DebugMessageInsert_load_with_dyn(get_proc_address);
            self.DebugMessageInsertARB_load_with_dyn(get_proc_address);
            self.DebugMessageInsertKHR_load_with_dyn(get_proc_address);
            self.DeleteBuffers_load_with_dyn(get_proc_address);
            self.DeleteFramebuffers_load_with_dyn(get_proc_address);
            self.DeleteProgram_load_with_dyn(get_proc_address);
            self.DeleteProgramPipelines_load_with_dyn(get_proc_address);
            self.DeleteQueries_load_with_dyn(get_proc_address);
            self.DeleteRenderbuffers_load_with_dyn(get_proc_address);
            self.DeleteSamplers_load_with_dyn(get_proc_address);
            self.DeleteShader_load_with_dyn(get_proc_address);
            self.DeleteSync_load_with_dyn(get_proc_address);
            self.DeleteTextures_load_with_dyn(get_proc_address);
            self.DeleteTransformFeedbacks_load_with_dyn(get_proc_address);
            self.DeleteVertexArrays_load_with_dyn(get_proc_address);
            self.DepthFunc_load_with_dyn(get_proc_address);
            self.DepthMask_load_with_dyn(get_proc_address);
            self.DepthRange_load_with_dyn(get_proc_address);
            self.DepthRangeArrayv_load_with_dyn(get_proc_address);
            self.DepthRangeIndexed_load_with_dyn(get_proc_address);
            self.DepthRangef_load_with_dyn(get_proc_address);
            self.DetachShader_load_with_dyn(get_proc_address);
            self.Disable_load_with_dyn(get_proc_address);
            self.DisableIndexedEXT_load_with_dyn(get_proc_address);
            self.DisableVertexArrayAttrib_load_with_dyn(get_proc_address);
            self.DisableVertexAttribArray_load_with_dyn(get_proc_address);
            self.Disablei_load_with_dyn(get_proc_address);
            self.DispatchCompute_load_with_dyn(get_proc_address);
            self.DispatchComputeIndirect_load_with_dyn(get_proc_address);
            self.DrawArrays_load_with_dyn(get_proc_address);
            self.DrawArraysIndirect_load_with_dyn(get_proc_address);
            self.DrawArraysInstanced_load_with_dyn(get_proc_address);
            self.DrawArraysInstancedARB_load_with_dyn(get_proc_address);
            self.DrawArraysInstancedBaseInstance_load_with_dyn(get_proc_address);
            self.DrawBuffer_load_with_dyn(get_proc_address);
            self.DrawBuffers_load_with_dyn(get_proc_address);
            self.DrawElements_load_with_dyn(get_proc_address);
            self.DrawElementsBaseVertex_load_with_dyn(get_proc_address);
            self.DrawElementsIndirect_load_with_dyn(get_proc_address);
            self.DrawElementsInstanced_load_with_dyn(get_proc_address);
            self.DrawElementsInstancedARB_load_with_dyn(get_proc_address);
            self.DrawElementsInstancedBaseInstance_load_with_dyn(get_proc_address);
            self.DrawElementsInstancedBaseVertex_load_with_dyn(get_proc_address);
            self.DrawElementsInstancedBaseVertexBaseInstance_load_with_dyn(get_proc_address);
            self.DrawRangeElements_load_with_dyn(get_proc_address);
            self.DrawRangeElementsBaseVertex_load_with_dyn(get_proc_address);
            self.DrawTransformFeedback_load_with_dyn(get_proc_address);
            self.DrawTransformFeedbackInstanced_load_with_dyn(get_proc_address);
            self.DrawTransformFeedbackStream_load_with_dyn(get_proc_address);
            self.DrawTransformFeedbackStreamInstanced_load_with_dyn(get_proc_address);
            self.Enable_load_with_dyn(get_proc_address);
            self.EnableIndexedEXT_load_with_dyn(get_proc_address);
            self.EnableVertexArrayAttrib_load_with_dyn(get_proc_address);
            self.EnableVertexAttribArray_load_with_dyn(get_proc_address);
            self.Enablei_load_with_dyn(get_proc_address);
            self.EndConditionalRender_load_with_dyn(get_proc_address);
            self.EndQuery_load_with_dyn(get_proc_address);
            self.EndQueryIndexed_load_with_dyn(get_proc_address);
            self.EndTransformFeedback_load_with_dyn(get_proc_address);
            self.FenceSync_load_with_dyn(get_proc_address);
            self.Finish_load_with_dyn(get_proc_address);
            self.Flush_load_with_dyn(get_proc_address);
            self.FlushMappedBufferRange_load_with_dyn(get_proc_address);
            self.FlushMappedNamedBufferRange_load_with_dyn(get_proc_address);
            self.FramebufferParameteri_load_with_dyn(get_proc_address);
            self.FramebufferRenderbuffer_load_with_dyn(get_proc_address);
            self.FramebufferTexture_load_with_dyn(get_proc_address);
            self.FramebufferTexture1D_load_with_dyn(get_proc_address);
            self.FramebufferTexture2D_load_with_dyn(get_proc_address);
            self.FramebufferTexture3D_load_with_dyn(get_proc_address);
            self.FramebufferTextureLayer_load_with_dyn(get_proc_address);
            self.FrontFace_load_with_dyn(get_proc_address);
            self.GenBuffers_load_with_dyn(get_proc_address);
            self.GenFramebuffers_load_with_dyn(get_proc_address);
            self.GenProgramPipelines_load_with_dyn(get_proc_address);
            self.GenQueries_load_with_dyn(get_proc_address);
            self.GenRenderbuffers_load_with_dyn(get_proc_address);
            self.GenSamplers_load_with_dyn(get_proc_address);
            self.GenTextures_load_with_dyn(get_proc_address);
            self.GenTransformFeedbacks_load_with_dyn(get_proc_address);
            self.GenVertexArrays_load_with_dyn(get_proc_address);
            self.GenerateMipmap_load_with_dyn(get_proc_address);
            self.GenerateTextureMipmap_load_with_dyn(get_proc_address);
            self.GetActiveAtomicCounterBufferiv_load_with_dyn(get_proc_address);
            self.GetActiveAttrib_load_with_dyn(get_proc_address);
            self.GetActiveSubroutineName_load_with_dyn(get_proc_address);
            self.GetActiveSubroutineUniformName_load_with_dyn(get_proc_address);
            self.GetActiveSubroutineUniformiv_load_with_dyn(get_proc_address);
            self.GetActiveUniform_load_with_dyn(get_proc_address);
            self.GetActiveUniformBlockName_load_with_dyn(get_proc_address);
            self.GetActiveUniformBlockiv_load_with_dyn(get_proc_address);
            self.GetActiveUniformName_load_with_dyn(get_proc_address);
            self.GetActiveUniformsiv_load_with_dyn(get_proc_address);
            self.GetAttachedShaders_load_with_dyn(get_proc_address);
            self.GetAttribLocation_load_with_dyn(get_proc_address);
            self.GetBooleanIndexedvEXT_load_with_dyn(get_proc_address);
            self.GetBooleani_v_load_with_dyn(get_proc_address);
            self.GetBooleanv_load_with_dyn(get_proc_address);
            self.GetBufferParameteri64v_load_with_dyn(get_proc_address);
            self.GetBufferParameteriv_load_with_dyn(get_proc_address);
            self.GetBufferPointerv_load_with_dyn(get_proc_address);
            self.GetBufferSubData_load_with_dyn(get_proc_address);
            self.GetCompressedTexImage_load_with_dyn(get_proc_address);
            self.GetCompressedTextureImage_load_with_dyn(get_proc_address);
            self.GetCompressedTextureSubImage_load_with_dyn(get_proc_address);
            self.GetDebugMessageLog_load_with_dyn(get_proc_address);
            self.GetDebugMessageLogARB_load_with_dyn(get_proc_address);
            self.GetDebugMessageLogKHR_load_with_dyn(get_proc_address);
            self.GetDoublei_v_load_with_dyn(get_proc_address);
            self.GetDoublev_load_with_dyn(get_proc_address);
            self.GetError_load_with_dyn(get_proc_address);
            self.GetFloati_v_load_with_dyn(get_proc_address);
            self.GetFloatv_load_with_dyn(get_proc_address);
            self.GetFragDataIndex_load_with_dyn(get_proc_address);
            self.GetFragDataLocation_load_with_dyn(get_proc_address);
            self.GetFramebufferAttachmentParameteriv_load_with_dyn(get_proc_address);
            self.GetFramebufferParameteriv_load_with_dyn(get_proc_address);
            self.GetGraphicsResetStatus_load_with_dyn(get_proc_address);
            self.GetInteger64i_v_load_with_dyn(get_proc_address);
            self.GetInteger64v_load_with_dyn(get_proc_address);
            self.GetIntegerIndexedvEXT_load_with_dyn(get_proc_address);
            self.GetIntegeri_v_load_with_dyn(get_proc_address);
            self.GetIntegerv_load_with_dyn(get_proc_address);
            self.GetInternalformati64v_load_with_dyn(get_proc_address);
            self.GetInternalformativ_load_with_dyn(get_proc_address);
            self.GetMultisamplefv_load_with_dyn(get_proc_address);
            self.GetNamedBufferParameteri64v_load_with_dyn(get_proc_address);
            self.GetNamedBufferParameteriv_load_with_dyn(get_proc_address);
            self.GetNamedBufferPointerv_load_with_dyn(get_proc_address);
            self.GetNamedBufferSubData_load_with_dyn(get_proc_address);
            self.GetNamedFramebufferAttachmentParameteriv_load_with_dyn(get_proc_address);
            self.GetNamedFramebufferParameteriv_load_with_dyn(get_proc_address);
            self.GetNamedRenderbufferParameteriv_load_with_dyn(get_proc_address);
            self.GetObjectLabel_load_with_dyn(get_proc_address);
            self.GetObjectLabelKHR_load_with_dyn(get_proc_address);
            self.GetObjectPtrLabel_load_with_dyn(get_proc_address);
            self.GetObjectPtrLabelKHR_load_with_dyn(get_proc_address);
            self.GetPointerv_load_with_dyn(get_proc_address);
            self.GetPointervKHR_load_with_dyn(get_proc_address);
            self.GetProgramBinary_load_with_dyn(get_proc_address);
            self.GetProgramInfoLog_load_with_dyn(get_proc_address);
            self.GetProgramInterfaceiv_load_with_dyn(get_proc_address);
            self.GetProgramPipelineInfoLog_load_with_dyn(get_proc_address);
            self.GetProgramPipelineiv_load_with_dyn(get_proc_address);
            self.GetProgramResourceIndex_load_with_dyn(get_proc_address);
            self.GetProgramResourceLocation_load_with_dyn(get_proc_address);
            self.GetProgramResourceLocationIndex_load_with_dyn(get_proc_address);
            self.GetProgramResourceName_load_with_dyn(get_proc_address);
            self.GetProgramResourceiv_load_with_dyn(get_proc_address);
            self.GetProgramStageiv_load_with_dyn(get_proc_address);
            self.GetProgramiv_load_with_dyn(get_proc_address);
            self.GetQueryBufferObjecti64v_load_with_dyn(get_proc_address);
            self.GetQueryBufferObjectiv_load_with_dyn(get_proc_address);
            self.GetQueryBufferObjectui64v_load_with_dyn(get_proc_address);
            self.GetQueryBufferObjectuiv_load_with_dyn(get_proc_address);
            self.GetQueryIndexediv_load_with_dyn(get_proc_address);
            self.GetQueryObjecti64v_load_with_dyn(get_proc_address);
            self.GetQueryObjectiv_load_with_dyn(get_proc_address);
            self.GetQueryObjectui64v_load_with_dyn(get_proc_address);
            self.GetQueryObjectuiv_load_with_dyn(get_proc_address);
            self.GetQueryiv_load_with_dyn(get_proc_address);
            self.GetRenderbufferParameteriv_load_with_dyn(get_proc_address);
            self.GetSamplerParameterIiv_load_with_dyn(get_proc_address);
            self.GetSamplerParameterIuiv_load_with_dyn(get_proc_address);
            self.GetSamplerParameterfv_load_with_dyn(get_proc_address);
            self.GetSamplerParameteriv_load_with_dyn(get_proc_address);
            self.GetShaderInfoLog_load_with_dyn(get_proc_address);
            self.GetShaderPrecisionFormat_load_with_dyn(get_proc_address);
            self.GetShaderSource_load_with_dyn(get_proc_address);
            self.GetShaderiv_load_with_dyn(get_proc_address);
            self.GetString_load_with_dyn(get_proc_address);
            self.GetStringi_load_with_dyn(get_proc_address);
            self.GetSubroutineIndex_load_with_dyn(get_proc_address);
            self.GetSubroutineUniformLocation_load_with_dyn(get_proc_address);
            self.GetSynciv_load_with_dyn(get_proc_address);
            self.GetTexImage_load_with_dyn(get_proc_address);
            self.GetTexLevelParameterfv_load_with_dyn(get_proc_address);
            self.GetTexLevelParameteriv_load_with_dyn(get_proc_address);
            self.GetTexParameterIiv_load_with_dyn(get_proc_address);
            self.GetTexParameterIuiv_load_with_dyn(get_proc_address);
            self.GetTexParameterfv_load_with_dyn(get_proc_address);
            self.GetTexParameteriv_load_with_dyn(get_proc_address);
            self.GetTextureImage_load_with_dyn(get_proc_address);
            self.GetTextureLevelParameterfv_load_with_dyn(get_proc_address);
            self.GetTextureLevelParameteriv_load_with_dyn(get_proc_address);
            self.GetTextureParameterIiv_load_with_dyn(get_proc_address);
            self.GetTextureParameterIuiv_load_with_dyn(get_proc_address);
            self.GetTextureParameterfv_load_with_dyn(get_proc_address);
            self.GetTextureParameteriv_load_with_dyn(get_proc_address);
            self.GetTextureSubImage_load_with_dyn(get_proc_address);
            self.GetTransformFeedbackVarying_load_with_dyn(get_proc_address);
            self.GetTransformFeedbacki64_v_load_with_dyn(get_proc_address);
            self.GetTransformFeedbacki_v_load_with_dyn(get_proc_address);
            self.GetTransformFeedbackiv_load_with_dyn(get_proc_address);
            self.GetUniformBlockIndex_load_with_dyn(get_proc_address);
            self.GetUniformIndices_load_with_dyn(get_proc_address);
            self.GetUniformLocation_load_with_dyn(get_proc_address);
            self.GetUniformSubroutineuiv_load_with_dyn(get_proc_address);
            self.GetUniformdv_load_with_dyn(get_proc_address);
            self.GetUniformfv_load_with_dyn(get_proc_address);
            self.GetUniformiv_load_with_dyn(get_proc_address);
            self.GetUniformuiv_load_with_dyn(get_proc_address);
            self.GetVertexArrayIndexed64iv_load_with_dyn(get_proc_address);
            self.GetVertexArrayIndexediv_load_with_dyn(get_proc_address);
            self.GetVertexArrayiv_load_with_dyn(get_proc_address);
            self.GetVertexAttribIiv_load_with_dyn(get_proc_address);
            self.GetVertexAttribIuiv_load_with_dyn(get_proc_address);
            self.GetVertexAttribLdv_load_with_dyn(get_proc_address);
            self.GetVertexAttribPointerv_load_with_dyn(get_proc_address);
            self.GetVertexAttribdv_load_with_dyn(get_proc_address);
            self.GetVertexAttribfv_load_with_dyn(get_proc_address);
            self.GetVertexAttribiv_load_with_dyn(get_proc_address);
            self.GetnCompressedTexImage_load_with_dyn(get_proc_address);
            self.GetnTexImage_load_with_dyn(get_proc_address);
            self.GetnUniformdv_load_with_dyn(get_proc_address);
            self.GetnUniformfv_load_with_dyn(get_proc_address);
            self.GetnUniformiv_load_with_dyn(get_proc_address);
            self.GetnUniformuiv_load_with_dyn(get_proc_address);
            self.Hint_load_with_dyn(get_proc_address);
            self.InvalidateBufferData_load_with_dyn(get_proc_address);
            self.InvalidateBufferSubData_load_with_dyn(get_proc_address);
            self.InvalidateFramebuffer_load_with_dyn(get_proc_address);
            self.InvalidateNamedFramebufferData_load_with_dyn(get_proc_address);
            self.InvalidateNamedFramebufferSubData_load_with_dyn(get_proc_address);
            self.InvalidateSubFramebuffer_load_with_dyn(get_proc_address);
            self.InvalidateTexImage_load_with_dyn(get_proc_address);
            self.InvalidateTexSubImage_load_with_dyn(get_proc_address);
            self.IsBuffer_load_with_dyn(get_proc_address);
            self.IsEnabled_load_with_dyn(get_proc_address);

            {
                self.IsEnabledIndexedEXT_load_with_dyn(get_proc_address);
            }
            self.IsEnabledi_load_with_dyn(get_proc_address);
            self.IsFramebuffer_load_with_dyn(get_proc_address);
            self.IsProgram_load_with_dyn(get_proc_address);
            self.IsProgramPipeline_load_with_dyn(get_proc_address);
            self.IsQuery_load_with_dyn(get_proc_address);
            self.IsRenderbuffer_load_with_dyn(get_proc_address);
            self.IsSampler_load_with_dyn(get_proc_address);
            self.IsShader_load_with_dyn(get_proc_address);
            self.IsSync_load_with_dyn(get_proc_address);
            self.IsTexture_load_with_dyn(get_proc_address);
            self.IsTransformFeedback_load_with_dyn(get_proc_address);
            self.IsVertexArray_load_with_dyn(get_proc_address);
            self.LineWidth_load_with_dyn(get_proc_address);
            self.LinkProgram_load_with_dyn(get_proc_address);
            self.LogicOp_load_with_dyn(get_proc_address);
            self.MapBuffer_load_with_dyn(get_proc_address);
            self.MapBufferRange_load_with_dyn(get_proc_address);
            self.MapNamedBuffer_load_with_dyn(get_proc_address);
            self.MapNamedBufferRange_load_with_dyn(get_proc_address);

            {
                self.MaxShaderCompilerThreadsARB_load_with_dyn(get_proc_address);
            }

            {
                self.MaxShaderCompilerThreadsKHR_load_with_dyn(get_proc_address);
            }
            self.MemoryBarrier_load_with_dyn(get_proc_address);
            self.MemoryBarrierByRegion_load_with_dyn(get_proc_address);
            self.MinSampleShading_load_with_dyn(get_proc_address);
            self.MultiDrawArrays_load_with_dyn(get_proc_address);
            self.MultiDrawArraysIndirect_load_with_dyn(get_proc_address);
            self.MultiDrawArraysIndirectCount_load_with_dyn(get_proc_address);
            self.MultiDrawElements_load_with_dyn(get_proc_address);
            self.MultiDrawElementsBaseVertex_load_with_dyn(get_proc_address);
            self.MultiDrawElementsIndirect_load_with_dyn(get_proc_address);
            self.MultiDrawElementsIndirectCount_load_with_dyn(get_proc_address);
            self.NamedBufferData_load_with_dyn(get_proc_address);
            self.NamedBufferStorage_load_with_dyn(get_proc_address);
            self.NamedBufferSubData_load_with_dyn(get_proc_address);
            self.NamedFramebufferDrawBuffer_load_with_dyn(get_proc_address);
            self.NamedFramebufferDrawBuffers_load_with_dyn(get_proc_address);
            self.NamedFramebufferParameteri_load_with_dyn(get_proc_address);
            self.NamedFramebufferReadBuffer_load_with_dyn(get_proc_address);
            self.NamedFramebufferRenderbuffer_load_with_dyn(get_proc_address);
            self.NamedFramebufferTexture_load_with_dyn(get_proc_address);
            self.NamedFramebufferTextureLayer_load_with_dyn(get_proc_address);
            self.NamedRenderbufferStorage_load_with_dyn(get_proc_address);
            self.NamedRenderbufferStorageMultisample_load_with_dyn(get_proc_address);
            self.ObjectLabel_load_with_dyn(get_proc_address);
            self.ObjectLabelKHR_load_with_dyn(get_proc_address);
            self.ObjectPtrLabel_load_with_dyn(get_proc_address);
            self.ObjectPtrLabelKHR_load_with_dyn(get_proc_address);
            self.PatchParameterfv_load_with_dyn(get_proc_address);
            self.PatchParameteri_load_with_dyn(get_proc_address);
            self.PauseTransformFeedback_load_with_dyn(get_proc_address);
            self.PixelStoref_load_with_dyn(get_proc_address);
            self.PixelStorei_load_with_dyn(get_proc_address);
            self.PointParameterf_load_with_dyn(get_proc_address);
            self.PointParameterfv_load_with_dyn(get_proc_address);
            self.PointParameteri_load_with_dyn(get_proc_address);
            self.PointParameteriv_load_with_dyn(get_proc_address);
            self.PointSize_load_with_dyn(get_proc_address);
            self.PolygonMode_load_with_dyn(get_proc_address);
            self.PolygonOffset_load_with_dyn(get_proc_address);
            self.PolygonOffsetClamp_load_with_dyn(get_proc_address);
            self.PopDebugGroup_load_with_dyn(get_proc_address);
            self.PopDebugGroupKHR_load_with_dyn(get_proc_address);
            self.PrimitiveBoundingBox_load_with_dyn(get_proc_address);
            self.PrimitiveRestartIndex_load_with_dyn(get_proc_address);
            self.ProgramBinary_load_with_dyn(get_proc_address);
            self.ProgramParameteri_load_with_dyn(get_proc_address);
            self.ProgramUniform1d_load_with_dyn(get_proc_address);
            self.ProgramUniform1dv_load_with_dyn(get_proc_address);
            self.ProgramUniform1f_load_with_dyn(get_proc_address);
            self.ProgramUniform1fv_load_with_dyn(get_proc_address);
            self.ProgramUniform1i_load_with_dyn(get_proc_address);
            self.ProgramUniform1iv_load_with_dyn(get_proc_address);
            self.ProgramUniform1ui_load_with_dyn(get_proc_address);
            self.ProgramUniform1uiv_load_with_dyn(get_proc_address);
            self.ProgramUniform2d_load_with_dyn(get_proc_address);
            self.ProgramUniform2dv_load_with_dyn(get_proc_address);
            self.ProgramUniform2f_load_with_dyn(get_proc_address);
            self.ProgramUniform2fv_load_with_dyn(get_proc_address);
            self.ProgramUniform2i_load_with_dyn(get_proc_address);
            self.ProgramUniform2iv_load_with_dyn(get_proc_address);
            self.ProgramUniform2ui_load_with_dyn(get_proc_address);
            self.ProgramUniform2uiv_load_with_dyn(get_proc_address);
            self.ProgramUniform3d_load_with_dyn(get_proc_address);
            self.ProgramUniform3dv_load_with_dyn(get_proc_address);
            self.ProgramUniform3f_load_with_dyn(get_proc_address);
            self.ProgramUniform3fv_load_with_dyn(get_proc_address);
            self.ProgramUniform3i_load_with_dyn(get_proc_address);
            self.ProgramUniform3iv_load_with_dyn(get_proc_address);
            self.ProgramUniform3ui_load_with_dyn(get_proc_address);
            self.ProgramUniform3uiv_load_with_dyn(get_proc_address);
            self.ProgramUniform4d_load_with_dyn(get_proc_address);
            self.ProgramUniform4dv_load_with_dyn(get_proc_address);
            self.ProgramUniform4f_load_with_dyn(get_proc_address);
            self.ProgramUniform4fv_load_with_dyn(get_proc_address);
            self.ProgramUniform4i_load_with_dyn(get_proc_address);
            self.ProgramUniform4iv_load_with_dyn(get_proc_address);
            self.ProgramUniform4ui_load_with_dyn(get_proc_address);
            self.ProgramUniform4uiv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix2dv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix2fv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix2x3dv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix2x3fv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix2x4dv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix2x4fv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix3dv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix3fv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix3x2dv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix3x2fv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix3x4dv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix3x4fv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix4dv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix4fv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix4x2dv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix4x2fv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix4x3dv_load_with_dyn(get_proc_address);
            self.ProgramUniformMatrix4x3fv_load_with_dyn(get_proc_address);
            self.ProvokingVertex_load_with_dyn(get_proc_address);
            self.PushDebugGroup_load_with_dyn(get_proc_address);
            self.PushDebugGroupKHR_load_with_dyn(get_proc_address);
            self.QueryCounter_load_with_dyn(get_proc_address);
            self.ReadBuffer_load_with_dyn(get_proc_address);
            self.ReadPixels_load_with_dyn(get_proc_address);
            self.ReadnPixels_load_with_dyn(get_proc_address);
            self.ReleaseShaderCompiler_load_with_dyn(get_proc_address);
            self.RenderbufferStorage_load_with_dyn(get_proc_address);
            self.RenderbufferStorageMultisample_load_with_dyn(get_proc_address);
            self.ResumeTransformFeedback_load_with_dyn(get_proc_address);
            self.SampleCoverage_load_with_dyn(get_proc_address);
            self.SampleMaski_load_with_dyn(get_proc_address);
            self.SamplerParameterIiv_load_with_dyn(get_proc_address);
            self.SamplerParameterIuiv_load_with_dyn(get_proc_address);
            self.SamplerParameterf_load_with_dyn(get_proc_address);
            self.SamplerParameterfv_load_with_dyn(get_proc_address);
            self.SamplerParameteri_load_with_dyn(get_proc_address);
            self.SamplerParameteriv_load_with_dyn(get_proc_address);
            self.Scissor_load_with_dyn(get_proc_address);
            self.ScissorArrayv_load_with_dyn(get_proc_address);
            self.ScissorIndexed_load_with_dyn(get_proc_address);
            self.ScissorIndexedv_load_with_dyn(get_proc_address);
            self.ShaderBinary_load_with_dyn(get_proc_address);
            self.ShaderSource_load_with_dyn(get_proc_address);
            self.ShaderStorageBlockBinding_load_with_dyn(get_proc_address);
            self.SpecializeShader_load_with_dyn(get_proc_address);
            self.StencilFunc_load_with_dyn(get_proc_address);
            self.StencilFuncSeparate_load_with_dyn(get_proc_address);
            self.StencilMask_load_with_dyn(get_proc_address);
            self.StencilMaskSeparate_load_with_dyn(get_proc_address);
            self.StencilOp_load_with_dyn(get_proc_address);
            self.StencilOpSeparate_load_with_dyn(get_proc_address);
            self.TexBuffer_load_with_dyn(get_proc_address);
            self.TexBufferRange_load_with_dyn(get_proc_address);
            self.TexImage1D_load_with_dyn(get_proc_address);
            self.TexImage2D_load_with_dyn(get_proc_address);
            self.TexImage2DMultisample_load_with_dyn(get_proc_address);
            self.TexImage3D_load_with_dyn(get_proc_address);
            self.TexImage3DMultisample_load_with_dyn(get_proc_address);
            self.TexParameterIiv_load_with_dyn(get_proc_address);
            self.TexParameterIuiv_load_with_dyn(get_proc_address);
            self.TexParameterf_load_with_dyn(get_proc_address);
            self.TexParameterfv_load_with_dyn(get_proc_address);
            self.TexParameteri_load_with_dyn(get_proc_address);
            self.TexParameteriv_load_with_dyn(get_proc_address);
            self.TexStorage1D_load_with_dyn(get_proc_address);
            self.TexStorage2D_load_with_dyn(get_proc_address);
            self.TexStorage2DMultisample_load_with_dyn(get_proc_address);
            self.TexStorage3D_load_with_dyn(get_proc_address);
            self.TexStorage3DMultisample_load_with_dyn(get_proc_address);
            self.TexSubImage1D_load_with_dyn(get_proc_address);
            self.TexSubImage2D_load_with_dyn(get_proc_address);
            self.TexSubImage3D_load_with_dyn(get_proc_address);
            self.TextureBarrier_load_with_dyn(get_proc_address);
            self.TextureBuffer_load_with_dyn(get_proc_address);
            self.TextureBufferRange_load_with_dyn(get_proc_address);
            self.TextureParameterIiv_load_with_dyn(get_proc_address);
            self.TextureParameterIuiv_load_with_dyn(get_proc_address);
            self.TextureParameterf_load_with_dyn(get_proc_address);
            self.TextureParameterfv_load_with_dyn(get_proc_address);
            self.TextureParameteri_load_with_dyn(get_proc_address);
            self.TextureParameteriv_load_with_dyn(get_proc_address);
            self.TextureStorage1D_load_with_dyn(get_proc_address);
            self.TextureStorage2D_load_with_dyn(get_proc_address);
            self.TextureStorage2DMultisample_load_with_dyn(get_proc_address);
            self.TextureStorage3D_load_with_dyn(get_proc_address);
            self.TextureStorage3DMultisample_load_with_dyn(get_proc_address);
            self.TextureSubImage1D_load_with_dyn(get_proc_address);
            self.TextureSubImage2D_load_with_dyn(get_proc_address);
            self.TextureSubImage3D_load_with_dyn(get_proc_address);
            self.TextureView_load_with_dyn(get_proc_address);
            self.TransformFeedbackBufferBase_load_with_dyn(get_proc_address);
            self.TransformFeedbackBufferRange_load_with_dyn(get_proc_address);
            self.TransformFeedbackVaryings_load_with_dyn(get_proc_address);
            self.Uniform1d_load_with_dyn(get_proc_address);
            self.Uniform1dv_load_with_dyn(get_proc_address);
            self.Uniform1f_load_with_dyn(get_proc_address);
            self.Uniform1fv_load_with_dyn(get_proc_address);
            self.Uniform1i_load_with_dyn(get_proc_address);
            self.Uniform1iv_load_with_dyn(get_proc_address);
            self.Uniform1ui_load_with_dyn(get_proc_address);
            self.Uniform1uiv_load_with_dyn(get_proc_address);
            self.Uniform2d_load_with_dyn(get_proc_address);
            self.Uniform2dv_load_with_dyn(get_proc_address);
            self.Uniform2f_load_with_dyn(get_proc_address);
            self.Uniform2fv_load_with_dyn(get_proc_address);
            self.Uniform2i_load_with_dyn(get_proc_address);
            self.Uniform2iv_load_with_dyn(get_proc_address);
            self.Uniform2ui_load_with_dyn(get_proc_address);
            self.Uniform2uiv_load_with_dyn(get_proc_address);
            self.Uniform3d_load_with_dyn(get_proc_address);
            self.Uniform3dv_load_with_dyn(get_proc_address);
            self.Uniform3f_load_with_dyn(get_proc_address);
            self.Uniform3fv_load_with_dyn(get_proc_address);
            self.Uniform3i_load_with_dyn(get_proc_address);
            self.Uniform3iv_load_with_dyn(get_proc_address);
            self.Uniform3ui_load_with_dyn(get_proc_address);
            self.Uniform3uiv_load_with_dyn(get_proc_address);
            self.Uniform4d_load_with_dyn(get_proc_address);
            self.Uniform4dv_load_with_dyn(get_proc_address);
            self.Uniform4f_load_with_dyn(get_proc_address);
            self.Uniform4fv_load_with_dyn(get_proc_address);
            self.Uniform4i_load_with_dyn(get_proc_address);
            self.Uniform4iv_load_with_dyn(get_proc_address);
            self.Uniform4ui_load_with_dyn(get_proc_address);
            self.Uniform4uiv_load_with_dyn(get_proc_address);
            self.UniformBlockBinding_load_with_dyn(get_proc_address);
            self.UniformMatrix2dv_load_with_dyn(get_proc_address);
            self.UniformMatrix2fv_load_with_dyn(get_proc_address);
            self.UniformMatrix2x3dv_load_with_dyn(get_proc_address);
            self.UniformMatrix2x3fv_load_with_dyn(get_proc_address);
            self.UniformMatrix2x4dv_load_with_dyn(get_proc_address);
            self.UniformMatrix2x4fv_load_with_dyn(get_proc_address);
            self.UniformMatrix3dv_load_with_dyn(get_proc_address);
            self.UniformMatrix3fv_load_with_dyn(get_proc_address);
            self.UniformMatrix3x2dv_load_with_dyn(get_proc_address);
            self.UniformMatrix3x2fv_load_with_dyn(get_proc_address);
            self.UniformMatrix3x4dv_load_with_dyn(get_proc_address);
            self.UniformMatrix3x4fv_load_with_dyn(get_proc_address);
            self.UniformMatrix4dv_load_with_dyn(get_proc_address);
            self.UniformMatrix4fv_load_with_dyn(get_proc_address);
            self.UniformMatrix4x2dv_load_with_dyn(get_proc_address);
            self.UniformMatrix4x2fv_load_with_dyn(get_proc_address);
            self.UniformMatrix4x3dv_load_with_dyn(get_proc_address);
            self.UniformMatrix4x3fv_load_with_dyn(get_proc_address);
            self.UniformSubroutinesuiv_load_with_dyn(get_proc_address);
            self.UnmapBuffer_load_with_dyn(get_proc_address);
            self.UnmapNamedBuffer_load_with_dyn(get_proc_address);
            self.UseProgram_load_with_dyn(get_proc_address);
            self.UseProgramStages_load_with_dyn(get_proc_address);
            self.ValidateProgram_load_with_dyn(get_proc_address);
            self.ValidateProgramPipeline_load_with_dyn(get_proc_address);
            self.VertexArrayAttribBinding_load_with_dyn(get_proc_address);
            self.VertexArrayAttribFormat_load_with_dyn(get_proc_address);
            self.VertexArrayAttribIFormat_load_with_dyn(get_proc_address);
            self.VertexArrayAttribLFormat_load_with_dyn(get_proc_address);
            self.VertexArrayBindingDivisor_load_with_dyn(get_proc_address);
            self.VertexArrayElementBuffer_load_with_dyn(get_proc_address);
            self.VertexArrayVertexBuffer_load_with_dyn(get_proc_address);
            self.VertexArrayVertexBuffers_load_with_dyn(get_proc_address);
            self.VertexAttrib1d_load_with_dyn(get_proc_address);
            self.VertexAttrib1dv_load_with_dyn(get_proc_address);
            self.VertexAttrib1f_load_with_dyn(get_proc_address);
            self.VertexAttrib1fv_load_with_dyn(get_proc_address);
            self.VertexAttrib1s_load_with_dyn(get_proc_address);
            self.VertexAttrib1sv_load_with_dyn(get_proc_address);
            self.VertexAttrib2d_load_with_dyn(get_proc_address);
            self.VertexAttrib2dv_load_with_dyn(get_proc_address);
            self.VertexAttrib2f_load_with_dyn(get_proc_address);
            self.VertexAttrib2fv_load_with_dyn(get_proc_address);
            self.VertexAttrib2s_load_with_dyn(get_proc_address);
            self.VertexAttrib2sv_load_with_dyn(get_proc_address);
            self.VertexAttrib3d_load_with_dyn(get_proc_address);
            self.VertexAttrib3dv_load_with_dyn(get_proc_address);
            self.VertexAttrib3f_load_with_dyn(get_proc_address);
            self.VertexAttrib3fv_load_with_dyn(get_proc_address);
            self.VertexAttrib3s_load_with_dyn(get_proc_address);
            self.VertexAttrib3sv_load_with_dyn(get_proc_address);
            self.VertexAttrib4Nbv_load_with_dyn(get_proc_address);
            self.VertexAttrib4Niv_load_with_dyn(get_proc_address);
            self.VertexAttrib4Nsv_load_with_dyn(get_proc_address);
            self.VertexAttrib4Nub_load_with_dyn(get_proc_address);
            self.VertexAttrib4Nubv_load_with_dyn(get_proc_address);
            self.VertexAttrib4Nuiv_load_with_dyn(get_proc_address);
            self.VertexAttrib4Nusv_load_with_dyn(get_proc_address);
            self.VertexAttrib4bv_load_with_dyn(get_proc_address);
            self.VertexAttrib4d_load_with_dyn(get_proc_address);
            self.VertexAttrib4dv_load_with_dyn(get_proc_address);
            self.VertexAttrib4f_load_with_dyn(get_proc_address);
            self.VertexAttrib4fv_load_with_dyn(get_proc_address);
            self.VertexAttrib4iv_load_with_dyn(get_proc_address);
            self.VertexAttrib4s_load_with_dyn(get_proc_address);
            self.VertexAttrib4sv_load_with_dyn(get_proc_address);
            self.VertexAttrib4ubv_load_with_dyn(get_proc_address);
            self.VertexAttrib4uiv_load_with_dyn(get_proc_address);
            self.VertexAttrib4usv_load_with_dyn(get_proc_address);
            self.VertexAttribBinding_load_with_dyn(get_proc_address);
            self.VertexAttribDivisor_load_with_dyn(get_proc_address);
            self.VertexAttribDivisorARB_load_with_dyn(get_proc_address);
            self.VertexAttribFormat_load_with_dyn(get_proc_address);
            self.VertexAttribI1i_load_with_dyn(get_proc_address);
            self.VertexAttribI1iv_load_with_dyn(get_proc_address);
            self.VertexAttribI1ui_load_with_dyn(get_proc_address);
            self.VertexAttribI1uiv_load_with_dyn(get_proc_address);
            self.VertexAttribI2i_load_with_dyn(get_proc_address);
            self.VertexAttribI2iv_load_with_dyn(get_proc_address);
            self.VertexAttribI2ui_load_with_dyn(get_proc_address);
            self.VertexAttribI2uiv_load_with_dyn(get_proc_address);
            self.VertexAttribI3i_load_with_dyn(get_proc_address);
            self.VertexAttribI3iv_load_with_dyn(get_proc_address);
            self.VertexAttribI3ui_load_with_dyn(get_proc_address);
            self.VertexAttribI3uiv_load_with_dyn(get_proc_address);
            self.VertexAttribI4bv_load_with_dyn(get_proc_address);
            self.VertexAttribI4i_load_with_dyn(get_proc_address);
            self.VertexAttribI4iv_load_with_dyn(get_proc_address);
            self.VertexAttribI4sv_load_with_dyn(get_proc_address);
            self.VertexAttribI4ubv_load_with_dyn(get_proc_address);
            self.VertexAttribI4ui_load_with_dyn(get_proc_address);
            self.VertexAttribI4uiv_load_with_dyn(get_proc_address);
            self.VertexAttribI4usv_load_with_dyn(get_proc_address);
            self.VertexAttribIFormat_load_with_dyn(get_proc_address);
            self.VertexAttribIPointer_load_with_dyn(get_proc_address);
            self.VertexAttribL1d_load_with_dyn(get_proc_address);
            self.VertexAttribL1dv_load_with_dyn(get_proc_address);
            self.VertexAttribL2d_load_with_dyn(get_proc_address);
            self.VertexAttribL2dv_load_with_dyn(get_proc_address);
            self.VertexAttribL3d_load_with_dyn(get_proc_address);
            self.VertexAttribL3dv_load_with_dyn(get_proc_address);
            self.VertexAttribL4d_load_with_dyn(get_proc_address);
            self.VertexAttribL4dv_load_with_dyn(get_proc_address);
            self.VertexAttribLFormat_load_with_dyn(get_proc_address);
            self.VertexAttribLPointer_load_with_dyn(get_proc_address);
            self.VertexAttribP1ui_load_with_dyn(get_proc_address);
            self.VertexAttribP1uiv_load_with_dyn(get_proc_address);
            self.VertexAttribP2ui_load_with_dyn(get_proc_address);
            self.VertexAttribP2uiv_load_with_dyn(get_proc_address);
            self.VertexAttribP3ui_load_with_dyn(get_proc_address);
            self.VertexAttribP3uiv_load_with_dyn(get_proc_address);
            self.VertexAttribP4ui_load_with_dyn(get_proc_address);
            self.VertexAttribP4uiv_load_with_dyn(get_proc_address);
            self.VertexAttribPointer_load_with_dyn(get_proc_address);
            self.VertexBindingDivisor_load_with_dyn(get_proc_address);
            self.Viewport_load_with_dyn(get_proc_address);
            self.ViewportArrayv_load_with_dyn(get_proc_address);
            self.ViewportIndexedf_load_with_dyn(get_proc_address);
            self.ViewportIndexedfv_load_with_dyn(get_proc_address);
            self.WaitSync_load_with_dyn(get_proc_address);
        }
        /// [glActiveShaderProgram](http://docs.gl/gl4/glActiveShaderProgram)(pipeline, program)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ActiveShaderProgram(&self, pipeline: GLuint, program: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ActiveShaderProgram({:?}, {:?});",
                    pipeline,
                    program
                );
            }
            let out = call_atomic_ptr_2arg(
                "glActiveShaderProgram",
                &self.glActiveShaderProgram_p,
                pipeline,
                program,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glActiveShaderProgram");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ActiveShaderProgram_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glActiveShaderProgram\0",
                &self.glActiveShaderProgram_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ActiveShaderProgram_is_loaded(&self) -> bool {
            !self.glActiveShaderProgram_p.load(RELAX).is_null()
        }
        /// [glActiveTexture](http://docs.gl/gl4/glActiveTexture)(texture)
        /// * `texture` group: TextureUnit
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ActiveTexture(&self, texture: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.ActiveTexture({:#X});", texture);
            }
            let out = call_atomic_ptr_1arg("glActiveTexture", &self.glActiveTexture_p, texture);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glActiveTexture");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ActiveTexture_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glActiveTexture\0",
                &self.glActiveTexture_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ActiveTexture_is_loaded(&self) -> bool {
            !self.glActiveTexture_p.load(RELAX).is_null()
        }
        /// [glAttachShader](http://docs.gl/gl4/glAttachShader)(program, shader)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn AttachShader(&self, program: GLuint, shader: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.AttachShader({:?}, {:?});", program, shader);
            }
            let out =
                call_atomic_ptr_2arg("glAttachShader", &self.glAttachShader_p, program, shader);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glAttachShader");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn AttachShader_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glAttachShader\0",
                &self.glAttachShader_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn AttachShader_is_loaded(&self) -> bool {
            !self.glAttachShader_p.load(RELAX).is_null()
        }
        /// [glBeginConditionalRender](http://docs.gl/gl4/glBeginConditionalRender)(id, mode)
        /// * `mode` group: ConditionalRenderMode
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BeginConditionalRender(&self, id: GLuint, mode: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BeginConditionalRender({:?}, {:#X});", id, mode);
            }
            let out = call_atomic_ptr_2arg(
                "glBeginConditionalRender",
                &self.glBeginConditionalRender_p,
                id,
                mode,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBeginConditionalRender");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BeginConditionalRender_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBeginConditionalRender\0",
                &self.glBeginConditionalRender_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BeginConditionalRender_is_loaded(&self) -> bool {
            !self.glBeginConditionalRender_p.load(RELAX).is_null()
        }
        /// [glBeginQuery](http://docs.gl/gl4/glBeginQuery)(target, id)
        /// * `target` group: QueryTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BeginQuery(&self, target: GLenum, id: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BeginQuery({:#X}, {:?});", target, id);
            }
            let out = call_atomic_ptr_2arg("glBeginQuery", &self.glBeginQuery_p, target, id);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBeginQuery");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BeginQuery_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glBeginQuery\0", &self.glBeginQuery_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn BeginQuery_is_loaded(&self) -> bool {
            !self.glBeginQuery_p.load(RELAX).is_null()
        }
        /// [glBeginQueryIndexed](http://docs.gl/gl4/glBeginQueryIndexed)(target, index, id)
        /// * `target` group: QueryTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BeginQueryIndexed(&self, target: GLenum, index: GLuint, id: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BeginQueryIndexed({:#X}, {:?}, {:?});",
                    target,
                    index,
                    id
                );
            }
            let out = call_atomic_ptr_3arg(
                "glBeginQueryIndexed",
                &self.glBeginQueryIndexed_p,
                target,
                index,
                id,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBeginQueryIndexed");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BeginQueryIndexed_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBeginQueryIndexed\0",
                &self.glBeginQueryIndexed_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BeginQueryIndexed_is_loaded(&self) -> bool {
            !self.glBeginQueryIndexed_p.load(RELAX).is_null()
        }
        /// [glBeginTransformFeedback](http://docs.gl/gl4/glBeginTransformFeedback)(primitiveMode)
        /// * `primitiveMode` group: PrimitiveType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BeginTransformFeedback(&self, primitiveMode: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BeginTransformFeedback({:#X});", primitiveMode);
            }
            let out = call_atomic_ptr_1arg(
                "glBeginTransformFeedback",
                &self.glBeginTransformFeedback_p,
                primitiveMode,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBeginTransformFeedback");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BeginTransformFeedback_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBeginTransformFeedback\0",
                &self.glBeginTransformFeedback_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BeginTransformFeedback_is_loaded(&self) -> bool {
            !self.glBeginTransformFeedback_p.load(RELAX).is_null()
        }
        /// [glBindAttribLocation](http://docs.gl/gl4/glBindAttribLocation)(program, index, name)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindAttribLocation(
            &self,
            program: GLuint,
            index: GLuint,
            name: *const GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindAttribLocation({:?}, {:?}, {:p});",
                    program,
                    index,
                    name
                );
            }
            let out = call_atomic_ptr_3arg(
                "glBindAttribLocation",
                &self.glBindAttribLocation_p,
                program,
                index,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindAttribLocation");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindAttribLocation_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindAttribLocation\0",
                &self.glBindAttribLocation_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindAttribLocation_is_loaded(&self) -> bool {
            !self.glBindAttribLocation_p.load(RELAX).is_null()
        }
        /// [glBindBuffer](http://docs.gl/gl4/glBindBuffer)(target, buffer)
        /// * `target` group: BufferTargetARB
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindBuffer(&self, target: GLenum, buffer: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BindBuffer({:#X}, {:?});", target, buffer);
            }
            let out = call_atomic_ptr_2arg("glBindBuffer", &self.glBindBuffer_p, target, buffer);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindBuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindBuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glBindBuffer\0", &self.glBindBuffer_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindBuffer_is_loaded(&self) -> bool {
            !self.glBindBuffer_p.load(RELAX).is_null()
        }
        /// [glBindBufferBase](http://docs.gl/gl4/glBindBufferBase)(target, index, buffer)
        /// * `target` group: BufferTargetARB
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindBufferBase(&self, target: GLenum, index: GLuint, buffer: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindBufferBase({:#X}, {:?}, {:?});",
                    target,
                    index,
                    buffer
                );
            }
            let out = call_atomic_ptr_3arg(
                "glBindBufferBase",
                &self.glBindBufferBase_p,
                target,
                index,
                buffer,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindBufferBase");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindBufferBase_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindBufferBase\0",
                &self.glBindBufferBase_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindBufferBase_is_loaded(&self) -> bool {
            !self.glBindBufferBase_p.load(RELAX).is_null()
        }
        /// [glBindBufferRange](http://docs.gl/gl4/glBindBufferRange)(target, index, buffer, offset, size)
        /// * `target` group: BufferTargetARB
        /// * `offset` group: BufferOffset
        /// * `size` group: BufferSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindBufferRange(
            &self,
            target: GLenum,
            index: GLuint,
            buffer: GLuint,
            offset: GLintptr,
            size: GLsizeiptr,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindBufferRange({:#X}, {:?}, {:?}, {:?}, {:?});",
                    target,
                    index,
                    buffer,
                    offset,
                    size
                );
            }
            let out = call_atomic_ptr_5arg(
                "glBindBufferRange",
                &self.glBindBufferRange_p,
                target,
                index,
                buffer,
                offset,
                size,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindBufferRange");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindBufferRange_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindBufferRange\0",
                &self.glBindBufferRange_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindBufferRange_is_loaded(&self) -> bool {
            !self.glBindBufferRange_p.load(RELAX).is_null()
        }
        /// [glBindBuffersBase](http://docs.gl/gl4/glBindBuffersBase)(target, first, count, buffers)
        /// * `target` group: BufferTargetARB
        /// * `buffers` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindBuffersBase(
            &self,
            target: GLenum,
            first: GLuint,
            count: GLsizei,
            buffers: *const GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindBuffersBase({:#X}, {:?}, {:?}, {:p});",
                    target,
                    first,
                    count,
                    buffers
                );
            }
            let out = call_atomic_ptr_4arg(
                "glBindBuffersBase",
                &self.glBindBuffersBase_p,
                target,
                first,
                count,
                buffers,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindBuffersBase");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindBuffersBase_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindBuffersBase\0",
                &self.glBindBuffersBase_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindBuffersBase_is_loaded(&self) -> bool {
            !self.glBindBuffersBase_p.load(RELAX).is_null()
        }
        /// [glBindBuffersRange](http://docs.gl/gl4/glBindBuffersRange)(target, first, count, buffers, offsets, sizes)
        /// * `target` group: BufferTargetARB
        /// * `buffers` len: count
        /// * `offsets` len: count
        /// * `sizes` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindBuffersRange(
            &self,
            target: GLenum,
            first: GLuint,
            count: GLsizei,
            buffers: *const GLuint,
            offsets: *const GLintptr,
            sizes: *const GLsizeiptr,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindBuffersRange({:#X}, {:?}, {:?}, {:p}, {:p}, {:p});",
                    target,
                    first,
                    count,
                    buffers,
                    offsets,
                    sizes
                );
            }
            let out = call_atomic_ptr_6arg(
                "glBindBuffersRange",
                &self.glBindBuffersRange_p,
                target,
                first,
                count,
                buffers,
                offsets,
                sizes,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindBuffersRange");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindBuffersRange_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindBuffersRange\0",
                &self.glBindBuffersRange_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindBuffersRange_is_loaded(&self) -> bool {
            !self.glBindBuffersRange_p.load(RELAX).is_null()
        }
        /// [glBindFragDataLocation](http://docs.gl/gl4/glBindFragDataLocation)(program, color, name)
        /// * `name` len: COMPSIZE(name)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindFragDataLocation(
            &self,
            program: GLuint,
            color: GLuint,
            name: *const GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindFragDataLocation({:?}, {:?}, {:p});",
                    program,
                    color,
                    name
                );
            }
            let out = call_atomic_ptr_3arg(
                "glBindFragDataLocation",
                &self.glBindFragDataLocation_p,
                program,
                color,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindFragDataLocation");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindFragDataLocation_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindFragDataLocation\0",
                &self.glBindFragDataLocation_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindFragDataLocation_is_loaded(&self) -> bool {
            !self.glBindFragDataLocation_p.load(RELAX).is_null()
        }
        /// [glBindFragDataLocationIndexed](http://docs.gl/gl4/glBindFragDataLocationIndexed)(program, colorNumber, index, name)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindFragDataLocationIndexed(
            &self,
            program: GLuint,
            colorNumber: GLuint,
            index: GLuint,
            name: *const GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindFragDataLocationIndexed({:?}, {:?}, {:?}, {:p});",
                    program,
                    colorNumber,
                    index,
                    name
                );
            }
            let out = call_atomic_ptr_4arg(
                "glBindFragDataLocationIndexed",
                &self.glBindFragDataLocationIndexed_p,
                program,
                colorNumber,
                index,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindFragDataLocationIndexed");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindFragDataLocationIndexed_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindFragDataLocationIndexed\0",
                &self.glBindFragDataLocationIndexed_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindFragDataLocationIndexed_is_loaded(&self) -> bool {
            !self.glBindFragDataLocationIndexed_p.load(RELAX).is_null()
        }
        /// [glBindFramebuffer](http://docs.gl/gl4/glBindFramebuffer)(target, framebuffer)
        /// * `target` group: FramebufferTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindFramebuffer(&self, target: GLenum, framebuffer: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindFramebuffer({:#X}, {:?});",
                    target,
                    framebuffer
                );
            }
            let out = call_atomic_ptr_2arg(
                "glBindFramebuffer",
                &self.glBindFramebuffer_p,
                target,
                framebuffer,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindFramebuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindFramebuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindFramebuffer\0",
                &self.glBindFramebuffer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindFramebuffer_is_loaded(&self) -> bool {
            !self.glBindFramebuffer_p.load(RELAX).is_null()
        }
        /// [glBindImageTexture](http://docs.gl/gl4/glBindImageTexture)(unit, texture, level, layered, layer, access, format)
        /// * `access` group: BufferAccessARB
        /// * `format` group: InternalFormat
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindImageTexture(
            &self,
            unit: GLuint,
            texture: GLuint,
            level: GLint,
            layered: GLboolean,
            layer: GLint,
            access: GLenum,
            format: GLenum,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindImageTexture({:?}, {:?}, {:?}, {:?}, {:?}, {:#X}, {:#X});",
                    unit,
                    texture,
                    level,
                    layered,
                    layer,
                    access,
                    format
                );
            }
            let out = call_atomic_ptr_7arg(
                "glBindImageTexture",
                &self.glBindImageTexture_p,
                unit,
                texture,
                level,
                layered,
                layer,
                access,
                format,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindImageTexture");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindImageTexture_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindImageTexture\0",
                &self.glBindImageTexture_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindImageTexture_is_loaded(&self) -> bool {
            !self.glBindImageTexture_p.load(RELAX).is_null()
        }
        /// [glBindImageTextures](http://docs.gl/gl4/glBindImageTextures)(first, count, textures)
        /// * `textures` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindImageTextures(
            &self,
            first: GLuint,
            count: GLsizei,
            textures: *const GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindImageTextures({:?}, {:?}, {:p});",
                    first,
                    count,
                    textures
                );
            }
            let out = call_atomic_ptr_3arg(
                "glBindImageTextures",
                &self.glBindImageTextures_p,
                first,
                count,
                textures,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindImageTextures");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindImageTextures_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindImageTextures\0",
                &self.glBindImageTextures_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindImageTextures_is_loaded(&self) -> bool {
            !self.glBindImageTextures_p.load(RELAX).is_null()
        }
        /// [glBindProgramPipeline](http://docs.gl/gl4/glBindProgramPipeline)(pipeline)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindProgramPipeline(&self, pipeline: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BindProgramPipeline({:?});", pipeline);
            }
            let out = call_atomic_ptr_1arg(
                "glBindProgramPipeline",
                &self.glBindProgramPipeline_p,
                pipeline,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindProgramPipeline");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindProgramPipeline_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindProgramPipeline\0",
                &self.glBindProgramPipeline_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindProgramPipeline_is_loaded(&self) -> bool {
            !self.glBindProgramPipeline_p.load(RELAX).is_null()
        }
        /// [glBindRenderbuffer](http://docs.gl/gl4/glBindRenderbuffer)(target, renderbuffer)
        /// * `target` group: RenderbufferTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindRenderbuffer(&self, target: GLenum, renderbuffer: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindRenderbuffer({:#X}, {:?});",
                    target,
                    renderbuffer
                );
            }
            let out = call_atomic_ptr_2arg(
                "glBindRenderbuffer",
                &self.glBindRenderbuffer_p,
                target,
                renderbuffer,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindRenderbuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindRenderbuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindRenderbuffer\0",
                &self.glBindRenderbuffer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindRenderbuffer_is_loaded(&self) -> bool {
            !self.glBindRenderbuffer_p.load(RELAX).is_null()
        }
        /// [glBindSampler](http://docs.gl/gl4/glBindSampler)(unit, sampler)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindSampler(&self, unit: GLuint, sampler: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BindSampler({:?}, {:?});", unit, sampler);
            }
            let out = call_atomic_ptr_2arg("glBindSampler", &self.glBindSampler_p, unit, sampler);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindSampler");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindSampler_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glBindSampler\0", &self.glBindSampler_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindSampler_is_loaded(&self) -> bool {
            !self.glBindSampler_p.load(RELAX).is_null()
        }
        /// [glBindSamplers](http://docs.gl/gl4/glBindSamplers)(first, count, samplers)
        /// * `samplers` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindSamplers(&self, first: GLuint, count: GLsizei, samplers: *const GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindSamplers({:?}, {:?}, {:p});",
                    first,
                    count,
                    samplers
                );
            }
            let out = call_atomic_ptr_3arg(
                "glBindSamplers",
                &self.glBindSamplers_p,
                first,
                count,
                samplers,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindSamplers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindSamplers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindSamplers\0",
                &self.glBindSamplers_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindSamplers_is_loaded(&self) -> bool {
            !self.glBindSamplers_p.load(RELAX).is_null()
        }
        /// [glBindTexture](http://docs.gl/gl4/glBindTexture)(target, texture)
        /// * `target` group: TextureTarget
        /// * `texture` group: Texture
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindTexture(&self, target: GLenum, texture: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BindTexture({:#X}, {:?});", target, texture);
            }
            let out = call_atomic_ptr_2arg("glBindTexture", &self.glBindTexture_p, target, texture);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindTexture");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindTexture_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glBindTexture\0", &self.glBindTexture_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindTexture_is_loaded(&self) -> bool {
            !self.glBindTexture_p.load(RELAX).is_null()
        }
        /// [glBindTextureUnit](http://docs.gl/gl4/glBindTextureUnit)(unit, texture)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindTextureUnit(&self, unit: GLuint, texture: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BindTextureUnit({:?}, {:?});", unit, texture);
            }
            let out = call_atomic_ptr_2arg(
                "glBindTextureUnit",
                &self.glBindTextureUnit_p,
                unit,
                texture,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindTextureUnit");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindTextureUnit_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindTextureUnit\0",
                &self.glBindTextureUnit_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindTextureUnit_is_loaded(&self) -> bool {
            !self.glBindTextureUnit_p.load(RELAX).is_null()
        }
        /// [glBindTextures](http://docs.gl/gl4/glBindTextures)(first, count, textures)
        /// * `textures` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindTextures(&self, first: GLuint, count: GLsizei, textures: *const GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindTextures({:?}, {:?}, {:p});",
                    first,
                    count,
                    textures
                );
            }
            let out = call_atomic_ptr_3arg(
                "glBindTextures",
                &self.glBindTextures_p,
                first,
                count,
                textures,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindTextures");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindTextures_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindTextures\0",
                &self.glBindTextures_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindTextures_is_loaded(&self) -> bool {
            !self.glBindTextures_p.load(RELAX).is_null()
        }
        /// [glBindTransformFeedback](http://docs.gl/gl4/glBindTransformFeedback)(target, id)
        /// * `target` group: BindTransformFeedbackTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindTransformFeedback(&self, target: GLenum, id: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BindTransformFeedback({:#X}, {:?});", target, id);
            }
            let out = call_atomic_ptr_2arg(
                "glBindTransformFeedback",
                &self.glBindTransformFeedback_p,
                target,
                id,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindTransformFeedback");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindTransformFeedback_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindTransformFeedback\0",
                &self.glBindTransformFeedback_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindTransformFeedback_is_loaded(&self) -> bool {
            !self.glBindTransformFeedback_p.load(RELAX).is_null()
        }
        /// [glBindVertexArray](http://docs.gl/gl4/glBindVertexArray)(array)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindVertexArray(&self, array: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BindVertexArray({:?});", array);
            }
            let out = call_atomic_ptr_1arg("glBindVertexArray", &self.glBindVertexArray_p, array);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindVertexArray");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindVertexArray_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindVertexArray\0",
                &self.glBindVertexArray_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindVertexArray_is_loaded(&self) -> bool {
            !self.glBindVertexArray_p.load(RELAX).is_null()
        }
        /// [glBindVertexBuffer](http://docs.gl/gl4/glBindVertexBuffer)(bindingindex, buffer, offset, stride)
        /// * `offset` group: BufferOffset
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindVertexBuffer(
            &self,
            bindingindex: GLuint,
            buffer: GLuint,
            offset: GLintptr,
            stride: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindVertexBuffer({:?}, {:?}, {:?}, {:?});",
                    bindingindex,
                    buffer,
                    offset,
                    stride
                );
            }
            let out = call_atomic_ptr_4arg(
                "glBindVertexBuffer",
                &self.glBindVertexBuffer_p,
                bindingindex,
                buffer,
                offset,
                stride,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindVertexBuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindVertexBuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindVertexBuffer\0",
                &self.glBindVertexBuffer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindVertexBuffer_is_loaded(&self) -> bool {
            !self.glBindVertexBuffer_p.load(RELAX).is_null()
        }
        /// [glBindVertexBuffers](http://docs.gl/gl4/glBindVertexBuffers)(first, count, buffers, offsets, strides)
        /// * `buffers` len: count
        /// * `offsets` len: count
        /// * `strides` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BindVertexBuffers(
            &self,
            first: GLuint,
            count: GLsizei,
            buffers: *const GLuint,
            offsets: *const GLintptr,
            strides: *const GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BindVertexBuffers({:?}, {:?}, {:p}, {:p}, {:p});",
                    first,
                    count,
                    buffers,
                    offsets,
                    strides
                );
            }
            let out = call_atomic_ptr_5arg(
                "glBindVertexBuffers",
                &self.glBindVertexBuffers_p,
                first,
                count,
                buffers,
                offsets,
                strides,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBindVertexBuffers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BindVertexBuffers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBindVertexBuffers\0",
                &self.glBindVertexBuffers_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BindVertexBuffers_is_loaded(&self) -> bool {
            !self.glBindVertexBuffers_p.load(RELAX).is_null()
        }
        /// [glBlendBarrier](http://docs.gl/gl4/glBlendBarrier)()
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BlendBarrier(&self) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BlendBarrier();",);
            }
            let out = call_atomic_ptr_0arg("glBlendBarrier", &self.glBlendBarrier_p);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBlendBarrier");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BlendBarrier_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBlendBarrier\0",
                &self.glBlendBarrier_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BlendBarrier_is_loaded(&self) -> bool {
            !self.glBlendBarrier_p.load(RELAX).is_null()
        }
        /// [glBlendColor](http://docs.gl/gl4/glBlendColor)(red, green, blue, alpha)
        /// * `red` group: ColorF
        /// * `green` group: ColorF
        /// * `blue` group: ColorF
        /// * `alpha` group: ColorF
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BlendColor(
            &self,
            red: GLfloat,
            green: GLfloat,
            blue: GLfloat,
            alpha: GLfloat,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BlendColor({:?}, {:?}, {:?}, {:?});",
                    red,
                    green,
                    blue,
                    alpha
                );
            }
            let out = call_atomic_ptr_4arg(
                "glBlendColor",
                &self.glBlendColor_p,
                red,
                green,
                blue,
                alpha,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBlendColor");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BlendColor_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glBlendColor\0", &self.glBlendColor_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn BlendColor_is_loaded(&self) -> bool {
            !self.glBlendColor_p.load(RELAX).is_null()
        }
        /// [glBlendEquation](http://docs.gl/gl4/glBlendEquation)(mode)
        /// * `mode` group: BlendEquationModeEXT
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BlendEquation(&self, mode: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BlendEquation({:#X});", mode);
            }
            let out = call_atomic_ptr_1arg("glBlendEquation", &self.glBlendEquation_p, mode);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBlendEquation");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BlendEquation_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBlendEquation\0",
                &self.glBlendEquation_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BlendEquation_is_loaded(&self) -> bool {
            !self.glBlendEquation_p.load(RELAX).is_null()
        }
        /// [glBlendEquationSeparate](http://docs.gl/gl4/glBlendEquationSeparate)(modeRGB, modeAlpha)
        /// * `modeRGB` group: BlendEquationModeEXT
        /// * `modeAlpha` group: BlendEquationModeEXT
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BlendEquationSeparate(&self, modeRGB: GLenum, modeAlpha: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BlendEquationSeparate({:#X}, {:#X});",
                    modeRGB,
                    modeAlpha
                );
            }
            let out = call_atomic_ptr_2arg(
                "glBlendEquationSeparate",
                &self.glBlendEquationSeparate_p,
                modeRGB,
                modeAlpha,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBlendEquationSeparate");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BlendEquationSeparate_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBlendEquationSeparate\0",
                &self.glBlendEquationSeparate_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BlendEquationSeparate_is_loaded(&self) -> bool {
            !self.glBlendEquationSeparate_p.load(RELAX).is_null()
        }
        /// [glBlendEquationSeparatei](http://docs.gl/gl4/glBlendEquationSeparate)(buf, modeRGB, modeAlpha)
        /// * `modeRGB` group: BlendEquationModeEXT
        /// * `modeAlpha` group: BlendEquationModeEXT
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BlendEquationSeparatei(
            &self,
            buf: GLuint,
            modeRGB: GLenum,
            modeAlpha: GLenum,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BlendEquationSeparatei({:?}, {:#X}, {:#X});",
                    buf,
                    modeRGB,
                    modeAlpha
                );
            }
            let out = call_atomic_ptr_3arg(
                "glBlendEquationSeparatei",
                &self.glBlendEquationSeparatei_p,
                buf,
                modeRGB,
                modeAlpha,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBlendEquationSeparatei");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BlendEquationSeparatei_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBlendEquationSeparatei\0",
                &self.glBlendEquationSeparatei_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BlendEquationSeparatei_is_loaded(&self) -> bool {
            !self.glBlendEquationSeparatei_p.load(RELAX).is_null()
        }
        /// [glBlendEquationi](http://docs.gl/gl4/glBlendEquation)(buf, mode)
        /// * `mode` group: BlendEquationModeEXT
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BlendEquationi(&self, buf: GLuint, mode: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BlendEquationi({:?}, {:#X});", buf, mode);
            }
            let out = call_atomic_ptr_2arg("glBlendEquationi", &self.glBlendEquationi_p, buf, mode);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBlendEquationi");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BlendEquationi_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBlendEquationi\0",
                &self.glBlendEquationi_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BlendEquationi_is_loaded(&self) -> bool {
            !self.glBlendEquationi_p.load(RELAX).is_null()
        }
        /// [glBlendFunc](http://docs.gl/gl4/glBlendFunc)(sfactor, dfactor)
        /// * `sfactor` group: BlendingFactor
        /// * `dfactor` group: BlendingFactor
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BlendFunc(&self, sfactor: GLenum, dfactor: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BlendFunc({:#X}, {:#X});", sfactor, dfactor);
            }
            let out = call_atomic_ptr_2arg("glBlendFunc", &self.glBlendFunc_p, sfactor, dfactor);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBlendFunc");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BlendFunc_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glBlendFunc\0", &self.glBlendFunc_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn BlendFunc_is_loaded(&self) -> bool {
            !self.glBlendFunc_p.load(RELAX).is_null()
        }
        /// [glBlendFuncSeparate](http://docs.gl/gl4/glBlendFuncSeparate)(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha)
        /// * `sfactorRGB` group: BlendingFactor
        /// * `dfactorRGB` group: BlendingFactor
        /// * `sfactorAlpha` group: BlendingFactor
        /// * `dfactorAlpha` group: BlendingFactor
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BlendFuncSeparate(
            &self,
            sfactorRGB: GLenum,
            dfactorRGB: GLenum,
            sfactorAlpha: GLenum,
            dfactorAlpha: GLenum,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BlendFuncSeparate({:#X}, {:#X}, {:#X}, {:#X});",
                    sfactorRGB,
                    dfactorRGB,
                    sfactorAlpha,
                    dfactorAlpha
                );
            }
            let out = call_atomic_ptr_4arg(
                "glBlendFuncSeparate",
                &self.glBlendFuncSeparate_p,
                sfactorRGB,
                dfactorRGB,
                sfactorAlpha,
                dfactorAlpha,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBlendFuncSeparate");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BlendFuncSeparate_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBlendFuncSeparate\0",
                &self.glBlendFuncSeparate_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BlendFuncSeparate_is_loaded(&self) -> bool {
            !self.glBlendFuncSeparate_p.load(RELAX).is_null()
        }
        /// [glBlendFuncSeparatei](http://docs.gl/gl4/glBlendFuncSeparate)(buf, srcRGB, dstRGB, srcAlpha, dstAlpha)
        /// * `srcRGB` group: BlendingFactor
        /// * `dstRGB` group: BlendingFactor
        /// * `srcAlpha` group: BlendingFactor
        /// * `dstAlpha` group: BlendingFactor
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BlendFuncSeparatei(
            &self,
            buf: GLuint,
            srcRGB: GLenum,
            dstRGB: GLenum,
            srcAlpha: GLenum,
            dstAlpha: GLenum,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BlendFuncSeparatei({:?}, {:#X}, {:#X}, {:#X}, {:#X});",
                    buf,
                    srcRGB,
                    dstRGB,
                    srcAlpha,
                    dstAlpha
                );
            }
            let out = call_atomic_ptr_5arg(
                "glBlendFuncSeparatei",
                &self.glBlendFuncSeparatei_p,
                buf,
                srcRGB,
                dstRGB,
                srcAlpha,
                dstAlpha,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBlendFuncSeparatei");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BlendFuncSeparatei_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBlendFuncSeparatei\0",
                &self.glBlendFuncSeparatei_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BlendFuncSeparatei_is_loaded(&self) -> bool {
            !self.glBlendFuncSeparatei_p.load(RELAX).is_null()
        }
        /// [glBlendFunci](http://docs.gl/gl4/glBlendFunc)(buf, src, dst)
        /// * `src` group: BlendingFactor
        /// * `dst` group: BlendingFactor
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BlendFunci(&self, buf: GLuint, src: GLenum, dst: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BlendFunci({:?}, {:#X}, {:#X});", buf, src, dst);
            }
            let out = call_atomic_ptr_3arg("glBlendFunci", &self.glBlendFunci_p, buf, src, dst);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBlendFunci");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BlendFunci_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glBlendFunci\0", &self.glBlendFunci_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn BlendFunci_is_loaded(&self) -> bool {
            !self.glBlendFunci_p.load(RELAX).is_null()
        }
        /// [glBlitFramebuffer](http://docs.gl/gl4/glBlitFramebuffer)(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter)
        /// * `mask` group: ClearBufferMask
        /// * `filter` group: BlitFramebufferFilter
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BlitFramebuffer(
            &self,
            srcX0: GLint,
            srcY0: GLint,
            srcX1: GLint,
            srcY1: GLint,
            dstX0: GLint,
            dstY0: GLint,
            dstX1: GLint,
            dstY1: GLint,
            mask: GLbitfield,
            filter: GLenum,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BlitFramebuffer({:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:#X});", srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
            }
            let out = call_atomic_ptr_10arg(
                "glBlitFramebuffer",
                &self.glBlitFramebuffer_p,
                srcX0,
                srcY0,
                srcX1,
                srcY1,
                dstX0,
                dstY0,
                dstX1,
                dstY1,
                mask,
                filter,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBlitFramebuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BlitFramebuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBlitFramebuffer\0",
                &self.glBlitFramebuffer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BlitFramebuffer_is_loaded(&self) -> bool {
            !self.glBlitFramebuffer_p.load(RELAX).is_null()
        }
        /// [glBlitNamedFramebuffer](http://docs.gl/gl4/glBlitNamedFramebuffer)(readFramebuffer, drawFramebuffer, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter)
        /// * `mask` group: ClearBufferMask
        /// * `filter` group: BlitFramebufferFilter
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BlitNamedFramebuffer(
            &self,
            readFramebuffer: GLuint,
            drawFramebuffer: GLuint,
            srcX0: GLint,
            srcY0: GLint,
            srcX1: GLint,
            srcY1: GLint,
            dstX0: GLint,
            dstY0: GLint,
            dstX1: GLint,
            dstY1: GLint,
            mask: GLbitfield,
            filter: GLenum,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.BlitNamedFramebuffer({:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:#X});", readFramebuffer, drawFramebuffer, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
            }
            let out = call_atomic_ptr_12arg(
                "glBlitNamedFramebuffer",
                &self.glBlitNamedFramebuffer_p,
                readFramebuffer,
                drawFramebuffer,
                srcX0,
                srcY0,
                srcX1,
                srcY1,
                dstX0,
                dstY0,
                dstX1,
                dstY1,
                mask,
                filter,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBlitNamedFramebuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BlitNamedFramebuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBlitNamedFramebuffer\0",
                &self.glBlitNamedFramebuffer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BlitNamedFramebuffer_is_loaded(&self) -> bool {
            !self.glBlitNamedFramebuffer_p.load(RELAX).is_null()
        }
        /// [glBufferData](http://docs.gl/gl4/glBufferData)(target, size, data, usage)
        /// * `target` group: BufferTargetARB
        /// * `size` group: BufferSize
        /// * `data` len: size
        /// * `usage` group: BufferUsageARB
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BufferData(
            &self,
            target: GLenum,
            size: GLsizeiptr,
            data: *const c_void,
            usage: GLenum,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BufferData({:#X}, {:?}, {:p}, {:#X});",
                    target,
                    size,
                    data,
                    usage
                );
            }
            let out = call_atomic_ptr_4arg(
                "glBufferData",
                &self.glBufferData_p,
                target,
                size,
                data,
                usage,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBufferData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BufferData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glBufferData\0", &self.glBufferData_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn BufferData_is_loaded(&self) -> bool {
            !self.glBufferData_p.load(RELAX).is_null()
        }
        /// [glBufferStorage](http://docs.gl/gl4/glBufferStorage)(target, size, data, flags)
        /// * `target` group: BufferStorageTarget
        /// * `data` len: size
        /// * `flags` group: BufferStorageMask
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BufferStorage(
            &self,
            target: GLenum,
            size: GLsizeiptr,
            data: *const c_void,
            flags: GLbitfield,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BufferStorage({:#X}, {:?}, {:p}, {:?});",
                    target,
                    size,
                    data,
                    flags
                );
            }
            let out = call_atomic_ptr_4arg(
                "glBufferStorage",
                &self.glBufferStorage_p,
                target,
                size,
                data,
                flags,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBufferStorage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BufferStorage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBufferStorage\0",
                &self.glBufferStorage_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BufferStorage_is_loaded(&self) -> bool {
            !self.glBufferStorage_p.load(RELAX).is_null()
        }
        /// [glBufferStorageEXT](http://docs.gl/gl4/glBufferStorageEXT)(target, size, data, flags)
        /// * `target` group: BufferStorageTarget
        /// * `data` len: size
        /// * `flags` group: BufferStorageMask
        /// * alias of: [`glBufferStorage`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BufferStorageEXT(
            &self,
            target: GLenum,
            size: GLsizeiptr,
            data: *const c_void,
            flags: GLbitfield,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BufferStorageEXT({:#X}, {:?}, {:p}, {:?});",
                    target,
                    size,
                    data,
                    flags
                );
            }
            let out = call_atomic_ptr_4arg(
                "glBufferStorageEXT",
                &self.glBufferStorageEXT_p,
                target,
                size,
                data,
                flags,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBufferStorageEXT");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BufferStorageEXT_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBufferStorageEXT\0",
                &self.glBufferStorageEXT_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BufferStorageEXT_is_loaded(&self) -> bool {
            !self.glBufferStorageEXT_p.load(RELAX).is_null()
        }
        /// [glBufferSubData](http://docs.gl/gl4/glBufferSubData)(target, offset, size, data)
        /// * `target` group: BufferTargetARB
        /// * `offset` group: BufferOffset
        /// * `size` group: BufferSize
        /// * `data` len: size
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn BufferSubData(
            &self,
            target: GLenum,
            offset: GLintptr,
            size: GLsizeiptr,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.BufferSubData({:#X}, {:?}, {:?}, {:p});",
                    target,
                    offset,
                    size,
                    data
                );
            }
            let out = call_atomic_ptr_4arg(
                "glBufferSubData",
                &self.glBufferSubData_p,
                target,
                offset,
                size,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glBufferSubData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn BufferSubData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glBufferSubData\0",
                &self.glBufferSubData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn BufferSubData_is_loaded(&self) -> bool {
            !self.glBufferSubData_p.load(RELAX).is_null()
        }
        /// [glCheckFramebufferStatus](http://docs.gl/gl4/glCheckFramebufferStatus)(target)
        /// * `target` group: FramebufferTarget
        /// * return value group: FramebufferStatus
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CheckFramebufferStatus(&self, target: GLenum) -> GLenum {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CheckFramebufferStatus({:#X});", target);
            }
            let out = call_atomic_ptr_1arg(
                "glCheckFramebufferStatus",
                &self.glCheckFramebufferStatus_p,
                target,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCheckFramebufferStatus");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CheckFramebufferStatus_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCheckFramebufferStatus\0",
                &self.glCheckFramebufferStatus_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CheckFramebufferStatus_is_loaded(&self) -> bool {
            !self.glCheckFramebufferStatus_p.load(RELAX).is_null()
        }
        /// [glCheckNamedFramebufferStatus](http://docs.gl/gl4/glCheckNamedFramebufferStatus)(framebuffer, target)
        /// * `target` group: FramebufferTarget
        /// * return value group: FramebufferStatus
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CheckNamedFramebufferStatus(
            &self,
            framebuffer: GLuint,
            target: GLenum,
        ) -> GLenum {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CheckNamedFramebufferStatus({:?}, {:#X});",
                    framebuffer,
                    target
                );
            }
            let out = call_atomic_ptr_2arg(
                "glCheckNamedFramebufferStatus",
                &self.glCheckNamedFramebufferStatus_p,
                framebuffer,
                target,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCheckNamedFramebufferStatus");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CheckNamedFramebufferStatus_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCheckNamedFramebufferStatus\0",
                &self.glCheckNamedFramebufferStatus_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CheckNamedFramebufferStatus_is_loaded(&self) -> bool {
            !self.glCheckNamedFramebufferStatus_p.load(RELAX).is_null()
        }
        /// [glClampColor](http://docs.gl/gl4/glClampColor)(target, clamp)
        /// * `target` group: ClampColorTargetARB
        /// * `clamp` group: ClampColorModeARB
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClampColor(&self, target: GLenum, clamp: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.ClampColor({:#X}, {:#X});", target, clamp);
            }
            let out = call_atomic_ptr_2arg("glClampColor", &self.glClampColor_p, target, clamp);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClampColor");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClampColor_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glClampColor\0", &self.glClampColor_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClampColor_is_loaded(&self) -> bool {
            !self.glClampColor_p.load(RELAX).is_null()
        }
        /// [glClear](http://docs.gl/gl4/glClear)(mask)
        /// * `mask` group: ClearBufferMask
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn Clear(&self, mask: GLbitfield) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.Clear({:?});", mask);
            }
            let out = call_atomic_ptr_1arg("glClear", &self.glClear_p, mask);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClear");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn Clear_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glClear\0", &self.glClear_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn Clear_is_loaded(&self) -> bool {
            !self.glClear_p.load(RELAX).is_null()
        }
        /// [glClearBufferData](http://docs.gl/gl4/glClearBufferData)(target, internalformat, format, type_, data)
        /// * `target` group: BufferStorageTarget
        /// * `internalformat` group: InternalFormat
        /// * `format` group: PixelFormat
        /// * `type_` group: PixelType
        /// * `data` len: COMPSIZE(format,type)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearBufferData(
            &self,
            target: GLenum,
            internalformat: GLenum,
            format: GLenum,
            type_: GLenum,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ClearBufferData({:#X}, {:#X}, {:#X}, {:#X}, {:p});",
                    target,
                    internalformat,
                    format,
                    type_,
                    data
                );
            }
            let out = call_atomic_ptr_5arg(
                "glClearBufferData",
                &self.glClearBufferData_p,
                target,
                internalformat,
                format,
                type_,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearBufferData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearBufferData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearBufferData\0",
                &self.glClearBufferData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearBufferData_is_loaded(&self) -> bool {
            !self.glClearBufferData_p.load(RELAX).is_null()
        }
        /// [glClearBufferSubData](http://docs.gl/gl4/glClearBufferSubData)(target, internalformat, offset, size, format, type_, data)
        /// * `target` group: BufferTargetARB
        /// * `internalformat` group: InternalFormat
        /// * `offset` group: BufferOffset
        /// * `size` group: BufferSize
        /// * `format` group: PixelFormat
        /// * `type_` group: PixelType
        /// * `data` len: COMPSIZE(format,type)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearBufferSubData(
            &self,
            target: GLenum,
            internalformat: GLenum,
            offset: GLintptr,
            size: GLsizeiptr,
            format: GLenum,
            type_: GLenum,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ClearBufferSubData({:#X}, {:#X}, {:?}, {:?}, {:#X}, {:#X}, {:p});",
                    target,
                    internalformat,
                    offset,
                    size,
                    format,
                    type_,
                    data
                );
            }
            let out = call_atomic_ptr_7arg(
                "glClearBufferSubData",
                &self.glClearBufferSubData_p,
                target,
                internalformat,
                offset,
                size,
                format,
                type_,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearBufferSubData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearBufferSubData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearBufferSubData\0",
                &self.glClearBufferSubData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearBufferSubData_is_loaded(&self) -> bool {
            !self.glClearBufferSubData_p.load(RELAX).is_null()
        }
        /// [glClearBufferfi](http://docs.gl/gl4/glClearBuffer)(buffer, drawbuffer, depth, stencil)
        /// * `buffer` group: Buffer
        /// * `drawbuffer` group: DrawBufferName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearBufferfi(
            &self,
            buffer: GLenum,
            drawbuffer: GLint,
            depth: GLfloat,
            stencil: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ClearBufferfi({:#X}, {:?}, {:?}, {:?});",
                    buffer,
                    drawbuffer,
                    depth,
                    stencil
                );
            }
            let out = call_atomic_ptr_4arg(
                "glClearBufferfi",
                &self.glClearBufferfi_p,
                buffer,
                drawbuffer,
                depth,
                stencil,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearBufferfi");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearBufferfi_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearBufferfi\0",
                &self.glClearBufferfi_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearBufferfi_is_loaded(&self) -> bool {
            !self.glClearBufferfi_p.load(RELAX).is_null()
        }
        /// [glClearBufferfv](http://docs.gl/gl4/glClearBuffer)(buffer, drawbuffer, value)
        /// * `buffer` group: Buffer
        /// * `drawbuffer` group: DrawBufferName
        /// * `value` len: COMPSIZE(buffer)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearBufferfv(
            &self,
            buffer: GLenum,
            drawbuffer: GLint,
            value: *const GLfloat,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ClearBufferfv({:#X}, {:?}, {:p});",
                    buffer,
                    drawbuffer,
                    value
                );
            }
            let out = call_atomic_ptr_3arg(
                "glClearBufferfv",
                &self.glClearBufferfv_p,
                buffer,
                drawbuffer,
                value,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearBufferfv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearBufferfv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearBufferfv\0",
                &self.glClearBufferfv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearBufferfv_is_loaded(&self) -> bool {
            !self.glClearBufferfv_p.load(RELAX).is_null()
        }
        /// [glClearBufferiv](http://docs.gl/gl4/glClearBuffer)(buffer, drawbuffer, value)
        /// * `buffer` group: Buffer
        /// * `drawbuffer` group: DrawBufferName
        /// * `value` len: COMPSIZE(buffer)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearBufferiv(&self, buffer: GLenum, drawbuffer: GLint, value: *const GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ClearBufferiv({:#X}, {:?}, {:p});",
                    buffer,
                    drawbuffer,
                    value
                );
            }
            let out = call_atomic_ptr_3arg(
                "glClearBufferiv",
                &self.glClearBufferiv_p,
                buffer,
                drawbuffer,
                value,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearBufferiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearBufferiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearBufferiv\0",
                &self.glClearBufferiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearBufferiv_is_loaded(&self) -> bool {
            !self.glClearBufferiv_p.load(RELAX).is_null()
        }
        /// [glClearBufferuiv](http://docs.gl/gl4/glClearBuffer)(buffer, drawbuffer, value)
        /// * `buffer` group: Buffer
        /// * `drawbuffer` group: DrawBufferName
        /// * `value` len: COMPSIZE(buffer)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearBufferuiv(
            &self,
            buffer: GLenum,
            drawbuffer: GLint,
            value: *const GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ClearBufferuiv({:#X}, {:?}, {:p});",
                    buffer,
                    drawbuffer,
                    value
                );
            }
            let out = call_atomic_ptr_3arg(
                "glClearBufferuiv",
                &self.glClearBufferuiv_p,
                buffer,
                drawbuffer,
                value,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearBufferuiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearBufferuiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearBufferuiv\0",
                &self.glClearBufferuiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearBufferuiv_is_loaded(&self) -> bool {
            !self.glClearBufferuiv_p.load(RELAX).is_null()
        }
        /// [glClearColor](http://docs.gl/gl4/glClearColor)(red, green, blue, alpha)
        /// * `red` group: ColorF
        /// * `green` group: ColorF
        /// * `blue` group: ColorF
        /// * `alpha` group: ColorF
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearColor(
            &self,
            red: GLfloat,
            green: GLfloat,
            blue: GLfloat,
            alpha: GLfloat,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ClearColor({:?}, {:?}, {:?}, {:?});",
                    red,
                    green,
                    blue,
                    alpha
                );
            }
            let out = call_atomic_ptr_4arg(
                "glClearColor",
                &self.glClearColor_p,
                red,
                green,
                blue,
                alpha,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearColor");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearColor_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glClearColor\0", &self.glClearColor_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearColor_is_loaded(&self) -> bool {
            !self.glClearColor_p.load(RELAX).is_null()
        }
        /// [glClearDepth](http://docs.gl/gl4/glClearDepth)(depth)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearDepth(&self, depth: GLdouble) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.ClearDepth({:?});", depth);
            }
            let out = call_atomic_ptr_1arg("glClearDepth", &self.glClearDepth_p, depth);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearDepth");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearDepth_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glClearDepth\0", &self.glClearDepth_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearDepth_is_loaded(&self) -> bool {
            !self.glClearDepth_p.load(RELAX).is_null()
        }
        /// [glClearDepthf](http://docs.gl/gl4/glClearDepth)(d)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearDepthf(&self, d: GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.ClearDepthf({:?});", d);
            }
            let out = call_atomic_ptr_1arg("glClearDepthf", &self.glClearDepthf_p, d);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearDepthf");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearDepthf_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glClearDepthf\0", &self.glClearDepthf_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearDepthf_is_loaded(&self) -> bool {
            !self.glClearDepthf_p.load(RELAX).is_null()
        }
        /// [glClearNamedBufferData](http://docs.gl/gl4/glClearNamedBufferData)(buffer, internalformat, format, type_, data)
        /// * `internalformat` group: InternalFormat
        /// * `format` group: PixelFormat
        /// * `type_` group: PixelType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearNamedBufferData(
            &self,
            buffer: GLuint,
            internalformat: GLenum,
            format: GLenum,
            type_: GLenum,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ClearNamedBufferData({:?}, {:#X}, {:#X}, {:#X}, {:p});",
                    buffer,
                    internalformat,
                    format,
                    type_,
                    data
                );
            }
            let out = call_atomic_ptr_5arg(
                "glClearNamedBufferData",
                &self.glClearNamedBufferData_p,
                buffer,
                internalformat,
                format,
                type_,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearNamedBufferData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearNamedBufferData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearNamedBufferData\0",
                &self.glClearNamedBufferData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearNamedBufferData_is_loaded(&self) -> bool {
            !self.glClearNamedBufferData_p.load(RELAX).is_null()
        }
        /// [glClearNamedBufferSubData](http://docs.gl/gl4/glClearNamedBufferSubData)(buffer, internalformat, offset, size, format, type_, data)
        /// * `internalformat` group: InternalFormat
        /// * `size` group: BufferSize
        /// * `format` group: PixelFormat
        /// * `type_` group: PixelType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearNamedBufferSubData(
            &self,
            buffer: GLuint,
            internalformat: GLenum,
            offset: GLintptr,
            size: GLsizeiptr,
            format: GLenum,
            type_: GLenum,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.ClearNamedBufferSubData({:?}, {:#X}, {:?}, {:?}, {:#X}, {:#X}, {:p});", buffer, internalformat, offset, size, format, type_, data);
            }
            let out = call_atomic_ptr_7arg(
                "glClearNamedBufferSubData",
                &self.glClearNamedBufferSubData_p,
                buffer,
                internalformat,
                offset,
                size,
                format,
                type_,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearNamedBufferSubData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearNamedBufferSubData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearNamedBufferSubData\0",
                &self.glClearNamedBufferSubData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearNamedBufferSubData_is_loaded(&self) -> bool {
            !self.glClearNamedBufferSubData_p.load(RELAX).is_null()
        }
        /// [glClearNamedFramebufferfi](http://docs.gl/gl4/glClearNamedFramebuffer)(framebuffer, buffer, drawbuffer, depth, stencil)
        /// * `buffer` group: Buffer
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearNamedFramebufferfi(
            &self,
            framebuffer: GLuint,
            buffer: GLenum,
            drawbuffer: GLint,
            depth: GLfloat,
            stencil: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ClearNamedFramebufferfi({:?}, {:#X}, {:?}, {:?}, {:?});",
                    framebuffer,
                    buffer,
                    drawbuffer,
                    depth,
                    stencil
                );
            }
            let out = call_atomic_ptr_5arg(
                "glClearNamedFramebufferfi",
                &self.glClearNamedFramebufferfi_p,
                framebuffer,
                buffer,
                drawbuffer,
                depth,
                stencil,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearNamedFramebufferfi");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearNamedFramebufferfi_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearNamedFramebufferfi\0",
                &self.glClearNamedFramebufferfi_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearNamedFramebufferfi_is_loaded(&self) -> bool {
            !self.glClearNamedFramebufferfi_p.load(RELAX).is_null()
        }
        /// [glClearNamedFramebufferfv](http://docs.gl/gl4/glClearNamedFramebuffer)(framebuffer, buffer, drawbuffer, value)
        /// * `buffer` group: Buffer
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearNamedFramebufferfv(
            &self,
            framebuffer: GLuint,
            buffer: GLenum,
            drawbuffer: GLint,
            value: *const GLfloat,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ClearNamedFramebufferfv({:?}, {:#X}, {:?}, {:p});",
                    framebuffer,
                    buffer,
                    drawbuffer,
                    value
                );
            }
            let out = call_atomic_ptr_4arg(
                "glClearNamedFramebufferfv",
                &self.glClearNamedFramebufferfv_p,
                framebuffer,
                buffer,
                drawbuffer,
                value,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearNamedFramebufferfv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearNamedFramebufferfv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearNamedFramebufferfv\0",
                &self.glClearNamedFramebufferfv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearNamedFramebufferfv_is_loaded(&self) -> bool {
            !self.glClearNamedFramebufferfv_p.load(RELAX).is_null()
        }
        /// [glClearNamedFramebufferiv](http://docs.gl/gl4/glClearNamedFramebuffer)(framebuffer, buffer, drawbuffer, value)
        /// * `buffer` group: Buffer
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearNamedFramebufferiv(
            &self,
            framebuffer: GLuint,
            buffer: GLenum,
            drawbuffer: GLint,
            value: *const GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ClearNamedFramebufferiv({:?}, {:#X}, {:?}, {:p});",
                    framebuffer,
                    buffer,
                    drawbuffer,
                    value
                );
            }
            let out = call_atomic_ptr_4arg(
                "glClearNamedFramebufferiv",
                &self.glClearNamedFramebufferiv_p,
                framebuffer,
                buffer,
                drawbuffer,
                value,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearNamedFramebufferiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearNamedFramebufferiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearNamedFramebufferiv\0",
                &self.glClearNamedFramebufferiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearNamedFramebufferiv_is_loaded(&self) -> bool {
            !self.glClearNamedFramebufferiv_p.load(RELAX).is_null()
        }
        /// [glClearNamedFramebufferuiv](http://docs.gl/gl4/glClearNamedFramebuffer)(framebuffer, buffer, drawbuffer, value)
        /// * `buffer` group: Buffer
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearNamedFramebufferuiv(
            &self,
            framebuffer: GLuint,
            buffer: GLenum,
            drawbuffer: GLint,
            value: *const GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ClearNamedFramebufferuiv({:?}, {:#X}, {:?}, {:p});",
                    framebuffer,
                    buffer,
                    drawbuffer,
                    value
                );
            }
            let out = call_atomic_ptr_4arg(
                "glClearNamedFramebufferuiv",
                &self.glClearNamedFramebufferuiv_p,
                framebuffer,
                buffer,
                drawbuffer,
                value,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearNamedFramebufferuiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearNamedFramebufferuiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearNamedFramebufferuiv\0",
                &self.glClearNamedFramebufferuiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearNamedFramebufferuiv_is_loaded(&self) -> bool {
            !self.glClearNamedFramebufferuiv_p.load(RELAX).is_null()
        }
        /// [glClearStencil](http://docs.gl/gl4/glClearStencil)(s)
        /// * `s` group: StencilValue
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearStencil(&self, s: GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.ClearStencil({:?});", s);
            }
            let out = call_atomic_ptr_1arg("glClearStencil", &self.glClearStencil_p, s);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearStencil");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearStencil_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearStencil\0",
                &self.glClearStencil_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearStencil_is_loaded(&self) -> bool {
            !self.glClearStencil_p.load(RELAX).is_null()
        }
        /// [glClearTexImage](http://docs.gl/gl4/glClearTexImage)(texture, level, format, type_, data)
        /// * `format` group: PixelFormat
        /// * `type_` group: PixelType
        /// * `data` len: COMPSIZE(format,type)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearTexImage(
            &self,
            texture: GLuint,
            level: GLint,
            format: GLenum,
            type_: GLenum,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ClearTexImage({:?}, {:?}, {:#X}, {:#X}, {:p});",
                    texture,
                    level,
                    format,
                    type_,
                    data
                );
            }
            let out = call_atomic_ptr_5arg(
                "glClearTexImage",
                &self.glClearTexImage_p,
                texture,
                level,
                format,
                type_,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearTexImage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearTexImage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearTexImage\0",
                &self.glClearTexImage_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearTexImage_is_loaded(&self) -> bool {
            !self.glClearTexImage_p.load(RELAX).is_null()
        }
        /// [glClearTexSubImage](http://docs.gl/gl4/glClearTexSubImage)(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type_, data)
        /// * `format` group: PixelFormat
        /// * `type_` group: PixelType
        /// * `data` len: COMPSIZE(format,type)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClearTexSubImage(
            &self,
            texture: GLuint,
            level: GLint,
            xoffset: GLint,
            yoffset: GLint,
            zoffset: GLint,
            width: GLsizei,
            height: GLsizei,
            depth: GLsizei,
            format: GLenum,
            type_: GLenum,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.ClearTexSubImage({:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:#X}, {:#X}, {:p});", texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type_, data);
            }
            let out = call_atomic_ptr_11arg(
                "glClearTexSubImage",
                &self.glClearTexSubImage_p,
                texture,
                level,
                xoffset,
                yoffset,
                zoffset,
                width,
                height,
                depth,
                format,
                type_,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClearTexSubImage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClearTexSubImage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClearTexSubImage\0",
                &self.glClearTexSubImage_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClearTexSubImage_is_loaded(&self) -> bool {
            !self.glClearTexSubImage_p.load(RELAX).is_null()
        }
        /// [glClientWaitSync](http://docs.gl/gl4/glClientWaitSync)(sync, flags, timeout)
        /// * `sync` group: sync
        /// * `flags` group: SyncObjectMask
        /// * return value group: SyncStatus
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClientWaitSync(
            &self,
            sync: GLsync,
            flags: GLbitfield,
            timeout: GLuint64,
        ) -> GLenum {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ClientWaitSync({:p}, {:?}, {:?});",
                    sync,
                    flags,
                    timeout
                );
            }
            let out = call_atomic_ptr_3arg(
                "glClientWaitSync",
                &self.glClientWaitSync_p,
                sync,
                flags,
                timeout,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClientWaitSync");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClientWaitSync_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glClientWaitSync\0",
                &self.glClientWaitSync_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClientWaitSync_is_loaded(&self) -> bool {
            !self.glClientWaitSync_p.load(RELAX).is_null()
        }
        /// [glClipControl](http://docs.gl/gl4/glClipControl)(origin, depth)
        /// * `origin` group: ClipControlOrigin
        /// * `depth` group: ClipControlDepth
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ClipControl(&self, origin: GLenum, depth: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.ClipControl({:#X}, {:#X});", origin, depth);
            }
            let out = call_atomic_ptr_2arg("glClipControl", &self.glClipControl_p, origin, depth);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glClipControl");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ClipControl_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glClipControl\0", &self.glClipControl_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn ClipControl_is_loaded(&self) -> bool {
            !self.glClipControl_p.load(RELAX).is_null()
        }
        /// [glColorMask](http://docs.gl/gl4/glColorMask)(red, green, blue, alpha)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ColorMask(
            &self,
            red: GLboolean,
            green: GLboolean,
            blue: GLboolean,
            alpha: GLboolean,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ColorMask({:?}, {:?}, {:?}, {:?});",
                    red,
                    green,
                    blue,
                    alpha
                );
            }
            let out =
                call_atomic_ptr_4arg("glColorMask", &self.glColorMask_p, red, green, blue, alpha);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glColorMask");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ColorMask_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glColorMask\0", &self.glColorMask_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn ColorMask_is_loaded(&self) -> bool {
            !self.glColorMask_p.load(RELAX).is_null()
        }
        /// [glColorMaskIndexedEXT](http://docs.gl/gl4/glColorMaskIndexedEXT)(index, r, g, b, a)
        /// * alias of: [`glColorMaski`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ColorMaskIndexedEXT(
            &self,
            index: GLuint,
            r: GLboolean,
            g: GLboolean,
            b: GLboolean,
            a: GLboolean,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ColorMaskIndexedEXT({:?}, {:?}, {:?}, {:?}, {:?});",
                    index,
                    r,
                    g,
                    b,
                    a
                );
            }
            let out = call_atomic_ptr_5arg(
                "glColorMaskIndexedEXT",
                &self.glColorMaskIndexedEXT_p,
                index,
                r,
                g,
                b,
                a,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glColorMaskIndexedEXT");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn ColorMaskIndexedEXT_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glColorMaskIndexedEXT\0",
                &self.glColorMaskIndexedEXT_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn ColorMaskIndexedEXT_is_loaded(&self) -> bool {
            !self.glColorMaskIndexedEXT_p.load(RELAX).is_null()
        }
        /// [glColorMaski](http://docs.gl/gl4/glColorMask)(index, r, g, b, a)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ColorMaski(
            &self,
            index: GLuint,
            r: GLboolean,
            g: GLboolean,
            b: GLboolean,
            a: GLboolean,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ColorMaski({:?}, {:?}, {:?}, {:?}, {:?});",
                    index,
                    r,
                    g,
                    b,
                    a
                );
            }
            let out = call_atomic_ptr_5arg("glColorMaski", &self.glColorMaski_p, index, r, g, b, a);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glColorMaski");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ColorMaski_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glColorMaski\0", &self.glColorMaski_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn ColorMaski_is_loaded(&self) -> bool {
            !self.glColorMaski_p.load(RELAX).is_null()
        }
        /// [glCompileShader](http://docs.gl/gl4/glCompileShader)(shader)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CompileShader(&self, shader: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CompileShader({:?});", shader);
            }
            let out = call_atomic_ptr_1arg("glCompileShader", &self.glCompileShader_p, shader);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCompileShader");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CompileShader_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCompileShader\0",
                &self.glCompileShader_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CompileShader_is_loaded(&self) -> bool {
            !self.glCompileShader_p.load(RELAX).is_null()
        }
        /// [glCompressedTexImage1D](http://docs.gl/gl4/glCompressedTexImage1D)(target, level, internalformat, width, border, imageSize, data)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `internalformat` group: InternalFormat
        /// * `border` group: CheckedInt32
        /// * `data` group: CompressedTextureARB
        /// * `data` len: imageSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CompressedTexImage1D(
            &self,
            target: GLenum,
            level: GLint,
            internalformat: GLenum,
            width: GLsizei,
            border: GLint,
            imageSize: GLsizei,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CompressedTexImage1D({:#X}, {:?}, {:#X}, {:?}, {:?}, {:?}, {:p});",
                    target,
                    level,
                    internalformat,
                    width,
                    border,
                    imageSize,
                    data
                );
            }
            let out = call_atomic_ptr_7arg(
                "glCompressedTexImage1D",
                &self.glCompressedTexImage1D_p,
                target,
                level,
                internalformat,
                width,
                border,
                imageSize,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCompressedTexImage1D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CompressedTexImage1D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCompressedTexImage1D\0",
                &self.glCompressedTexImage1D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CompressedTexImage1D_is_loaded(&self) -> bool {
            !self.glCompressedTexImage1D_p.load(RELAX).is_null()
        }
        /// [glCompressedTexImage2D](http://docs.gl/gl4/glCompressedTexImage2D)(target, level, internalformat, width, height, border, imageSize, data)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `internalformat` group: InternalFormat
        /// * `border` group: CheckedInt32
        /// * `data` group: CompressedTextureARB
        /// * `data` len: imageSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CompressedTexImage2D(
            &self,
            target: GLenum,
            level: GLint,
            internalformat: GLenum,
            width: GLsizei,
            height: GLsizei,
            border: GLint,
            imageSize: GLsizei,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CompressedTexImage2D({:#X}, {:?}, {:#X}, {:?}, {:?}, {:?}, {:?}, {:p});", target, level, internalformat, width, height, border, imageSize, data);
            }
            let out = call_atomic_ptr_8arg(
                "glCompressedTexImage2D",
                &self.glCompressedTexImage2D_p,
                target,
                level,
                internalformat,
                width,
                height,
                border,
                imageSize,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCompressedTexImage2D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CompressedTexImage2D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCompressedTexImage2D\0",
                &self.glCompressedTexImage2D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CompressedTexImage2D_is_loaded(&self) -> bool {
            !self.glCompressedTexImage2D_p.load(RELAX).is_null()
        }
        /// [glCompressedTexImage3D](http://docs.gl/gl4/glCompressedTexImage3D)(target, level, internalformat, width, height, depth, border, imageSize, data)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `internalformat` group: InternalFormat
        /// * `border` group: CheckedInt32
        /// * `data` group: CompressedTextureARB
        /// * `data` len: imageSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CompressedTexImage3D(
            &self,
            target: GLenum,
            level: GLint,
            internalformat: GLenum,
            width: GLsizei,
            height: GLsizei,
            depth: GLsizei,
            border: GLint,
            imageSize: GLsizei,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CompressedTexImage3D({:#X}, {:?}, {:#X}, {:?}, {:?}, {:?}, {:?}, {:?}, {:p});", target, level, internalformat, width, height, depth, border, imageSize, data);
            }
            let out = call_atomic_ptr_9arg(
                "glCompressedTexImage3D",
                &self.glCompressedTexImage3D_p,
                target,
                level,
                internalformat,
                width,
                height,
                depth,
                border,
                imageSize,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCompressedTexImage3D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CompressedTexImage3D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCompressedTexImage3D\0",
                &self.glCompressedTexImage3D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CompressedTexImage3D_is_loaded(&self) -> bool {
            !self.glCompressedTexImage3D_p.load(RELAX).is_null()
        }
        /// [glCompressedTexSubImage1D](http://docs.gl/gl4/glCompressedTexSubImage1D)(target, level, xoffset, width, format, imageSize, data)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `xoffset` group: CheckedInt32
        /// * `format` group: PixelFormat
        /// * `data` group: CompressedTextureARB
        /// * `data` len: imageSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CompressedTexSubImage1D(
            &self,
            target: GLenum,
            level: GLint,
            xoffset: GLint,
            width: GLsizei,
            format: GLenum,
            imageSize: GLsizei,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CompressedTexSubImage1D({:#X}, {:?}, {:?}, {:?}, {:#X}, {:?}, {:p});", target, level, xoffset, width, format, imageSize, data);
            }
            let out = call_atomic_ptr_7arg(
                "glCompressedTexSubImage1D",
                &self.glCompressedTexSubImage1D_p,
                target,
                level,
                xoffset,
                width,
                format,
                imageSize,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCompressedTexSubImage1D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CompressedTexSubImage1D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCompressedTexSubImage1D\0",
                &self.glCompressedTexSubImage1D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CompressedTexSubImage1D_is_loaded(&self) -> bool {
            !self.glCompressedTexSubImage1D_p.load(RELAX).is_null()
        }
        /// [glCompressedTexSubImage2D](http://docs.gl/gl4/glCompressedTexSubImage2D)(target, level, xoffset, yoffset, width, height, format, imageSize, data)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `xoffset` group: CheckedInt32
        /// * `yoffset` group: CheckedInt32
        /// * `format` group: PixelFormat
        /// * `data` group: CompressedTextureARB
        /// * `data` len: imageSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CompressedTexSubImage2D(
            &self,
            target: GLenum,
            level: GLint,
            xoffset: GLint,
            yoffset: GLint,
            width: GLsizei,
            height: GLsizei,
            format: GLenum,
            imageSize: GLsizei,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CompressedTexSubImage2D({:#X}, {:?}, {:?}, {:?}, {:?}, {:?}, {:#X}, {:?}, {:p});", target, level, xoffset, yoffset, width, height, format, imageSize, data);
            }
            let out = call_atomic_ptr_9arg(
                "glCompressedTexSubImage2D",
                &self.glCompressedTexSubImage2D_p,
                target,
                level,
                xoffset,
                yoffset,
                width,
                height,
                format,
                imageSize,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCompressedTexSubImage2D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CompressedTexSubImage2D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCompressedTexSubImage2D\0",
                &self.glCompressedTexSubImage2D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CompressedTexSubImage2D_is_loaded(&self) -> bool {
            !self.glCompressedTexSubImage2D_p.load(RELAX).is_null()
        }
        /// [glCompressedTexSubImage3D](http://docs.gl/gl4/glCompressedTexSubImage3D)(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `xoffset` group: CheckedInt32
        /// * `yoffset` group: CheckedInt32
        /// * `zoffset` group: CheckedInt32
        /// * `format` group: PixelFormat
        /// * `data` group: CompressedTextureARB
        /// * `data` len: imageSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CompressedTexSubImage3D(
            &self,
            target: GLenum,
            level: GLint,
            xoffset: GLint,
            yoffset: GLint,
            zoffset: GLint,
            width: GLsizei,
            height: GLsizei,
            depth: GLsizei,
            format: GLenum,
            imageSize: GLsizei,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CompressedTexSubImage3D({:#X}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:#X}, {:?}, {:p});", target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
            }
            let out = call_atomic_ptr_11arg(
                "glCompressedTexSubImage3D",
                &self.glCompressedTexSubImage3D_p,
                target,
                level,
                xoffset,
                yoffset,
                zoffset,
                width,
                height,
                depth,
                format,
                imageSize,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCompressedTexSubImage3D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CompressedTexSubImage3D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCompressedTexSubImage3D\0",
                &self.glCompressedTexSubImage3D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CompressedTexSubImage3D_is_loaded(&self) -> bool {
            !self.glCompressedTexSubImage3D_p.load(RELAX).is_null()
        }
        /// [glCompressedTextureSubImage1D](http://docs.gl/gl4/glCompressedTextureSubImage1D)(texture, level, xoffset, width, format, imageSize, data)
        /// * `format` group: PixelFormat
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CompressedTextureSubImage1D(
            &self,
            texture: GLuint,
            level: GLint,
            xoffset: GLint,
            width: GLsizei,
            format: GLenum,
            imageSize: GLsizei,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CompressedTextureSubImage1D({:?}, {:?}, {:?}, {:?}, {:#X}, {:?}, {:p});", texture, level, xoffset, width, format, imageSize, data);
            }
            let out = call_atomic_ptr_7arg(
                "glCompressedTextureSubImage1D",
                &self.glCompressedTextureSubImage1D_p,
                texture,
                level,
                xoffset,
                width,
                format,
                imageSize,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCompressedTextureSubImage1D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CompressedTextureSubImage1D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCompressedTextureSubImage1D\0",
                &self.glCompressedTextureSubImage1D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CompressedTextureSubImage1D_is_loaded(&self) -> bool {
            !self.glCompressedTextureSubImage1D_p.load(RELAX).is_null()
        }
        /// [glCompressedTextureSubImage2D](http://docs.gl/gl4/glCompressedTextureSubImage2D)(texture, level, xoffset, yoffset, width, height, format, imageSize, data)
        /// * `format` group: PixelFormat
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CompressedTextureSubImage2D(
            &self,
            texture: GLuint,
            level: GLint,
            xoffset: GLint,
            yoffset: GLint,
            width: GLsizei,
            height: GLsizei,
            format: GLenum,
            imageSize: GLsizei,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CompressedTextureSubImage2D({:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:#X}, {:?}, {:p});", texture, level, xoffset, yoffset, width, height, format, imageSize, data);
            }
            let out = call_atomic_ptr_9arg(
                "glCompressedTextureSubImage2D",
                &self.glCompressedTextureSubImage2D_p,
                texture,
                level,
                xoffset,
                yoffset,
                width,
                height,
                format,
                imageSize,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCompressedTextureSubImage2D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CompressedTextureSubImage2D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCompressedTextureSubImage2D\0",
                &self.glCompressedTextureSubImage2D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CompressedTextureSubImage2D_is_loaded(&self) -> bool {
            !self.glCompressedTextureSubImage2D_p.load(RELAX).is_null()
        }
        /// [glCompressedTextureSubImage3D](http://docs.gl/gl4/glCompressedTextureSubImage3D)(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data)
        /// * `format` group: PixelFormat
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CompressedTextureSubImage3D(
            &self,
            texture: GLuint,
            level: GLint,
            xoffset: GLint,
            yoffset: GLint,
            zoffset: GLint,
            width: GLsizei,
            height: GLsizei,
            depth: GLsizei,
            format: GLenum,
            imageSize: GLsizei,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CompressedTextureSubImage3D({:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:#X}, {:?}, {:p});", texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
            }
            let out = call_atomic_ptr_11arg(
                "glCompressedTextureSubImage3D",
                &self.glCompressedTextureSubImage3D_p,
                texture,
                level,
                xoffset,
                yoffset,
                zoffset,
                width,
                height,
                depth,
                format,
                imageSize,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCompressedTextureSubImage3D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CompressedTextureSubImage3D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCompressedTextureSubImage3D\0",
                &self.glCompressedTextureSubImage3D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CompressedTextureSubImage3D_is_loaded(&self) -> bool {
            !self.glCompressedTextureSubImage3D_p.load(RELAX).is_null()
        }
        /// [glCopyBufferSubData](http://docs.gl/gl4/glCopyBufferSubData)(readTarget, writeTarget, readOffset, writeOffset, size)
        /// * `readTarget` group: CopyBufferSubDataTarget
        /// * `writeTarget` group: CopyBufferSubDataTarget
        /// * `readOffset` group: BufferOffset
        /// * `writeOffset` group: BufferOffset
        /// * `size` group: BufferSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CopyBufferSubData(
            &self,
            readTarget: GLenum,
            writeTarget: GLenum,
            readOffset: GLintptr,
            writeOffset: GLintptr,
            size: GLsizeiptr,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CopyBufferSubData({:#X}, {:#X}, {:?}, {:?}, {:?});",
                    readTarget,
                    writeTarget,
                    readOffset,
                    writeOffset,
                    size
                );
            }
            let out = call_atomic_ptr_5arg(
                "glCopyBufferSubData",
                &self.glCopyBufferSubData_p,
                readTarget,
                writeTarget,
                readOffset,
                writeOffset,
                size,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCopyBufferSubData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CopyBufferSubData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCopyBufferSubData\0",
                &self.glCopyBufferSubData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CopyBufferSubData_is_loaded(&self) -> bool {
            !self.glCopyBufferSubData_p.load(RELAX).is_null()
        }
        /// [glCopyBufferSubDataNV](http://docs.gl/gl4/glCopyBufferSubDataNV)(readTarget, writeTarget, readOffset, writeOffset, size)
        /// * `readTarget` group: CopyBufferSubDataTarget
        /// * `writeTarget` group: CopyBufferSubDataTarget
        /// * `readOffset` group: BufferOffset
        /// * `writeOffset` group: BufferOffset
        /// * `size` group: BufferSize
        /// * alias of: [`glCopyBufferSubData`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CopyBufferSubDataNV(
            &self,
            readTarget: GLenum,
            writeTarget: GLenum,
            readOffset: GLintptr,
            writeOffset: GLintptr,
            size: GLsizeiptr,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CopyBufferSubDataNV({:#X}, {:#X}, {:?}, {:?}, {:?});",
                    readTarget,
                    writeTarget,
                    readOffset,
                    writeOffset,
                    size
                );
            }
            let out = call_atomic_ptr_5arg(
                "glCopyBufferSubDataNV",
                &self.glCopyBufferSubDataNV_p,
                readTarget,
                writeTarget,
                readOffset,
                writeOffset,
                size,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCopyBufferSubDataNV");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn CopyBufferSubDataNV_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCopyBufferSubDataNV\0",
                &self.glCopyBufferSubDataNV_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn CopyBufferSubDataNV_is_loaded(&self) -> bool {
            !self.glCopyBufferSubDataNV_p.load(RELAX).is_null()
        }
        /// [glCopyImageSubData](http://docs.gl/gl4/glCopyImageSubData)(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth)
        /// * `srcTarget` group: CopyImageSubDataTarget
        /// * `dstTarget` group: CopyImageSubDataTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CopyImageSubData(
            &self,
            srcName: GLuint,
            srcTarget: GLenum,
            srcLevel: GLint,
            srcX: GLint,
            srcY: GLint,
            srcZ: GLint,
            dstName: GLuint,
            dstTarget: GLenum,
            dstLevel: GLint,
            dstX: GLint,
            dstY: GLint,
            dstZ: GLint,
            srcWidth: GLsizei,
            srcHeight: GLsizei,
            srcDepth: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CopyImageSubData({:?}, {:#X}, {:?}, {:?}, {:?}, {:?}, {:?}, {:#X}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?});", srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
            }
            let out = call_atomic_ptr_15arg(
                "glCopyImageSubData",
                &self.glCopyImageSubData_p,
                srcName,
                srcTarget,
                srcLevel,
                srcX,
                srcY,
                srcZ,
                dstName,
                dstTarget,
                dstLevel,
                dstX,
                dstY,
                dstZ,
                srcWidth,
                srcHeight,
                srcDepth,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCopyImageSubData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CopyImageSubData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCopyImageSubData\0",
                &self.glCopyImageSubData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CopyImageSubData_is_loaded(&self) -> bool {
            !self.glCopyImageSubData_p.load(RELAX).is_null()
        }
        /// [glCopyNamedBufferSubData](http://docs.gl/gl4/glCopyNamedBufferSubData)(readBuffer, writeBuffer, readOffset, writeOffset, size)
        /// * `size` group: BufferSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CopyNamedBufferSubData(
            &self,
            readBuffer: GLuint,
            writeBuffer: GLuint,
            readOffset: GLintptr,
            writeOffset: GLintptr,
            size: GLsizeiptr,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CopyNamedBufferSubData({:?}, {:?}, {:?}, {:?}, {:?});",
                    readBuffer,
                    writeBuffer,
                    readOffset,
                    writeOffset,
                    size
                );
            }
            let out = call_atomic_ptr_5arg(
                "glCopyNamedBufferSubData",
                &self.glCopyNamedBufferSubData_p,
                readBuffer,
                writeBuffer,
                readOffset,
                writeOffset,
                size,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCopyNamedBufferSubData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CopyNamedBufferSubData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCopyNamedBufferSubData\0",
                &self.glCopyNamedBufferSubData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CopyNamedBufferSubData_is_loaded(&self) -> bool {
            !self.glCopyNamedBufferSubData_p.load(RELAX).is_null()
        }
        /// [glCopyTexImage1D](http://docs.gl/gl4/glCopyTexImage1D)(target, level, internalformat, x, y, width, border)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `internalformat` group: InternalFormat
        /// * `x` group: WinCoord
        /// * `y` group: WinCoord
        /// * `border` group: CheckedInt32
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CopyTexImage1D(
            &self,
            target: GLenum,
            level: GLint,
            internalformat: GLenum,
            x: GLint,
            y: GLint,
            width: GLsizei,
            border: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CopyTexImage1D({:#X}, {:?}, {:#X}, {:?}, {:?}, {:?}, {:?});",
                    target,
                    level,
                    internalformat,
                    x,
                    y,
                    width,
                    border
                );
            }
            let out = call_atomic_ptr_7arg(
                "glCopyTexImage1D",
                &self.glCopyTexImage1D_p,
                target,
                level,
                internalformat,
                x,
                y,
                width,
                border,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCopyTexImage1D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CopyTexImage1D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCopyTexImage1D\0",
                &self.glCopyTexImage1D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CopyTexImage1D_is_loaded(&self) -> bool {
            !self.glCopyTexImage1D_p.load(RELAX).is_null()
        }
        /// [glCopyTexImage2D](http://docs.gl/gl4/glCopyTexImage2D)(target, level, internalformat, x, y, width, height, border)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `internalformat` group: InternalFormat
        /// * `x` group: WinCoord
        /// * `y` group: WinCoord
        /// * `border` group: CheckedInt32
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CopyTexImage2D(
            &self,
            target: GLenum,
            level: GLint,
            internalformat: GLenum,
            x: GLint,
            y: GLint,
            width: GLsizei,
            height: GLsizei,
            border: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CopyTexImage2D({:#X}, {:?}, {:#X}, {:?}, {:?}, {:?}, {:?}, {:?});",
                    target,
                    level,
                    internalformat,
                    x,
                    y,
                    width,
                    height,
                    border
                );
            }
            let out = call_atomic_ptr_8arg(
                "glCopyTexImage2D",
                &self.glCopyTexImage2D_p,
                target,
                level,
                internalformat,
                x,
                y,
                width,
                height,
                border,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCopyTexImage2D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CopyTexImage2D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCopyTexImage2D\0",
                &self.glCopyTexImage2D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CopyTexImage2D_is_loaded(&self) -> bool {
            !self.glCopyTexImage2D_p.load(RELAX).is_null()
        }
        /// [glCopyTexSubImage1D](http://docs.gl/gl4/glCopyTexSubImage1D)(target, level, xoffset, x, y, width)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `xoffset` group: CheckedInt32
        /// * `x` group: WinCoord
        /// * `y` group: WinCoord
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CopyTexSubImage1D(
            &self,
            target: GLenum,
            level: GLint,
            xoffset: GLint,
            x: GLint,
            y: GLint,
            width: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CopyTexSubImage1D({:#X}, {:?}, {:?}, {:?}, {:?}, {:?});",
                    target,
                    level,
                    xoffset,
                    x,
                    y,
                    width
                );
            }
            let out = call_atomic_ptr_6arg(
                "glCopyTexSubImage1D",
                &self.glCopyTexSubImage1D_p,
                target,
                level,
                xoffset,
                x,
                y,
                width,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCopyTexSubImage1D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CopyTexSubImage1D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCopyTexSubImage1D\0",
                &self.glCopyTexSubImage1D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CopyTexSubImage1D_is_loaded(&self) -> bool {
            !self.glCopyTexSubImage1D_p.load(RELAX).is_null()
        }
        /// [glCopyTexSubImage2D](http://docs.gl/gl4/glCopyTexSubImage2D)(target, level, xoffset, yoffset, x, y, width, height)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `xoffset` group: CheckedInt32
        /// * `yoffset` group: CheckedInt32
        /// * `x` group: WinCoord
        /// * `y` group: WinCoord
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CopyTexSubImage2D(
            &self,
            target: GLenum,
            level: GLint,
            xoffset: GLint,
            yoffset: GLint,
            x: GLint,
            y: GLint,
            width: GLsizei,
            height: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CopyTexSubImage2D({:#X}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?});", target, level, xoffset, yoffset, x, y, width, height);
            }
            let out = call_atomic_ptr_8arg(
                "glCopyTexSubImage2D",
                &self.glCopyTexSubImage2D_p,
                target,
                level,
                xoffset,
                yoffset,
                x,
                y,
                width,
                height,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCopyTexSubImage2D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CopyTexSubImage2D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCopyTexSubImage2D\0",
                &self.glCopyTexSubImage2D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CopyTexSubImage2D_is_loaded(&self) -> bool {
            !self.glCopyTexSubImage2D_p.load(RELAX).is_null()
        }
        /// [glCopyTexSubImage3D](http://docs.gl/gl4/glCopyTexSubImage3D)(target, level, xoffset, yoffset, zoffset, x, y, width, height)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `xoffset` group: CheckedInt32
        /// * `yoffset` group: CheckedInt32
        /// * `zoffset` group: CheckedInt32
        /// * `x` group: WinCoord
        /// * `y` group: WinCoord
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CopyTexSubImage3D(
            &self,
            target: GLenum,
            level: GLint,
            xoffset: GLint,
            yoffset: GLint,
            zoffset: GLint,
            x: GLint,
            y: GLint,
            width: GLsizei,
            height: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CopyTexSubImage3D({:#X}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?});", target, level, xoffset, yoffset, zoffset, x, y, width, height);
            }
            let out = call_atomic_ptr_9arg(
                "glCopyTexSubImage3D",
                &self.glCopyTexSubImage3D_p,
                target,
                level,
                xoffset,
                yoffset,
                zoffset,
                x,
                y,
                width,
                height,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCopyTexSubImage3D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CopyTexSubImage3D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCopyTexSubImage3D\0",
                &self.glCopyTexSubImage3D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CopyTexSubImage3D_is_loaded(&self) -> bool {
            !self.glCopyTexSubImage3D_p.load(RELAX).is_null()
        }
        /// [glCopyTextureSubImage1D](http://docs.gl/gl4/glCopyTextureSubImage1D)(texture, level, xoffset, x, y, width)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CopyTextureSubImage1D(
            &self,
            texture: GLuint,
            level: GLint,
            xoffset: GLint,
            x: GLint,
            y: GLint,
            width: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CopyTextureSubImage1D({:?}, {:?}, {:?}, {:?}, {:?}, {:?});",
                    texture,
                    level,
                    xoffset,
                    x,
                    y,
                    width
                );
            }
            let out = call_atomic_ptr_6arg(
                "glCopyTextureSubImage1D",
                &self.glCopyTextureSubImage1D_p,
                texture,
                level,
                xoffset,
                x,
                y,
                width,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCopyTextureSubImage1D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CopyTextureSubImage1D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCopyTextureSubImage1D\0",
                &self.glCopyTextureSubImage1D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CopyTextureSubImage1D_is_loaded(&self) -> bool {
            !self.glCopyTextureSubImage1D_p.load(RELAX).is_null()
        }
        /// [glCopyTextureSubImage2D](http://docs.gl/gl4/glCopyTextureSubImage2D)(texture, level, xoffset, yoffset, x, y, width, height)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CopyTextureSubImage2D(
            &self,
            texture: GLuint,
            level: GLint,
            xoffset: GLint,
            yoffset: GLint,
            x: GLint,
            y: GLint,
            width: GLsizei,
            height: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CopyTextureSubImage2D({:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?});", texture, level, xoffset, yoffset, x, y, width, height);
            }
            let out = call_atomic_ptr_8arg(
                "glCopyTextureSubImage2D",
                &self.glCopyTextureSubImage2D_p,
                texture,
                level,
                xoffset,
                yoffset,
                x,
                y,
                width,
                height,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCopyTextureSubImage2D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CopyTextureSubImage2D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCopyTextureSubImage2D\0",
                &self.glCopyTextureSubImage2D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CopyTextureSubImage2D_is_loaded(&self) -> bool {
            !self.glCopyTextureSubImage2D_p.load(RELAX).is_null()
        }
        /// [glCopyTextureSubImage3D](http://docs.gl/gl4/glCopyTextureSubImage3D)(texture, level, xoffset, yoffset, zoffset, x, y, width, height)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CopyTextureSubImage3D(
            &self,
            texture: GLuint,
            level: GLint,
            xoffset: GLint,
            yoffset: GLint,
            zoffset: GLint,
            x: GLint,
            y: GLint,
            width: GLsizei,
            height: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CopyTextureSubImage3D({:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?});", texture, level, xoffset, yoffset, zoffset, x, y, width, height);
            }
            let out = call_atomic_ptr_9arg(
                "glCopyTextureSubImage3D",
                &self.glCopyTextureSubImage3D_p,
                texture,
                level,
                xoffset,
                yoffset,
                zoffset,
                x,
                y,
                width,
                height,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCopyTextureSubImage3D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CopyTextureSubImage3D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCopyTextureSubImage3D\0",
                &self.glCopyTextureSubImage3D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CopyTextureSubImage3D_is_loaded(&self) -> bool {
            !self.glCopyTextureSubImage3D_p.load(RELAX).is_null()
        }
        /// [glCreateBuffers](http://docs.gl/gl4/glCreateBuffers)(n, buffers)
        /// * `buffers` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CreateBuffers(&self, n: GLsizei, buffers: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CreateBuffers({:?}, {:p});", n, buffers);
            }
            let out = call_atomic_ptr_2arg("glCreateBuffers", &self.glCreateBuffers_p, n, buffers);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCreateBuffers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CreateBuffers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCreateBuffers\0",
                &self.glCreateBuffers_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CreateBuffers_is_loaded(&self) -> bool {
            !self.glCreateBuffers_p.load(RELAX).is_null()
        }
        /// [glCreateFramebuffers](http://docs.gl/gl4/glCreateFramebuffers)(n, framebuffers)
        /// * `framebuffers` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CreateFramebuffers(&self, n: GLsizei, framebuffers: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CreateFramebuffers({:?}, {:p});",
                    n,
                    framebuffers
                );
            }
            let out = call_atomic_ptr_2arg(
                "glCreateFramebuffers",
                &self.glCreateFramebuffers_p,
                n,
                framebuffers,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCreateFramebuffers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CreateFramebuffers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCreateFramebuffers\0",
                &self.glCreateFramebuffers_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CreateFramebuffers_is_loaded(&self) -> bool {
            !self.glCreateFramebuffers_p.load(RELAX).is_null()
        }
        /// [glCreateProgram](http://docs.gl/gl4/glCreateProgram)()
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CreateProgram(&self) -> GLuint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CreateProgram();",);
            }
            let out = call_atomic_ptr_0arg("glCreateProgram", &self.glCreateProgram_p);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCreateProgram");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CreateProgram_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCreateProgram\0",
                &self.glCreateProgram_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CreateProgram_is_loaded(&self) -> bool {
            !self.glCreateProgram_p.load(RELAX).is_null()
        }
        /// [glCreateProgramPipelines](http://docs.gl/gl4/glCreateProgramPipelines)(n, pipelines)
        /// * `pipelines` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CreateProgramPipelines(&self, n: GLsizei, pipelines: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CreateProgramPipelines({:?}, {:p});",
                    n,
                    pipelines
                );
            }
            let out = call_atomic_ptr_2arg(
                "glCreateProgramPipelines",
                &self.glCreateProgramPipelines_p,
                n,
                pipelines,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCreateProgramPipelines");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CreateProgramPipelines_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCreateProgramPipelines\0",
                &self.glCreateProgramPipelines_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CreateProgramPipelines_is_loaded(&self) -> bool {
            !self.glCreateProgramPipelines_p.load(RELAX).is_null()
        }
        /// [glCreateQueries](http://docs.gl/gl4/glCreateQueries)(target, n, ids)
        /// * `target` group: QueryTarget
        /// * `ids` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CreateQueries(&self, target: GLenum, n: GLsizei, ids: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CreateQueries({:#X}, {:?}, {:p});",
                    target,
                    n,
                    ids
                );
            }
            let out =
                call_atomic_ptr_3arg("glCreateQueries", &self.glCreateQueries_p, target, n, ids);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCreateQueries");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CreateQueries_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCreateQueries\0",
                &self.glCreateQueries_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CreateQueries_is_loaded(&self) -> bool {
            !self.glCreateQueries_p.load(RELAX).is_null()
        }
        /// [glCreateRenderbuffers](http://docs.gl/gl4/glCreateRenderbuffers)(n, renderbuffers)
        /// * `renderbuffers` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CreateRenderbuffers(&self, n: GLsizei, renderbuffers: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CreateRenderbuffers({:?}, {:p});",
                    n,
                    renderbuffers
                );
            }
            let out = call_atomic_ptr_2arg(
                "glCreateRenderbuffers",
                &self.glCreateRenderbuffers_p,
                n,
                renderbuffers,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCreateRenderbuffers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CreateRenderbuffers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCreateRenderbuffers\0",
                &self.glCreateRenderbuffers_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CreateRenderbuffers_is_loaded(&self) -> bool {
            !self.glCreateRenderbuffers_p.load(RELAX).is_null()
        }
        /// [glCreateSamplers](http://docs.gl/gl4/glCreateSamplers)(n, samplers)
        /// * `samplers` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CreateSamplers(&self, n: GLsizei, samplers: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CreateSamplers({:?}, {:p});", n, samplers);
            }
            let out =
                call_atomic_ptr_2arg("glCreateSamplers", &self.glCreateSamplers_p, n, samplers);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCreateSamplers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CreateSamplers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCreateSamplers\0",
                &self.glCreateSamplers_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CreateSamplers_is_loaded(&self) -> bool {
            !self.glCreateSamplers_p.load(RELAX).is_null()
        }
        /// [glCreateShader](http://docs.gl/gl4/glCreateShader)(type_)
        /// * `type_` group: ShaderType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CreateShader(&self, type_: GLenum) -> GLuint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CreateShader({:#X});", type_);
            }
            let out = call_atomic_ptr_1arg("glCreateShader", &self.glCreateShader_p, type_);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCreateShader");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CreateShader_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCreateShader\0",
                &self.glCreateShader_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CreateShader_is_loaded(&self) -> bool {
            !self.glCreateShader_p.load(RELAX).is_null()
        }
        /// [glCreateShaderProgramv](http://docs.gl/gl4/glCreateShaderProgramv)(type_, count, strings)
        /// * `type_` group: ShaderType
        /// * `strings` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CreateShaderProgramv(
            &self,
            type_: GLenum,
            count: GLsizei,
            strings: *const *const GLchar,
        ) -> GLuint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CreateShaderProgramv({:#X}, {:?}, {:p});",
                    type_,
                    count,
                    strings
                );
            }
            let out = call_atomic_ptr_3arg(
                "glCreateShaderProgramv",
                &self.glCreateShaderProgramv_p,
                type_,
                count,
                strings,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCreateShaderProgramv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CreateShaderProgramv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCreateShaderProgramv\0",
                &self.glCreateShaderProgramv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CreateShaderProgramv_is_loaded(&self) -> bool {
            !self.glCreateShaderProgramv_p.load(RELAX).is_null()
        }
        /// [glCreateTextures](http://docs.gl/gl4/glCreateTextures)(target, n, textures)
        /// * `target` group: TextureTarget
        /// * `textures` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CreateTextures(&self, target: GLenum, n: GLsizei, textures: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.CreateTextures({:#X}, {:?}, {:p});",
                    target,
                    n,
                    textures
                );
            }
            let out = call_atomic_ptr_3arg(
                "glCreateTextures",
                &self.glCreateTextures_p,
                target,
                n,
                textures,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCreateTextures");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CreateTextures_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCreateTextures\0",
                &self.glCreateTextures_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CreateTextures_is_loaded(&self) -> bool {
            !self.glCreateTextures_p.load(RELAX).is_null()
        }
        /// [glCreateTransformFeedbacks](http://docs.gl/gl4/glCreateTransformFeedbacks)(n, ids)
        /// * `ids` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CreateTransformFeedbacks(&self, n: GLsizei, ids: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CreateTransformFeedbacks({:?}, {:p});", n, ids);
            }
            let out = call_atomic_ptr_2arg(
                "glCreateTransformFeedbacks",
                &self.glCreateTransformFeedbacks_p,
                n,
                ids,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCreateTransformFeedbacks");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CreateTransformFeedbacks_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCreateTransformFeedbacks\0",
                &self.glCreateTransformFeedbacks_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CreateTransformFeedbacks_is_loaded(&self) -> bool {
            !self.glCreateTransformFeedbacks_p.load(RELAX).is_null()
        }
        /// [glCreateVertexArrays](http://docs.gl/gl4/glCreateVertexArrays)(n, arrays)
        /// * `arrays` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CreateVertexArrays(&self, n: GLsizei, arrays: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CreateVertexArrays({:?}, {:p});", n, arrays);
            }
            let out = call_atomic_ptr_2arg(
                "glCreateVertexArrays",
                &self.glCreateVertexArrays_p,
                n,
                arrays,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCreateVertexArrays");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CreateVertexArrays_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glCreateVertexArrays\0",
                &self.glCreateVertexArrays_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn CreateVertexArrays_is_loaded(&self) -> bool {
            !self.glCreateVertexArrays_p.load(RELAX).is_null()
        }
        /// [glCullFace](http://docs.gl/gl4/glCullFace)(mode)
        /// * `mode` group: CullFaceMode
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn CullFace(&self, mode: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.CullFace({:#X});", mode);
            }
            let out = call_atomic_ptr_1arg("glCullFace", &self.glCullFace_p, mode);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glCullFace");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn CullFace_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glCullFace\0", &self.glCullFace_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn CullFace_is_loaded(&self) -> bool {
            !self.glCullFace_p.load(RELAX).is_null()
        }
        /// [glDebugMessageCallback](http://docs.gl/gl4/glDebugMessageCallback)(callback, userParam)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DebugMessageCallback(&self, callback: GLDEBUGPROC, userParam: *const c_void) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DebugMessageCallback({:?}, {:p});",
                    transmute::<_, Option<fn()>>(callback),
                    userParam
                );
            }
            let out = call_atomic_ptr_2arg(
                "glDebugMessageCallback",
                &self.glDebugMessageCallback_p,
                callback,
                userParam,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDebugMessageCallback");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DebugMessageCallback_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDebugMessageCallback\0",
                &self.glDebugMessageCallback_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DebugMessageCallback_is_loaded(&self) -> bool {
            !self.glDebugMessageCallback_p.load(RELAX).is_null()
        }
        /// [glDebugMessageCallbackARB](http://docs.gl/gl4/glDebugMessageCallbackARB)(callback, userParam)
        /// * `userParam` len: COMPSIZE(callback)
        /// * alias of: [`glDebugMessageCallback`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DebugMessageCallbackARB(
            &self,
            callback: GLDEBUGPROCARB,
            userParam: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DebugMessageCallbackARB({:?}, {:p});",
                    transmute::<_, Option<fn()>>(callback),
                    userParam
                );
            }
            let out = call_atomic_ptr_2arg(
                "glDebugMessageCallbackARB",
                &self.glDebugMessageCallbackARB_p,
                callback,
                userParam,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDebugMessageCallbackARB");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn DebugMessageCallbackARB_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDebugMessageCallbackARB\0",
                &self.glDebugMessageCallbackARB_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn DebugMessageCallbackARB_is_loaded(&self) -> bool {
            !self.glDebugMessageCallbackARB_p.load(RELAX).is_null()
        }
        /// [glDebugMessageCallbackKHR](http://docs.gl/gl4/glDebugMessageCallbackKHR)(callback, userParam)
        /// * alias of: [`glDebugMessageCallback`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DebugMessageCallbackKHR(
            &self,
            callback: GLDEBUGPROCKHR,
            userParam: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DebugMessageCallbackKHR({:?}, {:p});",
                    transmute::<_, Option<fn()>>(callback),
                    userParam
                );
            }
            let out = call_atomic_ptr_2arg(
                "glDebugMessageCallbackKHR",
                &self.glDebugMessageCallbackKHR_p,
                callback,
                userParam,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDebugMessageCallbackKHR");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn DebugMessageCallbackKHR_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDebugMessageCallbackKHR\0",
                &self.glDebugMessageCallbackKHR_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn DebugMessageCallbackKHR_is_loaded(&self) -> bool {
            !self.glDebugMessageCallbackKHR_p.load(RELAX).is_null()
        }
        /// [glDebugMessageControl](http://docs.gl/gl4/glDebugMessageControl)(source, type_, severity, count, ids, enabled)
        /// * `source` group: DebugSource
        /// * `type_` group: DebugType
        /// * `severity` group: DebugSeverity
        /// * `ids` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DebugMessageControl(
            &self,
            source: GLenum,
            type_: GLenum,
            severity: GLenum,
            count: GLsizei,
            ids: *const GLuint,
            enabled: GLboolean,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DebugMessageControl({:#X}, {:#X}, {:#X}, {:?}, {:p}, {:?});",
                    source,
                    type_,
                    severity,
                    count,
                    ids,
                    enabled
                );
            }
            let out = call_atomic_ptr_6arg(
                "glDebugMessageControl",
                &self.glDebugMessageControl_p,
                source,
                type_,
                severity,
                count,
                ids,
                enabled,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDebugMessageControl");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DebugMessageControl_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDebugMessageControl\0",
                &self.glDebugMessageControl_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DebugMessageControl_is_loaded(&self) -> bool {
            !self.glDebugMessageControl_p.load(RELAX).is_null()
        }
        /// [glDebugMessageControlARB](http://docs.gl/gl4/glDebugMessageControlARB)(source, type_, severity, count, ids, enabled)
        /// * `source` group: DebugSource
        /// * `type_` group: DebugType
        /// * `severity` group: DebugSeverity
        /// * `ids` len: count
        /// * alias of: [`glDebugMessageControl`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DebugMessageControlARB(
            &self,
            source: GLenum,
            type_: GLenum,
            severity: GLenum,
            count: GLsizei,
            ids: *const GLuint,
            enabled: GLboolean,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DebugMessageControlARB({:#X}, {:#X}, {:#X}, {:?}, {:p}, {:?});",
                    source,
                    type_,
                    severity,
                    count,
                    ids,
                    enabled
                );
            }
            let out = call_atomic_ptr_6arg(
                "glDebugMessageControlARB",
                &self.glDebugMessageControlARB_p,
                source,
                type_,
                severity,
                count,
                ids,
                enabled,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDebugMessageControlARB");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn DebugMessageControlARB_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDebugMessageControlARB\0",
                &self.glDebugMessageControlARB_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn DebugMessageControlARB_is_loaded(&self) -> bool {
            !self.glDebugMessageControlARB_p.load(RELAX).is_null()
        }
        /// [glDebugMessageControlKHR](http://docs.gl/gl4/glDebugMessageControlKHR)(source, type_, severity, count, ids, enabled)
        /// * `source` group: DebugSource
        /// * `type_` group: DebugType
        /// * `severity` group: DebugSeverity
        /// * alias of: [`glDebugMessageControl`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DebugMessageControlKHR(
            &self,
            source: GLenum,
            type_: GLenum,
            severity: GLenum,
            count: GLsizei,
            ids: *const GLuint,
            enabled: GLboolean,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DebugMessageControlKHR({:#X}, {:#X}, {:#X}, {:?}, {:p}, {:?});",
                    source,
                    type_,
                    severity,
                    count,
                    ids,
                    enabled
                );
            }
            let out = call_atomic_ptr_6arg(
                "glDebugMessageControlKHR",
                &self.glDebugMessageControlKHR_p,
                source,
                type_,
                severity,
                count,
                ids,
                enabled,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDebugMessageControlKHR");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn DebugMessageControlKHR_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDebugMessageControlKHR\0",
                &self.glDebugMessageControlKHR_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn DebugMessageControlKHR_is_loaded(&self) -> bool {
            !self.glDebugMessageControlKHR_p.load(RELAX).is_null()
        }
        /// [glDebugMessageInsert](http://docs.gl/gl4/glDebugMessageInsert)(source, type_, id, severity, length, buf)
        /// * `source` group: DebugSource
        /// * `type_` group: DebugType
        /// * `severity` group: DebugSeverity
        /// * `buf` len: COMPSIZE(buf,length)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DebugMessageInsert(
            &self,
            source: GLenum,
            type_: GLenum,
            id: GLuint,
            severity: GLenum,
            length: GLsizei,
            buf: *const GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DebugMessageInsert({:#X}, {:#X}, {:?}, {:#X}, {:?}, {:p});",
                    source,
                    type_,
                    id,
                    severity,
                    length,
                    buf
                );
            }
            let out = call_atomic_ptr_6arg(
                "glDebugMessageInsert",
                &self.glDebugMessageInsert_p,
                source,
                type_,
                id,
                severity,
                length,
                buf,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDebugMessageInsert");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DebugMessageInsert_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDebugMessageInsert\0",
                &self.glDebugMessageInsert_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DebugMessageInsert_is_loaded(&self) -> bool {
            !self.glDebugMessageInsert_p.load(RELAX).is_null()
        }
        /// [glDebugMessageInsertARB](http://docs.gl/gl4/glDebugMessageInsertARB)(source, type_, id, severity, length, buf)
        /// * `source` group: DebugSource
        /// * `type_` group: DebugType
        /// * `severity` group: DebugSeverity
        /// * `buf` len: length
        /// * alias of: [`glDebugMessageInsert`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DebugMessageInsertARB(
            &self,
            source: GLenum,
            type_: GLenum,
            id: GLuint,
            severity: GLenum,
            length: GLsizei,
            buf: *const GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DebugMessageInsertARB({:#X}, {:#X}, {:?}, {:#X}, {:?}, {:p});",
                    source,
                    type_,
                    id,
                    severity,
                    length,
                    buf
                );
            }
            let out = call_atomic_ptr_6arg(
                "glDebugMessageInsertARB",
                &self.glDebugMessageInsertARB_p,
                source,
                type_,
                id,
                severity,
                length,
                buf,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDebugMessageInsertARB");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn DebugMessageInsertARB_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDebugMessageInsertARB\0",
                &self.glDebugMessageInsertARB_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn DebugMessageInsertARB_is_loaded(&self) -> bool {
            !self.glDebugMessageInsertARB_p.load(RELAX).is_null()
        }
        /// [glDebugMessageInsertKHR](http://docs.gl/gl4/glDebugMessageInsertKHR)(source, type_, id, severity, length, buf)
        /// * `source` group: DebugSource
        /// * `type_` group: DebugType
        /// * `severity` group: DebugSeverity
        /// * alias of: [`glDebugMessageInsert`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DebugMessageInsertKHR(
            &self,
            source: GLenum,
            type_: GLenum,
            id: GLuint,
            severity: GLenum,
            length: GLsizei,
            buf: *const GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DebugMessageInsertKHR({:#X}, {:#X}, {:?}, {:#X}, {:?}, {:p});",
                    source,
                    type_,
                    id,
                    severity,
                    length,
                    buf
                );
            }
            let out = call_atomic_ptr_6arg(
                "glDebugMessageInsertKHR",
                &self.glDebugMessageInsertKHR_p,
                source,
                type_,
                id,
                severity,
                length,
                buf,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDebugMessageInsertKHR");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn DebugMessageInsertKHR_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDebugMessageInsertKHR\0",
                &self.glDebugMessageInsertKHR_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn DebugMessageInsertKHR_is_loaded(&self) -> bool {
            !self.glDebugMessageInsertKHR_p.load(RELAX).is_null()
        }
        /// [glDeleteBuffers](http://docs.gl/gl4/glDeleteBuffers)(n, buffers)
        /// * `buffers` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DeleteBuffers(&self, n: GLsizei, buffers: *const GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DeleteBuffers({:?}, {:p});", n, buffers);
            }
            let out = call_atomic_ptr_2arg("glDeleteBuffers", &self.glDeleteBuffers_p, n, buffers);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDeleteBuffers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DeleteBuffers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDeleteBuffers\0",
                &self.glDeleteBuffers_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DeleteBuffers_is_loaded(&self) -> bool {
            !self.glDeleteBuffers_p.load(RELAX).is_null()
        }
        /// [glDeleteFramebuffers](http://docs.gl/gl4/glDeleteFramebuffers)(n, framebuffers)
        /// * `framebuffers` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DeleteFramebuffers(&self, n: GLsizei, framebuffers: *const GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DeleteFramebuffers({:?}, {:p});",
                    n,
                    framebuffers
                );
            }
            let out = call_atomic_ptr_2arg(
                "glDeleteFramebuffers",
                &self.glDeleteFramebuffers_p,
                n,
                framebuffers,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDeleteFramebuffers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DeleteFramebuffers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDeleteFramebuffers\0",
                &self.glDeleteFramebuffers_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DeleteFramebuffers_is_loaded(&self) -> bool {
            !self.glDeleteFramebuffers_p.load(RELAX).is_null()
        }
        /// [glDeleteProgram](http://docs.gl/gl4/glDeleteProgram)(program)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DeleteProgram(&self, program: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DeleteProgram({:?});", program);
            }
            let out = call_atomic_ptr_1arg("glDeleteProgram", &self.glDeleteProgram_p, program);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDeleteProgram");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DeleteProgram_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDeleteProgram\0",
                &self.glDeleteProgram_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DeleteProgram_is_loaded(&self) -> bool {
            !self.glDeleteProgram_p.load(RELAX).is_null()
        }
        /// [glDeleteProgramPipelines](http://docs.gl/gl4/glDeleteProgramPipelines)(n, pipelines)
        /// * `pipelines` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DeleteProgramPipelines(&self, n: GLsizei, pipelines: *const GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DeleteProgramPipelines({:?}, {:p});",
                    n,
                    pipelines
                );
            }
            let out = call_atomic_ptr_2arg(
                "glDeleteProgramPipelines",
                &self.glDeleteProgramPipelines_p,
                n,
                pipelines,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDeleteProgramPipelines");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DeleteProgramPipelines_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDeleteProgramPipelines\0",
                &self.glDeleteProgramPipelines_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DeleteProgramPipelines_is_loaded(&self) -> bool {
            !self.glDeleteProgramPipelines_p.load(RELAX).is_null()
        }
        /// [glDeleteQueries](http://docs.gl/gl4/glDeleteQueries)(n, ids)
        /// * `ids` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DeleteQueries(&self, n: GLsizei, ids: *const GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DeleteQueries({:?}, {:p});", n, ids);
            }
            let out = call_atomic_ptr_2arg("glDeleteQueries", &self.glDeleteQueries_p, n, ids);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDeleteQueries");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DeleteQueries_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDeleteQueries\0",
                &self.glDeleteQueries_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DeleteQueries_is_loaded(&self) -> bool {
            !self.glDeleteQueries_p.load(RELAX).is_null()
        }
        /// [glDeleteRenderbuffers](http://docs.gl/gl4/glDeleteRenderbuffers)(n, renderbuffers)
        /// * `renderbuffers` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DeleteRenderbuffers(&self, n: GLsizei, renderbuffers: *const GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DeleteRenderbuffers({:?}, {:p});",
                    n,
                    renderbuffers
                );
            }
            let out = call_atomic_ptr_2arg(
                "glDeleteRenderbuffers",
                &self.glDeleteRenderbuffers_p,
                n,
                renderbuffers,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDeleteRenderbuffers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DeleteRenderbuffers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDeleteRenderbuffers\0",
                &self.glDeleteRenderbuffers_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DeleteRenderbuffers_is_loaded(&self) -> bool {
            !self.glDeleteRenderbuffers_p.load(RELAX).is_null()
        }
        /// [glDeleteSamplers](http://docs.gl/gl4/glDeleteSamplers)(count, samplers)
        /// * `samplers` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DeleteSamplers(&self, count: GLsizei, samplers: *const GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DeleteSamplers({:?}, {:p});", count, samplers);
            }
            let out = call_atomic_ptr_2arg(
                "glDeleteSamplers",
                &self.glDeleteSamplers_p,
                count,
                samplers,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDeleteSamplers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DeleteSamplers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDeleteSamplers\0",
                &self.glDeleteSamplers_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DeleteSamplers_is_loaded(&self) -> bool {
            !self.glDeleteSamplers_p.load(RELAX).is_null()
        }
        /// [glDeleteShader](http://docs.gl/gl4/glDeleteShader)(shader)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DeleteShader(&self, shader: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DeleteShader({:?});", shader);
            }
            let out = call_atomic_ptr_1arg("glDeleteShader", &self.glDeleteShader_p, shader);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDeleteShader");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DeleteShader_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDeleteShader\0",
                &self.glDeleteShader_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DeleteShader_is_loaded(&self) -> bool {
            !self.glDeleteShader_p.load(RELAX).is_null()
        }
        /// [glDeleteSync](http://docs.gl/gl4/glDeleteSync)(sync)
        /// * `sync` group: sync
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DeleteSync(&self, sync: GLsync) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DeleteSync({:p});", sync);
            }
            let out = call_atomic_ptr_1arg("glDeleteSync", &self.glDeleteSync_p, sync);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDeleteSync");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DeleteSync_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glDeleteSync\0", &self.glDeleteSync_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn DeleteSync_is_loaded(&self) -> bool {
            !self.glDeleteSync_p.load(RELAX).is_null()
        }
        /// [glDeleteTextures](http://docs.gl/gl4/glDeleteTextures)(n, textures)
        /// * `textures` group: Texture
        /// * `textures` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DeleteTextures(&self, n: GLsizei, textures: *const GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DeleteTextures({:?}, {:p});", n, textures);
            }
            let out =
                call_atomic_ptr_2arg("glDeleteTextures", &self.glDeleteTextures_p, n, textures);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDeleteTextures");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DeleteTextures_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDeleteTextures\0",
                &self.glDeleteTextures_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DeleteTextures_is_loaded(&self) -> bool {
            !self.glDeleteTextures_p.load(RELAX).is_null()
        }
        /// [glDeleteTransformFeedbacks](http://docs.gl/gl4/glDeleteTransformFeedbacks)(n, ids)
        /// * `ids` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DeleteTransformFeedbacks(&self, n: GLsizei, ids: *const GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DeleteTransformFeedbacks({:?}, {:p});", n, ids);
            }
            let out = call_atomic_ptr_2arg(
                "glDeleteTransformFeedbacks",
                &self.glDeleteTransformFeedbacks_p,
                n,
                ids,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDeleteTransformFeedbacks");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DeleteTransformFeedbacks_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDeleteTransformFeedbacks\0",
                &self.glDeleteTransformFeedbacks_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DeleteTransformFeedbacks_is_loaded(&self) -> bool {
            !self.glDeleteTransformFeedbacks_p.load(RELAX).is_null()
        }
        /// [glDeleteVertexArrays](http://docs.gl/gl4/glDeleteVertexArrays)(n, arrays)
        /// * `arrays` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DeleteVertexArrays(&self, n: GLsizei, arrays: *const GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DeleteVertexArrays({:?}, {:p});", n, arrays);
            }
            let out = call_atomic_ptr_2arg(
                "glDeleteVertexArrays",
                &self.glDeleteVertexArrays_p,
                n,
                arrays,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDeleteVertexArrays");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DeleteVertexArrays_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDeleteVertexArrays\0",
                &self.glDeleteVertexArrays_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DeleteVertexArrays_is_loaded(&self) -> bool {
            !self.glDeleteVertexArrays_p.load(RELAX).is_null()
        }
        /// [glDepthFunc](http://docs.gl/gl4/glDepthFunc)(func)
        /// * `func` group: DepthFunction
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DepthFunc(&self, func: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DepthFunc({:#X});", func);
            }
            let out = call_atomic_ptr_1arg("glDepthFunc", &self.glDepthFunc_p, func);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDepthFunc");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DepthFunc_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glDepthFunc\0", &self.glDepthFunc_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn DepthFunc_is_loaded(&self) -> bool {
            !self.glDepthFunc_p.load(RELAX).is_null()
        }
        /// [glDepthMask](http://docs.gl/gl4/glDepthMask)(flag)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DepthMask(&self, flag: GLboolean) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DepthMask({:?});", flag);
            }
            let out = call_atomic_ptr_1arg("glDepthMask", &self.glDepthMask_p, flag);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDepthMask");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DepthMask_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glDepthMask\0", &self.glDepthMask_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn DepthMask_is_loaded(&self) -> bool {
            !self.glDepthMask_p.load(RELAX).is_null()
        }
        /// [glDepthRange](http://docs.gl/gl4/glDepthRange)(n, f)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DepthRange(&self, n: GLdouble, f: GLdouble) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DepthRange({:?}, {:?});", n, f);
            }
            let out = call_atomic_ptr_2arg("glDepthRange", &self.glDepthRange_p, n, f);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDepthRange");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DepthRange_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glDepthRange\0", &self.glDepthRange_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn DepthRange_is_loaded(&self) -> bool {
            !self.glDepthRange_p.load(RELAX).is_null()
        }
        /// [glDepthRangeArrayv](http://docs.gl/gl4/glDepthRangeArrayv)(first, count, v)
        /// * `v` len: COMPSIZE(count)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DepthRangeArrayv(&self, first: GLuint, count: GLsizei, v: *const GLdouble) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DepthRangeArrayv({:?}, {:?}, {:p});",
                    first,
                    count,
                    v
                );
            }
            let out = call_atomic_ptr_3arg(
                "glDepthRangeArrayv",
                &self.glDepthRangeArrayv_p,
                first,
                count,
                v,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDepthRangeArrayv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DepthRangeArrayv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDepthRangeArrayv\0",
                &self.glDepthRangeArrayv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DepthRangeArrayv_is_loaded(&self) -> bool {
            !self.glDepthRangeArrayv_p.load(RELAX).is_null()
        }
        /// [glDepthRangeIndexed](http://docs.gl/gl4/glDepthRangeIndexed)(index, n, f)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DepthRangeIndexed(&self, index: GLuint, n: GLdouble, f: GLdouble) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DepthRangeIndexed({:?}, {:?}, {:?});",
                    index,
                    n,
                    f
                );
            }
            let out = call_atomic_ptr_3arg(
                "glDepthRangeIndexed",
                &self.glDepthRangeIndexed_p,
                index,
                n,
                f,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDepthRangeIndexed");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DepthRangeIndexed_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDepthRangeIndexed\0",
                &self.glDepthRangeIndexed_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DepthRangeIndexed_is_loaded(&self) -> bool {
            !self.glDepthRangeIndexed_p.load(RELAX).is_null()
        }
        /// [glDepthRangef](http://docs.gl/gl4/glDepthRange)(n, f)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DepthRangef(&self, n: GLfloat, f: GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DepthRangef({:?}, {:?});", n, f);
            }
            let out = call_atomic_ptr_2arg("glDepthRangef", &self.glDepthRangef_p, n, f);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDepthRangef");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DepthRangef_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glDepthRangef\0", &self.glDepthRangef_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn DepthRangef_is_loaded(&self) -> bool {
            !self.glDepthRangef_p.load(RELAX).is_null()
        }
        /// [glDetachShader](http://docs.gl/gl4/glDetachShader)(program, shader)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DetachShader(&self, program: GLuint, shader: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DetachShader({:?}, {:?});", program, shader);
            }
            let out =
                call_atomic_ptr_2arg("glDetachShader", &self.glDetachShader_p, program, shader);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDetachShader");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DetachShader_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDetachShader\0",
                &self.glDetachShader_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DetachShader_is_loaded(&self) -> bool {
            !self.glDetachShader_p.load(RELAX).is_null()
        }
        /// [glDisable](http://docs.gl/gl4/glDisable)(cap)
        /// * `cap` group: EnableCap
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn Disable(&self, cap: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.Disable({:#X});", cap);
            }
            let out = call_atomic_ptr_1arg("glDisable", &self.glDisable_p, cap);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDisable");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn Disable_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glDisable\0", &self.glDisable_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn Disable_is_loaded(&self) -> bool {
            !self.glDisable_p.load(RELAX).is_null()
        }
        /// [glDisableIndexedEXT](http://docs.gl/gl4/glDisableIndexedEXT)(target, index)
        /// * `target` group: EnableCap
        /// * alias of: [`glDisablei`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DisableIndexedEXT(&self, target: GLenum, index: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DisableIndexedEXT({:#X}, {:?});", target, index);
            }
            let out = call_atomic_ptr_2arg(
                "glDisableIndexedEXT",
                &self.glDisableIndexedEXT_p,
                target,
                index,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDisableIndexedEXT");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn DisableIndexedEXT_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDisableIndexedEXT\0",
                &self.glDisableIndexedEXT_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn DisableIndexedEXT_is_loaded(&self) -> bool {
            !self.glDisableIndexedEXT_p.load(RELAX).is_null()
        }
        /// [glDisableVertexArrayAttrib](http://docs.gl/gl4/glDisableVertexArrayAttrib)(vaobj, index)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DisableVertexArrayAttrib(&self, vaobj: GLuint, index: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DisableVertexArrayAttrib({:?}, {:?});",
                    vaobj,
                    index
                );
            }
            let out = call_atomic_ptr_2arg(
                "glDisableVertexArrayAttrib",
                &self.glDisableVertexArrayAttrib_p,
                vaobj,
                index,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDisableVertexArrayAttrib");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DisableVertexArrayAttrib_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDisableVertexArrayAttrib\0",
                &self.glDisableVertexArrayAttrib_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DisableVertexArrayAttrib_is_loaded(&self) -> bool {
            !self.glDisableVertexArrayAttrib_p.load(RELAX).is_null()
        }
        /// [glDisableVertexAttribArray](http://docs.gl/gl4/glDisableVertexAttribArray)(index)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DisableVertexAttribArray(&self, index: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DisableVertexAttribArray({:?});", index);
            }
            let out = call_atomic_ptr_1arg(
                "glDisableVertexAttribArray",
                &self.glDisableVertexAttribArray_p,
                index,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDisableVertexAttribArray");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DisableVertexAttribArray_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDisableVertexAttribArray\0",
                &self.glDisableVertexAttribArray_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DisableVertexAttribArray_is_loaded(&self) -> bool {
            !self.glDisableVertexAttribArray_p.load(RELAX).is_null()
        }
        /// [glDisablei](http://docs.gl/gl4/glDisable)(target, index)
        /// * `target` group: EnableCap
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn Disablei(&self, target: GLenum, index: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.Disablei({:#X}, {:?});", target, index);
            }
            let out = call_atomic_ptr_2arg("glDisablei", &self.glDisablei_p, target, index);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDisablei");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn Disablei_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glDisablei\0", &self.glDisablei_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn Disablei_is_loaded(&self) -> bool {
            !self.glDisablei_p.load(RELAX).is_null()
        }
        /// [glDispatchCompute](http://docs.gl/gl4/glDispatchCompute)(num_groups_x, num_groups_y, num_groups_z)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DispatchCompute(
            &self,
            num_groups_x: GLuint,
            num_groups_y: GLuint,
            num_groups_z: GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DispatchCompute({:?}, {:?}, {:?});",
                    num_groups_x,
                    num_groups_y,
                    num_groups_z
                );
            }
            let out = call_atomic_ptr_3arg(
                "glDispatchCompute",
                &self.glDispatchCompute_p,
                num_groups_x,
                num_groups_y,
                num_groups_z,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDispatchCompute");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DispatchCompute_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDispatchCompute\0",
                &self.glDispatchCompute_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DispatchCompute_is_loaded(&self) -> bool {
            !self.glDispatchCompute_p.load(RELAX).is_null()
        }
        /// [glDispatchComputeIndirect](http://docs.gl/gl4/glDispatchComputeIndirect)(indirect)
        /// * `indirect` group: BufferOffset
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DispatchComputeIndirect(&self, indirect: GLintptr) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DispatchComputeIndirect({:?});", indirect);
            }
            let out = call_atomic_ptr_1arg(
                "glDispatchComputeIndirect",
                &self.glDispatchComputeIndirect_p,
                indirect,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDispatchComputeIndirect");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DispatchComputeIndirect_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDispatchComputeIndirect\0",
                &self.glDispatchComputeIndirect_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DispatchComputeIndirect_is_loaded(&self) -> bool {
            !self.glDispatchComputeIndirect_p.load(RELAX).is_null()
        }
        /// [glDrawArrays](http://docs.gl/gl4/glDrawArrays)(mode, first, count)
        /// * `mode` group: PrimitiveType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawArrays(&self, mode: GLenum, first: GLint, count: GLsizei) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DrawArrays({:#X}, {:?}, {:?});",
                    mode,
                    first,
                    count
                );
            }
            let out =
                call_atomic_ptr_3arg("glDrawArrays", &self.glDrawArrays_p, mode, first, count);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawArrays");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawArrays_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glDrawArrays\0", &self.glDrawArrays_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawArrays_is_loaded(&self) -> bool {
            !self.glDrawArrays_p.load(RELAX).is_null()
        }
        /// [glDrawArraysIndirect](http://docs.gl/gl4/glDrawArraysIndirect)(mode, indirect)
        /// * `mode` group: PrimitiveType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawArraysIndirect(&self, mode: GLenum, indirect: *const c_void) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DrawArraysIndirect({:#X}, {:p});",
                    mode,
                    indirect
                );
            }
            let out = call_atomic_ptr_2arg(
                "glDrawArraysIndirect",
                &self.glDrawArraysIndirect_p,
                mode,
                indirect,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawArraysIndirect");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawArraysIndirect_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawArraysIndirect\0",
                &self.glDrawArraysIndirect_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawArraysIndirect_is_loaded(&self) -> bool {
            !self.glDrawArraysIndirect_p.load(RELAX).is_null()
        }
        /// [glDrawArraysInstanced](http://docs.gl/gl4/glDrawArraysInstanced)(mode, first, count, instancecount)
        /// * `mode` group: PrimitiveType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawArraysInstanced(
            &self,
            mode: GLenum,
            first: GLint,
            count: GLsizei,
            instancecount: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DrawArraysInstanced({:#X}, {:?}, {:?}, {:?});",
                    mode,
                    first,
                    count,
                    instancecount
                );
            }
            let out = call_atomic_ptr_4arg(
                "glDrawArraysInstanced",
                &self.glDrawArraysInstanced_p,
                mode,
                first,
                count,
                instancecount,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawArraysInstanced");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawArraysInstanced_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawArraysInstanced\0",
                &self.glDrawArraysInstanced_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawArraysInstanced_is_loaded(&self) -> bool {
            !self.glDrawArraysInstanced_p.load(RELAX).is_null()
        }
        /// [glDrawArraysInstancedARB](http://docs.gl/gl4/glDrawArraysInstancedARB)(mode, first, count, primcount)
        /// * `mode` group: PrimitiveType
        /// * alias of: [`glDrawArraysInstanced`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawArraysInstancedARB(
            &self,
            mode: GLenum,
            first: GLint,
            count: GLsizei,
            primcount: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DrawArraysInstancedARB({:#X}, {:?}, {:?}, {:?});",
                    mode,
                    first,
                    count,
                    primcount
                );
            }
            let out = call_atomic_ptr_4arg(
                "glDrawArraysInstancedARB",
                &self.glDrawArraysInstancedARB_p,
                mode,
                first,
                count,
                primcount,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawArraysInstancedARB");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn DrawArraysInstancedARB_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawArraysInstancedARB\0",
                &self.glDrawArraysInstancedARB_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn DrawArraysInstancedARB_is_loaded(&self) -> bool {
            !self.glDrawArraysInstancedARB_p.load(RELAX).is_null()
        }
        /// [glDrawArraysInstancedBaseInstance](http://docs.gl/gl4/glDrawArraysInstancedBaseInstance)(mode, first, count, instancecount, baseinstance)
        /// * `mode` group: PrimitiveType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawArraysInstancedBaseInstance(
            &self,
            mode: GLenum,
            first: GLint,
            count: GLsizei,
            instancecount: GLsizei,
            baseinstance: GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DrawArraysInstancedBaseInstance({:#X}, {:?}, {:?}, {:?}, {:?});",
                    mode,
                    first,
                    count,
                    instancecount,
                    baseinstance
                );
            }
            let out = call_atomic_ptr_5arg(
                "glDrawArraysInstancedBaseInstance",
                &self.glDrawArraysInstancedBaseInstance_p,
                mode,
                first,
                count,
                instancecount,
                baseinstance,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawArraysInstancedBaseInstance");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawArraysInstancedBaseInstance_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawArraysInstancedBaseInstance\0",
                &self.glDrawArraysInstancedBaseInstance_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawArraysInstancedBaseInstance_is_loaded(&self) -> bool {
            !self
                .glDrawArraysInstancedBaseInstance_p
                .load(RELAX)
                .is_null()
        }
        /// [glDrawBuffer](http://docs.gl/gl4/glDrawBuffer)(buf)
        /// * `buf` group: DrawBufferMode
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawBuffer(&self, buf: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DrawBuffer({:#X});", buf);
            }
            let out = call_atomic_ptr_1arg("glDrawBuffer", &self.glDrawBuffer_p, buf);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawBuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawBuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glDrawBuffer\0", &self.glDrawBuffer_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawBuffer_is_loaded(&self) -> bool {
            !self.glDrawBuffer_p.load(RELAX).is_null()
        }
        /// [glDrawBuffers](http://docs.gl/gl4/glDrawBuffers)(n, bufs)
        /// * `bufs` group: DrawBufferMode
        /// * `bufs` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawBuffers(&self, n: GLsizei, bufs: *const GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DrawBuffers({:?}, {:p});", n, bufs);
            }
            let out = call_atomic_ptr_2arg("glDrawBuffers", &self.glDrawBuffers_p, n, bufs);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawBuffers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawBuffers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glDrawBuffers\0", &self.glDrawBuffers_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawBuffers_is_loaded(&self) -> bool {
            !self.glDrawBuffers_p.load(RELAX).is_null()
        }
        /// [glDrawElements](http://docs.gl/gl4/glDrawElements)(mode, count, type_, indices)
        /// * `mode` group: PrimitiveType
        /// * `type_` group: DrawElementsType
        /// * `indices` len: COMPSIZE(count,type)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawElements(
            &self,
            mode: GLenum,
            count: GLsizei,
            type_: GLenum,
            indices: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DrawElements({:#X}, {:?}, {:#X}, {:p});",
                    mode,
                    count,
                    type_,
                    indices
                );
            }
            let out = call_atomic_ptr_4arg(
                "glDrawElements",
                &self.glDrawElements_p,
                mode,
                count,
                type_,
                indices,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawElements");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawElements_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawElements\0",
                &self.glDrawElements_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawElements_is_loaded(&self) -> bool {
            !self.glDrawElements_p.load(RELAX).is_null()
        }
        /// [glDrawElementsBaseVertex](http://docs.gl/gl4/glDrawElementsBaseVertex)(mode, count, type_, indices, basevertex)
        /// * `mode` group: PrimitiveType
        /// * `type_` group: DrawElementsType
        /// * `indices` len: COMPSIZE(count,type)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawElementsBaseVertex(
            &self,
            mode: GLenum,
            count: GLsizei,
            type_: GLenum,
            indices: *const c_void,
            basevertex: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DrawElementsBaseVertex({:#X}, {:?}, {:#X}, {:p}, {:?});",
                    mode,
                    count,
                    type_,
                    indices,
                    basevertex
                );
            }
            let out = call_atomic_ptr_5arg(
                "glDrawElementsBaseVertex",
                &self.glDrawElementsBaseVertex_p,
                mode,
                count,
                type_,
                indices,
                basevertex,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawElementsBaseVertex");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawElementsBaseVertex_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawElementsBaseVertex\0",
                &self.glDrawElementsBaseVertex_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawElementsBaseVertex_is_loaded(&self) -> bool {
            !self.glDrawElementsBaseVertex_p.load(RELAX).is_null()
        }
        /// [glDrawElementsIndirect](http://docs.gl/gl4/glDrawElementsIndirect)(mode, type_, indirect)
        /// * `mode` group: PrimitiveType
        /// * `type_` group: DrawElementsType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawElementsIndirect(
            &self,
            mode: GLenum,
            type_: GLenum,
            indirect: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DrawElementsIndirect({:#X}, {:#X}, {:p});",
                    mode,
                    type_,
                    indirect
                );
            }
            let out = call_atomic_ptr_3arg(
                "glDrawElementsIndirect",
                &self.glDrawElementsIndirect_p,
                mode,
                type_,
                indirect,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawElementsIndirect");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawElementsIndirect_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawElementsIndirect\0",
                &self.glDrawElementsIndirect_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawElementsIndirect_is_loaded(&self) -> bool {
            !self.glDrawElementsIndirect_p.load(RELAX).is_null()
        }
        /// [glDrawElementsInstanced](http://docs.gl/gl4/glDrawElementsInstanced)(mode, count, type_, indices, instancecount)
        /// * `mode` group: PrimitiveType
        /// * `type_` group: DrawElementsType
        /// * `indices` len: COMPSIZE(count,type)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawElementsInstanced(
            &self,
            mode: GLenum,
            count: GLsizei,
            type_: GLenum,
            indices: *const c_void,
            instancecount: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DrawElementsInstanced({:#X}, {:?}, {:#X}, {:p}, {:?});",
                    mode,
                    count,
                    type_,
                    indices,
                    instancecount
                );
            }
            let out = call_atomic_ptr_5arg(
                "glDrawElementsInstanced",
                &self.glDrawElementsInstanced_p,
                mode,
                count,
                type_,
                indices,
                instancecount,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawElementsInstanced");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawElementsInstanced_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawElementsInstanced\0",
                &self.glDrawElementsInstanced_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawElementsInstanced_is_loaded(&self) -> bool {
            !self.glDrawElementsInstanced_p.load(RELAX).is_null()
        }
        /// [glDrawElementsInstancedARB](http://docs.gl/gl4/glDrawElementsInstancedARB)(mode, count, type_, indices, primcount)
        /// * `mode` group: PrimitiveType
        /// * `type_` group: DrawElementsType
        /// * `indices` len: COMPSIZE(count,type)
        /// * alias of: [`glDrawElementsInstanced`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawElementsInstancedARB(
            &self,
            mode: GLenum,
            count: GLsizei,
            type_: GLenum,
            indices: *const c_void,
            primcount: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DrawElementsInstancedARB({:#X}, {:?}, {:#X}, {:p}, {:?});",
                    mode,
                    count,
                    type_,
                    indices,
                    primcount
                );
            }
            let out = call_atomic_ptr_5arg(
                "glDrawElementsInstancedARB",
                &self.glDrawElementsInstancedARB_p,
                mode,
                count,
                type_,
                indices,
                primcount,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawElementsInstancedARB");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn DrawElementsInstancedARB_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawElementsInstancedARB\0",
                &self.glDrawElementsInstancedARB_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn DrawElementsInstancedARB_is_loaded(&self) -> bool {
            !self.glDrawElementsInstancedARB_p.load(RELAX).is_null()
        }
        /// [glDrawElementsInstancedBaseInstance](http://docs.gl/gl4/glDrawElementsInstancedBaseInstance)(mode, count, type_, indices, instancecount, baseinstance)
        /// * `mode` group: PrimitiveType
        /// * `type_` group: PrimitiveType
        /// * `indices` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawElementsInstancedBaseInstance(
            &self,
            mode: GLenum,
            count: GLsizei,
            type_: GLenum,
            indices: *const c_void,
            instancecount: GLsizei,
            baseinstance: GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DrawElementsInstancedBaseInstance({:#X}, {:?}, {:#X}, {:p}, {:?}, {:?});", mode, count, type_, indices, instancecount, baseinstance);
            }
            let out = call_atomic_ptr_6arg(
                "glDrawElementsInstancedBaseInstance",
                &self.glDrawElementsInstancedBaseInstance_p,
                mode,
                count,
                type_,
                indices,
                instancecount,
                baseinstance,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawElementsInstancedBaseInstance");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawElementsInstancedBaseInstance_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawElementsInstancedBaseInstance\0",
                &self.glDrawElementsInstancedBaseInstance_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawElementsInstancedBaseInstance_is_loaded(&self) -> bool {
            !self
                .glDrawElementsInstancedBaseInstance_p
                .load(RELAX)
                .is_null()
        }
        /// [glDrawElementsInstancedBaseVertex](http://docs.gl/gl4/glDrawElementsInstancedBaseVertex)(mode, count, type_, indices, instancecount, basevertex)
        /// * `mode` group: PrimitiveType
        /// * `type_` group: DrawElementsType
        /// * `indices` len: COMPSIZE(count,type)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawElementsInstancedBaseVertex(
            &self,
            mode: GLenum,
            count: GLsizei,
            type_: GLenum,
            indices: *const c_void,
            instancecount: GLsizei,
            basevertex: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DrawElementsInstancedBaseVertex({:#X}, {:?}, {:#X}, {:p}, {:?}, {:?});", mode, count, type_, indices, instancecount, basevertex);
            }
            let out = call_atomic_ptr_6arg(
                "glDrawElementsInstancedBaseVertex",
                &self.glDrawElementsInstancedBaseVertex_p,
                mode,
                count,
                type_,
                indices,
                instancecount,
                basevertex,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawElementsInstancedBaseVertex");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawElementsInstancedBaseVertex_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawElementsInstancedBaseVertex\0",
                &self.glDrawElementsInstancedBaseVertex_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawElementsInstancedBaseVertex_is_loaded(&self) -> bool {
            !self
                .glDrawElementsInstancedBaseVertex_p
                .load(RELAX)
                .is_null()
        }
        /// [glDrawElementsInstancedBaseVertexBaseInstance](http://docs.gl/gl4/glDrawElementsInstancedBaseVertexBaseInstance)(mode, count, type_, indices, instancecount, basevertex, baseinstance)
        /// * `mode` group: PrimitiveType
        /// * `type_` group: DrawElementsType
        /// * `indices` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawElementsInstancedBaseVertexBaseInstance(
            &self,
            mode: GLenum,
            count: GLsizei,
            type_: GLenum,
            indices: *const c_void,
            instancecount: GLsizei,
            basevertex: GLint,
            baseinstance: GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DrawElementsInstancedBaseVertexBaseInstance({:#X}, {:?}, {:#X}, {:p}, {:?}, {:?}, {:?});", mode, count, type_, indices, instancecount, basevertex, baseinstance);
            }
            let out = call_atomic_ptr_7arg(
                "glDrawElementsInstancedBaseVertexBaseInstance",
                &self.glDrawElementsInstancedBaseVertexBaseInstance_p,
                mode,
                count,
                type_,
                indices,
                instancecount,
                basevertex,
                baseinstance,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawElementsInstancedBaseVertexBaseInstance");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawElementsInstancedBaseVertexBaseInstance_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawElementsInstancedBaseVertexBaseInstance\0",
                &self.glDrawElementsInstancedBaseVertexBaseInstance_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawElementsInstancedBaseVertexBaseInstance_is_loaded(&self) -> bool {
            !self
                .glDrawElementsInstancedBaseVertexBaseInstance_p
                .load(RELAX)
                .is_null()
        }
        /// [glDrawRangeElements](http://docs.gl/gl4/glDrawRangeElements)(mode, start, end, count, type_, indices)
        /// * `mode` group: PrimitiveType
        /// * `type_` group: DrawElementsType
        /// * `indices` len: COMPSIZE(count,type)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawRangeElements(
            &self,
            mode: GLenum,
            start: GLuint,
            end: GLuint,
            count: GLsizei,
            type_: GLenum,
            indices: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DrawRangeElements({:#X}, {:?}, {:?}, {:?}, {:#X}, {:p});",
                    mode,
                    start,
                    end,
                    count,
                    type_,
                    indices
                );
            }
            let out = call_atomic_ptr_6arg(
                "glDrawRangeElements",
                &self.glDrawRangeElements_p,
                mode,
                start,
                end,
                count,
                type_,
                indices,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawRangeElements");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawRangeElements_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawRangeElements\0",
                &self.glDrawRangeElements_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawRangeElements_is_loaded(&self) -> bool {
            !self.glDrawRangeElements_p.load(RELAX).is_null()
        }
        /// [glDrawRangeElementsBaseVertex](http://docs.gl/gl4/glDrawRangeElementsBaseVertex)(mode, start, end, count, type_, indices, basevertex)
        /// * `mode` group: PrimitiveType
        /// * `type_` group: DrawElementsType
        /// * `indices` len: COMPSIZE(count,type)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawRangeElementsBaseVertex(
            &self,
            mode: GLenum,
            start: GLuint,
            end: GLuint,
            count: GLsizei,
            type_: GLenum,
            indices: *const c_void,
            basevertex: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DrawRangeElementsBaseVertex({:#X}, {:?}, {:?}, {:?}, {:#X}, {:p}, {:?});", mode, start, end, count, type_, indices, basevertex);
            }
            let out = call_atomic_ptr_7arg(
                "glDrawRangeElementsBaseVertex",
                &self.glDrawRangeElementsBaseVertex_p,
                mode,
                start,
                end,
                count,
                type_,
                indices,
                basevertex,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawRangeElementsBaseVertex");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawRangeElementsBaseVertex_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawRangeElementsBaseVertex\0",
                &self.glDrawRangeElementsBaseVertex_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawRangeElementsBaseVertex_is_loaded(&self) -> bool {
            !self.glDrawRangeElementsBaseVertex_p.load(RELAX).is_null()
        }
        /// [glDrawTransformFeedback](http://docs.gl/gl4/glDrawTransformFeedback)(mode, id)
        /// * `mode` group: PrimitiveType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawTransformFeedback(&self, mode: GLenum, id: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.DrawTransformFeedback({:#X}, {:?});", mode, id);
            }
            let out = call_atomic_ptr_2arg(
                "glDrawTransformFeedback",
                &self.glDrawTransformFeedback_p,
                mode,
                id,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawTransformFeedback");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawTransformFeedback_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawTransformFeedback\0",
                &self.glDrawTransformFeedback_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawTransformFeedback_is_loaded(&self) -> bool {
            !self.glDrawTransformFeedback_p.load(RELAX).is_null()
        }
        /// [glDrawTransformFeedbackInstanced](http://docs.gl/gl4/glDrawTransformFeedbackInstanced)(mode, id, instancecount)
        /// * `mode` group: PrimitiveType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawTransformFeedbackInstanced(
            &self,
            mode: GLenum,
            id: GLuint,
            instancecount: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DrawTransformFeedbackInstanced({:#X}, {:?}, {:?});",
                    mode,
                    id,
                    instancecount
                );
            }
            let out = call_atomic_ptr_3arg(
                "glDrawTransformFeedbackInstanced",
                &self.glDrawTransformFeedbackInstanced_p,
                mode,
                id,
                instancecount,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawTransformFeedbackInstanced");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawTransformFeedbackInstanced_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawTransformFeedbackInstanced\0",
                &self.glDrawTransformFeedbackInstanced_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawTransformFeedbackInstanced_is_loaded(&self) -> bool {
            !self
                .glDrawTransformFeedbackInstanced_p
                .load(RELAX)
                .is_null()
        }
        /// [glDrawTransformFeedbackStream](http://docs.gl/gl4/glDrawTransformFeedbackStream)(mode, id, stream)
        /// * `mode` group: PrimitiveType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawTransformFeedbackStream(&self, mode: GLenum, id: GLuint, stream: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DrawTransformFeedbackStream({:#X}, {:?}, {:?});",
                    mode,
                    id,
                    stream
                );
            }
            let out = call_atomic_ptr_3arg(
                "glDrawTransformFeedbackStream",
                &self.glDrawTransformFeedbackStream_p,
                mode,
                id,
                stream,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawTransformFeedbackStream");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawTransformFeedbackStream_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawTransformFeedbackStream\0",
                &self.glDrawTransformFeedbackStream_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawTransformFeedbackStream_is_loaded(&self) -> bool {
            !self.glDrawTransformFeedbackStream_p.load(RELAX).is_null()
        }
        /// [glDrawTransformFeedbackStreamInstanced](http://docs.gl/gl4/glDrawTransformFeedbackStreamInstanced)(mode, id, stream, instancecount)
        /// * `mode` group: PrimitiveType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn DrawTransformFeedbackStreamInstanced(
            &self,
            mode: GLenum,
            id: GLuint,
            stream: GLuint,
            instancecount: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.DrawTransformFeedbackStreamInstanced({:#X}, {:?}, {:?}, {:?});",
                    mode,
                    id,
                    stream,
                    instancecount
                );
            }
            let out = call_atomic_ptr_4arg(
                "glDrawTransformFeedbackStreamInstanced",
                &self.glDrawTransformFeedbackStreamInstanced_p,
                mode,
                id,
                stream,
                instancecount,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glDrawTransformFeedbackStreamInstanced");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn DrawTransformFeedbackStreamInstanced_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glDrawTransformFeedbackStreamInstanced\0",
                &self.glDrawTransformFeedbackStreamInstanced_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn DrawTransformFeedbackStreamInstanced_is_loaded(&self) -> bool {
            !self
                .glDrawTransformFeedbackStreamInstanced_p
                .load(RELAX)
                .is_null()
        }
        /// [glEnable](http://docs.gl/gl4/glEnable)(cap)
        /// * `cap` group: EnableCap
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn Enable(&self, cap: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.Enable({:#X});", cap);
            }
            let out = call_atomic_ptr_1arg("glEnable", &self.glEnable_p, cap);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glEnable");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn Enable_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glEnable\0", &self.glEnable_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn Enable_is_loaded(&self) -> bool {
            !self.glEnable_p.load(RELAX).is_null()
        }
        /// [glEnableIndexedEXT](http://docs.gl/gl4/glEnableIndexedEXT)(target, index)
        /// * `target` group: EnableCap
        /// * alias of: [`glEnablei`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn EnableIndexedEXT(&self, target: GLenum, index: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.EnableIndexedEXT({:#X}, {:?});", target, index);
            }
            let out = call_atomic_ptr_2arg(
                "glEnableIndexedEXT",
                &self.glEnableIndexedEXT_p,
                target,
                index,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glEnableIndexedEXT");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn EnableIndexedEXT_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glEnableIndexedEXT\0",
                &self.glEnableIndexedEXT_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn EnableIndexedEXT_is_loaded(&self) -> bool {
            !self.glEnableIndexedEXT_p.load(RELAX).is_null()
        }
        /// [glEnableVertexArrayAttrib](http://docs.gl/gl4/glEnableVertexArrayAttrib)(vaobj, index)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn EnableVertexArrayAttrib(&self, vaobj: GLuint, index: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.EnableVertexArrayAttrib({:?}, {:?});",
                    vaobj,
                    index
                );
            }
            let out = call_atomic_ptr_2arg(
                "glEnableVertexArrayAttrib",
                &self.glEnableVertexArrayAttrib_p,
                vaobj,
                index,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glEnableVertexArrayAttrib");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn EnableVertexArrayAttrib_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glEnableVertexArrayAttrib\0",
                &self.glEnableVertexArrayAttrib_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn EnableVertexArrayAttrib_is_loaded(&self) -> bool {
            !self.glEnableVertexArrayAttrib_p.load(RELAX).is_null()
        }
        /// [glEnableVertexAttribArray](http://docs.gl/gl4/glEnableVertexAttribArray)(index)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn EnableVertexAttribArray(&self, index: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.EnableVertexAttribArray({:?});", index);
            }
            let out = call_atomic_ptr_1arg(
                "glEnableVertexAttribArray",
                &self.glEnableVertexAttribArray_p,
                index,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glEnableVertexAttribArray");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn EnableVertexAttribArray_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glEnableVertexAttribArray\0",
                &self.glEnableVertexAttribArray_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn EnableVertexAttribArray_is_loaded(&self) -> bool {
            !self.glEnableVertexAttribArray_p.load(RELAX).is_null()
        }
        /// [glEnablei](http://docs.gl/gl4/glEnable)(target, index)
        /// * `target` group: EnableCap
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn Enablei(&self, target: GLenum, index: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.Enablei({:#X}, {:?});", target, index);
            }
            let out = call_atomic_ptr_2arg("glEnablei", &self.glEnablei_p, target, index);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glEnablei");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn Enablei_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glEnablei\0", &self.glEnablei_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn Enablei_is_loaded(&self) -> bool {
            !self.glEnablei_p.load(RELAX).is_null()
        }
        /// [glEndConditionalRender](http://docs.gl/gl4/glEndConditionalRender)()
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn EndConditionalRender(&self) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.EndConditionalRender();",);
            }
            let out =
                call_atomic_ptr_0arg("glEndConditionalRender", &self.glEndConditionalRender_p);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glEndConditionalRender");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn EndConditionalRender_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glEndConditionalRender\0",
                &self.glEndConditionalRender_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn EndConditionalRender_is_loaded(&self) -> bool {
            !self.glEndConditionalRender_p.load(RELAX).is_null()
        }
        /// [glEndQuery](http://docs.gl/gl4/glEndQuery)(target)
        /// * `target` group: QueryTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn EndQuery(&self, target: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.EndQuery({:#X});", target);
            }
            let out = call_atomic_ptr_1arg("glEndQuery", &self.glEndQuery_p, target);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glEndQuery");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn EndQuery_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glEndQuery\0", &self.glEndQuery_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn EndQuery_is_loaded(&self) -> bool {
            !self.glEndQuery_p.load(RELAX).is_null()
        }
        /// [glEndQueryIndexed](http://docs.gl/gl4/glEndQueryIndexed)(target, index)
        /// * `target` group: QueryTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn EndQueryIndexed(&self, target: GLenum, index: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.EndQueryIndexed({:#X}, {:?});", target, index);
            }
            let out = call_atomic_ptr_2arg(
                "glEndQueryIndexed",
                &self.glEndQueryIndexed_p,
                target,
                index,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glEndQueryIndexed");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn EndQueryIndexed_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glEndQueryIndexed\0",
                &self.glEndQueryIndexed_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn EndQueryIndexed_is_loaded(&self) -> bool {
            !self.glEndQueryIndexed_p.load(RELAX).is_null()
        }
        /// [glEndTransformFeedback](http://docs.gl/gl4/glEndTransformFeedback)()
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn EndTransformFeedback(&self) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.EndTransformFeedback();",);
            }
            let out =
                call_atomic_ptr_0arg("glEndTransformFeedback", &self.glEndTransformFeedback_p);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glEndTransformFeedback");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn EndTransformFeedback_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glEndTransformFeedback\0",
                &self.glEndTransformFeedback_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn EndTransformFeedback_is_loaded(&self) -> bool {
            !self.glEndTransformFeedback_p.load(RELAX).is_null()
        }
        /// [glFenceSync](http://docs.gl/gl4/glFenceSync)(condition, flags)
        /// * `condition` group: SyncCondition
        /// * `flags` group: SyncBehaviorFlags
        /// * return value group: sync
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn FenceSync(&self, condition: GLenum, flags: GLbitfield) -> GLsync {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.FenceSync({:#X}, {:?});", condition, flags);
            }
            let out = call_atomic_ptr_2arg("glFenceSync", &self.glFenceSync_p, condition, flags);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glFenceSync");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn FenceSync_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glFenceSync\0", &self.glFenceSync_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn FenceSync_is_loaded(&self) -> bool {
            !self.glFenceSync_p.load(RELAX).is_null()
        }
        /// [glFinish](http://docs.gl/gl4/glFinish)()
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn Finish(&self) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.Finish();",);
            }
            let out = call_atomic_ptr_0arg("glFinish", &self.glFinish_p);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glFinish");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn Finish_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glFinish\0", &self.glFinish_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn Finish_is_loaded(&self) -> bool {
            !self.glFinish_p.load(RELAX).is_null()
        }
        /// [glFlush](http://docs.gl/gl4/glFlush)()
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn Flush(&self) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.Flush();",);
            }
            let out = call_atomic_ptr_0arg("glFlush", &self.glFlush_p);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glFlush");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn Flush_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glFlush\0", &self.glFlush_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn Flush_is_loaded(&self) -> bool {
            !self.glFlush_p.load(RELAX).is_null()
        }
        /// [glFlushMappedBufferRange](http://docs.gl/gl4/glFlushMappedBufferRange)(target, offset, length)
        /// * `target` group: BufferTargetARB
        /// * `offset` group: BufferOffset
        /// * `length` group: BufferSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn FlushMappedBufferRange(
            &self,
            target: GLenum,
            offset: GLintptr,
            length: GLsizeiptr,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.FlushMappedBufferRange({:#X}, {:?}, {:?});",
                    target,
                    offset,
                    length
                );
            }
            let out = call_atomic_ptr_3arg(
                "glFlushMappedBufferRange",
                &self.glFlushMappedBufferRange_p,
                target,
                offset,
                length,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glFlushMappedBufferRange");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn FlushMappedBufferRange_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glFlushMappedBufferRange\0",
                &self.glFlushMappedBufferRange_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn FlushMappedBufferRange_is_loaded(&self) -> bool {
            !self.glFlushMappedBufferRange_p.load(RELAX).is_null()
        }
        /// [glFlushMappedNamedBufferRange](http://docs.gl/gl4/glFlushMappedNamedBufferRange)(buffer, offset, length)
        /// * `length` group: BufferSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn FlushMappedNamedBufferRange(
            &self,
            buffer: GLuint,
            offset: GLintptr,
            length: GLsizeiptr,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.FlushMappedNamedBufferRange({:?}, {:?}, {:?});",
                    buffer,
                    offset,
                    length
                );
            }
            let out = call_atomic_ptr_3arg(
                "glFlushMappedNamedBufferRange",
                &self.glFlushMappedNamedBufferRange_p,
                buffer,
                offset,
                length,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glFlushMappedNamedBufferRange");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn FlushMappedNamedBufferRange_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glFlushMappedNamedBufferRange\0",
                &self.glFlushMappedNamedBufferRange_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn FlushMappedNamedBufferRange_is_loaded(&self) -> bool {
            !self.glFlushMappedNamedBufferRange_p.load(RELAX).is_null()
        }
        /// [glFramebufferParameteri](http://docs.gl/gl4/glFramebufferParameter)(target, pname, param)
        /// * `target` group: FramebufferTarget
        /// * `pname` group: FramebufferParameterName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn FramebufferParameteri(&self, target: GLenum, pname: GLenum, param: GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.FramebufferParameteri({:#X}, {:#X}, {:?});",
                    target,
                    pname,
                    param
                );
            }
            let out = call_atomic_ptr_3arg(
                "glFramebufferParameteri",
                &self.glFramebufferParameteri_p,
                target,
                pname,
                param,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glFramebufferParameteri");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn FramebufferParameteri_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glFramebufferParameteri\0",
                &self.glFramebufferParameteri_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn FramebufferParameteri_is_loaded(&self) -> bool {
            !self.glFramebufferParameteri_p.load(RELAX).is_null()
        }
        /// [glFramebufferRenderbuffer](http://docs.gl/gl4/glFramebufferRenderbuffer)(target, attachment, renderbuffertarget, renderbuffer)
        /// * `target` group: FramebufferTarget
        /// * `attachment` group: FramebufferAttachment
        /// * `renderbuffertarget` group: RenderbufferTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn FramebufferRenderbuffer(
            &self,
            target: GLenum,
            attachment: GLenum,
            renderbuffertarget: GLenum,
            renderbuffer: GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.FramebufferRenderbuffer({:#X}, {:#X}, {:#X}, {:?});",
                    target,
                    attachment,
                    renderbuffertarget,
                    renderbuffer
                );
            }
            let out = call_atomic_ptr_4arg(
                "glFramebufferRenderbuffer",
                &self.glFramebufferRenderbuffer_p,
                target,
                attachment,
                renderbuffertarget,
                renderbuffer,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glFramebufferRenderbuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn FramebufferRenderbuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glFramebufferRenderbuffer\0",
                &self.glFramebufferRenderbuffer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn FramebufferRenderbuffer_is_loaded(&self) -> bool {
            !self.glFramebufferRenderbuffer_p.load(RELAX).is_null()
        }
        /// [glFramebufferTexture](http://docs.gl/gl4/glFramebufferTexture)(target, attachment, texture, level)
        /// * `target` group: FramebufferTarget
        /// * `attachment` group: FramebufferAttachment
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn FramebufferTexture(
            &self,
            target: GLenum,
            attachment: GLenum,
            texture: GLuint,
            level: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.FramebufferTexture({:#X}, {:#X}, {:?}, {:?});",
                    target,
                    attachment,
                    texture,
                    level
                );
            }
            let out = call_atomic_ptr_4arg(
                "glFramebufferTexture",
                &self.glFramebufferTexture_p,
                target,
                attachment,
                texture,
                level,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glFramebufferTexture");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn FramebufferTexture_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glFramebufferTexture\0",
                &self.glFramebufferTexture_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn FramebufferTexture_is_loaded(&self) -> bool {
            !self.glFramebufferTexture_p.load(RELAX).is_null()
        }
        /// [glFramebufferTexture1D](http://docs.gl/gl4/glFramebufferTexture1D)(target, attachment, textarget, texture, level)
        /// * `target` group: FramebufferTarget
        /// * `attachment` group: FramebufferAttachment
        /// * `textarget` group: TextureTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn FramebufferTexture1D(
            &self,
            target: GLenum,
            attachment: GLenum,
            textarget: GLenum,
            texture: GLuint,
            level: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.FramebufferTexture1D({:#X}, {:#X}, {:#X}, {:?}, {:?});",
                    target,
                    attachment,
                    textarget,
                    texture,
                    level
                );
            }
            let out = call_atomic_ptr_5arg(
                "glFramebufferTexture1D",
                &self.glFramebufferTexture1D_p,
                target,
                attachment,
                textarget,
                texture,
                level,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glFramebufferTexture1D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn FramebufferTexture1D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glFramebufferTexture1D\0",
                &self.glFramebufferTexture1D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn FramebufferTexture1D_is_loaded(&self) -> bool {
            !self.glFramebufferTexture1D_p.load(RELAX).is_null()
        }
        /// [glFramebufferTexture2D](http://docs.gl/gl4/glFramebufferTexture2D)(target, attachment, textarget, texture, level)
        /// * `target` group: FramebufferTarget
        /// * `attachment` group: FramebufferAttachment
        /// * `textarget` group: TextureTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn FramebufferTexture2D(
            &self,
            target: GLenum,
            attachment: GLenum,
            textarget: GLenum,
            texture: GLuint,
            level: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.FramebufferTexture2D({:#X}, {:#X}, {:#X}, {:?}, {:?});",
                    target,
                    attachment,
                    textarget,
                    texture,
                    level
                );
            }
            let out = call_atomic_ptr_5arg(
                "glFramebufferTexture2D",
                &self.glFramebufferTexture2D_p,
                target,
                attachment,
                textarget,
                texture,
                level,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glFramebufferTexture2D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn FramebufferTexture2D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glFramebufferTexture2D\0",
                &self.glFramebufferTexture2D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn FramebufferTexture2D_is_loaded(&self) -> bool {
            !self.glFramebufferTexture2D_p.load(RELAX).is_null()
        }
        /// [glFramebufferTexture3D](http://docs.gl/gl4/glFramebufferTexture3D)(target, attachment, textarget, texture, level, zoffset)
        /// * `target` group: FramebufferTarget
        /// * `attachment` group: FramebufferAttachment
        /// * `textarget` group: TextureTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn FramebufferTexture3D(
            &self,
            target: GLenum,
            attachment: GLenum,
            textarget: GLenum,
            texture: GLuint,
            level: GLint,
            zoffset: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.FramebufferTexture3D({:#X}, {:#X}, {:#X}, {:?}, {:?}, {:?});",
                    target,
                    attachment,
                    textarget,
                    texture,
                    level,
                    zoffset
                );
            }
            let out = call_atomic_ptr_6arg(
                "glFramebufferTexture3D",
                &self.glFramebufferTexture3D_p,
                target,
                attachment,
                textarget,
                texture,
                level,
                zoffset,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glFramebufferTexture3D");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn FramebufferTexture3D_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glFramebufferTexture3D\0",
                &self.glFramebufferTexture3D_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn FramebufferTexture3D_is_loaded(&self) -> bool {
            !self.glFramebufferTexture3D_p.load(RELAX).is_null()
        }
        /// [glFramebufferTextureLayer](http://docs.gl/gl4/glFramebufferTextureLayer)(target, attachment, texture, level, layer)
        /// * `target` group: FramebufferTarget
        /// * `attachment` group: FramebufferAttachment
        /// * `texture` group: Texture
        /// * `level` group: CheckedInt32
        /// * `layer` group: CheckedInt32
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn FramebufferTextureLayer(
            &self,
            target: GLenum,
            attachment: GLenum,
            texture: GLuint,
            level: GLint,
            layer: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.FramebufferTextureLayer({:#X}, {:#X}, {:?}, {:?}, {:?});",
                    target,
                    attachment,
                    texture,
                    level,
                    layer
                );
            }
            let out = call_atomic_ptr_5arg(
                "glFramebufferTextureLayer",
                &self.glFramebufferTextureLayer_p,
                target,
                attachment,
                texture,
                level,
                layer,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glFramebufferTextureLayer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn FramebufferTextureLayer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glFramebufferTextureLayer\0",
                &self.glFramebufferTextureLayer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn FramebufferTextureLayer_is_loaded(&self) -> bool {
            !self.glFramebufferTextureLayer_p.load(RELAX).is_null()
        }
        /// [glFrontFace](http://docs.gl/gl4/glFrontFace)(mode)
        /// * `mode` group: FrontFaceDirection
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn FrontFace(&self, mode: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.FrontFace({:#X});", mode);
            }
            let out = call_atomic_ptr_1arg("glFrontFace", &self.glFrontFace_p, mode);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glFrontFace");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn FrontFace_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glFrontFace\0", &self.glFrontFace_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn FrontFace_is_loaded(&self) -> bool {
            !self.glFrontFace_p.load(RELAX).is_null()
        }
        /// [glGenBuffers](http://docs.gl/gl4/glGenBuffers)(n, buffers)
        /// * `buffers` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GenBuffers(&self, n: GLsizei, buffers: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GenBuffers({:?}, {:p});", n, buffers);
            }
            let out = call_atomic_ptr_2arg("glGenBuffers", &self.glGenBuffers_p, n, buffers);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGenBuffers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GenBuffers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGenBuffers\0", &self.glGenBuffers_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GenBuffers_is_loaded(&self) -> bool {
            !self.glGenBuffers_p.load(RELAX).is_null()
        }
        /// [glGenFramebuffers](http://docs.gl/gl4/glGenFramebuffers)(n, framebuffers)
        /// * `framebuffers` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GenFramebuffers(&self, n: GLsizei, framebuffers: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GenFramebuffers({:?}, {:p});", n, framebuffers);
            }
            let out = call_atomic_ptr_2arg(
                "glGenFramebuffers",
                &self.glGenFramebuffers_p,
                n,
                framebuffers,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGenFramebuffers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GenFramebuffers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGenFramebuffers\0",
                &self.glGenFramebuffers_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GenFramebuffers_is_loaded(&self) -> bool {
            !self.glGenFramebuffers_p.load(RELAX).is_null()
        }
        /// [glGenProgramPipelines](http://docs.gl/gl4/glGenProgramPipelines)(n, pipelines)
        /// * `pipelines` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GenProgramPipelines(&self, n: GLsizei, pipelines: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GenProgramPipelines({:?}, {:p});", n, pipelines);
            }
            let out = call_atomic_ptr_2arg(
                "glGenProgramPipelines",
                &self.glGenProgramPipelines_p,
                n,
                pipelines,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGenProgramPipelines");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GenProgramPipelines_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGenProgramPipelines\0",
                &self.glGenProgramPipelines_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GenProgramPipelines_is_loaded(&self) -> bool {
            !self.glGenProgramPipelines_p.load(RELAX).is_null()
        }
        /// [glGenQueries](http://docs.gl/gl4/glGenQueries)(n, ids)
        /// * `ids` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GenQueries(&self, n: GLsizei, ids: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GenQueries({:?}, {:p});", n, ids);
            }
            let out = call_atomic_ptr_2arg("glGenQueries", &self.glGenQueries_p, n, ids);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGenQueries");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GenQueries_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGenQueries\0", &self.glGenQueries_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GenQueries_is_loaded(&self) -> bool {
            !self.glGenQueries_p.load(RELAX).is_null()
        }
        /// [glGenRenderbuffers](http://docs.gl/gl4/glGenRenderbuffers)(n, renderbuffers)
        /// * `renderbuffers` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GenRenderbuffers(&self, n: GLsizei, renderbuffers: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GenRenderbuffers({:?}, {:p});", n, renderbuffers);
            }
            let out = call_atomic_ptr_2arg(
                "glGenRenderbuffers",
                &self.glGenRenderbuffers_p,
                n,
                renderbuffers,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGenRenderbuffers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GenRenderbuffers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGenRenderbuffers\0",
                &self.glGenRenderbuffers_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GenRenderbuffers_is_loaded(&self) -> bool {
            !self.glGenRenderbuffers_p.load(RELAX).is_null()
        }
        /// [glGenSamplers](http://docs.gl/gl4/glGenSamplers)(count, samplers)
        /// * `samplers` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GenSamplers(&self, count: GLsizei, samplers: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GenSamplers({:?}, {:p});", count, samplers);
            }
            let out = call_atomic_ptr_2arg("glGenSamplers", &self.glGenSamplers_p, count, samplers);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGenSamplers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GenSamplers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGenSamplers\0", &self.glGenSamplers_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GenSamplers_is_loaded(&self) -> bool {
            !self.glGenSamplers_p.load(RELAX).is_null()
        }
        /// [glGenTextures](http://docs.gl/gl4/glGenTextures)(n, textures)
        /// * `textures` group: Texture
        /// * `textures` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GenTextures(&self, n: GLsizei, textures: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GenTextures({:?}, {:p});", n, textures);
            }
            let out = call_atomic_ptr_2arg("glGenTextures", &self.glGenTextures_p, n, textures);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGenTextures");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GenTextures_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGenTextures\0", &self.glGenTextures_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GenTextures_is_loaded(&self) -> bool {
            !self.glGenTextures_p.load(RELAX).is_null()
        }
        /// [glGenTransformFeedbacks](http://docs.gl/gl4/glGenTransformFeedbacks)(n, ids)
        /// * `ids` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GenTransformFeedbacks(&self, n: GLsizei, ids: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GenTransformFeedbacks({:?}, {:p});", n, ids);
            }
            let out = call_atomic_ptr_2arg(
                "glGenTransformFeedbacks",
                &self.glGenTransformFeedbacks_p,
                n,
                ids,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGenTransformFeedbacks");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GenTransformFeedbacks_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGenTransformFeedbacks\0",
                &self.glGenTransformFeedbacks_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GenTransformFeedbacks_is_loaded(&self) -> bool {
            !self.glGenTransformFeedbacks_p.load(RELAX).is_null()
        }
        /// [glGenVertexArrays](http://docs.gl/gl4/glGenVertexArrays)(n, arrays)
        /// * `arrays` len: n
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GenVertexArrays(&self, n: GLsizei, arrays: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GenVertexArrays({:?}, {:p});", n, arrays);
            }
            let out =
                call_atomic_ptr_2arg("glGenVertexArrays", &self.glGenVertexArrays_p, n, arrays);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGenVertexArrays");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GenVertexArrays_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGenVertexArrays\0",
                &self.glGenVertexArrays_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GenVertexArrays_is_loaded(&self) -> bool {
            !self.glGenVertexArrays_p.load(RELAX).is_null()
        }
        /// [glGenerateMipmap](http://docs.gl/gl4/glGenerateMipmap)(target)
        /// * `target` group: TextureTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GenerateMipmap(&self, target: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GenerateMipmap({:#X});", target);
            }
            let out = call_atomic_ptr_1arg("glGenerateMipmap", &self.glGenerateMipmap_p, target);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGenerateMipmap");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GenerateMipmap_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGenerateMipmap\0",
                &self.glGenerateMipmap_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GenerateMipmap_is_loaded(&self) -> bool {
            !self.glGenerateMipmap_p.load(RELAX).is_null()
        }
        /// [glGenerateTextureMipmap](http://docs.gl/gl4/glGenerateTextureMipmap)(texture)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GenerateTextureMipmap(&self, texture: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GenerateTextureMipmap({:?});", texture);
            }
            let out = call_atomic_ptr_1arg(
                "glGenerateTextureMipmap",
                &self.glGenerateTextureMipmap_p,
                texture,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGenerateTextureMipmap");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GenerateTextureMipmap_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGenerateTextureMipmap\0",
                &self.glGenerateTextureMipmap_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GenerateTextureMipmap_is_loaded(&self) -> bool {
            !self.glGenerateTextureMipmap_p.load(RELAX).is_null()
        }
        /// [glGetActiveAtomicCounterBufferiv](http://docs.gl/gl4/glGetActiveAtomicCounterBuffer)(program, bufferIndex, pname, params)
        /// * `pname` group: AtomicCounterBufferPName
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetActiveAtomicCounterBufferiv(
            &self,
            program: GLuint,
            bufferIndex: GLuint,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetActiveAtomicCounterBufferiv({:?}, {:?}, {:#X}, {:p});",
                    program,
                    bufferIndex,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetActiveAtomicCounterBufferiv",
                &self.glGetActiveAtomicCounterBufferiv_p,
                program,
                bufferIndex,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetActiveAtomicCounterBufferiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetActiveAtomicCounterBufferiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetActiveAtomicCounterBufferiv\0",
                &self.glGetActiveAtomicCounterBufferiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetActiveAtomicCounterBufferiv_is_loaded(&self) -> bool {
            !self
                .glGetActiveAtomicCounterBufferiv_p
                .load(RELAX)
                .is_null()
        }
        /// [glGetActiveAttrib](http://docs.gl/gl4/glGetActiveAttrib)(program, index, bufSize, length, size, type_, name)
        /// * `length` len: 1
        /// * `size` len: 1
        /// * `type_` group: AttributeType
        /// * `type_` len: 1
        /// * `name` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetActiveAttrib(
            &self,
            program: GLuint,
            index: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            size: *mut GLint,
            type_: *mut GLenum,
            name: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetActiveAttrib({:?}, {:?}, {:?}, {:p}, {:p}, {:p}, {:p});",
                    program,
                    index,
                    bufSize,
                    length,
                    size,
                    type_,
                    name
                );
            }
            let out = call_atomic_ptr_7arg(
                "glGetActiveAttrib",
                &self.glGetActiveAttrib_p,
                program,
                index,
                bufSize,
                length,
                size,
                type_,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetActiveAttrib");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetActiveAttrib_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetActiveAttrib\0",
                &self.glGetActiveAttrib_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetActiveAttrib_is_loaded(&self) -> bool {
            !self.glGetActiveAttrib_p.load(RELAX).is_null()
        }
        /// [glGetActiveSubroutineName](http://docs.gl/gl4/glGetActiveSubroutineName)(program, shadertype, index, bufSize, length, name)
        /// * `shadertype` group: ShaderType
        /// * `length` len: 1
        /// * `name` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetActiveSubroutineName(
            &self,
            program: GLuint,
            shadertype: GLenum,
            index: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            name: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetActiveSubroutineName({:?}, {:#X}, {:?}, {:?}, {:p}, {:p});",
                    program,
                    shadertype,
                    index,
                    bufSize,
                    length,
                    name
                );
            }
            let out = call_atomic_ptr_6arg(
                "glGetActiveSubroutineName",
                &self.glGetActiveSubroutineName_p,
                program,
                shadertype,
                index,
                bufSize,
                length,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetActiveSubroutineName");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetActiveSubroutineName_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetActiveSubroutineName\0",
                &self.glGetActiveSubroutineName_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetActiveSubroutineName_is_loaded(&self) -> bool {
            !self.glGetActiveSubroutineName_p.load(RELAX).is_null()
        }
        /// [glGetActiveSubroutineUniformName](http://docs.gl/gl4/glGetActiveSubroutineUniformName)(program, shadertype, index, bufSize, length, name)
        /// * `shadertype` group: ShaderType
        /// * `length` len: 1
        /// * `name` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetActiveSubroutineUniformName(
            &self,
            program: GLuint,
            shadertype: GLenum,
            index: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            name: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetActiveSubroutineUniformName({:?}, {:#X}, {:?}, {:?}, {:p}, {:p});", program, shadertype, index, bufSize, length, name);
            }
            let out = call_atomic_ptr_6arg(
                "glGetActiveSubroutineUniformName",
                &self.glGetActiveSubroutineUniformName_p,
                program,
                shadertype,
                index,
                bufSize,
                length,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetActiveSubroutineUniformName");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetActiveSubroutineUniformName_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetActiveSubroutineUniformName\0",
                &self.glGetActiveSubroutineUniformName_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetActiveSubroutineUniformName_is_loaded(&self) -> bool {
            !self
                .glGetActiveSubroutineUniformName_p
                .load(RELAX)
                .is_null()
        }
        /// [glGetActiveSubroutineUniformiv](http://docs.gl/gl4/glGetActiveSubroutineUniform)(program, shadertype, index, pname, values)
        /// * `shadertype` group: ShaderType
        /// * `pname` group: SubroutineParameterName
        /// * `values` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetActiveSubroutineUniformiv(
            &self,
            program: GLuint,
            shadertype: GLenum,
            index: GLuint,
            pname: GLenum,
            values: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetActiveSubroutineUniformiv({:?}, {:#X}, {:?}, {:#X}, {:p});",
                    program,
                    shadertype,
                    index,
                    pname,
                    values
                );
            }
            let out = call_atomic_ptr_5arg(
                "glGetActiveSubroutineUniformiv",
                &self.glGetActiveSubroutineUniformiv_p,
                program,
                shadertype,
                index,
                pname,
                values,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetActiveSubroutineUniformiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetActiveSubroutineUniformiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetActiveSubroutineUniformiv\0",
                &self.glGetActiveSubroutineUniformiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetActiveSubroutineUniformiv_is_loaded(&self) -> bool {
            !self.glGetActiveSubroutineUniformiv_p.load(RELAX).is_null()
        }
        /// [glGetActiveUniform](http://docs.gl/gl4/glGetActiveUniform)(program, index, bufSize, length, size, type_, name)
        /// * `length` len: 1
        /// * `size` len: 1
        /// * `type_` group: UniformType
        /// * `type_` len: 1
        /// * `name` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetActiveUniform(
            &self,
            program: GLuint,
            index: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            size: *mut GLint,
            type_: *mut GLenum,
            name: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetActiveUniform({:?}, {:?}, {:?}, {:p}, {:p}, {:p}, {:p});",
                    program,
                    index,
                    bufSize,
                    length,
                    size,
                    type_,
                    name
                );
            }
            let out = call_atomic_ptr_7arg(
                "glGetActiveUniform",
                &self.glGetActiveUniform_p,
                program,
                index,
                bufSize,
                length,
                size,
                type_,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetActiveUniform");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetActiveUniform_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetActiveUniform\0",
                &self.glGetActiveUniform_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetActiveUniform_is_loaded(&self) -> bool {
            !self.glGetActiveUniform_p.load(RELAX).is_null()
        }
        /// [glGetActiveUniformBlockName](http://docs.gl/gl4/glGetActiveUniformBlockName)(program, uniformBlockIndex, bufSize, length, uniformBlockName)
        /// * `length` len: 1
        /// * `uniformBlockName` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetActiveUniformBlockName(
            &self,
            program: GLuint,
            uniformBlockIndex: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            uniformBlockName: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetActiveUniformBlockName({:?}, {:?}, {:?}, {:p}, {:p});",
                    program,
                    uniformBlockIndex,
                    bufSize,
                    length,
                    uniformBlockName
                );
            }
            let out = call_atomic_ptr_5arg(
                "glGetActiveUniformBlockName",
                &self.glGetActiveUniformBlockName_p,
                program,
                uniformBlockIndex,
                bufSize,
                length,
                uniformBlockName,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetActiveUniformBlockName");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetActiveUniformBlockName_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetActiveUniformBlockName\0",
                &self.glGetActiveUniformBlockName_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetActiveUniformBlockName_is_loaded(&self) -> bool {
            !self.glGetActiveUniformBlockName_p.load(RELAX).is_null()
        }
        /// [glGetActiveUniformBlockiv](http://docs.gl/gl4/glGetActiveUniformBlockiv)(program, uniformBlockIndex, pname, params)
        /// * `pname` group: UniformBlockPName
        /// * `params` len: COMPSIZE(program,uniformBlockIndex,pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetActiveUniformBlockiv(
            &self,
            program: GLuint,
            uniformBlockIndex: GLuint,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetActiveUniformBlockiv({:?}, {:?}, {:#X}, {:p});",
                    program,
                    uniformBlockIndex,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetActiveUniformBlockiv",
                &self.glGetActiveUniformBlockiv_p,
                program,
                uniformBlockIndex,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetActiveUniformBlockiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetActiveUniformBlockiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetActiveUniformBlockiv\0",
                &self.glGetActiveUniformBlockiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetActiveUniformBlockiv_is_loaded(&self) -> bool {
            !self.glGetActiveUniformBlockiv_p.load(RELAX).is_null()
        }
        /// [glGetActiveUniformName](http://docs.gl/gl4/glGetActiveUniformName)(program, uniformIndex, bufSize, length, uniformName)
        /// * `length` len: 1
        /// * `uniformName` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetActiveUniformName(
            &self,
            program: GLuint,
            uniformIndex: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            uniformName: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetActiveUniformName({:?}, {:?}, {:?}, {:p}, {:p});",
                    program,
                    uniformIndex,
                    bufSize,
                    length,
                    uniformName
                );
            }
            let out = call_atomic_ptr_5arg(
                "glGetActiveUniformName",
                &self.glGetActiveUniformName_p,
                program,
                uniformIndex,
                bufSize,
                length,
                uniformName,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetActiveUniformName");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetActiveUniformName_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetActiveUniformName\0",
                &self.glGetActiveUniformName_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetActiveUniformName_is_loaded(&self) -> bool {
            !self.glGetActiveUniformName_p.load(RELAX).is_null()
        }
        /// [glGetActiveUniformsiv](http://docs.gl/gl4/glGetActiveUniformsiv)(program, uniformCount, uniformIndices, pname, params)
        /// * `uniformIndices` len: uniformCount
        /// * `pname` group: UniformPName
        /// * `params` len: COMPSIZE(uniformCount,pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetActiveUniformsiv(
            &self,
            program: GLuint,
            uniformCount: GLsizei,
            uniformIndices: *const GLuint,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetActiveUniformsiv({:?}, {:?}, {:p}, {:#X}, {:p});",
                    program,
                    uniformCount,
                    uniformIndices,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_5arg(
                "glGetActiveUniformsiv",
                &self.glGetActiveUniformsiv_p,
                program,
                uniformCount,
                uniformIndices,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetActiveUniformsiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetActiveUniformsiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetActiveUniformsiv\0",
                &self.glGetActiveUniformsiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetActiveUniformsiv_is_loaded(&self) -> bool {
            !self.glGetActiveUniformsiv_p.load(RELAX).is_null()
        }
        /// [glGetAttachedShaders](http://docs.gl/gl4/glGetAttachedShaders)(program, maxCount, count, shaders)
        /// * `count` len: 1
        /// * `shaders` len: maxCount
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetAttachedShaders(
            &self,
            program: GLuint,
            maxCount: GLsizei,
            count: *mut GLsizei,
            shaders: *mut GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetAttachedShaders({:?}, {:?}, {:p}, {:p});",
                    program,
                    maxCount,
                    count,
                    shaders
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetAttachedShaders",
                &self.glGetAttachedShaders_p,
                program,
                maxCount,
                count,
                shaders,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetAttachedShaders");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetAttachedShaders_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetAttachedShaders\0",
                &self.glGetAttachedShaders_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetAttachedShaders_is_loaded(&self) -> bool {
            !self.glGetAttachedShaders_p.load(RELAX).is_null()
        }
        /// [glGetAttribLocation](http://docs.gl/gl4/glGetAttribLocation)(program, name)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetAttribLocation(&self, program: GLuint, name: *const GLchar) -> GLint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetAttribLocation({:?}, {:p});", program, name);
            }
            let out = call_atomic_ptr_2arg(
                "glGetAttribLocation",
                &self.glGetAttribLocation_p,
                program,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetAttribLocation");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetAttribLocation_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetAttribLocation\0",
                &self.glGetAttribLocation_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetAttribLocation_is_loaded(&self) -> bool {
            !self.glGetAttribLocation_p.load(RELAX).is_null()
        }
        /// [glGetBooleanIndexedvEXT](http://docs.gl/gl4/glGetBooleanIndexedvEXT)(target, index, data)
        /// * `target` group: BufferTargetARB
        /// * `data` len: COMPSIZE(target)
        /// * alias of: [`glGetBooleani_v`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetBooleanIndexedvEXT(
            &self,
            target: GLenum,
            index: GLuint,
            data: *mut GLboolean,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetBooleanIndexedvEXT({:#X}, {:?}, {:p});",
                    target,
                    index,
                    data
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetBooleanIndexedvEXT",
                &self.glGetBooleanIndexedvEXT_p,
                target,
                index,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetBooleanIndexedvEXT");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn GetBooleanIndexedvEXT_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetBooleanIndexedvEXT\0",
                &self.glGetBooleanIndexedvEXT_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn GetBooleanIndexedvEXT_is_loaded(&self) -> bool {
            !self.glGetBooleanIndexedvEXT_p.load(RELAX).is_null()
        }
        /// [glGetBooleani_v](http://docs.gl/gl4/glGet)(target, index, data)
        /// * `target` group: BufferTargetARB
        /// * `data` len: COMPSIZE(target)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetBooleani_v(&self, target: GLenum, index: GLuint, data: *mut GLboolean) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetBooleani_v({:#X}, {:?}, {:p});",
                    target,
                    index,
                    data
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetBooleani_v",
                &self.glGetBooleani_v_p,
                target,
                index,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetBooleani_v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetBooleani_v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetBooleani_v\0",
                &self.glGetBooleani_v_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetBooleani_v_is_loaded(&self) -> bool {
            !self.glGetBooleani_v_p.load(RELAX).is_null()
        }
        /// [glGetBooleanv](http://docs.gl/gl4/glGet)(pname, data)
        /// * `pname` group: GetPName
        /// * `data` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetBooleanv(&self, pname: GLenum, data: *mut GLboolean) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetBooleanv({:#X}, {:p});", pname, data);
            }
            let out = call_atomic_ptr_2arg("glGetBooleanv", &self.glGetBooleanv_p, pname, data);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetBooleanv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetBooleanv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGetBooleanv\0", &self.glGetBooleanv_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetBooleanv_is_loaded(&self) -> bool {
            !self.glGetBooleanv_p.load(RELAX).is_null()
        }
        /// [glGetBufferParameteri64v](http://docs.gl/gl4/glGetBufferParameter)(target, pname, params)
        /// * `target` group: BufferTargetARB
        /// * `pname` group: BufferPNameARB
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetBufferParameteri64v(
            &self,
            target: GLenum,
            pname: GLenum,
            params: *mut GLint64,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetBufferParameteri64v({:#X}, {:#X}, {:p});",
                    target,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetBufferParameteri64v",
                &self.glGetBufferParameteri64v_p,
                target,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetBufferParameteri64v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetBufferParameteri64v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetBufferParameteri64v\0",
                &self.glGetBufferParameteri64v_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetBufferParameteri64v_is_loaded(&self) -> bool {
            !self.glGetBufferParameteri64v_p.load(RELAX).is_null()
        }
        /// [glGetBufferParameteriv](http://docs.gl/gl4/glGetBufferParameter)(target, pname, params)
        /// * `target` group: BufferTargetARB
        /// * `pname` group: BufferPNameARB
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetBufferParameteriv(
            &self,
            target: GLenum,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetBufferParameteriv({:#X}, {:#X}, {:p});",
                    target,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetBufferParameteriv",
                &self.glGetBufferParameteriv_p,
                target,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetBufferParameteriv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetBufferParameteriv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetBufferParameteriv\0",
                &self.glGetBufferParameteriv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetBufferParameteriv_is_loaded(&self) -> bool {
            !self.glGetBufferParameteriv_p.load(RELAX).is_null()
        }
        /// [glGetBufferPointerv](http://docs.gl/gl4/glGetBufferPointerv)(target, pname, params)
        /// * `target` group: BufferTargetARB
        /// * `pname` group: BufferPointerNameARB
        /// * `params` len: 1
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetBufferPointerv(
            &self,
            target: GLenum,
            pname: GLenum,
            params: *mut *mut c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetBufferPointerv({:#X}, {:#X}, {:p});",
                    target,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetBufferPointerv",
                &self.glGetBufferPointerv_p,
                target,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetBufferPointerv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetBufferPointerv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetBufferPointerv\0",
                &self.glGetBufferPointerv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetBufferPointerv_is_loaded(&self) -> bool {
            !self.glGetBufferPointerv_p.load(RELAX).is_null()
        }
        /// [glGetBufferSubData](http://docs.gl/gl4/glGetBufferSubData)(target, offset, size, data)
        /// * `target` group: BufferTargetARB
        /// * `offset` group: BufferOffset
        /// * `size` group: BufferSize
        /// * `data` len: size
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetBufferSubData(
            &self,
            target: GLenum,
            offset: GLintptr,
            size: GLsizeiptr,
            data: *mut c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetBufferSubData({:#X}, {:?}, {:?}, {:p});",
                    target,
                    offset,
                    size,
                    data
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetBufferSubData",
                &self.glGetBufferSubData_p,
                target,
                offset,
                size,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetBufferSubData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetBufferSubData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetBufferSubData\0",
                &self.glGetBufferSubData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetBufferSubData_is_loaded(&self) -> bool {
            !self.glGetBufferSubData_p.load(RELAX).is_null()
        }
        /// [glGetCompressedTexImage](http://docs.gl/gl4/glGetCompressedTexImage)(target, level, img)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `img` group: CompressedTextureARB
        /// * `img` len: COMPSIZE(target,level)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetCompressedTexImage(&self, target: GLenum, level: GLint, img: *mut c_void) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetCompressedTexImage({:#X}, {:?}, {:p});",
                    target,
                    level,
                    img
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetCompressedTexImage",
                &self.glGetCompressedTexImage_p,
                target,
                level,
                img,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetCompressedTexImage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetCompressedTexImage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetCompressedTexImage\0",
                &self.glGetCompressedTexImage_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetCompressedTexImage_is_loaded(&self) -> bool {
            !self.glGetCompressedTexImage_p.load(RELAX).is_null()
        }
        /// [glGetCompressedTextureImage](http://docs.gl/gl4/glGetCompressedTextureImage)(texture, level, bufSize, pixels)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetCompressedTextureImage(
            &self,
            texture: GLuint,
            level: GLint,
            bufSize: GLsizei,
            pixels: *mut c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetCompressedTextureImage({:?}, {:?}, {:?}, {:p});",
                    texture,
                    level,
                    bufSize,
                    pixels
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetCompressedTextureImage",
                &self.glGetCompressedTextureImage_p,
                texture,
                level,
                bufSize,
                pixels,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetCompressedTextureImage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetCompressedTextureImage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetCompressedTextureImage\0",
                &self.glGetCompressedTextureImage_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetCompressedTextureImage_is_loaded(&self) -> bool {
            !self.glGetCompressedTextureImage_p.load(RELAX).is_null()
        }
        /// [glGetCompressedTextureSubImage](http://docs.gl/gl4/glGetCompressedTextureSubImage)(texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, pixels)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetCompressedTextureSubImage(
            &self,
            texture: GLuint,
            level: GLint,
            xoffset: GLint,
            yoffset: GLint,
            zoffset: GLint,
            width: GLsizei,
            height: GLsizei,
            depth: GLsizei,
            bufSize: GLsizei,
            pixels: *mut c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetCompressedTextureSubImage({:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:p});", texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, pixels);
            }
            let out = call_atomic_ptr_10arg(
                "glGetCompressedTextureSubImage",
                &self.glGetCompressedTextureSubImage_p,
                texture,
                level,
                xoffset,
                yoffset,
                zoffset,
                width,
                height,
                depth,
                bufSize,
                pixels,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetCompressedTextureSubImage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetCompressedTextureSubImage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetCompressedTextureSubImage\0",
                &self.glGetCompressedTextureSubImage_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetCompressedTextureSubImage_is_loaded(&self) -> bool {
            !self.glGetCompressedTextureSubImage_p.load(RELAX).is_null()
        }
        /// [glGetDebugMessageLog](http://docs.gl/gl4/glGetDebugMessageLog)(count, bufSize, sources, types, ids, severities, lengths, messageLog)
        /// * `sources` group: DebugSource
        /// * `sources` len: count
        /// * `types` group: DebugType
        /// * `types` len: count
        /// * `ids` len: count
        /// * `severities` group: DebugSeverity
        /// * `severities` len: count
        /// * `lengths` len: count
        /// * `messageLog` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetDebugMessageLog(
            &self,
            count: GLuint,
            bufSize: GLsizei,
            sources: *mut GLenum,
            types: *mut GLenum,
            ids: *mut GLuint,
            severities: *mut GLenum,
            lengths: *mut GLsizei,
            messageLog: *mut GLchar,
        ) -> GLuint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetDebugMessageLog({:?}, {:?}, {:p}, {:p}, {:p}, {:p}, {:p}, {:p});", count, bufSize, sources, types, ids, severities, lengths, messageLog);
            }
            let out = call_atomic_ptr_8arg(
                "glGetDebugMessageLog",
                &self.glGetDebugMessageLog_p,
                count,
                bufSize,
                sources,
                types,
                ids,
                severities,
                lengths,
                messageLog,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetDebugMessageLog");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetDebugMessageLog_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetDebugMessageLog\0",
                &self.glGetDebugMessageLog_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetDebugMessageLog_is_loaded(&self) -> bool {
            !self.glGetDebugMessageLog_p.load(RELAX).is_null()
        }
        /// [glGetDebugMessageLogARB](http://docs.gl/gl4/glGetDebugMessageLogARB)(count, bufSize, sources, types, ids, severities, lengths, messageLog)
        /// * `sources` group: DebugSource
        /// * `sources` len: count
        /// * `types` group: DebugType
        /// * `types` len: count
        /// * `ids` len: count
        /// * `severities` group: DebugSeverity
        /// * `severities` len: count
        /// * `lengths` len: count
        /// * `messageLog` len: bufSize
        /// * alias of: [`glGetDebugMessageLog`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetDebugMessageLogARB(
            &self,
            count: GLuint,
            bufSize: GLsizei,
            sources: *mut GLenum,
            types: *mut GLenum,
            ids: *mut GLuint,
            severities: *mut GLenum,
            lengths: *mut GLsizei,
            messageLog: *mut GLchar,
        ) -> GLuint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetDebugMessageLogARB({:?}, {:?}, {:p}, {:p}, {:p}, {:p}, {:p}, {:p});", count, bufSize, sources, types, ids, severities, lengths, messageLog);
            }
            let out = call_atomic_ptr_8arg(
                "glGetDebugMessageLogARB",
                &self.glGetDebugMessageLogARB_p,
                count,
                bufSize,
                sources,
                types,
                ids,
                severities,
                lengths,
                messageLog,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetDebugMessageLogARB");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn GetDebugMessageLogARB_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetDebugMessageLogARB\0",
                &self.glGetDebugMessageLogARB_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn GetDebugMessageLogARB_is_loaded(&self) -> bool {
            !self.glGetDebugMessageLogARB_p.load(RELAX).is_null()
        }
        /// [glGetDebugMessageLogKHR](http://docs.gl/gl4/glGetDebugMessageLogKHR)(count, bufSize, sources, types, ids, severities, lengths, messageLog)
        /// * `sources` group: DebugSource
        /// * `sources` len: count
        /// * `types` group: DebugType
        /// * `types` len: count
        /// * `ids` len: count
        /// * `severities` group: DebugSeverity
        /// * `severities` len: count
        /// * `lengths` len: count
        /// * `messageLog` len: bufSize
        /// * alias of: [`glGetDebugMessageLog`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetDebugMessageLogKHR(
            &self,
            count: GLuint,
            bufSize: GLsizei,
            sources: *mut GLenum,
            types: *mut GLenum,
            ids: *mut GLuint,
            severities: *mut GLenum,
            lengths: *mut GLsizei,
            messageLog: *mut GLchar,
        ) -> GLuint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetDebugMessageLogKHR({:?}, {:?}, {:p}, {:p}, {:p}, {:p}, {:p}, {:p});", count, bufSize, sources, types, ids, severities, lengths, messageLog);
            }
            let out = call_atomic_ptr_8arg(
                "glGetDebugMessageLogKHR",
                &self.glGetDebugMessageLogKHR_p,
                count,
                bufSize,
                sources,
                types,
                ids,
                severities,
                lengths,
                messageLog,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetDebugMessageLogKHR");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn GetDebugMessageLogKHR_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetDebugMessageLogKHR\0",
                &self.glGetDebugMessageLogKHR_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn GetDebugMessageLogKHR_is_loaded(&self) -> bool {
            !self.glGetDebugMessageLogKHR_p.load(RELAX).is_null()
        }
        /// [glGetDoublei_v](http://docs.gl/gl4/glGetDoublei_v)(target, index, data)
        /// * `target` group: GetPName
        /// * `data` len: COMPSIZE(target)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetDoublei_v(&self, target: GLenum, index: GLuint, data: *mut GLdouble) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetDoublei_v({:#X}, {:?}, {:p});",
                    target,
                    index,
                    data
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetDoublei_v",
                &self.glGetDoublei_v_p,
                target,
                index,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetDoublei_v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetDoublei_v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetDoublei_v\0",
                &self.glGetDoublei_v_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetDoublei_v_is_loaded(&self) -> bool {
            !self.glGetDoublei_v_p.load(RELAX).is_null()
        }
        /// [glGetDoublev](http://docs.gl/gl4/glGetDoublev)(pname, data)
        /// * `pname` group: GetPName
        /// * `data` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetDoublev(&self, pname: GLenum, data: *mut GLdouble) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetDoublev({:#X}, {:p});", pname, data);
            }
            let out = call_atomic_ptr_2arg("glGetDoublev", &self.glGetDoublev_p, pname, data);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetDoublev");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetDoublev_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGetDoublev\0", &self.glGetDoublev_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetDoublev_is_loaded(&self) -> bool {
            !self.glGetDoublev_p.load(RELAX).is_null()
        }
        /// [glGetError](http://docs.gl/gl4/glGetError)()
        /// * return value group: ErrorCode
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetError(&self) -> GLenum {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetError();",);
            }
            let out = call_atomic_ptr_0arg("glGetError", &self.glGetError_p);

            out
        }
        #[doc(hidden)]
        pub unsafe fn GetError_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGetError\0", &self.glGetError_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetError_is_loaded(&self) -> bool {
            !self.glGetError_p.load(RELAX).is_null()
        }
        /// [glGetFloati_v](http://docs.gl/gl4/glGetFloati_v)(target, index, data)
        /// * `target` group: GetPName
        /// * `data` len: COMPSIZE(target)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetFloati_v(&self, target: GLenum, index: GLuint, data: *mut GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetFloati_v({:#X}, {:?}, {:p});",
                    target,
                    index,
                    data
                );
            }
            let out =
                call_atomic_ptr_3arg("glGetFloati_v", &self.glGetFloati_v_p, target, index, data);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetFloati_v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetFloati_v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGetFloati_v\0", &self.glGetFloati_v_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetFloati_v_is_loaded(&self) -> bool {
            !self.glGetFloati_v_p.load(RELAX).is_null()
        }
        /// [glGetFloatv](http://docs.gl/gl4/glGet)(pname, data)
        /// * `pname` group: GetPName
        /// * `data` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetFloatv(&self, pname: GLenum, data: *mut GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetFloatv({:#X}, {:p});", pname, data);
            }
            let out = call_atomic_ptr_2arg("glGetFloatv", &self.glGetFloatv_p, pname, data);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetFloatv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetFloatv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGetFloatv\0", &self.glGetFloatv_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetFloatv_is_loaded(&self) -> bool {
            !self.glGetFloatv_p.load(RELAX).is_null()
        }
        /// [glGetFragDataIndex](http://docs.gl/gl4/glGetFragDataIndex)(program, name)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetFragDataIndex(&self, program: GLuint, name: *const GLchar) -> GLint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetFragDataIndex({:?}, {:p});", program, name);
            }
            let out = call_atomic_ptr_2arg(
                "glGetFragDataIndex",
                &self.glGetFragDataIndex_p,
                program,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetFragDataIndex");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetFragDataIndex_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetFragDataIndex\0",
                &self.glGetFragDataIndex_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetFragDataIndex_is_loaded(&self) -> bool {
            !self.glGetFragDataIndex_p.load(RELAX).is_null()
        }
        /// [glGetFragDataLocation](http://docs.gl/gl4/glGetFragDataLocation)(program, name)
        /// * `name` len: COMPSIZE(name)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetFragDataLocation(&self, program: GLuint, name: *const GLchar) -> GLint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetFragDataLocation({:?}, {:p});", program, name);
            }
            let out = call_atomic_ptr_2arg(
                "glGetFragDataLocation",
                &self.glGetFragDataLocation_p,
                program,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetFragDataLocation");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetFragDataLocation_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetFragDataLocation\0",
                &self.glGetFragDataLocation_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetFragDataLocation_is_loaded(&self) -> bool {
            !self.glGetFragDataLocation_p.load(RELAX).is_null()
        }
        /// [glGetFramebufferAttachmentParameteriv](http://docs.gl/gl4/glGetFramebufferAttachmentParameter)(target, attachment, pname, params)
        /// * `target` group: FramebufferTarget
        /// * `attachment` group: FramebufferAttachment
        /// * `pname` group: FramebufferAttachmentParameterName
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetFramebufferAttachmentParameteriv(
            &self,
            target: GLenum,
            attachment: GLenum,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetFramebufferAttachmentParameteriv({:#X}, {:#X}, {:#X}, {:p});",
                    target,
                    attachment,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetFramebufferAttachmentParameteriv",
                &self.glGetFramebufferAttachmentParameteriv_p,
                target,
                attachment,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetFramebufferAttachmentParameteriv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetFramebufferAttachmentParameteriv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetFramebufferAttachmentParameteriv\0",
                &self.glGetFramebufferAttachmentParameteriv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetFramebufferAttachmentParameteriv_is_loaded(&self) -> bool {
            !self
                .glGetFramebufferAttachmentParameteriv_p
                .load(RELAX)
                .is_null()
        }
        /// [glGetFramebufferParameteriv](http://docs.gl/gl4/glGetFramebufferParameter)(target, pname, params)
        /// * `target` group: FramebufferTarget
        /// * `pname` group: FramebufferAttachmentParameterName
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetFramebufferParameteriv(
            &self,
            target: GLenum,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetFramebufferParameteriv({:#X}, {:#X}, {:p});",
                    target,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetFramebufferParameteriv",
                &self.glGetFramebufferParameteriv_p,
                target,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetFramebufferParameteriv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetFramebufferParameteriv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetFramebufferParameteriv\0",
                &self.glGetFramebufferParameteriv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetFramebufferParameteriv_is_loaded(&self) -> bool {
            !self.glGetFramebufferParameteriv_p.load(RELAX).is_null()
        }
        /// [glGetGraphicsResetStatus](http://docs.gl/gl4/glGetGraphicsResetStatus)()
        /// * return value group: GraphicsResetStatus
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetGraphicsResetStatus(&self) -> GLenum {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetGraphicsResetStatus();",);
            }
            let out =
                call_atomic_ptr_0arg("glGetGraphicsResetStatus", &self.glGetGraphicsResetStatus_p);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetGraphicsResetStatus");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetGraphicsResetStatus_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetGraphicsResetStatus\0",
                &self.glGetGraphicsResetStatus_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetGraphicsResetStatus_is_loaded(&self) -> bool {
            !self.glGetGraphicsResetStatus_p.load(RELAX).is_null()
        }
        /// [glGetInteger64i_v](http://docs.gl/gl4/glGet)(target, index, data)
        /// * `target` group: GetPName
        /// * `data` len: COMPSIZE(target)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetInteger64i_v(&self, target: GLenum, index: GLuint, data: *mut GLint64) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetInteger64i_v({:#X}, {:?}, {:p});",
                    target,
                    index,
                    data
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetInteger64i_v",
                &self.glGetInteger64i_v_p,
                target,
                index,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetInteger64i_v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetInteger64i_v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetInteger64i_v\0",
                &self.glGetInteger64i_v_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetInteger64i_v_is_loaded(&self) -> bool {
            !self.glGetInteger64i_v_p.load(RELAX).is_null()
        }
        /// [glGetInteger64v](http://docs.gl/gl4/glGet)(pname, data)
        /// * `pname` group: GetPName
        /// * `data` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetInteger64v(&self, pname: GLenum, data: *mut GLint64) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetInteger64v({:#X}, {:p});", pname, data);
            }
            let out = call_atomic_ptr_2arg("glGetInteger64v", &self.glGetInteger64v_p, pname, data);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetInteger64v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetInteger64v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetInteger64v\0",
                &self.glGetInteger64v_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetInteger64v_is_loaded(&self) -> bool {
            !self.glGetInteger64v_p.load(RELAX).is_null()
        }
        /// [glGetIntegerIndexedvEXT](http://docs.gl/gl4/glGetIntegerIndexedvEXT)(target, index, data)
        /// * `target` group: GetPName
        /// * `data` len: COMPSIZE(target)
        /// * alias of: [`glGetIntegeri_v`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetIntegerIndexedvEXT(
            &self,
            target: GLenum,
            index: GLuint,
            data: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetIntegerIndexedvEXT({:#X}, {:?}, {:p});",
                    target,
                    index,
                    data
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetIntegerIndexedvEXT",
                &self.glGetIntegerIndexedvEXT_p,
                target,
                index,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetIntegerIndexedvEXT");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn GetIntegerIndexedvEXT_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetIntegerIndexedvEXT\0",
                &self.glGetIntegerIndexedvEXT_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn GetIntegerIndexedvEXT_is_loaded(&self) -> bool {
            !self.glGetIntegerIndexedvEXT_p.load(RELAX).is_null()
        }
        /// [glGetIntegeri_v](http://docs.gl/gl4/glGet)(target, index, data)
        /// * `target` group: GetPName
        /// * `data` len: COMPSIZE(target)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetIntegeri_v(&self, target: GLenum, index: GLuint, data: *mut GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetIntegeri_v({:#X}, {:?}, {:p});",
                    target,
                    index,
                    data
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetIntegeri_v",
                &self.glGetIntegeri_v_p,
                target,
                index,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetIntegeri_v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetIntegeri_v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetIntegeri_v\0",
                &self.glGetIntegeri_v_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetIntegeri_v_is_loaded(&self) -> bool {
            !self.glGetIntegeri_v_p.load(RELAX).is_null()
        }
        /// [glGetIntegerv](http://docs.gl/gl4/glGet)(pname, data)
        /// * `pname` group: GetPName
        /// * `data` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetIntegerv(&self, pname: GLenum, data: *mut GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetIntegerv({:#X}, {:p});", pname, data);
            }
            let out = call_atomic_ptr_2arg("glGetIntegerv", &self.glGetIntegerv_p, pname, data);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetIntegerv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetIntegerv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGetIntegerv\0", &self.glGetIntegerv_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetIntegerv_is_loaded(&self) -> bool {
            !self.glGetIntegerv_p.load(RELAX).is_null()
        }
        /// [glGetInternalformati64v](http://docs.gl/gl4/glGetInternalformat)(target, internalformat, pname, count, params)
        /// * `target` group: TextureTarget
        /// * `internalformat` group: InternalFormat
        /// * `pname` group: InternalFormatPName
        /// * `params` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetInternalformati64v(
            &self,
            target: GLenum,
            internalformat: GLenum,
            pname: GLenum,
            count: GLsizei,
            params: *mut GLint64,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetInternalformati64v({:#X}, {:#X}, {:#X}, {:?}, {:p});",
                    target,
                    internalformat,
                    pname,
                    count,
                    params
                );
            }
            let out = call_atomic_ptr_5arg(
                "glGetInternalformati64v",
                &self.glGetInternalformati64v_p,
                target,
                internalformat,
                pname,
                count,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetInternalformati64v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetInternalformati64v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetInternalformati64v\0",
                &self.glGetInternalformati64v_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetInternalformati64v_is_loaded(&self) -> bool {
            !self.glGetInternalformati64v_p.load(RELAX).is_null()
        }
        /// [glGetInternalformativ](http://docs.gl/gl4/glGetInternalformativ)(target, internalformat, pname, count, params)
        /// * `target` group: TextureTarget
        /// * `internalformat` group: InternalFormat
        /// * `pname` group: InternalFormatPName
        /// * `params` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetInternalformativ(
            &self,
            target: GLenum,
            internalformat: GLenum,
            pname: GLenum,
            count: GLsizei,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetInternalformativ({:#X}, {:#X}, {:#X}, {:?}, {:p});",
                    target,
                    internalformat,
                    pname,
                    count,
                    params
                );
            }
            let out = call_atomic_ptr_5arg(
                "glGetInternalformativ",
                &self.glGetInternalformativ_p,
                target,
                internalformat,
                pname,
                count,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetInternalformativ");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetInternalformativ_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetInternalformativ\0",
                &self.glGetInternalformativ_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetInternalformativ_is_loaded(&self) -> bool {
            !self.glGetInternalformativ_p.load(RELAX).is_null()
        }
        /// [glGetMultisamplefv](http://docs.gl/gl4/glGetMultisample)(pname, index, val)
        /// * `pname` group: GetMultisamplePNameNV
        /// * `val` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetMultisamplefv(&self, pname: GLenum, index: GLuint, val: *mut GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetMultisamplefv({:#X}, {:?}, {:p});",
                    pname,
                    index,
                    val
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetMultisamplefv",
                &self.glGetMultisamplefv_p,
                pname,
                index,
                val,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetMultisamplefv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetMultisamplefv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetMultisamplefv\0",
                &self.glGetMultisamplefv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetMultisamplefv_is_loaded(&self) -> bool {
            !self.glGetMultisamplefv_p.load(RELAX).is_null()
        }
        /// [glGetNamedBufferParameteri64v](http://docs.gl/gl4/glGetNamedBufferParameter)(buffer, pname, params)
        /// * `pname` group: BufferPNameARB
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetNamedBufferParameteri64v(
            &self,
            buffer: GLuint,
            pname: GLenum,
            params: *mut GLint64,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetNamedBufferParameteri64v({:?}, {:#X}, {:p});",
                    buffer,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetNamedBufferParameteri64v",
                &self.glGetNamedBufferParameteri64v_p,
                buffer,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetNamedBufferParameteri64v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetNamedBufferParameteri64v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetNamedBufferParameteri64v\0",
                &self.glGetNamedBufferParameteri64v_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetNamedBufferParameteri64v_is_loaded(&self) -> bool {
            !self.glGetNamedBufferParameteri64v_p.load(RELAX).is_null()
        }
        /// [glGetNamedBufferParameteriv](http://docs.gl/gl4/glGetNamedBufferParameter)(buffer, pname, params)
        /// * `pname` group: BufferPNameARB
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetNamedBufferParameteriv(
            &self,
            buffer: GLuint,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetNamedBufferParameteriv({:?}, {:#X}, {:p});",
                    buffer,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetNamedBufferParameteriv",
                &self.glGetNamedBufferParameteriv_p,
                buffer,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetNamedBufferParameteriv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetNamedBufferParameteriv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetNamedBufferParameteriv\0",
                &self.glGetNamedBufferParameteriv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetNamedBufferParameteriv_is_loaded(&self) -> bool {
            !self.glGetNamedBufferParameteriv_p.load(RELAX).is_null()
        }
        /// [glGetNamedBufferPointerv](http://docs.gl/gl4/glGetNamedBufferPointerv)(buffer, pname, params)
        /// * `pname` group: BufferPointerNameARB
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetNamedBufferPointerv(
            &self,
            buffer: GLuint,
            pname: GLenum,
            params: *mut *mut c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetNamedBufferPointerv({:?}, {:#X}, {:p});",
                    buffer,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetNamedBufferPointerv",
                &self.glGetNamedBufferPointerv_p,
                buffer,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetNamedBufferPointerv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetNamedBufferPointerv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetNamedBufferPointerv\0",
                &self.glGetNamedBufferPointerv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetNamedBufferPointerv_is_loaded(&self) -> bool {
            !self.glGetNamedBufferPointerv_p.load(RELAX).is_null()
        }
        /// [glGetNamedBufferSubData](http://docs.gl/gl4/glGetNamedBufferSubData)(buffer, offset, size, data)
        /// * `size` group: BufferSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetNamedBufferSubData(
            &self,
            buffer: GLuint,
            offset: GLintptr,
            size: GLsizeiptr,
            data: *mut c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetNamedBufferSubData({:?}, {:?}, {:?}, {:p});",
                    buffer,
                    offset,
                    size,
                    data
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetNamedBufferSubData",
                &self.glGetNamedBufferSubData_p,
                buffer,
                offset,
                size,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetNamedBufferSubData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetNamedBufferSubData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetNamedBufferSubData\0",
                &self.glGetNamedBufferSubData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetNamedBufferSubData_is_loaded(&self) -> bool {
            !self.glGetNamedBufferSubData_p.load(RELAX).is_null()
        }
        /// [glGetNamedFramebufferAttachmentParameteriv](http://docs.gl/gl4/glGetNamedFramebufferAttachmentParameter)(framebuffer, attachment, pname, params)
        /// * `attachment` group: FramebufferAttachment
        /// * `pname` group: FramebufferAttachmentParameterName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetNamedFramebufferAttachmentParameteriv(
            &self,
            framebuffer: GLuint,
            attachment: GLenum,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetNamedFramebufferAttachmentParameteriv({:?}, {:#X}, {:#X}, {:p});", framebuffer, attachment, pname, params);
            }
            let out = call_atomic_ptr_4arg(
                "glGetNamedFramebufferAttachmentParameteriv",
                &self.glGetNamedFramebufferAttachmentParameteriv_p,
                framebuffer,
                attachment,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetNamedFramebufferAttachmentParameteriv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetNamedFramebufferAttachmentParameteriv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetNamedFramebufferAttachmentParameteriv\0",
                &self.glGetNamedFramebufferAttachmentParameteriv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetNamedFramebufferAttachmentParameteriv_is_loaded(&self) -> bool {
            !self
                .glGetNamedFramebufferAttachmentParameteriv_p
                .load(RELAX)
                .is_null()
        }
        /// [glGetNamedFramebufferParameteriv](http://docs.gl/gl4/glGetNamedFramebufferParameter)(framebuffer, pname, param)
        /// * `pname` group: GetFramebufferParameter
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetNamedFramebufferParameteriv(
            &self,
            framebuffer: GLuint,
            pname: GLenum,
            param: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetNamedFramebufferParameteriv({:?}, {:#X}, {:p});",
                    framebuffer,
                    pname,
                    param
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetNamedFramebufferParameteriv",
                &self.glGetNamedFramebufferParameteriv_p,
                framebuffer,
                pname,
                param,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetNamedFramebufferParameteriv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetNamedFramebufferParameteriv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetNamedFramebufferParameteriv\0",
                &self.glGetNamedFramebufferParameteriv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetNamedFramebufferParameteriv_is_loaded(&self) -> bool {
            !self
                .glGetNamedFramebufferParameteriv_p
                .load(RELAX)
                .is_null()
        }
        /// [glGetNamedRenderbufferParameteriv](http://docs.gl/gl4/glGetNamedRenderbufferParameter)(renderbuffer, pname, params)
        /// * `pname` group: RenderbufferParameterName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetNamedRenderbufferParameteriv(
            &self,
            renderbuffer: GLuint,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetNamedRenderbufferParameteriv({:?}, {:#X}, {:p});",
                    renderbuffer,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetNamedRenderbufferParameteriv",
                &self.glGetNamedRenderbufferParameteriv_p,
                renderbuffer,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetNamedRenderbufferParameteriv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetNamedRenderbufferParameteriv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetNamedRenderbufferParameteriv\0",
                &self.glGetNamedRenderbufferParameteriv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetNamedRenderbufferParameteriv_is_loaded(&self) -> bool {
            !self
                .glGetNamedRenderbufferParameteriv_p
                .load(RELAX)
                .is_null()
        }
        /// [glGetObjectLabel](http://docs.gl/gl4/glGetObjectLabel)(identifier, name, bufSize, length, label)
        /// * `identifier` group: ObjectIdentifier
        /// * `length` len: 1
        /// * `label` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetObjectLabel(
            &self,
            identifier: GLenum,
            name: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            label: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetObjectLabel({:#X}, {:?}, {:?}, {:p}, {:p});",
                    identifier,
                    name,
                    bufSize,
                    length,
                    label
                );
            }
            let out = call_atomic_ptr_5arg(
                "glGetObjectLabel",
                &self.glGetObjectLabel_p,
                identifier,
                name,
                bufSize,
                length,
                label,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetObjectLabel");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetObjectLabel_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetObjectLabel\0",
                &self.glGetObjectLabel_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetObjectLabel_is_loaded(&self) -> bool {
            !self.glGetObjectLabel_p.load(RELAX).is_null()
        }
        /// [glGetObjectLabelKHR](http://docs.gl/gl4/glGetObjectLabelKHR)(identifier, name, bufSize, length, label)
        /// * `label` len: bufSize
        /// * alias of: [`glGetObjectLabel`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetObjectLabelKHR(
            &self,
            identifier: GLenum,
            name: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            label: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetObjectLabelKHR({:#X}, {:?}, {:?}, {:p}, {:p});",
                    identifier,
                    name,
                    bufSize,
                    length,
                    label
                );
            }
            let out = call_atomic_ptr_5arg(
                "glGetObjectLabelKHR",
                &self.glGetObjectLabelKHR_p,
                identifier,
                name,
                bufSize,
                length,
                label,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetObjectLabelKHR");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn GetObjectLabelKHR_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetObjectLabelKHR\0",
                &self.glGetObjectLabelKHR_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn GetObjectLabelKHR_is_loaded(&self) -> bool {
            !self.glGetObjectLabelKHR_p.load(RELAX).is_null()
        }
        /// [glGetObjectPtrLabel](http://docs.gl/gl4/glGetObjectPtrLabel)(ptr, bufSize, length, label)
        /// * `length` len: 1
        /// * `label` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetObjectPtrLabel(
            &self,
            ptr: *const c_void,
            bufSize: GLsizei,
            length: *mut GLsizei,
            label: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetObjectPtrLabel({:p}, {:?}, {:p}, {:p});",
                    ptr,
                    bufSize,
                    length,
                    label
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetObjectPtrLabel",
                &self.glGetObjectPtrLabel_p,
                ptr,
                bufSize,
                length,
                label,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetObjectPtrLabel");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetObjectPtrLabel_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetObjectPtrLabel\0",
                &self.glGetObjectPtrLabel_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetObjectPtrLabel_is_loaded(&self) -> bool {
            !self.glGetObjectPtrLabel_p.load(RELAX).is_null()
        }
        /// [glGetObjectPtrLabelKHR](http://docs.gl/gl4/glGetObjectPtrLabelKHR)(ptr, bufSize, length, label)
        /// * `length` len: 1
        /// * `label` len: bufSize
        /// * alias of: [`glGetObjectPtrLabel`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetObjectPtrLabelKHR(
            &self,
            ptr: *const c_void,
            bufSize: GLsizei,
            length: *mut GLsizei,
            label: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetObjectPtrLabelKHR({:p}, {:?}, {:p}, {:p});",
                    ptr,
                    bufSize,
                    length,
                    label
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetObjectPtrLabelKHR",
                &self.glGetObjectPtrLabelKHR_p,
                ptr,
                bufSize,
                length,
                label,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetObjectPtrLabelKHR");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn GetObjectPtrLabelKHR_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetObjectPtrLabelKHR\0",
                &self.glGetObjectPtrLabelKHR_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn GetObjectPtrLabelKHR_is_loaded(&self) -> bool {
            !self.glGetObjectPtrLabelKHR_p.load(RELAX).is_null()
        }
        /// [glGetPointerv](http://docs.gl/gl4/glGetPointerv)(pname, params)
        /// * `pname` group: GetPointervPName
        /// * `params` len: 1
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetPointerv(&self, pname: GLenum, params: *mut *mut c_void) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetPointerv({:#X}, {:p});", pname, params);
            }
            let out = call_atomic_ptr_2arg("glGetPointerv", &self.glGetPointerv_p, pname, params);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetPointerv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetPointerv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGetPointerv\0", &self.glGetPointerv_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetPointerv_is_loaded(&self) -> bool {
            !self.glGetPointerv_p.load(RELAX).is_null()
        }
        /// [glGetPointervKHR](http://docs.gl/gl4/glGetPointervKHR)(pname, params)
        /// * alias of: [`glGetPointerv`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetPointervKHR(&self, pname: GLenum, params: *mut *mut c_void) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetPointervKHR({:#X}, {:p});", pname, params);
            }
            let out =
                call_atomic_ptr_2arg("glGetPointervKHR", &self.glGetPointervKHR_p, pname, params);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetPointervKHR");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn GetPointervKHR_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetPointervKHR\0",
                &self.glGetPointervKHR_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn GetPointervKHR_is_loaded(&self) -> bool {
            !self.glGetPointervKHR_p.load(RELAX).is_null()
        }
        /// [glGetProgramBinary](http://docs.gl/gl4/glGetProgramBinary)(program, bufSize, length, binaryFormat, binary)
        /// * `length` len: 1
        /// * `binaryFormat` len: 1
        /// * `binary` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetProgramBinary(
            &self,
            program: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            binaryFormat: *mut GLenum,
            binary: *mut c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetProgramBinary({:?}, {:?}, {:p}, {:p}, {:p});",
                    program,
                    bufSize,
                    length,
                    binaryFormat,
                    binary
                );
            }
            let out = call_atomic_ptr_5arg(
                "glGetProgramBinary",
                &self.glGetProgramBinary_p,
                program,
                bufSize,
                length,
                binaryFormat,
                binary,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetProgramBinary");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetProgramBinary_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetProgramBinary\0",
                &self.glGetProgramBinary_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetProgramBinary_is_loaded(&self) -> bool {
            !self.glGetProgramBinary_p.load(RELAX).is_null()
        }
        /// [glGetProgramInfoLog](http://docs.gl/gl4/glGetProgramInfoLog)(program, bufSize, length, infoLog)
        /// * `length` len: 1
        /// * `infoLog` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetProgramInfoLog(
            &self,
            program: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            infoLog: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetProgramInfoLog({:?}, {:?}, {:p}, {:p});",
                    program,
                    bufSize,
                    length,
                    infoLog
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetProgramInfoLog",
                &self.glGetProgramInfoLog_p,
                program,
                bufSize,
                length,
                infoLog,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetProgramInfoLog");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetProgramInfoLog_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetProgramInfoLog\0",
                &self.glGetProgramInfoLog_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetProgramInfoLog_is_loaded(&self) -> bool {
            !self.glGetProgramInfoLog_p.load(RELAX).is_null()
        }
        /// [glGetProgramInterfaceiv](http://docs.gl/gl4/glGetProgramInterface)(program, programInterface, pname, params)
        /// * `programInterface` group: ProgramInterface
        /// * `pname` group: ProgramInterfacePName
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetProgramInterfaceiv(
            &self,
            program: GLuint,
            programInterface: GLenum,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetProgramInterfaceiv({:?}, {:#X}, {:#X}, {:p});",
                    program,
                    programInterface,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetProgramInterfaceiv",
                &self.glGetProgramInterfaceiv_p,
                program,
                programInterface,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetProgramInterfaceiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetProgramInterfaceiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetProgramInterfaceiv\0",
                &self.glGetProgramInterfaceiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetProgramInterfaceiv_is_loaded(&self) -> bool {
            !self.glGetProgramInterfaceiv_p.load(RELAX).is_null()
        }
        /// [glGetProgramPipelineInfoLog](http://docs.gl/gl4/glGetProgramPipelineInfoLog)(pipeline, bufSize, length, infoLog)
        /// * `length` len: 1
        /// * `infoLog` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetProgramPipelineInfoLog(
            &self,
            pipeline: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            infoLog: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetProgramPipelineInfoLog({:?}, {:?}, {:p}, {:p});",
                    pipeline,
                    bufSize,
                    length,
                    infoLog
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetProgramPipelineInfoLog",
                &self.glGetProgramPipelineInfoLog_p,
                pipeline,
                bufSize,
                length,
                infoLog,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetProgramPipelineInfoLog");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetProgramPipelineInfoLog_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetProgramPipelineInfoLog\0",
                &self.glGetProgramPipelineInfoLog_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetProgramPipelineInfoLog_is_loaded(&self) -> bool {
            !self.glGetProgramPipelineInfoLog_p.load(RELAX).is_null()
        }
        /// [glGetProgramPipelineiv](http://docs.gl/gl4/glGetProgramPipeline)(pipeline, pname, params)
        /// * `pname` group: PipelineParameterName
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetProgramPipelineiv(
            &self,
            pipeline: GLuint,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetProgramPipelineiv({:?}, {:#X}, {:p});",
                    pipeline,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetProgramPipelineiv",
                &self.glGetProgramPipelineiv_p,
                pipeline,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetProgramPipelineiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetProgramPipelineiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetProgramPipelineiv\0",
                &self.glGetProgramPipelineiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetProgramPipelineiv_is_loaded(&self) -> bool {
            !self.glGetProgramPipelineiv_p.load(RELAX).is_null()
        }
        /// [glGetProgramResourceIndex](http://docs.gl/gl4/glGetProgramResourceIndex)(program, programInterface, name)
        /// * `programInterface` group: ProgramInterface
        /// * `name` len: COMPSIZE(name)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetProgramResourceIndex(
            &self,
            program: GLuint,
            programInterface: GLenum,
            name: *const GLchar,
        ) -> GLuint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetProgramResourceIndex({:?}, {:#X}, {:p});",
                    program,
                    programInterface,
                    name
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetProgramResourceIndex",
                &self.glGetProgramResourceIndex_p,
                program,
                programInterface,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetProgramResourceIndex");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetProgramResourceIndex_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetProgramResourceIndex\0",
                &self.glGetProgramResourceIndex_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetProgramResourceIndex_is_loaded(&self) -> bool {
            !self.glGetProgramResourceIndex_p.load(RELAX).is_null()
        }
        /// [glGetProgramResourceLocation](http://docs.gl/gl4/glGetProgramResourceLocation)(program, programInterface, name)
        /// * `programInterface` group: ProgramInterface
        /// * `name` len: COMPSIZE(name)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetProgramResourceLocation(
            &self,
            program: GLuint,
            programInterface: GLenum,
            name: *const GLchar,
        ) -> GLint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetProgramResourceLocation({:?}, {:#X}, {:p});",
                    program,
                    programInterface,
                    name
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetProgramResourceLocation",
                &self.glGetProgramResourceLocation_p,
                program,
                programInterface,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetProgramResourceLocation");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetProgramResourceLocation_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetProgramResourceLocation\0",
                &self.glGetProgramResourceLocation_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetProgramResourceLocation_is_loaded(&self) -> bool {
            !self.glGetProgramResourceLocation_p.load(RELAX).is_null()
        }
        /// [glGetProgramResourceLocationIndex](http://docs.gl/gl4/glGetProgramResourceLocationIndex)(program, programInterface, name)
        /// * `programInterface` group: ProgramInterface
        /// * `name` len: COMPSIZE(name)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetProgramResourceLocationIndex(
            &self,
            program: GLuint,
            programInterface: GLenum,
            name: *const GLchar,
        ) -> GLint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetProgramResourceLocationIndex({:?}, {:#X}, {:p});",
                    program,
                    programInterface,
                    name
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetProgramResourceLocationIndex",
                &self.glGetProgramResourceLocationIndex_p,
                program,
                programInterface,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetProgramResourceLocationIndex");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetProgramResourceLocationIndex_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetProgramResourceLocationIndex\0",
                &self.glGetProgramResourceLocationIndex_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetProgramResourceLocationIndex_is_loaded(&self) -> bool {
            !self
                .glGetProgramResourceLocationIndex_p
                .load(RELAX)
                .is_null()
        }
        /// [glGetProgramResourceName](http://docs.gl/gl4/glGetProgramResourceName)(program, programInterface, index, bufSize, length, name)
        /// * `programInterface` group: ProgramInterface
        /// * `length` len: 1
        /// * `name` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetProgramResourceName(
            &self,
            program: GLuint,
            programInterface: GLenum,
            index: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            name: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetProgramResourceName({:?}, {:#X}, {:?}, {:?}, {:p}, {:p});",
                    program,
                    programInterface,
                    index,
                    bufSize,
                    length,
                    name
                );
            }
            let out = call_atomic_ptr_6arg(
                "glGetProgramResourceName",
                &self.glGetProgramResourceName_p,
                program,
                programInterface,
                index,
                bufSize,
                length,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetProgramResourceName");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetProgramResourceName_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetProgramResourceName\0",
                &self.glGetProgramResourceName_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetProgramResourceName_is_loaded(&self) -> bool {
            !self.glGetProgramResourceName_p.load(RELAX).is_null()
        }
        /// [glGetProgramResourceiv](http://docs.gl/gl4/glGetProgramResource)(program, programInterface, index, propCount, props, count, length, params)
        /// * `programInterface` group: ProgramInterface
        /// * `props` group: ProgramResourceProperty
        /// * `props` len: propCount
        /// * `length` len: 1
        /// * `params` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetProgramResourceiv(
            &self,
            program: GLuint,
            programInterface: GLenum,
            index: GLuint,
            propCount: GLsizei,
            props: *const GLenum,
            count: GLsizei,
            length: *mut GLsizei,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetProgramResourceiv({:?}, {:#X}, {:?}, {:?}, {:p}, {:?}, {:p}, {:p});", program, programInterface, index, propCount, props, count, length, params);
            }
            let out = call_atomic_ptr_8arg(
                "glGetProgramResourceiv",
                &self.glGetProgramResourceiv_p,
                program,
                programInterface,
                index,
                propCount,
                props,
                count,
                length,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetProgramResourceiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetProgramResourceiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetProgramResourceiv\0",
                &self.glGetProgramResourceiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetProgramResourceiv_is_loaded(&self) -> bool {
            !self.glGetProgramResourceiv_p.load(RELAX).is_null()
        }
        /// [glGetProgramStageiv](http://docs.gl/gl4/glGetProgramStage)(program, shadertype, pname, values)
        /// * `shadertype` group: ShaderType
        /// * `pname` group: ProgramStagePName
        /// * `values` len: 1
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetProgramStageiv(
            &self,
            program: GLuint,
            shadertype: GLenum,
            pname: GLenum,
            values: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetProgramStageiv({:?}, {:#X}, {:#X}, {:p});",
                    program,
                    shadertype,
                    pname,
                    values
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetProgramStageiv",
                &self.glGetProgramStageiv_p,
                program,
                shadertype,
                pname,
                values,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetProgramStageiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetProgramStageiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetProgramStageiv\0",
                &self.glGetProgramStageiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetProgramStageiv_is_loaded(&self) -> bool {
            !self.glGetProgramStageiv_p.load(RELAX).is_null()
        }
        /// [glGetProgramiv](http://docs.gl/gl4/glGetProgram)(program, pname, params)
        /// * `pname` group: ProgramPropertyARB
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetProgramiv(&self, program: GLuint, pname: GLenum, params: *mut GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetProgramiv({:?}, {:#X}, {:p});",
                    program,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetProgramiv",
                &self.glGetProgramiv_p,
                program,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetProgramiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetProgramiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetProgramiv\0",
                &self.glGetProgramiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetProgramiv_is_loaded(&self) -> bool {
            !self.glGetProgramiv_p.load(RELAX).is_null()
        }
        /// [glGetQueryBufferObjecti64v](http://docs.gl/gl4/glGetQueryBufferObject)(id, buffer, pname, offset)
        /// * `pname` group: QueryObjectParameterName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetQueryBufferObjecti64v(
            &self,
            id: GLuint,
            buffer: GLuint,
            pname: GLenum,
            offset: GLintptr,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetQueryBufferObjecti64v({:?}, {:?}, {:#X}, {:?});",
                    id,
                    buffer,
                    pname,
                    offset
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetQueryBufferObjecti64v",
                &self.glGetQueryBufferObjecti64v_p,
                id,
                buffer,
                pname,
                offset,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetQueryBufferObjecti64v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetQueryBufferObjecti64v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetQueryBufferObjecti64v\0",
                &self.glGetQueryBufferObjecti64v_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetQueryBufferObjecti64v_is_loaded(&self) -> bool {
            !self.glGetQueryBufferObjecti64v_p.load(RELAX).is_null()
        }
        /// [glGetQueryBufferObjectiv](http://docs.gl/gl4/glGetQueryBufferObject)(id, buffer, pname, offset)
        /// * `pname` group: QueryObjectParameterName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetQueryBufferObjectiv(
            &self,
            id: GLuint,
            buffer: GLuint,
            pname: GLenum,
            offset: GLintptr,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetQueryBufferObjectiv({:?}, {:?}, {:#X}, {:?});",
                    id,
                    buffer,
                    pname,
                    offset
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetQueryBufferObjectiv",
                &self.glGetQueryBufferObjectiv_p,
                id,
                buffer,
                pname,
                offset,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetQueryBufferObjectiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetQueryBufferObjectiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetQueryBufferObjectiv\0",
                &self.glGetQueryBufferObjectiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetQueryBufferObjectiv_is_loaded(&self) -> bool {
            !self.glGetQueryBufferObjectiv_p.load(RELAX).is_null()
        }
        /// [glGetQueryBufferObjectui64v](http://docs.gl/gl4/glGetQueryBufferObjectu)(id, buffer, pname, offset)
        /// * `pname` group: QueryObjectParameterName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetQueryBufferObjectui64v(
            &self,
            id: GLuint,
            buffer: GLuint,
            pname: GLenum,
            offset: GLintptr,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetQueryBufferObjectui64v({:?}, {:?}, {:#X}, {:?});",
                    id,
                    buffer,
                    pname,
                    offset
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetQueryBufferObjectui64v",
                &self.glGetQueryBufferObjectui64v_p,
                id,
                buffer,
                pname,
                offset,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetQueryBufferObjectui64v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetQueryBufferObjectui64v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetQueryBufferObjectui64v\0",
                &self.glGetQueryBufferObjectui64v_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetQueryBufferObjectui64v_is_loaded(&self) -> bool {
            !self.glGetQueryBufferObjectui64v_p.load(RELAX).is_null()
        }
        /// [glGetQueryBufferObjectuiv](http://docs.gl/gl4/glGetQueryBufferObject)(id, buffer, pname, offset)
        /// * `pname` group: QueryObjectParameterName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetQueryBufferObjectuiv(
            &self,
            id: GLuint,
            buffer: GLuint,
            pname: GLenum,
            offset: GLintptr,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetQueryBufferObjectuiv({:?}, {:?}, {:#X}, {:?});",
                    id,
                    buffer,
                    pname,
                    offset
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetQueryBufferObjectuiv",
                &self.glGetQueryBufferObjectuiv_p,
                id,
                buffer,
                pname,
                offset,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetQueryBufferObjectuiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetQueryBufferObjectuiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetQueryBufferObjectuiv\0",
                &self.glGetQueryBufferObjectuiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetQueryBufferObjectuiv_is_loaded(&self) -> bool {
            !self.glGetQueryBufferObjectuiv_p.load(RELAX).is_null()
        }
        /// [glGetQueryIndexediv](http://docs.gl/gl4/glGetQueryIndexed)(target, index, pname, params)
        /// * `target` group: QueryTarget
        /// * `pname` group: QueryParameterName
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetQueryIndexediv(
            &self,
            target: GLenum,
            index: GLuint,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetQueryIndexediv({:#X}, {:?}, {:#X}, {:p});",
                    target,
                    index,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetQueryIndexediv",
                &self.glGetQueryIndexediv_p,
                target,
                index,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetQueryIndexediv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetQueryIndexediv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetQueryIndexediv\0",
                &self.glGetQueryIndexediv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetQueryIndexediv_is_loaded(&self) -> bool {
            !self.glGetQueryIndexediv_p.load(RELAX).is_null()
        }
        /// [glGetQueryObjecti64v](http://docs.gl/gl4/glGetQueryObject)(id, pname, params)
        /// * `pname` group: QueryObjectParameterName
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetQueryObjecti64v(&self, id: GLuint, pname: GLenum, params: *mut GLint64) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetQueryObjecti64v({:?}, {:#X}, {:p});",
                    id,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetQueryObjecti64v",
                &self.glGetQueryObjecti64v_p,
                id,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetQueryObjecti64v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetQueryObjecti64v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetQueryObjecti64v\0",
                &self.glGetQueryObjecti64v_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetQueryObjecti64v_is_loaded(&self) -> bool {
            !self.glGetQueryObjecti64v_p.load(RELAX).is_null()
        }
        /// [glGetQueryObjectiv](http://docs.gl/gl4/glGetQueryObject)(id, pname, params)
        /// * `pname` group: QueryObjectParameterName
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetQueryObjectiv(&self, id: GLuint, pname: GLenum, params: *mut GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetQueryObjectiv({:?}, {:#X}, {:p});",
                    id,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetQueryObjectiv",
                &self.glGetQueryObjectiv_p,
                id,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetQueryObjectiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetQueryObjectiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetQueryObjectiv\0",
                &self.glGetQueryObjectiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetQueryObjectiv_is_loaded(&self) -> bool {
            !self.glGetQueryObjectiv_p.load(RELAX).is_null()
        }
        /// [glGetQueryObjectui64v](http://docs.gl/gl4/glGetQueryObjectu)(id, pname, params)
        /// * `pname` group: QueryObjectParameterName
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetQueryObjectui64v(&self, id: GLuint, pname: GLenum, params: *mut GLuint64) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetQueryObjectui64v({:?}, {:#X}, {:p});",
                    id,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetQueryObjectui64v",
                &self.glGetQueryObjectui64v_p,
                id,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetQueryObjectui64v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetQueryObjectui64v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetQueryObjectui64v\0",
                &self.glGetQueryObjectui64v_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetQueryObjectui64v_is_loaded(&self) -> bool {
            !self.glGetQueryObjectui64v_p.load(RELAX).is_null()
        }
        /// [glGetQueryObjectuiv](http://docs.gl/gl4/glGetQueryObject)(id, pname, params)
        /// * `pname` group: QueryObjectParameterName
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetQueryObjectuiv(&self, id: GLuint, pname: GLenum, params: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetQueryObjectuiv({:?}, {:#X}, {:p});",
                    id,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetQueryObjectuiv",
                &self.glGetQueryObjectuiv_p,
                id,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetQueryObjectuiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetQueryObjectuiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetQueryObjectuiv\0",
                &self.glGetQueryObjectuiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetQueryObjectuiv_is_loaded(&self) -> bool {
            !self.glGetQueryObjectuiv_p.load(RELAX).is_null()
        }
        /// [glGetQueryiv](http://docs.gl/gl4/glGetQuery)(target, pname, params)
        /// * `target` group: QueryTarget
        /// * `pname` group: QueryParameterName
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetQueryiv(&self, target: GLenum, pname: GLenum, params: *mut GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetQueryiv({:#X}, {:#X}, {:p});",
                    target,
                    pname,
                    params
                );
            }
            let out =
                call_atomic_ptr_3arg("glGetQueryiv", &self.glGetQueryiv_p, target, pname, params);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetQueryiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetQueryiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGetQueryiv\0", &self.glGetQueryiv_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetQueryiv_is_loaded(&self) -> bool {
            !self.glGetQueryiv_p.load(RELAX).is_null()
        }
        /// [glGetRenderbufferParameteriv](http://docs.gl/gl4/glGetRenderbufferParameter)(target, pname, params)
        /// * `target` group: RenderbufferTarget
        /// * `pname` group: RenderbufferParameterName
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetRenderbufferParameteriv(
            &self,
            target: GLenum,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetRenderbufferParameteriv({:#X}, {:#X}, {:p});",
                    target,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetRenderbufferParameteriv",
                &self.glGetRenderbufferParameteriv_p,
                target,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetRenderbufferParameteriv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetRenderbufferParameteriv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetRenderbufferParameteriv\0",
                &self.glGetRenderbufferParameteriv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetRenderbufferParameteriv_is_loaded(&self) -> bool {
            !self.glGetRenderbufferParameteriv_p.load(RELAX).is_null()
        }
        /// [glGetSamplerParameterIiv](http://docs.gl/gl4/glGetSamplerParameter)(sampler, pname, params)
        /// * `pname` group: SamplerParameterI
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetSamplerParameterIiv(
            &self,
            sampler: GLuint,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetSamplerParameterIiv({:?}, {:#X}, {:p});",
                    sampler,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetSamplerParameterIiv",
                &self.glGetSamplerParameterIiv_p,
                sampler,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetSamplerParameterIiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetSamplerParameterIiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetSamplerParameterIiv\0",
                &self.glGetSamplerParameterIiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetSamplerParameterIiv_is_loaded(&self) -> bool {
            !self.glGetSamplerParameterIiv_p.load(RELAX).is_null()
        }
        /// [glGetSamplerParameterIuiv](http://docs.gl/gl4/glGetSamplerParameter)(sampler, pname, params)
        /// * `pname` group: SamplerParameterI
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetSamplerParameterIuiv(
            &self,
            sampler: GLuint,
            pname: GLenum,
            params: *mut GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetSamplerParameterIuiv({:?}, {:#X}, {:p});",
                    sampler,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetSamplerParameterIuiv",
                &self.glGetSamplerParameterIuiv_p,
                sampler,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetSamplerParameterIuiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetSamplerParameterIuiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetSamplerParameterIuiv\0",
                &self.glGetSamplerParameterIuiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetSamplerParameterIuiv_is_loaded(&self) -> bool {
            !self.glGetSamplerParameterIuiv_p.load(RELAX).is_null()
        }
        /// [glGetSamplerParameterfv](http://docs.gl/gl4/glGetSamplerParameter)(sampler, pname, params)
        /// * `pname` group: SamplerParameterF
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetSamplerParameterfv(
            &self,
            sampler: GLuint,
            pname: GLenum,
            params: *mut GLfloat,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetSamplerParameterfv({:?}, {:#X}, {:p});",
                    sampler,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetSamplerParameterfv",
                &self.glGetSamplerParameterfv_p,
                sampler,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetSamplerParameterfv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetSamplerParameterfv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetSamplerParameterfv\0",
                &self.glGetSamplerParameterfv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetSamplerParameterfv_is_loaded(&self) -> bool {
            !self.glGetSamplerParameterfv_p.load(RELAX).is_null()
        }
        /// [glGetSamplerParameteriv](http://docs.gl/gl4/glGetSamplerParameter)(sampler, pname, params)
        /// * `pname` group: SamplerParameterI
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetSamplerParameteriv(
            &self,
            sampler: GLuint,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetSamplerParameteriv({:?}, {:#X}, {:p});",
                    sampler,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetSamplerParameteriv",
                &self.glGetSamplerParameteriv_p,
                sampler,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetSamplerParameteriv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetSamplerParameteriv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetSamplerParameteriv\0",
                &self.glGetSamplerParameteriv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetSamplerParameteriv_is_loaded(&self) -> bool {
            !self.glGetSamplerParameteriv_p.load(RELAX).is_null()
        }
        /// [glGetShaderInfoLog](http://docs.gl/gl4/glGetShaderInfoLog)(shader, bufSize, length, infoLog)
        /// * `length` len: 1
        /// * `infoLog` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetShaderInfoLog(
            &self,
            shader: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            infoLog: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetShaderInfoLog({:?}, {:?}, {:p}, {:p});",
                    shader,
                    bufSize,
                    length,
                    infoLog
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetShaderInfoLog",
                &self.glGetShaderInfoLog_p,
                shader,
                bufSize,
                length,
                infoLog,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetShaderInfoLog");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetShaderInfoLog_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetShaderInfoLog\0",
                &self.glGetShaderInfoLog_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetShaderInfoLog_is_loaded(&self) -> bool {
            !self.glGetShaderInfoLog_p.load(RELAX).is_null()
        }
        /// [glGetShaderPrecisionFormat](http://docs.gl/gl4/glGetShaderPrecisionFormat)(shadertype, precisiontype, range, precision)
        /// * `shadertype` group: ShaderType
        /// * `precisiontype` group: PrecisionType
        /// * `range` len: 2
        /// * `precision` len: 1
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetShaderPrecisionFormat(
            &self,
            shadertype: GLenum,
            precisiontype: GLenum,
            range: *mut GLint,
            precision: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetShaderPrecisionFormat({:#X}, {:#X}, {:p}, {:p});",
                    shadertype,
                    precisiontype,
                    range,
                    precision
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetShaderPrecisionFormat",
                &self.glGetShaderPrecisionFormat_p,
                shadertype,
                precisiontype,
                range,
                precision,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetShaderPrecisionFormat");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetShaderPrecisionFormat_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetShaderPrecisionFormat\0",
                &self.glGetShaderPrecisionFormat_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetShaderPrecisionFormat_is_loaded(&self) -> bool {
            !self.glGetShaderPrecisionFormat_p.load(RELAX).is_null()
        }
        /// [glGetShaderSource](http://docs.gl/gl4/glGetShaderSource)(shader, bufSize, length, source)
        /// * `length` len: 1
        /// * `source` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetShaderSource(
            &self,
            shader: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            source: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetShaderSource({:?}, {:?}, {:p}, {:p});",
                    shader,
                    bufSize,
                    length,
                    source
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetShaderSource",
                &self.glGetShaderSource_p,
                shader,
                bufSize,
                length,
                source,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetShaderSource");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetShaderSource_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetShaderSource\0",
                &self.glGetShaderSource_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetShaderSource_is_loaded(&self) -> bool {
            !self.glGetShaderSource_p.load(RELAX).is_null()
        }
        /// [glGetShaderiv](http://docs.gl/gl4/glGetShaderiv)(shader, pname, params)
        /// * `pname` group: ShaderParameterName
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetShaderiv(&self, shader: GLuint, pname: GLenum, params: *mut GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetShaderiv({:?}, {:#X}, {:p});",
                    shader,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetShaderiv",
                &self.glGetShaderiv_p,
                shader,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetShaderiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetShaderiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGetShaderiv\0", &self.glGetShaderiv_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetShaderiv_is_loaded(&self) -> bool {
            !self.glGetShaderiv_p.load(RELAX).is_null()
        }
        /// [glGetString](http://docs.gl/gl4/glGetString)(name)
        /// * `name` group: StringName
        /// * return value group: String
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetString(&self, name: GLenum) -> *const GLubyte {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetString({:#X});", name);
            }
            let out = call_atomic_ptr_1arg("glGetString", &self.glGetString_p, name);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetString");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetString_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGetString\0", &self.glGetString_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetString_is_loaded(&self) -> bool {
            !self.glGetString_p.load(RELAX).is_null()
        }
        /// [glGetStringi](http://docs.gl/gl4/glGetString)(name, index)
        /// * `name` group: StringName
        /// * return value group: String
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetStringi(&self, name: GLenum, index: GLuint) -> *const GLubyte {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetStringi({:#X}, {:?});", name, index);
            }
            let out = call_atomic_ptr_2arg("glGetStringi", &self.glGetStringi_p, name, index);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetStringi");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetStringi_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGetStringi\0", &self.glGetStringi_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetStringi_is_loaded(&self) -> bool {
            !self.glGetStringi_p.load(RELAX).is_null()
        }
        /// [glGetSubroutineIndex](http://docs.gl/gl4/glGetSubroutineIndex)(program, shadertype, name)
        /// * `shadertype` group: ShaderType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetSubroutineIndex(
            &self,
            program: GLuint,
            shadertype: GLenum,
            name: *const GLchar,
        ) -> GLuint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetSubroutineIndex({:?}, {:#X}, {:p});",
                    program,
                    shadertype,
                    name
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetSubroutineIndex",
                &self.glGetSubroutineIndex_p,
                program,
                shadertype,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetSubroutineIndex");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetSubroutineIndex_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetSubroutineIndex\0",
                &self.glGetSubroutineIndex_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetSubroutineIndex_is_loaded(&self) -> bool {
            !self.glGetSubroutineIndex_p.load(RELAX).is_null()
        }
        /// [glGetSubroutineUniformLocation](http://docs.gl/gl4/glGetSubroutineUniformLocation)(program, shadertype, name)
        /// * `shadertype` group: ShaderType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetSubroutineUniformLocation(
            &self,
            program: GLuint,
            shadertype: GLenum,
            name: *const GLchar,
        ) -> GLint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetSubroutineUniformLocation({:?}, {:#X}, {:p});",
                    program,
                    shadertype,
                    name
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetSubroutineUniformLocation",
                &self.glGetSubroutineUniformLocation_p,
                program,
                shadertype,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetSubroutineUniformLocation");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetSubroutineUniformLocation_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetSubroutineUniformLocation\0",
                &self.glGetSubroutineUniformLocation_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetSubroutineUniformLocation_is_loaded(&self) -> bool {
            !self.glGetSubroutineUniformLocation_p.load(RELAX).is_null()
        }
        /// [glGetSynciv](http://docs.gl/gl4/glGetSync)(sync, pname, count, length, values)
        /// * `sync` group: sync
        /// * `pname` group: SyncParameterName
        /// * `length` len: 1
        /// * `values` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetSynciv(
            &self,
            sync: GLsync,
            pname: GLenum,
            count: GLsizei,
            length: *mut GLsizei,
            values: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetSynciv({:p}, {:#X}, {:?}, {:p}, {:p});",
                    sync,
                    pname,
                    count,
                    length,
                    values
                );
            }
            let out = call_atomic_ptr_5arg(
                "glGetSynciv",
                &self.glGetSynciv_p,
                sync,
                pname,
                count,
                length,
                values,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetSynciv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetSynciv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGetSynciv\0", &self.glGetSynciv_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetSynciv_is_loaded(&self) -> bool {
            !self.glGetSynciv_p.load(RELAX).is_null()
        }
        /// [glGetTexImage](http://docs.gl/gl4/glGetTexImage)(target, level, format, type_, pixels)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `format` group: PixelFormat
        /// * `type_` group: PixelType
        /// * `pixels` len: COMPSIZE(target,level,format,type)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTexImage(
            &self,
            target: GLenum,
            level: GLint,
            format: GLenum,
            type_: GLenum,
            pixels: *mut c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTexImage({:#X}, {:?}, {:#X}, {:#X}, {:p});",
                    target,
                    level,
                    format,
                    type_,
                    pixels
                );
            }
            let out = call_atomic_ptr_5arg(
                "glGetTexImage",
                &self.glGetTexImage_p,
                target,
                level,
                format,
                type_,
                pixels,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTexImage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTexImage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glGetTexImage\0", &self.glGetTexImage_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTexImage_is_loaded(&self) -> bool {
            !self.glGetTexImage_p.load(RELAX).is_null()
        }
        /// [glGetTexLevelParameterfv](http://docs.gl/gl4/glGetTexLevelParameter)(target, level, pname, params)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `pname` group: GetTextureParameter
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTexLevelParameterfv(
            &self,
            target: GLenum,
            level: GLint,
            pname: GLenum,
            params: *mut GLfloat,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTexLevelParameterfv({:#X}, {:?}, {:#X}, {:p});",
                    target,
                    level,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetTexLevelParameterfv",
                &self.glGetTexLevelParameterfv_p,
                target,
                level,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTexLevelParameterfv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTexLevelParameterfv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTexLevelParameterfv\0",
                &self.glGetTexLevelParameterfv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTexLevelParameterfv_is_loaded(&self) -> bool {
            !self.glGetTexLevelParameterfv_p.load(RELAX).is_null()
        }
        /// [glGetTexLevelParameteriv](http://docs.gl/gl4/glGetTexLevelParameter)(target, level, pname, params)
        /// * `target` group: TextureTarget
        /// * `level` group: CheckedInt32
        /// * `pname` group: GetTextureParameter
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTexLevelParameteriv(
            &self,
            target: GLenum,
            level: GLint,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTexLevelParameteriv({:#X}, {:?}, {:#X}, {:p});",
                    target,
                    level,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetTexLevelParameteriv",
                &self.glGetTexLevelParameteriv_p,
                target,
                level,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTexLevelParameteriv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTexLevelParameteriv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTexLevelParameteriv\0",
                &self.glGetTexLevelParameteriv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTexLevelParameteriv_is_loaded(&self) -> bool {
            !self.glGetTexLevelParameteriv_p.load(RELAX).is_null()
        }
        /// [glGetTexParameterIiv](http://docs.gl/gl4/glGetTexParameter)(target, pname, params)
        /// * `target` group: TextureTarget
        /// * `pname` group: GetTextureParameter
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTexParameterIiv(&self, target: GLenum, pname: GLenum, params: *mut GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTexParameterIiv({:#X}, {:#X}, {:p});",
                    target,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetTexParameterIiv",
                &self.glGetTexParameterIiv_p,
                target,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTexParameterIiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTexParameterIiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTexParameterIiv\0",
                &self.glGetTexParameterIiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTexParameterIiv_is_loaded(&self) -> bool {
            !self.glGetTexParameterIiv_p.load(RELAX).is_null()
        }
        /// [glGetTexParameterIuiv](http://docs.gl/gl4/glGetTexParameter)(target, pname, params)
        /// * `target` group: TextureTarget
        /// * `pname` group: GetTextureParameter
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTexParameterIuiv(
            &self,
            target: GLenum,
            pname: GLenum,
            params: *mut GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTexParameterIuiv({:#X}, {:#X}, {:p});",
                    target,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetTexParameterIuiv",
                &self.glGetTexParameterIuiv_p,
                target,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTexParameterIuiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTexParameterIuiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTexParameterIuiv\0",
                &self.glGetTexParameterIuiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTexParameterIuiv_is_loaded(&self) -> bool {
            !self.glGetTexParameterIuiv_p.load(RELAX).is_null()
        }
        /// [glGetTexParameterfv](http://docs.gl/gl4/glGetTexParameter)(target, pname, params)
        /// * `target` group: TextureTarget
        /// * `pname` group: GetTextureParameter
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTexParameterfv(
            &self,
            target: GLenum,
            pname: GLenum,
            params: *mut GLfloat,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTexParameterfv({:#X}, {:#X}, {:p});",
                    target,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetTexParameterfv",
                &self.glGetTexParameterfv_p,
                target,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTexParameterfv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTexParameterfv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTexParameterfv\0",
                &self.glGetTexParameterfv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTexParameterfv_is_loaded(&self) -> bool {
            !self.glGetTexParameterfv_p.load(RELAX).is_null()
        }
        /// [glGetTexParameteriv](http://docs.gl/gl4/glGetTexParameter)(target, pname, params)
        /// * `target` group: TextureTarget
        /// * `pname` group: GetTextureParameter
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTexParameteriv(&self, target: GLenum, pname: GLenum, params: *mut GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTexParameteriv({:#X}, {:#X}, {:p});",
                    target,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetTexParameteriv",
                &self.glGetTexParameteriv_p,
                target,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTexParameteriv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTexParameteriv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTexParameteriv\0",
                &self.glGetTexParameteriv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTexParameteriv_is_loaded(&self) -> bool {
            !self.glGetTexParameteriv_p.load(RELAX).is_null()
        }
        /// [glGetTextureImage](http://docs.gl/gl4/glGetTextureImage)(texture, level, format, type_, bufSize, pixels)
        /// * `format` group: PixelFormat
        /// * `type_` group: PixelType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTextureImage(
            &self,
            texture: GLuint,
            level: GLint,
            format: GLenum,
            type_: GLenum,
            bufSize: GLsizei,
            pixels: *mut c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTextureImage({:?}, {:?}, {:#X}, {:#X}, {:?}, {:p});",
                    texture,
                    level,
                    format,
                    type_,
                    bufSize,
                    pixels
                );
            }
            let out = call_atomic_ptr_6arg(
                "glGetTextureImage",
                &self.glGetTextureImage_p,
                texture,
                level,
                format,
                type_,
                bufSize,
                pixels,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTextureImage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTextureImage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTextureImage\0",
                &self.glGetTextureImage_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTextureImage_is_loaded(&self) -> bool {
            !self.glGetTextureImage_p.load(RELAX).is_null()
        }
        /// [glGetTextureLevelParameterfv](http://docs.gl/gl4/glGetTextureLevelParameter)(texture, level, pname, params)
        /// * `pname` group: GetTextureParameter
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTextureLevelParameterfv(
            &self,
            texture: GLuint,
            level: GLint,
            pname: GLenum,
            params: *mut GLfloat,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTextureLevelParameterfv({:?}, {:?}, {:#X}, {:p});",
                    texture,
                    level,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetTextureLevelParameterfv",
                &self.glGetTextureLevelParameterfv_p,
                texture,
                level,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTextureLevelParameterfv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTextureLevelParameterfv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTextureLevelParameterfv\0",
                &self.glGetTextureLevelParameterfv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTextureLevelParameterfv_is_loaded(&self) -> bool {
            !self.glGetTextureLevelParameterfv_p.load(RELAX).is_null()
        }
        /// [glGetTextureLevelParameteriv](http://docs.gl/gl4/glGetTextureLevelParameter)(texture, level, pname, params)
        /// * `pname` group: GetTextureParameter
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTextureLevelParameteriv(
            &self,
            texture: GLuint,
            level: GLint,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTextureLevelParameteriv({:?}, {:?}, {:#X}, {:p});",
                    texture,
                    level,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetTextureLevelParameteriv",
                &self.glGetTextureLevelParameteriv_p,
                texture,
                level,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTextureLevelParameteriv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTextureLevelParameteriv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTextureLevelParameteriv\0",
                &self.glGetTextureLevelParameteriv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTextureLevelParameteriv_is_loaded(&self) -> bool {
            !self.glGetTextureLevelParameteriv_p.load(RELAX).is_null()
        }
        /// [glGetTextureParameterIiv](http://docs.gl/gl4/glGetTextureParameter)(texture, pname, params)
        /// * `pname` group: GetTextureParameter
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTextureParameterIiv(
            &self,
            texture: GLuint,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTextureParameterIiv({:?}, {:#X}, {:p});",
                    texture,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetTextureParameterIiv",
                &self.glGetTextureParameterIiv_p,
                texture,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTextureParameterIiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTextureParameterIiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTextureParameterIiv\0",
                &self.glGetTextureParameterIiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTextureParameterIiv_is_loaded(&self) -> bool {
            !self.glGetTextureParameterIiv_p.load(RELAX).is_null()
        }
        /// [glGetTextureParameterIuiv](http://docs.gl/gl4/glGetTextureParameter)(texture, pname, params)
        /// * `pname` group: GetTextureParameter
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTextureParameterIuiv(
            &self,
            texture: GLuint,
            pname: GLenum,
            params: *mut GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTextureParameterIuiv({:?}, {:#X}, {:p});",
                    texture,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetTextureParameterIuiv",
                &self.glGetTextureParameterIuiv_p,
                texture,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTextureParameterIuiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTextureParameterIuiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTextureParameterIuiv\0",
                &self.glGetTextureParameterIuiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTextureParameterIuiv_is_loaded(&self) -> bool {
            !self.glGetTextureParameterIuiv_p.load(RELAX).is_null()
        }
        /// [glGetTextureParameterfv](http://docs.gl/gl4/glGetTextureParameter)(texture, pname, params)
        /// * `pname` group: GetTextureParameter
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTextureParameterfv(
            &self,
            texture: GLuint,
            pname: GLenum,
            params: *mut GLfloat,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTextureParameterfv({:?}, {:#X}, {:p});",
                    texture,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetTextureParameterfv",
                &self.glGetTextureParameterfv_p,
                texture,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTextureParameterfv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTextureParameterfv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTextureParameterfv\0",
                &self.glGetTextureParameterfv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTextureParameterfv_is_loaded(&self) -> bool {
            !self.glGetTextureParameterfv_p.load(RELAX).is_null()
        }
        /// [glGetTextureParameteriv](http://docs.gl/gl4/glGetTextureParameter)(texture, pname, params)
        /// * `pname` group: GetTextureParameter
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTextureParameteriv(
            &self,
            texture: GLuint,
            pname: GLenum,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTextureParameteriv({:?}, {:#X}, {:p});",
                    texture,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetTextureParameteriv",
                &self.glGetTextureParameteriv_p,
                texture,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTextureParameteriv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTextureParameteriv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTextureParameteriv\0",
                &self.glGetTextureParameteriv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTextureParameteriv_is_loaded(&self) -> bool {
            !self.glGetTextureParameteriv_p.load(RELAX).is_null()
        }
        /// [glGetTextureSubImage](http://docs.gl/gl4/glGetTextureSubImage)(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type_, bufSize, pixels)
        /// * `format` group: PixelFormat
        /// * `type_` group: PixelType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTextureSubImage(
            &self,
            texture: GLuint,
            level: GLint,
            xoffset: GLint,
            yoffset: GLint,
            zoffset: GLint,
            width: GLsizei,
            height: GLsizei,
            depth: GLsizei,
            format: GLenum,
            type_: GLenum,
            bufSize: GLsizei,
            pixels: *mut c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetTextureSubImage({:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:#X}, {:#X}, {:?}, {:p});", texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type_, bufSize, pixels);
            }
            let out = call_atomic_ptr_12arg(
                "glGetTextureSubImage",
                &self.glGetTextureSubImage_p,
                texture,
                level,
                xoffset,
                yoffset,
                zoffset,
                width,
                height,
                depth,
                format,
                type_,
                bufSize,
                pixels,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTextureSubImage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTextureSubImage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTextureSubImage\0",
                &self.glGetTextureSubImage_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTextureSubImage_is_loaded(&self) -> bool {
            !self.glGetTextureSubImage_p.load(RELAX).is_null()
        }
        /// [glGetTransformFeedbackVarying](http://docs.gl/gl4/glGetTransformFeedbackVarying)(program, index, bufSize, length, size, type_, name)
        /// * `length` len: 1
        /// * `size` len: 1
        /// * `type_` group: AttributeType
        /// * `type_` len: 1
        /// * `name` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTransformFeedbackVarying(
            &self,
            program: GLuint,
            index: GLuint,
            bufSize: GLsizei,
            length: *mut GLsizei,
            size: *mut GLsizei,
            type_: *mut GLenum,
            name: *mut GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetTransformFeedbackVarying({:?}, {:?}, {:?}, {:p}, {:p}, {:p}, {:p});", program, index, bufSize, length, size, type_, name);
            }
            let out = call_atomic_ptr_7arg(
                "glGetTransformFeedbackVarying",
                &self.glGetTransformFeedbackVarying_p,
                program,
                index,
                bufSize,
                length,
                size,
                type_,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTransformFeedbackVarying");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTransformFeedbackVarying_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTransformFeedbackVarying\0",
                &self.glGetTransformFeedbackVarying_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTransformFeedbackVarying_is_loaded(&self) -> bool {
            !self.glGetTransformFeedbackVarying_p.load(RELAX).is_null()
        }
        /// [glGetTransformFeedbacki64_v](http://docs.gl/gl4/glGetTransformFeedbacki64_v)(xfb, pname, index, param)
        /// * `pname` group: TransformFeedbackPName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTransformFeedbacki64_v(
            &self,
            xfb: GLuint,
            pname: GLenum,
            index: GLuint,
            param: *mut GLint64,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTransformFeedbacki64_v({:?}, {:#X}, {:?}, {:p});",
                    xfb,
                    pname,
                    index,
                    param
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetTransformFeedbacki64_v",
                &self.glGetTransformFeedbacki64_v_p,
                xfb,
                pname,
                index,
                param,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTransformFeedbacki64_v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTransformFeedbacki64_v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTransformFeedbacki64_v\0",
                &self.glGetTransformFeedbacki64_v_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTransformFeedbacki64_v_is_loaded(&self) -> bool {
            !self.glGetTransformFeedbacki64_v_p.load(RELAX).is_null()
        }
        /// [glGetTransformFeedbacki_v](http://docs.gl/gl4/glGetTransformFeedbacki_v)(xfb, pname, index, param)
        /// * `pname` group: TransformFeedbackPName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTransformFeedbacki_v(
            &self,
            xfb: GLuint,
            pname: GLenum,
            index: GLuint,
            param: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTransformFeedbacki_v({:?}, {:#X}, {:?}, {:p});",
                    xfb,
                    pname,
                    index,
                    param
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetTransformFeedbacki_v",
                &self.glGetTransformFeedbacki_v_p,
                xfb,
                pname,
                index,
                param,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTransformFeedbacki_v");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTransformFeedbacki_v_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTransformFeedbacki_v\0",
                &self.glGetTransformFeedbacki_v_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTransformFeedbacki_v_is_loaded(&self) -> bool {
            !self.glGetTransformFeedbacki_v_p.load(RELAX).is_null()
        }
        /// [glGetTransformFeedbackiv](http://docs.gl/gl4/glGetTransformFeedback)(xfb, pname, param)
        /// * `pname` group: TransformFeedbackPName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetTransformFeedbackiv(&self, xfb: GLuint, pname: GLenum, param: *mut GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetTransformFeedbackiv({:?}, {:#X}, {:p});",
                    xfb,
                    pname,
                    param
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetTransformFeedbackiv",
                &self.glGetTransformFeedbackiv_p,
                xfb,
                pname,
                param,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetTransformFeedbackiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetTransformFeedbackiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetTransformFeedbackiv\0",
                &self.glGetTransformFeedbackiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetTransformFeedbackiv_is_loaded(&self) -> bool {
            !self.glGetTransformFeedbackiv_p.load(RELAX).is_null()
        }
        /// [glGetUniformBlockIndex](http://docs.gl/gl4/glGetUniformBlockIndex)(program, uniformBlockName)
        /// * `uniformBlockName` len: COMPSIZE()
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetUniformBlockIndex(
            &self,
            program: GLuint,
            uniformBlockName: *const GLchar,
        ) -> GLuint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetUniformBlockIndex({:?}, {:p});",
                    program,
                    uniformBlockName
                );
            }
            let out = call_atomic_ptr_2arg(
                "glGetUniformBlockIndex",
                &self.glGetUniformBlockIndex_p,
                program,
                uniformBlockName,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetUniformBlockIndex");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetUniformBlockIndex_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetUniformBlockIndex\0",
                &self.glGetUniformBlockIndex_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetUniformBlockIndex_is_loaded(&self) -> bool {
            !self.glGetUniformBlockIndex_p.load(RELAX).is_null()
        }
        /// [glGetUniformIndices](http://docs.gl/gl4/glGetUniformIndices)(program, uniformCount, uniformNames, uniformIndices)
        /// * `uniformNames` len: COMPSIZE(uniformCount)
        /// * `uniformIndices` len: COMPSIZE(uniformCount)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetUniformIndices(
            &self,
            program: GLuint,
            uniformCount: GLsizei,
            uniformNames: *const *const GLchar,
            uniformIndices: *mut GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetUniformIndices({:?}, {:?}, {:p}, {:p});",
                    program,
                    uniformCount,
                    uniformNames,
                    uniformIndices
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetUniformIndices",
                &self.glGetUniformIndices_p,
                program,
                uniformCount,
                uniformNames,
                uniformIndices,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetUniformIndices");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetUniformIndices_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetUniformIndices\0",
                &self.glGetUniformIndices_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetUniformIndices_is_loaded(&self) -> bool {
            !self.glGetUniformIndices_p.load(RELAX).is_null()
        }
        /// [glGetUniformLocation](http://docs.gl/gl4/glGetUniformLocation)(program, name)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetUniformLocation(&self, program: GLuint, name: *const GLchar) -> GLint {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.GetUniformLocation({:?}, {:p});", program, name);
            }
            let out = call_atomic_ptr_2arg(
                "glGetUniformLocation",
                &self.glGetUniformLocation_p,
                program,
                name,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetUniformLocation");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetUniformLocation_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetUniformLocation\0",
                &self.glGetUniformLocation_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetUniformLocation_is_loaded(&self) -> bool {
            !self.glGetUniformLocation_p.load(RELAX).is_null()
        }
        /// [glGetUniformSubroutineuiv](http://docs.gl/gl4/glGetUniformSubroutine)(shadertype, location, params)
        /// * `shadertype` group: ShaderType
        /// * `params` len: 1
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetUniformSubroutineuiv(
            &self,
            shadertype: GLenum,
            location: GLint,
            params: *mut GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetUniformSubroutineuiv({:#X}, {:?}, {:p});",
                    shadertype,
                    location,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetUniformSubroutineuiv",
                &self.glGetUniformSubroutineuiv_p,
                shadertype,
                location,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetUniformSubroutineuiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetUniformSubroutineuiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetUniformSubroutineuiv\0",
                &self.glGetUniformSubroutineuiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetUniformSubroutineuiv_is_loaded(&self) -> bool {
            !self.glGetUniformSubroutineuiv_p.load(RELAX).is_null()
        }
        /// [glGetUniformdv](http://docs.gl/gl4/glGetUniformdv)(program, location, params)
        /// * `params` len: COMPSIZE(program,location)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetUniformdv(&self, program: GLuint, location: GLint, params: *mut GLdouble) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetUniformdv({:?}, {:?}, {:p});",
                    program,
                    location,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetUniformdv",
                &self.glGetUniformdv_p,
                program,
                location,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetUniformdv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetUniformdv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetUniformdv\0",
                &self.glGetUniformdv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetUniformdv_is_loaded(&self) -> bool {
            !self.glGetUniformdv_p.load(RELAX).is_null()
        }
        /// [glGetUniformfv](http://docs.gl/gl4/glGetUniform)(program, location, params)
        /// * `params` len: COMPSIZE(program,location)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetUniformfv(&self, program: GLuint, location: GLint, params: *mut GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetUniformfv({:?}, {:?}, {:p});",
                    program,
                    location,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetUniformfv",
                &self.glGetUniformfv_p,
                program,
                location,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetUniformfv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetUniformfv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetUniformfv\0",
                &self.glGetUniformfv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetUniformfv_is_loaded(&self) -> bool {
            !self.glGetUniformfv_p.load(RELAX).is_null()
        }
        /// [glGetUniformiv](http://docs.gl/gl4/glGetUniform)(program, location, params)
        /// * `params` len: COMPSIZE(program,location)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetUniformiv(&self, program: GLuint, location: GLint, params: *mut GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetUniformiv({:?}, {:?}, {:p});",
                    program,
                    location,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetUniformiv",
                &self.glGetUniformiv_p,
                program,
                location,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetUniformiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetUniformiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetUniformiv\0",
                &self.glGetUniformiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetUniformiv_is_loaded(&self) -> bool {
            !self.glGetUniformiv_p.load(RELAX).is_null()
        }
        /// [glGetUniformuiv](http://docs.gl/gl4/glGetUniform)(program, location, params)
        /// * `params` len: COMPSIZE(program,location)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetUniformuiv(&self, program: GLuint, location: GLint, params: *mut GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetUniformuiv({:?}, {:?}, {:p});",
                    program,
                    location,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetUniformuiv",
                &self.glGetUniformuiv_p,
                program,
                location,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetUniformuiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetUniformuiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetUniformuiv\0",
                &self.glGetUniformuiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetUniformuiv_is_loaded(&self) -> bool {
            !self.glGetUniformuiv_p.load(RELAX).is_null()
        }
        /// [glGetVertexArrayIndexed64iv](http://docs.gl/gl4/glGetVertexArrayIndexed6)(vaobj, index, pname, param)
        /// * `pname` group: VertexArrayPName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetVertexArrayIndexed64iv(
            &self,
            vaobj: GLuint,
            index: GLuint,
            pname: GLenum,
            param: *mut GLint64,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetVertexArrayIndexed64iv({:?}, {:?}, {:#X}, {:p});",
                    vaobj,
                    index,
                    pname,
                    param
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetVertexArrayIndexed64iv",
                &self.glGetVertexArrayIndexed64iv_p,
                vaobj,
                index,
                pname,
                param,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetVertexArrayIndexed64iv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetVertexArrayIndexed64iv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetVertexArrayIndexed64iv\0",
                &self.glGetVertexArrayIndexed64iv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetVertexArrayIndexed64iv_is_loaded(&self) -> bool {
            !self.glGetVertexArrayIndexed64iv_p.load(RELAX).is_null()
        }
        /// [glGetVertexArrayIndexediv](http://docs.gl/gl4/glGetVertexArrayIndexed)(vaobj, index, pname, param)
        /// * `pname` group: VertexArrayPName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetVertexArrayIndexediv(
            &self,
            vaobj: GLuint,
            index: GLuint,
            pname: GLenum,
            param: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetVertexArrayIndexediv({:?}, {:?}, {:#X}, {:p});",
                    vaobj,
                    index,
                    pname,
                    param
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetVertexArrayIndexediv",
                &self.glGetVertexArrayIndexediv_p,
                vaobj,
                index,
                pname,
                param,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetVertexArrayIndexediv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetVertexArrayIndexediv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetVertexArrayIndexediv\0",
                &self.glGetVertexArrayIndexediv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetVertexArrayIndexediv_is_loaded(&self) -> bool {
            !self.glGetVertexArrayIndexediv_p.load(RELAX).is_null()
        }
        /// [glGetVertexArrayiv](http://docs.gl/gl4/glGetVertexArray)(vaobj, pname, param)
        /// * `pname` group: VertexArrayPName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetVertexArrayiv(&self, vaobj: GLuint, pname: GLenum, param: *mut GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetVertexArrayiv({:?}, {:#X}, {:p});",
                    vaobj,
                    pname,
                    param
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetVertexArrayiv",
                &self.glGetVertexArrayiv_p,
                vaobj,
                pname,
                param,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetVertexArrayiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetVertexArrayiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetVertexArrayiv\0",
                &self.glGetVertexArrayiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetVertexArrayiv_is_loaded(&self) -> bool {
            !self.glGetVertexArrayiv_p.load(RELAX).is_null()
        }
        /// [glGetVertexAttribIiv](http://docs.gl/gl4/glGetVertexAttrib)(index, pname, params)
        /// * `pname` group: VertexAttribEnum
        /// * `params` len: 1
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetVertexAttribIiv(&self, index: GLuint, pname: GLenum, params: *mut GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetVertexAttribIiv({:?}, {:#X}, {:p});",
                    index,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetVertexAttribIiv",
                &self.glGetVertexAttribIiv_p,
                index,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetVertexAttribIiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetVertexAttribIiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetVertexAttribIiv\0",
                &self.glGetVertexAttribIiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetVertexAttribIiv_is_loaded(&self) -> bool {
            !self.glGetVertexAttribIiv_p.load(RELAX).is_null()
        }
        /// [glGetVertexAttribIuiv](http://docs.gl/gl4/glGetVertexAttrib)(index, pname, params)
        /// * `pname` group: VertexAttribEnum
        /// * `params` len: 1
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetVertexAttribIuiv(
            &self,
            index: GLuint,
            pname: GLenum,
            params: *mut GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetVertexAttribIuiv({:?}, {:#X}, {:p});",
                    index,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetVertexAttribIuiv",
                &self.glGetVertexAttribIuiv_p,
                index,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetVertexAttribIuiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetVertexAttribIuiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetVertexAttribIuiv\0",
                &self.glGetVertexAttribIuiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetVertexAttribIuiv_is_loaded(&self) -> bool {
            !self.glGetVertexAttribIuiv_p.load(RELAX).is_null()
        }
        /// [glGetVertexAttribLdv](http://docs.gl/gl4/glGetVertexAttribLdv)(index, pname, params)
        /// * `pname` group: VertexAttribEnum
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetVertexAttribLdv(
            &self,
            index: GLuint,
            pname: GLenum,
            params: *mut GLdouble,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetVertexAttribLdv({:?}, {:#X}, {:p});",
                    index,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetVertexAttribLdv",
                &self.glGetVertexAttribLdv_p,
                index,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetVertexAttribLdv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetVertexAttribLdv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetVertexAttribLdv\0",
                &self.glGetVertexAttribLdv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetVertexAttribLdv_is_loaded(&self) -> bool {
            !self.glGetVertexAttribLdv_p.load(RELAX).is_null()
        }
        /// [glGetVertexAttribPointerv](http://docs.gl/gl4/glGetVertexAttribPointerv)(index, pname, pointer)
        /// * `pname` group: VertexAttribPointerPropertyARB
        /// * `pointer` len: 1
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetVertexAttribPointerv(
            &self,
            index: GLuint,
            pname: GLenum,
            pointer: *mut *mut c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetVertexAttribPointerv({:?}, {:#X}, {:p});",
                    index,
                    pname,
                    pointer
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetVertexAttribPointerv",
                &self.glGetVertexAttribPointerv_p,
                index,
                pname,
                pointer,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetVertexAttribPointerv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetVertexAttribPointerv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetVertexAttribPointerv\0",
                &self.glGetVertexAttribPointerv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetVertexAttribPointerv_is_loaded(&self) -> bool {
            !self.glGetVertexAttribPointerv_p.load(RELAX).is_null()
        }
        /// [glGetVertexAttribdv](http://docs.gl/gl4/glGetVertexAttribdv)(index, pname, params)
        /// * `pname` group: VertexAttribPropertyARB
        /// * `params` len: 4
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetVertexAttribdv(
            &self,
            index: GLuint,
            pname: GLenum,
            params: *mut GLdouble,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetVertexAttribdv({:?}, {:#X}, {:p});",
                    index,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetVertexAttribdv",
                &self.glGetVertexAttribdv_p,
                index,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetVertexAttribdv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetVertexAttribdv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetVertexAttribdv\0",
                &self.glGetVertexAttribdv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetVertexAttribdv_is_loaded(&self) -> bool {
            !self.glGetVertexAttribdv_p.load(RELAX).is_null()
        }
        /// [glGetVertexAttribfv](http://docs.gl/gl4/glGetVertexAttrib)(index, pname, params)
        /// * `pname` group: VertexAttribPropertyARB
        /// * `params` len: 4
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetVertexAttribfv(&self, index: GLuint, pname: GLenum, params: *mut GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetVertexAttribfv({:?}, {:#X}, {:p});",
                    index,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetVertexAttribfv",
                &self.glGetVertexAttribfv_p,
                index,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetVertexAttribfv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetVertexAttribfv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetVertexAttribfv\0",
                &self.glGetVertexAttribfv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetVertexAttribfv_is_loaded(&self) -> bool {
            !self.glGetVertexAttribfv_p.load(RELAX).is_null()
        }
        /// [glGetVertexAttribiv](http://docs.gl/gl4/glGetVertexAttrib)(index, pname, params)
        /// * `pname` group: VertexAttribPropertyARB
        /// * `params` len: 4
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetVertexAttribiv(&self, index: GLuint, pname: GLenum, params: *mut GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetVertexAttribiv({:?}, {:#X}, {:p});",
                    index,
                    pname,
                    params
                );
            }
            let out = call_atomic_ptr_3arg(
                "glGetVertexAttribiv",
                &self.glGetVertexAttribiv_p,
                index,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetVertexAttribiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetVertexAttribiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetVertexAttribiv\0",
                &self.glGetVertexAttribiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetVertexAttribiv_is_loaded(&self) -> bool {
            !self.glGetVertexAttribiv_p.load(RELAX).is_null()
        }
        /// [glGetnCompressedTexImage](http://docs.gl/gl4/glGetnCompressedTexImage)(target, lod, bufSize, pixels)
        /// * `target` group: TextureTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetnCompressedTexImage(
            &self,
            target: GLenum,
            lod: GLint,
            bufSize: GLsizei,
            pixels: *mut c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetnCompressedTexImage({:#X}, {:?}, {:?}, {:p});",
                    target,
                    lod,
                    bufSize,
                    pixels
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetnCompressedTexImage",
                &self.glGetnCompressedTexImage_p,
                target,
                lod,
                bufSize,
                pixels,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetnCompressedTexImage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetnCompressedTexImage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetnCompressedTexImage\0",
                &self.glGetnCompressedTexImage_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetnCompressedTexImage_is_loaded(&self) -> bool {
            !self.glGetnCompressedTexImage_p.load(RELAX).is_null()
        }
        /// [glGetnTexImage](http://docs.gl/gl4/glGetnTexImage)(target, level, format, type_, bufSize, pixels)
        /// * `target` group: TextureTarget
        /// * `format` group: PixelFormat
        /// * `type_` group: PixelType
        /// * `pixels` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetnTexImage(
            &self,
            target: GLenum,
            level: GLint,
            format: GLenum,
            type_: GLenum,
            bufSize: GLsizei,
            pixels: *mut c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetnTexImage({:#X}, {:?}, {:#X}, {:#X}, {:?}, {:p});",
                    target,
                    level,
                    format,
                    type_,
                    bufSize,
                    pixels
                );
            }
            let out = call_atomic_ptr_6arg(
                "glGetnTexImage",
                &self.glGetnTexImage_p,
                target,
                level,
                format,
                type_,
                bufSize,
                pixels,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetnTexImage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetnTexImage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetnTexImage\0",
                &self.glGetnTexImage_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetnTexImage_is_loaded(&self) -> bool {
            !self.glGetnTexImage_p.load(RELAX).is_null()
        }
        /// [glGetnUniformdv](http://docs.gl/gl4/glGetnUniformdv)(program, location, bufSize, params)
        /// * `params` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetnUniformdv(
            &self,
            program: GLuint,
            location: GLint,
            bufSize: GLsizei,
            params: *mut GLdouble,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetnUniformdv({:?}, {:?}, {:?}, {:p});",
                    program,
                    location,
                    bufSize,
                    params
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetnUniformdv",
                &self.glGetnUniformdv_p,
                program,
                location,
                bufSize,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetnUniformdv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetnUniformdv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetnUniformdv\0",
                &self.glGetnUniformdv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetnUniformdv_is_loaded(&self) -> bool {
            !self.glGetnUniformdv_p.load(RELAX).is_null()
        }
        /// [glGetnUniformfv](http://docs.gl/gl4/glGetnUniform)(program, location, bufSize, params)
        /// * `params` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetnUniformfv(
            &self,
            program: GLuint,
            location: GLint,
            bufSize: GLsizei,
            params: *mut GLfloat,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetnUniformfv({:?}, {:?}, {:?}, {:p});",
                    program,
                    location,
                    bufSize,
                    params
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetnUniformfv",
                &self.glGetnUniformfv_p,
                program,
                location,
                bufSize,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetnUniformfv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetnUniformfv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetnUniformfv\0",
                &self.glGetnUniformfv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetnUniformfv_is_loaded(&self) -> bool {
            !self.glGetnUniformfv_p.load(RELAX).is_null()
        }
        /// [glGetnUniformiv](http://docs.gl/gl4/glGetnUniform)(program, location, bufSize, params)
        /// * `params` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetnUniformiv(
            &self,
            program: GLuint,
            location: GLint,
            bufSize: GLsizei,
            params: *mut GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetnUniformiv({:?}, {:?}, {:?}, {:p});",
                    program,
                    location,
                    bufSize,
                    params
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetnUniformiv",
                &self.glGetnUniformiv_p,
                program,
                location,
                bufSize,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetnUniformiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetnUniformiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetnUniformiv\0",
                &self.glGetnUniformiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetnUniformiv_is_loaded(&self) -> bool {
            !self.glGetnUniformiv_p.load(RELAX).is_null()
        }
        /// [glGetnUniformuiv](http://docs.gl/gl4/glGetnUniform)(program, location, bufSize, params)
        /// * `params` len: bufSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn GetnUniformuiv(
            &self,
            program: GLuint,
            location: GLint,
            bufSize: GLsizei,
            params: *mut GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.GetnUniformuiv({:?}, {:?}, {:?}, {:p});",
                    program,
                    location,
                    bufSize,
                    params
                );
            }
            let out = call_atomic_ptr_4arg(
                "glGetnUniformuiv",
                &self.glGetnUniformuiv_p,
                program,
                location,
                bufSize,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glGetnUniformuiv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn GetnUniformuiv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glGetnUniformuiv\0",
                &self.glGetnUniformuiv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn GetnUniformuiv_is_loaded(&self) -> bool {
            !self.glGetnUniformuiv_p.load(RELAX).is_null()
        }
        /// [glHint](http://docs.gl/gl4/glHint)(target, mode)
        /// * `target` group: HintTarget
        /// * `mode` group: HintMode
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn Hint(&self, target: GLenum, mode: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.Hint({:#X}, {:#X});", target, mode);
            }
            let out = call_atomic_ptr_2arg("glHint", &self.glHint_p, target, mode);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glHint");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn Hint_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glHint\0", &self.glHint_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn Hint_is_loaded(&self) -> bool {
            !self.glHint_p.load(RELAX).is_null()
        }
        /// [glInvalidateBufferData](http://docs.gl/gl4/glInvalidateBufferData)(buffer)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn InvalidateBufferData(&self, buffer: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.InvalidateBufferData({:?});", buffer);
            }
            let out = call_atomic_ptr_1arg(
                "glInvalidateBufferData",
                &self.glInvalidateBufferData_p,
                buffer,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glInvalidateBufferData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn InvalidateBufferData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glInvalidateBufferData\0",
                &self.glInvalidateBufferData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn InvalidateBufferData_is_loaded(&self) -> bool {
            !self.glInvalidateBufferData_p.load(RELAX).is_null()
        }
        /// [glInvalidateBufferSubData](http://docs.gl/gl4/glInvalidateBufferSubData)(buffer, offset, length)
        /// * `offset` group: BufferOffset
        /// * `length` group: BufferSize
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn InvalidateBufferSubData(
            &self,
            buffer: GLuint,
            offset: GLintptr,
            length: GLsizeiptr,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.InvalidateBufferSubData({:?}, {:?}, {:?});",
                    buffer,
                    offset,
                    length
                );
            }
            let out = call_atomic_ptr_3arg(
                "glInvalidateBufferSubData",
                &self.glInvalidateBufferSubData_p,
                buffer,
                offset,
                length,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glInvalidateBufferSubData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn InvalidateBufferSubData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glInvalidateBufferSubData\0",
                &self.glInvalidateBufferSubData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn InvalidateBufferSubData_is_loaded(&self) -> bool {
            !self.glInvalidateBufferSubData_p.load(RELAX).is_null()
        }
        /// [glInvalidateFramebuffer](http://docs.gl/gl4/glInvalidateFramebuffer)(target, numAttachments, attachments)
        /// * `target` group: FramebufferTarget
        /// * `attachments` group: InvalidateFramebufferAttachment
        /// * `attachments` len: numAttachments
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn InvalidateFramebuffer(
            &self,
            target: GLenum,
            numAttachments: GLsizei,
            attachments: *const GLenum,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.InvalidateFramebuffer({:#X}, {:?}, {:p});",
                    target,
                    numAttachments,
                    attachments
                );
            }
            let out = call_atomic_ptr_3arg(
                "glInvalidateFramebuffer",
                &self.glInvalidateFramebuffer_p,
                target,
                numAttachments,
                attachments,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glInvalidateFramebuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn InvalidateFramebuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glInvalidateFramebuffer\0",
                &self.glInvalidateFramebuffer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn InvalidateFramebuffer_is_loaded(&self) -> bool {
            !self.glInvalidateFramebuffer_p.load(RELAX).is_null()
        }
        /// [glInvalidateNamedFramebufferData](http://docs.gl/gl4/glInvalidateNamedFramebufferData)(framebuffer, numAttachments, attachments)
        /// * `attachments` group: FramebufferAttachment
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn InvalidateNamedFramebufferData(
            &self,
            framebuffer: GLuint,
            numAttachments: GLsizei,
            attachments: *const GLenum,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.InvalidateNamedFramebufferData({:?}, {:?}, {:p});",
                    framebuffer,
                    numAttachments,
                    attachments
                );
            }
            let out = call_atomic_ptr_3arg(
                "glInvalidateNamedFramebufferData",
                &self.glInvalidateNamedFramebufferData_p,
                framebuffer,
                numAttachments,
                attachments,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glInvalidateNamedFramebufferData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn InvalidateNamedFramebufferData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glInvalidateNamedFramebufferData\0",
                &self.glInvalidateNamedFramebufferData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn InvalidateNamedFramebufferData_is_loaded(&self) -> bool {
            !self
                .glInvalidateNamedFramebufferData_p
                .load(RELAX)
                .is_null()
        }
        /// [glInvalidateNamedFramebufferSubData](http://docs.gl/gl4/glInvalidateNamedFramebufferSubData)(framebuffer, numAttachments, attachments, x, y, width, height)
        /// * `attachments` group: FramebufferAttachment
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn InvalidateNamedFramebufferSubData(
            &self,
            framebuffer: GLuint,
            numAttachments: GLsizei,
            attachments: *const GLenum,
            x: GLint,
            y: GLint,
            width: GLsizei,
            height: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.InvalidateNamedFramebufferSubData({:?}, {:?}, {:p}, {:?}, {:?}, {:?}, {:?});", framebuffer, numAttachments, attachments, x, y, width, height);
            }
            let out = call_atomic_ptr_7arg(
                "glInvalidateNamedFramebufferSubData",
                &self.glInvalidateNamedFramebufferSubData_p,
                framebuffer,
                numAttachments,
                attachments,
                x,
                y,
                width,
                height,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glInvalidateNamedFramebufferSubData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn InvalidateNamedFramebufferSubData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glInvalidateNamedFramebufferSubData\0",
                &self.glInvalidateNamedFramebufferSubData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn InvalidateNamedFramebufferSubData_is_loaded(&self) -> bool {
            !self
                .glInvalidateNamedFramebufferSubData_p
                .load(RELAX)
                .is_null()
        }
        /// [glInvalidateSubFramebuffer](http://docs.gl/gl4/glInvalidateSubFramebuffer)(target, numAttachments, attachments, x, y, width, height)
        /// * `target` group: FramebufferTarget
        /// * `attachments` group: InvalidateFramebufferAttachment
        /// * `attachments` len: numAttachments
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn InvalidateSubFramebuffer(
            &self,
            target: GLenum,
            numAttachments: GLsizei,
            attachments: *const GLenum,
            x: GLint,
            y: GLint,
            width: GLsizei,
            height: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.InvalidateSubFramebuffer({:#X}, {:?}, {:p}, {:?}, {:?}, {:?}, {:?});", target, numAttachments, attachments, x, y, width, height);
            }
            let out = call_atomic_ptr_7arg(
                "glInvalidateSubFramebuffer",
                &self.glInvalidateSubFramebuffer_p,
                target,
                numAttachments,
                attachments,
                x,
                y,
                width,
                height,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glInvalidateSubFramebuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn InvalidateSubFramebuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glInvalidateSubFramebuffer\0",
                &self.glInvalidateSubFramebuffer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn InvalidateSubFramebuffer_is_loaded(&self) -> bool {
            !self.glInvalidateSubFramebuffer_p.load(RELAX).is_null()
        }
        /// [glInvalidateTexImage](http://docs.gl/gl4/glInvalidateTexImage)(texture, level)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn InvalidateTexImage(&self, texture: GLuint, level: GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.InvalidateTexImage({:?}, {:?});", texture, level);
            }
            let out = call_atomic_ptr_2arg(
                "glInvalidateTexImage",
                &self.glInvalidateTexImage_p,
                texture,
                level,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glInvalidateTexImage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn InvalidateTexImage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glInvalidateTexImage\0",
                &self.glInvalidateTexImage_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn InvalidateTexImage_is_loaded(&self) -> bool {
            !self.glInvalidateTexImage_p.load(RELAX).is_null()
        }
        /// [glInvalidateTexSubImage](http://docs.gl/gl4/glInvalidateTexSubImage)(texture, level, xoffset, yoffset, zoffset, width, height, depth)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn InvalidateTexSubImage(
            &self,
            texture: GLuint,
            level: GLint,
            xoffset: GLint,
            yoffset: GLint,
            zoffset: GLint,
            width: GLsizei,
            height: GLsizei,
            depth: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.InvalidateTexSubImage({:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?});", texture, level, xoffset, yoffset, zoffset, width, height, depth);
            }
            let out = call_atomic_ptr_8arg(
                "glInvalidateTexSubImage",
                &self.glInvalidateTexSubImage_p,
                texture,
                level,
                xoffset,
                yoffset,
                zoffset,
                width,
                height,
                depth,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glInvalidateTexSubImage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn InvalidateTexSubImage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glInvalidateTexSubImage\0",
                &self.glInvalidateTexSubImage_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn InvalidateTexSubImage_is_loaded(&self) -> bool {
            !self.glInvalidateTexSubImage_p.load(RELAX).is_null()
        }
        /// [glIsBuffer](http://docs.gl/gl4/glIsBuffer)(buffer)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsBuffer(&self, buffer: GLuint) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.IsBuffer({:?});", buffer);
            }
            let out = call_atomic_ptr_1arg("glIsBuffer", &self.glIsBuffer_p, buffer);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsBuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn IsBuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glIsBuffer\0", &self.glIsBuffer_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn IsBuffer_is_loaded(&self) -> bool {
            !self.glIsBuffer_p.load(RELAX).is_null()
        }
        /// [glIsEnabled](http://docs.gl/gl4/glIsEnabled)(cap)
        /// * `cap` group: EnableCap
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsEnabled(&self, cap: GLenum) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.IsEnabled({:#X});", cap);
            }
            let out = call_atomic_ptr_1arg("glIsEnabled", &self.glIsEnabled_p, cap);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsEnabled");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn IsEnabled_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glIsEnabled\0", &self.glIsEnabled_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn IsEnabled_is_loaded(&self) -> bool {
            !self.glIsEnabled_p.load(RELAX).is_null()
        }
        /// [glIsEnabledIndexedEXT](http://docs.gl/gl4/glIsEnabledIndexedEXT)(target, index)
        /// * `target` group: EnableCap
        /// * alias of: [`glIsEnabledi`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsEnabledIndexedEXT(&self, target: GLenum, index: GLuint) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.IsEnabledIndexedEXT({:#X}, {:?});",
                    target,
                    index
                );
            }
            let out = call_atomic_ptr_2arg(
                "glIsEnabledIndexedEXT",
                &self.glIsEnabledIndexedEXT_p,
                target,
                index,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsEnabledIndexedEXT");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn IsEnabledIndexedEXT_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glIsEnabledIndexedEXT\0",
                &self.glIsEnabledIndexedEXT_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn IsEnabledIndexedEXT_is_loaded(&self) -> bool {
            !self.glIsEnabledIndexedEXT_p.load(RELAX).is_null()
        }
        /// [glIsEnabledi](http://docs.gl/gl4/glIsEnabled)(target, index)
        /// * `target` group: EnableCap
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsEnabledi(&self, target: GLenum, index: GLuint) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.IsEnabledi({:#X}, {:?});", target, index);
            }
            let out = call_atomic_ptr_2arg("glIsEnabledi", &self.glIsEnabledi_p, target, index);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsEnabledi");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn IsEnabledi_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glIsEnabledi\0", &self.glIsEnabledi_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn IsEnabledi_is_loaded(&self) -> bool {
            !self.glIsEnabledi_p.load(RELAX).is_null()
        }
        /// [glIsFramebuffer](http://docs.gl/gl4/glIsFramebuffer)(framebuffer)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsFramebuffer(&self, framebuffer: GLuint) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.IsFramebuffer({:?});", framebuffer);
            }
            let out = call_atomic_ptr_1arg("glIsFramebuffer", &self.glIsFramebuffer_p, framebuffer);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsFramebuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn IsFramebuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glIsFramebuffer\0",
                &self.glIsFramebuffer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn IsFramebuffer_is_loaded(&self) -> bool {
            !self.glIsFramebuffer_p.load(RELAX).is_null()
        }
        /// [glIsProgram](http://docs.gl/gl4/glIsProgram)(program)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsProgram(&self, program: GLuint) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.IsProgram({:?});", program);
            }
            let out = call_atomic_ptr_1arg("glIsProgram", &self.glIsProgram_p, program);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsProgram");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn IsProgram_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glIsProgram\0", &self.glIsProgram_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn IsProgram_is_loaded(&self) -> bool {
            !self.glIsProgram_p.load(RELAX).is_null()
        }
        /// [glIsProgramPipeline](http://docs.gl/gl4/glIsProgramPipeline)(pipeline)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsProgramPipeline(&self, pipeline: GLuint) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.IsProgramPipeline({:?});", pipeline);
            }
            let out =
                call_atomic_ptr_1arg("glIsProgramPipeline", &self.glIsProgramPipeline_p, pipeline);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsProgramPipeline");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn IsProgramPipeline_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glIsProgramPipeline\0",
                &self.glIsProgramPipeline_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn IsProgramPipeline_is_loaded(&self) -> bool {
            !self.glIsProgramPipeline_p.load(RELAX).is_null()
        }
        /// [glIsQuery](http://docs.gl/gl4/glIsQuery)(id)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsQuery(&self, id: GLuint) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.IsQuery({:?});", id);
            }
            let out = call_atomic_ptr_1arg("glIsQuery", &self.glIsQuery_p, id);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsQuery");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn IsQuery_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glIsQuery\0", &self.glIsQuery_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn IsQuery_is_loaded(&self) -> bool {
            !self.glIsQuery_p.load(RELAX).is_null()
        }
        /// [glIsRenderbuffer](http://docs.gl/gl4/glIsRenderbuffer)(renderbuffer)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsRenderbuffer(&self, renderbuffer: GLuint) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.IsRenderbuffer({:?});", renderbuffer);
            }
            let out =
                call_atomic_ptr_1arg("glIsRenderbuffer", &self.glIsRenderbuffer_p, renderbuffer);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsRenderbuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn IsRenderbuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glIsRenderbuffer\0",
                &self.glIsRenderbuffer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn IsRenderbuffer_is_loaded(&self) -> bool {
            !self.glIsRenderbuffer_p.load(RELAX).is_null()
        }
        /// [glIsSampler](http://docs.gl/gl4/glIsSampler)(sampler)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsSampler(&self, sampler: GLuint) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.IsSampler({:?});", sampler);
            }
            let out = call_atomic_ptr_1arg("glIsSampler", &self.glIsSampler_p, sampler);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsSampler");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn IsSampler_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glIsSampler\0", &self.glIsSampler_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn IsSampler_is_loaded(&self) -> bool {
            !self.glIsSampler_p.load(RELAX).is_null()
        }
        /// [glIsShader](http://docs.gl/gl4/glIsShader)(shader)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsShader(&self, shader: GLuint) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.IsShader({:?});", shader);
            }
            let out = call_atomic_ptr_1arg("glIsShader", &self.glIsShader_p, shader);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsShader");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn IsShader_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glIsShader\0", &self.glIsShader_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn IsShader_is_loaded(&self) -> bool {
            !self.glIsShader_p.load(RELAX).is_null()
        }
        /// [glIsSync](http://docs.gl/gl4/glIsSync)(sync)
        /// * `sync` group: sync
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsSync(&self, sync: GLsync) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.IsSync({:p});", sync);
            }
            let out = call_atomic_ptr_1arg("glIsSync", &self.glIsSync_p, sync);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsSync");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn IsSync_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glIsSync\0", &self.glIsSync_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn IsSync_is_loaded(&self) -> bool {
            !self.glIsSync_p.load(RELAX).is_null()
        }
        /// [glIsTexture](http://docs.gl/gl4/glIsTexture)(texture)
        /// * `texture` group: Texture
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsTexture(&self, texture: GLuint) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.IsTexture({:?});", texture);
            }
            let out = call_atomic_ptr_1arg("glIsTexture", &self.glIsTexture_p, texture);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsTexture");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn IsTexture_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glIsTexture\0", &self.glIsTexture_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn IsTexture_is_loaded(&self) -> bool {
            !self.glIsTexture_p.load(RELAX).is_null()
        }
        /// [glIsTransformFeedback](http://docs.gl/gl4/glIsTransformFeedback)(id)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsTransformFeedback(&self, id: GLuint) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.IsTransformFeedback({:?});", id);
            }
            let out =
                call_atomic_ptr_1arg("glIsTransformFeedback", &self.glIsTransformFeedback_p, id);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsTransformFeedback");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn IsTransformFeedback_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glIsTransformFeedback\0",
                &self.glIsTransformFeedback_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn IsTransformFeedback_is_loaded(&self) -> bool {
            !self.glIsTransformFeedback_p.load(RELAX).is_null()
        }
        /// [glIsVertexArray](http://docs.gl/gl4/glIsVertexArray)(array)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn IsVertexArray(&self, array: GLuint) -> GLboolean {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.IsVertexArray({:?});", array);
            }
            let out = call_atomic_ptr_1arg("glIsVertexArray", &self.glIsVertexArray_p, array);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glIsVertexArray");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn IsVertexArray_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glIsVertexArray\0",
                &self.glIsVertexArray_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn IsVertexArray_is_loaded(&self) -> bool {
            !self.glIsVertexArray_p.load(RELAX).is_null()
        }
        /// [glLineWidth](http://docs.gl/gl4/glLineWidth)(width)
        /// * `width` group: CheckedFloat32
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn LineWidth(&self, width: GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.LineWidth({:?});", width);
            }
            let out = call_atomic_ptr_1arg("glLineWidth", &self.glLineWidth_p, width);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glLineWidth");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn LineWidth_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glLineWidth\0", &self.glLineWidth_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn LineWidth_is_loaded(&self) -> bool {
            !self.glLineWidth_p.load(RELAX).is_null()
        }
        /// [glLinkProgram](http://docs.gl/gl4/glLinkProgram)(program)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn LinkProgram(&self, program: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.LinkProgram({:?});", program);
            }
            let out = call_atomic_ptr_1arg("glLinkProgram", &self.glLinkProgram_p, program);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glLinkProgram");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn LinkProgram_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glLinkProgram\0", &self.glLinkProgram_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn LinkProgram_is_loaded(&self) -> bool {
            !self.glLinkProgram_p.load(RELAX).is_null()
        }
        /// [glLogicOp](http://docs.gl/gl4/glLogicOp)(opcode)
        /// * `opcode` group: LogicOp
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn LogicOp(&self, opcode: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.LogicOp({:#X});", opcode);
            }
            let out = call_atomic_ptr_1arg("glLogicOp", &self.glLogicOp_p, opcode);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glLogicOp");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn LogicOp_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glLogicOp\0", &self.glLogicOp_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn LogicOp_is_loaded(&self) -> bool {
            !self.glLogicOp_p.load(RELAX).is_null()
        }
        /// [glMapBuffer](http://docs.gl/gl4/glMapBuffer)(target, access)
        /// * `target` group: BufferTargetARB
        /// * `access` group: BufferAccessARB
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MapBuffer(&self, target: GLenum, access: GLenum) -> *mut c_void {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.MapBuffer({:#X}, {:#X});", target, access);
            }
            let out = call_atomic_ptr_2arg("glMapBuffer", &self.glMapBuffer_p, target, access);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMapBuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MapBuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glMapBuffer\0", &self.glMapBuffer_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn MapBuffer_is_loaded(&self) -> bool {
            !self.glMapBuffer_p.load(RELAX).is_null()
        }
        /// [glMapBufferRange](http://docs.gl/gl4/glMapBufferRange)(target, offset, length, access)
        /// * `target` group: BufferTargetARB
        /// * `offset` group: BufferOffset
        /// * `length` group: BufferSize
        /// * `access` group: MapBufferAccessMask
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MapBufferRange(
            &self,
            target: GLenum,
            offset: GLintptr,
            length: GLsizeiptr,
            access: GLbitfield,
        ) -> *mut c_void {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.MapBufferRange({:#X}, {:?}, {:?}, {:?});",
                    target,
                    offset,
                    length,
                    access
                );
            }
            let out = call_atomic_ptr_4arg(
                "glMapBufferRange",
                &self.glMapBufferRange_p,
                target,
                offset,
                length,
                access,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMapBufferRange");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MapBufferRange_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMapBufferRange\0",
                &self.glMapBufferRange_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MapBufferRange_is_loaded(&self) -> bool {
            !self.glMapBufferRange_p.load(RELAX).is_null()
        }
        /// [glMapNamedBuffer](http://docs.gl/gl4/glMapNamedBuffer)(buffer, access)
        /// * `access` group: BufferAccessARB
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MapNamedBuffer(&self, buffer: GLuint, access: GLenum) -> *mut c_void {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.MapNamedBuffer({:?}, {:#X});", buffer, access);
            }
            let out =
                call_atomic_ptr_2arg("glMapNamedBuffer", &self.glMapNamedBuffer_p, buffer, access);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMapNamedBuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MapNamedBuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMapNamedBuffer\0",
                &self.glMapNamedBuffer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MapNamedBuffer_is_loaded(&self) -> bool {
            !self.glMapNamedBuffer_p.load(RELAX).is_null()
        }
        /// [glMapNamedBufferRange](http://docs.gl/gl4/glMapNamedBufferRange)(buffer, offset, length, access)
        /// * `length` group: BufferSize
        /// * `access` group: MapBufferAccessMask
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MapNamedBufferRange(
            &self,
            buffer: GLuint,
            offset: GLintptr,
            length: GLsizeiptr,
            access: GLbitfield,
        ) -> *mut c_void {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.MapNamedBufferRange({:?}, {:?}, {:?}, {:?});",
                    buffer,
                    offset,
                    length,
                    access
                );
            }
            let out = call_atomic_ptr_4arg(
                "glMapNamedBufferRange",
                &self.glMapNamedBufferRange_p,
                buffer,
                offset,
                length,
                access,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMapNamedBufferRange");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MapNamedBufferRange_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMapNamedBufferRange\0",
                &self.glMapNamedBufferRange_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MapNamedBufferRange_is_loaded(&self) -> bool {
            !self.glMapNamedBufferRange_p.load(RELAX).is_null()
        }
        /// [glMaxShaderCompilerThreadsARB](http://docs.gl/gl4/glMaxShaderCompilerThreadsARB)(count)
        /// * alias of: [`glMaxShaderCompilerThreadsKHR`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MaxShaderCompilerThreadsARB(&self, count: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.MaxShaderCompilerThreadsARB({:?});", count);
            }
            let out = call_atomic_ptr_1arg(
                "glMaxShaderCompilerThreadsARB",
                &self.glMaxShaderCompilerThreadsARB_p,
                count,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMaxShaderCompilerThreadsARB");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MaxShaderCompilerThreadsARB_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMaxShaderCompilerThreadsARB\0",
                &self.glMaxShaderCompilerThreadsARB_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MaxShaderCompilerThreadsARB_is_loaded(&self) -> bool {
            !self.glMaxShaderCompilerThreadsARB_p.load(RELAX).is_null()
        }
        /// [glMaxShaderCompilerThreadsKHR](http://docs.gl/gl4/glMaxShaderCompilerThreadsKHR)(count)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MaxShaderCompilerThreadsKHR(&self, count: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.MaxShaderCompilerThreadsKHR({:?});", count);
            }
            let out = call_atomic_ptr_1arg(
                "glMaxShaderCompilerThreadsKHR",
                &self.glMaxShaderCompilerThreadsKHR_p,
                count,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMaxShaderCompilerThreadsKHR");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MaxShaderCompilerThreadsKHR_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMaxShaderCompilerThreadsKHR\0",
                &self.glMaxShaderCompilerThreadsKHR_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MaxShaderCompilerThreadsKHR_is_loaded(&self) -> bool {
            !self.glMaxShaderCompilerThreadsKHR_p.load(RELAX).is_null()
        }
        /// [glMemoryBarrier](http://docs.gl/gl4/glMemoryBarrier)(barriers)
        /// * `barriers` group: MemoryBarrierMask
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MemoryBarrier(&self, barriers: GLbitfield) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.MemoryBarrier({:?});", barriers);
            }
            let out = call_atomic_ptr_1arg("glMemoryBarrier", &self.glMemoryBarrier_p, barriers);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMemoryBarrier");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MemoryBarrier_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMemoryBarrier\0",
                &self.glMemoryBarrier_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MemoryBarrier_is_loaded(&self) -> bool {
            !self.glMemoryBarrier_p.load(RELAX).is_null()
        }
        /// [glMemoryBarrierByRegion](http://docs.gl/gl4/glMemoryBarrierByRegion)(barriers)
        /// * `barriers` group: MemoryBarrierMask
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MemoryBarrierByRegion(&self, barriers: GLbitfield) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.MemoryBarrierByRegion({:?});", barriers);
            }
            let out = call_atomic_ptr_1arg(
                "glMemoryBarrierByRegion",
                &self.glMemoryBarrierByRegion_p,
                barriers,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMemoryBarrierByRegion");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MemoryBarrierByRegion_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMemoryBarrierByRegion\0",
                &self.glMemoryBarrierByRegion_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MemoryBarrierByRegion_is_loaded(&self) -> bool {
            !self.glMemoryBarrierByRegion_p.load(RELAX).is_null()
        }
        /// [glMinSampleShading](http://docs.gl/gl4/glMinSampleShading)(value)
        /// * `value` group: ColorF
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MinSampleShading(&self, value: GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.MinSampleShading({:?});", value);
            }
            let out = call_atomic_ptr_1arg("glMinSampleShading", &self.glMinSampleShading_p, value);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMinSampleShading");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MinSampleShading_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMinSampleShading\0",
                &self.glMinSampleShading_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MinSampleShading_is_loaded(&self) -> bool {
            !self.glMinSampleShading_p.load(RELAX).is_null()
        }
        /// [glMultiDrawArrays](http://docs.gl/gl4/glMultiDrawArrays)(mode, first, count, drawcount)
        /// * `mode` group: PrimitiveType
        /// * `first` len: COMPSIZE(drawcount)
        /// * `count` len: COMPSIZE(drawcount)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MultiDrawArrays(
            &self,
            mode: GLenum,
            first: *const GLint,
            count: *const GLsizei,
            drawcount: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.MultiDrawArrays({:#X}, {:p}, {:p}, {:?});",
                    mode,
                    first,
                    count,
                    drawcount
                );
            }
            let out = call_atomic_ptr_4arg(
                "glMultiDrawArrays",
                &self.glMultiDrawArrays_p,
                mode,
                first,
                count,
                drawcount,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMultiDrawArrays");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MultiDrawArrays_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMultiDrawArrays\0",
                &self.glMultiDrawArrays_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MultiDrawArrays_is_loaded(&self) -> bool {
            !self.glMultiDrawArrays_p.load(RELAX).is_null()
        }
        /// [glMultiDrawArraysIndirect](http://docs.gl/gl4/glMultiDrawArraysIndirect)(mode, indirect, drawcount, stride)
        /// * `mode` group: PrimitiveType
        /// * `indirect` len: COMPSIZE(drawcount,stride)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MultiDrawArraysIndirect(
            &self,
            mode: GLenum,
            indirect: *const c_void,
            drawcount: GLsizei,
            stride: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.MultiDrawArraysIndirect({:#X}, {:p}, {:?}, {:?});",
                    mode,
                    indirect,
                    drawcount,
                    stride
                );
            }
            let out = call_atomic_ptr_4arg(
                "glMultiDrawArraysIndirect",
                &self.glMultiDrawArraysIndirect_p,
                mode,
                indirect,
                drawcount,
                stride,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMultiDrawArraysIndirect");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MultiDrawArraysIndirect_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMultiDrawArraysIndirect\0",
                &self.glMultiDrawArraysIndirect_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MultiDrawArraysIndirect_is_loaded(&self) -> bool {
            !self.glMultiDrawArraysIndirect_p.load(RELAX).is_null()
        }
        /// [glMultiDrawArraysIndirectCount](http://docs.gl/gl4/glMultiDrawArraysIndirectCount)(mode, indirect, drawcount, maxdrawcount, stride)
        /// * `mode` group: PrimitiveType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MultiDrawArraysIndirectCount(
            &self,
            mode: GLenum,
            indirect: *const c_void,
            drawcount: GLintptr,
            maxdrawcount: GLsizei,
            stride: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.MultiDrawArraysIndirectCount({:#X}, {:p}, {:?}, {:?}, {:?});",
                    mode,
                    indirect,
                    drawcount,
                    maxdrawcount,
                    stride
                );
            }
            let out = call_atomic_ptr_5arg(
                "glMultiDrawArraysIndirectCount",
                &self.glMultiDrawArraysIndirectCount_p,
                mode,
                indirect,
                drawcount,
                maxdrawcount,
                stride,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMultiDrawArraysIndirectCount");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MultiDrawArraysIndirectCount_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMultiDrawArraysIndirectCount\0",
                &self.glMultiDrawArraysIndirectCount_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MultiDrawArraysIndirectCount_is_loaded(&self) -> bool {
            !self.glMultiDrawArraysIndirectCount_p.load(RELAX).is_null()
        }
        /// [glMultiDrawElements](http://docs.gl/gl4/glMultiDrawElements)(mode, count, type_, indices, drawcount)
        /// * `mode` group: PrimitiveType
        /// * `count` len: COMPSIZE(drawcount)
        /// * `type_` group: DrawElementsType
        /// * `indices` len: COMPSIZE(drawcount)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MultiDrawElements(
            &self,
            mode: GLenum,
            count: *const GLsizei,
            type_: GLenum,
            indices: *const *const c_void,
            drawcount: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.MultiDrawElements({:#X}, {:p}, {:#X}, {:p}, {:?});",
                    mode,
                    count,
                    type_,
                    indices,
                    drawcount
                );
            }
            let out = call_atomic_ptr_5arg(
                "glMultiDrawElements",
                &self.glMultiDrawElements_p,
                mode,
                count,
                type_,
                indices,
                drawcount,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMultiDrawElements");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MultiDrawElements_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMultiDrawElements\0",
                &self.glMultiDrawElements_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MultiDrawElements_is_loaded(&self) -> bool {
            !self.glMultiDrawElements_p.load(RELAX).is_null()
        }
        /// [glMultiDrawElementsBaseVertex](http://docs.gl/gl4/glMultiDrawElementsBaseVertex)(mode, count, type_, indices, drawcount, basevertex)
        /// * `mode` group: PrimitiveType
        /// * `count` len: COMPSIZE(drawcount)
        /// * `type_` group: DrawElementsType
        /// * `indices` len: COMPSIZE(drawcount)
        /// * `basevertex` len: COMPSIZE(drawcount)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MultiDrawElementsBaseVertex(
            &self,
            mode: GLenum,
            count: *const GLsizei,
            type_: GLenum,
            indices: *const *const c_void,
            drawcount: GLsizei,
            basevertex: *const GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.MultiDrawElementsBaseVertex({:#X}, {:p}, {:#X}, {:p}, {:?}, {:p});",
                    mode,
                    count,
                    type_,
                    indices,
                    drawcount,
                    basevertex
                );
            }
            let out = call_atomic_ptr_6arg(
                "glMultiDrawElementsBaseVertex",
                &self.glMultiDrawElementsBaseVertex_p,
                mode,
                count,
                type_,
                indices,
                drawcount,
                basevertex,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMultiDrawElementsBaseVertex");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MultiDrawElementsBaseVertex_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMultiDrawElementsBaseVertex\0",
                &self.glMultiDrawElementsBaseVertex_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MultiDrawElementsBaseVertex_is_loaded(&self) -> bool {
            !self.glMultiDrawElementsBaseVertex_p.load(RELAX).is_null()
        }
        /// [glMultiDrawElementsIndirect](http://docs.gl/gl4/glMultiDrawElementsIndirect)(mode, type_, indirect, drawcount, stride)
        /// * `mode` group: PrimitiveType
        /// * `type_` group: DrawElementsType
        /// * `indirect` len: COMPSIZE(drawcount,stride)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MultiDrawElementsIndirect(
            &self,
            mode: GLenum,
            type_: GLenum,
            indirect: *const c_void,
            drawcount: GLsizei,
            stride: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.MultiDrawElementsIndirect({:#X}, {:#X}, {:p}, {:?}, {:?});",
                    mode,
                    type_,
                    indirect,
                    drawcount,
                    stride
                );
            }
            let out = call_atomic_ptr_5arg(
                "glMultiDrawElementsIndirect",
                &self.glMultiDrawElementsIndirect_p,
                mode,
                type_,
                indirect,
                drawcount,
                stride,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMultiDrawElementsIndirect");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MultiDrawElementsIndirect_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMultiDrawElementsIndirect\0",
                &self.glMultiDrawElementsIndirect_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MultiDrawElementsIndirect_is_loaded(&self) -> bool {
            !self.glMultiDrawElementsIndirect_p.load(RELAX).is_null()
        }
        /// [glMultiDrawElementsIndirectCount](http://docs.gl/gl4/glMultiDrawElementsIndirectCount)(mode, type_, indirect, drawcount, maxdrawcount, stride)
        /// * `mode` group: PrimitiveType
        /// * `type_` group: DrawElementsType
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn MultiDrawElementsIndirectCount(
            &self,
            mode: GLenum,
            type_: GLenum,
            indirect: *const c_void,
            drawcount: GLintptr,
            maxdrawcount: GLsizei,
            stride: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.MultiDrawElementsIndirectCount({:#X}, {:#X}, {:p}, {:?}, {:?}, {:?});", mode, type_, indirect, drawcount, maxdrawcount, stride);
            }
            let out = call_atomic_ptr_6arg(
                "glMultiDrawElementsIndirectCount",
                &self.glMultiDrawElementsIndirectCount_p,
                mode,
                type_,
                indirect,
                drawcount,
                maxdrawcount,
                stride,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glMultiDrawElementsIndirectCount");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn MultiDrawElementsIndirectCount_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glMultiDrawElementsIndirectCount\0",
                &self.glMultiDrawElementsIndirectCount_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn MultiDrawElementsIndirectCount_is_loaded(&self) -> bool {
            !self
                .glMultiDrawElementsIndirectCount_p
                .load(RELAX)
                .is_null()
        }
        /// [glNamedBufferData](http://docs.gl/gl4/glNamedBufferData)(buffer, size, data, usage)
        /// * `size` group: BufferSize
        /// * `usage` group: VertexBufferObjectUsage
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn NamedBufferData(
            &self,
            buffer: GLuint,
            size: GLsizeiptr,
            data: *const c_void,
            usage: GLenum,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.NamedBufferData({:?}, {:?}, {:p}, {:#X});",
                    buffer,
                    size,
                    data,
                    usage
                );
            }
            let out = call_atomic_ptr_4arg(
                "glNamedBufferData",
                &self.glNamedBufferData_p,
                buffer,
                size,
                data,
                usage,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glNamedBufferData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn NamedBufferData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glNamedBufferData\0",
                &self.glNamedBufferData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn NamedBufferData_is_loaded(&self) -> bool {
            !self.glNamedBufferData_p.load(RELAX).is_null()
        }
        /// [glNamedBufferStorage](http://docs.gl/gl4/glNamedBufferStorage)(buffer, size, data, flags)
        /// * `size` group: BufferSize
        /// * `data` len: size
        /// * `flags` group: BufferStorageMask
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn NamedBufferStorage(
            &self,
            buffer: GLuint,
            size: GLsizeiptr,
            data: *const c_void,
            flags: GLbitfield,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.NamedBufferStorage({:?}, {:?}, {:p}, {:?});",
                    buffer,
                    size,
                    data,
                    flags
                );
            }
            let out = call_atomic_ptr_4arg(
                "glNamedBufferStorage",
                &self.glNamedBufferStorage_p,
                buffer,
                size,
                data,
                flags,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glNamedBufferStorage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn NamedBufferStorage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glNamedBufferStorage\0",
                &self.glNamedBufferStorage_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn NamedBufferStorage_is_loaded(&self) -> bool {
            !self.glNamedBufferStorage_p.load(RELAX).is_null()
        }
        /// [glNamedBufferSubData](http://docs.gl/gl4/glNamedBufferSubData)(buffer, offset, size, data)
        /// * `size` group: BufferSize
        /// * `data` len: COMPSIZE(size)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn NamedBufferSubData(
            &self,
            buffer: GLuint,
            offset: GLintptr,
            size: GLsizeiptr,
            data: *const c_void,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.NamedBufferSubData({:?}, {:?}, {:?}, {:p});",
                    buffer,
                    offset,
                    size,
                    data
                );
            }
            let out = call_atomic_ptr_4arg(
                "glNamedBufferSubData",
                &self.glNamedBufferSubData_p,
                buffer,
                offset,
                size,
                data,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glNamedBufferSubData");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn NamedBufferSubData_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glNamedBufferSubData\0",
                &self.glNamedBufferSubData_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn NamedBufferSubData_is_loaded(&self) -> bool {
            !self.glNamedBufferSubData_p.load(RELAX).is_null()
        }
        /// [glNamedFramebufferDrawBuffer](http://docs.gl/gl4/glNamedFramebufferDrawBuffer)(framebuffer, buf)
        /// * `buf` group: ColorBuffer
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn NamedFramebufferDrawBuffer(&self, framebuffer: GLuint, buf: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.NamedFramebufferDrawBuffer({:?}, {:#X});",
                    framebuffer,
                    buf
                );
            }
            let out = call_atomic_ptr_2arg(
                "glNamedFramebufferDrawBuffer",
                &self.glNamedFramebufferDrawBuffer_p,
                framebuffer,
                buf,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glNamedFramebufferDrawBuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn NamedFramebufferDrawBuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glNamedFramebufferDrawBuffer\0",
                &self.glNamedFramebufferDrawBuffer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn NamedFramebufferDrawBuffer_is_loaded(&self) -> bool {
            !self.glNamedFramebufferDrawBuffer_p.load(RELAX).is_null()
        }
        /// [glNamedFramebufferDrawBuffers](http://docs.gl/gl4/glNamedFramebufferDrawBuffers)(framebuffer, n, bufs)
        /// * `bufs` group: ColorBuffer
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn NamedFramebufferDrawBuffers(
            &self,
            framebuffer: GLuint,
            n: GLsizei,
            bufs: *const GLenum,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.NamedFramebufferDrawBuffers({:?}, {:?}, {:p});",
                    framebuffer,
                    n,
                    bufs
                );
            }
            let out = call_atomic_ptr_3arg(
                "glNamedFramebufferDrawBuffers",
                &self.glNamedFramebufferDrawBuffers_p,
                framebuffer,
                n,
                bufs,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glNamedFramebufferDrawBuffers");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn NamedFramebufferDrawBuffers_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glNamedFramebufferDrawBuffers\0",
                &self.glNamedFramebufferDrawBuffers_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn NamedFramebufferDrawBuffers_is_loaded(&self) -> bool {
            !self.glNamedFramebufferDrawBuffers_p.load(RELAX).is_null()
        }
        /// [glNamedFramebufferParameteri](http://docs.gl/gl4/glNamedFramebufferParameter)(framebuffer, pname, param)
        /// * `pname` group: FramebufferParameterName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn NamedFramebufferParameteri(
            &self,
            framebuffer: GLuint,
            pname: GLenum,
            param: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.NamedFramebufferParameteri({:?}, {:#X}, {:?});",
                    framebuffer,
                    pname,
                    param
                );
            }
            let out = call_atomic_ptr_3arg(
                "glNamedFramebufferParameteri",
                &self.glNamedFramebufferParameteri_p,
                framebuffer,
                pname,
                param,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glNamedFramebufferParameteri");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn NamedFramebufferParameteri_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glNamedFramebufferParameteri\0",
                &self.glNamedFramebufferParameteri_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn NamedFramebufferParameteri_is_loaded(&self) -> bool {
            !self.glNamedFramebufferParameteri_p.load(RELAX).is_null()
        }
        /// [glNamedFramebufferReadBuffer](http://docs.gl/gl4/glNamedFramebufferReadBuffer)(framebuffer, src)
        /// * `src` group: ColorBuffer
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn NamedFramebufferReadBuffer(&self, framebuffer: GLuint, src: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.NamedFramebufferReadBuffer({:?}, {:#X});",
                    framebuffer,
                    src
                );
            }
            let out = call_atomic_ptr_2arg(
                "glNamedFramebufferReadBuffer",
                &self.glNamedFramebufferReadBuffer_p,
                framebuffer,
                src,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glNamedFramebufferReadBuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn NamedFramebufferReadBuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glNamedFramebufferReadBuffer\0",
                &self.glNamedFramebufferReadBuffer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn NamedFramebufferReadBuffer_is_loaded(&self) -> bool {
            !self.glNamedFramebufferReadBuffer_p.load(RELAX).is_null()
        }
        /// [glNamedFramebufferRenderbuffer](http://docs.gl/gl4/glNamedFramebufferRenderbuffer)(framebuffer, attachment, renderbuffertarget, renderbuffer)
        /// * `attachment` group: FramebufferAttachment
        /// * `renderbuffertarget` group: RenderbufferTarget
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn NamedFramebufferRenderbuffer(
            &self,
            framebuffer: GLuint,
            attachment: GLenum,
            renderbuffertarget: GLenum,
            renderbuffer: GLuint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.NamedFramebufferRenderbuffer({:?}, {:#X}, {:#X}, {:?});",
                    framebuffer,
                    attachment,
                    renderbuffertarget,
                    renderbuffer
                );
            }
            let out = call_atomic_ptr_4arg(
                "glNamedFramebufferRenderbuffer",
                &self.glNamedFramebufferRenderbuffer_p,
                framebuffer,
                attachment,
                renderbuffertarget,
                renderbuffer,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glNamedFramebufferRenderbuffer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn NamedFramebufferRenderbuffer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glNamedFramebufferRenderbuffer\0",
                &self.glNamedFramebufferRenderbuffer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn NamedFramebufferRenderbuffer_is_loaded(&self) -> bool {
            !self.glNamedFramebufferRenderbuffer_p.load(RELAX).is_null()
        }
        /// [glNamedFramebufferTexture](http://docs.gl/gl4/glNamedFramebufferTexture)(framebuffer, attachment, texture, level)
        /// * `attachment` group: FramebufferAttachment
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn NamedFramebufferTexture(
            &self,
            framebuffer: GLuint,
            attachment: GLenum,
            texture: GLuint,
            level: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.NamedFramebufferTexture({:?}, {:#X}, {:?}, {:?});",
                    framebuffer,
                    attachment,
                    texture,
                    level
                );
            }
            let out = call_atomic_ptr_4arg(
                "glNamedFramebufferTexture",
                &self.glNamedFramebufferTexture_p,
                framebuffer,
                attachment,
                texture,
                level,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glNamedFramebufferTexture");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn NamedFramebufferTexture_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glNamedFramebufferTexture\0",
                &self.glNamedFramebufferTexture_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn NamedFramebufferTexture_is_loaded(&self) -> bool {
            !self.glNamedFramebufferTexture_p.load(RELAX).is_null()
        }
        /// [glNamedFramebufferTextureLayer](http://docs.gl/gl4/glNamedFramebufferTextureLayer)(framebuffer, attachment, texture, level, layer)
        /// * `attachment` group: FramebufferAttachment
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn NamedFramebufferTextureLayer(
            &self,
            framebuffer: GLuint,
            attachment: GLenum,
            texture: GLuint,
            level: GLint,
            layer: GLint,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.NamedFramebufferTextureLayer({:?}, {:#X}, {:?}, {:?}, {:?});",
                    framebuffer,
                    attachment,
                    texture,
                    level,
                    layer
                );
            }
            let out = call_atomic_ptr_5arg(
                "glNamedFramebufferTextureLayer",
                &self.glNamedFramebufferTextureLayer_p,
                framebuffer,
                attachment,
                texture,
                level,
                layer,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glNamedFramebufferTextureLayer");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn NamedFramebufferTextureLayer_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glNamedFramebufferTextureLayer\0",
                &self.glNamedFramebufferTextureLayer_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn NamedFramebufferTextureLayer_is_loaded(&self) -> bool {
            !self.glNamedFramebufferTextureLayer_p.load(RELAX).is_null()
        }
        /// [glNamedRenderbufferStorage](http://docs.gl/gl4/glNamedRenderbufferStorage)(renderbuffer, internalformat, width, height)
        /// * `internalformat` group: InternalFormat
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn NamedRenderbufferStorage(
            &self,
            renderbuffer: GLuint,
            internalformat: GLenum,
            width: GLsizei,
            height: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.NamedRenderbufferStorage({:?}, {:#X}, {:?}, {:?});",
                    renderbuffer,
                    internalformat,
                    width,
                    height
                );
            }
            let out = call_atomic_ptr_4arg(
                "glNamedRenderbufferStorage",
                &self.glNamedRenderbufferStorage_p,
                renderbuffer,
                internalformat,
                width,
                height,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glNamedRenderbufferStorage");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn NamedRenderbufferStorage_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glNamedRenderbufferStorage\0",
                &self.glNamedRenderbufferStorage_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn NamedRenderbufferStorage_is_loaded(&self) -> bool {
            !self.glNamedRenderbufferStorage_p.load(RELAX).is_null()
        }
        /// [glNamedRenderbufferStorageMultisample](http://docs.gl/gl4/glNamedRenderbufferStorageMultisample)(renderbuffer, samples, internalformat, width, height)
        /// * `internalformat` group: InternalFormat
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn NamedRenderbufferStorageMultisample(
            &self,
            renderbuffer: GLuint,
            samples: GLsizei,
            internalformat: GLenum,
            width: GLsizei,
            height: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.NamedRenderbufferStorageMultisample({:?}, {:?}, {:#X}, {:?}, {:?});", renderbuffer, samples, internalformat, width, height);
            }
            let out = call_atomic_ptr_5arg(
                "glNamedRenderbufferStorageMultisample",
                &self.glNamedRenderbufferStorageMultisample_p,
                renderbuffer,
                samples,
                internalformat,
                width,
                height,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glNamedRenderbufferStorageMultisample");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn NamedRenderbufferStorageMultisample_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glNamedRenderbufferStorageMultisample\0",
                &self.glNamedRenderbufferStorageMultisample_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn NamedRenderbufferStorageMultisample_is_loaded(&self) -> bool {
            !self
                .glNamedRenderbufferStorageMultisample_p
                .load(RELAX)
                .is_null()
        }
        /// [glObjectLabel](http://docs.gl/gl4/glObjectLabel)(identifier, name, length, label)
        /// * `identifier` group: ObjectIdentifier
        /// * `label` len: COMPSIZE(label,length)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ObjectLabel(
            &self,
            identifier: GLenum,
            name: GLuint,
            length: GLsizei,
            label: *const GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ObjectLabel({:#X}, {:?}, {:?}, {:p});",
                    identifier,
                    name,
                    length,
                    label
                );
            }
            let out = call_atomic_ptr_4arg(
                "glObjectLabel",
                &self.glObjectLabel_p,
                identifier,
                name,
                length,
                label,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glObjectLabel");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ObjectLabel_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glObjectLabel\0", &self.glObjectLabel_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn ObjectLabel_is_loaded(&self) -> bool {
            !self.glObjectLabel_p.load(RELAX).is_null()
        }
        /// [glObjectLabelKHR](http://docs.gl/gl4/glObjectLabelKHR)(identifier, name, length, label)
        /// * `identifier` group: ObjectIdentifier
        /// * alias of: [`glObjectLabel`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ObjectLabelKHR(
            &self,
            identifier: GLenum,
            name: GLuint,
            length: GLsizei,
            label: *const GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ObjectLabelKHR({:#X}, {:?}, {:?}, {:p});",
                    identifier,
                    name,
                    length,
                    label
                );
            }
            let out = call_atomic_ptr_4arg(
                "glObjectLabelKHR",
                &self.glObjectLabelKHR_p,
                identifier,
                name,
                length,
                label,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glObjectLabelKHR");
            }
            out
        }

        #[doc(hidden)]
        pub unsafe fn ObjectLabelKHR_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glObjectLabelKHR\0",
                &self.glObjectLabelKHR_p,
            )
        }
        #[inline]
        #[doc(hidden)]

        pub fn ObjectLabelKHR_is_loaded(&self) -> bool {
            !self.glObjectLabelKHR_p.load(RELAX).is_null()
        }
        /// [glObjectPtrLabel](http://docs.gl/gl4/glObjectPtrLabel)(ptr, length, label)
        /// * `label` len: COMPSIZE(label,length)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ObjectPtrLabel(
            &self,
            ptr: *const c_void,
            length: GLsizei,
            label: *const GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ObjectPtrLabel({:p}, {:?}, {:p});",
                    ptr,
                    length,
                    label
                );
            }
            let out = call_atomic_ptr_3arg(
                "glObjectPtrLabel",
                &self.glObjectPtrLabel_p,
                ptr,
                length,
                label,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glObjectPtrLabel");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ObjectPtrLabel_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glObjectPtrLabel\0",
                &self.glObjectPtrLabel_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ObjectPtrLabel_is_loaded(&self) -> bool {
            !self.glObjectPtrLabel_p.load(RELAX).is_null()
        }
        /// [glObjectPtrLabelKHR](http://docs.gl/gl4/glObjectPtrLabelKHR)(ptr, length, label)
        /// * alias of: [`glObjectPtrLabel`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ObjectPtrLabelKHR(
            &self,
            ptr: *const c_void,
            length: GLsizei,
            label: *const GLchar,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ObjectPtrLabelKHR({:p}, {:?}, {:p});",
                    ptr,
                    length,
                    label
                );
            }
            let out = call_atomic_ptr_3arg(
                "glObjectPtrLabelKHR",
                &self.glObjectPtrLabelKHR_p,
                ptr,
                length,
                label,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glObjectPtrLabelKHR");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ObjectPtrLabelKHR_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glObjectPtrLabelKHR\0",
                &self.glObjectPtrLabelKHR_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ObjectPtrLabelKHR_is_loaded(&self) -> bool {
            !self.glObjectPtrLabelKHR_p.load(RELAX).is_null()
        }
        /// [glPatchParameterfv](http://docs.gl/gl4/glPatchParameter)(pname, values)
        /// * `pname` group: PatchParameterName
        /// * `values` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PatchParameterfv(&self, pname: GLenum, values: *const GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PatchParameterfv({:#X}, {:p});", pname, values);
            }
            let out = call_atomic_ptr_2arg(
                "glPatchParameterfv",
                &self.glPatchParameterfv_p,
                pname,
                values,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPatchParameterfv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PatchParameterfv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glPatchParameterfv\0",
                &self.glPatchParameterfv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn PatchParameterfv_is_loaded(&self) -> bool {
            !self.glPatchParameterfv_p.load(RELAX).is_null()
        }
        /// [glPatchParameteri](http://docs.gl/gl4/glPatchParameter)(pname, value)
        /// * `pname` group: PatchParameterName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PatchParameteri(&self, pname: GLenum, value: GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PatchParameteri({:#X}, {:?});", pname, value);
            }
            let out =
                call_atomic_ptr_2arg("glPatchParameteri", &self.glPatchParameteri_p, pname, value);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPatchParameteri");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PatchParameteri_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glPatchParameteri\0",
                &self.glPatchParameteri_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn PatchParameteri_is_loaded(&self) -> bool {
            !self.glPatchParameteri_p.load(RELAX).is_null()
        }
        /// [glPauseTransformFeedback](http://docs.gl/gl4/glPauseTransformFeedback)()
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PauseTransformFeedback(&self) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PauseTransformFeedback();",);
            }
            let out =
                call_atomic_ptr_0arg("glPauseTransformFeedback", &self.glPauseTransformFeedback_p);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPauseTransformFeedback");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PauseTransformFeedback_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glPauseTransformFeedback\0",
                &self.glPauseTransformFeedback_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn PauseTransformFeedback_is_loaded(&self) -> bool {
            !self.glPauseTransformFeedback_p.load(RELAX).is_null()
        }
        /// [glPixelStoref](http://docs.gl/gl4/glPixelStore)(pname, param)
        /// * `pname` group: PixelStoreParameter
        /// * `param` group: CheckedFloat32
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PixelStoref(&self, pname: GLenum, param: GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PixelStoref({:#X}, {:?});", pname, param);
            }
            let out = call_atomic_ptr_2arg("glPixelStoref", &self.glPixelStoref_p, pname, param);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPixelStoref");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PixelStoref_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glPixelStoref\0", &self.glPixelStoref_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn PixelStoref_is_loaded(&self) -> bool {
            !self.glPixelStoref_p.load(RELAX).is_null()
        }
        /// [glPixelStorei](http://docs.gl/gl4/glPixelStore)(pname, param)
        /// * `pname` group: PixelStoreParameter
        /// * `param` group: CheckedInt32
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PixelStorei(&self, pname: GLenum, param: GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PixelStorei({:#X}, {:?});", pname, param);
            }
            let out = call_atomic_ptr_2arg("glPixelStorei", &self.glPixelStorei_p, pname, param);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPixelStorei");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PixelStorei_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glPixelStorei\0", &self.glPixelStorei_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn PixelStorei_is_loaded(&self) -> bool {
            !self.glPixelStorei_p.load(RELAX).is_null()
        }
        /// [glPointParameterf](http://docs.gl/gl4/glPointParameter)(pname, param)
        /// * `pname` group: PointParameterNameARB
        /// * `param` group: CheckedFloat32
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PointParameterf(&self, pname: GLenum, param: GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PointParameterf({:#X}, {:?});", pname, param);
            }
            let out =
                call_atomic_ptr_2arg("glPointParameterf", &self.glPointParameterf_p, pname, param);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPointParameterf");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PointParameterf_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glPointParameterf\0",
                &self.glPointParameterf_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn PointParameterf_is_loaded(&self) -> bool {
            !self.glPointParameterf_p.load(RELAX).is_null()
        }
        /// [glPointParameterfv](http://docs.gl/gl4/glPointParameter)(pname, params)
        /// * `pname` group: PointParameterNameARB
        /// * `params` group: CheckedFloat32
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PointParameterfv(&self, pname: GLenum, params: *const GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PointParameterfv({:#X}, {:p});", pname, params);
            }
            let out = call_atomic_ptr_2arg(
                "glPointParameterfv",
                &self.glPointParameterfv_p,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPointParameterfv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PointParameterfv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glPointParameterfv\0",
                &self.glPointParameterfv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn PointParameterfv_is_loaded(&self) -> bool {
            !self.glPointParameterfv_p.load(RELAX).is_null()
        }
        /// [glPointParameteri](http://docs.gl/gl4/glPointParameter)(pname, param)
        /// * `pname` group: PointParameterNameARB
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PointParameteri(&self, pname: GLenum, param: GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PointParameteri({:#X}, {:?});", pname, param);
            }
            let out =
                call_atomic_ptr_2arg("glPointParameteri", &self.glPointParameteri_p, pname, param);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPointParameteri");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PointParameteri_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glPointParameteri\0",
                &self.glPointParameteri_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn PointParameteri_is_loaded(&self) -> bool {
            !self.glPointParameteri_p.load(RELAX).is_null()
        }
        /// [glPointParameteriv](http://docs.gl/gl4/glPointParameter)(pname, params)
        /// * `pname` group: PointParameterNameARB
        /// * `params` len: COMPSIZE(pname)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PointParameteriv(&self, pname: GLenum, params: *const GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PointParameteriv({:#X}, {:p});", pname, params);
            }
            let out = call_atomic_ptr_2arg(
                "glPointParameteriv",
                &self.glPointParameteriv_p,
                pname,
                params,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPointParameteriv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PointParameteriv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glPointParameteriv\0",
                &self.glPointParameteriv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn PointParameteriv_is_loaded(&self) -> bool {
            !self.glPointParameteriv_p.load(RELAX).is_null()
        }
        /// [glPointSize](http://docs.gl/gl4/glPointSize)(size)
        /// * `size` group: CheckedFloat32
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PointSize(&self, size: GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PointSize({:?});", size);
            }
            let out = call_atomic_ptr_1arg("glPointSize", &self.glPointSize_p, size);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPointSize");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PointSize_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glPointSize\0", &self.glPointSize_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn PointSize_is_loaded(&self) -> bool {
            !self.glPointSize_p.load(RELAX).is_null()
        }
        /// [glPolygonMode](http://docs.gl/gl4/glPolygonMode)(face, mode)
        /// * `face` group: MaterialFace
        /// * `mode` group: PolygonMode
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PolygonMode(&self, face: GLenum, mode: GLenum) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PolygonMode({:#X}, {:#X});", face, mode);
            }
            let out = call_atomic_ptr_2arg("glPolygonMode", &self.glPolygonMode_p, face, mode);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPolygonMode");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PolygonMode_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(get_proc_address, b"glPolygonMode\0", &self.glPolygonMode_p)
        }
        #[inline]
        #[doc(hidden)]
        pub fn PolygonMode_is_loaded(&self) -> bool {
            !self.glPolygonMode_p.load(RELAX).is_null()
        }
        /// [glPolygonOffset](http://docs.gl/gl4/glPolygonOffset)(factor, units)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PolygonOffset(&self, factor: GLfloat, units: GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PolygonOffset({:?}, {:?});", factor, units);
            }
            let out =
                call_atomic_ptr_2arg("glPolygonOffset", &self.glPolygonOffset_p, factor, units);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPolygonOffset");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PolygonOffset_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glPolygonOffset\0",
                &self.glPolygonOffset_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn PolygonOffset_is_loaded(&self) -> bool {
            !self.glPolygonOffset_p.load(RELAX).is_null()
        }
        /// [glPolygonOffsetClamp](http://docs.gl/gl4/glPolygonOffsetClamp)(factor, units, clamp)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PolygonOffsetClamp(&self, factor: GLfloat, units: GLfloat, clamp: GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.PolygonOffsetClamp({:?}, {:?}, {:?});",
                    factor,
                    units,
                    clamp
                );
            }
            let out = call_atomic_ptr_3arg(
                "glPolygonOffsetClamp",
                &self.glPolygonOffsetClamp_p,
                factor,
                units,
                clamp,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPolygonOffsetClamp");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PolygonOffsetClamp_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glPolygonOffsetClamp\0",
                &self.glPolygonOffsetClamp_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn PolygonOffsetClamp_is_loaded(&self) -> bool {
            !self.glPolygonOffsetClamp_p.load(RELAX).is_null()
        }
        /// [glPopDebugGroup](http://docs.gl/gl4/glPopDebugGroup)()
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PopDebugGroup(&self) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PopDebugGroup();",);
            }
            let out = call_atomic_ptr_0arg("glPopDebugGroup", &self.glPopDebugGroup_p);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPopDebugGroup");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PopDebugGroup_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glPopDebugGroup\0",
                &self.glPopDebugGroup_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn PopDebugGroup_is_loaded(&self) -> bool {
            !self.glPopDebugGroup_p.load(RELAX).is_null()
        }
        /// [glPopDebugGroupKHR](http://docs.gl/gl4/glPopDebugGroupKHR)()
        /// * alias of: [`glPopDebugGroup`]
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PopDebugGroupKHR(&self) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PopDebugGroupKHR();",);
            }
            let out = call_atomic_ptr_0arg("glPopDebugGroupKHR", &self.glPopDebugGroupKHR_p);
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPopDebugGroupKHR");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PopDebugGroupKHR_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glPopDebugGroupKHR\0",
                &self.glPopDebugGroupKHR_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn PopDebugGroupKHR_is_loaded(&self) -> bool {
            !self.glPopDebugGroupKHR_p.load(RELAX).is_null()
        }
        /// [glPrimitiveBoundingBox](http://docs.gl/gl4/glPrimitiveBoundingBox)(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PrimitiveBoundingBox(
            &self,
            minX: GLfloat,
            minY: GLfloat,
            minZ: GLfloat,
            minW: GLfloat,
            maxX: GLfloat,
            maxY: GLfloat,
            maxZ: GLfloat,
            maxW: GLfloat,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PrimitiveBoundingBox({:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?}, {:?});", minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
            }
            let out = call_atomic_ptr_8arg(
                "glPrimitiveBoundingBox",
                &self.glPrimitiveBoundingBox_p,
                minX,
                minY,
                minZ,
                minW,
                maxX,
                maxY,
                maxZ,
                maxW,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPrimitiveBoundingBox");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PrimitiveBoundingBox_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glPrimitiveBoundingBox\0",
                &self.glPrimitiveBoundingBox_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn PrimitiveBoundingBox_is_loaded(&self) -> bool {
            !self.glPrimitiveBoundingBox_p.load(RELAX).is_null()
        }
        /// [glPrimitiveRestartIndex](http://docs.gl/gl4/glPrimitiveRestartIndex)(index)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn PrimitiveRestartIndex(&self, index: GLuint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!("calling gl.PrimitiveRestartIndex({:?});", index);
            }
            let out = call_atomic_ptr_1arg(
                "glPrimitiveRestartIndex",
                &self.glPrimitiveRestartIndex_p,
                index,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glPrimitiveRestartIndex");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn PrimitiveRestartIndex_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glPrimitiveRestartIndex\0",
                &self.glPrimitiveRestartIndex_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn PrimitiveRestartIndex_is_loaded(&self) -> bool {
            !self.glPrimitiveRestartIndex_p.load(RELAX).is_null()
        }
        /// [glProgramBinary](http://docs.gl/gl4/glProgramBinary)(program, binaryFormat, binary, length)
        /// * `binary` len: length
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ProgramBinary(
            &self,
            program: GLuint,
            binaryFormat: GLenum,
            binary: *const c_void,
            length: GLsizei,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ProgramBinary({:?}, {:#X}, {:p}, {:?});",
                    program,
                    binaryFormat,
                    binary,
                    length
                );
            }
            let out = call_atomic_ptr_4arg(
                "glProgramBinary",
                &self.glProgramBinary_p,
                program,
                binaryFormat,
                binary,
                length,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glProgramBinary");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ProgramBinary_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glProgramBinary\0",
                &self.glProgramBinary_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ProgramBinary_is_loaded(&self) -> bool {
            !self.glProgramBinary_p.load(RELAX).is_null()
        }
        /// [glProgramParameteri](http://docs.gl/gl4/glProgramParameteri)(program, pname, value)
        /// * `pname` group: ProgramParameterPName
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ProgramParameteri(&self, program: GLuint, pname: GLenum, value: GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ProgramParameteri({:?}, {:#X}, {:?});",
                    program,
                    pname,
                    value
                );
            }
            let out = call_atomic_ptr_3arg(
                "glProgramParameteri",
                &self.glProgramParameteri_p,
                program,
                pname,
                value,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glProgramParameteri");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ProgramParameteri_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glProgramParameteri\0",
                &self.glProgramParameteri_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ProgramParameteri_is_loaded(&self) -> bool {
            !self.glProgramParameteri_p.load(RELAX).is_null()
        }
        /// [glProgramUniform1d](http://docs.gl/gl4/glProgramUniform1d)(program, location, v0)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ProgramUniform1d(&self, program: GLuint, location: GLint, v0: GLdouble) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ProgramUniform1d({:?}, {:?}, {:?});",
                    program,
                    location,
                    v0
                );
            }
            let out = call_atomic_ptr_3arg(
                "glProgramUniform1d",
                &self.glProgramUniform1d_p,
                program,
                location,
                v0,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glProgramUniform1d");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ProgramUniform1d_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glProgramUniform1d\0",
                &self.glProgramUniform1d_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ProgramUniform1d_is_loaded(&self) -> bool {
            !self.glProgramUniform1d_p.load(RELAX).is_null()
        }
        /// [glProgramUniform1dv](http://docs.gl/gl4/glProgramUniform1dv)(program, location, count, value)
        /// * `value` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ProgramUniform1dv(
            &self,
            program: GLuint,
            location: GLint,
            count: GLsizei,
            value: *const GLdouble,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ProgramUniform1dv({:?}, {:?}, {:?}, {:p});",
                    program,
                    location,
                    count,
                    value
                );
            }
            let out = call_atomic_ptr_4arg(
                "glProgramUniform1dv",
                &self.glProgramUniform1dv_p,
                program,
                location,
                count,
                value,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glProgramUniform1dv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ProgramUniform1dv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glProgramUniform1dv\0",
                &self.glProgramUniform1dv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ProgramUniform1dv_is_loaded(&self) -> bool {
            !self.glProgramUniform1dv_p.load(RELAX).is_null()
        }
        /// [glProgramUniform1f](http://docs.gl/gl4/glProgramUniform)(program, location, v0)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ProgramUniform1f(&self, program: GLuint, location: GLint, v0: GLfloat) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ProgramUniform1f({:?}, {:?}, {:?});",
                    program,
                    location,
                    v0
                );
            }
            let out = call_atomic_ptr_3arg(
                "glProgramUniform1f",
                &self.glProgramUniform1f_p,
                program,
                location,
                v0,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glProgramUniform1f");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ProgramUniform1f_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glProgramUniform1f\0",
                &self.glProgramUniform1f_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ProgramUniform1f_is_loaded(&self) -> bool {
            !self.glProgramUniform1f_p.load(RELAX).is_null()
        }
        /// [glProgramUniform1fv](http://docs.gl/gl4/glProgramUniform)(program, location, count, value)
        /// * `value` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ProgramUniform1fv(
            &self,
            program: GLuint,
            location: GLint,
            count: GLsizei,
            value: *const GLfloat,
        ) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ProgramUniform1fv({:?}, {:?}, {:?}, {:p});",
                    program,
                    location,
                    count,
                    value
                );
            }
            let out = call_atomic_ptr_4arg(
                "glProgramUniform1fv",
                &self.glProgramUniform1fv_p,
                program,
                location,
                count,
                value,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glProgramUniform1fv");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ProgramUniform1fv_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glProgramUniform1fv\0",
                &self.glProgramUniform1fv_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ProgramUniform1fv_is_loaded(&self) -> bool {
            !self.glProgramUniform1fv_p.load(RELAX).is_null()
        }
        /// [glProgramUniform1i](http://docs.gl/gl4/glProgramUniform)(program, location, v0)
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ProgramUniform1i(&self, program: GLuint, location: GLint, v0: GLint) {
            #[cfg(all(debug_assertions, feature = "debug_trace_calls"))]
            {
                trace!(
                    "calling gl.ProgramUniform1i({:?}, {:?}, {:?});",
                    program,
                    location,
                    v0
                );
            }
            let out = call_atomic_ptr_3arg(
                "glProgramUniform1i",
                &self.glProgramUniform1i_p,
                program,
                location,
                v0,
            );
            #[cfg(all(debug_assertions, feature = "debug_automatic_glGetError"))]
            {
                self.automatic_glGetError("glProgramUniform1i");
            }
            out
        }
        #[doc(hidden)]
        pub unsafe fn ProgramUniform1i_load_with_dyn(
            &self,
            get_proc_address: &mut dyn FnMut(*const c_char) -> *mut c_void,
        ) -> bool {
            load_dyn_name_atomic_ptr(
                get_proc_address,
                b"glProgramUniform1i\0",
                &self.glProgramUniform1i_p,
            )
        }
        #[inline]
        #[doc(hidden)]
        pub fn ProgramUniform1i_is_loaded(&self) -> bool {
            !self.glProgramUniform1i_p.load(RELAX).is_null()
        }
        /// [glProgramUniform1iv](http://docs.gl/gl4/glProgramUniform)(program, location, count, value)
        /// * `value` len: count
        #[cfg_attr(feature = "inline", inline)]
        #[cfg_attr(feature = "inline_always", inline(always))]
        pub unsafe fn ProgramUniform1iv(
           