/*
 * Copyright (c) 2013, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package jdk.jfr.event.runtime;

import java.time.Duration;
import java.util.List;

import jdk.jfr.Recording;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedThread;
import jdk.test.lib.jfr.EventNames;
import jdk.test.lib.jfr.Events;

/**
 * @test
 *
 *
 * @key jfr
 * @library /test/lib /
 * @run main/othervm -XX:+UseParallelGC jdk.jfr.event.runtime.TestVMOperation
 */
public class TestVMOperation {

    private static final String EVENT_NAME = EventNames.ExecuteVMOperation;
    private static final String VM_OPERATION = "ParallelGCSystemGC";

    public static void main(String[] args) throws Throwable {
        Recording recording = new Recording();
        recording.enable(EVENT_NAME).withThreshold(Duration.ofMillis(0));
        recording.start();
        System.gc();
        recording.stop();

        List<RecordedEvent> events = Events.fromRecording(recording);
        Events.hasEvents(events);
        for (RecordedEvent event : Events.fromRecording(recording)) {
            String operation = Events.assertField(event, "operation").notEmpty().getValue();
            if (operation.equals(VM_OPERATION)) {
                Events.assertField(event, "safepoint").equal(true);
                Events.assertField(event, "blocking").equal(true);
                RecordedThread jt = event.getValue("caller");
                if (Thread.currentThread().getName().equals(jt.getJavaName())) {
                    return;
                }
            }
        }
        throw new AssertionError("No matching event with VM operation name " + VM_OPERATION + " and current threasd as caller");
    }
}
