#ifndef __PACKAGEDETAILS_H_2025_01_01
#define __PACKAGEDETAILS_H_2025_01_01

#include "ipackagedetails.h"


namespace NApt {

class PackageDetails : public IPackageDetails
{
public:
    PackageDetails(
        const QString& description,
        const QString& essential,
        const QString& priority,
        const QString& section,
        const QString& maintainer,
        const QString& replaces,
        const QString& provides,
        const QString& preDepends,
        const QString& depends,
        const QString& recommends,
        const QString& suggests,
        const QString& conflicts,
        const QString& breaks,
        const QString& md5sum,
        const QString& conffiles,
        const QString& filename,
        const QString& source,
        const QString& homepage,
        uint size,
        uint installedSize
    ) :
        _longDescription(description),
        _essential(essential),
        _priority(priority),
        _section(section),
        _maintainer(maintainer),
        _replaces(replaces),
        _provides(provides),
        _preDepends(preDepends),
        _depends(depends),
        _recommends(recommends),
        _suggests(suggests),
        _conflicts(conflicts),
        _breaks(breaks),
        _md5sum(md5sum),
        _conffiles(conffiles),
        _filename(filename),
        _source(source),
        _homepage(homepage),
        _size(size),
        _installedSize(installedSize)
    {}
    ~PackageDetails() override = default;

    QString longDescription() const override { return _longDescription; };

    QString essential() const override { return _essential; }
    QString priority() const override { return _priority; }
    QString section() const override { return _section; }
    QString installedSize() const override { return QString::number(_installedSize);; }
    QString maintainer() const override { return _maintainer; }

    QString replaces() const override { return _replaces; }
    QString provides() const override { return _provides; }
    QString preDepends() const override { return _preDepends; }
    QString depends() const override { return _depends; }
    QString recommends() const override { return _recommends; }
    QString suggests() const override { return _suggests; }
    QString conflicts() const override { return _conflicts; }
    QString breaks() const override { return _breaks; }

    QString size() const override { return QString::number(_size); }
    QString md5sum() const override { return _md5sum; }
    QString conffiles() const override { return _conffiles; }

    QString filename() const override { return _filename; }
    QString source() const override { return _source; }

    QString homepage() const override { return _homepage; }

    uint getSize() const override { return _size; }
    uint getInstalledSize() const override { return _installedSize; }

private:
    QString _longDescription;

    QString _essential;
    QString _priority;
    QString _section;
    QString _maintainer;

    QString _replaces;
    QString _provides;
    QString _preDepends;
    QString _depends;
    QString _recommends;
    QString _suggests;
    QString _conflicts;
    QString _breaks;

    QString _md5sum;
    QString _conffiles;

    QString _filename;
    QString _source;

    QString _homepage;

    uint _size;
    uint _installedSize;
};

}

#endif // __PACKAGEDETAILS_H_2025_01_01
