# Changes since [4.6.0](./4.6.0.md)

## Bug fixes

- Fix a bug causing broken installation if `~/.local/lib` is a symbolic link

  - or `site-packages` or any of its parents are a symbolic link

- Fix incompatibilty with Python 3.9 (despite documentation)

- Fix `scripts/entry-filters-doc.py`, `scripts/plugin-doc.py` and `doc/entry-filters.md`

- AppleDict: Fix typos in Chinese language module

## Features:

- Use environment variable `VERBOSITY` as default (a number from 0 to 5)

## Improvements

- AppleDict Binary: set `html_full=True` by default

- Update `wcwidth` to `0.2.6`

## Refactoring

- Add `glos.stripFullHtml(errorHandler)` and use it in 3 plugins

  - Add entry filter `StripFullHtml` and change `entry.stripFullHtml()` to return error

- Refactor `entryFiltersRules`

- Remove empty plugin gettext_mo.py

- Remove `glos.titleElement` from `glossary_v2.Glossary`

  - Add to `glossary.Glossary` for compatibility
  - `glossary.Glossary` is a wrapper (child class) on top on `glossary_v2.Glossary`

## Documentation

- Update `doc/entry-filters.md` to list some entry filters that were enabled conditionally (besides config)

- Remove `sdict.md` and `sdict_source.md` (removed plugins)

## Type checking

- Add missing method in `GlossaryType` class
- Fix `mypy` errors on most of code base and some of plugins
- Use builtin types `list, dict, tuple, set` for type annotations
- Replace `Optional[X]` with `X or None`
  - will not effect runtime, but type checking now only works with Python 3.10+
