# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.batch import BatchManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestBatchManagementBatchAccountOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(BatchManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create(self, resource_group):
        response = self.client.batch_account.begin_create(
            resource_group_name=resource_group.name,
            account_name="str",
            parameters={
                "location": "str",
                "allowedAuthenticationModes": ["str"],
                "autoStorage": {
                    "storageAccountId": "str",
                    "authenticationMode": "StorageKeys",
                    "nodeIdentityReference": {"resourceId": "str"},
                },
                "encryption": {"keySource": "str", "keyVaultProperties": {"keyIdentifier": "str"}},
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "keyVaultReference": {"id": "str", "url": "str"},
                "networkProfile": {
                    "accountAccess": {"defaultAction": "str", "ipRules": [{"action": "Allow", "value": "str"}]},
                    "nodeManagementAccess": {"defaultAction": "str", "ipRules": [{"action": "Allow", "value": "str"}]},
                },
                "poolAllocationMode": "str",
                "publicNetworkAccess": "Enabled",
                "tags": {"str": "str"},
            },
            api_version="2024-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update(self, resource_group):
        response = self.client.batch_account.update(
            resource_group_name=resource_group.name,
            account_name="str",
            parameters={
                "allowedAuthenticationModes": ["str"],
                "autoStorage": {
                    "storageAccountId": "str",
                    "authenticationMode": "StorageKeys",
                    "nodeIdentityReference": {"resourceId": "str"},
                },
                "encryption": {"keySource": "str", "keyVaultProperties": {"keyIdentifier": "str"}},
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "networkProfile": {
                    "accountAccess": {"defaultAction": "str", "ipRules": [{"action": "Allow", "value": "str"}]},
                    "nodeManagementAccess": {"defaultAction": "str", "ipRules": [{"action": "Allow", "value": "str"}]},
                },
                "publicNetworkAccess": "Enabled",
                "tags": {"str": "str"},
            },
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.batch_account.begin_delete(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.batch_account.get(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.batch_account.list(
            api_version="2024-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.batch_account.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_synchronize_auto_storage_keys(self, resource_group):
        response = self.client.batch_account.synchronize_auto_storage_keys(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_regenerate_key(self, resource_group):
        response = self.client.batch_account.regenerate_key(
            resource_group_name=resource_group.name,
            account_name="str",
            parameters={"keyName": "str"},
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_keys(self, resource_group):
        response = self.client.batch_account.get_keys(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_detectors(self, resource_group):
        response = self.client.batch_account.list_detectors(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_detector(self, resource_group):
        response = self.client.batch_account.get_detector(
            resource_group_name=resource_group.name,
            account_name="str",
            detector_id="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_outbound_network_dependencies_endpoints(self, resource_group):
        response = self.client.batch_account.list_outbound_network_dependencies_endpoints(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
