# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.confidentialledger.aio import ConfidentialLedger

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestConfidentialLedgerManagedCCFOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ConfidentialLedger, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_ccf_get(self, resource_group):
        response = await self.client.managed_ccf.get(
            resource_group_name=resource_group.name,
            app_name="str",
            api_version="2024-09-19-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_ccf_begin_delete(self, resource_group):
        response = await (
            await self.client.managed_ccf.begin_delete(
                resource_group_name=resource_group.name,
                app_name="str",
                api_version="2024-09-19-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_ccf_begin_create(self, resource_group):
        response = await (
            await self.client.managed_ccf.begin_create(
                resource_group_name=resource_group.name,
                app_name="str",
                managed_ccf={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "appName": "str",
                        "appUri": "str",
                        "deploymentType": {"appSourceUri": "str", "languageRuntime": "str"},
                        "enclavePlatform": "str",
                        "identityServiceUri": "str",
                        "memberIdentityCertificates": [{"certificate": "str", "encryptionkey": "str", "tags": {}}],
                        "nodeCount": 3,
                        "provisioningState": "str",
                        "runningState": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-19-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_ccf_begin_update(self, resource_group):
        response = await (
            await self.client.managed_ccf.begin_update(
                resource_group_name=resource_group.name,
                app_name="str",
                managed_ccf={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "appName": "str",
                        "appUri": "str",
                        "deploymentType": {"appSourceUri": "str", "languageRuntime": "str"},
                        "enclavePlatform": "str",
                        "identityServiceUri": "str",
                        "memberIdentityCertificates": [{"certificate": "str", "encryptionkey": "str", "tags": {}}],
                        "nodeCount": 3,
                        "provisioningState": "str",
                        "runningState": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-19-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_ccf_list_by_resource_group(self, resource_group):
        response = self.client.managed_ccf.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-09-19-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_ccf_list_by_subscription(self, resource_group):
        response = self.client.managed_ccf.list_by_subscription(
            api_version="2024-09-19-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_ccf_begin_backup(self, resource_group):
        response = await (
            await self.client.managed_ccf.begin_backup(
                resource_group_name=resource_group.name,
                app_name="str",
                managed_ccf={"uri": "str", "restoreRegion": "str"},
                api_version="2024-09-19-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_ccf_begin_restore(self, resource_group):
        response = await (
            await self.client.managed_ccf.begin_restore(
                resource_group_name=resource_group.name,
                app_name="str",
                managed_ccf={"fileShareName": "str", "restoreRegion": "str", "uri": "str"},
                api_version="2024-09-19-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
