# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AdvancedFilterOperatorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others."""

    NUMBER_IN = "NumberIn"
    NUMBER_NOT_IN = "NumberNotIn"
    NUMBER_LESS_THAN = "NumberLessThan"
    NUMBER_GREATER_THAN = "NumberGreaterThan"
    NUMBER_LESS_THAN_OR_EQUALS = "NumberLessThanOrEquals"
    NUMBER_GREATER_THAN_OR_EQUALS = "NumberGreaterThanOrEquals"
    BOOL_EQUALS = "BoolEquals"
    STRING_IN = "StringIn"
    STRING_NOT_IN = "StringNotIn"
    STRING_BEGINS_WITH = "StringBeginsWith"
    STRING_ENDS_WITH = "StringEndsWith"
    STRING_CONTAINS = "StringContains"
    NUMBER_IN_RANGE = "NumberInRange"
    NUMBER_NOT_IN_RANGE = "NumberNotInRange"
    STRING_NOT_BEGINS_WITH = "StringNotBeginsWith"
    STRING_NOT_ENDS_WITH = "StringNotEndsWith"
    STRING_NOT_CONTAINS = "StringNotContains"
    IS_NULL_OR_UNDEFINED = "IsNullOrUndefined"
    IS_NOT_NULL = "IsNotNull"


class CaCertificateProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the CA Certificate resource."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    DELETED = "Deleted"


class ChannelProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the channel."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    IDLE_DUE_TO_MIRRORED_PARTNER_TOPIC_DELETION = "IdleDueToMirroredPartnerTopicDeletion"


class ChannelType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the event channel which represents the direction flow of events."""

    PARTNER_TOPIC = "PartnerTopic"


class ClientCertificateValidationScheme(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The validation scheme used to authenticate the client. Default value is
    SubjectMatchesAuthenticationName.
    """

    SUBJECT_MATCHES_AUTHENTICATION_NAME = "SubjectMatchesAuthenticationName"
    DNS_MATCHES_AUTHENTICATION_NAME = "DnsMatchesAuthenticationName"
    URI_MATCHES_AUTHENTICATION_NAME = "UriMatchesAuthenticationName"
    IP_MATCHES_AUTHENTICATION_NAME = "IpMatchesAuthenticationName"
    EMAIL_MATCHES_AUTHENTICATION_NAME = "EmailMatchesAuthenticationName"
    THUMBPRINT_MATCH = "ThumbprintMatch"


class ClientGroupProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the ClientGroup resource."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    DELETED = "Deleted"


class ClientProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the Client resource."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    DELETED = "Deleted"


class ClientState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if the client is enabled or not. Default value is Enabled."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class CustomDomainIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"


class CustomDomainValidationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Validation state for the custom domain. This is a read only property and is initially set to
    'Pending' and will be updated to 'Approved' by Event Grid only after ownership of the domain
    name has been successfully validated.
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    ERROR_RETRIEVING_DNS_RECORD = "ErrorRetrievingDnsRecord"


class DataResidencyBoundary(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Data Residency Boundary of the resource."""

    WITHIN_GEOPAIR = "WithinGeopair"
    WITHIN_REGION = "WithinRegion"


class DeadLetterEndPointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the endpoint for the dead letter destination."""

    STORAGE_BLOB = "StorageBlob"


class DeliveryAttributeMappingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the delivery attribute or header name."""

    STATIC = "Static"
    DYNAMIC = "Dynamic"


class DeliveryMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Delivery mode of the event subscription."""

    QUEUE = "Queue"
    PUSH = "Push"


class DeliverySchema(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The event delivery schema for the event subscription."""

    CLOUD_EVENT_SCHEMA_V1_0 = "CloudEventSchemaV1_0"


class DomainProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the Event Grid Domain Resource."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"


class DomainTopicProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the domain topic."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"


class EndpointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the endpoint for the event subscription destination."""

    WEB_HOOK = "WebHook"
    EVENT_HUB = "EventHub"
    STORAGE_QUEUE = "StorageQueue"
    HYBRID_CONNECTION = "HybridConnection"
    SERVICE_BUS_QUEUE = "ServiceBusQueue"
    SERVICE_BUS_TOPIC = "ServiceBusTopic"
    AZURE_FUNCTION = "AzureFunction"
    MONITOR_ALERT = "MonitorAlert"
    NAMESPACE_TOPIC = "NamespaceTopic"


class EventDefinitionKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of event type used."""

    INLINE = "Inline"


class EventDeliverySchema(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The event delivery schema for the event subscription."""

    EVENT_GRID_SCHEMA = "EventGridSchema"
    CUSTOM_INPUT_SCHEMA = "CustomInputSchema"
    CLOUD_EVENT_SCHEMA_V1_0 = "CloudEventSchemaV1_0"


class EventInputSchema(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This determines the format that is expected for incoming events published to the topic."""

    CLOUD_EVENT_SCHEMA_V1_0 = "CloudEventSchemaV1_0"


class EventSubscriptionIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"


class EventSubscriptionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the event subscription."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    AWAITING_MANUAL_ACTION = "AwaitingManualAction"


class FilterOperatorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others."""

    NUMBER_IN = "NumberIn"
    NUMBER_NOT_IN = "NumberNotIn"
    NUMBER_LESS_THAN = "NumberLessThan"
    NUMBER_GREATER_THAN = "NumberGreaterThan"
    NUMBER_LESS_THAN_OR_EQUALS = "NumberLessThanOrEquals"
    NUMBER_GREATER_THAN_OR_EQUALS = "NumberGreaterThanOrEquals"
    BOOL_EQUALS = "BoolEquals"
    STRING_IN = "StringIn"
    STRING_NOT_IN = "StringNotIn"
    STRING_BEGINS_WITH = "StringBeginsWith"
    STRING_ENDS_WITH = "StringEndsWith"
    STRING_CONTAINS = "StringContains"
    NUMBER_IN_RANGE = "NumberInRange"
    NUMBER_NOT_IN_RANGE = "NumberNotInRange"
    STRING_NOT_BEGINS_WITH = "StringNotBeginsWith"
    STRING_NOT_ENDS_WITH = "StringNotEndsWith"
    STRING_NOT_CONTAINS = "StringNotContains"
    IS_NULL_OR_UNDEFINED = "IsNullOrUndefined"
    IS_NOT_NULL = "IsNotNull"


class IdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an
    implicitly created identity and a set of user-assigned identities. The type 'None' will remove
    any identity.
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"


class InputSchema(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This determines the format that Event Grid should expect for incoming events published to the
    Event Grid Domain Resource.
    """

    EVENT_GRID_SCHEMA = "EventGridSchema"
    CUSTOM_EVENT_SCHEMA = "CustomEventSchema"
    CLOUD_EVENT_SCHEMA_V1_0 = "CloudEventSchemaV1_0"


class InputSchemaMappingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the custom mapping."""

    JSON = "Json"


class IpActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Action to perform based on the match or no match of the IpMask."""

    ALLOW = "Allow"


class MonitorAlertSeverity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The severity that will be attached to every Alert fired through this event subscription.
    This field must be provided.
    """

    SEV0 = "Sev0"
    SEV1 = "Sev1"
    SEV2 = "Sev2"
    SEV3 = "Sev3"
    SEV4 = "Sev4"


class NamespaceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the namespace resource."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    DELETED = "Deleted"
    DELETE_FAILED = "DeleteFailed"
    CREATE_FAILED = "CreateFailed"
    UPDATED_FAILED = "UpdatedFailed"


class NamespaceTopicProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the namespace topic."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    DELETED = "Deleted"
    DELETE_FAILED = "DeleteFailed"
    CREATE_FAILED = "CreateFailed"
    UPDATED_FAILED = "UpdatedFailed"


class PartnerConfigurationProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the partner configuration."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"


class PartnerNamespaceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the partner namespace."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"


class PartnerRegistrationProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the partner registration."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"


class PartnerTopicActivationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Activation state of the partner topic."""

    NEVER_ACTIVATED = "NeverActivated"
    ACTIVATED = "Activated"
    DEACTIVATED = "Deactivated"


class PartnerTopicProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the partner topic."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    IDLE_DUE_TO_MIRRORED_CHANNEL_RESOURCE_DELETION = "IdleDueToMirroredChannelResourceDeletion"


class PartnerTopicRoutingMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This determines if events published to this partner namespace should use the source attribute
    in the event payload
    or use the channel name in the header when matching to the partner topic. If none is specified,
    source attribute routing will be used to match the partner topic.
    """

    SOURCE_EVENT_ATTRIBUTE = "SourceEventAttribute"
    CHANNEL_NAME_HEADER = "ChannelNameHeader"


class PermissionBindingProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the PermissionBinding resource."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    DELETED = "Deleted"


class PermissionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The allowed permission."""

    PUBLISHER = "Publisher"
    SUBSCRIBER = "Subscriber"


class PersistedConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the connection."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"


class PrivateEndpointConnectionsParentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PrivateEndpointConnectionsParentType."""

    TOPICS = "topics"
    DOMAINS = "domains"
    PARTNER_NAMESPACES = "partnerNamespaces"
    NAMESPACES = "namespaces"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This determines if traffic is allowed over public network. By default it is enabled.
    You can further restrict to specific IPs by configuring :code:`<seealso
    cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules"
    />`.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class PublisherType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Publisher type of the namespace topic."""

    CUSTOM = "Custom"


class ReadinessState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The readiness state of the corresponding partner topic."""

    NEVER_ACTIVATED = "NeverActivated"
    ACTIVATED = "Activated"


class ResourceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the Private Endpoint Connection."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"


class ResourceRegionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Region type of the resource."""

    REGIONAL_RESOURCE = "RegionalResource"
    GLOBAL_RESOURCE = "GlobalResource"


class RoutingIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Routing identity type for topic spaces configuration."""

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the SKU."""

    STANDARD = "Standard"


class StaticRoutingEnrichmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Static routing enrichment value type. For e.g. this property value can be 'String'."""

    STRING = "String"


class SubscriptionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the event subscription."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    AWAITING_MANUAL_ACTION = "AwaitingManualAction"
    DELETED = "Deleted"
    DELETE_FAILED = "DeleteFailed"
    CREATE_FAILED = "CreateFailed"
    UPDATED_FAILED = "UpdatedFailed"


class TlsVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Minimum TLS version of the publisher allowed to publish to this domain."""

    ONE0 = "1.0"
    ONE1 = "1.1"
    ONE2 = "1.2"


class TopicProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the topic."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"


class TopicSpaceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the TopicSpace resource."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    DELETED = "Deleted"


class TopicSpacesConfigurationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class TopicTypeProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the topic type."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"


class TopicTypeSourceScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TopicTypeSourceScope."""

    RESOURCE = "Resource"
    RESOURCE_GROUP = "ResourceGroup"
    AZURE_SUBSCRIPTION = "AzureSubscription"
    MANAGEMENT_GROUP = "ManagementGroup"


class VerifiedPartnerProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the verified partner."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
