# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details:
     list[~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class Extension(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The Extension object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar identity: Identity of the Extension resource.
    :vartype identity: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.Identity
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.SystemData
    :ivar plan: The plan information.
    :vartype plan: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.Plan
    :ivar extension_type: Type of the Extension, of which this resource is an instance of.  It must
     be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the
     Extension publisher.
    :vartype extension_type: str
    :ivar auto_upgrade_minor_version: Flag to note if this extension participates in auto upgrade
     of minor version, or not.
    :vartype auto_upgrade_minor_version: bool
    :ivar release_train: ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable,
     Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
    :vartype release_train: str
    :ivar version: User-specified version of the extension for this extension to 'pin'. To use
     'version', autoUpgradeMinorVersion must be 'false'.
    :vartype version: str
    :ivar scope: Scope at which the extension is installed.
    :vartype scope: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.Scope
    :ivar configuration_settings: Configuration settings, as name-value pairs for configuring this
     extension.
    :vartype configuration_settings: dict[str, str]
    :ivar configuration_protected_settings: Configuration settings that are sensitive, as
     name-value pairs for configuring this extension.
    :vartype configuration_protected_settings: dict[str, str]
    :ivar installed_version: Installed version of the extension.
    :vartype installed_version: str
    :ivar provisioning_state: Status of installation of this extension. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ProvisioningState
    :ivar statuses: Status from this extension.
    :vartype statuses:
     list[~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ExtensionStatus]
    :ivar error_info: Error information from the Agent - e.g. errors during installation.
    :vartype error_info: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ErrorDetail
    :ivar custom_location_settings: Custom Location settings properties.
    :vartype custom_location_settings: dict[str, str]
    :ivar package_uri: Uri of the Helm package.
    :vartype package_uri: str
    :ivar aks_assigned_identity: Identity of the Extension resource in an AKS cluster.
    :vartype aks_assigned_identity:
     ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ExtensionPropertiesAksAssignedIdentity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "installed_version": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "error_info": {"readonly": True},
        "custom_location_settings": {"readonly": True},
        "package_uri": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "plan": {"key": "plan", "type": "Plan"},
        "extension_type": {"key": "properties.extensionType", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "release_train": {"key": "properties.releaseTrain", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "scope": {"key": "properties.scope", "type": "Scope"},
        "configuration_settings": {"key": "properties.configurationSettings", "type": "{str}"},
        "configuration_protected_settings": {"key": "properties.configurationProtectedSettings", "type": "{str}"},
        "installed_version": {"key": "properties.installedVersion", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "statuses": {"key": "properties.statuses", "type": "[ExtensionStatus]"},
        "error_info": {"key": "properties.errorInfo", "type": "ErrorDetail"},
        "custom_location_settings": {"key": "properties.customLocationSettings", "type": "{str}"},
        "package_uri": {"key": "properties.packageUri", "type": "str"},
        "aks_assigned_identity": {
            "key": "properties.aksAssignedIdentity",
            "type": "ExtensionPropertiesAksAssignedIdentity",
        },
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.Identity"] = None,
        plan: Optional["_models.Plan"] = None,
        extension_type: Optional[str] = None,
        auto_upgrade_minor_version: bool = True,
        release_train: str = "Stable",
        version: Optional[str] = None,
        scope: Optional["_models.Scope"] = None,
        configuration_settings: Optional[Dict[str, str]] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        statuses: Optional[List["_models.ExtensionStatus"]] = None,
        aks_assigned_identity: Optional["_models.ExtensionPropertiesAksAssignedIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Identity of the Extension resource.
        :paramtype identity: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.Identity
        :keyword plan: The plan information.
        :paramtype plan: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.Plan
        :keyword extension_type: Type of the Extension, of which this resource is an instance of.  It
         must be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the
         Extension publisher.
        :paramtype extension_type: str
        :keyword auto_upgrade_minor_version: Flag to note if this extension participates in auto
         upgrade of minor version, or not.
        :paramtype auto_upgrade_minor_version: bool
        :keyword release_train: ReleaseTrain this extension participates in for auto-upgrade (e.g.
         Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
        :paramtype release_train: str
        :keyword version: User-specified version of the extension for this extension to 'pin'. To use
         'version', autoUpgradeMinorVersion must be 'false'.
        :paramtype version: str
        :keyword scope: Scope at which the extension is installed.
        :paramtype scope: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.Scope
        :keyword configuration_settings: Configuration settings, as name-value pairs for configuring
         this extension.
        :paramtype configuration_settings: dict[str, str]
        :keyword configuration_protected_settings: Configuration settings that are sensitive, as
         name-value pairs for configuring this extension.
        :paramtype configuration_protected_settings: dict[str, str]
        :keyword statuses: Status from this extension.
        :paramtype statuses:
         list[~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ExtensionStatus]
        :keyword aks_assigned_identity: Identity of the Extension resource in an AKS cluster.
        :paramtype aks_assigned_identity:
         ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ExtensionPropertiesAksAssignedIdentity
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.system_data = None
        self.plan = plan
        self.extension_type = extension_type
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.release_train = release_train
        self.version = version
        self.scope = scope
        self.configuration_settings = configuration_settings
        self.configuration_protected_settings = configuration_protected_settings
        self.installed_version = None
        self.provisioning_state = None
        self.statuses = statuses
        self.error_info = None
        self.custom_location_settings = None
        self.package_uri = None
        self.aks_assigned_identity = aks_assigned_identity


class ExtensionPropertiesAksAssignedIdentity(_serialization.Model):
    """Identity of the Extension resource in an AKS cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Known values are: "SystemAssigned" and "UserAssigned".
    :vartype type: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.AKSIdentityType
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.AKSIdentityType"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The identity type. Known values are: "SystemAssigned" and "UserAssigned".
        :paramtype type: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.AKSIdentityType
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class ExtensionsList(_serialization.Model):
    """Result of the request to list Extensions.  It contains a list of Extension objects and a URL
    link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Extensions within a Kubernetes cluster.
    :vartype value: list[~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.Extension]
    :ivar next_link: URL to get the next set of extension objects, if any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Extension]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ExtensionStatus(_serialization.Model):
    """Status from the extension.

    :ivar code: Status code provided by the Extension.
    :vartype code: str
    :ivar display_status: Short description of status of the extension.
    :vartype display_status: str
    :ivar level: Level of the status. Known values are: "Error", "Warning", and "Information".
    :vartype level: str or ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.LevelType
    :ivar message: Detailed message of the status from the Extension.
    :vartype message: str
    :ivar time: DateLiteral (per ISO8601) noting the time of installation status.
    :vartype time: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "time": {"key": "time", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        display_status: Optional[str] = None,
        level: Union[str, "_models.LevelType"] = "Information",
        message: Optional[str] = None,
        time: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Status code provided by the Extension.
        :paramtype code: str
        :keyword display_status: Short description of status of the extension.
        :paramtype display_status: str
        :keyword level: Level of the status. Known values are: "Error", "Warning", and "Information".
        :paramtype level: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.LevelType
        :keyword message: Detailed message of the status from the Extension.
        :paramtype message: str
        :keyword time: DateLiteral (per ISO8601) noting the time of installation status.
        :paramtype time: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.display_status = display_status
        self.level = level
        self.message = message
        self.time = time


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Default value is "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Literal["SystemAssigned"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The identity type. Default value is "SystemAssigned".
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class ResourceAutoGenerated(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(ResourceAutoGenerated):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class KubernetesConfigurationPrivateLinkScope(TrackedResource):
    """An Azure Arc PrivateLinkScope definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties that define a Azure Arc PrivateLinkScope resource.
    :vartype properties:
     ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.KubernetesConfigurationPrivateLinkScopeProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "KubernetesConfigurationPrivateLinkScopeProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.KubernetesConfigurationPrivateLinkScopeProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Properties that define a Azure Arc PrivateLinkScope resource.
        :paramtype properties:
         ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.KubernetesConfigurationPrivateLinkScopeProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class KubernetesConfigurationPrivateLinkScopeListResult(_serialization.Model):
    """Describes the list of Azure Arc PrivateLinkScope resources.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of Azure Arc PrivateLinkScope definitions. Required.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.KubernetesConfigurationPrivateLinkScope]
    :ivar next_link: The URI to get the next set of Azure Arc PrivateLinkScope definitions if too
     many PrivateLinkScopes where returned in the result set.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[KubernetesConfigurationPrivateLinkScope]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: List["_models.KubernetesConfigurationPrivateLinkScope"],
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Azure Arc PrivateLinkScope definitions. Required.
        :paramtype value:
         list[~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.KubernetesConfigurationPrivateLinkScope]
        :keyword next_link: The URI to get the next set of Azure Arc PrivateLinkScope definitions if
         too many PrivateLinkScopes where returned in the result set.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class KubernetesConfigurationPrivateLinkScopeProperties(_serialization.Model):
    """Properties that define a Azure Arc PrivateLinkScope resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar public_network_access: Indicates whether machines associated with the private link scope
     can also use public Azure Arc service endpoints. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.PublicNetworkAccessType
    :ivar provisioning_state: Current state of this PrivateLinkScope: whether or not is has been
     provisioned within the resource group it is defined. Users cannot change this value but are
     able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed. Known
     values are: "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ProvisioningState
    :ivar cluster_resource_id: Managed Cluster ARM ID for the private link scope  (Required).
     Required.
    :vartype cluster_resource_id: str
    :ivar private_link_scope_id: The Guid id of the private link scope.
    :vartype private_link_scope_id: str
    :ivar private_endpoint_connections: The collection of associated Private Endpoint Connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.PrivateEndpointConnection]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "cluster_resource_id": {"required": True},
        "private_link_scope_id": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "cluster_resource_id": {"key": "clusterResourceId", "type": "str"},
        "private_link_scope_id": {"key": "privateLinkScopeId", "type": "str"},
        "private_endpoint_connections": {"key": "privateEndpointConnections", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(
        self,
        *,
        cluster_resource_id: str,
        public_network_access: Union[str, "_models.PublicNetworkAccessType"] = "Disabled",
        **kwargs: Any
    ) -> None:
        """
        :keyword public_network_access: Indicates whether machines associated with the private link
         scope can also use public Azure Arc service endpoints. Known values are: "Enabled" and
         "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.PublicNetworkAccessType
        :keyword cluster_resource_id: Managed Cluster ARM ID for the private link scope  (Required).
         Required.
        :paramtype cluster_resource_id: str
        """
        super().__init__(**kwargs)
        self.public_network_access = public_network_access
        self.provisioning_state = None
        self.cluster_resource_id = cluster_resource_id
        self.private_link_scope_id = None
        self.private_endpoint_connections = None


class OperationStatusResult(_serialization.Model):
    """The current status of an async operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar properties: Additional information, if available.
    :vartype properties: dict[str, str]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ErrorDetail
    """

    _validation = {
        "status": {"required": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword properties: Additional information, if available.
        :paramtype properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.properties = properties
        self.error = None


class PatchExtension(_serialization.Model):
    """The Extension Patch Request object.

    :ivar auto_upgrade_minor_version: Flag to note if this extension participates in auto upgrade
     of minor version, or not.
    :vartype auto_upgrade_minor_version: bool
    :ivar release_train: ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable,
     Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
    :vartype release_train: str
    :ivar version: Version of the extension for this extension, if it is 'pinned' to a specific
     version. autoUpgradeMinorVersion must be 'false'.
    :vartype version: str
    :ivar configuration_settings: Configuration settings, as name-value pairs for configuring this
     extension.
    :vartype configuration_settings: dict[str, str]
    :ivar configuration_protected_settings: Configuration settings that are sensitive, as
     name-value pairs for configuring this extension.
    :vartype configuration_protected_settings: dict[str, str]
    """

    _attribute_map = {
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "release_train": {"key": "properties.releaseTrain", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "configuration_settings": {"key": "properties.configurationSettings", "type": "{str}"},
        "configuration_protected_settings": {"key": "properties.configurationProtectedSettings", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        auto_upgrade_minor_version: bool = True,
        release_train: str = "Stable",
        version: Optional[str] = None,
        configuration_settings: Optional[Dict[str, str]] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auto_upgrade_minor_version: Flag to note if this extension participates in auto
         upgrade of minor version, or not.
        :paramtype auto_upgrade_minor_version: bool
        :keyword release_train: ReleaseTrain this extension participates in for auto-upgrade (e.g.
         Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
        :paramtype release_train: str
        :keyword version: Version of the extension for this extension, if it is 'pinned' to a specific
         version. autoUpgradeMinorVersion must be 'false'.
        :paramtype version: str
        :keyword configuration_settings: Configuration settings, as name-value pairs for configuring
         this extension.
        :paramtype configuration_settings: dict[str, str]
        :keyword configuration_protected_settings: Configuration settings that are sensitive, as
         name-value pairs for configuring this extension.
        :paramtype configuration_protected_settings: dict[str, str]
        """
        super().__init__(**kwargs)
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.release_train = release_train
        self.version = version
        self.configuration_settings = configuration_settings
        self.configuration_protected_settings = configuration_protected_settings


class Plan(_serialization.Model):
    """Plan for the resource.

    All required parameters must be populated in order to send to Azure.

    :ivar name: A user defined name of the 3rd Party Artifact that is being procured. Required.
    :vartype name: str
    :ivar publisher: The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic.
     Required.
    :vartype publisher: str
    :ivar product: The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to
     the OfferID specified for the artifact at the time of Data Market onboarding. Required.
    :vartype product: str
    :ivar promotion_code: A publisher provided promotion code as provisioned in Data Market for the
     said product/artifact.
    :vartype promotion_code: str
    :ivar version: The version of the desired product/artifact.
    :vartype version: str
    """

    _validation = {
        "name": {"required": True},
        "publisher": {"required": True},
        "product": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        product: str,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: A user defined name of the 3rd Party Artifact that is being procured. Required.
        :paramtype name: str
        :keyword publisher: The publisher of the 3rd Party Artifact that is being bought. E.g.
         NewRelic. Required.
        :paramtype publisher: str
        :keyword product: The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to
         the OfferID specified for the artifact at the time of Data Market onboarding. Required.
        :paramtype product: str
        :keyword promotion_code: A publisher provided promotion code as provisioned in Data Market for
         the said product/artifact.
        :paramtype promotion_code: str
        :keyword version: The version of the desired product/artifact.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code
        self.version = version


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(ResourceAutoGenerated):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.SystemData
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint:
     ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint:
         ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    :ivar value: Array of private endpoint connections.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value:
         list[~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkResource(ResourceAutoGenerated):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.SystemData
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value:
         list[~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class Scope(_serialization.Model):
    """Scope of the extension. It can be either Cluster or Namespace; but not both.

    :ivar cluster: Specifies that the scope of the extension is Cluster.
    :vartype cluster: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ScopeCluster
    :ivar namespace: Specifies that the scope of the extension is Namespace.
    :vartype namespace:
     ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ScopeNamespace
    """

    _attribute_map = {
        "cluster": {"key": "cluster", "type": "ScopeCluster"},
        "namespace": {"key": "namespace", "type": "ScopeNamespace"},
    }

    def __init__(
        self,
        *,
        cluster: Optional["_models.ScopeCluster"] = None,
        namespace: Optional["_models.ScopeNamespace"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cluster: Specifies that the scope of the extension is Cluster.
        :paramtype cluster: ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ScopeCluster
        :keyword namespace: Specifies that the scope of the extension is Namespace.
        :paramtype namespace:
         ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.ScopeNamespace
        """
        super().__init__(**kwargs)
        self.cluster = cluster
        self.namespace = namespace


class ScopeCluster(_serialization.Model):
    """Specifies that the scope of the extension is Cluster.

    :ivar release_namespace: Namespace where the extension Release must be placed, for a Cluster
     scoped extension.  If this namespace does not exist, it will be created.
    :vartype release_namespace: str
    """

    _attribute_map = {
        "release_namespace": {"key": "releaseNamespace", "type": "str"},
    }

    def __init__(self, *, release_namespace: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword release_namespace: Namespace where the extension Release must be placed, for a Cluster
         scoped extension.  If this namespace does not exist, it will be created.
        :paramtype release_namespace: str
        """
        super().__init__(**kwargs)
        self.release_namespace = release_namespace


class ScopeNamespace(_serialization.Model):
    """Specifies that the scope of the extension is Namespace.

    :ivar target_namespace: Namespace where the extension will be created for an Namespace scoped
     extension.  If this namespace does not exist, it will be created.
    :vartype target_namespace: str
    """

    _attribute_map = {
        "target_namespace": {"key": "targetNamespace", "type": "str"},
    }

    def __init__(self, *, target_namespace: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword target_namespace: Namespace where the extension will be created for an Namespace
         scoped extension.  If this namespace does not exist, it will be created.
        :paramtype target_namespace: str
        """
        super().__init__(**kwargs)
        self.target_namespace = target_namespace


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_04_02_preview.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsResource(_serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on a
    PrivateLinkScope instance.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags
