# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class ConnectionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A connection type for access labs and VMs (Public, Private or None)."""

    PUBLIC = "Public"
    PRIVATE = "Private"
    NONE = "None"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class CreateOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates what lab virtual machines are created from."""

    #: An image is used to create all lab user virtual machines. When this option is set, no template
    #: VM will be created.
    IMAGE = "Image"
    #: A template VM will be used to create all lab user virtual machines.
    TEMPLATE_VM = "TemplateVM"


class EnableState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Property enabled state."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class InvitationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The lab user invitation state."""

    #: The invitation has not been sent.
    NOT_SENT = "NotSent"
    #: Currently sending the invitation.
    SENDING = "Sending"
    #: The invitation has been successfully sent.
    SENT = "Sent"
    #: There was an error while sending the invitation.
    FAILED = "Failed"


class LabServicesSkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The tier of the SKU."""

    STANDARD = "Standard"
    PREMIUM = "Premium"


class LabState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of a virtual machine."""

    #: The lab is currently in draft (has not been published).
    DRAFT = "Draft"
    #: The lab is publishing.
    PUBLISHING = "Publishing"
    #: The lab is scaling.
    SCALING = "Scaling"
    #: The lab is syncing users.
    SYNCING = "Syncing"
    #: The lab has been published.
    PUBLISHED = "Published"


class OperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operation status."""

    #: The operation has been accepted but hasn't started.
    NOT_STARTED = "NotStarted"
    #: The operation is running
    IN_PROGRESS = "InProgress"
    #: The operation Succeeded
    SUCCEEDED = "Succeeded"
    #: The operation failed
    FAILED = "Failed"
    #: Not supported yet
    CANCELED = "Canceled"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class OsState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operating system state."""

    #: Image does not contain any machine and user specific information.
    GENERALIZED = "Generalized"
    #: Image contains machine and user specific information.
    SPECIALIZED = "Specialized"


class OsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operating system type."""

    WINDOWS = "Windows"
    LINUX = "Linux"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource provisioning state."""

    #: Resource is in the process of being created.
    CREATING = "Creating"
    #: New property values are being applied to the resource.
    UPDATING = "Updating"
    #: Resource is in the process of being deleted.
    DELETING = "Deleting"
    #: Resource is in healthy state after creation or update operation.
    SUCCEEDED = "Succeeded"
    #: Previous operation on the resource has failed leaving resource in unhealthy state.
    FAILED = "Failed"
    #: The resource is locked and changes are currently blocked. This could be due to maintenance or a
    #: scheduled operation. The state will go back to succeeded once the locking operation has
    #: finished.
    LOCKED = "Locked"


class RecurrenceFrequency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Schedule recurrence frequencies."""

    #: Schedule will run every days.
    DAILY = "Daily"
    #: Schedule will run every week on days specified in weekDays.
    WEEKLY = "Weekly"


class RegistrationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The user lab registration state."""

    #: User has not yet registered with the lab.
    REGISTERED = "Registered"
    #: User has registered with the lab.
    NOT_REGISTERED = "NotRegistered"


class RestrictionReasonCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reason for the restriction."""

    QUOTA_ID = "QuotaId"
    NOT_AVAILABLE_FOR_SUBSCRIPTION = "NotAvailableForSubscription"


class RestrictionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of restriction."""

    LOCATION = "Location"


class ScaleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The localized name of the resource."""

    #: The capacity is not adjustable in any way.
    NONE = "None"
    #: The user must manually scale this SKU in and out.
    MANUAL = "Manual"
    #: The user is permitted to scale this SKU in and out.
    AUTOMATIC = "Automatic"


class ShutdownOnIdleMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines whether to shut down VM on idle and the criteria for idle detection."""

    #: The VM won't be shut down when it is idle.
    NONE = "None"
    #: The VM will be considered as idle when there is no keyboard or mouse input.
    USER_ABSENCE = "UserAbsence"
    #: The VM will be considered as idle when user is absent and the resource (CPU and disk)
    #: consumption is low.
    LOW_USAGE = "LowUsage"


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This field is required to be implemented by the Resource Provider if the service has more than
    one tier, but is not required on a PUT.
    """

    FREE = "Free"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class UsageUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The unit details."""

    COUNT = "Count"


class VirtualMachineState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of a virtual machine."""

    #: The VM is currently stopped.
    STOPPED = "Stopped"
    #: The VM is starting.
    STARTING = "Starting"
    #: The VM is running.
    RUNNING = "Running"
    #: The VM is stopping.
    STOPPING = "Stopping"
    #: The VM password is being reset.
    RESETTING_PASSWORD = "ResettingPassword"
    #: The VM is being reimaged.
    REIMAGING = "Reimaging"
    #: The VM is being redeployed.
    REDEPLOYING = "Redeploying"


class VirtualMachineType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the lab virtual machine."""

    #: A user VM
    USER = "User"
    #: A template VM
    TEMPLATE = "Template"


class WeekDay(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Days of the week."""

    #: Schedule will run on Sunday
    SUNDAY = "Sunday"
    #: Schedule will run on Monday
    MONDAY = "Monday"
    #: Schedule will run on Tuesday
    TUESDAY = "Tuesday"
    #: Schedule will run on Wednesday
    WEDNESDAY = "Wednesday"
    #: Schedule will run on Thursday
    THURSDAY = "Thursday"
    #: Schedule will run on Friday
    FRIDAY = "Friday"
    #: Schedule will run on Saturday
    SATURDAY = "Saturday"
