# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.9.5, generator: @autorest/python@6.34.1)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, MutableMapping

from .._utils import serialization as _serialization

JSON = MutableMapping[str, Any]

if TYPE_CHECKING:
    from .. import models as _models


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.search.documents.agent.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.search.documents.agent.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetail"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.search.documents.agent.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.search.documents.agent.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class KnowledgeAgentActivityRecord(_serialization.Model):
    """Base type for activity records.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeAgentSearchActivityRecord, KnowledgeAgentSemanticRankerActivityRecord,
    KnowledgeAgentModelQueryPlanningActivityRecord

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "AzureSearchQuery": "KnowledgeAgentSearchActivityRecord",
            "AzureSearchSemanticRanker": "KnowledgeAgentSemanticRankerActivityRecord",
            "ModelQueryPlanning": "KnowledgeAgentModelQueryPlanningActivityRecord",
        }
    }

    def __init__(self, *, id: int, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        """
        super().__init__(**kwargs)
        self.id = id
        self.type: Optional[str] = None


class KnowledgeAgentReference(_serialization.Model):
    """Base type for references.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeAgentAzureSearchDocReference

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the reference. Required.
    :vartype type: str
    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    """

    _validation = {
        "type": {"required": True},
        "id": {"required": True},
        "activity_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "activity_source": {"key": "activitySource", "type": "int"},
    }

    _subtype_map = {"type": {"AzureSearchDoc": "KnowledgeAgentAzureSearchDocReference"}}

    def __init__(self, *, id: str, activity_source: int, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ID of the reference. Required.
        :paramtype id: str
        :keyword activity_source: The source activity ID for the reference. Required.
        :paramtype activity_source: int
        """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.id = id
        self.activity_source = activity_source


class KnowledgeAgentAzureSearchDocReference(KnowledgeAgentReference):
    """Represents an Azure Search document reference.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the reference. Required.
    :vartype type: str
    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar doc_key: The document key for the reference.
    :vartype doc_key: str
    :ivar source_data: Dictionary of :code:`<any>`.
    :vartype source_data: dict[str, any]
    """

    _validation = {
        "type": {"required": True},
        "id": {"required": True},
        "activity_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "activity_source": {"key": "activitySource", "type": "int"},
        "doc_key": {"key": "docKey", "type": "str"},
        "source_data": {"key": "sourceData", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        doc_key: Optional[str] = None,
        source_data: Optional[Dict[str, Any]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the reference. Required.
        :paramtype id: str
        :keyword activity_source: The source activity ID for the reference. Required.
        :paramtype activity_source: int
        :keyword doc_key: The document key for the reference.
        :paramtype doc_key: str
        :keyword source_data: Dictionary of :code:`<any>`.
        :paramtype source_data: dict[str, any]
        """
        super().__init__(id=id, activity_source=activity_source, **kwargs)
        self.type: str = "AzureSearchDoc"
        self.doc_key = doc_key
        self.source_data = source_data


class KnowledgeAgentIndexParams(_serialization.Model):
    """KnowledgeAgentIndexParams.

    :ivar index_name: The name of the index the params apply to.
    :vartype index_name: str
    :ivar filter_add_on: A filter condition applied to the index (e.g., 'State eq VA').
    :vartype filter_add_on: str
    :ivar max_docs_for_reranker: Limits the number of documents considered for ranking.
    :vartype max_docs_for_reranker: int
    :ivar reranker_threshold: A threshold for reranking results (range: 0-4).
    :vartype reranker_threshold: float
    :ivar include_reference_source_data: Indicates whether reference source data should be
     included.
    :vartype include_reference_source_data: bool
    """

    _validation = {
        "reranker_threshold": {"maximum": 4, "minimum": 0},
    }

    _attribute_map = {
        "index_name": {"key": "indexName", "type": "str"},
        "filter_add_on": {"key": "filterAddOn", "type": "str"},
        "max_docs_for_reranker": {"key": "maxDocsForReranker", "type": "int"},
        "reranker_threshold": {"key": "rerankerThreshold", "type": "float"},
        "include_reference_source_data": {"key": "includeReferenceSourceData", "type": "bool"},
    }

    def __init__(
        self,
        *,
        index_name: Optional[str] = None,
        filter_add_on: Optional[str] = None,
        max_docs_for_reranker: Optional[int] = None,
        reranker_threshold: Optional[float] = None,
        include_reference_source_data: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword index_name: The name of the index the params apply to.
        :paramtype index_name: str
        :keyword filter_add_on: A filter condition applied to the index (e.g., 'State eq VA').
        :paramtype filter_add_on: str
        :keyword max_docs_for_reranker: Limits the number of documents considered for ranking.
        :paramtype max_docs_for_reranker: int
        :keyword reranker_threshold: A threshold for reranking results (range: 0-4).
        :paramtype reranker_threshold: float
        :keyword include_reference_source_data: Indicates whether reference source data should be
         included.
        :paramtype include_reference_source_data: bool
        """
        super().__init__(**kwargs)
        self.index_name = index_name
        self.filter_add_on = filter_add_on
        self.max_docs_for_reranker = max_docs_for_reranker
        self.reranker_threshold = reranker_threshold
        self.include_reference_source_data = include_reference_source_data


class KnowledgeAgentMessage(_serialization.Model):
    """The natural language message style object.

    All required parameters must be populated in order to send to server.

    :ivar role: The role of the tool response. Required.
    :vartype role: str
    :ivar content: Required.
    :vartype content: list[~azure.search.documents.agent.models.KnowledgeAgentMessageContent]
    """

    _validation = {
        "role": {"required": True},
        "content": {"required": True},
    }

    _attribute_map = {
        "role": {"key": "role", "type": "str"},
        "content": {"key": "content", "type": "[KnowledgeAgentMessageContent]"},
    }

    def __init__(self, *, role: str, content: List["_models.KnowledgeAgentMessageContent"], **kwargs: Any) -> None:
        """
        :keyword role: The role of the tool response. Required.
        :paramtype role: str
        :keyword content: Required.
        :paramtype content: list[~azure.search.documents.agent.models.KnowledgeAgentMessageContent]
        """
        super().__init__(**kwargs)
        self.role = role
        self.content = content


class KnowledgeAgentMessageContent(_serialization.Model):
    """Specifies the type of the message content.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeAgentMessageImageContent, KnowledgeAgentMessageTextContent

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the message. Required. Known values are: "text" and "image".
    :vartype type: str or ~azure.search.documents.agent.models.KnowledgeAgentMessageContentType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"image": "KnowledgeAgentMessageImageContent", "text": "KnowledgeAgentMessageTextContent"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None


class KnowledgeAgentMessageImageContent(KnowledgeAgentMessageContent):
    """Text message type.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the message. Required. Known values are: "text" and "image".
    :vartype type: str or ~azure.search.documents.agent.models.KnowledgeAgentMessageContentType
    :ivar image: Required.
    :vartype image: ~azure.search.documents.agent.models.KnowledgeAgentMessageImageContentImage
    """

    _validation = {
        "type": {"required": True},
        "image": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "image": {"key": "image", "type": "KnowledgeAgentMessageImageContentImage"},
    }

    def __init__(self, *, image: "_models.KnowledgeAgentMessageImageContentImage", **kwargs: Any) -> None:
        """
        :keyword image: Required.
        :paramtype image: ~azure.search.documents.agent.models.KnowledgeAgentMessageImageContentImage
        """
        super().__init__(**kwargs)
        self.type: str = "image"
        self.image = image


class KnowledgeAgentMessageImageContentImage(_serialization.Model):
    """KnowledgeAgentMessageImageContentImage.

    All required parameters must be populated in order to send to server.

    :ivar url: The url of the image. Required.
    :vartype url: str
    """

    _validation = {
        "url": {"required": True},
    }

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: str, **kwargs: Any) -> None:
        """
        :keyword url: The url of the image. Required.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.url = url


class KnowledgeAgentMessageTextContent(KnowledgeAgentMessageContent):
    """Text message type.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the message. Required. Known values are: "text" and "image".
    :vartype type: str or ~azure.search.documents.agent.models.KnowledgeAgentMessageContentType
    :ivar text: Required.
    :vartype text: str
    """

    _validation = {
        "type": {"required": True},
        "text": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "text": {"key": "text", "type": "str"},
    }

    def __init__(self, *, text: str, **kwargs: Any) -> None:
        """
        :keyword text: Required.
        :paramtype text: str
        """
        super().__init__(**kwargs)
        self.type: str = "text"
        self.text = text


class KnowledgeAgentModelQueryPlanningActivityRecord(KnowledgeAgentActivityRecord):  # pylint: disable=name-too-long
    """Represents an LLM query planning activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar input_tokens: The number of input tokens for the LLM query planning activity.
    :vartype input_tokens: int
    :ivar output_tokens: The number of output tokens for the LLM query planning activity.
    :vartype output_tokens: int
    :ivar elapsed_ms: The elapsed time in milliseconds for the model activity.
    :vartype elapsed_ms: int
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "input_tokens": {"key": "inputTokens", "type": "int"},
        "output_tokens": {"key": "outputTokens", "type": "int"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        input_tokens: Optional[int] = None,
        output_tokens: Optional[int] = None,
        elapsed_ms: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword input_tokens: The number of input tokens for the LLM query planning activity.
        :paramtype input_tokens: int
        :keyword output_tokens: The number of output tokens for the LLM query planning activity.
        :paramtype output_tokens: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the model activity.
        :paramtype elapsed_ms: int
        """
        super().__init__(id=id, **kwargs)
        self.type: str = "ModelQueryPlanning"
        self.input_tokens = input_tokens
        self.output_tokens = output_tokens
        self.elapsed_ms = elapsed_ms


class KnowledgeAgentRetrievalRequest(_serialization.Model):
    """The input contract for the retrieval request.

    All required parameters must be populated in order to send to server.

    :ivar messages: Required.
    :vartype messages: list[~azure.search.documents.agent.models.KnowledgeAgentMessage]
    :ivar target_index_params:
    :vartype target_index_params:
     list[~azure.search.documents.agent.models.KnowledgeAgentIndexParams]
    """

    _validation = {
        "messages": {"required": True},
    }

    _attribute_map = {
        "messages": {"key": "messages", "type": "[KnowledgeAgentMessage]"},
        "target_index_params": {"key": "targetIndexParams", "type": "[KnowledgeAgentIndexParams]"},
    }

    def __init__(
        self,
        *,
        messages: List["_models.KnowledgeAgentMessage"],
        target_index_params: Optional[List["_models.KnowledgeAgentIndexParams"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword messages: Required.
        :paramtype messages: list[~azure.search.documents.agent.models.KnowledgeAgentMessage]
        :keyword target_index_params:
        :paramtype target_index_params:
         list[~azure.search.documents.agent.models.KnowledgeAgentIndexParams]
        """
        super().__init__(**kwargs)
        self.messages = messages
        self.target_index_params = target_index_params


class KnowledgeAgentRetrievalResponse(_serialization.Model):
    """The output contract for the retrieval response.

    :ivar response:
    :vartype response: list[~azure.search.documents.agent.models.KnowledgeAgentMessage]
    :ivar activity: The activity records for tracking progress and billing implications.
    :vartype activity: list[~azure.search.documents.agent.models.KnowledgeAgentActivityRecord]
    :ivar references: The references for the retrieval data used in the response.
    :vartype references: list[~azure.search.documents.agent.models.KnowledgeAgentReference]
    """

    _attribute_map = {
        "response": {"key": "response", "type": "[KnowledgeAgentMessage]"},
        "activity": {"key": "activity", "type": "[KnowledgeAgentActivityRecord]"},
        "references": {"key": "references", "type": "[KnowledgeAgentReference]"},
    }

    def __init__(
        self,
        *,
        response: Optional[List["_models.KnowledgeAgentMessage"]] = None,
        activity: Optional[List["_models.KnowledgeAgentActivityRecord"]] = None,
        references: Optional[List["_models.KnowledgeAgentReference"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword response:
        :paramtype response: list[~azure.search.documents.agent.models.KnowledgeAgentMessage]
        :keyword activity: The activity records for tracking progress and billing implications.
        :paramtype activity: list[~azure.search.documents.agent.models.KnowledgeAgentActivityRecord]
        :keyword references: The references for the retrieval data used in the response.
        :paramtype references: list[~azure.search.documents.agent.models.KnowledgeAgentReference]
        """
        super().__init__(**kwargs)
        self.response = response
        self.activity = activity
        self.references = references


class KnowledgeAgentSearchActivityRecord(KnowledgeAgentActivityRecord):
    """Represents a retrieval activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar target_index: The target index for the retrieval activity.
    :vartype target_index: str
    :ivar query: The query details for the retrieval activity.
    :vartype query: ~azure.search.documents.agent.models.KnowledgeAgentSearchActivityRecordQuery
    :ivar query_time: The query time for this retrieval activity.
    :vartype query_time: ~datetime.datetime
    :ivar count: The count of documents retrieved.
    :vartype count: int
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "target_index": {"key": "targetIndex", "type": "str"},
        "query": {"key": "query", "type": "KnowledgeAgentSearchActivityRecordQuery"},
        "query_time": {"key": "queryTime", "type": "iso-8601"},
        "count": {"key": "count", "type": "int"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        target_index: Optional[str] = None,
        query: Optional["_models.KnowledgeAgentSearchActivityRecordQuery"] = None,
        query_time: Optional[datetime.datetime] = None,
        count: Optional[int] = None,
        elapsed_ms: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword target_index: The target index for the retrieval activity.
        :paramtype target_index: str
        :keyword query: The query details for the retrieval activity.
        :paramtype query: ~azure.search.documents.agent.models.KnowledgeAgentSearchActivityRecordQuery
        :keyword query_time: The query time for this retrieval activity.
        :paramtype query_time: ~datetime.datetime
        :keyword count: The count of documents retrieved.
        :paramtype count: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        """
        super().__init__(id=id, **kwargs)
        self.type: str = "AzureSearchQuery"
        self.target_index = target_index
        self.query = query
        self.query_time = query_time
        self.count = count
        self.elapsed_ms = elapsed_ms


class KnowledgeAgentSearchActivityRecordQuery(_serialization.Model):
    """The query details for the retrieval activity.

    :ivar search: The search string.
    :vartype search: str
    :ivar filter: The filter string.
    :vartype filter: str
    """

    _attribute_map = {
        "search": {"key": "search", "type": "str"},
        "filter": {"key": "filter", "type": "str"},
    }

    def __init__(
        self,
        *,
        search: Optional[str] = None,
        filter: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword search: The search string.
        :paramtype search: str
        :keyword filter: The filter string.
        :paramtype filter: str
        """
        super().__init__(**kwargs)
        self.search = search
        self.filter = filter


class KnowledgeAgentSemanticRankerActivityRecord(KnowledgeAgentActivityRecord):  # pylint: disable=name-too-long
    """Represents a semantic ranker activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar input_tokens: The number of input tokens for the semantic ranker activity.
    :vartype input_tokens: int
    :ivar elapsed_ms: The elapsed time in milliseconds for the model activity.
    :vartype elapsed_ms: int
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "input_tokens": {"key": "inputTokens", "type": "int"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        input_tokens: Optional[int] = None,
        elapsed_ms: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword input_tokens: The number of input tokens for the semantic ranker activity.
        :paramtype input_tokens: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the model activity.
        :paramtype elapsed_ms: int
        """
        super().__init__(id=id, **kwargs)
        self.type: str = "AzureSearchSemanticRanker"
        self.input_tokens = input_tokens
        self.elapsed_ms = elapsed_ms


class RequestOptions(_serialization.Model):
    """Parameter group.

    :ivar x_ms_client_request_id: The tracking ID sent with the request to help with debugging.
    :vartype x_ms_client_request_id: str
    """

    _attribute_map = {
        "x_ms_client_request_id": {"key": "x-ms-client-request-id", "type": "str"},
    }

    def __init__(self, *, x_ms_client_request_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword x_ms_client_request_id: The tracking ID sent with the request to help with debugging.
        :paramtype x_ms_client_request_id: str
        """
        super().__init__(**kwargs)
        self.x_ms_client_request_id = x_ms_client_request_id
