# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=R0914
from io import IOBase
import json
import sys
from typing import Any, Callable, Dict, IO, List, Optional, Type, TypeVar, Union, overload

from azure.core import MatchConditions
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceModifiedError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._model_base import SdkJSONEncoder, _deserialize
from ..._operations._operations import (
    build_text_translation_find_sentence_boundaries_request,
    build_text_translation_get_supported_languages_request,
    build_text_translation_lookup_dictionary_entries_request,
    build_text_translation_lookup_dictionary_examples_request,
    build_text_translation_translate_request,
    build_text_translation_transliterate_request,
)
from .._vendor import TextTranslationClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class TextTranslationClientOperationsMixin(TextTranslationClientMixinABC):

    @distributed_trace_async
    async def get_supported_languages(
        self,
        *,
        client_trace_id: Optional[str] = None,
        scope: Optional[str] = None,
        accept_language: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.GetSupportedLanguagesResult:
        # pylint: disable=line-too-long
        """Gets the set of languages currently supported by other operations of the Translator.

        Gets the set of languages currently supported by other operations of the Translator.

        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword scope: A comma-separated list of names defining the group of languages to return.
         Allowed group names are: ``translation``\\ , ``transliteration`` and ``dictionary``.
         If no scope is given, then all groups are returned, which is equivalent to passing
         ``scope=translation,transliteration,dictionary``. To decide which set of supported languages
         is appropriate for your scenario, see the description of the `response object
         <#response-body>`_. Default value is None.
        :paramtype scope: str
        :keyword accept_language: The language to use for user interface strings. Some of the fields in
         the response are names of languages or
         names of regions. Use this parameter to define the language in which these names are returned.
         The language is specified by providing a well-formed BCP 47 language tag. For instance, use
         the value ``fr``
         to request names in French or use the value ``zh-Hant`` to request names in Chinese
         Traditional.
         Names are provided in the English language when a target language is not specified or when
         localization
         is not available. Default value is None.
        :paramtype accept_language: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: GetSupportedLanguagesResult. The GetSupportedLanguagesResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.translation.text.models.GetSupportedLanguagesResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "dictionary": {
                        "str": {
                            "dir": "str",  # Directionality, which is rtl for
                              right-to-left languages or ltr for left-to-right languages. Required.
                              Known values are: "ltr" and "rtl".
                            "name": "str",  # Display name of the language in the locale
                              requested via Accept-Language header. Required.
                            "nativeName": "str",  # Display name of the language in the
                              locale native for this language. Required.
                            "translations": [
                                {
                                    "code": "str",  # Language code identifying
                                      the target language. Required.
                                    "dir": "str",  # Directionality, which is rtl
                                      for right-to-left languages or ltr for left-to-right languages.
                                      Required. Known values are: "ltr" and "rtl".
                                    "name": "str",  # Display name of the
                                      language in the locale requested via Accept-Language header.
                                      Required.
                                    "nativeName": "str"  # Display name of the
                                      language in the locale native for this language. Required.
                                }
                            ]
                        }
                    },
                    "translation": {
                        "str": {
                            "dir": "str",  # Directionality, which is rtl for
                              right-to-left languages or ltr for left-to-right languages. Required.
                              Known values are: "ltr" and "rtl".
                            "name": "str",  # Display name of the language in the locale
                              requested via Accept-Language header. Required.
                            "nativeName": "str"  # Display name of the language in the
                              locale native for this language. Required.
                        }
                    },
                    "transliteration": {
                        "str": {
                            "name": "str",  # Display name of the language in the locale
                              requested via Accept-Language header. Required.
                            "nativeName": "str",  # Display name of the language in the
                              locale native for this language. Required.
                            "scripts": [
                                {
                                    "code": "str",  # Code identifying the
                                      script. Required.
                                    "dir": "str",  # Directionality, which is rtl
                                      for right-to-left languages or ltr for left-to-right languages.
                                      Required. Known values are: "ltr" and "rtl".
                                    "name": "str",  # Display name of the script
                                      in the locale requested via Accept-Language header. Required.
                                    "nativeName": "str",  # Display name of the
                                      language in the locale native for the language. Required.
                                    "toScripts": [
                                        {
                                            "code": "str",  # Code
                                              identifying the script. Required.
                                            "dir": "str",  #
                                              Directionality, which is rtl for right-to-left languages
                                              or ltr for left-to-right languages. Required. Known
                                              values are: "ltr" and "rtl".
                                            "name": "str",  # Display
                                              name of the script in the locale requested via
                                              Accept-Language header. Required.
                                            "nativeName": "str"  #
                                              Display name of the language in the locale native for the
                                              language. Required.
                                        }
                                    ]
                                }
                            ]
                        }
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.GetSupportedLanguagesResult] = kwargs.pop("cls", None)

        _request = build_text_translation_get_supported_languages_request(
            client_trace_id=client_trace_id,
            scope=scope,
            accept_language=accept_language,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.GetSupportedLanguagesResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def translate(
        self,
        body: List[_models.InputTextItem],
        *,
        to_language: List[str],
        client_trace_id: Optional[str] = None,
        from_language: Optional[str] = None,
        text_type: Optional[Union[str, _models.TextType]] = None,
        category: Optional[str] = None,
        profanity_action: Optional[Union[str, _models.ProfanityAction]] = None,
        profanity_marker: Optional[Union[str, _models.ProfanityMarker]] = None,
        include_alignment: Optional[bool] = None,
        include_sentence_length: Optional[bool] = None,
        suggested_from: Optional[str] = None,
        from_script: Optional[str] = None,
        to_script: Optional[str] = None,
        allow_fallback: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.TranslatedTextItem]:
        # pylint: disable=line-too-long
        """Translate Text.

        Translate Text.

        :param body: Defines the content of the request. Required.
        :type body: list[~azure.ai.translation.text.models.InputTextItem]
        :keyword to_language: Specifies the language of the output text. The target language must be
         one of the supported languages included
         in the translation scope. For example, use to=de to translate to German.
         It's possible to translate to multiple languages simultaneously by repeating the parameter in
         the query string.
         For example, use to=de&to=it to translate to German and Italian. Required.
        :paramtype to_language: list[str]
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword from_language: Specifies the language of the input text. Find which languages are
         available to translate from by
         looking up supported languages using the translation scope. If the from parameter isn't
         specified,
         automatic language detection is applied to determine the source language.

         You must use the from parameter rather than autodetection when using the dynamic dictionary
         feature.
         Note: the dynamic dictionary feature is case-sensitive. Default value is None.
        :paramtype from_language: str
        :keyword text_type: Defines whether the text being translated is plain text or HTML text. Any
         HTML needs to be a well-formed,
         complete element. Possible values are: plain (default) or html. Known values are: "Plain" and
         "Html". Default value is None.
        :paramtype text_type: str or ~azure.ai.translation.text.models.TextType
        :keyword category: A string specifying the category (domain) of the translation. This parameter
         is used to get translations
         from a customized system built with Custom Translator. Add the Category ID from your Custom
         Translator
         project details to this parameter to use your deployed customized system. Default value is:
         general. Default value is None.
        :paramtype category: str
        :keyword profanity_action: Specifies how profanities should be treated in translations.
         Possible values are: NoAction (default), Marked or Deleted. Known values are: "NoAction",
         "Marked", and "Deleted". Default value is None.
        :paramtype profanity_action: str or ~azure.ai.translation.text.models.ProfanityAction
        :keyword profanity_marker: Specifies how profanities should be marked in translations.
         Possible values are: Asterisk (default) or Tag. Known values are: "Asterisk" and "Tag".
         Default value is None.
        :paramtype profanity_marker: str or ~azure.ai.translation.text.models.ProfanityMarker
        :keyword include_alignment: Specifies whether to include alignment projection from source text
         to translated text.
         Possible values are: true or false (default). Default value is None.
        :paramtype include_alignment: bool
        :keyword include_sentence_length: Specifies whether to include sentence boundaries for the
         input text and the translated text.
         Possible values are: true or false (default). Default value is None.
        :paramtype include_sentence_length: bool
        :keyword suggested_from: Specifies a fallback language if the language of the input text can't
         be identified.
         Language autodetection is applied when the from parameter is omitted. If detection fails,
         the suggestedFrom language will be assumed. Default value is None.
        :paramtype suggested_from: str
        :keyword from_script: Specifies the script of the input text. Default value is None.
        :paramtype from_script: str
        :keyword to_script: Specifies the script of the translated text. Default value is None.
        :paramtype to_script: str
        :keyword allow_fallback: Specifies that the service is allowed to fall back to a general system
         when a custom system doesn't exist.
         Possible values are: true (default) or false.

         allowFallback=false specifies that the translation should only use systems trained for the
         category specified
         by the request. If a translation for language X to language Y requires chaining through a
         pivot language E,
         then all the systems in the chain (X → E and E → Y) will need to be custom and have the same
         category.
         If no system is found with the specific category, the request will return a 400 status code.
         allowFallback=true
         specifies that the service is allowed to fall back to a general system when a custom system
         doesn't exist. Default value is None.
        :paramtype allow_fallback: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of TranslatedTextItem
        :rtype: list[~azure.ai.translation.text.models.TranslatedTextItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    {
                        "text": "str"  # Text to translate. Required.
                    }
                ]

                # response body for status code(s): 200
                response == [
                    {
                        "translations": [
                            {
                                "text": "str",  # A string giving the translated
                                  text. Required.
                                "to": "str",  # A string representing the language
                                  code of the target language. Required.
                                "alignment": {
                                    "proj": "str"  # Maps input text to
                                      translated text. The alignment information is only provided when
                                      the request  parameter includeAlignment is true. Alignment is
                                      returned as a string value of the following  format:
                                      [[SourceTextStartIndex]:[SourceTextEndIndex]"u2013[TgtTextStartIndex]:[TgtTextEndIndex]].
                                      The colon separates start and end index, the dash separates the
                                      languages, and space separates the words.  One word may align
                                      with zero, one, or multiple words in the other language, and the
                                      aligned words may  be non-contiguous. When no alignment
                                      information is available, the alignment element will be empty.
                                      Required.
                                },
                                "sentLen": {
                                    "srcSentLen": [
                                        0  # An integer array representing
                                          the lengths of the sentences in the input text.  The length
                                          of the array is the number of sentences, and the values are
                                          the length of each sentence. Required.
                                    ],
                                    "transSentLen": [
                                        0  # An integer array representing
                                          the lengths of the sentences in the translated text.  The
                                          length of the array is the number of sentences, and the
                                          values are the length of each sentence. Required.
                                    ]
                                },
                                "transliteration": {
                                    "script": "str",  # A string specifying the
                                      script used in the output. Required.
                                    "text": "str"  # A string which is the result
                                      of converting the input string to the output script. Required.
                                }
                            }
                        ],
                        "detectedLanguage": {
                            "language": "str",  # A string representing the code of the
                              detected language. Required.
                            "score": 0.0  # A float value indicating the confidence in
                              the result. The score is between zero and one and a low score indicates a
                              low confidence. Required.
                        },
                        "sourceText": {
                            "text": "str"  # Input text in the default script of the
                              source language. Required.
                        }
                    }
                ]
        """

    @overload
    async def translate(
        self,
        body: IO[bytes],
        *,
        to_language: List[str],
        client_trace_id: Optional[str] = None,
        from_language: Optional[str] = None,
        text_type: Optional[Union[str, _models.TextType]] = None,
        category: Optional[str] = None,
        profanity_action: Optional[Union[str, _models.ProfanityAction]] = None,
        profanity_marker: Optional[Union[str, _models.ProfanityMarker]] = None,
        include_alignment: Optional[bool] = None,
        include_sentence_length: Optional[bool] = None,
        suggested_from: Optional[str] = None,
        from_script: Optional[str] = None,
        to_script: Optional[str] = None,
        allow_fallback: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.TranslatedTextItem]:
        # pylint: disable=line-too-long
        """Translate Text.

        Translate Text.

        :param body: Defines the content of the request. Required.
        :type body: IO[bytes]
        :keyword to_language: Specifies the language of the output text. The target language must be
         one of the supported languages included
         in the translation scope. For example, use to=de to translate to German.
         It's possible to translate to multiple languages simultaneously by repeating the parameter in
         the query string.
         For example, use to=de&to=it to translate to German and Italian. Required.
        :paramtype to_language: list[str]
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword from_language: Specifies the language of the input text. Find which languages are
         available to translate from by
         looking up supported languages using the translation scope. If the from parameter isn't
         specified,
         automatic language detection is applied to determine the source language.

         You must use the from parameter rather than autodetection when using the dynamic dictionary
         feature.
         Note: the dynamic dictionary feature is case-sensitive. Default value is None.
        :paramtype from_language: str
        :keyword text_type: Defines whether the text being translated is plain text or HTML text. Any
         HTML needs to be a well-formed,
         complete element. Possible values are: plain (default) or html. Known values are: "Plain" and
         "Html". Default value is None.
        :paramtype text_type: str or ~azure.ai.translation.text.models.TextType
        :keyword category: A string specifying the category (domain) of the translation. This parameter
         is used to get translations
         from a customized system built with Custom Translator. Add the Category ID from your Custom
         Translator
         project details to this parameter to use your deployed customized system. Default value is:
         general. Default value is None.
        :paramtype category: str
        :keyword profanity_action: Specifies how profanities should be treated in translations.
         Possible values are: NoAction (default), Marked or Deleted. Known values are: "NoAction",
         "Marked", and "Deleted". Default value is None.
        :paramtype profanity_action: str or ~azure.ai.translation.text.models.ProfanityAction
        :keyword profanity_marker: Specifies how profanities should be marked in translations.
         Possible values are: Asterisk (default) or Tag. Known values are: "Asterisk" and "Tag".
         Default value is None.
        :paramtype profanity_marker: str or ~azure.ai.translation.text.models.ProfanityMarker
        :keyword include_alignment: Specifies whether to include alignment projection from source text
         to translated text.
         Possible values are: true or false (default). Default value is None.
        :paramtype include_alignment: bool
        :keyword include_sentence_length: Specifies whether to include sentence boundaries for the
         input text and the translated text.
         Possible values are: true or false (default). Default value is None.
        :paramtype include_sentence_length: bool
        :keyword suggested_from: Specifies a fallback language if the language of the input text can't
         be identified.
         Language autodetection is applied when the from parameter is omitted. If detection fails,
         the suggestedFrom language will be assumed. Default value is None.
        :paramtype suggested_from: str
        :keyword from_script: Specifies the script of the input text. Default value is None.
        :paramtype from_script: str
        :keyword to_script: Specifies the script of the translated text. Default value is None.
        :paramtype to_script: str
        :keyword allow_fallback: Specifies that the service is allowed to fall back to a general system
         when a custom system doesn't exist.
         Possible values are: true (default) or false.

         allowFallback=false specifies that the translation should only use systems trained for the
         category specified
         by the request. If a translation for language X to language Y requires chaining through a
         pivot language E,
         then all the systems in the chain (X → E and E → Y) will need to be custom and have the same
         category.
         If no system is found with the specific category, the request will return a 400 status code.
         allowFallback=true
         specifies that the service is allowed to fall back to a general system when a custom system
         doesn't exist. Default value is None.
        :paramtype allow_fallback: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of TranslatedTextItem
        :rtype: list[~azure.ai.translation.text.models.TranslatedTextItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "translations": [
                            {
                                "text": "str",  # A string giving the translated
                                  text. Required.
                                "to": "str",  # A string representing the language
                                  code of the target language. Required.
                                "alignment": {
                                    "proj": "str"  # Maps input text to
                                      translated text. The alignment information is only provided when
                                      the request  parameter includeAlignment is true. Alignment is
                                      returned as a string value of the following  format:
                                      [[SourceTextStartIndex]:[SourceTextEndIndex]"u2013[TgtTextStartIndex]:[TgtTextEndIndex]].
                                      The colon separates start and end index, the dash separates the
                                      languages, and space separates the words.  One word may align
                                      with zero, one, or multiple words in the other language, and the
                                      aligned words may  be non-contiguous. When no alignment
                                      information is available, the alignment element will be empty.
                                      Required.
                                },
                                "sentLen": {
                                    "srcSentLen": [
                                        0  # An integer array representing
                                          the lengths of the sentences in the input text.  The length
                                          of the array is the number of sentences, and the values are
                                          the length of each sentence. Required.
                                    ],
                                    "transSentLen": [
                                        0  # An integer array representing
                                          the lengths of the sentences in the translated text.  The
                                          length of the array is the number of sentences, and the
                                          values are the length of each sentence. Required.
                                    ]
                                },
                                "transliteration": {
                                    "script": "str",  # A string specifying the
                                      script used in the output. Required.
                                    "text": "str"  # A string which is the result
                                      of converting the input string to the output script. Required.
                                }
                            }
                        ],
                        "detectedLanguage": {
                            "language": "str",  # A string representing the code of the
                              detected language. Required.
                            "score": 0.0  # A float value indicating the confidence in
                              the result. The score is between zero and one and a low score indicates a
                              low confidence. Required.
                        },
                        "sourceText": {
                            "text": "str"  # Input text in the default script of the
                              source language. Required.
                        }
                    }
                ]
        """

    @distributed_trace_async
    async def translate(
        self,
        body: Union[List[_models.InputTextItem], IO[bytes]],
        *,
        to_language: List[str],
        client_trace_id: Optional[str] = None,
        from_language: Optional[str] = None,
        text_type: Optional[Union[str, _models.TextType]] = None,
        category: Optional[str] = None,
        profanity_action: Optional[Union[str, _models.ProfanityAction]] = None,
        profanity_marker: Optional[Union[str, _models.ProfanityMarker]] = None,
        include_alignment: Optional[bool] = None,
        include_sentence_length: Optional[bool] = None,
        suggested_from: Optional[str] = None,
        from_script: Optional[str] = None,
        to_script: Optional[str] = None,
        allow_fallback: Optional[bool] = None,
        **kwargs: Any
    ) -> List[_models.TranslatedTextItem]:
        # pylint: disable=line-too-long
        """Translate Text.

        Translate Text.

        :param body: Defines the content of the request. Is either a [InputTextItem] type or a
         IO[bytes] type. Required.
        :type body: list[~azure.ai.translation.text.models.InputTextItem] or IO[bytes]
        :keyword to_language: Specifies the language of the output text. The target language must be
         one of the supported languages included
         in the translation scope. For example, use to=de to translate to German.
         It's possible to translate to multiple languages simultaneously by repeating the parameter in
         the query string.
         For example, use to=de&to=it to translate to German and Italian. Required.
        :paramtype to_language: list[str]
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword from_language: Specifies the language of the input text. Find which languages are
         available to translate from by
         looking up supported languages using the translation scope. If the from parameter isn't
         specified,
         automatic language detection is applied to determine the source language.

         You must use the from parameter rather than autodetection when using the dynamic dictionary
         feature.
         Note: the dynamic dictionary feature is case-sensitive. Default value is None.
        :paramtype from_language: str
        :keyword text_type: Defines whether the text being translated is plain text or HTML text. Any
         HTML needs to be a well-formed,
         complete element. Possible values are: plain (default) or html. Known values are: "Plain" and
         "Html". Default value is None.
        :paramtype text_type: str or ~azure.ai.translation.text.models.TextType
        :keyword category: A string specifying the category (domain) of the translation. This parameter
         is used to get translations
         from a customized system built with Custom Translator. Add the Category ID from your Custom
         Translator
         project details to this parameter to use your deployed customized system. Default value is:
         general. Default value is None.
        :paramtype category: str
        :keyword profanity_action: Specifies how profanities should be treated in translations.
         Possible values are: NoAction (default), Marked or Deleted. Known values are: "NoAction",
         "Marked", and "Deleted". Default value is None.
        :paramtype profanity_action: str or ~azure.ai.translation.text.models.ProfanityAction
        :keyword profanity_marker: Specifies how profanities should be marked in translations.
         Possible values are: Asterisk (default) or Tag. Known values are: "Asterisk" and "Tag".
         Default value is None.
        :paramtype profanity_marker: str or ~azure.ai.translation.text.models.ProfanityMarker
        :keyword include_alignment: Specifies whether to include alignment projection from source text
         to translated text.
         Possible values are: true or false (default). Default value is None.
        :paramtype include_alignment: bool
        :keyword include_sentence_length: Specifies whether to include sentence boundaries for the
         input text and the translated text.
         Possible values are: true or false (default). Default value is None.
        :paramtype include_sentence_length: bool
        :keyword suggested_from: Specifies a fallback language if the language of the input text can't
         be identified.
         Language autodetection is applied when the from parameter is omitted. If detection fails,
         the suggestedFrom language will be assumed. Default value is None.
        :paramtype suggested_from: str
        :keyword from_script: Specifies the script of the input text. Default value is None.
        :paramtype from_script: str
        :keyword to_script: Specifies the script of the translated text. Default value is None.
        :paramtype to_script: str
        :keyword allow_fallback: Specifies that the service is allowed to fall back to a general system
         when a custom system doesn't exist.
         Possible values are: true (default) or false.

         allowFallback=false specifies that the translation should only use systems trained for the
         category specified
         by the request. If a translation for language X to language Y requires chaining through a
         pivot language E,
         then all the systems in the chain (X → E and E → Y) will need to be custom and have the same
         category.
         If no system is found with the specific category, the request will return a 400 status code.
         allowFallback=true
         specifies that the service is allowed to fall back to a general system when a custom system
         doesn't exist. Default value is None.
        :paramtype allow_fallback: bool
        :return: list of TranslatedTextItem
        :rtype: list[~azure.ai.translation.text.models.TranslatedTextItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "translations": [
                            {
                                "text": "str",  # A string giving the translated
                                  text. Required.
                                "to": "str",  # A string representing the language
                                  code of the target language. Required.
                                "alignment": {
                                    "proj": "str"  # Maps input text to
                                      translated text. The alignment information is only provided when
                                      the request  parameter includeAlignment is true. Alignment is
                                      returned as a string value of the following  format:
                                      [[SourceTextStartIndex]:[SourceTextEndIndex]"u2013[TgtTextStartIndex]:[TgtTextEndIndex]].
                                      The colon separates start and end index, the dash separates the
                                      languages, and space separates the words.  One word may align
                                      with zero, one, or multiple words in the other language, and the
                                      aligned words may  be non-contiguous. When no alignment
                                      information is available, the alignment element will be empty.
                                      Required.
                                },
                                "sentLen": {
                                    "srcSentLen": [
                                        0  # An integer array representing
                                          the lengths of the sentences in the input text.  The length
                                          of the array is the number of sentences, and the values are
                                          the length of each sentence. Required.
                                    ],
                                    "transSentLen": [
                                        0  # An integer array representing
                                          the lengths of the sentences in the translated text.  The
                                          length of the array is the number of sentences, and the
                                          values are the length of each sentence. Required.
                                    ]
                                },
                                "transliteration": {
                                    "script": "str",  # A string specifying the
                                      script used in the output. Required.
                                    "text": "str"  # A string which is the result
                                      of converting the input string to the output script. Required.
                                }
                            }
                        ],
                        "detectedLanguage": {
                            "language": "str",  # A string representing the code of the
                              detected language. Required.
                            "score": 0.0  # A float value indicating the confidence in
                              the result. The score is between zero and one and a low score indicates a
                              low confidence. Required.
                        },
                        "sourceText": {
                            "text": "str"  # Input text in the default script of the
                              source language. Required.
                        }
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.TranslatedTextItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_text_translation_translate_request(
            to_language=to_language,
            client_trace_id=client_trace_id,
            from_language=from_language,
            text_type=text_type,
            category=category,
            profanity_action=profanity_action,
            profanity_marker=profanity_marker,
            include_alignment=include_alignment,
            include_sentence_length=include_sentence_length,
            suggested_from=suggested_from,
            from_script=from_script,
            to_script=to_script,
            allow_fallback=allow_fallback,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))
        response_headers["x-mt-system"] = self._deserialize("str", response.headers.get("x-mt-system"))
        response_headers["x-metered-usage"] = self._deserialize("int", response.headers.get("x-metered-usage"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.TranslatedTextItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def transliterate(
        self,
        body: List[_models.InputTextItem],
        *,
        language: str,
        from_script: str,
        to_script: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.TransliteratedText]:
        """Transliterate Text.

        Transliterate Text.

        :param body: Defines the content of the request. Required.
        :type body: list[~azure.ai.translation.text.models.InputTextItem]
        :keyword language: Specifies the language of the text to convert from one script to another.
         Possible languages are listed in the transliteration scope obtained by querying the service
         for its supported languages. Required.
        :paramtype language: str
        :keyword from_script: Specifies the script used by the input text. Look up supported languages
         using the transliteration scope,
         to find input scripts available for the selected language. Required.
        :paramtype from_script: str
        :keyword to_script: Specifies the output script. Look up supported languages using the
         transliteration scope, to find output
         scripts available for the selected combination of input language and input script. Required.
        :paramtype to_script: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of TransliteratedText
        :rtype: list[~azure.ai.translation.text.models.TransliteratedText]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    {
                        "text": "str"  # Text to translate. Required.
                    }
                ]

                # response body for status code(s): 200
                response == [
                    {
                        "script": "str",  # A string specifying the script used in the
                          output. Required.
                        "text": "str"  # A string which is the result of converting the input
                          string to the output script. Required.
                    }
                ]
        """

    @overload
    async def transliterate(
        self,
        body: IO[bytes],
        *,
        language: str,
        from_script: str,
        to_script: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.TransliteratedText]:
        """Transliterate Text.

        Transliterate Text.

        :param body: Defines the content of the request. Required.
        :type body: IO[bytes]
        :keyword language: Specifies the language of the text to convert from one script to another.
         Possible languages are listed in the transliteration scope obtained by querying the service
         for its supported languages. Required.
        :paramtype language: str
        :keyword from_script: Specifies the script used by the input text. Look up supported languages
         using the transliteration scope,
         to find input scripts available for the selected language. Required.
        :paramtype from_script: str
        :keyword to_script: Specifies the output script. Look up supported languages using the
         transliteration scope, to find output
         scripts available for the selected combination of input language and input script. Required.
        :paramtype to_script: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of TransliteratedText
        :rtype: list[~azure.ai.translation.text.models.TransliteratedText]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "script": "str",  # A string specifying the script used in the
                          output. Required.
                        "text": "str"  # A string which is the result of converting the input
                          string to the output script. Required.
                    }
                ]
        """

    @distributed_trace_async
    async def transliterate(
        self,
        body: Union[List[_models.InputTextItem], IO[bytes]],
        *,
        language: str,
        from_script: str,
        to_script: str,
        client_trace_id: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.TransliteratedText]:
        """Transliterate Text.

        Transliterate Text.

        :param body: Defines the content of the request. Is either a [InputTextItem] type or a
         IO[bytes] type. Required.
        :type body: list[~azure.ai.translation.text.models.InputTextItem] or IO[bytes]
        :keyword language: Specifies the language of the text to convert from one script to another.
         Possible languages are listed in the transliteration scope obtained by querying the service
         for its supported languages. Required.
        :paramtype language: str
        :keyword from_script: Specifies the script used by the input text. Look up supported languages
         using the transliteration scope,
         to find input scripts available for the selected language. Required.
        :paramtype from_script: str
        :keyword to_script: Specifies the output script. Look up supported languages using the
         transliteration scope, to find output
         scripts available for the selected combination of input language and input script. Required.
        :paramtype to_script: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :return: list of TransliteratedText
        :rtype: list[~azure.ai.translation.text.models.TransliteratedText]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "script": "str",  # A string specifying the script used in the
                          output. Required.
                        "text": "str"  # A string which is the result of converting the input
                          string to the output script. Required.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.TransliteratedText]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_text_translation_transliterate_request(
            language=language,
            from_script=from_script,
            to_script=to_script,
            client_trace_id=client_trace_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.TransliteratedText], response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def find_sentence_boundaries(
        self,
        body: List[_models.InputTextItem],
        *,
        client_trace_id: Optional[str] = None,
        language: Optional[str] = None,
        script: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.BreakSentenceItem]:
        # pylint: disable=line-too-long
        """Find Sentence Boundaries.

        Find Sentence Boundaries.

        :param body: Defines the content of the request. Required.
        :type body: list[~azure.ai.translation.text.models.InputTextItem]
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword language: Language tag identifying the language of the input text.
         If a code isn't specified, automatic language detection will be applied. Default value is
         None.
        :paramtype language: str
        :keyword script: Script tag identifying the script used by the input text.
         If a script isn't specified, the default script of the language will be assumed. Default value
         is None.
        :paramtype script: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of BreakSentenceItem
        :rtype: list[~azure.ai.translation.text.models.BreakSentenceItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    {
                        "text": "str"  # Text to translate. Required.
                    }
                ]

                # response body for status code(s): 200
                response == [
                    {
                        "sentLen": [
                            0  # An integer array representing the lengths of the
                              sentences in the input text. The length of the array is the number of
                              sentences, and the values are the length of each sentence. Required.
                        ],
                        "detectedLanguage": {
                            "language": "str",  # A string representing the code of the
                              detected language. Required.
                            "score": 0.0  # A float value indicating the confidence in
                              the result. The score is between zero and one and a low score indicates a
                              low confidence. Required.
                        }
                    }
                ]
        """

    @overload
    async def find_sentence_boundaries(
        self,
        body: IO[bytes],
        *,
        client_trace_id: Optional[str] = None,
        language: Optional[str] = None,
        script: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.BreakSentenceItem]:
        # pylint: disable=line-too-long
        """Find Sentence Boundaries.

        Find Sentence Boundaries.

        :param body: Defines the content of the request. Required.
        :type body: IO[bytes]
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword language: Language tag identifying the language of the input text.
         If a code isn't specified, automatic language detection will be applied. Default value is
         None.
        :paramtype language: str
        :keyword script: Script tag identifying the script used by the input text.
         If a script isn't specified, the default script of the language will be assumed. Default value
         is None.
        :paramtype script: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of BreakSentenceItem
        :rtype: list[~azure.ai.translation.text.models.BreakSentenceItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "sentLen": [
                            0  # An integer array representing the lengths of the
                              sentences in the input text. The length of the array is the number of
                              sentences, and the values are the length of each sentence. Required.
                        ],
                        "detectedLanguage": {
                            "language": "str",  # A string representing the code of the
                              detected language. Required.
                            "score": 0.0  # A float value indicating the confidence in
                              the result. The score is between zero and one and a low score indicates a
                              low confidence. Required.
                        }
                    }
                ]
        """

    @distributed_trace_async
    async def find_sentence_boundaries(
        self,
        body: Union[List[_models.InputTextItem], IO[bytes]],
        *,
        client_trace_id: Optional[str] = None,
        language: Optional[str] = None,
        script: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.BreakSentenceItem]:
        # pylint: disable=line-too-long
        """Find Sentence Boundaries.

        Find Sentence Boundaries.

        :param body: Defines the content of the request. Is either a [InputTextItem] type or a
         IO[bytes] type. Required.
        :type body: list[~azure.ai.translation.text.models.InputTextItem] or IO[bytes]
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword language: Language tag identifying the language of the input text.
         If a code isn't specified, automatic language detection will be applied. Default value is
         None.
        :paramtype language: str
        :keyword script: Script tag identifying the script used by the input text.
         If a script isn't specified, the default script of the language will be assumed. Default value
         is None.
        :paramtype script: str
        :return: list of BreakSentenceItem
        :rtype: list[~azure.ai.translation.text.models.BreakSentenceItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "sentLen": [
                            0  # An integer array representing the lengths of the
                              sentences in the input text. The length of the array is the number of
                              sentences, and the values are the length of each sentence. Required.
                        ],
                        "detectedLanguage": {
                            "language": "str",  # A string representing the code of the
                              detected language. Required.
                            "score": 0.0  # A float value indicating the confidence in
                              the result. The score is between zero and one and a low score indicates a
                              low confidence. Required.
                        }
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.BreakSentenceItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_text_translation_find_sentence_boundaries_request(
            client_trace_id=client_trace_id,
            language=language,
            script=script,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.BreakSentenceItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def lookup_dictionary_entries(
        self,
        body: List[_models.InputTextItem],
        *,
        from_language: str,
        to_language: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.DictionaryLookupItem]:
        # pylint: disable=line-too-long
        """Lookup Dictionary Entries.

        Lookup Dictionary Entries.

        :param body: Defines the content of the request. Required.
        :type body: list[~azure.ai.translation.text.models.InputTextItem]
        :keyword from_language: Specifies the language of the input text.
         The source language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype from_language: str
        :keyword to_language: Specifies the language of the output text.
         The target language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype to_language: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of DictionaryLookupItem
        :rtype: list[~azure.ai.translation.text.models.DictionaryLookupItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    {
                        "text": "str"  # Text to translate. Required.
                    }
                ]

                # response body for status code(s): 200
                response == [
                    {
                        "displaySource": "str",  # A string giving the source term in a form
                          best suited for end-user display. For example, if the input is "JOHN", the
                          display form will reflect the usual spelling of the name: "John". Required.
                        "normalizedSource": "str",  # A string giving the normalized form of
                          the source term. For example, if the request is "JOHN", the normalized form
                          will be "john". The content of this field becomes the input to lookup
                          examples. Required.
                        "translations": [
                            {
                                "backTranslations": [
                                    {
                                        "displayText": "str",  # A string
                                          giving the source term that is a back-translation of the
                                          target in a form best suited for end-user display. Required.
                                        "frequencyCount": 0,  # An integer
                                          representing the frequency of this translation pair in the
                                          data. The main purpose of this field is to provide a user
                                          interface with a means to sort back-translations so the most
                                          frequent terms are first. Required.
                                        "normalizedText": "str",  # A string
                                          giving the normalized form of the source term that is a
                                          back-translation of the target. This value should be used as
                                          input to lookup examples. Required.
                                        "numExamples": 0  # An integer
                                          representing the number of examples that are available for
                                          this translation pair. Actual examples must be retrieved with
                                          a separate call to lookup examples. The number is mostly
                                          intended to facilitate display in a UX. For example, a user
                                          interface may add a hyperlink to the back-translation if the
                                          number of examples is greater than zero and show the
                                          back-translation as plain text if there are no examples. Note
                                          that the actual number of examples returned by a call to
                                          lookup examples may be less than numExamples, because
                                          additional filtering may be applied on the fly to remove
                                          "bad" examples. Required.
                                    }
                                ],
                                "confidence": 0.0,  # A value between 0.0 and 1.0
                                  which represents the "confidence"  (or perhaps more accurately,
                                  "probability in the training data") of that translation pair.  The
                                  sum of confidence scores for one source word may or may not sum to
                                  1.0. Required.
                                "displayTarget": "str",  # A string giving the term
                                  in the target language and in a form best suited for end-user
                                  display. Generally, this will only differ from the normalizedTarget
                                  in terms of capitalization. For example, a proper noun like "Juan"
                                  will have normalizedTarget = "juan" and displayTarget = "Juan".
                                  Required.
                                "normalizedTarget": "str",  # A string giving the
                                  normalized form of this term in the target language. This value
                                  should be used as input to lookup examples. Required.
                                "posTag": "str",  # A string associating this term
                                  with a part-of-speech tag. Required.
                                "prefixWord": "str"  # A string giving the word to
                                  display as a prefix of the translation. Currently, this is the
                                  gendered determiner of nouns, in languages that have gendered
                                  determiners. For example, the prefix of the Spanish word "mosca" is
                                  "la", since "mosca" is a feminine noun in Spanish.  This is only
                                  dependent on the translation, and not on the source.  If there is no
                                  prefix, it will be the empty string. Required.
                            }
                        ]
                    }
                ]
        """

    @overload
    async def lookup_dictionary_entries(
        self,
        body: IO[bytes],
        *,
        from_language: str,
        to_language: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.DictionaryLookupItem]:
        # pylint: disable=line-too-long
        """Lookup Dictionary Entries.

        Lookup Dictionary Entries.

        :param body: Defines the content of the request. Required.
        :type body: IO[bytes]
        :keyword from_language: Specifies the language of the input text.
         The source language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype from_language: str
        :keyword to_language: Specifies the language of the output text.
         The target language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype to_language: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of DictionaryLookupItem
        :rtype: list[~azure.ai.translation.text.models.DictionaryLookupItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "displaySource": "str",  # A string giving the source term in a form
                          best suited for end-user display. For example, if the input is "JOHN", the
                          display form will reflect the usual spelling of the name: "John". Required.
                        "normalizedSource": "str",  # A string giving the normalized form of
                          the source term. For example, if the request is "JOHN", the normalized form
                          will be "john". The content of this field becomes the input to lookup
                          examples. Required.
                        "translations": [
                            {
                                "backTranslations": [
                                    {
                                        "displayText": "str",  # A string
                                          giving the source term that is a back-translation of the
                                          target in a form best suited for end-user display. Required.
                                        "frequencyCount": 0,  # An integer
                                          representing the frequency of this translation pair in the
                                          data. The main purpose of this field is to provide a user
                                          interface with a means to sort back-translations so the most
                                          frequent terms are first. Required.
                                        "normalizedText": "str",  # A string
                                          giving the normalized form of the source term that is a
                                          back-translation of the target. This value should be used as
                                          input to lookup examples. Required.
                                        "numExamples": 0  # An integer
                                          representing the number of examples that are available for
                                          this translation pair. Actual examples must be retrieved with
                                          a separate call to lookup examples. The number is mostly
                                          intended to facilitate display in a UX. For example, a user
                                          interface may add a hyperlink to the back-translation if the
                                          number of examples is greater than zero and show the
                                          back-translation as plain text if there are no examples. Note
                                          that the actual number of examples returned by a call to
                                          lookup examples may be less than numExamples, because
                                          additional filtering may be applied on the fly to remove
                                          "bad" examples. Required.
                                    }
                                ],
                                "confidence": 0.0,  # A value between 0.0 and 1.0
                                  which represents the "confidence"  (or perhaps more accurately,
                                  "probability in the training data") of that translation pair.  The
                                  sum of confidence scores for one source word may or may not sum to
                                  1.0. Required.
                                "displayTarget": "str",  # A string giving the term
                                  in the target language and in a form best suited for end-user
                                  display. Generally, this will only differ from the normalizedTarget
                                  in terms of capitalization. For example, a proper noun like "Juan"
                                  will have normalizedTarget = "juan" and displayTarget = "Juan".
                                  Required.
                                "normalizedTarget": "str",  # A string giving the
                                  normalized form of this term in the target language. This value
                                  should be used as input to lookup examples. Required.
                                "posTag": "str",  # A string associating this term
                                  with a part-of-speech tag. Required.
                                "prefixWord": "str"  # A string giving the word to
                                  display as a prefix of the translation. Currently, this is the
                                  gendered determiner of nouns, in languages that have gendered
                                  determiners. For example, the prefix of the Spanish word "mosca" is
                                  "la", since "mosca" is a feminine noun in Spanish.  This is only
                                  dependent on the translation, and not on the source.  If there is no
                                  prefix, it will be the empty string. Required.
                            }
                        ]
                    }
                ]
        """

    @distributed_trace_async
    async def lookup_dictionary_entries(
        self,
        body: Union[List[_models.InputTextItem], IO[bytes]],
        *,
        from_language: str,
        to_language: str,
        client_trace_id: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.DictionaryLookupItem]:
        # pylint: disable=line-too-long
        """Lookup Dictionary Entries.

        Lookup Dictionary Entries.

        :param body: Defines the content of the request. Is either a [InputTextItem] type or a
         IO[bytes] type. Required.
        :type body: list[~azure.ai.translation.text.models.InputTextItem] or IO[bytes]
        :keyword from_language: Specifies the language of the input text.
         The source language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype from_language: str
        :keyword to_language: Specifies the language of the output text.
         The target language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype to_language: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :return: list of DictionaryLookupItem
        :rtype: list[~azure.ai.translation.text.models.DictionaryLookupItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "displaySource": "str",  # A string giving the source term in a form
                          best suited for end-user display. For example, if the input is "JOHN", the
                          display form will reflect the usual spelling of the name: "John". Required.
                        "normalizedSource": "str",  # A string giving the normalized form of
                          the source term. For example, if the request is "JOHN", the normalized form
                          will be "john". The content of this field becomes the input to lookup
                          examples. Required.
                        "translations": [
                            {
                                "backTranslations": [
                                    {
                                        "displayText": "str",  # A string
                                          giving the source term that is a back-translation of the
                                          target in a form best suited for end-user display. Required.
                                        "frequencyCount": 0,  # An integer
                                          representing the frequency of this translation pair in the
                                          data. The main purpose of this field is to provide a user
                                          interface with a means to sort back-translations so the most
                                          frequent terms are first. Required.
                                        "normalizedText": "str",  # A string
                                          giving the normalized form of the source term that is a
                                          back-translation of the target. This value should be used as
                                          input to lookup examples. Required.
                                        "numExamples": 0  # An integer
                                          representing the number of examples that are available for
                                          this translation pair. Actual examples must be retrieved with
                                          a separate call to lookup examples. The number is mostly
                                          intended to facilitate display in a UX. For example, a user
                                          interface may add a hyperlink to the back-translation if the
                                          number of examples is greater than zero and show the
                                          back-translation as plain text if there are no examples. Note
                                          that the actual number of examples returned by a call to
                                          lookup examples may be less than numExamples, because
                                          additional filtering may be applied on the fly to remove
                                          "bad" examples. Required.
                                    }
                                ],
                                "confidence": 0.0,  # A value between 0.0 and 1.0
                                  which represents the "confidence"  (or perhaps more accurately,
                                  "probability in the training data") of that translation pair.  The
                                  sum of confidence scores for one source word may or may not sum to
                                  1.0. Required.
                                "displayTarget": "str",  # A string giving the term
                                  in the target language and in a form best suited for end-user
                                  display. Generally, this will only differ from the normalizedTarget
                                  in terms of capitalization. For example, a proper noun like "Juan"
                                  will have normalizedTarget = "juan" and displayTarget = "Juan".
                                  Required.
                                "normalizedTarget": "str",  # A string giving the
                                  normalized form of this term in the target language. This value
                                  should be used as input to lookup examples. Required.
                                "posTag": "str",  # A string associating this term
                                  with a part-of-speech tag. Required.
                                "prefixWord": "str"  # A string giving the word to
                                  display as a prefix of the translation. Currently, this is the
                                  gendered determiner of nouns, in languages that have gendered
                                  determiners. For example, the prefix of the Spanish word "mosca" is
                                  "la", since "mosca" is a feminine noun in Spanish.  This is only
                                  dependent on the translation, and not on the source.  If there is no
                                  prefix, it will be the empty string. Required.
                            }
                        ]
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.DictionaryLookupItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_text_translation_lookup_dictionary_entries_request(
            from_language=from_language,
            to_language=to_language,
            client_trace_id=client_trace_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.DictionaryLookupItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def lookup_dictionary_examples(
        self,
        body: List[_models.DictionaryExampleTextItem],
        *,
        from_language: str,
        to_language: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.DictionaryExampleItem]:
        # pylint: disable=line-too-long
        """Lookup Dictionary Examples.

        Lookup Dictionary Examples.

        :param body: Defines the content of the request. Required.
        :type body: list[~azure.ai.translation.text.models.DictionaryExampleTextItem]
        :keyword from_language: Specifies the language of the input text.
         The source language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype from_language: str
        :keyword to_language: Specifies the language of the output text.
         The target language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype to_language: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of DictionaryExampleItem
        :rtype: list[~azure.ai.translation.text.models.DictionaryExampleItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    {
                        "text": "str",  # Text to translate. Required.
                        "translation": "str"  # A string specifying the translated text
                          previously returned by the Dictionary lookup operation.  This should be the
                          value from the normalizedTarget field in the translations list of the
                          Dictionary  lookup response. The service will return examples for the
                          specific source-target word-pair. Required.
                    }
                ]

                # response body for status code(s): 200
                response == [
                    {
                        "examples": [
                            {
                                "sourcePrefix": "str",  # The string to concatenate
                                  before the value of sourceTerm to form a complete example. Do not add
                                  a space character, since it is already there when it should be. This
                                  value may be an empty string. Required.
                                "sourceSuffix": "str",  # The string to concatenate
                                  after the value of sourceTerm to form a complete example. Do not add
                                  a space character, since it is already there when it should be. This
                                  value may be an empty string. Required.
                                "sourceTerm": "str",  # A string equal to the actual
                                  term looked up. The string is added with sourcePrefix and
                                  sourceSuffix to form the complete example. Its value is separated so
                                  it can be marked in a user interface, e.g., by bolding it. Required.
                                "targetPrefix": "str",  # A string similar to
                                  sourcePrefix but for the target. Required.
                                "targetSuffix": "str",  # A string similar to
                                  sourceSuffix but for the target. Required.
                                "targetTerm": "str"  # A string similar to sourceTerm
                                  but for the target. Required.
                            }
                        ],
                        "normalizedSource": "str",  # A string giving the normalized form of
                          the source term. Generally, this should be identical to the value of the Text
                          field at the matching list index in the body of the request. Required.
                        "normalizedTarget": "str"  # A string giving the normalized form of
                          the target term. Generally, this should be identical to the value of the
                          Translation field at the matching list index in the body of the request.
                          Required.
                    }
                ]
        """

    @overload
    async def lookup_dictionary_examples(
        self,
        body: IO[bytes],
        *,
        from_language: str,
        to_language: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.DictionaryExampleItem]:
        # pylint: disable=line-too-long
        """Lookup Dictionary Examples.

        Lookup Dictionary Examples.

        :param body: Defines the content of the request. Required.
        :type body: IO[bytes]
        :keyword from_language: Specifies the language of the input text.
         The source language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype from_language: str
        :keyword to_language: Specifies the language of the output text.
         The target language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype to_language: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of DictionaryExampleItem
        :rtype: list[~azure.ai.translation.text.models.DictionaryExampleItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "examples": [
                            {
                                "sourcePrefix": "str",  # The string to concatenate
                                  before the value of sourceTerm to form a complete example. Do not add
                                  a space character, since it is already there when it should be. This
                                  value may be an empty string. Required.
                                "sourceSuffix": "str",  # The string to concatenate
                                  after the value of sourceTerm to form a complete example. Do not add
                                  a space character, since it is already there when it should be. This
                                  value may be an empty string. Required.
                                "sourceTerm": "str",  # A string equal to the actual
                                  term looked up. The string is added with sourcePrefix and
                                  sourceSuffix to form the complete example. Its value is separated so
                                  it can be marked in a user interface, e.g., by bolding it. Required.
                                "targetPrefix": "str",  # A string similar to
                                  sourcePrefix but for the target. Required.
                                "targetSuffix": "str",  # A string similar to
                                  sourceSuffix but for the target. Required.
                                "targetTerm": "str"  # A string similar to sourceTerm
                                  but for the target. Required.
                            }
                        ],
                        "normalizedSource": "str",  # A string giving the normalized form of
                          the source term. Generally, this should be identical to the value of the Text
                          field at the matching list index in the body of the request. Required.
                        "normalizedTarget": "str"  # A string giving the normalized form of
                          the target term. Generally, this should be identical to the value of the
                          Translation field at the matching list index in the body of the request.
                          Required.
                    }
                ]
        """

    @distributed_trace_async
    async def lookup_dictionary_examples(
        self,
        body: Union[List[_models.DictionaryExampleTextItem], IO[bytes]],
        *,
        from_language: str,
        to_language: str,
        client_trace_id: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.DictionaryExampleItem]:
        # pylint: disable=line-too-long
        """Lookup Dictionary Examples.

        Lookup Dictionary Examples.

        :param body: Defines the content of the request. Is either a [DictionaryExampleTextItem] type
         or a IO[bytes] type. Required.
        :type body: list[~azure.ai.translation.text.models.DictionaryExampleTextItem] or IO[bytes]
        :keyword from_language: Specifies the language of the input text.
         The source language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype from_language: str
        :keyword to_language: Specifies the language of the output text.
         The target language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype to_language: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :return: list of DictionaryExampleItem
        :rtype: list[~azure.ai.translation.text.models.DictionaryExampleItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "examples": [
                            {
                                "sourcePrefix": "str",  # The string to concatenate
                                  before the value of sourceTerm to form a complete example. Do not add
                                  a space character, since it is already there when it should be. This
                                  value may be an empty string. Required.
                                "sourceSuffix": "str",  # The string to concatenate
                                  after the value of sourceTerm to form a complete example. Do not add
                                  a space character, since it is already there when it should be. This
                                  value may be an empty string. Required.
                                "sourceTerm": "str",  # A string equal to the actual
                                  term looked up. The string is added with sourcePrefix and
                                  sourceSuffix to form the complete example. Its value is separated so
                                  it can be marked in a user interface, e.g., by bolding it. Required.
                                "targetPrefix": "str",  # A string similar to
                                  sourcePrefix but for the target. Required.
                                "targetSuffix": "str",  # A string similar to
                                  sourceSuffix but for the target. Required.
                                "targetTerm": "str"  # A string similar to sourceTerm
                                  but for the target. Required.
                            }
                        ],
                        "normalizedSource": "str",  # A string giving the normalized form of
                          the source term. Generally, this should be identical to the value of the Text
                          field at the matching list index in the body of the request. Required.
                        "normalizedTarget": "str"  # A string giving the normalized form of
                          the target term. Generally, this should be identical to the value of the
                          Translation field at the matching list index in the body of the request.
                          Required.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.DictionaryExampleItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_text_translation_lookup_dictionary_examples_request(
            from_language=from_language,
            to_language=to_language,
            client_trace_id=client_trace_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.DictionaryExampleItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore
