# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_discriminator, rest_field
from ._enums import (
    CommunicationMessageKind,
    CommunicationMessagesChannel,
    MessageActionBindingKind,
    MessageContentKind,
    MessageTemplateBindingsKind,
    MessageTemplateValueKind,
)

if TYPE_CHECKING:
    from .. import models as _models


class ActionBindings(_model_base.Model):
    """Binding actions to the interactive message.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    WhatsAppButtonActionBindings, WhatsAppListActionBindings, WhatsAppUrlActionBindings

    All required parameters must be populated in order to send to server.

    :ivar kind: Kind of the MessageActionBinding. Required. Known values are: "whatsAppListAction",
     "whatsAppButtonAction", and "whatsAppUrlAction".
    :vartype kind: str or ~azure.communication.messages.models.MessageActionBindingKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind")
    """Kind of the MessageActionBinding. Required. Known values are: \"whatsAppListAction\",
     \"whatsAppButtonAction\", and \"whatsAppUrlAction\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ActionGroup(_model_base.Model):
    """The Action Group content.

    All required parameters must be populated in order to send to server.

    :ivar title: Title of the ActionGroup. Required.
    :vartype title: str
    :ivar items_property: Array of items in ActionGroup. Required.
    :vartype items_property: list[~azure.communication.messages.models.ActionGroupItem]
    """

    title: str = rest_field()
    """Title of the ActionGroup. Required."""
    items_property: List["_models.ActionGroupItem"] = rest_field(name="items")
    """Array of items in ActionGroup. Required."""

    @overload
    def __init__(
        self,
        *,
        title: str,
        items_property: List["_models.ActionGroupItem"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MessageContent(_model_base.Model):
    """The message content object used to create interactive messages components.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ButtonSetContent, DocumentMessageContent, ActionGroupContent, ImageMessageContent,
    TextMessageContent, LinkContent, VideoMessageContent

    All required parameters must be populated in order to send to server.

    :ivar kind: Kind of MessageContent. Required. Known values are: "text", "image", "video",
     "document", "group", "buttonSet", and "url".
    :vartype kind: str or ~azure.communication.messages.models.MessageContentKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind")
    """Kind of MessageContent. Required. Known values are: \"text\", \"image\", \"video\",
     \"document\", \"group\", \"buttonSet\", and \"url\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ActionGroupContent(MessageContent, discriminator="group"):
    """The action content of type ActionGroup.

    All required parameters must be populated in order to send to server.

    :ivar kind: Message content kind is actionGroup. Required. The ActionSet content type.
    :vartype kind: str or ~azure.communication.messages.models.GROUP
    :ivar title: Title of the actionGroup content. Required.
    :vartype title: str
    :ivar groups: Set or group of actions. Required.
    :vartype groups: list[~azure.communication.messages.models.ActionGroup]
    """

    kind: Literal[MessageContentKind.GROUP] = rest_discriminator(name="kind")  # type: ignore
    """Message content kind is actionGroup. Required. The ActionSet content type."""
    title: str = rest_field()
    """Title of the actionGroup content. Required."""
    groups: List["_models.ActionGroup"] = rest_field()
    """Set or group of actions. Required."""

    @overload
    def __init__(
        self,
        *,
        title: str,
        groups: List["_models.ActionGroup"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageContentKind.GROUP, **kwargs)


class ActionGroupItem(_model_base.Model):
    """The Action group item in the content.

    All required parameters must be populated in order to send to server.

    :ivar id: Id of the Item. Required.
    :vartype id: str
    :ivar title: Title of the Item. Required.
    :vartype title: str
    :ivar description: Description of the Item. Required.
    :vartype description: str
    """

    id: str = rest_field()
    """Id of the Item. Required."""
    title: str = rest_field()
    """Title of the Item. Required."""
    description: str = rest_field()
    """Description of the Item. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        title: str,
        description: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NotificationContent(_model_base.Model):
    """Details of the message to send.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AudioNotificationContent, DocumentNotificationContent, ImageNotificationContent,
    MediaNotificationContent, InteractiveNotificationContent, ReactionNotificationContent,
    StickerNotificationContent, TemplateNotificationContent, TextNotificationContent,
    VideoNotificationContent

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: The type discriminator describing a notification type. Required. Known values are:
     "text", "image", "image_v0", "document", "video", "audio", "template", "sticker", "reaction",
     and "interactive".
    :vartype kind: str or ~azure.communication.messages.models.CommunicationMessageKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    channel_registration_id: str = rest_field(name="channelRegistrationId")
    """The Channel Registration ID for the Business Identifier. Required."""
    to: List[str] = rest_field()
    """The native external platform user identifiers of the recipient. Required."""
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a notification type. Required. Known values are: \"text\",
     \"image\", \"image_v0\", \"document\", \"video\", \"audio\", \"template\", \"sticker\",
     \"reaction\", and \"interactive\"."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AudioNotificationContent(NotificationContent, discriminator="audio"):
    """A request to send an audio notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is audio. Required. Audio message type.
    :vartype kind: str or ~azure.communication.messages.models.AUDIO
    :ivar media_uri: A media url for the file. Required if the type is one of the supported media
     types, e.g. image. Required.
    :vartype media_uri: str
    """

    kind: Literal[CommunicationMessageKind.AUDIO] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is audio. Required. Audio message type."""
    media_uri: str = rest_field(name="mediaUri")
    """A media url for the file. Required if the type is one of the supported media types, e.g. image.
     Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        media_uri: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=CommunicationMessageKind.AUDIO, **kwargs)


class ButtonContent(_model_base.Model):
    """The message content of type Button information.

    All required parameters must be populated in order to send to server.

    :ivar id: Unique Id of the button content. Required.
    :vartype id: str
    :ivar title: Title of the button content. Required.
    :vartype title: str
    """

    id: str = rest_field()
    """Unique Id of the button content. Required."""
    title: str = rest_field()
    """Title of the button content. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        title: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ButtonSetContent(MessageContent, discriminator="buttonSet"):
    """The message content of type ButtonSet/ List of buttons information.

    All required parameters must be populated in order to send to server.

    :ivar kind: Message content kind is Button. Required. The ButtonSet content type.
    :vartype kind: str or ~azure.communication.messages.models.BUTTON_SET
    :ivar buttons: Unique Id of the button content. Required.
    :vartype buttons: list[~azure.communication.messages.models.ButtonContent]
    """

    kind: Literal[MessageContentKind.BUTTON_SET] = rest_discriminator(name="kind")  # type: ignore
    """Message content kind is Button. Required. The ButtonSet content type."""
    buttons: List["_models.ButtonContent"] = rest_field()
    """Unique Id of the button content. Required."""

    @overload
    def __init__(
        self,
        *,
        buttons: List["_models.ButtonContent"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageContentKind.BUTTON_SET, **kwargs)


class DocumentMessageContent(MessageContent, discriminator="document"):
    """The message content of type document information.

    All required parameters must be populated in order to send to server.

    :ivar kind: Message content kind is document. Required. The document content type.
    :vartype kind: str or ~azure.communication.messages.models.DOCUMENT
    :ivar media_uri: MediaUri of the media content. Required.
    :vartype media_uri: str
    """

    kind: Literal[MessageContentKind.DOCUMENT] = rest_discriminator(name="kind")  # type: ignore
    """Message content kind is document. Required. The document content type."""
    media_uri: str = rest_field(name="mediaUri")
    """MediaUri of the media content. Required."""

    @overload
    def __init__(
        self,
        *,
        media_uri: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageContentKind.DOCUMENT, **kwargs)


class DocumentNotificationContent(NotificationContent, discriminator="document"):
    """A request to send a document notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is image. Required. Document message type.
    :vartype kind: str or ~azure.communication.messages.models.DOCUMENT
    :ivar caption: Optional text content.
    :vartype caption: str
    :ivar file_name: Optional name for the file.
    :vartype file_name: str
    :ivar media_uri: A media url for the file. Required if the type is one of the supported media
     types, e.g. image. Required.
    :vartype media_uri: str
    """

    kind: Literal[CommunicationMessageKind.DOCUMENT] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is image. Required. Document message type."""
    caption: Optional[str] = rest_field()
    """Optional text content."""
    file_name: Optional[str] = rest_field(name="fileName")
    """Optional name for the file."""
    media_uri: str = rest_field(name="mediaUri")
    """A media url for the file. Required if the type is one of the supported media types, e.g. image.
     Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        media_uri: str,
        caption: Optional[str] = None,
        file_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=CommunicationMessageKind.DOCUMENT, **kwargs)


class ImageMessageContent(MessageContent, discriminator="image"):
    """The message content of type image information.

    All required parameters must be populated in order to send to server.

    :ivar kind: Message content kind is image. Required. The image content type.
    :vartype kind: str or ~azure.communication.messages.models.IMAGE
    :ivar media_uri: MediaUri of the media content. Required.
    :vartype media_uri: str
    """

    kind: Literal[MessageContentKind.IMAGE] = rest_discriminator(name="kind")  # type: ignore
    """Message content kind is image. Required. The image content type."""
    media_uri: str = rest_field(name="mediaUri")
    """MediaUri of the media content. Required."""

    @overload
    def __init__(
        self,
        *,
        media_uri: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageContentKind.IMAGE, **kwargs)


class ImageNotificationContent(NotificationContent, discriminator="image"):
    """A request to send an image notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is image. Required. Image message type.
    :vartype kind: str or ~azure.communication.messages.models.IMAGE
    :ivar content: Optional text content.
    :vartype content: str
    :ivar media_uri: A media url for the file. Required if the type is one of the supported media
     types, e.g. image. Required.
    :vartype media_uri: str
    """

    kind: Literal[CommunicationMessageKind.IMAGE] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is image. Required. Image message type."""
    content: Optional[str] = rest_field(name="caption")
    """Optional text content."""
    media_uri: str = rest_field(name="mediaUri")
    """A media url for the file. Required if the type is one of the supported media types, e.g. image.
     Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        media_uri: str,
        content: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=CommunicationMessageKind.IMAGE, **kwargs)


class InteractiveMessage(_model_base.Model):
    """The Interactive message content to which user can read and respond.

    All required parameters must be populated in order to send to server.

    :ivar header: Gets or Sets Header content. Supports the following types:text, images etc.
    :vartype header: ~azure.communication.messages.models.MessageContent
    :ivar body: Gets or Sets Message body content. Emojis, markdown, and links are supported.
     Required.
    :vartype body: ~azure.communication.messages.models.TextMessageContent
    :ivar footer: Gets or Sets Message footer content. Emojis, markdown, and links are supported.
    :vartype footer: ~azure.communication.messages.models.TextMessageContent
    :ivar action: The binding object to get or set Action which describes options user have to
     respond to message. Required.
    :vartype action: ~azure.communication.messages.models.ActionBindings
    """

    header: Optional["_models.MessageContent"] = rest_field()
    """Gets or Sets Header content. Supports the following types:text, images etc."""
    body: "_models.TextMessageContent" = rest_field()
    """Gets or Sets Message body content. Emojis, markdown, and links are supported. Required."""
    footer: Optional["_models.TextMessageContent"] = rest_field()
    """Gets or Sets Message footer content. Emojis, markdown, and links are supported."""
    action: "_models.ActionBindings" = rest_field()
    """The binding object to get or set Action which describes options user have to respond to
     message. Required."""

    @overload
    def __init__(
        self,
        *,
        body: "_models.TextMessageContent",
        action: "_models.ActionBindings",
        header: Optional["_models.MessageContent"] = None,
        footer: Optional["_models.TextMessageContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InteractiveNotificationContent(NotificationContent, discriminator="interactive"):
    """A request to send an Interactive message notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is Interactive. Required. Interactive Actionable message
     type.
    :vartype kind: str or ~azure.communication.messages.models.INTERACTIVE
    :ivar interactive_message: The interactive message content. Required.
    :vartype interactive_message: ~azure.communication.messages.models.InteractiveMessage
    """

    kind: Literal[CommunicationMessageKind.INTERACTIVE] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is Interactive. Required. Interactive Actionable message type."""
    interactive_message: "_models.InteractiveMessage" = rest_field(name="interactiveMessage")
    """The interactive message content. Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        interactive_message: "_models.InteractiveMessage",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=CommunicationMessageKind.INTERACTIVE, **kwargs)


class LinkContent(MessageContent, discriminator="url"):
    """The message content of type Url information.

    All required parameters must be populated in order to send to server.

    :ivar kind: Message content kind is url. Required. The Url content type.
    :vartype kind: str or ~azure.communication.messages.models.URL
    :ivar title: Title of the url content. Required.
    :vartype title: str
    :ivar url: The url in the content. Required.
    :vartype url: str
    """

    kind: Literal[MessageContentKind.URL] = rest_discriminator(name="kind")  # type: ignore
    """Message content kind is url. Required. The Url content type."""
    title: str = rest_field()
    """Title of the url content. Required."""
    url: str = rest_field()
    """The url in the content. Required."""

    @overload
    def __init__(
        self,
        *,
        title: str,
        url: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageContentKind.URL, **kwargs)


class MediaNotificationContent(NotificationContent, discriminator="image_v0"):
    """@deprecated A request to send an image notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is image. Required. Image message type. Legacy image type
     for ``MediaNotificationContent`` which is being deprecated
    :vartype kind: str or ~azure.communication.messages.models.IMAGE_V0
    :ivar content: Optional text content.
    :vartype content: str
    :ivar media_uri: A media url for the file. Required if the type is one of the supported media
     types, e.g. image. Required.
    :vartype media_uri: str
    """

    kind: Literal[CommunicationMessageKind.IMAGE_V0] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is image. Required. Image message type. Legacy image type for
     ``MediaNotificationContent`` which is being deprecated"""
    content: Optional[str] = rest_field()
    """Optional text content."""
    media_uri: str = rest_field(name="mediaUri")
    """A media url for the file. Required if the type is one of the supported media types, e.g. image.
     Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        media_uri: str,
        content: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=CommunicationMessageKind.IMAGE_V0, **kwargs)


class MessageReceipt(_model_base.Model):
    """Receipt of the sending one message.


    :ivar message_id: The message id. Required.
    :vartype message_id: str
    :ivar to: The native external platform user identifier of the recipient. Required.
    :vartype to: str
    """

    message_id: str = rest_field(name="messageId")
    """The message id. Required."""
    to: str = rest_field()
    """The native external platform user identifier of the recipient. Required."""

    @overload
    def __init__(
        self,
        *,
        message_id: str,
        to: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MessageTemplate(_model_base.Model):
    """The template object used to create templates.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the template. Required.
    :vartype name: str
    :ivar language: The template's language, in the ISO 639 format, consist of a two-letter
     language code followed by an optional two-letter country code, e.g., 'en' or 'en_US'. Required.
    :vartype language: str
    :ivar template_values: The template values.
    :vartype template_values: list[~azure.communication.messages.models.MessageTemplateValue]
    :ivar bindings: The binding object to link values to the template specific locations.
    :vartype bindings: ~azure.communication.messages.models.MessageTemplateBindings
    """

    name: str = rest_field()
    """Name of the template. Required."""
    language: str = rest_field()
    """The template's language, in the ISO 639 format, consist of a two-letter language code followed
     by an optional two-letter country code, e.g., 'en' or 'en_US'. Required."""
    template_values: Optional[List["_models.MessageTemplateValue"]] = rest_field(name="values")
    """The template values."""
    bindings: Optional["_models.MessageTemplateBindings"] = rest_field()
    """The binding object to link values to the template specific locations."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        language: str,
        template_values: Optional[List["_models.MessageTemplateValue"]] = None,
        bindings: Optional["_models.MessageTemplateBindings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MessageTemplateBindings(_model_base.Model):
    """The binding object to link values to the template specific locations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    WhatsAppMessageTemplateBindings

    All required parameters must be populated in order to send to server.

    :ivar kind: The type discriminator describing a template bindings type. Required. "whatsApp"
    :vartype kind: str or ~azure.communication.messages.models.MessageTemplateBindingsKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a template bindings type. Required. \"whatsApp\""""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MessageTemplateValue(_model_base.Model):
    """The class describes a parameter of a template.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MessageTemplateDocument, MessageTemplateImage, MessageTemplateLocation,
    MessageTemplateQuickAction, MessageTemplateText, MessageTemplateVideo

    All required parameters must be populated in order to send to server.

    :ivar name: Template binding reference name. Required.
    :vartype name: str
    :ivar kind: The type discriminator describing a template parameter type. Required. Known values
     are: "text", "image", "document", "video", "location", and "quickAction".
    :vartype kind: str or ~azure.communication.messages.models.MessageTemplateValueKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    name: str = rest_field()
    """Template binding reference name. Required."""
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a template parameter type. Required. Known values are:
     \"text\", \"image\", \"document\", \"video\", \"location\", and \"quickAction\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MessageTemplateDocument(MessageTemplateValue, discriminator="document"):
    """The message template's document value information.

    All required parameters must be populated in order to send to server.

    :ivar name: Template binding reference name. Required.
    :vartype name: str
    :ivar kind: Message parameter type is document. Required. The document template parameter type.
    :vartype kind: str or ~azure.communication.messages.models.DOCUMENT
    :ivar url: The (public) URL of the media. Required.
    :vartype url: str
    :ivar caption: The [optional] caption of the media object.
    :vartype caption: str
    :ivar file_name: The [optional] filename of the media file.
    :vartype file_name: str
    """

    kind: Literal[MessageTemplateValueKind.DOCUMENT] = rest_discriminator(name="kind")  # type: ignore
    """Message parameter type is document. Required. The document template parameter type."""
    url: str = rest_field()
    """The (public) URL of the media. Required."""
    caption: Optional[str] = rest_field()
    """The [optional] caption of the media object."""
    file_name: Optional[str] = rest_field(name="fileName")
    """The [optional] filename of the media file."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        url: str,
        caption: Optional[str] = None,
        file_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageTemplateValueKind.DOCUMENT, **kwargs)


class MessageTemplateImage(MessageTemplateValue, discriminator="image"):
    """The message template's image value information.

    All required parameters must be populated in order to send to server.

    :ivar name: Template binding reference name. Required.
    :vartype name: str
    :ivar kind: Message parameter type is image. Required. The image template parameter type.
    :vartype kind: str or ~azure.communication.messages.models.IMAGE
    :ivar url: The (public) URL of the media. Required.
    :vartype url: str
    :ivar caption: The [optional] caption of the media object.
    :vartype caption: str
    :ivar file_name: The [optional] filename of the media file.
    :vartype file_name: str
    """

    kind: Literal[MessageTemplateValueKind.IMAGE] = rest_discriminator(name="kind")  # type: ignore
    """Message parameter type is image. Required. The image template parameter type."""
    url: str = rest_field()
    """The (public) URL of the media. Required."""
    caption: Optional[str] = rest_field()
    """The [optional] caption of the media object."""
    file_name: Optional[str] = rest_field(name="fileName")
    """The [optional] filename of the media file."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        url: str,
        caption: Optional[str] = None,
        file_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageTemplateValueKind.IMAGE, **kwargs)


class MessageTemplateItem(_model_base.Model):
    """The message template as returned from the service.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    WhatsAppMessageTemplateItem

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar name: The template's name. Required.
    :vartype name: str
    :ivar language: The template's language, in the ISO 639 format, consist of a two-letter
     language code followed by an optional two-letter country code, e.g., 'en' or 'en_US'. Required.
    :vartype language: str
    :ivar status: The aggregated template status. Required. Known values are: "approved",
     "rejected", "pending", and "paused".
    :vartype status: str or ~azure.communication.messages.models.MessageTemplateStatus
    :ivar kind: The type discriminator describing a template type. Required. "whatsApp"
    :vartype kind: str or ~azure.communication.messages.models.CommunicationMessagesChannel
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    name: str = rest_field(visibility=["read"])
    """The template's name. Required."""
    language: str = rest_field()
    """The template's language, in the ISO 639 format, consist of a two-letter language code followed
     by an optional two-letter country code, e.g., 'en' or 'en_US'. Required."""
    status: Union[str, "_models.MessageTemplateStatus"] = rest_field()
    """The aggregated template status. Required. Known values are: \"approved\", \"rejected\",
     \"pending\", and \"paused\"."""
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a template type. Required. \"whatsApp\""""

    @overload
    def __init__(
        self,
        *,
        language: str,
        status: Union[str, "_models.MessageTemplateStatus"],
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MessageTemplateLocation(MessageTemplateValue, discriminator="location"):
    """The message template's location value information.

    All required parameters must be populated in order to send to server.

    :ivar name: Template binding reference name. Required.
    :vartype name: str
    :ivar kind: Message parameter type is location. Required. The location template parameter type.
    :vartype kind: str or ~azure.communication.messages.models.LOCATION
    :ivar location_name: The [Optional] name of the location.
    :vartype location_name: str
    :ivar address: The [Optional] address of the location.
    :vartype address: str
    :ivar latitude: The latitude of the location. Required.
    :vartype latitude: float
    :ivar longitude: The longitude of the location. Required.
    :vartype longitude: float
    """

    kind: Literal[MessageTemplateValueKind.LOCATION] = rest_discriminator(name="kind")  # type: ignore
    """Message parameter type is location. Required. The location template parameter type."""
    location_name: Optional[str] = rest_field(name="locationName")
    """The [Optional] name of the location."""
    address: Optional[str] = rest_field()
    """The [Optional] address of the location."""
    latitude: float = rest_field()
    """The latitude of the location. Required."""
    longitude: float = rest_field()
    """The longitude of the location. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        latitude: float,
        longitude: float,
        location_name: Optional[str] = None,
        address: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageTemplateValueKind.LOCATION, **kwargs)


class MessageTemplateQuickAction(MessageTemplateValue, discriminator="quickAction"):
    """The message template's quick action value information.

    All required parameters must be populated in order to send to server.

    :ivar name: Template binding reference name. Required.
    :vartype name: str
    :ivar kind: Message parameter type is quick action. Required. The quick action template
     parameter type.
    :vartype kind: str or ~azure.communication.messages.models.QUICK_ACTION
    :ivar text: The [Optional] quick action text.
    :vartype text: str
    :ivar payload: The [Optional] quick action payload.
    :vartype payload: str
    """

    kind: Literal[MessageTemplateValueKind.QUICK_ACTION] = rest_discriminator(name="kind")  # type: ignore
    """Message parameter type is quick action. Required. The quick action template parameter type."""
    text: Optional[str] = rest_field()
    """The [Optional] quick action text."""
    payload: Optional[str] = rest_field()
    """The [Optional] quick action payload."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        text: Optional[str] = None,
        payload: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageTemplateValueKind.QUICK_ACTION, **kwargs)


class MessageTemplateText(MessageTemplateValue, discriminator="text"):
    """The message template's text value information.

    All required parameters must be populated in order to send to server.

    :ivar name: Template binding reference name. Required.
    :vartype name: str
    :ivar kind: Message parameter type is text. Required. The text template parameter type.
    :vartype kind: str or ~azure.communication.messages.models.TEXT
    :ivar text: The text value. Required.
    :vartype text: str
    """

    kind: Literal[MessageTemplateValueKind.TEXT] = rest_discriminator(name="kind")  # type: ignore
    """Message parameter type is text. Required. The text template parameter type."""
    text: str = rest_field()
    """The text value. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageTemplateValueKind.TEXT, **kwargs)


class MessageTemplateVideo(MessageTemplateValue, discriminator="video"):
    """The message template's video value information.

    All required parameters must be populated in order to send to server.

    :ivar name: Template binding reference name. Required.
    :vartype name: str
    :ivar kind: Message parameter type is video. Required. The video template parameter type.
    :vartype kind: str or ~azure.communication.messages.models.VIDEO
    :ivar url: The (public) URL of the media. Required.
    :vartype url: str
    :ivar caption: The [optional] caption of the media object.
    :vartype caption: str
    :ivar file_name: The [optional] filename of the media file.
    :vartype file_name: str
    """

    kind: Literal[MessageTemplateValueKind.VIDEO] = rest_discriminator(name="kind")  # type: ignore
    """Message parameter type is video. Required. The video template parameter type."""
    url: str = rest_field()
    """The (public) URL of the media. Required."""
    caption: Optional[str] = rest_field()
    """The [optional] caption of the media object."""
    file_name: Optional[str] = rest_field(name="fileName")
    """The [optional] filename of the media file."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        url: str,
        caption: Optional[str] = None,
        file_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageTemplateValueKind.VIDEO, **kwargs)


class ReactionNotificationContent(NotificationContent, discriminator="reaction"):
    """A request to send a Reaction notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is reaction. Required. Reaction message type.
    :vartype kind: str or ~azure.communication.messages.models.REACTION
    :ivar emoji: emoji content like uD83D. Required.
    :vartype emoji: str
    :ivar message_id: ID of the previous message you want to reply to. Required.
    :vartype message_id: str
    """

    kind: Literal[CommunicationMessageKind.REACTION] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is reaction. Required. Reaction message type."""
    emoji: str = rest_field()
    """emoji content like :) Required."""
    message_id: str = rest_field(name="messageId")
    """ID of the previous message you want to reply to. Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        emoji: str,
        message_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=CommunicationMessageKind.REACTION, **kwargs)


class SendMessageResult(_model_base.Model):
    """Result of the send message operation.


    :ivar receipts: Receipts of the send message operation. Required.
    :vartype receipts: list[~azure.communication.messages.models.MessageReceipt]
    """

    receipts: List["_models.MessageReceipt"] = rest_field()
    """Receipts of the send message operation. Required."""

    @overload
    def __init__(
        self,
        *,
        receipts: List["_models.MessageReceipt"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StickerNotificationContent(NotificationContent, discriminator="sticker"):
    """A request to send a Sticker notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is sticker. Required. Sticker message type.
    :vartype kind: str or ~azure.communication.messages.models.STICKER
    :ivar media_uri: A media url for the file. Required if the type is one of the supported media
     types, e.g. image. Required.
    :vartype media_uri: str
    """

    kind: Literal[CommunicationMessageKind.STICKER] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is sticker. Required. Sticker message type."""
    media_uri: str = rest_field(name="mediaUri")
    """A media url for the file. Required if the type is one of the supported media types, e.g. image.
     Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        media_uri: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=CommunicationMessageKind.STICKER, **kwargs)


class TemplateNotificationContent(NotificationContent, discriminator="template"):
    """A request to send a template notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is template. Required. Template message type.
    :vartype kind: str or ~azure.communication.messages.models.TEMPLATE
    :ivar template: The template object used to create templates. Required.
    :vartype template: ~azure.communication.messages.models.MessageTemplate
    """

    kind: Literal[CommunicationMessageKind.TEMPLATE] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is template. Required. Template message type."""
    template: "_models.MessageTemplate" = rest_field()
    """The template object used to create templates. Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        template: "_models.MessageTemplate",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=CommunicationMessageKind.TEMPLATE, **kwargs)


class TextMessageContent(MessageContent, discriminator="text"):
    """The message content of type text information.

    All required parameters must be populated in order to send to server.

    :ivar kind: Message content kind is text. Required. The text content type.
    :vartype kind: str or ~azure.communication.messages.models.TEXT
    :ivar text: The text value. Required.
    :vartype text: str
    """

    kind: Literal[MessageContentKind.TEXT] = rest_discriminator(name="kind")  # type: ignore
    """Message content kind is text. Required. The text content type."""
    text: str = rest_field()
    """The text value. Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageContentKind.TEXT, **kwargs)


class TextNotificationContent(NotificationContent, discriminator="text"):
    """A request to send a text notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is text. Required. Text message type.
    :vartype kind: str or ~azure.communication.messages.models.TEXT
    :ivar content: Message content. Required.
    :vartype content: str
    """

    kind: Literal[CommunicationMessageKind.TEXT] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is text. Required. Text message type."""
    content: str = rest_field()
    """Message content. Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        content: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=CommunicationMessageKind.TEXT, **kwargs)


class VideoMessageContent(MessageContent, discriminator="video"):
    """The message content of type video information.

    All required parameters must be populated in order to send to server.

    :ivar kind: Message content kind is video. Required. The video content type.
    :vartype kind: str or ~azure.communication.messages.models.VIDEO
    :ivar media_uri: MediaUri of the media content. Required.
    :vartype media_uri: str
    """

    kind: Literal[MessageContentKind.VIDEO] = rest_discriminator(name="kind")  # type: ignore
    """Message content kind is video. Required. The video content type."""
    media_uri: str = rest_field(name="mediaUri")
    """MediaUri of the media content. Required."""

    @overload
    def __init__(
        self,
        *,
        media_uri: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageContentKind.VIDEO, **kwargs)


class VideoNotificationContent(NotificationContent, discriminator="video"):
    """A request to send a video notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is image. Required. Video message type.
    :vartype kind: str or ~azure.communication.messages.models.VIDEO
    :ivar caption: Optional text content.
    :vartype caption: str
    :ivar media_uri: A media url for the file. Required if the type is one of the supported media
     types, e.g. image. Required.
    :vartype media_uri: str
    """

    kind: Literal[CommunicationMessageKind.VIDEO] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is image. Required. Video message type."""
    caption: Optional[str] = rest_field()
    """Optional text content."""
    media_uri: str = rest_field(name="mediaUri")
    """A media url for the file. Required if the type is one of the supported media types, e.g. image.
     Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        media_uri: str,
        caption: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=CommunicationMessageKind.VIDEO, **kwargs)


class WhatsAppButtonActionBindings(ActionBindings, discriminator="whatsAppButtonAction"):
    """WhatsApp Binding actions to the interactive message.

    All required parameters must be populated in order to send to server.

    :ivar kind: Message action binding type is WhatsAppButtonAction. Required. The WhatsApp Button
     action binding kind.
    :vartype kind: str or ~azure.communication.messages.models.WHATS_APP_BUTTON_ACTION
    :ivar content: Action content of Interactive message. Required.
    :vartype content: ~azure.communication.messages.models.ButtonSetContent
    """

    kind: Literal[MessageActionBindingKind.WHATS_APP_BUTTON_ACTION] = rest_discriminator(name="kind")  # type: ignore
    """Message action binding type is WhatsAppButtonAction. Required. The WhatsApp Button action
     binding kind."""
    content: "_models.ButtonSetContent" = rest_field()
    """Action content of Interactive message. Required."""

    @overload
    def __init__(
        self,
        *,
        content: "_models.ButtonSetContent",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageActionBindingKind.WHATS_APP_BUTTON_ACTION, **kwargs)


class WhatsAppListActionBindings(ActionBindings, discriminator="whatsAppListAction"):
    """WhatsApp List Binding actions to the interactive message.

    All required parameters must be populated in order to send to server.

    :ivar kind: Message action binding type is WhatsAppListAction. Required. The WhatsApp List
     action binding kind.
    :vartype kind: str or ~azure.communication.messages.models.WHATS_APP_LIST_ACTION
    :ivar content: Action content of Interactive message. Required.
    :vartype content: ~azure.communication.messages.models.ActionGroupContent
    """

    kind: Literal[MessageActionBindingKind.WHATS_APP_LIST_ACTION] = rest_discriminator(name="kind")  # type: ignore
    """Message action binding type is WhatsAppListAction. Required. The WhatsApp List action binding
     kind."""
    content: "_models.ActionGroupContent" = rest_field()
    """Action content of Interactive message. Required."""

    @overload
    def __init__(
        self,
        *,
        content: "_models.ActionGroupContent",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageActionBindingKind.WHATS_APP_LIST_ACTION, **kwargs)


class WhatsAppMessageTemplateBindings(MessageTemplateBindings, discriminator="whatsApp"):
    """The template bindings for WhatsApp.

    All required parameters must be populated in order to send to server.

    :ivar kind: MessageTemplateBindings is whatsApp. Required. The WhatsApp template type.
    :vartype kind: str or ~azure.communication.messages.models.WHATSAPP
    :ivar header: The header template bindings.
    :vartype header:
     list[~azure.communication.messages.models.WhatsAppMessageTemplateBindingsComponent]
    :ivar body: The body template bindings.
    :vartype body:
     list[~azure.communication.messages.models.WhatsAppMessageTemplateBindingsComponent]
    :ivar footer: The footer template bindings.
    :vartype footer:
     list[~azure.communication.messages.models.WhatsAppMessageTemplateBindingsComponent]
    :ivar buttons: The button template bindings.
    :vartype buttons:
     list[~azure.communication.messages.models.WhatsAppMessageTemplateBindingsButton]
    """

    kind: Literal[MessageTemplateBindingsKind.WHATSAPP] = rest_discriminator(name="kind")  # type: ignore
    """MessageTemplateBindings is whatsApp. Required. The WhatsApp template type."""
    header: Optional[List["_models.WhatsAppMessageTemplateBindingsComponent"]] = rest_field()
    """The header template bindings."""
    body: Optional[List["_models.WhatsAppMessageTemplateBindingsComponent"]] = rest_field()
    """The body template bindings."""
    footer: Optional[List["_models.WhatsAppMessageTemplateBindingsComponent"]] = rest_field()
    """The footer template bindings."""
    buttons: Optional[List["_models.WhatsAppMessageTemplateBindingsButton"]] = rest_field()
    """The button template bindings."""

    @overload
    def __init__(
        self,
        *,
        header: Optional[List["_models.WhatsAppMessageTemplateBindingsComponent"]] = None,
        body: Optional[List["_models.WhatsAppMessageTemplateBindingsComponent"]] = None,
        footer: Optional[List["_models.WhatsAppMessageTemplateBindingsComponent"]] = None,
        buttons: Optional[List["_models.WhatsAppMessageTemplateBindingsButton"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageTemplateBindingsKind.WHATSAPP, **kwargs)


class WhatsAppMessageTemplateBindingsButton(_model_base.Model):
    """The template bindings component button for WhatsApp.

    All required parameters must be populated in order to send to server.

    :ivar sub_type: The WhatsApp button sub type. Required. Known values are: "quickReply" and
     "url".
    :vartype sub_type: str or ~azure.communication.messages.models.WhatsAppMessageButtonSubType
    :ivar ref_value: The name of the referenced item in the template values. Required.
    :vartype ref_value: str
    """

    sub_type: Union[str, "_models.WhatsAppMessageButtonSubType"] = rest_field(name="subType")
    """The WhatsApp button sub type. Required. Known values are: \"quickReply\" and \"url\"."""
    ref_value: str = rest_field(name="refValue")
    """The name of the referenced item in the template values. Required."""

    @overload
    def __init__(
        self,
        *,
        sub_type: Union[str, "_models.WhatsAppMessageButtonSubType"],
        ref_value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WhatsAppMessageTemplateBindingsComponent(_model_base.Model):
    """The template bindings component for WhatsApp.

    All required parameters must be populated in order to send to server.

    :ivar ref_value: The name of the referenced item in the template values. Required.
    :vartype ref_value: str
    """

    ref_value: str = rest_field(name="refValue")
    """The name of the referenced item in the template values. Required."""

    @overload
    def __init__(
        self,
        *,
        ref_value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WhatsAppMessageTemplateItem(MessageTemplateItem, discriminator="whatsApp"):
    """The WhatsApp-specific template response contract.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar name: The template's name. Required.
    :vartype name: str
    :ivar language: The template's language, in the ISO 639 format, consist of a two-letter
     language code followed by an optional two-letter country code, e.g., 'en' or 'en_US'. Required.
    :vartype language: str
    :ivar status: The aggregated template status. Required. Known values are: "approved",
     "rejected", "pending", and "paused".
    :vartype status: str or ~azure.communication.messages.models.MessageTemplateStatus
    :ivar content: WhatsApp platform's template content. This is the payload returned from WhatsApp
     API.
    :vartype content: any
    :ivar kind: Message template response type is whatsApp. Required. The WhatsApp communication
     messages channel type.
    :vartype kind: str or ~azure.communication.messages.models.WHATSAPP
    """

    content: Optional[Any] = rest_field()
    """WhatsApp platform's template content. This is the payload returned from WhatsApp API."""
    kind: Literal[CommunicationMessagesChannel.WHATSAPP] = rest_discriminator(name="kind")  # type: ignore
    """Message template response type is whatsApp. Required. The WhatsApp communication messages
     channel type."""

    @overload
    def __init__(
        self,
        *,
        language: str,
        status: Union[str, "_models.MessageTemplateStatus"],
        content: Optional[Any] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=CommunicationMessagesChannel.WHATSAPP, **kwargs)


class WhatsAppUrlActionBindings(ActionBindings, discriminator="whatsAppUrlAction"):
    """WhatsApp Binding actions to the interactive message.

    All required parameters must be populated in order to send to server.

    :ivar kind: Message action binding type is WhatsAppUrlAction. Required. The WhatsApp Url action
     binding kind.
    :vartype kind: str or ~azure.communication.messages.models.WHATS_APP_URL_ACTION
    :ivar content: Action content of Interactive message. Required.
    :vartype content: ~azure.communication.messages.models.LinkContent
    """

    kind: Literal[MessageActionBindingKind.WHATS_APP_URL_ACTION] = rest_discriminator(name="kind")  # type: ignore
    """Message action binding type is WhatsAppUrlAction. Required. The WhatsApp Url action binding
     kind."""
    content: "_models.LinkContent" = rest_field()
    """Action content of Interactive message. Required."""

    @overload
    def __init__(
        self,
        *,
        content: "_models.LinkContent",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MessageActionBindingKind.WHATS_APP_URL_ACTION, **kwargs)
