# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class ApiError(_serialization.Model):
    """Error information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error information in OData format.
    :vartype error: ~azure.mgmt.datamigration.models.ODataError
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemDataAutoGenerated
    """

    _validation = {
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ODataError"},
        "system_data": {"key": "systemData", "type": "SystemDataAutoGenerated"},
    }

    def __init__(self, *, error: Optional["_models.ODataError"] = None, **kwargs: Any) -> None:
        """
        :keyword error: Error information in OData format.
        :paramtype error: ~azure.mgmt.datamigration.models.ODataError
        """
        super().__init__(**kwargs)
        self.error = error
        self.system_data: Optional["_models.SystemDataAutoGenerated"] = None


class AuthenticationKeys(_serialization.Model):
    """An authentication key.

    :ivar auth_key1: The first authentication key.
    :vartype auth_key1: str
    :ivar auth_key2: The second authentication key.
    :vartype auth_key2: str
    """

    _attribute_map = {
        "auth_key1": {"key": "authKey1", "type": "str"},
        "auth_key2": {"key": "authKey2", "type": "str"},
    }

    def __init__(self, *, auth_key1: Optional[str] = None, auth_key2: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword auth_key1: The first authentication key.
        :paramtype auth_key1: str
        :keyword auth_key2: The second authentication key.
        :paramtype auth_key2: str
        """
        super().__init__(**kwargs)
        self.auth_key1 = auth_key1
        self.auth_key2 = auth_key2


class AvailableServiceSku(_serialization.Model):
    """Describes the available service SKU.

    :ivar resource_type: The resource type, including the provider namespace.
    :vartype resource_type: str
    :ivar sku: SKU name, tier, etc.
    :vartype sku: ~azure.mgmt.datamigration.models.AvailableServiceSkuSku
    :ivar capacity: A description of the scaling capacities of the SKU.
    :vartype capacity: ~azure.mgmt.datamigration.models.AvailableServiceSkuCapacity
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "sku": {"key": "sku", "type": "AvailableServiceSkuSku"},
        "capacity": {"key": "capacity", "type": "AvailableServiceSkuCapacity"},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        sku: Optional["_models.AvailableServiceSkuSku"] = None,
        capacity: Optional["_models.AvailableServiceSkuCapacity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_type: The resource type, including the provider namespace.
        :paramtype resource_type: str
        :keyword sku: SKU name, tier, etc.
        :paramtype sku: ~azure.mgmt.datamigration.models.AvailableServiceSkuSku
        :keyword capacity: A description of the scaling capacities of the SKU.
        :paramtype capacity: ~azure.mgmt.datamigration.models.AvailableServiceSkuCapacity
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.sku = sku
        self.capacity = capacity


class AvailableServiceSkuCapacity(_serialization.Model):
    """A description of the scaling capacities of the SKU.

    :ivar minimum: The minimum capacity, usually 0 or 1.
    :vartype minimum: int
    :ivar maximum: The maximum capacity.
    :vartype maximum: int
    :ivar default: The default capacity.
    :vartype default: int
    :ivar scale_type: The scalability approach. Known values are: "none", "manual", and
     "automatic".
    :vartype scale_type: str or ~azure.mgmt.datamigration.models.ServiceScalability
    """

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default": {"key": "default", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(
        self,
        *,
        minimum: Optional[int] = None,
        maximum: Optional[int] = None,
        default: Optional[int] = None,
        scale_type: Optional[Union[str, "_models.ServiceScalability"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword minimum: The minimum capacity, usually 0 or 1.
        :paramtype minimum: int
        :keyword maximum: The maximum capacity.
        :paramtype maximum: int
        :keyword default: The default capacity.
        :paramtype default: int
        :keyword scale_type: The scalability approach. Known values are: "none", "manual", and
         "automatic".
        :paramtype scale_type: str or ~azure.mgmt.datamigration.models.ServiceScalability
        """
        super().__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default
        self.scale_type = scale_type


class AvailableServiceSkuSku(_serialization.Model):
    """SKU name, tier, etc.

    :ivar name: The name of the SKU.
    :vartype name: str
    :ivar family: SKU family.
    :vartype family: str
    :ivar size: SKU size.
    :vartype size: str
    :ivar tier: The tier of the SKU, such as "Basic", "General Purpose", or "Business Critical".
    :vartype tier: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        family: Optional[str] = None,
        size: Optional[str] = None,
        tier: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the SKU.
        :paramtype name: str
        :keyword family: SKU family.
        :paramtype family: str
        :keyword size: SKU size.
        :paramtype size: str
        :keyword tier: The tier of the SKU, such as "Basic", "General Purpose", or "Business Critical".
        :paramtype tier: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.family = family
        self.size = size
        self.tier = tier


class AzureActiveDirectoryApp(_serialization.Model):
    """Azure Active Directory Application.

    :ivar application_id: Application ID of the Azure Active Directory Application.
    :vartype application_id: str
    :ivar app_key: Key used to authenticate to the Azure Active Directory Application.
    :vartype app_key: str
    :ivar tenant_id: Tenant id of the customer.
    :vartype tenant_id: str
    :ivar ignore_azure_permissions: Ignore checking azure permissions on the AAD app.
    :vartype ignore_azure_permissions: bool
    """

    _attribute_map = {
        "application_id": {"key": "applicationId", "type": "str"},
        "app_key": {"key": "appKey", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "ignore_azure_permissions": {"key": "ignoreAzurePermissions", "type": "bool"},
    }

    def __init__(
        self,
        *,
        application_id: Optional[str] = None,
        app_key: Optional[str] = None,
        tenant_id: Optional[str] = None,
        ignore_azure_permissions: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword application_id: Application ID of the Azure Active Directory Application.
        :paramtype application_id: str
        :keyword app_key: Key used to authenticate to the Azure Active Directory Application.
        :paramtype app_key: str
        :keyword tenant_id: Tenant id of the customer.
        :paramtype tenant_id: str
        :keyword ignore_azure_permissions: Ignore checking azure permissions on the AAD app.
        :paramtype ignore_azure_permissions: bool
        """
        super().__init__(**kwargs)
        self.application_id = application_id
        self.app_key = app_key
        self.tenant_id = tenant_id
        self.ignore_azure_permissions = ignore_azure_permissions


class AzureBlob(_serialization.Model):
    """Azure Blob Details.

    :ivar auth_type: Authentication type used for accessing Azure Blob Storage. Known values are:
     "AccountKey" and "ManagedIdentity".
    :vartype auth_type: str or ~azure.mgmt.datamigration.models.AuthType
    :ivar identity: Identity details for authentication using a Managed Identity.
    :vartype identity: ~azure.mgmt.datamigration.models.ManagedServiceIdentity
    :ivar storage_account_resource_id: Resource Id of the storage account where backups are stored.
    :vartype storage_account_resource_id: str
    :ivar account_key: Storage Account Key.
    :vartype account_key: str
    :ivar blob_container_name: Blob container name where backups are stored.
    :vartype blob_container_name: str
    """

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "storage_account_resource_id": {"key": "storageAccountResourceId", "type": "str"},
        "account_key": {"key": "accountKey", "type": "str"},
        "blob_container_name": {"key": "blobContainerName", "type": "str"},
    }

    def __init__(
        self,
        *,
        auth_type: Optional[Union[str, "_models.AuthType"]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        storage_account_resource_id: Optional[str] = None,
        account_key: Optional[str] = None,
        blob_container_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auth_type: Authentication type used for accessing Azure Blob Storage. Known values
         are: "AccountKey" and "ManagedIdentity".
        :paramtype auth_type: str or ~azure.mgmt.datamigration.models.AuthType
        :keyword identity: Identity details for authentication using a Managed Identity.
        :paramtype identity: ~azure.mgmt.datamigration.models.ManagedServiceIdentity
        :keyword storage_account_resource_id: Resource Id of the storage account where backups are
         stored.
        :paramtype storage_account_resource_id: str
        :keyword account_key: Storage Account Key.
        :paramtype account_key: str
        :keyword blob_container_name: Blob container name where backups are stored.
        :paramtype blob_container_name: str
        """
        super().__init__(**kwargs)
        self.auth_type = auth_type
        self.identity = identity
        self.storage_account_resource_id = storage_account_resource_id
        self.account_key = account_key
        self.blob_container_name = blob_container_name


class BackupConfiguration(_serialization.Model):
    """Backup Configuration.

    :ivar source_location: Source location of backups.
    :vartype source_location: ~azure.mgmt.datamigration.models.SourceLocation
    :ivar target_location: Target location for copying backups.
    :vartype target_location: ~azure.mgmt.datamigration.models.TargetLocation
    """

    _attribute_map = {
        "source_location": {"key": "sourceLocation", "type": "SourceLocation"},
        "target_location": {"key": "targetLocation", "type": "TargetLocation"},
    }

    def __init__(
        self,
        *,
        source_location: Optional["_models.SourceLocation"] = None,
        target_location: Optional["_models.TargetLocation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_location: Source location of backups.
        :paramtype source_location: ~azure.mgmt.datamigration.models.SourceLocation
        :keyword target_location: Target location for copying backups.
        :paramtype target_location: ~azure.mgmt.datamigration.models.TargetLocation
        """
        super().__init__(**kwargs)
        self.source_location = source_location
        self.target_location = target_location


class BackupFileInfo(_serialization.Model):
    """Information of the backup file.

    :ivar file_location: Location of the backup file in shared folder.
    :vartype file_location: str
    :ivar family_sequence_number: Sequence number of the backup file in the backup set.
    :vartype family_sequence_number: int
    :ivar status: Status of the backup file during migration. Known values are: "Arrived",
     "Queued", "Uploading", "Uploaded", "Restoring", "Restored", and "Cancelled".
    :vartype status: str or ~azure.mgmt.datamigration.models.BackupFileStatus
    """

    _attribute_map = {
        "file_location": {"key": "fileLocation", "type": "str"},
        "family_sequence_number": {"key": "familySequenceNumber", "type": "int"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        file_location: Optional[str] = None,
        family_sequence_number: Optional[int] = None,
        status: Optional[Union[str, "_models.BackupFileStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword file_location: Location of the backup file in shared folder.
        :paramtype file_location: str
        :keyword family_sequence_number: Sequence number of the backup file in the backup set.
        :paramtype family_sequence_number: int
        :keyword status: Status of the backup file during migration. Known values are: "Arrived",
         "Queued", "Uploading", "Uploaded", "Restoring", "Restored", and "Cancelled".
        :paramtype status: str or ~azure.mgmt.datamigration.models.BackupFileStatus
        """
        super().__init__(**kwargs)
        self.file_location = file_location
        self.family_sequence_number = family_sequence_number
        self.status = status


class BackupSetInfo(_serialization.Model):
    """Information of backup set.

    :ivar backup_set_id: Id for the set of backup files.
    :vartype backup_set_id: str
    :ivar first_lsn: First log sequence number of the backup file.
    :vartype first_lsn: str
    :ivar last_lsn: Last log sequence number of the backup file.
    :vartype last_lsn: str
    :ivar last_modified_time: Last modified time of the backup file in share location.
    :vartype last_modified_time: ~datetime.datetime
    :ivar backup_type: Enum of the different backup types. Known values are: "Database",
     "TransactionLog", "File", "DifferentialDatabase", "DifferentialFile", "Partial", and
     "DifferentialPartial".
    :vartype backup_type: str or ~azure.mgmt.datamigration.models.BackupType
    :ivar list_of_backup_files: List of files in the backup set.
    :vartype list_of_backup_files: list[~azure.mgmt.datamigration.models.BackupFileInfo]
    :ivar database_name: Name of the database to which the backup set belongs.
    :vartype database_name: str
    :ivar backup_start_date: Date and time that the backup operation began.
    :vartype backup_start_date: ~datetime.datetime
    :ivar backup_finished_date: Date and time that the backup operation finished.
    :vartype backup_finished_date: ~datetime.datetime
    :ivar is_backup_restored: Whether the backup set is restored or not.
    :vartype is_backup_restored: bool
    """

    _attribute_map = {
        "backup_set_id": {"key": "backupSetId", "type": "str"},
        "first_lsn": {"key": "firstLsn", "type": "str"},
        "last_lsn": {"key": "lastLsn", "type": "str"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
        "backup_type": {"key": "backupType", "type": "str"},
        "list_of_backup_files": {"key": "listOfBackupFiles", "type": "[BackupFileInfo]"},
        "database_name": {"key": "databaseName", "type": "str"},
        "backup_start_date": {"key": "backupStartDate", "type": "iso-8601"},
        "backup_finished_date": {"key": "backupFinishedDate", "type": "iso-8601"},
        "is_backup_restored": {"key": "isBackupRestored", "type": "bool"},
    }

    def __init__(
        self,
        *,
        backup_set_id: Optional[str] = None,
        first_lsn: Optional[str] = None,
        last_lsn: Optional[str] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        backup_type: Optional[Union[str, "_models.BackupType"]] = None,
        list_of_backup_files: Optional[List["_models.BackupFileInfo"]] = None,
        database_name: Optional[str] = None,
        backup_start_date: Optional[datetime.datetime] = None,
        backup_finished_date: Optional[datetime.datetime] = None,
        is_backup_restored: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_set_id: Id for the set of backup files.
        :paramtype backup_set_id: str
        :keyword first_lsn: First log sequence number of the backup file.
        :paramtype first_lsn: str
        :keyword last_lsn: Last log sequence number of the backup file.
        :paramtype last_lsn: str
        :keyword last_modified_time: Last modified time of the backup file in share location.
        :paramtype last_modified_time: ~datetime.datetime
        :keyword backup_type: Enum of the different backup types. Known values are: "Database",
         "TransactionLog", "File", "DifferentialDatabase", "DifferentialFile", "Partial", and
         "DifferentialPartial".
        :paramtype backup_type: str or ~azure.mgmt.datamigration.models.BackupType
        :keyword list_of_backup_files: List of files in the backup set.
        :paramtype list_of_backup_files: list[~azure.mgmt.datamigration.models.BackupFileInfo]
        :keyword database_name: Name of the database to which the backup set belongs.
        :paramtype database_name: str
        :keyword backup_start_date: Date and time that the backup operation began.
        :paramtype backup_start_date: ~datetime.datetime
        :keyword backup_finished_date: Date and time that the backup operation finished.
        :paramtype backup_finished_date: ~datetime.datetime
        :keyword is_backup_restored: Whether the backup set is restored or not.
        :paramtype is_backup_restored: bool
        """
        super().__init__(**kwargs)
        self.backup_set_id = backup_set_id
        self.first_lsn = first_lsn
        self.last_lsn = last_lsn
        self.last_modified_time = last_modified_time
        self.backup_type = backup_type
        self.list_of_backup_files = list_of_backup_files
        self.database_name = database_name
        self.backup_start_date = backup_start_date
        self.backup_finished_date = backup_finished_date
        self.is_backup_restored = is_backup_restored


class BlobShare(_serialization.Model):
    """Blob container storage information.

    :ivar sas_uri: SAS URI of Azure Storage Account Container.
    :vartype sas_uri: str
    """

    _attribute_map = {
        "sas_uri": {"key": "sasUri", "type": "str"},
    }

    def __init__(self, *, sas_uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword sas_uri: SAS URI of Azure Storage Account Container.
        :paramtype sas_uri: str
        """
        super().__init__(**kwargs)
        self.sas_uri = sas_uri


class CheckOCIDriverTaskInput(_serialization.Model):
    """Input for the service task to check for OCI drivers.

    :ivar server_version: Version of the source server to check against.  Optional.
    :vartype server_version: str
    """

    _attribute_map = {
        "server_version": {"key": "serverVersion", "type": "str"},
    }

    def __init__(self, *, server_version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword server_version: Version of the source server to check against.  Optional.
        :paramtype server_version: str
        """
        super().__init__(**kwargs)
        self.server_version = server_version


class CheckOCIDriverTaskOutput(_serialization.Model):
    """Output for the service task to check for OCI drivers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar installed_driver: Information about the installed driver if found and valid.
    :vartype installed_driver: ~azure.mgmt.datamigration.models.OracleOCIDriverInfo
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "installed_driver": {"key": "installedDriver", "type": "OracleOCIDriverInfo"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, *, installed_driver: Optional["_models.OracleOCIDriverInfo"] = None, **kwargs: Any) -> None:
        """
        :keyword installed_driver: Information about the installed driver if found and valid.
        :paramtype installed_driver: ~azure.mgmt.datamigration.models.OracleOCIDriverInfo
        """
        super().__init__(**kwargs)
        self.installed_driver = installed_driver
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class ProjectTaskProperties(_serialization.Model):
    """Base class for all types of DMS (classic) task properties. If task is not supported by current
    client, this object is returned.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConnectToMongoDbTaskProperties, ConnectToSourceMySqlTaskProperties,
    ConnectToSourceOracleSyncTaskProperties, ConnectToSourcePostgreSqlSyncTaskProperties,
    ConnectToSourceSqlServerTaskProperties, ConnectToSourceSqlServerSyncTaskProperties,
    ConnectToTargetAzureDbForMySqlTaskProperties,
    ConnectToTargetAzureDbForPostgreSqlSyncTaskProperties, ConnectToTargetSqlMITaskProperties,
    ConnectToTargetSqlMISyncTaskProperties,
    ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskProperties,
    ConnectToTargetSqlDbTaskProperties, ConnectToTargetSqlDbSyncTaskProperties,
    GetTdeCertificatesSqlTaskProperties, GetUserTablesSqlSyncTaskProperties,
    GetUserTablesSqlTaskProperties, GetUserTablesMySqlTaskProperties,
    GetUserTablesOracleTaskProperties, GetUserTablesPostgreSqlTaskProperties,
    MigrateMongoDbTaskProperties, MigrateMySqlAzureDbForMySqlOfflineTaskProperties,
    MigrateMySqlAzureDbForMySqlSyncTaskProperties,
    MigrateOracleAzureDbForPostgreSqlSyncTaskProperties,
    MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties,
    MigrateSqlServerSqlDbSyncTaskProperties, MigrateSqlServerSqlMITaskProperties,
    MigrateSqlServerSqlMISyncTaskProperties, MigrateSqlServerSqlDbTaskProperties,
    MigrateSsisTaskProperties, MigrateSchemaSqlServerSqlDbTaskProperties,
    CheckOCIDriverTaskProperties, InstallOCIDriverTaskProperties, UploadOCIDriverTaskProperties,
    ValidateMongoDbTaskProperties, ValidateOracleAzureDbForPostgreSqlSyncTaskProperties,
    ValidateMigrationInputSqlServerSqlMITaskProperties,
    ValidateMigrationInputSqlServerSqlMISyncTaskProperties,
    ValidateMigrationInputSqlServerSqlDbSyncTaskProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
    }

    _subtype_map = {
        "task_type": {
            "Connect.MongoDb": "ConnectToMongoDbTaskProperties",
            "ConnectToSource.MySql": "ConnectToSourceMySqlTaskProperties",
            "ConnectToSource.Oracle.Sync": "ConnectToSourceOracleSyncTaskProperties",
            "ConnectToSource.PostgreSql.Sync": "ConnectToSourcePostgreSqlSyncTaskProperties",
            "ConnectToSource.SqlServer": "ConnectToSourceSqlServerTaskProperties",
            "ConnectToSource.SqlServer.Sync": "ConnectToSourceSqlServerSyncTaskProperties",
            "ConnectToTarget.AzureDbForMySql": "ConnectToTargetAzureDbForMySqlTaskProperties",
            "ConnectToTarget.AzureDbForPostgreSql.Sync": "ConnectToTargetAzureDbForPostgreSqlSyncTaskProperties",
            "ConnectToTarget.AzureSqlDbMI": "ConnectToTargetSqlMITaskProperties",
            "ConnectToTarget.AzureSqlDbMI.Sync.LRS": "ConnectToTargetSqlMISyncTaskProperties",
            "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync": "ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskProperties",
            "ConnectToTarget.SqlDb": "ConnectToTargetSqlDbTaskProperties",
            "ConnectToTarget.SqlDb.Sync": "ConnectToTargetSqlDbSyncTaskProperties",
            "GetTDECertificates.Sql": "GetTdeCertificatesSqlTaskProperties",
            "GetUserTables.AzureSqlDb.Sync": "GetUserTablesSqlSyncTaskProperties",
            "GetUserTables.Sql": "GetUserTablesSqlTaskProperties",
            "GetUserTablesMySql": "GetUserTablesMySqlTaskProperties",
            "GetUserTablesOracle": "GetUserTablesOracleTaskProperties",
            "GetUserTablesPostgreSql": "GetUserTablesPostgreSqlTaskProperties",
            "Migrate.MongoDb": "MigrateMongoDbTaskProperties",
            "Migrate.MySql.AzureDbForMySql": "MigrateMySqlAzureDbForMySqlOfflineTaskProperties",
            "Migrate.MySql.AzureDbForMySql.Sync": "MigrateMySqlAzureDbForMySqlSyncTaskProperties",
            "Migrate.Oracle.AzureDbForPostgreSql.Sync": "MigrateOracleAzureDbForPostgreSqlSyncTaskProperties",
            "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2": "MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties",
            "Migrate.SqlServer.AzureSqlDb.Sync": "MigrateSqlServerSqlDbSyncTaskProperties",
            "Migrate.SqlServer.AzureSqlDbMI": "MigrateSqlServerSqlMITaskProperties",
            "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS": "MigrateSqlServerSqlMISyncTaskProperties",
            "Migrate.SqlServer.SqlDb": "MigrateSqlServerSqlDbTaskProperties",
            "Migrate.Ssis": "MigrateSsisTaskProperties",
            "MigrateSchemaSqlServerSqlDb": "MigrateSchemaSqlServerSqlDbTaskProperties",
            "Service.Check.OCI": "CheckOCIDriverTaskProperties",
            "Service.Install.OCI": "InstallOCIDriverTaskProperties",
            "Service.Upload.OCI": "UploadOCIDriverTaskProperties",
            "Validate.MongoDb": "ValidateMongoDbTaskProperties",
            "Validate.Oracle.AzureDbPostgreSql.Sync": "ValidateOracleAzureDbForPostgreSqlSyncTaskProperties",
            "ValidateMigrationInput.SqlServer.AzureSqlDbMI": "ValidateMigrationInputSqlServerSqlMITaskProperties",
            "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS": "ValidateMigrationInputSqlServerSqlMISyncTaskProperties",
            "ValidateMigrationInput.SqlServer.SqlDb.Sync": "ValidateMigrationInputSqlServerSqlDbSyncTaskProperties",
        }
    }

    def __init__(self, *, client_data: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        """
        super().__init__(**kwargs)
        self.task_type: Optional[str] = None
        self.errors: Optional[List["_models.ODataError"]] = None
        self.state: Optional[Union[str, "_models.TaskState"]] = None
        self.commands: Optional[List["_models.CommandProperties"]] = None
        self.client_data = client_data


class CheckOCIDriverTaskProperties(ProjectTaskProperties):
    """Properties for the task that checks for OCI drivers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Input for the service task to check for OCI drivers.
    :vartype input: ~azure.mgmt.datamigration.models.CheckOCIDriverTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.CheckOCIDriverTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "CheckOCIDriverTaskInput"},
        "output": {"key": "output", "type": "[CheckOCIDriverTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.CheckOCIDriverTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Input for the service task to check for OCI drivers.
        :paramtype input: ~azure.mgmt.datamigration.models.CheckOCIDriverTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Service.Check.OCI"
        self.input = input
        self.output: Optional[List["_models.CheckOCIDriverTaskOutput"]] = None


class CommandProperties(_serialization.Model):
    """Base class for all types of DMS (classic) command properties. If command is not supported by
    current client, this object is returned.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MigrateMISyncCompleteCommandProperties, MigrateSyncCompleteCommandProperties,
    MongoDbCancelCommand, MongoDbFinishCommand, MongoDbRestartCommand

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar command_type: Command type. Required. Known values are: "Migrate.Sync.Complete.Database",
     "Migrate.SqlServer.AzureDbSqlMi.Complete", "cancel", "finish", and "restart".
    :vartype command_type: str or ~azure.mgmt.datamigration.models.CommandType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the command. This is ignored if submitted. Known values are:
     "Unknown", "Accepted", "Running", "Succeeded", and "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.CommandState
    """

    _validation = {
        "command_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "command_type": {"key": "commandType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
    }

    _subtype_map = {
        "command_type": {
            "Migrate.SqlServer.AzureDbSqlMi.Complete": "MigrateMISyncCompleteCommandProperties",
            "Migrate.Sync.Complete.Database": "MigrateSyncCompleteCommandProperties",
            "cancel": "MongoDbCancelCommand",
            "finish": "MongoDbFinishCommand",
            "restart": "MongoDbRestartCommand",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.command_type: Optional[str] = None
        self.errors: Optional[List["_models.ODataError"]] = None
        self.state: Optional[Union[str, "_models.CommandState"]] = None


class ConnectionInfo(_serialization.Model):
    """Defines the connection properties of a server.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MiSqlConnectionInfo, MongoDbConnectionInfo, MySqlConnectionInfo, OracleConnectionInfo,
    PostgreSqlConnectionInfo, SqlConnectionInfo

    All required parameters must be populated in order to send to server.

    :ivar type: Type of connection info. Required.
    :vartype type: str
    :ivar user_name: User name.
    :vartype user_name: str
    :ivar password: Password credential.
    :vartype password: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "MiSqlConnectionInfo": "MiSqlConnectionInfo",
            "MongoDbConnectionInfo": "MongoDbConnectionInfo",
            "MySqlConnectionInfo": "MySqlConnectionInfo",
            "OracleConnectionInfo": "OracleConnectionInfo",
            "PostgreSqlConnectionInfo": "PostgreSqlConnectionInfo",
            "SqlConnectionInfo": "SqlConnectionInfo",
        }
    }

    def __init__(self, *, user_name: Optional[str] = None, password: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword user_name: User name.
        :paramtype user_name: str
        :keyword password: Password credential.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.user_name = user_name
        self.password = password


class ConnectToMongoDbTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates the connection to and provides information about a
    MongoDB server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Describes a connection to a MongoDB data source.
    :vartype input: ~azure.mgmt.datamigration.models.MongoDbConnectionInfo
    :ivar output: An array containing a single MongoDbClusterInfo object.
    :vartype output: list[~azure.mgmt.datamigration.models.MongoDbClusterInfo]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "MongoDbConnectionInfo"},
        "output": {"key": "output", "type": "[MongoDbClusterInfo]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.MongoDbConnectionInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Describes a connection to a MongoDB data source.
        :paramtype input: ~azure.mgmt.datamigration.models.MongoDbConnectionInfo
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Connect.MongoDb"
        self.input = input
        self.output: Optional[List["_models.MongoDbClusterInfo"]] = None


class ConnectToSourceMySqlTaskInput(_serialization.Model):
    """Input for the task that validates MySQL database connection.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Information for connecting to MySQL source. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
    :ivar target_platform: Target Platform for the migration. Known values are: "SqlServer" and
     "AzureDbForMySQL".
    :vartype target_platform: str or ~azure.mgmt.datamigration.models.MySqlTargetPlatformType
    :ivar check_permissions_group: Permission group for validations. Known values are: "Default",
     "MigrationFromSqlServerToAzureDB", "MigrationFromSqlServerToAzureMI",
     "MigrationFromMySQLToAzureDBForMySQL", and "MigrationFromSqlServerToAzureVM".
    :vartype check_permissions_group: str or
     ~azure.mgmt.datamigration.models.ServerLevelPermissionsGroup
    :ivar is_offline_migration: Flag for whether or not the migration is offline.
    :vartype is_offline_migration: bool
    """

    _validation = {
        "source_connection_info": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "MySqlConnectionInfo"},
        "target_platform": {"key": "targetPlatform", "type": "str"},
        "check_permissions_group": {"key": "checkPermissionsGroup", "type": "str"},
        "is_offline_migration": {"key": "isOfflineMigration", "type": "bool"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.MySqlConnectionInfo",
        target_platform: Optional[Union[str, "_models.MySqlTargetPlatformType"]] = None,
        check_permissions_group: Optional[Union[str, "_models.ServerLevelPermissionsGroup"]] = None,
        is_offline_migration: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Information for connecting to MySQL source. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
        :keyword target_platform: Target Platform for the migration. Known values are: "SqlServer" and
         "AzureDbForMySQL".
        :paramtype target_platform: str or ~azure.mgmt.datamigration.models.MySqlTargetPlatformType
        :keyword check_permissions_group: Permission group for validations. Known values are:
         "Default", "MigrationFromSqlServerToAzureDB", "MigrationFromSqlServerToAzureMI",
         "MigrationFromMySQLToAzureDBForMySQL", and "MigrationFromSqlServerToAzureVM".
        :paramtype check_permissions_group: str or
         ~azure.mgmt.datamigration.models.ServerLevelPermissionsGroup
        :keyword is_offline_migration: Flag for whether or not the migration is offline.
        :paramtype is_offline_migration: bool
        """
        super().__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_platform = target_platform
        self.check_permissions_group = check_permissions_group
        self.is_offline_migration = is_offline_migration


class ConnectToSourceMySqlTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates MySQL database connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.ConnectToSourceMySqlTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToSourceNonSqlTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ConnectToSourceMySqlTaskInput"},
        "output": {"key": "output", "type": "[ConnectToSourceNonSqlTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ConnectToSourceMySqlTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.ConnectToSourceMySqlTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ConnectToSource.MySql"
        self.input = input
        self.output: Optional[List["_models.ConnectToSourceNonSqlTaskOutput"]] = None


class ConnectToSourceNonSqlTaskOutput(_serialization.Model):
    """Output for connect to MySQL type source.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar source_server_brand_version: Server brand version.
    :vartype source_server_brand_version: str
    :ivar server_properties: Server properties.
    :vartype server_properties: ~azure.mgmt.datamigration.models.ServerProperties
    :ivar databases: List of databases on the server.
    :vartype databases: list[str]
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "source_server_brand_version": {"readonly": True},
        "server_properties": {"readonly": True},
        "databases": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "source_server_brand_version": {"key": "sourceServerBrandVersion", "type": "str"},
        "server_properties": {"key": "serverProperties", "type": "ServerProperties"},
        "databases": {"key": "databases", "type": "[str]"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.source_server_brand_version: Optional[str] = None
        self.server_properties: Optional["_models.ServerProperties"] = None
        self.databases: Optional[List[str]] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class ConnectToSourceOracleSyncTaskInput(_serialization.Model):
    """Input for the task that validates Oracle database connection.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Information for connecting to Oracle source. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.OracleConnectionInfo
    """

    _validation = {
        "source_connection_info": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "OracleConnectionInfo"},
    }

    def __init__(self, *, source_connection_info: "_models.OracleConnectionInfo", **kwargs: Any) -> None:
        """
        :keyword source_connection_info: Information for connecting to Oracle source. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.OracleConnectionInfo
        """
        super().__init__(**kwargs)
        self.source_connection_info = source_connection_info


class ConnectToSourceOracleSyncTaskOutput(_serialization.Model):
    """Output for the task that validates Oracle database connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source_server_version: Version of the source server.
    :vartype source_server_version: str
    :ivar databases: List of schemas on source server.
    :vartype databases: list[str]
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "source_server_version": {"readonly": True},
        "databases": {"readonly": True},
        "source_server_brand_version": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "source_server_version": {"key": "sourceServerVersion", "type": "str"},
        "databases": {"key": "databases", "type": "[str]"},
        "source_server_brand_version": {"key": "sourceServerBrandVersion", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.source_server_version: Optional[str] = None
        self.databases: Optional[List[str]] = None
        self.source_server_brand_version: Optional[str] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class ConnectToSourceOracleSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates Oracle database connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.ConnectToSourceOracleSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToSourceOracleSyncTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ConnectToSourceOracleSyncTaskInput"},
        "output": {"key": "output", "type": "[ConnectToSourceOracleSyncTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ConnectToSourceOracleSyncTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.ConnectToSourceOracleSyncTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ConnectToSource.Oracle.Sync"
        self.input = input
        self.output: Optional[List["_models.ConnectToSourceOracleSyncTaskOutput"]] = None


class ConnectToSourcePostgreSqlSyncTaskInput(_serialization.Model):
    """Input for the task that validates connection to PostgreSQL and source server requirements.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Connection information for source PostgreSQL server. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    """

    _validation = {
        "source_connection_info": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "PostgreSqlConnectionInfo"},
    }

    def __init__(self, *, source_connection_info: "_models.PostgreSqlConnectionInfo", **kwargs: Any) -> None:
        """
        :keyword source_connection_info: Connection information for source PostgreSQL server. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
        """
        super().__init__(**kwargs)
        self.source_connection_info = source_connection_info


class ConnectToSourcePostgreSqlSyncTaskOutput(_serialization.Model):
    """Output for the task that validates connection to PostgreSQL and source server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar source_server_version: Version of the source server.
    :vartype source_server_version: str
    :ivar databases: List of databases on source server.
    :vartype databases: list[str]
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "source_server_version": {"readonly": True},
        "databases": {"readonly": True},
        "source_server_brand_version": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "source_server_version": {"key": "sourceServerVersion", "type": "str"},
        "databases": {"key": "databases", "type": "[str]"},
        "source_server_brand_version": {"key": "sourceServerBrandVersion", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.source_server_version: Optional[str] = None
        self.databases: Optional[List[str]] = None
        self.source_server_brand_version: Optional[str] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class ConnectToSourcePostgreSqlSyncTaskProperties(ProjectTaskProperties):  # pylint: disable=name-too-long
    """Properties for the task that validates connection to PostgreSQL server and source server
    requirements for online migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.ConnectToSourcePostgreSqlSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToSourcePostgreSqlSyncTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ConnectToSourcePostgreSqlSyncTaskInput"},
        "output": {"key": "output", "type": "[ConnectToSourcePostgreSqlSyncTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ConnectToSourcePostgreSqlSyncTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.ConnectToSourcePostgreSqlSyncTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ConnectToSource.PostgreSql.Sync"
        self.input = input
        self.output: Optional[List["_models.ConnectToSourcePostgreSqlSyncTaskOutput"]] = None


class ConnectToSourceSqlServerSyncTaskProperties(ProjectTaskProperties):  # pylint: disable=name-too-long
    """Properties for the task that validates connection to SQL Server and source server requirements
    for online migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.ConnectToSourceSqlServerTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToSourceSqlServerTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ConnectToSourceSqlServerTaskInput"},
        "output": {"key": "output", "type": "[ConnectToSourceSqlServerTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ConnectToSourceSqlServerTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.ConnectToSourceSqlServerTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ConnectToSource.SqlServer.Sync"
        self.input = input
        self.output: Optional[List["_models.ConnectToSourceSqlServerTaskOutput"]] = None


class ConnectToSourceSqlServerTaskInput(_serialization.Model):
    """Input for the task that validates connection to SQL Server and also validates source server
    requirements.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Connection information for Source SQL Server. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar check_permissions_group: Permission group for validations. Known values are: "Default",
     "MigrationFromSqlServerToAzureDB", "MigrationFromSqlServerToAzureMI",
     "MigrationFromMySQLToAzureDBForMySQL", and "MigrationFromSqlServerToAzureVM".
    :vartype check_permissions_group: str or
     ~azure.mgmt.datamigration.models.ServerLevelPermissionsGroup
    :ivar collect_databases: Flag for whether to collect databases from source server.
    :vartype collect_databases: bool
    :ivar collect_logins: Flag for whether to collect logins from source server.
    :vartype collect_logins: bool
    :ivar collect_agent_jobs: Flag for whether to collect agent jobs from source server.
    :vartype collect_agent_jobs: bool
    :ivar collect_tde_certificate_info: Flag for whether to collect TDE Certificate names from
     source server.
    :vartype collect_tde_certificate_info: bool
    :ivar validate_ssis_catalog_only: Flag for whether to validate SSIS catalog is reachable on the
     source server.
    :vartype validate_ssis_catalog_only: bool
    :ivar encrypted_key_for_secure_fields: encrypted key for secure fields.
    :vartype encrypted_key_for_secure_fields: str
    """

    _validation = {
        "source_connection_info": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "SqlConnectionInfo"},
        "check_permissions_group": {"key": "checkPermissionsGroup", "type": "str"},
        "collect_databases": {"key": "collectDatabases", "type": "bool"},
        "collect_logins": {"key": "collectLogins", "type": "bool"},
        "collect_agent_jobs": {"key": "collectAgentJobs", "type": "bool"},
        "collect_tde_certificate_info": {"key": "collectTdeCertificateInfo", "type": "bool"},
        "validate_ssis_catalog_only": {"key": "validateSsisCatalogOnly", "type": "bool"},
        "encrypted_key_for_secure_fields": {"key": "encryptedKeyForSecureFields", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.SqlConnectionInfo",
        check_permissions_group: Optional[Union[str, "_models.ServerLevelPermissionsGroup"]] = None,
        collect_databases: bool = True,
        collect_logins: bool = False,
        collect_agent_jobs: bool = False,
        collect_tde_certificate_info: bool = False,
        validate_ssis_catalog_only: bool = False,
        encrypted_key_for_secure_fields: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Connection information for Source SQL Server. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword check_permissions_group: Permission group for validations. Known values are:
         "Default", "MigrationFromSqlServerToAzureDB", "MigrationFromSqlServerToAzureMI",
         "MigrationFromMySQLToAzureDBForMySQL", and "MigrationFromSqlServerToAzureVM".
        :paramtype check_permissions_group: str or
         ~azure.mgmt.datamigration.models.ServerLevelPermissionsGroup
        :keyword collect_databases: Flag for whether to collect databases from source server.
        :paramtype collect_databases: bool
        :keyword collect_logins: Flag for whether to collect logins from source server.
        :paramtype collect_logins: bool
        :keyword collect_agent_jobs: Flag for whether to collect agent jobs from source server.
        :paramtype collect_agent_jobs: bool
        :keyword collect_tde_certificate_info: Flag for whether to collect TDE Certificate names from
         source server.
        :paramtype collect_tde_certificate_info: bool
        :keyword validate_ssis_catalog_only: Flag for whether to validate SSIS catalog is reachable on
         the source server.
        :paramtype validate_ssis_catalog_only: bool
        :keyword encrypted_key_for_secure_fields: encrypted key for secure fields.
        :paramtype encrypted_key_for_secure_fields: str
        """
        super().__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.check_permissions_group = check_permissions_group
        self.collect_databases = collect_databases
        self.collect_logins = collect_logins
        self.collect_agent_jobs = collect_agent_jobs
        self.collect_tde_certificate_info = collect_tde_certificate_info
        self.validate_ssis_catalog_only = validate_ssis_catalog_only
        self.encrypted_key_for_secure_fields = encrypted_key_for_secure_fields


class ConnectToSourceSqlServerTaskOutput(_serialization.Model):
    """Output for the task that validates connection to SQL Server and also validates source server
    requirements.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConnectToSourceSqlServerTaskOutputAgentJobLevel,
    ConnectToSourceSqlServerTaskOutputDatabaseLevel, ConnectToSourceSqlServerTaskOutputLoginLevel,
    ConnectToSourceSqlServerTaskOutputTaskLevel

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Type of result - database level or task level. Required.
    :vartype result_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
    }

    _subtype_map = {
        "result_type": {
            "AgentJobLevelOutput": "ConnectToSourceSqlServerTaskOutputAgentJobLevel",
            "DatabaseLevelOutput": "ConnectToSourceSqlServerTaskOutputDatabaseLevel",
            "LoginLevelOutput": "ConnectToSourceSqlServerTaskOutputLoginLevel",
            "TaskLevelOutput": "ConnectToSourceSqlServerTaskOutputTaskLevel",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.result_type: Optional[str] = None


class ConnectToSourceSqlServerTaskOutputAgentJobLevel(
    ConnectToSourceSqlServerTaskOutput
):  # pylint: disable=name-too-long
    """Agent Job level output for the task that validates connection to SQL Server and also validates
    source server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Type of result - database level or task level. Required.
    :vartype result_type: str
    :ivar name: Agent Job name.
    :vartype name: str
    :ivar job_category: The type of Agent Job.
    :vartype job_category: str
    :ivar is_enabled: The state of the original Agent Job.
    :vartype is_enabled: bool
    :ivar job_owner: The owner of the Agent Job.
    :vartype job_owner: str
    :ivar last_executed_on: UTC Date and time when the Agent Job was last executed.
    :vartype last_executed_on: ~datetime.datetime
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar migration_eligibility: Information about eligibility of agent job for migration.
    :vartype migration_eligibility: ~azure.mgmt.datamigration.models.MigrationEligibilityInfo
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "name": {"readonly": True},
        "job_category": {"readonly": True},
        "is_enabled": {"readonly": True},
        "job_owner": {"readonly": True},
        "last_executed_on": {"readonly": True},
        "validation_errors": {"readonly": True},
        "migration_eligibility": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "job_category": {"key": "jobCategory", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "job_owner": {"key": "jobOwner", "type": "str"},
        "last_executed_on": {"key": "lastExecutedOn", "type": "iso-8601"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
        "migration_eligibility": {"key": "migrationEligibility", "type": "MigrationEligibilityInfo"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "AgentJobLevelOutput"
        self.name: Optional[str] = None
        self.job_category: Optional[str] = None
        self.is_enabled: Optional[bool] = None
        self.job_owner: Optional[str] = None
        self.last_executed_on: Optional[datetime.datetime] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None
        self.migration_eligibility: Optional["_models.MigrationEligibilityInfo"] = None


class ConnectToSourceSqlServerTaskOutputDatabaseLevel(
    ConnectToSourceSqlServerTaskOutput
):  # pylint: disable=name-too-long
    """Database level output for the task that validates connection to SQL Server and also validates
    source server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Type of result - database level or task level. Required.
    :vartype result_type: str
    :ivar name: Database name.
    :vartype name: str
    :ivar size_mb: Size of the file in megabytes.
    :vartype size_mb: float
    :ivar database_files: The list of database files.
    :vartype database_files: list[~azure.mgmt.datamigration.models.DatabaseFileInfo]
    :ivar compatibility_level: SQL Server compatibility level of database. Known values are:
     "CompatLevel80", "CompatLevel90", "CompatLevel100", "CompatLevel110", "CompatLevel120",
     "CompatLevel130", and "CompatLevel140".
    :vartype compatibility_level: str or ~azure.mgmt.datamigration.models.DatabaseCompatLevel
    :ivar database_state: State of the database. Known values are: "Online", "Restoring",
     "Recovering", "RecoveryPending", "Suspect", "Emergency", "Offline", "Copying", and
     "OfflineSecondary".
    :vartype database_state: str or ~azure.mgmt.datamigration.models.DatabaseState
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "name": {"readonly": True},
        "size_mb": {"readonly": True},
        "database_files": {"readonly": True},
        "compatibility_level": {"readonly": True},
        "database_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "size_mb": {"key": "sizeMB", "type": "float"},
        "database_files": {"key": "databaseFiles", "type": "[DatabaseFileInfo]"},
        "compatibility_level": {"key": "compatibilityLevel", "type": "str"},
        "database_state": {"key": "databaseState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "DatabaseLevelOutput"
        self.name: Optional[str] = None
        self.size_mb: Optional[float] = None
        self.database_files: Optional[List["_models.DatabaseFileInfo"]] = None
        self.compatibility_level: Optional[Union[str, "_models.DatabaseCompatLevel"]] = None
        self.database_state: Optional[Union[str, "_models.DatabaseState"]] = None


class ConnectToSourceSqlServerTaskOutputLoginLevel(ConnectToSourceSqlServerTaskOutput):  # pylint: disable=name-too-long
    """Login level output for the task that validates connection to SQL Server and also validates
    source server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Type of result - database level or task level. Required.
    :vartype result_type: str
    :ivar name: Login name.
    :vartype name: str
    :ivar login_type: The type of login. Known values are: "WindowsUser", "WindowsGroup",
     "SqlLogin", "Certificate", "AsymmetricKey", "ExternalUser", and "ExternalGroup".
    :vartype login_type: str or ~azure.mgmt.datamigration.models.LoginType
    :ivar default_database: The default database for the login.
    :vartype default_database: str
    :ivar is_enabled: The state of the login.
    :vartype is_enabled: bool
    :ivar migration_eligibility: Information about eligibility of login for migration.
    :vartype migration_eligibility: ~azure.mgmt.datamigration.models.MigrationEligibilityInfo
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "name": {"readonly": True},
        "login_type": {"readonly": True},
        "default_database": {"readonly": True},
        "is_enabled": {"readonly": True},
        "migration_eligibility": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "login_type": {"key": "loginType", "type": "str"},
        "default_database": {"key": "defaultDatabase", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "migration_eligibility": {"key": "migrationEligibility", "type": "MigrationEligibilityInfo"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "LoginLevelOutput"
        self.name: Optional[str] = None
        self.login_type: Optional[Union[str, "_models.LoginType"]] = None
        self.default_database: Optional[str] = None
        self.is_enabled: Optional[bool] = None
        self.migration_eligibility: Optional["_models.MigrationEligibilityInfo"] = None


class ConnectToSourceSqlServerTaskOutputTaskLevel(ConnectToSourceSqlServerTaskOutput):  # pylint: disable=name-too-long
    """Task level output for the task that validates connection to SQL Server and also validates
    source server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Type of result - database level or task level. Required.
    :vartype result_type: str
    :ivar databases: Source databases as a map from database name to database id.
    :vartype databases: str
    :ivar logins: Source logins as a map from login name to login id.
    :vartype logins: str
    :ivar agent_jobs: Source agent jobs as a map from agent job name to id.
    :vartype agent_jobs: str
    :ivar database_tde_certificate_mapping: Mapping from database name to TDE certificate name, if
     applicable.
    :vartype database_tde_certificate_mapping: str
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "databases": {"readonly": True},
        "logins": {"readonly": True},
        "agent_jobs": {"readonly": True},
        "database_tde_certificate_mapping": {"readonly": True},
        "source_server_version": {"readonly": True},
        "source_server_brand_version": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "databases": {"key": "databases", "type": "str"},
        "logins": {"key": "logins", "type": "str"},
        "agent_jobs": {"key": "agentJobs", "type": "str"},
        "database_tde_certificate_mapping": {"key": "databaseTdeCertificateMapping", "type": "str"},
        "source_server_version": {"key": "sourceServerVersion", "type": "str"},
        "source_server_brand_version": {"key": "sourceServerBrandVersion", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "TaskLevelOutput"
        self.databases: Optional[str] = None
        self.logins: Optional[str] = None
        self.agent_jobs: Optional[str] = None
        self.database_tde_certificate_mapping: Optional[str] = None
        self.source_server_version: Optional[str] = None
        self.source_server_brand_version: Optional[str] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class ConnectToSourceSqlServerTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to SQL Server and also validates source
    server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.ConnectToSourceSqlServerTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToSourceSqlServerTaskOutput]
    :ivar task_id: Task id.
    :vartype task_id: str
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ConnectToSourceSqlServerTaskInput"},
        "output": {"key": "output", "type": "[ConnectToSourceSqlServerTaskOutput]"},
        "task_id": {"key": "taskId", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ConnectToSourceSqlServerTaskInput"] = None,
        task_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.ConnectToSourceSqlServerTaskInput
        :keyword task_id: Task id.
        :paramtype task_id: str
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ConnectToSource.SqlServer"
        self.input = input
        self.output: Optional[List["_models.ConnectToSourceSqlServerTaskOutput"]] = None
        self.task_id = task_id


class ConnectToTargetAzureDbForMySqlTaskInput(_serialization.Model):
    """Input for the task that validates connection to Azure Database for MySQL and target server
    requirements.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Connection information for source MySQL server. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
    :ivar target_connection_info: Connection information for target Azure Database for MySQL
     server. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
    :ivar is_offline_migration: Flag for whether or not the migration is offline.
    :vartype is_offline_migration: bool
    """

    _validation = {
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "MySqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "MySqlConnectionInfo"},
        "is_offline_migration": {"key": "isOfflineMigration", "type": "bool"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.MySqlConnectionInfo",
        target_connection_info: "_models.MySqlConnectionInfo",
        is_offline_migration: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Connection information for source MySQL server. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
        :keyword target_connection_info: Connection information for target Azure Database for MySQL
         server. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
        :keyword is_offline_migration: Flag for whether or not the migration is offline.
        :paramtype is_offline_migration: bool
        """
        super().__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info
        self.is_offline_migration = is_offline_migration


class ConnectToTargetAzureDbForMySqlTaskOutput(_serialization.Model):
    """Output for the task that validates connection to Azure Database for MySQL and target server
    requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar server_version: Version of the target server.
    :vartype server_version: str
    :ivar databases: List of databases on target server.
    :vartype databases: list[str]
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "server_version": {"readonly": True},
        "databases": {"readonly": True},
        "target_server_brand_version": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "server_version": {"key": "serverVersion", "type": "str"},
        "databases": {"key": "databases", "type": "[str]"},
        "target_server_brand_version": {"key": "targetServerBrandVersion", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.server_version: Optional[str] = None
        self.databases: Optional[List[str]] = None
        self.target_server_brand_version: Optional[str] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class ConnectToTargetAzureDbForMySqlTaskProperties(ProjectTaskProperties):  # pylint: disable=name-too-long
    """Properties for the task that validates connection to Azure Database for MySQL and target server
    requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.ConnectToTargetAzureDbForMySqlTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.ConnectToTargetAzureDbForMySqlTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ConnectToTargetAzureDbForMySqlTaskInput"},
        "output": {"key": "output", "type": "[ConnectToTargetAzureDbForMySqlTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ConnectToTargetAzureDbForMySqlTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.ConnectToTargetAzureDbForMySqlTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ConnectToTarget.AzureDbForMySql"
        self.input = input
        self.output: Optional[List["_models.ConnectToTargetAzureDbForMySqlTaskOutput"]] = None


class ConnectToTargetAzureDbForPostgreSqlSyncTaskInput(_serialization.Model):  # pylint: disable=name-too-long
    """Input for the task that validates connection to Azure Database for PostgreSQL and target server
    requirements.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Connection information for source PostgreSQL server. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    :ivar target_connection_info: Connection information for target Azure Database for PostgreSQL
     server. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    """

    _validation = {
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "PostgreSqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "PostgreSqlConnectionInfo"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.PostgreSqlConnectionInfo",
        target_connection_info: "_models.PostgreSqlConnectionInfo",
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Connection information for source PostgreSQL server. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
        :keyword target_connection_info: Connection information for target Azure Database for
         PostgreSQL server. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
        """
        super().__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info


class ConnectToTargetAzureDbForPostgreSqlSyncTaskOutput(_serialization.Model):  # pylint: disable=name-too-long
    """Output for the task that validates connection to Azure Database for PostgreSQL and target
    server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar target_server_version: Version of the target server.
    :vartype target_server_version: str
    :ivar databases: List of databases on target server.
    :vartype databases: list[str]
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "target_server_version": {"readonly": True},
        "databases": {"readonly": True},
        "target_server_brand_version": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "databases": {"key": "databases", "type": "[str]"},
        "target_server_brand_version": {"key": "targetServerBrandVersion", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.target_server_version: Optional[str] = None
        self.databases: Optional[List[str]] = None
        self.target_server_brand_version: Optional[str] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class ConnectToTargetAzureDbForPostgreSqlSyncTaskProperties(ProjectTaskProperties):  # pylint: disable=name-too-long
    """Properties for the task that validates connection to Azure Database For PostgreSQL server and
    target server requirements for online migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input:
     ~azure.mgmt.datamigration.models.ConnectToTargetAzureDbForPostgreSqlSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.ConnectToTargetAzureDbForPostgreSqlSyncTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ConnectToTargetAzureDbForPostgreSqlSyncTaskInput"},
        "output": {"key": "output", "type": "[ConnectToTargetAzureDbForPostgreSqlSyncTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ConnectToTargetAzureDbForPostgreSqlSyncTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input:
         ~azure.mgmt.datamigration.models.ConnectToTargetAzureDbForPostgreSqlSyncTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ConnectToTarget.AzureDbForPostgreSql.Sync"
        self.input = input
        self.output: Optional[List["_models.ConnectToTargetAzureDbForPostgreSqlSyncTaskOutput"]] = None


class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInput(_serialization.Model):  # pylint: disable=name-too-long
    """Input for the task that validates connection to Azure Database for PostgreSQL and target server
    requirements for Oracle source.

    All required parameters must be populated in order to send to server.

    :ivar target_connection_info: Connection information for target Azure Database for PostgreSQL
     server. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    """

    _validation = {
        "target_connection_info": {"required": True},
    }

    _attribute_map = {
        "target_connection_info": {"key": "targetConnectionInfo", "type": "PostgreSqlConnectionInfo"},
    }

    def __init__(self, *, target_connection_info: "_models.PostgreSqlConnectionInfo", **kwargs: Any) -> None:
        """
        :keyword target_connection_info: Connection information for target Azure Database for
         PostgreSQL server. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
        """
        super().__init__(**kwargs)
        self.target_connection_info = target_connection_info


class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutput(_serialization.Model):  # pylint: disable=name-too-long
    """Output for the task that validates connection to Azure Database for PostgreSQL and target
    server requirements for Oracle source.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_server_version: Version of the target server.
    :vartype target_server_version: str
    :ivar databases: List of databases on target server.
    :vartype databases: list[str]
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar database_schema_map: Mapping of schemas per database.
    :vartype database_schema_map:
     list[~azure.mgmt.datamigration.models.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem]
    """

    _validation = {
        "target_server_version": {"readonly": True},
        "databases": {"readonly": True},
        "target_server_brand_version": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "databases": {"key": "databases", "type": "[str]"},
        "target_server_brand_version": {"key": "targetServerBrandVersion", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
        "database_schema_map": {
            "key": "databaseSchemaMap",
            "type": "[ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem]",
        },
    }

    def __init__(
        self,
        *,
        database_schema_map: Optional[
            List["_models.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem"]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword database_schema_map: Mapping of schemas per database.
        :paramtype database_schema_map:
         list[~azure.mgmt.datamigration.models.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem]
        """
        super().__init__(**kwargs)
        self.target_server_version: Optional[str] = None
        self.databases: Optional[List[str]] = None
        self.target_server_brand_version: Optional[str] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None
        self.database_schema_map = database_schema_map


class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem(
    _serialization.Model
):  # pylint: disable=name-too-long
    """ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem.

    :ivar database:
    :vartype database: str
    :ivar schemas:
    :vartype schemas: list[str]
    """

    _attribute_map = {
        "database": {"key": "database", "type": "str"},
        "schemas": {"key": "schemas", "type": "[str]"},
    }

    def __init__(self, *, database: Optional[str] = None, schemas: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword database:
        :paramtype database: str
        :keyword schemas:
        :paramtype schemas: list[str]
        """
        super().__init__(**kwargs)
        self.database = database
        self.schemas = schemas


class ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskProperties(
    ProjectTaskProperties
):  # pylint: disable=name-too-long
    """Properties for the task that validates connection to Azure Database For PostgreSQL server and
    target server requirements for online migration for Oracle source.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input:
     ~azure.mgmt.datamigration.models.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInput"},
        "output": {"key": "output", "type": "[ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input:
         ~azure.mgmt.datamigration.models.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync"
        self.input = input
        self.output: Optional[List["_models.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskOutput"]] = None


class ConnectToTargetSqlDbSyncTaskInput(_serialization.Model):
    """Input for the task that validates connection to Azure SQL DB and target server requirements.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Connection information for source SQL Server. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar target_connection_info: Connection information for target SQL DB. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    """

    _validation = {
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "SqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "SqlConnectionInfo"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.SqlConnectionInfo",
        target_connection_info: "_models.SqlConnectionInfo",
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Connection information for source SQL Server. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword target_connection_info: Connection information for target SQL DB. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        """
        super().__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info


class ConnectToTargetSqlDbSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to SQL DB and target server requirements for
    online migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.ConnectToTargetSqlDbSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToTargetSqlDbTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ConnectToTargetSqlDbSyncTaskInput"},
        "output": {"key": "output", "type": "[ConnectToTargetSqlDbTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ConnectToTargetSqlDbSyncTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.ConnectToTargetSqlDbSyncTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ConnectToTarget.SqlDb.Sync"
        self.input = input
        self.output: Optional[List["_models.ConnectToTargetSqlDbTaskOutput"]] = None


class ConnectToTargetSqlDbTaskInput(_serialization.Model):
    """Input for the task that validates connection to SQL DB and target server requirements.

    All required parameters must be populated in order to send to server.

    :ivar target_connection_info: Connection information for target SQL DB. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar query_object_counts: Boolean flag indicating whether to query object counts for each
     database on the target server.
    :vartype query_object_counts: bool
    """

    _validation = {
        "target_connection_info": {"required": True},
    }

    _attribute_map = {
        "target_connection_info": {"key": "targetConnectionInfo", "type": "SqlConnectionInfo"},
        "query_object_counts": {"key": "queryObjectCounts", "type": "bool"},
    }

    def __init__(
        self,
        *,
        target_connection_info: "_models.SqlConnectionInfo",
        query_object_counts: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_connection_info: Connection information for target SQL DB. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword query_object_counts: Boolean flag indicating whether to query object counts for each
         database on the target server.
        :paramtype query_object_counts: bool
        """
        super().__init__(**kwargs)
        self.target_connection_info = target_connection_info
        self.query_object_counts = query_object_counts


class ConnectToTargetSqlDbTaskOutput(_serialization.Model):
    """Output for the task that validates connection to SQL DB and target server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar databases: Source databases as a map from database name to database id.
    :vartype databases: str
    :ivar target_server_version: Version of the target server.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    """

    _validation = {
        "id": {"readonly": True},
        "databases": {"readonly": True},
        "target_server_version": {"readonly": True},
        "target_server_brand_version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "databases": {"key": "databases", "type": "str"},
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "target_server_brand_version": {"key": "targetServerBrandVersion", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.databases: Optional[str] = None
        self.target_server_version: Optional[str] = None
        self.target_server_brand_version: Optional[str] = None


class ConnectToTargetSqlDbTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to SQL DB and target server requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.ConnectToTargetSqlDbTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToTargetSqlDbTaskOutput]
    :ivar created_on: DateTime in UTC when the task was created.
    :vartype created_on: str
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ConnectToTargetSqlDbTaskInput"},
        "output": {"key": "output", "type": "[ConnectToTargetSqlDbTaskOutput]"},
        "created_on": {"key": "createdOn", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ConnectToTargetSqlDbTaskInput"] = None,
        created_on: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.ConnectToTargetSqlDbTaskInput
        :keyword created_on: DateTime in UTC when the task was created.
        :paramtype created_on: str
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ConnectToTarget.SqlDb"
        self.input = input
        self.output: Optional[List["_models.ConnectToTargetSqlDbTaskOutput"]] = None
        self.created_on = created_on


class ConnectToTargetSqlMISyncTaskInput(_serialization.Model):
    """Input for the task that validates connection to Azure SQL Database Managed Instance online
    scenario.

    All required parameters must be populated in order to send to server.

    :ivar target_connection_info: Connection information for Azure SQL Database Managed Instance.
     Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.MiSqlConnectionInfo
    :ivar azure_app: Azure Active Directory Application the DMS (classic) instance will use to
     connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage
     Account. Required.
    :vartype azure_app: ~azure.mgmt.datamigration.models.AzureActiveDirectoryApp
    """

    _validation = {
        "target_connection_info": {"required": True},
        "azure_app": {"required": True},
    }

    _attribute_map = {
        "target_connection_info": {"key": "targetConnectionInfo", "type": "MiSqlConnectionInfo"},
        "azure_app": {"key": "azureApp", "type": "AzureActiveDirectoryApp"},
    }

    def __init__(
        self,
        *,
        target_connection_info: "_models.MiSqlConnectionInfo",
        azure_app: "_models.AzureActiveDirectoryApp",
        **kwargs: Any
    ) -> None:
        """
        :keyword target_connection_info: Connection information for Azure SQL Database Managed
         Instance. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.MiSqlConnectionInfo
        :keyword azure_app: Azure Active Directory Application the DMS (classic) instance will use to
         connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage
         Account. Required.
        :paramtype azure_app: ~azure.mgmt.datamigration.models.AzureActiveDirectoryApp
        """
        super().__init__(**kwargs)
        self.target_connection_info = target_connection_info
        self.azure_app = azure_app


class ConnectToTargetSqlMISyncTaskOutput(_serialization.Model):
    """Output for the task that validates connection to Azure SQL Database Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "target_server_version": {"readonly": True},
        "target_server_brand_version": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "target_server_brand_version": {"key": "targetServerBrandVersion", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.target_server_version: Optional[str] = None
        self.target_server_brand_version: Optional[str] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class ConnectToTargetSqlMISyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to Azure SQL Database Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.ConnectToTargetSqlMISyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToTargetSqlMISyncTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ConnectToTargetSqlMISyncTaskInput"},
        "output": {"key": "output", "type": "[ConnectToTargetSqlMISyncTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ConnectToTargetSqlMISyncTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.ConnectToTargetSqlMISyncTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ConnectToTarget.AzureSqlDbMI.Sync.LRS"
        self.input = input
        self.output: Optional[List["_models.ConnectToTargetSqlMISyncTaskOutput"]] = None


class ConnectToTargetSqlMITaskInput(_serialization.Model):
    """Input for the task that validates connection to Azure SQL Database Managed Instance.

    All required parameters must be populated in order to send to server.

    :ivar target_connection_info: Connection information for target SQL Server. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar collect_logins: Flag for whether to collect logins from target SQL MI server.
    :vartype collect_logins: bool
    :ivar collect_agent_jobs: Flag for whether to collect agent jobs from target SQL MI server.
    :vartype collect_agent_jobs: bool
    :ivar validate_ssis_catalog_only: Flag for whether to validate SSIS catalog is reachable on the
     target SQL MI server.
    :vartype validate_ssis_catalog_only: bool
    """

    _validation = {
        "target_connection_info": {"required": True},
    }

    _attribute_map = {
        "target_connection_info": {"key": "targetConnectionInfo", "type": "SqlConnectionInfo"},
        "collect_logins": {"key": "collectLogins", "type": "bool"},
        "collect_agent_jobs": {"key": "collectAgentJobs", "type": "bool"},
        "validate_ssis_catalog_only": {"key": "validateSsisCatalogOnly", "type": "bool"},
    }

    def __init__(
        self,
        *,
        target_connection_info: "_models.SqlConnectionInfo",
        collect_logins: bool = True,
        collect_agent_jobs: bool = True,
        validate_ssis_catalog_only: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_connection_info: Connection information for target SQL Server. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword collect_logins: Flag for whether to collect logins from target SQL MI server.
        :paramtype collect_logins: bool
        :keyword collect_agent_jobs: Flag for whether to collect agent jobs from target SQL MI server.
        :paramtype collect_agent_jobs: bool
        :keyword validate_ssis_catalog_only: Flag for whether to validate SSIS catalog is reachable on
         the target SQL MI server.
        :paramtype validate_ssis_catalog_only: bool
        """
        super().__init__(**kwargs)
        self.target_connection_info = target_connection_info
        self.collect_logins = collect_logins
        self.collect_agent_jobs = collect_agent_jobs
        self.validate_ssis_catalog_only = validate_ssis_catalog_only


class ConnectToTargetSqlMITaskOutput(_serialization.Model):
    """Output for the task that validates connection to Azure SQL Database Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar logins: List of logins on the target server.
    :vartype logins: list[str]
    :ivar agent_jobs: List of agent jobs on the target server.
    :vartype agent_jobs: list[str]
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "target_server_version": {"readonly": True},
        "target_server_brand_version": {"readonly": True},
        "logins": {"readonly": True},
        "agent_jobs": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "target_server_brand_version": {"key": "targetServerBrandVersion", "type": "str"},
        "logins": {"key": "logins", "type": "[str]"},
        "agent_jobs": {"key": "agentJobs", "type": "[str]"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.target_server_version: Optional[str] = None
        self.target_server_brand_version: Optional[str] = None
        self.logins: Optional[List[str]] = None
        self.agent_jobs: Optional[List[str]] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class ConnectToTargetSqlMITaskProperties(ProjectTaskProperties):
    """Properties for the task that validates connection to Azure SQL Database Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.ConnectToTargetSqlMITaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.ConnectToTargetSqlMITaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ConnectToTargetSqlMITaskInput"},
        "output": {"key": "output", "type": "[ConnectToTargetSqlMITaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ConnectToTargetSqlMITaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.ConnectToTargetSqlMITaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ConnectToTarget.AzureSqlDbMI"
        self.input = input
        self.output: Optional[List["_models.ConnectToTargetSqlMITaskOutput"]] = None


class CopyProgressDetails(_serialization.Model):
    """Details on progress of ADF copy activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar table_name: Table Name.
    :vartype table_name: str
    :ivar status: Status of the Copy activity (InProgress, Succeeded, Failed, Canceled).
    :vartype status: str
    :ivar parallel_copy_type: Type of parallel copy (Dynamic range, Physical partition, none).
    :vartype parallel_copy_type: str
    :ivar used_parallel_copies: The degree of parallelization.
    :vartype used_parallel_copies: int
    :ivar data_read: Bytes read.
    :vartype data_read: int
    :ivar data_written: Bytes written.
    :vartype data_written: int
    :ivar rows_read: Rows read.
    :vartype rows_read: int
    :ivar rows_copied: Rows Copied.
    :vartype rows_copied: int
    :ivar copy_start: Copy Start.
    :vartype copy_start: ~datetime.datetime
    :ivar copy_throughput: Copy throughput in KBps.
    :vartype copy_throughput: float
    :ivar copy_duration: Copy Duration in seconds.
    :vartype copy_duration: int
    """

    _validation = {
        "table_name": {"readonly": True},
        "status": {"readonly": True},
        "parallel_copy_type": {"readonly": True},
        "used_parallel_copies": {"readonly": True},
        "data_read": {"readonly": True},
        "data_written": {"readonly": True},
        "rows_read": {"readonly": True},
        "rows_copied": {"readonly": True},
        "copy_start": {"readonly": True},
        "copy_throughput": {"readonly": True},
        "copy_duration": {"readonly": True},
    }

    _attribute_map = {
        "table_name": {"key": "tableName", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "parallel_copy_type": {"key": "parallelCopyType", "type": "str"},
        "used_parallel_copies": {"key": "usedParallelCopies", "type": "int"},
        "data_read": {"key": "dataRead", "type": "int"},
        "data_written": {"key": "dataWritten", "type": "int"},
        "rows_read": {"key": "rowsRead", "type": "int"},
        "rows_copied": {"key": "rowsCopied", "type": "int"},
        "copy_start": {"key": "copyStart", "type": "iso-8601"},
        "copy_throughput": {"key": "copyThroughput", "type": "float"},
        "copy_duration": {"key": "copyDuration", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.table_name: Optional[str] = None
        self.status: Optional[str] = None
        self.parallel_copy_type: Optional[str] = None
        self.used_parallel_copies: Optional[int] = None
        self.data_read: Optional[int] = None
        self.data_written: Optional[int] = None
        self.rows_read: Optional[int] = None
        self.rows_copied: Optional[int] = None
        self.copy_start: Optional[datetime.datetime] = None
        self.copy_throughput: Optional[float] = None
        self.copy_duration: Optional[int] = None


class Database(_serialization.Model):
    """Information about a single database.

    :ivar id: Unique identifier for the database.
    :vartype id: str
    :ivar name: Name of the database.
    :vartype name: str
    :ivar compatibility_level: SQL Server compatibility level of database. Known values are:
     "CompatLevel80", "CompatLevel90", "CompatLevel100", "CompatLevel110", "CompatLevel120",
     "CompatLevel130", and "CompatLevel140".
    :vartype compatibility_level: str or ~azure.mgmt.datamigration.models.DatabaseCompatLevel
    :ivar collation: Collation name of the database.
    :vartype collation: str
    :ivar server_name: Name of the server.
    :vartype server_name: str
    :ivar fqdn: Fully qualified name.
    :vartype fqdn: str
    :ivar install_id: Install id of the database.
    :vartype install_id: str
    :ivar server_version: Version of the server.
    :vartype server_version: str
    :ivar server_edition: Edition of the server.
    :vartype server_edition: str
    :ivar server_level: Product level of the server (RTM, SP, CTP).
    :vartype server_level: str
    :ivar server_default_data_path: Default path of the data files.
    :vartype server_default_data_path: str
    :ivar server_default_log_path: Default path of the log files.
    :vartype server_default_log_path: str
    :ivar server_default_backup_path: Default path of the backup folder.
    :vartype server_default_backup_path: str
    :ivar server_core_count: Number of cores on the server.
    :vartype server_core_count: int
    :ivar server_visible_online_core_count: Number of cores on the server that have VISIBLE ONLINE
     status.
    :vartype server_visible_online_core_count: int
    :ivar database_state: State of the database. Known values are: "Online", "Restoring",
     "Recovering", "RecoveryPending", "Suspect", "Emergency", "Offline", "Copying", and
     "OfflineSecondary".
    :vartype database_state: str or ~azure.mgmt.datamigration.models.DatabaseState
    :ivar server_id: The unique Server Id.
    :vartype server_id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "compatibility_level": {"key": "compatibilityLevel", "type": "str"},
        "collation": {"key": "collation", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "install_id": {"key": "installId", "type": "str"},
        "server_version": {"key": "serverVersion", "type": "str"},
        "server_edition": {"key": "serverEdition", "type": "str"},
        "server_level": {"key": "serverLevel", "type": "str"},
        "server_default_data_path": {"key": "serverDefaultDataPath", "type": "str"},
        "server_default_log_path": {"key": "serverDefaultLogPath", "type": "str"},
        "server_default_backup_path": {"key": "serverDefaultBackupPath", "type": "str"},
        "server_core_count": {"key": "serverCoreCount", "type": "int"},
        "server_visible_online_core_count": {"key": "serverVisibleOnlineCoreCount", "type": "int"},
        "database_state": {"key": "databaseState", "type": "str"},
        "server_id": {"key": "serverId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        compatibility_level: Optional[Union[str, "_models.DatabaseCompatLevel"]] = None,
        collation: Optional[str] = None,
        server_name: Optional[str] = None,
        fqdn: Optional[str] = None,
        install_id: Optional[str] = None,
        server_version: Optional[str] = None,
        server_edition: Optional[str] = None,
        server_level: Optional[str] = None,
        server_default_data_path: Optional[str] = None,
        server_default_log_path: Optional[str] = None,
        server_default_backup_path: Optional[str] = None,
        server_core_count: Optional[int] = None,
        server_visible_online_core_count: Optional[int] = None,
        database_state: Optional[Union[str, "_models.DatabaseState"]] = None,
        server_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Unique identifier for the database.
        :paramtype id: str
        :keyword name: Name of the database.
        :paramtype name: str
        :keyword compatibility_level: SQL Server compatibility level of database. Known values are:
         "CompatLevel80", "CompatLevel90", "CompatLevel100", "CompatLevel110", "CompatLevel120",
         "CompatLevel130", and "CompatLevel140".
        :paramtype compatibility_level: str or ~azure.mgmt.datamigration.models.DatabaseCompatLevel
        :keyword collation: Collation name of the database.
        :paramtype collation: str
        :keyword server_name: Name of the server.
        :paramtype server_name: str
        :keyword fqdn: Fully qualified name.
        :paramtype fqdn: str
        :keyword install_id: Install id of the database.
        :paramtype install_id: str
        :keyword server_version: Version of the server.
        :paramtype server_version: str
        :keyword server_edition: Edition of the server.
        :paramtype server_edition: str
        :keyword server_level: Product level of the server (RTM, SP, CTP).
        :paramtype server_level: str
        :keyword server_default_data_path: Default path of the data files.
        :paramtype server_default_data_path: str
        :keyword server_default_log_path: Default path of the log files.
        :paramtype server_default_log_path: str
        :keyword server_default_backup_path: Default path of the backup folder.
        :paramtype server_default_backup_path: str
        :keyword server_core_count: Number of cores on the server.
        :paramtype server_core_count: int
        :keyword server_visible_online_core_count: Number of cores on the server that have VISIBLE
         ONLINE status.
        :paramtype server_visible_online_core_count: int
        :keyword database_state: State of the database. Known values are: "Online", "Restoring",
         "Recovering", "RecoveryPending", "Suspect", "Emergency", "Offline", "Copying", and
         "OfflineSecondary".
        :paramtype database_state: str or ~azure.mgmt.datamigration.models.DatabaseState
        :keyword server_id: The unique Server Id.
        :paramtype server_id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.compatibility_level = compatibility_level
        self.collation = collation
        self.server_name = server_name
        self.fqdn = fqdn
        self.install_id = install_id
        self.server_version = server_version
        self.server_edition = server_edition
        self.server_level = server_level
        self.server_default_data_path = server_default_data_path
        self.server_default_log_path = server_default_log_path
        self.server_default_backup_path = server_default_backup_path
        self.server_core_count = server_core_count
        self.server_visible_online_core_count = server_visible_online_core_count
        self.database_state = database_state
        self.server_id = server_id


class DatabaseBackupInfo(_serialization.Model):
    """Information about backup files when existing backup mode is used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar database_name: Database name.
    :vartype database_name: str
    :ivar backup_type: Backup Type. Known values are: "Database", "TransactionLog", "File",
     "DifferentialDatabase", "DifferentialFile", "Partial", and "DifferentialPartial".
    :vartype backup_type: str or ~azure.mgmt.datamigration.models.BackupType
    :ivar backup_files: The list of backup files for the current database.
    :vartype backup_files: list[str]
    :ivar position: Position of current database backup in the file.
    :vartype position: int
    :ivar is_damaged: Database was damaged when backed up, but the backup operation was requested
     to continue despite errors.
    :vartype is_damaged: bool
    :ivar is_compressed: Whether the backup set is compressed.
    :vartype is_compressed: bool
    :ivar family_count: Number of files in the backup set.
    :vartype family_count: int
    :ivar backup_finish_date: Date and time when the backup operation finished.
    :vartype backup_finish_date: ~datetime.datetime
    """

    _validation = {
        "database_name": {"readonly": True},
        "backup_type": {"readonly": True},
        "backup_files": {"readonly": True},
        "position": {"readonly": True},
        "is_damaged": {"readonly": True},
        "is_compressed": {"readonly": True},
        "family_count": {"readonly": True},
        "backup_finish_date": {"readonly": True},
    }

    _attribute_map = {
        "database_name": {"key": "databaseName", "type": "str"},
        "backup_type": {"key": "backupType", "type": "str"},
        "backup_files": {"key": "backupFiles", "type": "[str]"},
        "position": {"key": "position", "type": "int"},
        "is_damaged": {"key": "isDamaged", "type": "bool"},
        "is_compressed": {"key": "isCompressed", "type": "bool"},
        "family_count": {"key": "familyCount", "type": "int"},
        "backup_finish_date": {"key": "backupFinishDate", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.database_name: Optional[str] = None
        self.backup_type: Optional[Union[str, "_models.BackupType"]] = None
        self.backup_files: Optional[List[str]] = None
        self.position: Optional[int] = None
        self.is_damaged: Optional[bool] = None
        self.is_compressed: Optional[bool] = None
        self.family_count: Optional[int] = None
        self.backup_finish_date: Optional[datetime.datetime] = None


class DatabaseFileInfo(_serialization.Model):
    """Database file specific information.

    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar id: Unique identifier for database file.
    :vartype id: str
    :ivar logical_name: Logical name of the file.
    :vartype logical_name: str
    :ivar physical_full_name: Operating-system full path of the file.
    :vartype physical_full_name: str
    :ivar restore_full_name: Suggested full path of the file for restoring.
    :vartype restore_full_name: str
    :ivar file_type: Database file type. Known values are: "Rows", "Log", "Filestream",
     "NotSupported", and "Fulltext".
    :vartype file_type: str or ~azure.mgmt.datamigration.models.DatabaseFileType
    :ivar size_mb: Size of the file in megabytes.
    :vartype size_mb: float
    """

    _attribute_map = {
        "database_name": {"key": "databaseName", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "logical_name": {"key": "logicalName", "type": "str"},
        "physical_full_name": {"key": "physicalFullName", "type": "str"},
        "restore_full_name": {"key": "restoreFullName", "type": "str"},
        "file_type": {"key": "fileType", "type": "str"},
        "size_mb": {"key": "sizeMB", "type": "float"},
    }

    def __init__(
        self,
        *,
        database_name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        logical_name: Optional[str] = None,
        physical_full_name: Optional[str] = None,
        restore_full_name: Optional[str] = None,
        file_type: Optional[Union[str, "_models.DatabaseFileType"]] = None,
        size_mb: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword database_name: Name of the database.
        :paramtype database_name: str
        :keyword id: Unique identifier for database file.
        :paramtype id: str
        :keyword logical_name: Logical name of the file.
        :paramtype logical_name: str
        :keyword physical_full_name: Operating-system full path of the file.
        :paramtype physical_full_name: str
        :keyword restore_full_name: Suggested full path of the file for restoring.
        :paramtype restore_full_name: str
        :keyword file_type: Database file type. Known values are: "Rows", "Log", "Filestream",
         "NotSupported", and "Fulltext".
        :paramtype file_type: str or ~azure.mgmt.datamigration.models.DatabaseFileType
        :keyword size_mb: Size of the file in megabytes.
        :paramtype size_mb: float
        """
        super().__init__(**kwargs)
        self.database_name = database_name
        self.id = id
        self.logical_name = logical_name
        self.physical_full_name = physical_full_name
        self.restore_full_name = restore_full_name
        self.file_type = file_type
        self.size_mb = size_mb


class DatabaseFileInput(_serialization.Model):
    """Database file specific information for input.

    :ivar id: Unique identifier for database file.
    :vartype id: str
    :ivar logical_name: Logical name of the file.
    :vartype logical_name: str
    :ivar physical_full_name: Operating-system full path of the file.
    :vartype physical_full_name: str
    :ivar restore_full_name: Suggested full path of the file for restoring.
    :vartype restore_full_name: str
    :ivar file_type: Database file type. Known values are: "Rows", "Log", "Filestream",
     "NotSupported", and "Fulltext".
    :vartype file_type: str or ~azure.mgmt.datamigration.models.DatabaseFileType
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "logical_name": {"key": "logicalName", "type": "str"},
        "physical_full_name": {"key": "physicalFullName", "type": "str"},
        "restore_full_name": {"key": "restoreFullName", "type": "str"},
        "file_type": {"key": "fileType", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        logical_name: Optional[str] = None,
        physical_full_name: Optional[str] = None,
        restore_full_name: Optional[str] = None,
        file_type: Optional[Union[str, "_models.DatabaseFileType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Unique identifier for database file.
        :paramtype id: str
        :keyword logical_name: Logical name of the file.
        :paramtype logical_name: str
        :keyword physical_full_name: Operating-system full path of the file.
        :paramtype physical_full_name: str
        :keyword restore_full_name: Suggested full path of the file for restoring.
        :paramtype restore_full_name: str
        :keyword file_type: Database file type. Known values are: "Rows", "Log", "Filestream",
         "NotSupported", and "Fulltext".
        :paramtype file_type: str or ~azure.mgmt.datamigration.models.DatabaseFileType
        """
        super().__init__(**kwargs)
        self.id = id
        self.logical_name = logical_name
        self.physical_full_name = physical_full_name
        self.restore_full_name = restore_full_name
        self.file_type = file_type


class DatabaseInfo(_serialization.Model):
    """Project Database Details.

    All required parameters must be populated in order to send to server.

    :ivar source_database_name: Name of the database. Required.
    :vartype source_database_name: str
    """

    _validation = {
        "source_database_name": {"required": True},
    }

    _attribute_map = {
        "source_database_name": {"key": "sourceDatabaseName", "type": "str"},
    }

    def __init__(self, *, source_database_name: str, **kwargs: Any) -> None:
        """
        :keyword source_database_name: Name of the database. Required.
        :paramtype source_database_name: str
        """
        super().__init__(**kwargs)
        self.source_database_name = source_database_name


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemData
    """


class DatabaseMigration(ProxyResource):
    """Database Migration Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemData
    :ivar properties: Database Migration Resource properties.
    :vartype properties: ~azure.mgmt.datamigration.models.DatabaseMigrationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DatabaseMigrationProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DatabaseMigrationProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Database Migration Resource properties.
        :paramtype properties: ~azure.mgmt.datamigration.models.DatabaseMigrationProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DatabaseMigrationBase(ProxyResource):
    """Database Migration Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemData
    :ivar properties: Database Migration Base Resource properties.
    :vartype properties: ~azure.mgmt.datamigration.models.DatabaseMigrationBaseProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DatabaseMigrationBaseProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.DatabaseMigrationBaseProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Database Migration Base Resource properties.
        :paramtype properties: ~azure.mgmt.datamigration.models.DatabaseMigrationBaseProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DatabaseMigrationBaseListResult(_serialization.Model):
    """A list of Database Migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.datamigration.models.DatabaseMigrationBase]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseMigrationBase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DatabaseMigrationBase"]] = None
        self.next_link: Optional[str] = None


class DatabaseMigrationBaseProperties(_serialization.Model):
    """Database Migration Base Resource properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DatabaseMigrationProperties, DatabaseMigrationPropertiesCosmosDbMongo

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar kind: Required. Known values are: "SqlMi", "SqlVm", "SqlDb", and "MongoToCosmosDbMongo".
    :vartype kind: str or ~azure.mgmt.datamigration.models.ResourceType
    :ivar scope: Resource Id of the target resource.
    :vartype scope: str
    :ivar provisioning_state: Provisioning State of migration. ProvisioningState as Succeeded
     implies that validations have been performed and migration has started. Known values are:
     "Provisioning", "Updating", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.datamigration.models.ProvisioningState
    :ivar migration_status: Migration status.
    :vartype migration_status: str
    :ivar started_on: Database migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Database migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_service: Resource Id of the Migration Service.
    :vartype migration_service: str
    :ivar migration_operation_id: ID for current migration operation.
    :vartype migration_operation_id: str
    :ivar migration_failure_error: Error details in case of migration failure.
    :vartype migration_failure_error: ~azure.mgmt.datamigration.models.ErrorInfo
    :ivar provisioning_error: Error message for migration provisioning failure, if any.
    :vartype provisioning_error: str
    """

    _validation = {
        "kind": {"required": True},
        "provisioning_state": {"readonly": True},
        "migration_status": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "migration_failure_error": {"readonly": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "migration_status": {"key": "migrationStatus", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "migration_service": {"key": "migrationService", "type": "str"},
        "migration_operation_id": {"key": "migrationOperationId", "type": "str"},
        "migration_failure_error": {"key": "migrationFailureError", "type": "ErrorInfo"},
        "provisioning_error": {"key": "provisioningError", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "DatabaseMigrationProperties": "DatabaseMigrationProperties",
            "MongoToCosmosDbMongo": "DatabaseMigrationPropertiesCosmosDbMongo",
        }
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        migration_service: Optional[str] = None,
        migration_operation_id: Optional[str] = None,
        provisioning_error: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: Resource Id of the target resource.
        :paramtype scope: str
        :keyword migration_service: Resource Id of the Migration Service.
        :paramtype migration_service: str
        :keyword migration_operation_id: ID for current migration operation.
        :paramtype migration_operation_id: str
        :keyword provisioning_error: Error message for migration provisioning failure, if any.
        :paramtype provisioning_error: str
        """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None
        self.scope = scope
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.migration_status: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.migration_service = migration_service
        self.migration_operation_id = migration_operation_id
        self.migration_failure_error: Optional["_models.ErrorInfo"] = None
        self.provisioning_error = provisioning_error


class DatabaseMigrationCosmosDbMongo(ProxyResource):
    """Database Migration Resource for Mongo to CosmosDb.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemData
    :ivar kind: Known values are: "SqlMi", "SqlVm", "SqlDb", and "MongoToCosmosDbMongo".
    :vartype kind: str or ~azure.mgmt.datamigration.models.ResourceType
    :ivar scope: Resource Id of the target resource.
    :vartype scope: str
    :ivar provisioning_state: Provisioning State of migration. ProvisioningState as Succeeded
     implies that validations have been performed and migration has started. Known values are:
     "Provisioning", "Updating", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.datamigration.models.ProvisioningState
    :ivar migration_status: Migration status.
    :vartype migration_status: str
    :ivar started_on: Database migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Database migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_service: Resource Id of the Migration Service.
    :vartype migration_service: str
    :ivar migration_operation_id: ID for current migration operation.
    :vartype migration_operation_id: str
    :ivar migration_failure_error: Error details in case of migration failure.
    :vartype migration_failure_error: ~azure.mgmt.datamigration.models.ErrorInfo
    :ivar provisioning_error: Error message for migration provisioning failure, if any.
    :vartype provisioning_error: str
    :ivar source_mongo_connection: Source Mongo connection details.
    :vartype source_mongo_connection: ~azure.mgmt.datamigration.models.MongoConnectionInformation
    :ivar target_mongo_connection: Target Cosmos DB Mongo connection details.
    :vartype target_mongo_connection: ~azure.mgmt.datamigration.models.MongoConnectionInformation
    :ivar collection_list: List of Mongo Collections to be migrated.
    :vartype collection_list: list[~azure.mgmt.datamigration.models.MongoMigrationCollection]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "migration_status": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "migration_failure_error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "properties.kind", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "migration_status": {"key": "properties.migrationStatus", "type": "str"},
        "started_on": {"key": "properties.startedOn", "type": "iso-8601"},
        "ended_on": {"key": "properties.endedOn", "type": "iso-8601"},
        "migration_service": {"key": "properties.migrationService", "type": "str"},
        "migration_operation_id": {"key": "properties.migrationOperationId", "type": "str"},
        "migration_failure_error": {"key": "properties.migrationFailureError", "type": "ErrorInfo"},
        "provisioning_error": {"key": "properties.provisioningError", "type": "str"},
        "source_mongo_connection": {"key": "properties.sourceMongoConnection", "type": "MongoConnectionInformation"},
        "target_mongo_connection": {"key": "properties.targetMongoConnection", "type": "MongoConnectionInformation"},
        "collection_list": {"key": "properties.collectionList", "type": "[MongoMigrationCollection]"},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        migration_service: Optional[str] = None,
        migration_operation_id: Optional[str] = None,
        provisioning_error: Optional[str] = None,
        source_mongo_connection: Optional["_models.MongoConnectionInformation"] = None,
        target_mongo_connection: Optional["_models.MongoConnectionInformation"] = None,
        collection_list: Optional[List["_models.MongoMigrationCollection"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: Resource Id of the target resource.
        :paramtype scope: str
        :keyword migration_service: Resource Id of the Migration Service.
        :paramtype migration_service: str
        :keyword migration_operation_id: ID for current migration operation.
        :paramtype migration_operation_id: str
        :keyword provisioning_error: Error message for migration provisioning failure, if any.
        :paramtype provisioning_error: str
        :keyword source_mongo_connection: Source Mongo connection details.
        :paramtype source_mongo_connection: ~azure.mgmt.datamigration.models.MongoConnectionInformation
        :keyword target_mongo_connection: Target Cosmos DB Mongo connection details.
        :paramtype target_mongo_connection: ~azure.mgmt.datamigration.models.MongoConnectionInformation
        :keyword collection_list: List of Mongo Collections to be migrated.
        :paramtype collection_list: list[~azure.mgmt.datamigration.models.MongoMigrationCollection]
        """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None
        self.scope = scope
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.migration_status: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.migration_service = migration_service
        self.migration_operation_id = migration_operation_id
        self.migration_failure_error: Optional["_models.ErrorInfo"] = None
        self.provisioning_error = provisioning_error
        self.source_mongo_connection = source_mongo_connection
        self.target_mongo_connection = target_mongo_connection
        self.collection_list = collection_list


class DatabaseMigrationCosmosDbMongoListResult(_serialization.Model):
    """A list of Database Migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.datamigration.models.DatabaseMigrationCosmosDbMongo]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseMigrationCosmosDbMongo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DatabaseMigrationCosmosDbMongo"]] = None
        self.next_link: Optional[str] = None


class DatabaseMigrationListResult(_serialization.Model):
    """A list of Database Migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.datamigration.models.DatabaseMigration]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseMigration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DatabaseMigration"]] = None
        self.next_link: Optional[str] = None


class DatabaseMigrationProperties(DatabaseMigrationBaseProperties):
    """Database Migration Resource properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DatabaseMigrationPropertiesSqlDb, DatabaseMigrationPropertiesSqlMi,
    DatabaseMigrationPropertiesSqlVm

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar kind: Required. Known values are: "SqlMi", "SqlVm", "SqlDb", and "MongoToCosmosDbMongo".
    :vartype kind: str or ~azure.mgmt.datamigration.models.ResourceType
    :ivar scope: Resource Id of the target resource.
    :vartype scope: str
    :ivar provisioning_state: Provisioning State of migration. ProvisioningState as Succeeded
     implies that validations have been performed and migration has started. Known values are:
     "Provisioning", "Updating", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.datamigration.models.ProvisioningState
    :ivar migration_status: Migration status.
    :vartype migration_status: str
    :ivar started_on: Database migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Database migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_service: Resource Id of the Migration Service.
    :vartype migration_service: str
    :ivar migration_operation_id: ID for current migration operation.
    :vartype migration_operation_id: str
    :ivar migration_failure_error: Error details in case of migration failure.
    :vartype migration_failure_error: ~azure.mgmt.datamigration.models.ErrorInfo
    :ivar provisioning_error: Error message for migration provisioning failure, if any.
    :vartype provisioning_error: str
    :ivar source_sql_connection: Source SQL Server connection details.
    :vartype source_sql_connection: ~azure.mgmt.datamigration.models.SqlConnectionInformation
    :ivar source_database_name: Name of the source database.
    :vartype source_database_name: str
    :ivar source_server_name: Name of the source sql server.
    :vartype source_server_name: str
    :ivar target_database_collation: Database collation to be used for the target database.
    :vartype target_database_collation: str
    """

    _validation = {
        "kind": {"required": True},
        "provisioning_state": {"readonly": True},
        "migration_status": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "migration_failure_error": {"readonly": True},
        "source_server_name": {"readonly": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "migration_status": {"key": "migrationStatus", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "migration_service": {"key": "migrationService", "type": "str"},
        "migration_operation_id": {"key": "migrationOperationId", "type": "str"},
        "migration_failure_error": {"key": "migrationFailureError", "type": "ErrorInfo"},
        "provisioning_error": {"key": "provisioningError", "type": "str"},
        "source_sql_connection": {"key": "sourceSqlConnection", "type": "SqlConnectionInformation"},
        "source_database_name": {"key": "sourceDatabaseName", "type": "str"},
        "source_server_name": {"key": "sourceServerName", "type": "str"},
        "target_database_collation": {"key": "targetDatabaseCollation", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "SqlDb": "DatabaseMigrationPropertiesSqlDb",
            "SqlMi": "DatabaseMigrationPropertiesSqlMi",
            "SqlVm": "DatabaseMigrationPropertiesSqlVm",
        }
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        migration_service: Optional[str] = None,
        migration_operation_id: Optional[str] = None,
        provisioning_error: Optional[str] = None,
        source_sql_connection: Optional["_models.SqlConnectionInformation"] = None,
        source_database_name: Optional[str] = None,
        target_database_collation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: Resource Id of the target resource.
        :paramtype scope: str
        :keyword migration_service: Resource Id of the Migration Service.
        :paramtype migration_service: str
        :keyword migration_operation_id: ID for current migration operation.
        :paramtype migration_operation_id: str
        :keyword provisioning_error: Error message for migration provisioning failure, if any.
        :paramtype provisioning_error: str
        :keyword source_sql_connection: Source SQL Server connection details.
        :paramtype source_sql_connection: ~azure.mgmt.datamigration.models.SqlConnectionInformation
        :keyword source_database_name: Name of the source database.
        :paramtype source_database_name: str
        :keyword target_database_collation: Database collation to be used for the target database.
        :paramtype target_database_collation: str
        """
        super().__init__(
            scope=scope,
            migration_service=migration_service,
            migration_operation_id=migration_operation_id,
            provisioning_error=provisioning_error,
            **kwargs
        )
        self.kind: str = "DatabaseMigrationProperties"
        self.source_sql_connection = source_sql_connection
        self.source_database_name = source_database_name
        self.source_server_name: Optional[str] = None
        self.target_database_collation = target_database_collation


class DatabaseMigrationPropertiesCosmosDbMongo(DatabaseMigrationBaseProperties):
    """Database Migration Resource properties for CosmosDb for Mongo.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar kind: Required. Known values are: "SqlMi", "SqlVm", "SqlDb", and "MongoToCosmosDbMongo".
    :vartype kind: str or ~azure.mgmt.datamigration.models.ResourceType
    :ivar scope: Resource Id of the target resource.
    :vartype scope: str
    :ivar provisioning_state: Provisioning State of migration. ProvisioningState as Succeeded
     implies that validations have been performed and migration has started. Known values are:
     "Provisioning", "Updating", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.datamigration.models.ProvisioningState
    :ivar migration_status: Migration status.
    :vartype migration_status: str
    :ivar started_on: Database migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Database migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_service: Resource Id of the Migration Service.
    :vartype migration_service: str
    :ivar migration_operation_id: ID for current migration operation.
    :vartype migration_operation_id: str
    :ivar migration_failure_error: Error details in case of migration failure.
    :vartype migration_failure_error: ~azure.mgmt.datamigration.models.ErrorInfo
    :ivar provisioning_error: Error message for migration provisioning failure, if any.
    :vartype provisioning_error: str
    :ivar source_mongo_connection: Source Mongo connection details.
    :vartype source_mongo_connection: ~azure.mgmt.datamigration.models.MongoConnectionInformation
    :ivar target_mongo_connection: Target Cosmos DB Mongo connection details.
    :vartype target_mongo_connection: ~azure.mgmt.datamigration.models.MongoConnectionInformation
    :ivar collection_list: List of Mongo Collections to be migrated.
    :vartype collection_list: list[~azure.mgmt.datamigration.models.MongoMigrationCollection]
    """

    _validation = {
        "kind": {"required": True},
        "provisioning_state": {"readonly": True},
        "migration_status": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "migration_failure_error": {"readonly": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "migration_status": {"key": "migrationStatus", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "migration_service": {"key": "migrationService", "type": "str"},
        "migration_operation_id": {"key": "migrationOperationId", "type": "str"},
        "migration_failure_error": {"key": "migrationFailureError", "type": "ErrorInfo"},
        "provisioning_error": {"key": "provisioningError", "type": "str"},
        "source_mongo_connection": {"key": "sourceMongoConnection", "type": "MongoConnectionInformation"},
        "target_mongo_connection": {"key": "targetMongoConnection", "type": "MongoConnectionInformation"},
        "collection_list": {"key": "collectionList", "type": "[MongoMigrationCollection]"},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        migration_service: Optional[str] = None,
        migration_operation_id: Optional[str] = None,
        provisioning_error: Optional[str] = None,
        source_mongo_connection: Optional["_models.MongoConnectionInformation"] = None,
        target_mongo_connection: Optional["_models.MongoConnectionInformation"] = None,
        collection_list: Optional[List["_models.MongoMigrationCollection"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: Resource Id of the target resource.
        :paramtype scope: str
        :keyword migration_service: Resource Id of the Migration Service.
        :paramtype migration_service: str
        :keyword migration_operation_id: ID for current migration operation.
        :paramtype migration_operation_id: str
        :keyword provisioning_error: Error message for migration provisioning failure, if any.
        :paramtype provisioning_error: str
        :keyword source_mongo_connection: Source Mongo connection details.
        :paramtype source_mongo_connection: ~azure.mgmt.datamigration.models.MongoConnectionInformation
        :keyword target_mongo_connection: Target Cosmos DB Mongo connection details.
        :paramtype target_mongo_connection: ~azure.mgmt.datamigration.models.MongoConnectionInformation
        :keyword collection_list: List of Mongo Collections to be migrated.
        :paramtype collection_list: list[~azure.mgmt.datamigration.models.MongoMigrationCollection]
        """
        super().__init__(
            scope=scope,
            migration_service=migration_service,
            migration_operation_id=migration_operation_id,
            provisioning_error=provisioning_error,
            **kwargs
        )
        self.kind: str = "MongoToCosmosDbMongo"
        self.source_mongo_connection = source_mongo_connection
        self.target_mongo_connection = target_mongo_connection
        self.collection_list = collection_list


class DatabaseMigrationPropertiesSqlDb(DatabaseMigrationProperties):
    """Database Migration Resource properties for SQL database.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar kind: Required. Known values are: "SqlMi", "SqlVm", "SqlDb", and "MongoToCosmosDbMongo".
    :vartype kind: str or ~azure.mgmt.datamigration.models.ResourceType
    :ivar scope: Resource Id of the target resource.
    :vartype scope: str
    :ivar provisioning_state: Provisioning State of migration. ProvisioningState as Succeeded
     implies that validations have been performed and migration has started. Known values are:
     "Provisioning", "Updating", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.datamigration.models.ProvisioningState
    :ivar migration_status: Migration status.
    :vartype migration_status: str
    :ivar started_on: Database migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Database migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_service: Resource Id of the Migration Service.
    :vartype migration_service: str
    :ivar migration_operation_id: ID for current migration operation.
    :vartype migration_operation_id: str
    :ivar migration_failure_error: Error details in case of migration failure.
    :vartype migration_failure_error: ~azure.mgmt.datamigration.models.ErrorInfo
    :ivar provisioning_error: Error message for migration provisioning failure, if any.
    :vartype provisioning_error: str
    :ivar source_sql_connection: Source SQL Server connection details.
    :vartype source_sql_connection: ~azure.mgmt.datamigration.models.SqlConnectionInformation
    :ivar source_database_name: Name of the source database.
    :vartype source_database_name: str
    :ivar source_server_name: Name of the source sql server.
    :vartype source_server_name: str
    :ivar target_database_collation: Database collation to be used for the target database.
    :vartype target_database_collation: str
    :ivar migration_status_details: Detailed migration status. Not included by default.
    :vartype migration_status_details: ~azure.mgmt.datamigration.models.SqlDbMigrationStatusDetails
    :ivar target_sql_connection: Target SQL DB connection details.
    :vartype target_sql_connection: ~azure.mgmt.datamigration.models.SqlConnectionInformation
    :ivar offline_configuration: Offline configuration.
    :vartype offline_configuration: ~azure.mgmt.datamigration.models.SqlDbOfflineConfiguration
    :ivar table_list: List of tables to copy.
    :vartype table_list: list[str]
    """

    _validation = {
        "kind": {"required": True},
        "provisioning_state": {"readonly": True},
        "migration_status": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "migration_failure_error": {"readonly": True},
        "source_server_name": {"readonly": True},
        "migration_status_details": {"readonly": True},
        "offline_configuration": {"readonly": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "migration_status": {"key": "migrationStatus", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "migration_service": {"key": "migrationService", "type": "str"},
        "migration_operation_id": {"key": "migrationOperationId", "type": "str"},
        "migration_failure_error": {"key": "migrationFailureError", "type": "ErrorInfo"},
        "provisioning_error": {"key": "provisioningError", "type": "str"},
        "source_sql_connection": {"key": "sourceSqlConnection", "type": "SqlConnectionInformation"},
        "source_database_name": {"key": "sourceDatabaseName", "type": "str"},
        "source_server_name": {"key": "sourceServerName", "type": "str"},
        "target_database_collation": {"key": "targetDatabaseCollation", "type": "str"},
        "migration_status_details": {"key": "migrationStatusDetails", "type": "SqlDbMigrationStatusDetails"},
        "target_sql_connection": {"key": "targetSqlConnection", "type": "SqlConnectionInformation"},
        "offline_configuration": {"key": "offlineConfiguration", "type": "SqlDbOfflineConfiguration"},
        "table_list": {"key": "tableList", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        migration_service: Optional[str] = None,
        migration_operation_id: Optional[str] = None,
        provisioning_error: Optional[str] = None,
        source_sql_connection: Optional["_models.SqlConnectionInformation"] = None,
        source_database_name: Optional[str] = None,
        target_database_collation: Optional[str] = None,
        target_sql_connection: Optional["_models.SqlConnectionInformation"] = None,
        table_list: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: Resource Id of the target resource.
        :paramtype scope: str
        :keyword migration_service: Resource Id of the Migration Service.
        :paramtype migration_service: str
        :keyword migration_operation_id: ID for current migration operation.
        :paramtype migration_operation_id: str
        :keyword provisioning_error: Error message for migration provisioning failure, if any.
        :paramtype provisioning_error: str
        :keyword source_sql_connection: Source SQL Server connection details.
        :paramtype source_sql_connection: ~azure.mgmt.datamigration.models.SqlConnectionInformation
        :keyword source_database_name: Name of the source database.
        :paramtype source_database_name: str
        :keyword target_database_collation: Database collation to be used for the target database.
        :paramtype target_database_collation: str
        :keyword target_sql_connection: Target SQL DB connection details.
        :paramtype target_sql_connection: ~azure.mgmt.datamigration.models.SqlConnectionInformation
        :keyword table_list: List of tables to copy.
        :paramtype table_list: list[str]
        """
        super().__init__(
            scope=scope,
            migration_service=migration_service,
            migration_operation_id=migration_operation_id,
            provisioning_error=provisioning_error,
            source_sql_connection=source_sql_connection,
            source_database_name=source_database_name,
            target_database_collation=target_database_collation,
            **kwargs
        )
        self.kind: str = "SqlDb"
        self.migration_status_details: Optional["_models.SqlDbMigrationStatusDetails"] = None
        self.target_sql_connection = target_sql_connection
        self.offline_configuration: Optional["_models.SqlDbOfflineConfiguration"] = None
        self.table_list = table_list


class DatabaseMigrationPropertiesSqlMi(DatabaseMigrationProperties):
    """Database Migration Resource properties for SQL Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar kind: Required. Known values are: "SqlMi", "SqlVm", "SqlDb", and "MongoToCosmosDbMongo".
    :vartype kind: str or ~azure.mgmt.datamigration.models.ResourceType
    :ivar scope: Resource Id of the target resource.
    :vartype scope: str
    :ivar provisioning_state: Provisioning State of migration. ProvisioningState as Succeeded
     implies that validations have been performed and migration has started. Known values are:
     "Provisioning", "Updating", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.datamigration.models.ProvisioningState
    :ivar migration_status: Migration status.
    :vartype migration_status: str
    :ivar started_on: Database migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Database migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_service: Resource Id of the Migration Service.
    :vartype migration_service: str
    :ivar migration_operation_id: ID for current migration operation.
    :vartype migration_operation_id: str
    :ivar migration_failure_error: Error details in case of migration failure.
    :vartype migration_failure_error: ~azure.mgmt.datamigration.models.ErrorInfo
    :ivar provisioning_error: Error message for migration provisioning failure, if any.
    :vartype provisioning_error: str
    :ivar source_sql_connection: Source SQL Server connection details.
    :vartype source_sql_connection: ~azure.mgmt.datamigration.models.SqlConnectionInformation
    :ivar source_database_name: Name of the source database.
    :vartype source_database_name: str
    :ivar source_server_name: Name of the source sql server.
    :vartype source_server_name: str
    :ivar target_database_collation: Database collation to be used for the target database.
    :vartype target_database_collation: str
    :ivar migration_status_details: Detailed migration status. Not included by default.
    :vartype migration_status_details: ~azure.mgmt.datamigration.models.MigrationStatusDetails
    :ivar backup_configuration: Backup configuration info.
    :vartype backup_configuration: ~azure.mgmt.datamigration.models.BackupConfiguration
    :ivar offline_configuration: Offline configuration.
    :vartype offline_configuration: ~azure.mgmt.datamigration.models.OfflineConfiguration
    """

    _validation = {
        "kind": {"required": True},
        "provisioning_state": {"readonly": True},
        "migration_status": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "migration_failure_error": {"readonly": True},
        "source_server_name": {"readonly": True},
        "migration_status_details": {"readonly": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "migration_status": {"key": "migrationStatus", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "migration_service": {"key": "migrationService", "type": "str"},
        "migration_operation_id": {"key": "migrationOperationId", "type": "str"},
        "migration_failure_error": {"key": "migrationFailureError", "type": "ErrorInfo"},
        "provisioning_error": {"key": "provisioningError", "type": "str"},
        "source_sql_connection": {"key": "sourceSqlConnection", "type": "SqlConnectionInformation"},
        "source_database_name": {"key": "sourceDatabaseName", "type": "str"},
        "source_server_name": {"key": "sourceServerName", "type": "str"},
        "target_database_collation": {"key": "targetDatabaseCollation", "type": "str"},
        "migration_status_details": {"key": "migrationStatusDetails", "type": "MigrationStatusDetails"},
        "backup_configuration": {"key": "backupConfiguration", "type": "BackupConfiguration"},
        "offline_configuration": {"key": "offlineConfiguration", "type": "OfflineConfiguration"},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        migration_service: Optional[str] = None,
        migration_operation_id: Optional[str] = None,
        provisioning_error: Optional[str] = None,
        source_sql_connection: Optional["_models.SqlConnectionInformation"] = None,
        source_database_name: Optional[str] = None,
        target_database_collation: Optional[str] = None,
        backup_configuration: Optional["_models.BackupConfiguration"] = None,
        offline_configuration: Optional["_models.OfflineConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: Resource Id of the target resource.
        :paramtype scope: str
        :keyword migration_service: Resource Id of the Migration Service.
        :paramtype migration_service: str
        :keyword migration_operation_id: ID for current migration operation.
        :paramtype migration_operation_id: str
        :keyword provisioning_error: Error message for migration provisioning failure, if any.
        :paramtype provisioning_error: str
        :keyword source_sql_connection: Source SQL Server connection details.
        :paramtype source_sql_connection: ~azure.mgmt.datamigration.models.SqlConnectionInformation
        :keyword source_database_name: Name of the source database.
        :paramtype source_database_name: str
        :keyword target_database_collation: Database collation to be used for the target database.
        :paramtype target_database_collation: str
        :keyword backup_configuration: Backup configuration info.
        :paramtype backup_configuration: ~azure.mgmt.datamigration.models.BackupConfiguration
        :keyword offline_configuration: Offline configuration.
        :paramtype offline_configuration: ~azure.mgmt.datamigration.models.OfflineConfiguration
        """
        super().__init__(
            scope=scope,
            migration_service=migration_service,
            migration_operation_id=migration_operation_id,
            provisioning_error=provisioning_error,
            source_sql_connection=source_sql_connection,
            source_database_name=source_database_name,
            target_database_collation=target_database_collation,
            **kwargs
        )
        self.kind: str = "SqlMi"
        self.migration_status_details: Optional["_models.MigrationStatusDetails"] = None
        self.backup_configuration = backup_configuration
        self.offline_configuration = offline_configuration


class DatabaseMigrationPropertiesSqlVm(DatabaseMigrationProperties):
    """Database Migration Resource properties for SQL Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar kind: Required. Known values are: "SqlMi", "SqlVm", "SqlDb", and "MongoToCosmosDbMongo".
    :vartype kind: str or ~azure.mgmt.datamigration.models.ResourceType
    :ivar scope: Resource Id of the target resource.
    :vartype scope: str
    :ivar provisioning_state: Provisioning State of migration. ProvisioningState as Succeeded
     implies that validations have been performed and migration has started. Known values are:
     "Provisioning", "Updating", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.datamigration.models.ProvisioningState
    :ivar migration_status: Migration status.
    :vartype migration_status: str
    :ivar started_on: Database migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Database migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_service: Resource Id of the Migration Service.
    :vartype migration_service: str
    :ivar migration_operation_id: ID for current migration operation.
    :vartype migration_operation_id: str
    :ivar migration_failure_error: Error details in case of migration failure.
    :vartype migration_failure_error: ~azure.mgmt.datamigration.models.ErrorInfo
    :ivar provisioning_error: Error message for migration provisioning failure, if any.
    :vartype provisioning_error: str
    :ivar source_sql_connection: Source SQL Server connection details.
    :vartype source_sql_connection: ~azure.mgmt.datamigration.models.SqlConnectionInformation
    :ivar source_database_name: Name of the source database.
    :vartype source_database_name: str
    :ivar source_server_name: Name of the source sql server.
    :vartype source_server_name: str
    :ivar target_database_collation: Database collation to be used for the target database.
    :vartype target_database_collation: str
    :ivar migration_status_details: Detailed migration status. Not included by default.
    :vartype migration_status_details: ~azure.mgmt.datamigration.models.MigrationStatusDetails
    :ivar backup_configuration: Backup configuration info.
    :vartype backup_configuration: ~azure.mgmt.datamigration.models.BackupConfiguration
    :ivar offline_configuration: Offline configuration.
    :vartype offline_configuration: ~azure.mgmt.datamigration.models.OfflineConfiguration
    """

    _validation = {
        "kind": {"required": True},
        "provisioning_state": {"readonly": True},
        "migration_status": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "migration_failure_error": {"readonly": True},
        "source_server_name": {"readonly": True},
        "migration_status_details": {"readonly": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "migration_status": {"key": "migrationStatus", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "migration_service": {"key": "migrationService", "type": "str"},
        "migration_operation_id": {"key": "migrationOperationId", "type": "str"},
        "migration_failure_error": {"key": "migrationFailureError", "type": "ErrorInfo"},
        "provisioning_error": {"key": "provisioningError", "type": "str"},
        "source_sql_connection": {"key": "sourceSqlConnection", "type": "SqlConnectionInformation"},
        "source_database_name": {"key": "sourceDatabaseName", "type": "str"},
        "source_server_name": {"key": "sourceServerName", "type": "str"},
        "target_database_collation": {"key": "targetDatabaseCollation", "type": "str"},
        "migration_status_details": {"key": "migrationStatusDetails", "type": "MigrationStatusDetails"},
        "backup_configuration": {"key": "backupConfiguration", "type": "BackupConfiguration"},
        "offline_configuration": {"key": "offlineConfiguration", "type": "OfflineConfiguration"},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        migration_service: Optional[str] = None,
        migration_operation_id: Optional[str] = None,
        provisioning_error: Optional[str] = None,
        source_sql_connection: Optional["_models.SqlConnectionInformation"] = None,
        source_database_name: Optional[str] = None,
        target_database_collation: Optional[str] = None,
        backup_configuration: Optional["_models.BackupConfiguration"] = None,
        offline_configuration: Optional["_models.OfflineConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: Resource Id of the target resource.
        :paramtype scope: str
        :keyword migration_service: Resource Id of the Migration Service.
        :paramtype migration_service: str
        :keyword migration_operation_id: ID for current migration operation.
        :paramtype migration_operation_id: str
        :keyword provisioning_error: Error message for migration provisioning failure, if any.
        :paramtype provisioning_error: str
        :keyword source_sql_connection: Source SQL Server connection details.
        :paramtype source_sql_connection: ~azure.mgmt.datamigration.models.SqlConnectionInformation
        :keyword source_database_name: Name of the source database.
        :paramtype source_database_name: str
        :keyword target_database_collation: Database collation to be used for the target database.
        :paramtype target_database_collation: str
        :keyword backup_configuration: Backup configuration info.
        :paramtype backup_configuration: ~azure.mgmt.datamigration.models.BackupConfiguration
        :keyword offline_configuration: Offline configuration.
        :paramtype offline_configuration: ~azure.mgmt.datamigration.models.OfflineConfiguration
        """
        super().__init__(
            scope=scope,
            migration_service=migration_service,
            migration_operation_id=migration_operation_id,
            provisioning_error=provisioning_error,
            source_sql_connection=source_sql_connection,
            source_database_name=source_database_name,
            target_database_collation=target_database_collation,
            **kwargs
        )
        self.kind: str = "SqlVm"
        self.migration_status_details: Optional["_models.MigrationStatusDetails"] = None
        self.backup_configuration = backup_configuration
        self.offline_configuration = offline_configuration


class ProxyResourceAutoGenerated(_serialization.Model):
    """ProxyResourceAutoGenerated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemDataAutoGenerated
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemDataAutoGenerated"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemDataAutoGenerated"] = None


class DatabaseMigrationSqlDb(ProxyResourceAutoGenerated):
    """Database Migration Resource for SQL Database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemDataAutoGenerated
    :ivar properties: Database Migration Resource properties for SQL database.
    :vartype properties: ~azure.mgmt.datamigration.models.DatabaseMigrationPropertiesSqlDb
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemDataAutoGenerated"},
        "properties": {"key": "properties", "type": "DatabaseMigrationPropertiesSqlDb"},
    }

    def __init__(
        self, *, properties: Optional["_models.DatabaseMigrationPropertiesSqlDb"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Database Migration Resource properties for SQL database.
        :paramtype properties: ~azure.mgmt.datamigration.models.DatabaseMigrationPropertiesSqlDb
        """
        super().__init__(**kwargs)
        self.properties = properties


class DatabaseMigrationSqlMi(ProxyResourceAutoGenerated):
    """Database Migration Resource for SQL Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemDataAutoGenerated
    :ivar properties: Database Migration Resource properties for SQL Managed Instance.
    :vartype properties: ~azure.mgmt.datamigration.models.DatabaseMigrationPropertiesSqlMi
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemDataAutoGenerated"},
        "properties": {"key": "properties", "type": "DatabaseMigrationPropertiesSqlMi"},
    }

    def __init__(
        self, *, properties: Optional["_models.DatabaseMigrationPropertiesSqlMi"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Database Migration Resource properties for SQL Managed Instance.
        :paramtype properties: ~azure.mgmt.datamigration.models.DatabaseMigrationPropertiesSqlMi
        """
        super().__init__(**kwargs)
        self.properties = properties


class DatabaseMigrationSqlVm(ProxyResourceAutoGenerated):
    """Database Migration Resource for SQL Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemDataAutoGenerated
    :ivar properties: Database Migration Resource properties for SQL Virtual Machine.
    :vartype properties: ~azure.mgmt.datamigration.models.DatabaseMigrationPropertiesSqlVm
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemDataAutoGenerated"},
        "properties": {"key": "properties", "type": "DatabaseMigrationPropertiesSqlVm"},
    }

    def __init__(
        self, *, properties: Optional["_models.DatabaseMigrationPropertiesSqlVm"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Database Migration Resource properties for SQL Virtual Machine.
        :paramtype properties: ~azure.mgmt.datamigration.models.DatabaseMigrationPropertiesSqlVm
        """
        super().__init__(**kwargs)
        self.properties = properties


class DatabaseObjectName(_serialization.Model):
    """A representation of the name of an object in a database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar database_name: The unescaped name of the database containing the object.
    :vartype database_name: str
    :ivar object_name: The unescaped name of the object.
    :vartype object_name: str
    :ivar schema_name: The unescaped name of the schema containing the object.
    :vartype schema_name: str
    :ivar object_type: Type of the object in the database. Known values are: "StoredProcedures",
     "Table", "User", "View", and "Function".
    :vartype object_type: str or ~azure.mgmt.datamigration.models.ObjectType
    """

    _validation = {
        "database_name": {"readonly": True},
        "object_name": {"readonly": True},
        "schema_name": {"readonly": True},
    }

    _attribute_map = {
        "database_name": {"key": "databaseName", "type": "str"},
        "object_name": {"key": "objectName", "type": "str"},
        "schema_name": {"key": "schemaName", "type": "str"},
        "object_type": {"key": "objectType", "type": "str"},
    }

    def __init__(self, *, object_type: Optional[Union[str, "_models.ObjectType"]] = None, **kwargs: Any) -> None:
        """
        :keyword object_type: Type of the object in the database. Known values are: "StoredProcedures",
         "Table", "User", "View", and "Function".
        :paramtype object_type: str or ~azure.mgmt.datamigration.models.ObjectType
        """
        super().__init__(**kwargs)
        self.database_name: Optional[str] = None
        self.object_name: Optional[str] = None
        self.schema_name: Optional[str] = None
        self.object_type = object_type


class DataItemMigrationSummaryResult(_serialization.Model):
    """Basic summary of a data item migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the item.
    :vartype name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar state: Current state of migration. Known values are: "None", "InProgress", "Failed",
     "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar status_message: Status message.
    :vartype status_message: str
    :ivar items_count: Number of items.
    :vartype items_count: int
    :ivar items_completed_count: Number of successfully completed items.
    :vartype items_completed_count: int
    :ivar error_prefix: Wildcard string prefix to use for querying all errors of the item.
    :vartype error_prefix: str
    :ivar result_prefix: Wildcard string prefix to use for querying all sub-tem results of the
     item.
    :vartype result_prefix: str
    """

    _validation = {
        "name": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "state": {"readonly": True},
        "status_message": {"readonly": True},
        "items_count": {"readonly": True},
        "items_completed_count": {"readonly": True},
        "error_prefix": {"readonly": True},
        "result_prefix": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "state": {"key": "state", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "str"},
        "items_count": {"key": "itemsCount", "type": "int"},
        "items_completed_count": {"key": "itemsCompletedCount", "type": "int"},
        "error_prefix": {"key": "errorPrefix", "type": "str"},
        "result_prefix": {"key": "resultPrefix", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.state: Optional[Union[str, "_models.MigrationState"]] = None
        self.status_message: Optional[str] = None
        self.items_count: Optional[int] = None
        self.items_completed_count: Optional[int] = None
        self.error_prefix: Optional[str] = None
        self.result_prefix: Optional[str] = None


class DatabaseSummaryResult(DataItemMigrationSummaryResult):
    """Summary of database results in the migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the item.
    :vartype name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar state: Current state of migration. Known values are: "None", "InProgress", "Failed",
     "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar status_message: Status message.
    :vartype status_message: str
    :ivar items_count: Number of items.
    :vartype items_count: int
    :ivar items_completed_count: Number of successfully completed items.
    :vartype items_completed_count: int
    :ivar error_prefix: Wildcard string prefix to use for querying all errors of the item.
    :vartype error_prefix: str
    :ivar result_prefix: Wildcard string prefix to use for querying all sub-tem results of the
     item.
    :vartype result_prefix: str
    :ivar size_mb: Size of the database in megabytes.
    :vartype size_mb: float
    """

    _validation = {
        "name": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "state": {"readonly": True},
        "status_message": {"readonly": True},
        "items_count": {"readonly": True},
        "items_completed_count": {"readonly": True},
        "error_prefix": {"readonly": True},
        "result_prefix": {"readonly": True},
        "size_mb": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "state": {"key": "state", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "str"},
        "items_count": {"key": "itemsCount", "type": "int"},
        "items_completed_count": {"key": "itemsCompletedCount", "type": "int"},
        "error_prefix": {"key": "errorPrefix", "type": "str"},
        "result_prefix": {"key": "resultPrefix", "type": "str"},
        "size_mb": {"key": "sizeMB", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.size_mb: Optional[float] = None


class DatabaseTable(_serialization.Model):
    """Table properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar has_rows: Indicates whether table is empty or not.
    :vartype has_rows: bool
    :ivar name: Schema-qualified name of the table.
    :vartype name: str
    """

    _validation = {
        "has_rows": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "has_rows": {"key": "hasRows", "type": "bool"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.has_rows: Optional[bool] = None
        self.name: Optional[str] = None


class DataIntegrityValidationResult(_serialization.Model):
    """Results for checksum based Data Integrity validation results.

    :ivar failed_objects: List of failed table names of source and target pair.
    :vartype failed_objects: dict[str, str]
    :ivar validation_errors: List of errors that happened while performing data integrity
     validation.
    :vartype validation_errors: ~azure.mgmt.datamigration.models.ValidationError
    """

    _attribute_map = {
        "failed_objects": {"key": "failedObjects", "type": "{str}"},
        "validation_errors": {"key": "validationErrors", "type": "ValidationError"},
    }

    def __init__(
        self,
        *,
        failed_objects: Optional[Dict[str, str]] = None,
        validation_errors: Optional["_models.ValidationError"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword failed_objects: List of failed table names of source and target pair.
        :paramtype failed_objects: dict[str, str]
        :keyword validation_errors: List of errors that happened while performing data integrity
         validation.
        :paramtype validation_errors: ~azure.mgmt.datamigration.models.ValidationError
        """
        super().__init__(**kwargs)
        self.failed_objects = failed_objects
        self.validation_errors = validation_errors


class DataMigrationError(_serialization.Model):
    """Migration Task errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar message: Error description.
    :vartype message: str
    :ivar type: Error type. Known values are: "Default", "Warning", and "Error".
    :vartype type: str or ~azure.mgmt.datamigration.models.ErrorType
    """

    _validation = {
        "message": {"readonly": True},
    }

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.ErrorType"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: Error type. Known values are: "Default", "Warning", and "Error".
        :paramtype type: str or ~azure.mgmt.datamigration.models.ErrorType
        """
        super().__init__(**kwargs)
        self.message: Optional[str] = None
        self.type = type


class DataMigrationProjectMetadata(_serialization.Model):
    """Common metadata for migration projects.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source_server_name: Source server name.
    :vartype source_server_name: str
    :ivar source_server_port: Source server port number.
    :vartype source_server_port: str
    :ivar source_username: Source username.
    :vartype source_username: str
    :ivar target_server_name: Target server name.
    :vartype target_server_name: str
    :ivar target_username: Target username.
    :vartype target_username: str
    :ivar target_db_name: Target database name.
    :vartype target_db_name: str
    :ivar target_using_win_auth: Whether target connection is Windows authentication.
    :vartype target_using_win_auth: bool
    :ivar selected_migration_tables: List of tables selected for migration.
    :vartype selected_migration_tables:
     list[~azure.mgmt.datamigration.models.MigrationTableMetadata]
    """

    _validation = {
        "source_server_name": {"readonly": True},
        "source_server_port": {"readonly": True},
        "source_username": {"readonly": True},
        "target_server_name": {"readonly": True},
        "target_username": {"readonly": True},
        "target_db_name": {"readonly": True},
        "target_using_win_auth": {"readonly": True},
        "selected_migration_tables": {"readonly": True},
    }

    _attribute_map = {
        "source_server_name": {"key": "sourceServerName", "type": "str"},
        "source_server_port": {"key": "sourceServerPort", "type": "str"},
        "source_username": {"key": "sourceUsername", "type": "str"},
        "target_server_name": {"key": "targetServerName", "type": "str"},
        "target_username": {"key": "targetUsername", "type": "str"},
        "target_db_name": {"key": "targetDbName", "type": "str"},
        "target_using_win_auth": {"key": "targetUsingWinAuth", "type": "bool"},
        "selected_migration_tables": {"key": "selectedMigrationTables", "type": "[MigrationTableMetadata]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.source_server_name: Optional[str] = None
        self.source_server_port: Optional[str] = None
        self.source_username: Optional[str] = None
        self.target_server_name: Optional[str] = None
        self.target_username: Optional[str] = None
        self.target_db_name: Optional[str] = None
        self.target_using_win_auth: Optional[bool] = None
        self.selected_migration_tables: Optional[List["_models.MigrationTableMetadata"]] = None


class TrackedResourceAutoGenerated(_serialization.Model):
    """TrackedResourceAutoGenerated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location:
    :vartype location: str
    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar system_data:
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemDataAutoGenerated
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemDataAutoGenerated"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location:
        :paramtype location: str
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemDataAutoGenerated"] = None


class DataMigrationService(TrackedResourceAutoGenerated):
    """An Azure Database Migration Service (classic) resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location:
    :vartype location: str
    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar system_data:
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemDataAutoGenerated
    :ivar etag: HTTP strong entity tag value. Ignored if submitted.
    :vartype etag: str
    :ivar kind: The resource kind. Only 'vm' (the default) is supported.
    :vartype kind: str
    :ivar sku: Service SKU.
    :vartype sku: ~azure.mgmt.datamigration.models.ServiceSku
    :ivar provisioning_state: The resource's provisioning state. Known values are: "Accepted",
     "Deleting", "Deploying", "Stopped", "Stopping", "Starting", "FailedToStart", "FailedToStop",
     "Succeeded", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datamigration.models.ServiceProvisioningState
    :ivar public_key: The public key of the service, used to encrypt secrets sent to the service.
    :vartype public_key: str
    :ivar virtual_subnet_id: The ID of the Microsoft.Network/virtualNetworks/subnets resource to
     which the service should be joined.
    :vartype virtual_subnet_id: str
    :ivar virtual_nic_id: The ID of the Microsoft.Network/networkInterfaces resource which the
     service have.
    :vartype virtual_nic_id: str
    :ivar auto_stop_delay: The time delay before the service is auto-stopped when idle.
    :vartype auto_stop_delay: str
    :ivar delete_resources_on_stop: Whether service resources should be deleted when stopped.
     (Turned on by default).
    :vartype delete_resources_on_stop: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemDataAutoGenerated"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "sku": {"key": "sku", "type": "ServiceSku"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "public_key": {"key": "properties.publicKey", "type": "str"},
        "virtual_subnet_id": {"key": "properties.virtualSubnetId", "type": "str"},
        "virtual_nic_id": {"key": "properties.virtualNicId", "type": "str"},
        "auto_stop_delay": {"key": "properties.autoStopDelay", "type": "str"},
        "delete_resources_on_stop": {"key": "properties.deleteResourcesOnStop", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        kind: Optional[str] = None,
        sku: Optional["_models.ServiceSku"] = None,
        public_key: Optional[str] = None,
        virtual_subnet_id: Optional[str] = None,
        virtual_nic_id: Optional[str] = None,
        auto_stop_delay: Optional[str] = None,
        delete_resources_on_stop: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location:
        :paramtype location: str
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword etag: HTTP strong entity tag value. Ignored if submitted.
        :paramtype etag: str
        :keyword kind: The resource kind. Only 'vm' (the default) is supported.
        :paramtype kind: str
        :keyword sku: Service SKU.
        :paramtype sku: ~azure.mgmt.datamigration.models.ServiceSku
        :keyword public_key: The public key of the service, used to encrypt secrets sent to the
         service.
        :paramtype public_key: str
        :keyword virtual_subnet_id: The ID of the Microsoft.Network/virtualNetworks/subnets resource to
         which the service should be joined.
        :paramtype virtual_subnet_id: str
        :keyword virtual_nic_id: The ID of the Microsoft.Network/networkInterfaces resource which the
         service have.
        :paramtype virtual_nic_id: str
        :keyword auto_stop_delay: The time delay before the service is auto-stopped when idle.
        :paramtype auto_stop_delay: str
        :keyword delete_resources_on_stop: Whether service resources should be deleted when stopped.
         (Turned on by default).
        :paramtype delete_resources_on_stop: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.etag = etag
        self.kind = kind
        self.sku = sku
        self.provisioning_state: Optional[Union[str, "_models.ServiceProvisioningState"]] = None
        self.public_key = public_key
        self.virtual_subnet_id = virtual_subnet_id
        self.virtual_nic_id = virtual_nic_id
        self.auto_stop_delay = auto_stop_delay
        self.delete_resources_on_stop = delete_resources_on_stop


class DataMigrationServiceList(_serialization.Model):
    """OData page of service objects.

    :ivar value: List of services.
    :vartype value: list[~azure.mgmt.datamigration.models.DataMigrationService]
    :ivar next_link: URL to load the next page of services.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DataMigrationService]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.DataMigrationService"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of services.
        :paramtype value: list[~azure.mgmt.datamigration.models.DataMigrationService]
        :keyword next_link: URL to load the next page of services.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataMigrationServiceStatusResponse(_serialization.Model):
    """Service health status.

    :ivar agent_version: The DMS instance agent version.
    :vartype agent_version: str
    :ivar agent_configuration: Agent Configuration.
    :vartype agent_configuration: JSON
    :ivar status: The machine-readable status, such as 'Initializing', 'Offline', 'Online',
     'Deploying', 'Deleting', 'Stopped', 'Stopping', 'Starting', 'FailedToStart', 'FailedToStop' or
     'Failed'.
    :vartype status: str
    :ivar vm_size: The services virtual machine size, such as 'Standard_D2_v2'.
    :vartype vm_size: str
    :ivar supported_task_types: The list of supported task types.
    :vartype supported_task_types: list[str]
    """

    _attribute_map = {
        "agent_version": {"key": "agentVersion", "type": "str"},
        "agent_configuration": {"key": "agentConfiguration", "type": "object"},
        "status": {"key": "status", "type": "str"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "supported_task_types": {"key": "supportedTaskTypes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        agent_version: Optional[str] = None,
        agent_configuration: Optional[JSON] = None,
        status: Optional[str] = None,
        vm_size: Optional[str] = None,
        supported_task_types: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword agent_version: The DMS instance agent version.
        :paramtype agent_version: str
        :keyword agent_configuration: Agent Configuration.
        :paramtype agent_configuration: JSON
        :keyword status: The machine-readable status, such as 'Initializing', 'Offline', 'Online',
         'Deploying', 'Deleting', 'Stopped', 'Stopping', 'Starting', 'FailedToStart', 'FailedToStop' or
         'Failed'.
        :paramtype status: str
        :keyword vm_size: The services virtual machine size, such as 'Standard_D2_v2'.
        :paramtype vm_size: str
        :keyword supported_task_types: The list of supported task types.
        :paramtype supported_task_types: list[str]
        """
        super().__init__(**kwargs)
        self.agent_version = agent_version
        self.agent_configuration = agent_configuration
        self.status = status
        self.vm_size = vm_size
        self.supported_task_types = supported_task_types


class DeleteNode(_serialization.Model):
    """Details of node to be deleted.

    :ivar node_name: The name of node to delete.
    :vartype node_name: str
    :ivar integration_runtime_name: The name of integration runtime.
    :vartype integration_runtime_name: str
    """

    _attribute_map = {
        "node_name": {"key": "nodeName", "type": "str"},
        "integration_runtime_name": {"key": "integrationRuntimeName", "type": "str"},
    }

    def __init__(
        self, *, node_name: Optional[str] = None, integration_runtime_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword node_name: The name of node to delete.
        :paramtype node_name: str
        :keyword integration_runtime_name: The name of integration runtime.
        :paramtype integration_runtime_name: str
        """
        super().__init__(**kwargs)
        self.node_name = node_name
        self.integration_runtime_name = integration_runtime_name


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.datamigration.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.datamigration.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetail"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorInfo(_serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.datamigration.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.datamigration.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExecutionStatistics(_serialization.Model):
    """Description about the errors happen while performing migration validation.

    :ivar execution_count: No. of query executions.
    :vartype execution_count: int
    :ivar cpu_time_ms: CPU Time in millisecond(s) for the query execution.
    :vartype cpu_time_ms: float
    :ivar elapsed_time_ms: Time taken in millisecond(s) for executing the query.
    :vartype elapsed_time_ms: float
    :ivar wait_stats: Dictionary of sql query execution wait types and the respective statistics.
    :vartype wait_stats: dict[str, ~azure.mgmt.datamigration.models.WaitStatistics]
    :ivar has_errors: Indicates whether the query resulted in an error.
    :vartype has_errors: bool
    :ivar sql_errors: List of sql Errors.
    :vartype sql_errors: list[str]
    """

    _attribute_map = {
        "execution_count": {"key": "executionCount", "type": "int"},
        "cpu_time_ms": {"key": "cpuTimeMs", "type": "float"},
        "elapsed_time_ms": {"key": "elapsedTimeMs", "type": "float"},
        "wait_stats": {"key": "waitStats", "type": "{WaitStatistics}"},
        "has_errors": {"key": "hasErrors", "type": "bool"},
        "sql_errors": {"key": "sqlErrors", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        execution_count: Optional[int] = None,
        cpu_time_ms: Optional[float] = None,
        elapsed_time_ms: Optional[float] = None,
        wait_stats: Optional[Dict[str, "_models.WaitStatistics"]] = None,
        has_errors: Optional[bool] = None,
        sql_errors: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword execution_count: No. of query executions.
        :paramtype execution_count: int
        :keyword cpu_time_ms: CPU Time in millisecond(s) for the query execution.
        :paramtype cpu_time_ms: float
        :keyword elapsed_time_ms: Time taken in millisecond(s) for executing the query.
        :paramtype elapsed_time_ms: float
        :keyword wait_stats: Dictionary of sql query execution wait types and the respective
         statistics.
        :paramtype wait_stats: dict[str, ~azure.mgmt.datamigration.models.WaitStatistics]
        :keyword has_errors: Indicates whether the query resulted in an error.
        :paramtype has_errors: bool
        :keyword sql_errors: List of sql Errors.
        :paramtype sql_errors: list[str]
        """
        super().__init__(**kwargs)
        self.execution_count = execution_count
        self.cpu_time_ms = cpu_time_ms
        self.elapsed_time_ms = elapsed_time_ms
        self.wait_stats = wait_stats
        self.has_errors = has_errors
        self.sql_errors = sql_errors


class FileList(_serialization.Model):
    """OData page of files.

    :ivar value: List of files.
    :vartype value: list[~azure.mgmt.datamigration.models.ProjectFile]
    :ivar next_link: URL to load the next page of files.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ProjectFile]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ProjectFile"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of files.
        :paramtype value: list[~azure.mgmt.datamigration.models.ProjectFile]
        :keyword next_link: URL to load the next page of files.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FileShare(_serialization.Model):
    """File share information with Path, Username, and Password.

    All required parameters must be populated in order to send to server.

    :ivar user_name: User name credential to connect to the share location.
    :vartype user_name: str
    :ivar password: Password credential used to connect to the share location.
    :vartype password: str
    :ivar path: The folder path for this share. Required.
    :vartype path: str
    """

    _validation = {
        "path": {"required": True},
    }

    _attribute_map = {
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(
        self, *, path: str, user_name: Optional[str] = None, password: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword user_name: User name credential to connect to the share location.
        :paramtype user_name: str
        :keyword password: Password credential used to connect to the share location.
        :paramtype password: str
        :keyword path: The folder path for this share. Required.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.user_name = user_name
        self.password = password
        self.path = path


class FileStorageInfo(_serialization.Model):
    """File storage information.

    :ivar uri: A URI that can be used to access the file content.
    :vartype uri: str
    :ivar headers: Dictionary of :code:`<string>`.
    :vartype headers: dict[str, str]
    """

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
        "headers": {"key": "headers", "type": "{str}"},
    }

    def __init__(self, *, uri: Optional[str] = None, headers: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword uri: A URI that can be used to access the file content.
        :paramtype uri: str
        :keyword headers: Dictionary of :code:`<string>`.
        :paramtype headers: dict[str, str]
        """
        super().__init__(**kwargs)
        self.uri = uri
        self.headers = headers


class GetProjectDetailsNonSqlTaskInput(_serialization.Model):
    """Input for the task that reads configuration from project artifacts.

    All required parameters must be populated in order to send to server.

    :ivar project_name: Name of the migration project. Required.
    :vartype project_name: str
    :ivar project_location: A URL that points to the location to access project artifacts.
     Required.
    :vartype project_location: str
    """

    _validation = {
        "project_name": {"required": True},
        "project_location": {"required": True},
    }

    _attribute_map = {
        "project_name": {"key": "projectName", "type": "str"},
        "project_location": {"key": "projectLocation", "type": "str"},
    }

    def __init__(self, *, project_name: str, project_location: str, **kwargs: Any) -> None:
        """
        :keyword project_name: Name of the migration project. Required.
        :paramtype project_name: str
        :keyword project_location: A URL that points to the location to access project artifacts.
         Required.
        :paramtype project_location: str
        """
        super().__init__(**kwargs)
        self.project_name = project_name
        self.project_location = project_location


class GetTdeCertificatesSqlTaskInput(_serialization.Model):
    """Input for the task that gets TDE certificates in Base64 encoded format.

    All required parameters must be populated in order to send to server.

    :ivar connection_info: Connection information for SQL Server. Required.
    :vartype connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar backup_file_share: Backup file share information for file share to be used for
     temporarily storing files. Required.
    :vartype backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :ivar selected_certificates: List containing certificate names and corresponding password to
     use for encrypting the exported certificate. Required.
    :vartype selected_certificates: list[~azure.mgmt.datamigration.models.SelectedCertificateInput]
    """

    _validation = {
        "connection_info": {"required": True},
        "backup_file_share": {"required": True},
        "selected_certificates": {"required": True},
    }

    _attribute_map = {
        "connection_info": {"key": "connectionInfo", "type": "SqlConnectionInfo"},
        "backup_file_share": {"key": "backupFileShare", "type": "FileShare"},
        "selected_certificates": {"key": "selectedCertificates", "type": "[SelectedCertificateInput]"},
    }

    def __init__(
        self,
        *,
        connection_info: "_models.SqlConnectionInfo",
        backup_file_share: "_models.FileShare",
        selected_certificates: List["_models.SelectedCertificateInput"],
        **kwargs: Any
    ) -> None:
        """
        :keyword connection_info: Connection information for SQL Server. Required.
        :paramtype connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword backup_file_share: Backup file share information for file share to be used for
         temporarily storing files. Required.
        :paramtype backup_file_share: ~azure.mgmt.datamigration.models.FileShare
        :keyword selected_certificates: List containing certificate names and corresponding password to
         use for encrypting the exported certificate. Required.
        :paramtype selected_certificates:
         list[~azure.mgmt.datamigration.models.SelectedCertificateInput]
        """
        super().__init__(**kwargs)
        self.connection_info = connection_info
        self.backup_file_share = backup_file_share
        self.selected_certificates = selected_certificates


class GetTdeCertificatesSqlTaskOutput(_serialization.Model):
    """Output of the task that gets TDE certificates in Base64 encoded format.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar base64_encoded_certificates: Mapping from certificate name to base 64 encoded format.
    :vartype base64_encoded_certificates: str
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "base64_encoded_certificates": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "base64_encoded_certificates": {"key": "base64EncodedCertificates", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.base64_encoded_certificates: Optional[str] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class GetTdeCertificatesSqlTaskProperties(ProjectTaskProperties):
    """Properties for the task that gets TDE certificates in Base64 encoded format.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.GetTdeCertificatesSqlTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.GetTdeCertificatesSqlTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "GetTdeCertificatesSqlTaskInput"},
        "output": {"key": "output", "type": "[GetTdeCertificatesSqlTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.GetTdeCertificatesSqlTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.GetTdeCertificatesSqlTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "GetTDECertificates.Sql"
        self.input = input
        self.output: Optional[List["_models.GetTdeCertificatesSqlTaskOutput"]] = None


class GetUserTablesMySqlTaskInput(_serialization.Model):
    """Input for the task that collects user tables for the given list of databases.

    All required parameters must be populated in order to send to server.

    :ivar connection_info: Connection information for SQL Server. Required.
    :vartype connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
    :ivar selected_databases: List of database names to collect tables for. Required.
    :vartype selected_databases: list[str]
    """

    _validation = {
        "connection_info": {"required": True},
        "selected_databases": {"required": True},
    }

    _attribute_map = {
        "connection_info": {"key": "connectionInfo", "type": "MySqlConnectionInfo"},
        "selected_databases": {"key": "selectedDatabases", "type": "[str]"},
    }

    def __init__(
        self, *, connection_info: "_models.MySqlConnectionInfo", selected_databases: List[str], **kwargs: Any
    ) -> None:
        """
        :keyword connection_info: Connection information for SQL Server. Required.
        :paramtype connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
        :keyword selected_databases: List of database names to collect tables for. Required.
        :paramtype selected_databases: list[str]
        """
        super().__init__(**kwargs)
        self.connection_info = connection_info
        self.selected_databases = selected_databases


class GetUserTablesMySqlTaskOutput(_serialization.Model):
    """Output of the task that collects user tables for the given list of databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar databases_to_tables: Mapping from database name to list of tables.
    :vartype databases_to_tables: str
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "databases_to_tables": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "databases_to_tables": {"key": "databasesToTables", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.databases_to_tables: Optional[str] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class GetUserTablesMySqlTaskProperties(ProjectTaskProperties):
    """Properties for the task that collects user tables for the given list of databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.GetUserTablesMySqlTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.GetUserTablesMySqlTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "GetUserTablesMySqlTaskInput"},
        "output": {"key": "output", "type": "[GetUserTablesMySqlTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.GetUserTablesMySqlTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.GetUserTablesMySqlTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "GetUserTablesMySql"
        self.input = input
        self.output: Optional[List["_models.GetUserTablesMySqlTaskOutput"]] = None


class GetUserTablesOracleTaskInput(_serialization.Model):
    """Input for the task that gets the list of tables contained within a provided list of Oracle
    schemas.

    All required parameters must be populated in order to send to server.

    :ivar connection_info: Information for connecting to Oracle source. Required.
    :vartype connection_info: ~azure.mgmt.datamigration.models.OracleConnectionInfo
    :ivar selected_schemas: List of Oracle schemas for which to collect tables. Required.
    :vartype selected_schemas: list[str]
    """

    _validation = {
        "connection_info": {"required": True},
        "selected_schemas": {"required": True},
    }

    _attribute_map = {
        "connection_info": {"key": "connectionInfo", "type": "OracleConnectionInfo"},
        "selected_schemas": {"key": "selectedSchemas", "type": "[str]"},
    }

    def __init__(
        self, *, connection_info: "_models.OracleConnectionInfo", selected_schemas: List[str], **kwargs: Any
    ) -> None:
        """
        :keyword connection_info: Information for connecting to Oracle source. Required.
        :paramtype connection_info: ~azure.mgmt.datamigration.models.OracleConnectionInfo
        :keyword selected_schemas: List of Oracle schemas for which to collect tables. Required.
        :paramtype selected_schemas: list[str]
        """
        super().__init__(**kwargs)
        self.connection_info = connection_info
        self.selected_schemas = selected_schemas


class GetUserTablesOracleTaskOutput(_serialization.Model):
    """Output for the task that gets the list of tables contained within a provided list of Oracle
    schemas.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar schema_name: The schema this result is for.
    :vartype schema_name: str
    :ivar tables: List of valid tables found for this schema.
    :vartype tables: list[~azure.mgmt.datamigration.models.DatabaseTable]
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "schema_name": {"readonly": True},
        "tables": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "schema_name": {"key": "schemaName", "type": "str"},
        "tables": {"key": "tables", "type": "[DatabaseTable]"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.schema_name: Optional[str] = None
        self.tables: Optional[List["_models.DatabaseTable"]] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class GetUserTablesOracleTaskProperties(ProjectTaskProperties):
    """Properties for the task that collects user tables for the given list of Oracle schemas.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.GetUserTablesOracleTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.GetUserTablesOracleTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "GetUserTablesOracleTaskInput"},
        "output": {"key": "output", "type": "[GetUserTablesOracleTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.GetUserTablesOracleTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.GetUserTablesOracleTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "GetUserTablesOracle"
        self.input = input
        self.output: Optional[List["_models.GetUserTablesOracleTaskOutput"]] = None


class GetUserTablesPostgreSqlTaskInput(_serialization.Model):
    """Input for the task that gets the list of tables for a provided list of PostgreSQL databases.

    All required parameters must be populated in order to send to server.

    :ivar connection_info: Information for connecting to PostgreSQL source. Required.
    :vartype connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    :ivar selected_databases: List of PostgreSQL databases for which to collect tables. Required.
    :vartype selected_databases: list[str]
    """

    _validation = {
        "connection_info": {"required": True},
        "selected_databases": {"required": True},
    }

    _attribute_map = {
        "connection_info": {"key": "connectionInfo", "type": "PostgreSqlConnectionInfo"},
        "selected_databases": {"key": "selectedDatabases", "type": "[str]"},
    }

    def __init__(
        self, *, connection_info: "_models.PostgreSqlConnectionInfo", selected_databases: List[str], **kwargs: Any
    ) -> None:
        """
        :keyword connection_info: Information for connecting to PostgreSQL source. Required.
        :paramtype connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
        :keyword selected_databases: List of PostgreSQL databases for which to collect tables.
         Required.
        :paramtype selected_databases: list[str]
        """
        super().__init__(**kwargs)
        self.connection_info = connection_info
        self.selected_databases = selected_databases


class GetUserTablesPostgreSqlTaskOutput(_serialization.Model):
    """Output for the task that gets the list of tables for a provided list of PostgreSQL databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar database_name: The database this result is for.
    :vartype database_name: str
    :ivar tables: List of valid tables found for this database.
    :vartype tables: list[~azure.mgmt.datamigration.models.DatabaseTable]
    :ivar validation_errors: Validation errors associated with the task.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "database_name": {"readonly": True},
        "tables": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "database_name": {"key": "databaseName", "type": "str"},
        "tables": {"key": "tables", "type": "[DatabaseTable]"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.database_name: Optional[str] = None
        self.tables: Optional[List["_models.DatabaseTable"]] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class GetUserTablesPostgreSqlTaskProperties(ProjectTaskProperties):
    """Properties for the task that collects user tables for the given list of databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.GetUserTablesPostgreSqlTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.GetUserTablesPostgreSqlTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "GetUserTablesPostgreSqlTaskInput"},
        "output": {"key": "output", "type": "[GetUserTablesPostgreSqlTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.GetUserTablesPostgreSqlTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.GetUserTablesPostgreSqlTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "GetUserTablesPostgreSql"
        self.input = input
        self.output: Optional[List["_models.GetUserTablesPostgreSqlTaskOutput"]] = None


class GetUserTablesSqlSyncTaskInput(_serialization.Model):
    """Input for the task that collects user tables for the given list of databases.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Connection information for SQL Server. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar target_connection_info: Connection information for SQL DB. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar selected_source_databases: List of source database names to collect tables for. Required.
    :vartype selected_source_databases: list[str]
    :ivar selected_target_databases: List of target database names to collect tables for. Required.
    :vartype selected_target_databases: list[str]
    """

    _validation = {
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
        "selected_source_databases": {"required": True},
        "selected_target_databases": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "SqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "SqlConnectionInfo"},
        "selected_source_databases": {"key": "selectedSourceDatabases", "type": "[str]"},
        "selected_target_databases": {"key": "selectedTargetDatabases", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.SqlConnectionInfo",
        target_connection_info: "_models.SqlConnectionInfo",
        selected_source_databases: List[str],
        selected_target_databases: List[str],
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Connection information for SQL Server. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword target_connection_info: Connection information for SQL DB. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword selected_source_databases: List of source database names to collect tables for.
         Required.
        :paramtype selected_source_databases: list[str]
        :keyword selected_target_databases: List of target database names to collect tables for.
         Required.
        :paramtype selected_target_databases: list[str]
        """
        super().__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info
        self.selected_source_databases = selected_source_databases
        self.selected_target_databases = selected_target_databases


class GetUserTablesSqlSyncTaskOutput(_serialization.Model):
    """Output of the task that collects user tables for the given list of databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar databases_to_source_tables: Mapping from database name to list of source tables.
    :vartype databases_to_source_tables: str
    :ivar databases_to_target_tables: Mapping from database name to list of target tables.
    :vartype databases_to_target_tables: str
    :ivar table_validation_errors: Mapping from database name to list of validation errors.
    :vartype table_validation_errors: str
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "databases_to_source_tables": {"readonly": True},
        "databases_to_target_tables": {"readonly": True},
        "table_validation_errors": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "databases_to_source_tables": {"key": "databasesToSourceTables", "type": "str"},
        "databases_to_target_tables": {"key": "databasesToTargetTables", "type": "str"},
        "table_validation_errors": {"key": "tableValidationErrors", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.databases_to_source_tables: Optional[str] = None
        self.databases_to_target_tables: Optional[str] = None
        self.table_validation_errors: Optional[str] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class GetUserTablesSqlSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that collects user tables for the given list of databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.GetUserTablesSqlSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.GetUserTablesSqlSyncTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "GetUserTablesSqlSyncTaskInput"},
        "output": {"key": "output", "type": "[GetUserTablesSqlSyncTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.GetUserTablesSqlSyncTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.GetUserTablesSqlSyncTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "GetUserTables.AzureSqlDb.Sync"
        self.input = input
        self.output: Optional[List["_models.GetUserTablesSqlSyncTaskOutput"]] = None


class GetUserTablesSqlTaskInput(_serialization.Model):
    """Input for the task that collects user tables for the given list of databases.

    All required parameters must be populated in order to send to server.

    :ivar connection_info: Connection information for SQL Server. Required.
    :vartype connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar selected_databases: List of database names to collect tables for. Required.
    :vartype selected_databases: list[str]
    :ivar encrypted_key_for_secure_fields: encrypted key for secure fields.
    :vartype encrypted_key_for_secure_fields: str
    """

    _validation = {
        "connection_info": {"required": True},
        "selected_databases": {"required": True},
    }

    _attribute_map = {
        "connection_info": {"key": "connectionInfo", "type": "SqlConnectionInfo"},
        "selected_databases": {"key": "selectedDatabases", "type": "[str]"},
        "encrypted_key_for_secure_fields": {"key": "encryptedKeyForSecureFields", "type": "str"},
    }

    def __init__(
        self,
        *,
        connection_info: "_models.SqlConnectionInfo",
        selected_databases: List[str],
        encrypted_key_for_secure_fields: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword connection_info: Connection information for SQL Server. Required.
        :paramtype connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword selected_databases: List of database names to collect tables for. Required.
        :paramtype selected_databases: list[str]
        :keyword encrypted_key_for_secure_fields: encrypted key for secure fields.
        :paramtype encrypted_key_for_secure_fields: str
        """
        super().__init__(**kwargs)
        self.connection_info = connection_info
        self.selected_databases = selected_databases
        self.encrypted_key_for_secure_fields = encrypted_key_for_secure_fields


class GetUserTablesSqlTaskOutput(_serialization.Model):
    """Output of the task that collects user tables for the given list of databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar databases_to_tables: Mapping from database name to list of tables.
    :vartype databases_to_tables: str
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "databases_to_tables": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "databases_to_tables": {"key": "databasesToTables", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.databases_to_tables: Optional[str] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class GetUserTablesSqlTaskProperties(ProjectTaskProperties):
    """Properties for the task that collects user tables for the given list of databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.GetUserTablesSqlTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.GetUserTablesSqlTaskOutput]
    :ivar task_id: Task id.
    :vartype task_id: str
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "GetUserTablesSqlTaskInput"},
        "output": {"key": "output", "type": "[GetUserTablesSqlTaskOutput]"},
        "task_id": {"key": "taskId", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.GetUserTablesSqlTaskInput"] = None,
        task_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.GetUserTablesSqlTaskInput
        :keyword task_id: Task id.
        :paramtype task_id: str
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "GetUserTables.Sql"
        self.input = input
        self.output: Optional[List["_models.GetUserTablesSqlTaskOutput"]] = None
        self.task_id = task_id


class InstallOCIDriverTaskInput(_serialization.Model):
    """Input for the service task to install an OCI driver.

    :ivar driver_package_name: Name of the uploaded driver package to install.
    :vartype driver_package_name: str
    """

    _attribute_map = {
        "driver_package_name": {"key": "driverPackageName", "type": "str"},
    }

    def __init__(self, *, driver_package_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword driver_package_name: Name of the uploaded driver package to install.
        :paramtype driver_package_name: str
        """
        super().__init__(**kwargs)
        self.driver_package_name = driver_package_name


class InstallOCIDriverTaskOutput(_serialization.Model):
    """Output for the service task to install an OCI driver.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class InstallOCIDriverTaskProperties(ProjectTaskProperties):
    """Properties for the task that installs an OCI driver.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Input for the service task to install an OCI driver.
    :vartype input: ~azure.mgmt.datamigration.models.InstallOCIDriverTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.InstallOCIDriverTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "InstallOCIDriverTaskInput"},
        "output": {"key": "output", "type": "[InstallOCIDriverTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.InstallOCIDriverTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Input for the service task to install an OCI driver.
        :paramtype input: ~azure.mgmt.datamigration.models.InstallOCIDriverTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Service.Install.OCI"
        self.input = input
        self.output: Optional[List["_models.InstallOCIDriverTaskOutput"]] = None


class IntegrationRuntimeMonitoringData(_serialization.Model):
    """Integration Runtime Monitoring Data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of Integration Runtime.
    :vartype name: str
    :ivar nodes: Integration Runtime node monitoring data.
    :vartype nodes: list[~azure.mgmt.datamigration.models.NodeMonitoringData]
    """

    _validation = {
        "name": {"readonly": True},
        "nodes": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "nodes": {"key": "nodes", "type": "[NodeMonitoringData]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.nodes: Optional[List["_models.NodeMonitoringData"]] = None


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.datamigration.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.datamigration.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.datamigration.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.datamigration.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class MigrateMISyncCompleteCommandInput(_serialization.Model):
    """Input for command that completes online migration for an Azure SQL Database Managed Instance.

    All required parameters must be populated in order to send to server.

    :ivar source_database_name: Name of managed instance database. Required.
    :vartype source_database_name: str
    """

    _validation = {
        "source_database_name": {"required": True},
    }

    _attribute_map = {
        "source_database_name": {"key": "sourceDatabaseName", "type": "str"},
    }

    def __init__(self, *, source_database_name: str, **kwargs: Any) -> None:
        """
        :keyword source_database_name: Name of managed instance database. Required.
        :paramtype source_database_name: str
        """
        super().__init__(**kwargs)
        self.source_database_name = source_database_name


class MigrateMISyncCompleteCommandOutput(_serialization.Model):
    """Output for command that completes online migration for an Azure SQL Database Managed Instance.

    :ivar errors: List of errors that happened during the command execution.
    :vartype errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _attribute_map = {
        "errors": {"key": "errors", "type": "[ReportableException]"},
    }

    def __init__(self, *, errors: Optional[List["_models.ReportableException"]] = None, **kwargs: Any) -> None:
        """
        :keyword errors: List of errors that happened during the command execution.
        :paramtype errors: list[~azure.mgmt.datamigration.models.ReportableException]
        """
        super().__init__(**kwargs)
        self.errors = errors


class MigrateMISyncCompleteCommandProperties(CommandProperties):
    """Properties for the command that completes online migration for an Azure SQL Database Managed
    Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar command_type: Command type. Required. Known values are: "Migrate.Sync.Complete.Database",
     "Migrate.SqlServer.AzureDbSqlMi.Complete", "cancel", "finish", and "restart".
    :vartype command_type: str or ~azure.mgmt.datamigration.models.CommandType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the command. This is ignored if submitted. Known values are:
     "Unknown", "Accepted", "Running", "Succeeded", and "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.CommandState
    :ivar input: Command input.
    :vartype input: ~azure.mgmt.datamigration.models.MigrateMISyncCompleteCommandInput
    :ivar output: Command output. This is ignored if submitted.
    :vartype output: ~azure.mgmt.datamigration.models.MigrateMISyncCompleteCommandOutput
    """

    _validation = {
        "command_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "command_type": {"key": "commandType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "input": {"key": "input", "type": "MigrateMISyncCompleteCommandInput"},
        "output": {"key": "output", "type": "MigrateMISyncCompleteCommandOutput"},
    }

    def __init__(self, *, input: Optional["_models.MigrateMISyncCompleteCommandInput"] = None, **kwargs: Any) -> None:
        """
        :keyword input: Command input.
        :paramtype input: ~azure.mgmt.datamigration.models.MigrateMISyncCompleteCommandInput
        """
        super().__init__(**kwargs)
        self.command_type: str = "Migrate.SqlServer.AzureDbSqlMi.Complete"
        self.input = input
        self.output: Optional["_models.MigrateMISyncCompleteCommandOutput"] = None


class MigrateMongoDbTaskProperties(ProjectTaskProperties):
    """Properties for the task that migrates data between MongoDB data sources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Describes how a MongoDB data migration should be performed.
    :vartype input: ~azure.mgmt.datamigration.models.MongoDbMigrationSettings
    :ivar output:
    :vartype output: list[~azure.mgmt.datamigration.models.MongoDbProgress]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "MongoDbMigrationSettings"},
        "output": {"key": "output", "type": "[MongoDbProgress]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.MongoDbMigrationSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Describes how a MongoDB data migration should be performed.
        :paramtype input: ~azure.mgmt.datamigration.models.MongoDbMigrationSettings
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Migrate.MongoDb"
        self.input = input
        self.output: Optional[List["_models.MongoDbProgress"]] = None


class MigrateMySqlAzureDbForMySqlOfflineDatabaseInput(_serialization.Model):  # pylint: disable=name-too-long
    """Database specific information for offline MySQL to Azure Database for MySQL migration task
    inputs.

    :ivar name: Name of the database.
    :vartype name: str
    :ivar target_database_name: Name of target database. Note: Target database will be truncated
     before starting migration.
    :vartype target_database_name: str
    :ivar table_map: Mapping of source to target tables.
    :vartype table_map: dict[str, str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "target_database_name": {"key": "targetDatabaseName", "type": "str"},
        "table_map": {"key": "tableMap", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        target_database_name: Optional[str] = None,
        table_map: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the database.
        :paramtype name: str
        :keyword target_database_name: Name of target database. Note: Target database will be truncated
         before starting migration.
        :paramtype target_database_name: str
        :keyword table_map: Mapping of source to target tables.
        :paramtype table_map: dict[str, str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.target_database_name = target_database_name
        self.table_map = table_map


class MigrateMySqlAzureDbForMySqlOfflineTaskInput(_serialization.Model):  # pylint: disable=name-too-long
    """Input for the task that migrates MySQL databases to Azure Database for MySQL for offline
    migrations.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Connection information for source MySQL. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
    :ivar target_connection_info: Connection information for target Azure Database for MySQL.
     Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
    :ivar selected_databases: Databases to migrate. Required.
    :vartype selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateMySqlAzureDbForMySqlOfflineDatabaseInput]
    :ivar make_source_server_read_only: Setting to set the source server read only.
    :vartype make_source_server_read_only: bool
    :ivar started_on: Parameter to specify when the migration started.
    :vartype started_on: ~datetime.datetime
    :ivar optional_agent_settings: Optional parameters for fine tuning the data transfer rate
     during migration.
    :vartype optional_agent_settings: dict[str, str]
    :ivar encrypted_key_for_secure_fields: encrypted key for secure fields.
    :vartype encrypted_key_for_secure_fields: str
    """

    _validation = {
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
        "selected_databases": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "MySqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "MySqlConnectionInfo"},
        "selected_databases": {"key": "selectedDatabases", "type": "[MigrateMySqlAzureDbForMySqlOfflineDatabaseInput]"},
        "make_source_server_read_only": {"key": "makeSourceServerReadOnly", "type": "bool"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "optional_agent_settings": {"key": "optionalAgentSettings", "type": "{str}"},
        "encrypted_key_for_secure_fields": {"key": "encryptedKeyForSecureFields", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.MySqlConnectionInfo",
        target_connection_info: "_models.MySqlConnectionInfo",
        selected_databases: List["_models.MigrateMySqlAzureDbForMySqlOfflineDatabaseInput"],
        make_source_server_read_only: bool = False,
        started_on: Optional[datetime.datetime] = None,
        optional_agent_settings: Optional[Dict[str, str]] = None,
        encrypted_key_for_secure_fields: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Connection information for source MySQL. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
        :keyword target_connection_info: Connection information for target Azure Database for MySQL.
         Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
        :keyword selected_databases: Databases to migrate. Required.
        :paramtype selected_databases:
         list[~azure.mgmt.datamigration.models.MigrateMySqlAzureDbForMySqlOfflineDatabaseInput]
        :keyword make_source_server_read_only: Setting to set the source server read only.
        :paramtype make_source_server_read_only: bool
        :keyword started_on: Parameter to specify when the migration started.
        :paramtype started_on: ~datetime.datetime
        :keyword optional_agent_settings: Optional parameters for fine tuning the data transfer rate
         during migration.
        :paramtype optional_agent_settings: dict[str, str]
        :keyword encrypted_key_for_secure_fields: encrypted key for secure fields.
        :paramtype encrypted_key_for_secure_fields: str
        """
        super().__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info
        self.selected_databases = selected_databases
        self.make_source_server_read_only = make_source_server_read_only
        self.started_on = started_on
        self.optional_agent_settings = optional_agent_settings
        self.encrypted_key_for_secure_fields = encrypted_key_for_secure_fields


class MigrateMySqlAzureDbForMySqlOfflineTaskOutput(_serialization.Model):  # pylint: disable=name-too-long
    """Output for the task that migrates MySQL databases to Azure Database for MySQL for offline
    migrations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel,
    MigrateMySqlAzureDbForMySqlOfflineTaskOutputError,
    MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel,
    MigrateMySqlAzureDbForMySqlOfflineTaskOutputTableLevel

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
    }

    _subtype_map = {
        "result_type": {
            "DatabaseLevelOutput": "MigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel",
            "ErrorOutput": "MigrateMySqlAzureDbForMySqlOfflineTaskOutputError",
            "MigrationLevelOutput": "MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel",
            "TableLevelOutput": "MigrateMySqlAzureDbForMySqlOfflineTaskOutputTableLevel",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.result_type: Optional[str] = None


class MigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel(
    MigrateMySqlAzureDbForMySqlOfflineTaskOutput
):  # pylint: disable=name-too-long
    """MigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar state: Current state of migration. Known values are: "None", "InProgress", "Failed",
     "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar stage: Migration stage that this database is in. Known values are: "None", "Initialize",
     "Backup", "FileCopy", "Restore", and "Completed".
    :vartype stage: str or ~azure.mgmt.datamigration.models.DatabaseMigrationStage
    :ivar status_message: Status message.
    :vartype status_message: str
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar number_of_objects: Number of objects.
    :vartype number_of_objects: int
    :ivar number_of_objects_completed: Number of successfully completed objects.
    :vartype number_of_objects_completed: int
    :ivar error_count: Number of database/object errors.
    :vartype error_count: int
    :ivar error_prefix: Wildcard string prefix to use for querying all errors of the item.
    :vartype error_prefix: str
    :ivar result_prefix: Wildcard string prefix to use for querying all sub-tem results of the
     item.
    :vartype result_prefix: str
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar last_storage_update: Last time the storage was updated.
    :vartype last_storage_update: ~datetime.datetime
    :ivar object_summary: Summary of object results in the migration.
    :vartype object_summary: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "database_name": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "state": {"readonly": True},
        "stage": {"readonly": True},
        "status_message": {"readonly": True},
        "message": {"readonly": True},
        "number_of_objects": {"readonly": True},
        "number_of_objects_completed": {"readonly": True},
        "error_count": {"readonly": True},
        "error_prefix": {"readonly": True},
        "result_prefix": {"readonly": True},
        "exceptions_and_warnings": {"readonly": True},
        "last_storage_update": {"readonly": True},
        "object_summary": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "state": {"key": "state", "type": "str"},
        "stage": {"key": "stage", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "number_of_objects": {"key": "numberOfObjects", "type": "int"},
        "number_of_objects_completed": {"key": "numberOfObjectsCompleted", "type": "int"},
        "error_count": {"key": "errorCount", "type": "int"},
        "error_prefix": {"key": "errorPrefix", "type": "str"},
        "result_prefix": {"key": "resultPrefix", "type": "str"},
        "exceptions_and_warnings": {"key": "exceptionsAndWarnings", "type": "[ReportableException]"},
        "last_storage_update": {"key": "lastStorageUpdate", "type": "iso-8601"},
        "object_summary": {"key": "objectSummary", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "DatabaseLevelOutput"
        self.database_name: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.state: Optional[Union[str, "_models.MigrationState"]] = None
        self.stage: Optional[Union[str, "_models.DatabaseMigrationStage"]] = None
        self.status_message: Optional[str] = None
        self.message: Optional[str] = None
        self.number_of_objects: Optional[int] = None
        self.number_of_objects_completed: Optional[int] = None
        self.error_count: Optional[int] = None
        self.error_prefix: Optional[str] = None
        self.result_prefix: Optional[str] = None
        self.exceptions_and_warnings: Optional[List["_models.ReportableException"]] = None
        self.last_storage_update: Optional[datetime.datetime] = None
        self.object_summary: Optional[str] = None


class MigrateMySqlAzureDbForMySqlOfflineTaskOutputError(
    MigrateMySqlAzureDbForMySqlOfflineTaskOutput
):  # pylint: disable=name-too-long
    """MigrateMySqlAzureDbForMySqlOfflineTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "error": {"key": "error", "type": "ReportableException"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "ErrorOutput"
        self.error: Optional["_models.ReportableException"] = None


class MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel(
    MigrateMySqlAzureDbForMySqlOfflineTaskOutput
):  # pylint: disable=name-too-long
    """MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar duration_in_seconds: Duration of task execution in seconds.
    :vartype duration_in_seconds: int
    :ivar status: Current status of migration. Known values are: "Default", "Connecting",
     "SourceAndTargetSelected", "SelectLogins", "Configured", "Running", "Error", "Stopped",
     "Completed", and "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.datamigration.models.MigrationStatus
    :ivar status_message: Migration status message.
    :vartype status_message: str
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar databases: Selected databases as a map from database name to database id.
    :vartype databases: str
    :ivar database_summary: Summary of database results in the migration.
    :vartype database_summary: str
    :ivar migration_report_result: Migration Report Result, provides unique url for downloading
     your migration report.
    :vartype migration_report_result: ~azure.mgmt.datamigration.models.MigrationReportResult
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar last_storage_update: Last time the storage was updated.
    :vartype last_storage_update: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "duration_in_seconds": {"readonly": True},
        "status": {"readonly": True},
        "status_message": {"readonly": True},
        "message": {"readonly": True},
        "database_summary": {"readonly": True},
        "source_server_version": {"readonly": True},
        "source_server_brand_version": {"readonly": True},
        "target_server_version": {"readonly": True},
        "target_server_brand_version": {"readonly": True},
        "exceptions_and_warnings": {"readonly": True},
        "last_storage_update": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "duration_in_seconds": {"key": "durationInSeconds", "type": "int"},
        "status": {"key": "status", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "databases": {"key": "databases", "type": "str"},
        "database_summary": {"key": "databaseSummary", "type": "str"},
        "migration_report_result": {"key": "migrationReportResult", "type": "MigrationReportResult"},
        "source_server_version": {"key": "sourceServerVersion", "type": "str"},
        "source_server_brand_version": {"key": "sourceServerBrandVersion", "type": "str"},
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "target_server_brand_version": {"key": "targetServerBrandVersion", "type": "str"},
        "exceptions_and_warnings": {"key": "exceptionsAndWarnings", "type": "[ReportableException]"},
        "last_storage_update": {"key": "lastStorageUpdate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        databases: Optional[str] = None,
        migration_report_result: Optional["_models.MigrationReportResult"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword databases: Selected databases as a map from database name to database id.
        :paramtype databases: str
        :keyword migration_report_result: Migration Report Result, provides unique url for downloading
         your migration report.
        :paramtype migration_report_result: ~azure.mgmt.datamigration.models.MigrationReportResult
        """
        super().__init__(**kwargs)
        self.result_type: str = "MigrationLevelOutput"
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.duration_in_seconds: Optional[int] = None
        self.status: Optional[Union[str, "_models.MigrationStatus"]] = None
        self.status_message: Optional[str] = None
        self.message: Optional[str] = None
        self.databases = databases
        self.database_summary: Optional[str] = None
        self.migration_report_result = migration_report_result
        self.source_server_version: Optional[str] = None
        self.source_server_brand_version: Optional[str] = None
        self.target_server_version: Optional[str] = None
        self.target_server_brand_version: Optional[str] = None
        self.exceptions_and_warnings: Optional[List["_models.ReportableException"]] = None
        self.last_storage_update: Optional[datetime.datetime] = None


class MigrateMySqlAzureDbForMySqlOfflineTaskOutputTableLevel(
    MigrateMySqlAzureDbForMySqlOfflineTaskOutput
):  # pylint: disable=name-too-long
    """MigrateMySqlAzureDbForMySqlOfflineTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar object_name: Name of the item.
    :vartype object_name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar state: Current state of migration. Known values are: "None", "InProgress", "Failed",
     "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar status_message: Status message.
    :vartype status_message: str
    :ivar items_count: Number of items.
    :vartype items_count: int
    :ivar items_completed_count: Number of successfully completed items.
    :vartype items_completed_count: int
    :ivar error_prefix: Wildcard string prefix to use for querying all errors of the item.
    :vartype error_prefix: str
    :ivar result_prefix: Wildcard string prefix to use for querying all sub-tem results of the
     item.
    :vartype result_prefix: str
    :ivar last_storage_update: Last time the storage was updated.
    :vartype last_storage_update: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "object_name": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "state": {"readonly": True},
        "status_message": {"readonly": True},
        "items_count": {"readonly": True},
        "items_completed_count": {"readonly": True},
        "error_prefix": {"readonly": True},
        "result_prefix": {"readonly": True},
        "last_storage_update": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "object_name": {"key": "objectName", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "state": {"key": "state", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "str"},
        "items_count": {"key": "itemsCount", "type": "int"},
        "items_completed_count": {"key": "itemsCompletedCount", "type": "int"},
        "error_prefix": {"key": "errorPrefix", "type": "str"},
        "result_prefix": {"key": "resultPrefix", "type": "str"},
        "last_storage_update": {"key": "lastStorageUpdate", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "TableLevelOutput"
        self.object_name: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.state: Optional[Union[str, "_models.MigrationState"]] = None
        self.status_message: Optional[str] = None
        self.items_count: Optional[int] = None
        self.items_completed_count: Optional[int] = None
        self.error_prefix: Optional[str] = None
        self.result_prefix: Optional[str] = None
        self.last_storage_update: Optional[datetime.datetime] = None


class MigrateMySqlAzureDbForMySqlOfflineTaskProperties(ProjectTaskProperties):  # pylint: disable=name-too-long
    """Properties for the task that migrates MySQL databases to Azure Database for MySQL for offline
    migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.MigrateMySqlAzureDbForMySqlOfflineTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.MigrateMySqlAzureDbForMySqlOfflineTaskOutput]
    :ivar is_cloneable: whether the task can be cloned or not.
    :vartype is_cloneable: bool
    :ivar task_id: Task id.
    :vartype task_id: str
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "MigrateMySqlAzureDbForMySqlOfflineTaskInput"},
        "output": {"key": "output", "type": "[MigrateMySqlAzureDbForMySqlOfflineTaskOutput]"},
        "is_cloneable": {"key": "isCloneable", "type": "bool"},
        "task_id": {"key": "taskId", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.MigrateMySqlAzureDbForMySqlOfflineTaskInput"] = None,
        is_cloneable: Optional[bool] = None,
        task_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.MigrateMySqlAzureDbForMySqlOfflineTaskInput
        :keyword is_cloneable: whether the task can be cloned or not.
        :paramtype is_cloneable: bool
        :keyword task_id: Task id.
        :paramtype task_id: str
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Migrate.MySql.AzureDbForMySql"
        self.input = input
        self.output: Optional[List["_models.MigrateMySqlAzureDbForMySqlOfflineTaskOutput"]] = None
        self.is_cloneable = is_cloneable
        self.task_id = task_id


class MigrateMySqlAzureDbForMySqlSyncDatabaseInput(_serialization.Model):  # pylint: disable=name-too-long
    """Database specific information for MySQL to Azure Database for MySQL migration task inputs.

    :ivar name: Name of the database.
    :vartype name: str
    :ivar target_database_name: Name of target database. Note: Target database will be truncated
     before starting migration.
    :vartype target_database_name: str
    :ivar migration_setting: Migration settings which tune the migration behavior.
    :vartype migration_setting: dict[str, str]
    :ivar source_setting: Source settings to tune source endpoint migration behavior.
    :vartype source_setting: dict[str, str]
    :ivar target_setting: Target settings to tune target endpoint migration behavior.
    :vartype target_setting: dict[str, str]
    :ivar table_map: Mapping of source to target tables.
    :vartype table_map: dict[str, str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "target_database_name": {"key": "targetDatabaseName", "type": "str"},
        "migration_setting": {"key": "migrationSetting", "type": "{str}"},
        "source_setting": {"key": "sourceSetting", "type": "{str}"},
        "target_setting": {"key": "targetSetting", "type": "{str}"},
        "table_map": {"key": "tableMap", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        target_database_name: Optional[str] = None,
        migration_setting: Optional[Dict[str, str]] = None,
        source_setting: Optional[Dict[str, str]] = None,
        target_setting: Optional[Dict[str, str]] = None,
        table_map: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the database.
        :paramtype name: str
        :keyword target_database_name: Name of target database. Note: Target database will be truncated
         before starting migration.
        :paramtype target_database_name: str
        :keyword migration_setting: Migration settings which tune the migration behavior.
        :paramtype migration_setting: dict[str, str]
        :keyword source_setting: Source settings to tune source endpoint migration behavior.
        :paramtype source_setting: dict[str, str]
        :keyword target_setting: Target settings to tune target endpoint migration behavior.
        :paramtype target_setting: dict[str, str]
        :keyword table_map: Mapping of source to target tables.
        :paramtype table_map: dict[str, str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.target_database_name = target_database_name
        self.migration_setting = migration_setting
        self.source_setting = source_setting
        self.target_setting = target_setting
        self.table_map = table_map


class MigrateMySqlAzureDbForMySqlSyncTaskInput(_serialization.Model):
    """Input for the task that migrates MySQL databases to Azure Database for MySQL for online
    migrations.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Connection information for source MySQL. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
    :ivar target_connection_info: Connection information for target Azure Database for MySQL.
     Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
    :ivar selected_databases: Databases to migrate. Required.
    :vartype selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateMySqlAzureDbForMySqlSyncDatabaseInput]
    """

    _validation = {
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
        "selected_databases": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "MySqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "MySqlConnectionInfo"},
        "selected_databases": {"key": "selectedDatabases", "type": "[MigrateMySqlAzureDbForMySqlSyncDatabaseInput]"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.MySqlConnectionInfo",
        target_connection_info: "_models.MySqlConnectionInfo",
        selected_databases: List["_models.MigrateMySqlAzureDbForMySqlSyncDatabaseInput"],
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Connection information for source MySQL. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
        :keyword target_connection_info: Connection information for target Azure Database for MySQL.
         Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.MySqlConnectionInfo
        :keyword selected_databases: Databases to migrate. Required.
        :paramtype selected_databases:
         list[~azure.mgmt.datamigration.models.MigrateMySqlAzureDbForMySqlSyncDatabaseInput]
        """
        super().__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info
        self.selected_databases = selected_databases


class MigrateMySqlAzureDbForMySqlSyncTaskOutput(_serialization.Model):  # pylint: disable=name-too-long
    """Output for the task that migrates MySQL databases to Azure Database for MySQL for online
    migrations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseError,
    MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevel,
    MigrateMySqlAzureDbForMySqlSyncTaskOutputError,
    MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevel,
    MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevel

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
    }

    _subtype_map = {
        "result_type": {
            "DatabaseLevelErrorOutput": "MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseError",
            "DatabaseLevelOutput": "MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevel",
            "ErrorOutput": "MigrateMySqlAzureDbForMySqlSyncTaskOutputError",
            "MigrationLevelOutput": "MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevel",
            "TableLevelOutput": "MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevel",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.result_type: Optional[str] = None


class MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseError(
    MigrateMySqlAzureDbForMySqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar error_message: Error message.
    :vartype error_message: str
    :ivar events: List of error events.
    :vartype events: list[~azure.mgmt.datamigration.models.SyncMigrationDatabaseErrorEvent]
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "events": {"key": "events", "type": "[SyncMigrationDatabaseErrorEvent]"},
    }

    def __init__(
        self,
        *,
        error_message: Optional[str] = None,
        events: Optional[List["_models.SyncMigrationDatabaseErrorEvent"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_message: Error message.
        :paramtype error_message: str
        :keyword events: List of error events.
        :paramtype events: list[~azure.mgmt.datamigration.models.SyncMigrationDatabaseErrorEvent]
        """
        super().__init__(**kwargs)
        self.result_type: str = "DatabaseLevelErrorOutput"
        self.error_message = error_message
        self.events = events


class MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevel(
    MigrateMySqlAzureDbForMySqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateMySqlAzureDbForMySqlSyncTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_state: Migration state that this database is in. Known values are: "UNDEFINED",
     "CONFIGURING", "INITIALIAZING", "STARTING", "RUNNING", "READY_TO_COMPLETE", "COMPLETING",
     "COMPLETE", "CANCELLING", "CANCELLED", "FAILED", "VALIDATING", "VALIDATION_COMPLETE",
     "VALIDATION_FAILED", "RESTORE_IN_PROGRESS", "RESTORE_COMPLETED", "BACKUP_IN_PROGRESS", and
     "BACKUP_COMPLETED".
    :vartype migration_state: str or
     ~azure.mgmt.datamigration.models.SyncDatabaseMigrationReportingState
    :ivar incoming_changes: Number of incoming changes.
    :vartype incoming_changes: int
    :ivar applied_changes: Number of applied changes.
    :vartype applied_changes: int
    :ivar cdc_insert_counter: Number of cdc inserts.
    :vartype cdc_insert_counter: int
    :ivar cdc_delete_counter: Number of cdc deletes.
    :vartype cdc_delete_counter: int
    :ivar cdc_update_counter: Number of cdc updates.
    :vartype cdc_update_counter: int
    :ivar full_load_completed_tables: Number of tables completed in full load.
    :vartype full_load_completed_tables: int
    :ivar full_load_loading_tables: Number of tables loading in full load.
    :vartype full_load_loading_tables: int
    :ivar full_load_queued_tables: Number of tables queued in full load.
    :vartype full_load_queued_tables: int
    :ivar full_load_errored_tables: Number of tables errored in full load.
    :vartype full_load_errored_tables: int
    :ivar initialization_completed: Indicates if initial load (full load) has been completed.
    :vartype initialization_completed: bool
    :ivar latency: CDC apply latency.
    :vartype latency: int
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "database_name": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "migration_state": {"readonly": True},
        "incoming_changes": {"readonly": True},
        "applied_changes": {"readonly": True},
        "cdc_insert_counter": {"readonly": True},
        "cdc_delete_counter": {"readonly": True},
        "cdc_update_counter": {"readonly": True},
        "full_load_completed_tables": {"readonly": True},
        "full_load_loading_tables": {"readonly": True},
        "full_load_queued_tables": {"readonly": True},
        "full_load_errored_tables": {"readonly": True},
        "initialization_completed": {"readonly": True},
        "latency": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "migration_state": {"key": "migrationState", "type": "str"},
        "incoming_changes": {"key": "incomingChanges", "type": "int"},
        "applied_changes": {"key": "appliedChanges", "type": "int"},
        "cdc_insert_counter": {"key": "cdcInsertCounter", "type": "int"},
        "cdc_delete_counter": {"key": "cdcDeleteCounter", "type": "int"},
        "cdc_update_counter": {"key": "cdcUpdateCounter", "type": "int"},
        "full_load_completed_tables": {"key": "fullLoadCompletedTables", "type": "int"},
        "full_load_loading_tables": {"key": "fullLoadLoadingTables", "type": "int"},
        "full_load_queued_tables": {"key": "fullLoadQueuedTables", "type": "int"},
        "full_load_errored_tables": {"key": "fullLoadErroredTables", "type": "int"},
        "initialization_completed": {"key": "initializationCompleted", "type": "bool"},
        "latency": {"key": "latency", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "DatabaseLevelOutput"
        self.database_name: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.migration_state: Optional[Union[str, "_models.SyncDatabaseMigrationReportingState"]] = None
        self.incoming_changes: Optional[int] = None
        self.applied_changes: Optional[int] = None
        self.cdc_insert_counter: Optional[int] = None
        self.cdc_delete_counter: Optional[int] = None
        self.cdc_update_counter: Optional[int] = None
        self.full_load_completed_tables: Optional[int] = None
        self.full_load_loading_tables: Optional[int] = None
        self.full_load_queued_tables: Optional[int] = None
        self.full_load_errored_tables: Optional[int] = None
        self.initialization_completed: Optional[bool] = None
        self.latency: Optional[int] = None


class MigrateMySqlAzureDbForMySqlSyncTaskOutputError(
    MigrateMySqlAzureDbForMySqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateMySqlAzureDbForMySqlSyncTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "error": {"key": "error", "type": "ReportableException"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "ErrorOutput"
        self.error: Optional["_models.ReportableException"] = None


class MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevel(
    MigrateMySqlAzureDbForMySqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server: Source server name.
    :vartype source_server: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server: Target server name.
    :vartype target_server: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "source_server_version": {"readonly": True},
        "source_server": {"readonly": True},
        "target_server_version": {"readonly": True},
        "target_server": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "source_server_version": {"key": "sourceServerVersion", "type": "str"},
        "source_server": {"key": "sourceServer", "type": "str"},
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "target_server": {"key": "targetServer", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "MigrationLevelOutput"
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.source_server_version: Optional[str] = None
        self.source_server: Optional[str] = None
        self.target_server_version: Optional[str] = None
        self.target_server: Optional[str] = None


class MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevel(
    MigrateMySqlAzureDbForMySqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateMySqlAzureDbForMySqlSyncTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar table_name: Name of the table.
    :vartype table_name: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar cdc_insert_counter: Number of applied inserts.
    :vartype cdc_insert_counter: str
    :ivar cdc_update_counter: Number of applied updates.
    :vartype cdc_update_counter: str
    :ivar cdc_delete_counter: Number of applied deletes.
    :vartype cdc_delete_counter: str
    :ivar full_load_est_finish_time: Estimate to finish full load.
    :vartype full_load_est_finish_time: ~datetime.datetime
    :ivar full_load_started_on: Full load start time.
    :vartype full_load_started_on: ~datetime.datetime
    :ivar full_load_ended_on: Full load end time.
    :vartype full_load_ended_on: ~datetime.datetime
    :ivar full_load_total_rows: Number of rows applied in full load.
    :vartype full_load_total_rows: int
    :ivar state: Current state of the table migration. Known values are: "BEFORE_LOAD",
     "FULL_LOAD", "COMPLETED", "CANCELED", "ERROR", and "FAILED".
    :vartype state: str or ~azure.mgmt.datamigration.models.SyncTableMigrationState
    :ivar total_changes_applied: Total number of applied changes.
    :vartype total_changes_applied: int
    :ivar data_errors_counter: Number of data errors occurred.
    :vartype data_errors_counter: int
    :ivar last_modified_time: Last modified time on target.
    :vartype last_modified_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "table_name": {"readonly": True},
        "database_name": {"readonly": True},
        "cdc_insert_counter": {"readonly": True},
        "cdc_update_counter": {"readonly": True},
        "cdc_delete_counter": {"readonly": True},
        "full_load_est_finish_time": {"readonly": True},
        "full_load_started_on": {"readonly": True},
        "full_load_ended_on": {"readonly": True},
        "full_load_total_rows": {"readonly": True},
        "state": {"readonly": True},
        "total_changes_applied": {"readonly": True},
        "data_errors_counter": {"readonly": True},
        "last_modified_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "table_name": {"key": "tableName", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "cdc_insert_counter": {"key": "cdcInsertCounter", "type": "str"},
        "cdc_update_counter": {"key": "cdcUpdateCounter", "type": "str"},
        "cdc_delete_counter": {"key": "cdcDeleteCounter", "type": "str"},
        "full_load_est_finish_time": {"key": "fullLoadEstFinishTime", "type": "iso-8601"},
        "full_load_started_on": {"key": "fullLoadStartedOn", "type": "iso-8601"},
        "full_load_ended_on": {"key": "fullLoadEndedOn", "type": "iso-8601"},
        "full_load_total_rows": {"key": "fullLoadTotalRows", "type": "int"},
        "state": {"key": "state", "type": "str"},
        "total_changes_applied": {"key": "totalChangesApplied", "type": "int"},
        "data_errors_counter": {"key": "dataErrorsCounter", "type": "int"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "TableLevelOutput"
        self.table_name: Optional[str] = None
        self.database_name: Optional[str] = None
        self.cdc_insert_counter: Optional[str] = None
        self.cdc_update_counter: Optional[str] = None
        self.cdc_delete_counter: Optional[str] = None
        self.full_load_est_finish_time: Optional[datetime.datetime] = None
        self.full_load_started_on: Optional[datetime.datetime] = None
        self.full_load_ended_on: Optional[datetime.datetime] = None
        self.full_load_total_rows: Optional[int] = None
        self.state: Optional[Union[str, "_models.SyncTableMigrationState"]] = None
        self.total_changes_applied: Optional[int] = None
        self.data_errors_counter: Optional[int] = None
        self.last_modified_time: Optional[datetime.datetime] = None


class MigrateMySqlAzureDbForMySqlSyncTaskProperties(ProjectTaskProperties):  # pylint: disable=name-too-long
    """Properties for the task that migrates MySQL databases to Azure Database for MySQL for online
    migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.MigrateMySqlAzureDbForMySqlSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.MigrateMySqlAzureDbForMySqlSyncTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "MigrateMySqlAzureDbForMySqlSyncTaskInput"},
        "output": {"key": "output", "type": "[MigrateMySqlAzureDbForMySqlSyncTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.MigrateMySqlAzureDbForMySqlSyncTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.MigrateMySqlAzureDbForMySqlSyncTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Migrate.MySql.AzureDbForMySql.Sync"
        self.input = input
        self.output: Optional[List["_models.MigrateMySqlAzureDbForMySqlSyncTaskOutput"]] = None


class MigrateOracleAzureDbForPostgreSqlSyncTaskProperties(ProjectTaskProperties):  # pylint: disable=name-too-long
    """Properties for the task that migrates Oracle to Azure Database for PostgreSQL for online
    migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.MigrateOracleAzureDbPostgreSqlSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.MigrateOracleAzureDbPostgreSqlSyncTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "MigrateOracleAzureDbPostgreSqlSyncTaskInput"},
        "output": {"key": "output", "type": "[MigrateOracleAzureDbPostgreSqlSyncTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.MigrateOracleAzureDbPostgreSqlSyncTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.MigrateOracleAzureDbPostgreSqlSyncTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Migrate.Oracle.AzureDbForPostgreSql.Sync"
        self.input = input
        self.output: Optional[List["_models.MigrateOracleAzureDbPostgreSqlSyncTaskOutput"]] = None


class MigrateOracleAzureDbPostgreSqlSyncDatabaseInput(_serialization.Model):  # pylint: disable=name-too-long
    """Database specific information for Oracle to Azure Database for PostgreSQL migration task
    inputs.

    :ivar case_manipulation: How to handle object name casing: either Preserve or ToLower.
    :vartype case_manipulation: str
    :ivar name: Name of the migration pipeline.
    :vartype name: str
    :ivar schema_name: Name of the source schema.
    :vartype schema_name: str
    :ivar table_map: Mapping of source to target tables.
    :vartype table_map: dict[str, str]
    :ivar target_database_name: Name of target database. Note: Target database will be truncated
     before starting migration.
    :vartype target_database_name: str
    :ivar migration_setting: Migration settings which tune the migration behavior.
    :vartype migration_setting: dict[str, str]
    :ivar source_setting: Source settings to tune source endpoint migration behavior.
    :vartype source_setting: dict[str, str]
    :ivar target_setting: Target settings to tune target endpoint migration behavior.
    :vartype target_setting: dict[str, str]
    """

    _attribute_map = {
        "case_manipulation": {"key": "caseManipulation", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "schema_name": {"key": "schemaName", "type": "str"},
        "table_map": {"key": "tableMap", "type": "{str}"},
        "target_database_name": {"key": "targetDatabaseName", "type": "str"},
        "migration_setting": {"key": "migrationSetting", "type": "{str}"},
        "source_setting": {"key": "sourceSetting", "type": "{str}"},
        "target_setting": {"key": "targetSetting", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        case_manipulation: Optional[str] = None,
        name: Optional[str] = None,
        schema_name: Optional[str] = None,
        table_map: Optional[Dict[str, str]] = None,
        target_database_name: Optional[str] = None,
        migration_setting: Optional[Dict[str, str]] = None,
        source_setting: Optional[Dict[str, str]] = None,
        target_setting: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword case_manipulation: How to handle object name casing: either Preserve or ToLower.
        :paramtype case_manipulation: str
        :keyword name: Name of the migration pipeline.
        :paramtype name: str
        :keyword schema_name: Name of the source schema.
        :paramtype schema_name: str
        :keyword table_map: Mapping of source to target tables.
        :paramtype table_map: dict[str, str]
        :keyword target_database_name: Name of target database. Note: Target database will be truncated
         before starting migration.
        :paramtype target_database_name: str
        :keyword migration_setting: Migration settings which tune the migration behavior.
        :paramtype migration_setting: dict[str, str]
        :keyword source_setting: Source settings to tune source endpoint migration behavior.
        :paramtype source_setting: dict[str, str]
        :keyword target_setting: Target settings to tune target endpoint migration behavior.
        :paramtype target_setting: dict[str, str]
        """
        super().__init__(**kwargs)
        self.case_manipulation = case_manipulation
        self.name = name
        self.schema_name = schema_name
        self.table_map = table_map
        self.target_database_name = target_database_name
        self.migration_setting = migration_setting
        self.source_setting = source_setting
        self.target_setting = target_setting


class MigrateOracleAzureDbPostgreSqlSyncTaskInput(_serialization.Model):  # pylint: disable=name-too-long
    """Input for the task that migrates Oracle databases to Azure Database for PostgreSQL for online
    migrations.

    All required parameters must be populated in order to send to server.

    :ivar selected_databases: Databases to migrate. Required.
    :vartype selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateOracleAzureDbPostgreSqlSyncDatabaseInput]
    :ivar target_connection_info: Connection information for target Azure Database for PostgreSQL.
     Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    :ivar source_connection_info: Connection information for source Oracle. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.OracleConnectionInfo
    """

    _validation = {
        "selected_databases": {"required": True},
        "target_connection_info": {"required": True},
        "source_connection_info": {"required": True},
    }

    _attribute_map = {
        "selected_databases": {"key": "selectedDatabases", "type": "[MigrateOracleAzureDbPostgreSqlSyncDatabaseInput]"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "PostgreSqlConnectionInfo"},
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "OracleConnectionInfo"},
    }

    def __init__(
        self,
        *,
        selected_databases: List["_models.MigrateOracleAzureDbPostgreSqlSyncDatabaseInput"],
        target_connection_info: "_models.PostgreSqlConnectionInfo",
        source_connection_info: "_models.OracleConnectionInfo",
        **kwargs: Any
    ) -> None:
        """
        :keyword selected_databases: Databases to migrate. Required.
        :paramtype selected_databases:
         list[~azure.mgmt.datamigration.models.MigrateOracleAzureDbPostgreSqlSyncDatabaseInput]
        :keyword target_connection_info: Connection information for target Azure Database for
         PostgreSQL. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
        :keyword source_connection_info: Connection information for source Oracle. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.OracleConnectionInfo
        """
        super().__init__(**kwargs)
        self.selected_databases = selected_databases
        self.target_connection_info = target_connection_info
        self.source_connection_info = source_connection_info


class MigrateOracleAzureDbPostgreSqlSyncTaskOutput(_serialization.Model):  # pylint: disable=name-too-long
    """Output for the task that migrates Oracle databases to Azure Database for PostgreSQL for online
    migrations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseError,
    MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseLevel,
    MigrateOracleAzureDbPostgreSqlSyncTaskOutputError,
    MigrateOracleAzureDbPostgreSqlSyncTaskOutputMigrationLevel,
    MigrateOracleAzureDbPostgreSqlSyncTaskOutputTableLevel

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
    }

    _subtype_map = {
        "result_type": {
            "DatabaseLevelErrorOutput": "MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseError",
            "DatabaseLevelOutput": "MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseLevel",
            "ErrorOutput": "MigrateOracleAzureDbPostgreSqlSyncTaskOutputError",
            "MigrationLevelOutput": "MigrateOracleAzureDbPostgreSqlSyncTaskOutputMigrationLevel",
            "TableLevelOutput": "MigrateOracleAzureDbPostgreSqlSyncTaskOutputTableLevel",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.result_type: Optional[str] = None


class MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseError(
    MigrateOracleAzureDbPostgreSqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar error_message: Error message.
    :vartype error_message: str
    :ivar events: List of error events.
    :vartype events: list[~azure.mgmt.datamigration.models.SyncMigrationDatabaseErrorEvent]
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "events": {"key": "events", "type": "[SyncMigrationDatabaseErrorEvent]"},
    }

    def __init__(
        self,
        *,
        error_message: Optional[str] = None,
        events: Optional[List["_models.SyncMigrationDatabaseErrorEvent"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_message: Error message.
        :paramtype error_message: str
        :keyword events: List of error events.
        :paramtype events: list[~azure.mgmt.datamigration.models.SyncMigrationDatabaseErrorEvent]
        """
        super().__init__(**kwargs)
        self.result_type: str = "DatabaseLevelErrorOutput"
        self.error_message = error_message
        self.events = events


class MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseLevel(
    MigrateOracleAzureDbPostgreSqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateOracleAzureDbPostgreSqlSyncTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_state: Migration state that this database is in. Known values are: "UNDEFINED",
     "CONFIGURING", "INITIALIAZING", "STARTING", "RUNNING", "READY_TO_COMPLETE", "COMPLETING",
     "COMPLETE", "CANCELLING", "CANCELLED", "FAILED", "VALIDATING", "VALIDATION_COMPLETE",
     "VALIDATION_FAILED", "RESTORE_IN_PROGRESS", "RESTORE_COMPLETED", "BACKUP_IN_PROGRESS", and
     "BACKUP_COMPLETED".
    :vartype migration_state: str or
     ~azure.mgmt.datamigration.models.SyncDatabaseMigrationReportingState
    :ivar incoming_changes: Number of incoming changes.
    :vartype incoming_changes: int
    :ivar applied_changes: Number of applied changes.
    :vartype applied_changes: int
    :ivar cdc_insert_counter: Number of cdc inserts.
    :vartype cdc_insert_counter: int
    :ivar cdc_delete_counter: Number of cdc deletes.
    :vartype cdc_delete_counter: int
    :ivar cdc_update_counter: Number of cdc updates.
    :vartype cdc_update_counter: int
    :ivar full_load_completed_tables: Number of tables completed in full load.
    :vartype full_load_completed_tables: int
    :ivar full_load_loading_tables: Number of tables loading in full load.
    :vartype full_load_loading_tables: int
    :ivar full_load_queued_tables: Number of tables queued in full load.
    :vartype full_load_queued_tables: int
    :ivar full_load_errored_tables: Number of tables errored in full load.
    :vartype full_load_errored_tables: int
    :ivar initialization_completed: Indicates if initial load (full load) has been completed.
    :vartype initialization_completed: bool
    :ivar latency: CDC apply latency.
    :vartype latency: int
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "database_name": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "migration_state": {"readonly": True},
        "incoming_changes": {"readonly": True},
        "applied_changes": {"readonly": True},
        "cdc_insert_counter": {"readonly": True},
        "cdc_delete_counter": {"readonly": True},
        "cdc_update_counter": {"readonly": True},
        "full_load_completed_tables": {"readonly": True},
        "full_load_loading_tables": {"readonly": True},
        "full_load_queued_tables": {"readonly": True},
        "full_load_errored_tables": {"readonly": True},
        "initialization_completed": {"readonly": True},
        "latency": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "migration_state": {"key": "migrationState", "type": "str"},
        "incoming_changes": {"key": "incomingChanges", "type": "int"},
        "applied_changes": {"key": "appliedChanges", "type": "int"},
        "cdc_insert_counter": {"key": "cdcInsertCounter", "type": "int"},
        "cdc_delete_counter": {"key": "cdcDeleteCounter", "type": "int"},
        "cdc_update_counter": {"key": "cdcUpdateCounter", "type": "int"},
        "full_load_completed_tables": {"key": "fullLoadCompletedTables", "type": "int"},
        "full_load_loading_tables": {"key": "fullLoadLoadingTables", "type": "int"},
        "full_load_queued_tables": {"key": "fullLoadQueuedTables", "type": "int"},
        "full_load_errored_tables": {"key": "fullLoadErroredTables", "type": "int"},
        "initialization_completed": {"key": "initializationCompleted", "type": "bool"},
        "latency": {"key": "latency", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "DatabaseLevelOutput"
        self.database_name: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.migration_state: Optional[Union[str, "_models.SyncDatabaseMigrationReportingState"]] = None
        self.incoming_changes: Optional[int] = None
        self.applied_changes: Optional[int] = None
        self.cdc_insert_counter: Optional[int] = None
        self.cdc_delete_counter: Optional[int] = None
        self.cdc_update_counter: Optional[int] = None
        self.full_load_completed_tables: Optional[int] = None
        self.full_load_loading_tables: Optional[int] = None
        self.full_load_queued_tables: Optional[int] = None
        self.full_load_errored_tables: Optional[int] = None
        self.initialization_completed: Optional[bool] = None
        self.latency: Optional[int] = None


class MigrateOracleAzureDbPostgreSqlSyncTaskOutputError(
    MigrateOracleAzureDbPostgreSqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateOracleAzureDbPostgreSqlSyncTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "error": {"key": "error", "type": "ReportableException"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "ErrorOutput"
        self.error: Optional["_models.ReportableException"] = None


class MigrateOracleAzureDbPostgreSqlSyncTaskOutputMigrationLevel(
    MigrateOracleAzureDbPostgreSqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateOracleAzureDbPostgreSqlSyncTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server: Source server name.
    :vartype source_server: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server: Target server name.
    :vartype target_server: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "source_server_version": {"readonly": True},
        "source_server": {"readonly": True},
        "target_server_version": {"readonly": True},
        "target_server": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "source_server_version": {"key": "sourceServerVersion", "type": "str"},
        "source_server": {"key": "sourceServer", "type": "str"},
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "target_server": {"key": "targetServer", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "MigrationLevelOutput"
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.source_server_version: Optional[str] = None
        self.source_server: Optional[str] = None
        self.target_server_version: Optional[str] = None
        self.target_server: Optional[str] = None


class MigrateOracleAzureDbPostgreSqlSyncTaskOutputTableLevel(
    MigrateOracleAzureDbPostgreSqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateOracleAzureDbPostgreSqlSyncTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar table_name: Name of the table.
    :vartype table_name: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar cdc_insert_counter: Number of applied inserts.
    :vartype cdc_insert_counter: int
    :ivar cdc_update_counter: Number of applied updates.
    :vartype cdc_update_counter: int
    :ivar cdc_delete_counter: Number of applied deletes.
    :vartype cdc_delete_counter: int
    :ivar full_load_est_finish_time: Estimate to finish full load.
    :vartype full_load_est_finish_time: ~datetime.datetime
    :ivar full_load_started_on: Full load start time.
    :vartype full_load_started_on: ~datetime.datetime
    :ivar full_load_ended_on: Full load end time.
    :vartype full_load_ended_on: ~datetime.datetime
    :ivar full_load_total_rows: Number of rows applied in full load.
    :vartype full_load_total_rows: int
    :ivar state: Current state of the table migration. Known values are: "BEFORE_LOAD",
     "FULL_LOAD", "COMPLETED", "CANCELED", "ERROR", and "FAILED".
    :vartype state: str or ~azure.mgmt.datamigration.models.SyncTableMigrationState
    :ivar total_changes_applied: Total number of applied changes.
    :vartype total_changes_applied: int
    :ivar data_errors_counter: Number of data errors occurred.
    :vartype data_errors_counter: int
    :ivar last_modified_time: Last modified time on target.
    :vartype last_modified_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "table_name": {"readonly": True},
        "database_name": {"readonly": True},
        "cdc_insert_counter": {"readonly": True},
        "cdc_update_counter": {"readonly": True},
        "cdc_delete_counter": {"readonly": True},
        "full_load_est_finish_time": {"readonly": True},
        "full_load_started_on": {"readonly": True},
        "full_load_ended_on": {"readonly": True},
        "full_load_total_rows": {"readonly": True},
        "state": {"readonly": True},
        "total_changes_applied": {"readonly": True},
        "data_errors_counter": {"readonly": True},
        "last_modified_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "table_name": {"key": "tableName", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "cdc_insert_counter": {"key": "cdcInsertCounter", "type": "int"},
        "cdc_update_counter": {"key": "cdcUpdateCounter", "type": "int"},
        "cdc_delete_counter": {"key": "cdcDeleteCounter", "type": "int"},
        "full_load_est_finish_time": {"key": "fullLoadEstFinishTime", "type": "iso-8601"},
        "full_load_started_on": {"key": "fullLoadStartedOn", "type": "iso-8601"},
        "full_load_ended_on": {"key": "fullLoadEndedOn", "type": "iso-8601"},
        "full_load_total_rows": {"key": "fullLoadTotalRows", "type": "int"},
        "state": {"key": "state", "type": "str"},
        "total_changes_applied": {"key": "totalChangesApplied", "type": "int"},
        "data_errors_counter": {"key": "dataErrorsCounter", "type": "int"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "TableLevelOutput"
        self.table_name: Optional[str] = None
        self.database_name: Optional[str] = None
        self.cdc_insert_counter: Optional[int] = None
        self.cdc_update_counter: Optional[int] = None
        self.cdc_delete_counter: Optional[int] = None
        self.full_load_est_finish_time: Optional[datetime.datetime] = None
        self.full_load_started_on: Optional[datetime.datetime] = None
        self.full_load_ended_on: Optional[datetime.datetime] = None
        self.full_load_total_rows: Optional[int] = None
        self.state: Optional[Union[str, "_models.SyncTableMigrationState"]] = None
        self.total_changes_applied: Optional[int] = None
        self.data_errors_counter: Optional[int] = None
        self.last_modified_time: Optional[datetime.datetime] = None


class MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput(_serialization.Model):  # pylint: disable=name-too-long
    """Database specific information for PostgreSQL to Azure Database for PostgreSQL migration task
    inputs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the database.
    :vartype name: str
    :ivar id: Result identifier.
    :vartype id: str
    :ivar target_database_name: Name of target database. Note: Target database will be truncated
     before starting migration.
    :vartype target_database_name: str
    :ivar migration_setting: Migration settings which tune the migration behavior.
    :vartype migration_setting: dict[str, any]
    :ivar source_setting: Source settings to tune source endpoint migration behavior.
    :vartype source_setting: dict[str, str]
    :ivar target_setting: Target settings to tune target endpoint migration behavior.
    :vartype target_setting: dict[str, str]
    :ivar selected_tables: Tables selected for migration.
    :vartype selected_tables:
     list[~azure.mgmt.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInput]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "target_database_name": {"key": "targetDatabaseName", "type": "str"},
        "migration_setting": {"key": "migrationSetting", "type": "{object}"},
        "source_setting": {"key": "sourceSetting", "type": "{str}"},
        "target_setting": {"key": "targetSetting", "type": "{str}"},
        "selected_tables": {
            "key": "selectedTables",
            "type": "[MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInput]",
        },
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        target_database_name: Optional[str] = None,
        migration_setting: Optional[Dict[str, Any]] = None,
        source_setting: Optional[Dict[str, str]] = None,
        target_setting: Optional[Dict[str, str]] = None,
        selected_tables: Optional[List["_models.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInput"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the database.
        :paramtype name: str
        :keyword target_database_name: Name of target database. Note: Target database will be truncated
         before starting migration.
        :paramtype target_database_name: str
        :keyword migration_setting: Migration settings which tune the migration behavior.
        :paramtype migration_setting: dict[str, any]
        :keyword source_setting: Source settings to tune source endpoint migration behavior.
        :paramtype source_setting: dict[str, str]
        :keyword target_setting: Target settings to tune target endpoint migration behavior.
        :paramtype target_setting: dict[str, str]
        :keyword selected_tables: Tables selected for migration.
        :paramtype selected_tables:
         list[~azure.mgmt.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInput]
        """
        super().__init__(**kwargs)
        self.name = name
        self.id: Optional[str] = None
        self.target_database_name = target_database_name
        self.migration_setting = migration_setting
        self.source_setting = source_setting
        self.target_setting = target_setting
        self.selected_tables = selected_tables


class MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseTableInput(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Selected tables for the migration.

    :ivar name: Name of the table to migrate.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the table to migrate.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput(_serialization.Model):  # pylint: disable=name-too-long
    """Input for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for
    online migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar selected_databases: Databases to migrate. Required.
    :vartype selected_databases:
     list[~azure.mgmt.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput]
    :ivar target_connection_info: Connection information for target Azure Database for PostgreSQL.
     Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    :ivar source_connection_info: Connection information for source PostgreSQL. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
    :ivar encrypted_key_for_secure_fields: encrypted key for secure fields.
    :vartype encrypted_key_for_secure_fields: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    """

    _validation = {
        "selected_databases": {"required": True},
        "target_connection_info": {"required": True},
        "source_connection_info": {"required": True},
        "started_on": {"readonly": True},
    }

    _attribute_map = {
        "selected_databases": {
            "key": "selectedDatabases",
            "type": "[MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput]",
        },
        "target_connection_info": {"key": "targetConnectionInfo", "type": "PostgreSqlConnectionInfo"},
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "PostgreSqlConnectionInfo"},
        "encrypted_key_for_secure_fields": {"key": "encryptedKeyForSecureFields", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        selected_databases: List["_models.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput"],
        target_connection_info: "_models.PostgreSqlConnectionInfo",
        source_connection_info: "_models.PostgreSqlConnectionInfo",
        encrypted_key_for_secure_fields: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword selected_databases: Databases to migrate. Required.
        :paramtype selected_databases:
         list[~azure.mgmt.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput]
        :keyword target_connection_info: Connection information for target Azure Database for
         PostgreSQL. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
        :keyword source_connection_info: Connection information for source PostgreSQL. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.PostgreSqlConnectionInfo
        :keyword encrypted_key_for_secure_fields: encrypted key for secure fields.
        :paramtype encrypted_key_for_secure_fields: str
        """
        super().__init__(**kwargs)
        self.selected_databases = selected_databases
        self.target_connection_info = target_connection_info
        self.source_connection_info = source_connection_info
        self.encrypted_key_for_secure_fields = encrypted_key_for_secure_fields
        self.started_on: Optional[datetime.datetime] = None


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput(_serialization.Model):  # pylint: disable=name-too-long
    """Output for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for
    online migrations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseError,
    MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevel,
    MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError,
    MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel,
    MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevel

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
    }

    _subtype_map = {
        "result_type": {
            "DatabaseLevelErrorOutput": "MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseError",
            "DatabaseLevelOutput": "MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevel",
            "ErrorOutput": "MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError",
            "MigrationLevelOutput": "MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel",
            "TableLevelOutput": "MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevel",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.result_type: Optional[str] = None


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseError(
    MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar error_message: Error message.
    :vartype error_message: str
    :ivar events: List of error events.
    :vartype events: list[~azure.mgmt.datamigration.models.SyncMigrationDatabaseErrorEvent]
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "events": {"key": "events", "type": "[SyncMigrationDatabaseErrorEvent]"},
    }

    def __init__(
        self,
        *,
        error_message: Optional[str] = None,
        events: Optional[List["_models.SyncMigrationDatabaseErrorEvent"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_message: Error message.
        :paramtype error_message: str
        :keyword events: List of error events.
        :paramtype events: list[~azure.mgmt.datamigration.models.SyncMigrationDatabaseErrorEvent]
        """
        super().__init__(**kwargs)
        self.result_type: str = "DatabaseLevelErrorOutput"
        self.error_message = error_message
        self.events = events


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevel(
    MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_state: Migration state that this database is in. Known values are: "UNDEFINED",
     "CONFIGURING", "INITIALIAZING", "STARTING", "RUNNING", "READY_TO_COMPLETE", "COMPLETING",
     "COMPLETE", "CANCELLING", "CANCELLED", "FAILED", "VALIDATING", "VALIDATION_COMPLETE",
     "VALIDATION_FAILED", "RESTORE_IN_PROGRESS", "RESTORE_COMPLETED", "BACKUP_IN_PROGRESS", and
     "BACKUP_COMPLETED".
    :vartype migration_state: str or
     ~azure.mgmt.datamigration.models.SyncDatabaseMigrationReportingState
    :ivar incoming_changes: Number of incoming changes.
    :vartype incoming_changes: int
    :ivar applied_changes: Number of applied changes.
    :vartype applied_changes: int
    :ivar cdc_insert_counter: Number of cdc inserts.
    :vartype cdc_insert_counter: int
    :ivar cdc_delete_counter: Number of cdc deletes.
    :vartype cdc_delete_counter: int
    :ivar cdc_update_counter: Number of cdc updates.
    :vartype cdc_update_counter: int
    :ivar full_load_completed_tables: Number of tables completed in full load.
    :vartype full_load_completed_tables: int
    :ivar full_load_loading_tables: Number of tables loading in full load.
    :vartype full_load_loading_tables: int
    :ivar full_load_queued_tables: Number of tables queued in full load.
    :vartype full_load_queued_tables: int
    :ivar full_load_errored_tables: Number of tables errored in full load.
    :vartype full_load_errored_tables: int
    :ivar initialization_completed: Indicates if initial load (full load) has been completed.
    :vartype initialization_completed: bool
    :ivar latency: CDC apply latency.
    :vartype latency: int
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "database_name": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "migration_state": {"readonly": True},
        "incoming_changes": {"readonly": True},
        "applied_changes": {"readonly": True},
        "cdc_insert_counter": {"readonly": True},
        "cdc_delete_counter": {"readonly": True},
        "cdc_update_counter": {"readonly": True},
        "full_load_completed_tables": {"readonly": True},
        "full_load_loading_tables": {"readonly": True},
        "full_load_queued_tables": {"readonly": True},
        "full_load_errored_tables": {"readonly": True},
        "initialization_completed": {"readonly": True},
        "latency": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "migration_state": {"key": "migrationState", "type": "str"},
        "incoming_changes": {"key": "incomingChanges", "type": "int"},
        "applied_changes": {"key": "appliedChanges", "type": "int"},
        "cdc_insert_counter": {"key": "cdcInsertCounter", "type": "int"},
        "cdc_delete_counter": {"key": "cdcDeleteCounter", "type": "int"},
        "cdc_update_counter": {"key": "cdcUpdateCounter", "type": "int"},
        "full_load_completed_tables": {"key": "fullLoadCompletedTables", "type": "int"},
        "full_load_loading_tables": {"key": "fullLoadLoadingTables", "type": "int"},
        "full_load_queued_tables": {"key": "fullLoadQueuedTables", "type": "int"},
        "full_load_errored_tables": {"key": "fullLoadErroredTables", "type": "int"},
        "initialization_completed": {"key": "initializationCompleted", "type": "bool"},
        "latency": {"key": "latency", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "DatabaseLevelOutput"
        self.database_name: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.migration_state: Optional[Union[str, "_models.SyncDatabaseMigrationReportingState"]] = None
        self.incoming_changes: Optional[int] = None
        self.applied_changes: Optional[int] = None
        self.cdc_insert_counter: Optional[int] = None
        self.cdc_delete_counter: Optional[int] = None
        self.cdc_update_counter: Optional[int] = None
        self.full_load_completed_tables: Optional[int] = None
        self.full_load_loading_tables: Optional[int] = None
        self.full_load_queued_tables: Optional[int] = None
        self.full_load_errored_tables: Optional[int] = None
        self.initialization_completed: Optional[bool] = None
        self.latency: Optional[int] = None


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError(
    MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    :ivar events: List of error events.
    :vartype events: list[~azure.mgmt.datamigration.models.SyncMigrationDatabaseErrorEvent]
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "error": {"key": "error", "type": "ReportableException"},
        "events": {"key": "events", "type": "[SyncMigrationDatabaseErrorEvent]"},
    }

    def __init__(
        self, *, events: Optional[List["_models.SyncMigrationDatabaseErrorEvent"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword events: List of error events.
        :paramtype events: list[~azure.mgmt.datamigration.models.SyncMigrationDatabaseErrorEvent]
        """
        super().__init__(**kwargs)
        self.result_type: str = "ErrorOutput"
        self.error: Optional["_models.ReportableException"] = None
        self.events = events


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel(
    MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server: Source server name.
    :vartype source_server: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server: Target server name.
    :vartype target_server: str
    :ivar source_server_type: Source server type. Known values are: "Access", "DB2", "MySQL",
     "Oracle", "SQL", "Sybase", "PostgreSQL", "MongoDB", "SQLRDS", "MySQLRDS", and "PostgreSQLRDS".
    :vartype source_server_type: str or ~azure.mgmt.datamigration.models.ScenarioSource
    :ivar target_server_type: Target server type. Known values are: "SQLServer", "SQLDB", "SQLDW",
     "SQLMI", "AzureDBForMySql", "AzureDBForPostgresSQL", and "MongoDB".
    :vartype target_server_type: str or ~azure.mgmt.datamigration.models.ScenarioTarget
    :ivar state: Migration status. Known values are: "UNDEFINED", "VALIDATING", "PENDING",
     "COMPLETE", "ACTION_REQUIRED", and "FAILED".
    :vartype state: str or ~azure.mgmt.datamigration.models.ReplicateMigrationState
    :ivar database_count: Number of databases to include.
    :vartype database_count: float
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "source_server_version": {"readonly": True},
        "source_server": {"readonly": True},
        "target_server_version": {"readonly": True},
        "target_server": {"readonly": True},
        "source_server_type": {"readonly": True},
        "target_server_type": {"readonly": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "source_server_version": {"key": "sourceServerVersion", "type": "str"},
        "source_server": {"key": "sourceServer", "type": "str"},
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "target_server": {"key": "targetServer", "type": "str"},
        "source_server_type": {"key": "sourceServerType", "type": "str"},
        "target_server_type": {"key": "targetServerType", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "database_count": {"key": "databaseCount", "type": "float"},
    }

    def __init__(self, *, database_count: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword database_count: Number of databases to include.
        :paramtype database_count: float
        """
        super().__init__(**kwargs)
        self.result_type: str = "MigrationLevelOutput"
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.source_server_version: Optional[str] = None
        self.source_server: Optional[str] = None
        self.target_server_version: Optional[str] = None
        self.target_server: Optional[str] = None
        self.source_server_type: Optional[Union[str, "_models.ScenarioSource"]] = None
        self.target_server_type: Optional[Union[str, "_models.ScenarioTarget"]] = None
        self.state: Optional[Union[str, "_models.ReplicateMigrationState"]] = None
        self.database_count = database_count


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevel(
    MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar table_name: Name of the table.
    :vartype table_name: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar cdc_insert_counter: Number of applied inserts.
    :vartype cdc_insert_counter: int
    :ivar cdc_update_counter: Number of applied updates.
    :vartype cdc_update_counter: int
    :ivar cdc_delete_counter: Number of applied deletes.
    :vartype cdc_delete_counter: int
    :ivar full_load_est_finish_time: Estimate to finish full load.
    :vartype full_load_est_finish_time: ~datetime.datetime
    :ivar full_load_started_on: Full load start time.
    :vartype full_load_started_on: ~datetime.datetime
    :ivar full_load_ended_on: Full load end time.
    :vartype full_load_ended_on: ~datetime.datetime
    :ivar full_load_total_rows: Number of rows applied in full load.
    :vartype full_load_total_rows: int
    :ivar state: Current state of the table migration. Known values are: "BEFORE_LOAD",
     "FULL_LOAD", "COMPLETED", "CANCELED", "ERROR", and "FAILED".
    :vartype state: str or ~azure.mgmt.datamigration.models.SyncTableMigrationState
    :ivar total_changes_applied: Total number of applied changes.
    :vartype total_changes_applied: int
    :ivar data_errors_counter: Number of data errors occurred.
    :vartype data_errors_counter: int
    :ivar last_modified_time: Last modified time on target.
    :vartype last_modified_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "table_name": {"readonly": True},
        "database_name": {"readonly": True},
        "cdc_insert_counter": {"readonly": True},
        "cdc_update_counter": {"readonly": True},
        "cdc_delete_counter": {"readonly": True},
        "full_load_est_finish_time": {"readonly": True},
        "full_load_started_on": {"readonly": True},
        "full_load_ended_on": {"readonly": True},
        "full_load_total_rows": {"readonly": True},
        "state": {"readonly": True},
        "total_changes_applied": {"readonly": True},
        "data_errors_counter": {"readonly": True},
        "last_modified_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "table_name": {"key": "tableName", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "cdc_insert_counter": {"key": "cdcInsertCounter", "type": "int"},
        "cdc_update_counter": {"key": "cdcUpdateCounter", "type": "int"},
        "cdc_delete_counter": {"key": "cdcDeleteCounter", "type": "int"},
        "full_load_est_finish_time": {"key": "fullLoadEstFinishTime", "type": "iso-8601"},
        "full_load_started_on": {"key": "fullLoadStartedOn", "type": "iso-8601"},
        "full_load_ended_on": {"key": "fullLoadEndedOn", "type": "iso-8601"},
        "full_load_total_rows": {"key": "fullLoadTotalRows", "type": "int"},
        "state": {"key": "state", "type": "str"},
        "total_changes_applied": {"key": "totalChangesApplied", "type": "int"},
        "data_errors_counter": {"key": "dataErrorsCounter", "type": "int"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "TableLevelOutput"
        self.table_name: Optional[str] = None
        self.database_name: Optional[str] = None
        self.cdc_insert_counter: Optional[int] = None
        self.cdc_update_counter: Optional[int] = None
        self.cdc_delete_counter: Optional[int] = None
        self.full_load_est_finish_time: Optional[datetime.datetime] = None
        self.full_load_started_on: Optional[datetime.datetime] = None
        self.full_load_ended_on: Optional[datetime.datetime] = None
        self.full_load_total_rows: Optional[int] = None
        self.state: Optional[Union[str, "_models.SyncTableMigrationState"]] = None
        self.total_changes_applied: Optional[int] = None
        self.data_errors_counter: Optional[int] = None
        self.last_modified_time: Optional[datetime.datetime] = None


class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties(ProjectTaskProperties):  # pylint: disable=name-too-long
    """Properties for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for
    online migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input:
     ~azure.mgmt.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput]
    :ivar task_id: task id.
    :vartype task_id: str
    :ivar created_on: DateTime in UTC when the task was created.
    :vartype created_on: str
    :ivar is_cloneable: whether the task can be cloned or not.
    :vartype is_cloneable: bool
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput"},
        "output": {"key": "output", "type": "[MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput]"},
        "task_id": {"key": "taskId", "type": "str"},
        "created_on": {"key": "createdOn", "type": "str"},
        "is_cloneable": {"key": "isCloneable", "type": "bool"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput"] = None,
        task_id: Optional[str] = None,
        created_on: Optional[str] = None,
        is_cloneable: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input:
         ~azure.mgmt.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput
        :keyword task_id: task id.
        :paramtype task_id: str
        :keyword created_on: DateTime in UTC when the task was created.
        :paramtype created_on: str
        :keyword is_cloneable: whether the task can be cloned or not.
        :paramtype is_cloneable: bool
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2"
        self.input = input
        self.output: Optional[List["_models.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput"]] = None
        self.task_id = task_id
        self.created_on = created_on
        self.is_cloneable = is_cloneable


class MigrateSchemaSqlServerSqlDbDatabaseInput(_serialization.Model):
    """Database input for migrate schema Sql Server to Azure SQL Server scenario.

    :ivar name: Name of source database.
    :vartype name: str
    :ivar id: Id of the source database.
    :vartype id: str
    :ivar target_database_name: Name of target database.
    :vartype target_database_name: str
    :ivar schema_setting: Database schema migration settings.
    :vartype schema_setting: ~azure.mgmt.datamigration.models.SchemaMigrationSetting
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "target_database_name": {"key": "targetDatabaseName", "type": "str"},
        "schema_setting": {"key": "schemaSetting", "type": "SchemaMigrationSetting"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        target_database_name: Optional[str] = None,
        schema_setting: Optional["_models.SchemaMigrationSetting"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of source database.
        :paramtype name: str
        :keyword id: Id of the source database.
        :paramtype id: str
        :keyword target_database_name: Name of target database.
        :paramtype target_database_name: str
        :keyword schema_setting: Database schema migration settings.
        :paramtype schema_setting: ~azure.mgmt.datamigration.models.SchemaMigrationSetting
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.target_database_name = target_database_name
        self.schema_setting = schema_setting


class SqlMigrationTaskInput(_serialization.Model):
    """Base class for migration task input.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Information for connecting to source. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar target_connection_info: Information for connecting to target. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    """

    _validation = {
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "SqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "SqlConnectionInfo"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.SqlConnectionInfo",
        target_connection_info: "_models.SqlConnectionInfo",
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Information for connecting to source. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword target_connection_info: Information for connecting to target. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        """
        super().__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info


class MigrateSchemaSqlServerSqlDbTaskInput(SqlMigrationTaskInput):
    """Input for task that migrates Schema for SQL Server databases to Azure SQL databases.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Information for connecting to source. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar target_connection_info: Information for connecting to target. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar selected_databases: Databases to migrate. Required.
    :vartype selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSchemaSqlServerSqlDbDatabaseInput]
    :ivar encrypted_key_for_secure_fields: encrypted key for secure fields.
    :vartype encrypted_key_for_secure_fields: str
    :ivar started_on: Migration start time.
    :vartype started_on: str
    """

    _validation = {
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
        "selected_databases": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "SqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "SqlConnectionInfo"},
        "selected_databases": {"key": "selectedDatabases", "type": "[MigrateSchemaSqlServerSqlDbDatabaseInput]"},
        "encrypted_key_for_secure_fields": {"key": "encryptedKeyForSecureFields", "type": "str"},
        "started_on": {"key": "startedOn", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.SqlConnectionInfo",
        target_connection_info: "_models.SqlConnectionInfo",
        selected_databases: List["_models.MigrateSchemaSqlServerSqlDbDatabaseInput"],
        encrypted_key_for_secure_fields: Optional[str] = None,
        started_on: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Information for connecting to source. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword target_connection_info: Information for connecting to target. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword selected_databases: Databases to migrate. Required.
        :paramtype selected_databases:
         list[~azure.mgmt.datamigration.models.MigrateSchemaSqlServerSqlDbDatabaseInput]
        :keyword encrypted_key_for_secure_fields: encrypted key for secure fields.
        :paramtype encrypted_key_for_secure_fields: str
        :keyword started_on: Migration start time.
        :paramtype started_on: str
        """
        super().__init__(
            source_connection_info=source_connection_info, target_connection_info=target_connection_info, **kwargs
        )
        self.selected_databases = selected_databases
        self.encrypted_key_for_secure_fields = encrypted_key_for_secure_fields
        self.started_on = started_on


class MigrateSchemaSqlServerSqlDbTaskOutput(_serialization.Model):
    """Output for the task that migrates Schema for SQL Server databases to Azure SQL databases.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel, MigrateSchemaSqlTaskOutputError,
    MigrateSchemaSqlServerSqlDbTaskOutputMigrationLevel, MigrateSchemaSqlServerSqlDbTaskOutputError

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
    }

    _subtype_map = {
        "result_type": {
            "DatabaseLevelOutput": "MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel",
            "ErrorOutput": "MigrateSchemaSqlTaskOutputError",
            "MigrationLevelOutput": "MigrateSchemaSqlServerSqlDbTaskOutputMigrationLevel",
            "SchemaErrorOutput": "MigrateSchemaSqlServerSqlDbTaskOutputError",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.result_type: Optional[str] = None


class MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel(
    MigrateSchemaSqlServerSqlDbTaskOutput
):  # pylint: disable=name-too-long
    """MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar database_name: The name of the database.
    :vartype database_name: str
    :ivar state: State of the schema migration for this database. Known values are: "None",
     "InProgress", "Failed", "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar stage: Schema migration stage for this database. Known values are: "NotStarted",
     "ValidatingInputs", "CollectingObjects", "DownloadingScript", "GeneratingScript",
     "UploadingScript", "DeployingSchema", "Completed", "CompletedWithWarnings", and "Failed".
    :vartype stage: str or ~azure.mgmt.datamigration.models.SchemaMigrationStage
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar database_error_result_prefix: Prefix string to use for querying errors for this database.
    :vartype database_error_result_prefix: str
    :ivar schema_error_result_prefix: Prefix string to use for querying schema errors for this
     database.
    :vartype schema_error_result_prefix: str
    :ivar number_of_successful_operations: Number of successful operations for this database.
    :vartype number_of_successful_operations: int
    :ivar number_of_failed_operations: Number of failed operations for this database.
    :vartype number_of_failed_operations: int
    :ivar file_id: Identifier for the file resource containing the schema of this database.
    :vartype file_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "database_name": {"readonly": True},
        "state": {"readonly": True},
        "stage": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "database_error_result_prefix": {"readonly": True},
        "schema_error_result_prefix": {"readonly": True},
        "number_of_successful_operations": {"readonly": True},
        "number_of_failed_operations": {"readonly": True},
        "file_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "stage": {"key": "stage", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "database_error_result_prefix": {"key": "databaseErrorResultPrefix", "type": "str"},
        "schema_error_result_prefix": {"key": "schemaErrorResultPrefix", "type": "str"},
        "number_of_successful_operations": {"key": "numberOfSuccessfulOperations", "type": "int"},
        "number_of_failed_operations": {"key": "numberOfFailedOperations", "type": "int"},
        "file_id": {"key": "fileId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "DatabaseLevelOutput"
        self.database_name: Optional[str] = None
        self.state: Optional[Union[str, "_models.MigrationState"]] = None
        self.stage: Optional[Union[str, "_models.SchemaMigrationStage"]] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.database_error_result_prefix: Optional[str] = None
        self.schema_error_result_prefix: Optional[str] = None
        self.number_of_successful_operations: Optional[int] = None
        self.number_of_failed_operations: Optional[int] = None
        self.file_id: Optional[str] = None


class MigrateSchemaSqlServerSqlDbTaskOutputError(
    MigrateSchemaSqlServerSqlDbTaskOutput
):  # pylint: disable=name-too-long
    """MigrateSchemaSqlServerSqlDbTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar command_text: Schema command which failed.
    :vartype command_text: str
    :ivar error_text: Reason of failure.
    :vartype error_text: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "command_text": {"readonly": True},
        "error_text": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "command_text": {"key": "commandText", "type": "str"},
        "error_text": {"key": "errorText", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "SchemaErrorOutput"
        self.command_text: Optional[str] = None
        self.error_text: Optional[str] = None


class MigrateSchemaSqlServerSqlDbTaskOutputMigrationLevel(
    MigrateSchemaSqlServerSqlDbTaskOutput
):  # pylint: disable=name-too-long
    """MigrateSchemaSqlServerSqlDbTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar state: Overall state of the schema migration. Known values are: "None", "InProgress",
     "Failed", "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "state": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "source_server_version": {"readonly": True},
        "source_server_brand_version": {"readonly": True},
        "target_server_version": {"readonly": True},
        "target_server_brand_version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "source_server_version": {"key": "sourceServerVersion", "type": "str"},
        "source_server_brand_version": {"key": "sourceServerBrandVersion", "type": "str"},
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "target_server_brand_version": {"key": "targetServerBrandVersion", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "MigrationLevelOutput"
        self.state: Optional[Union[str, "_models.MigrationState"]] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.source_server_version: Optional[str] = None
        self.source_server_brand_version: Optional[str] = None
        self.target_server_version: Optional[str] = None
        self.target_server_brand_version: Optional[str] = None


class MigrateSchemaSqlServerSqlDbTaskProperties(ProjectTaskProperties):  # pylint: disable=name-too-long
    """Properties for task that migrates Schema for SQL Server databases to Azure SQL databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.MigrateSchemaSqlServerSqlDbTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.MigrateSchemaSqlServerSqlDbTaskOutput]
    :ivar created_on: DateTime in UTC when the task was created.
    :vartype created_on: str
    :ivar task_id: Task id.
    :vartype task_id: str
    :ivar is_cloneable: whether the task can be cloned or not.
    :vartype is_cloneable: bool
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "MigrateSchemaSqlServerSqlDbTaskInput"},
        "output": {"key": "output", "type": "[MigrateSchemaSqlServerSqlDbTaskOutput]"},
        "created_on": {"key": "createdOn", "type": "str"},
        "task_id": {"key": "taskId", "type": "str"},
        "is_cloneable": {"key": "isCloneable", "type": "bool"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.MigrateSchemaSqlServerSqlDbTaskInput"] = None,
        created_on: Optional[str] = None,
        task_id: Optional[str] = None,
        is_cloneable: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.MigrateSchemaSqlServerSqlDbTaskInput
        :keyword created_on: DateTime in UTC when the task was created.
        :paramtype created_on: str
        :keyword task_id: Task id.
        :paramtype task_id: str
        :keyword is_cloneable: whether the task can be cloned or not.
        :paramtype is_cloneable: bool
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "MigrateSchemaSqlServerSqlDb"
        self.input = input
        self.output: Optional[List["_models.MigrateSchemaSqlServerSqlDbTaskOutput"]] = None
        self.created_on = created_on
        self.task_id = task_id
        self.is_cloneable = is_cloneable


class MigrateSchemaSqlTaskOutputError(MigrateSchemaSqlServerSqlDbTaskOutput):
    """MigrateSchemaSqlTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "error": {"key": "error", "type": "ReportableException"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "ErrorOutput"
        self.error: Optional["_models.ReportableException"] = None


class MigrateSqlServerDatabaseInput(_serialization.Model):
    """Database specific information for SQL to SQL migration task inputs.

    :ivar name: Name of the database.
    :vartype name: str
    :ivar restore_database_name: Name of the database at destination.
    :vartype restore_database_name: str
    :ivar backup_and_restore_folder: The backup and restore folder.
    :vartype backup_and_restore_folder: str
    :ivar database_files: The list of database files.
    :vartype database_files: list[~azure.mgmt.datamigration.models.DatabaseFileInput]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "restore_database_name": {"key": "restoreDatabaseName", "type": "str"},
        "backup_and_restore_folder": {"key": "backupAndRestoreFolder", "type": "str"},
        "database_files": {"key": "databaseFiles", "type": "[DatabaseFileInput]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        restore_database_name: Optional[str] = None,
        backup_and_restore_folder: Optional[str] = None,
        database_files: Optional[List["_models.DatabaseFileInput"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the database.
        :paramtype name: str
        :keyword restore_database_name: Name of the database at destination.
        :paramtype restore_database_name: str
        :keyword backup_and_restore_folder: The backup and restore folder.
        :paramtype backup_and_restore_folder: str
        :keyword database_files: The list of database files.
        :paramtype database_files: list[~azure.mgmt.datamigration.models.DatabaseFileInput]
        """
        super().__init__(**kwargs)
        self.name = name
        self.restore_database_name = restore_database_name
        self.backup_and_restore_folder = backup_and_restore_folder
        self.database_files = database_files


class MigrateSqlServerSqlDbDatabaseInput(_serialization.Model):
    """Database specific information for SQL to Azure SQL DB migration task inputs.

    :ivar name: Name of the database.
    :vartype name: str
    :ivar target_database_name: Name of target database. Note: Target database will be truncated
     before starting migration.
    :vartype target_database_name: str
    :ivar make_source_db_read_only: Whether to set database read only before migration.
    :vartype make_source_db_read_only: bool
    :ivar table_map: Mapping of source to target tables.
    :vartype table_map: dict[str, str]
    :ivar schema_setting: Settings selected for DB schema migration.
    :vartype schema_setting: JSON
    :ivar id: id of the database.
    :vartype id: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "target_database_name": {"key": "targetDatabaseName", "type": "str"},
        "make_source_db_read_only": {"key": "makeSourceDbReadOnly", "type": "bool"},
        "table_map": {"key": "tableMap", "type": "{str}"},
        "schema_setting": {"key": "schemaSetting", "type": "object"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        target_database_name: Optional[str] = None,
        make_source_db_read_only: Optional[bool] = None,
        table_map: Optional[Dict[str, str]] = None,
        schema_setting: Optional[JSON] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the database.
        :paramtype name: str
        :keyword target_database_name: Name of target database. Note: Target database will be truncated
         before starting migration.
        :paramtype target_database_name: str
        :keyword make_source_db_read_only: Whether to set database read only before migration.
        :paramtype make_source_db_read_only: bool
        :keyword table_map: Mapping of source to target tables.
        :paramtype table_map: dict[str, str]
        :keyword schema_setting: Settings selected for DB schema migration.
        :paramtype schema_setting: JSON
        :keyword id: id of the database.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.target_database_name = target_database_name
        self.make_source_db_read_only = make_source_db_read_only
        self.table_map = table_map
        self.schema_setting = schema_setting
        self.id = id


class MigrateSqlServerSqlDbSyncDatabaseInput(_serialization.Model):
    """Database specific information for SQL to Azure SQL DB sync migration task inputs.

    :ivar id: Unique identifier for database.
    :vartype id: str
    :ivar name: Name of database.
    :vartype name: str
    :ivar target_database_name: Target database name.
    :vartype target_database_name: str
    :ivar schema_name: Schema name to be migrated.
    :vartype schema_name: str
    :ivar table_map: Mapping of source to target tables.
    :vartype table_map: dict[str, str]
    :ivar migration_setting: Migration settings which tune the migration behavior.
    :vartype migration_setting: dict[str, str]
    :ivar source_setting: Source settings to tune source endpoint migration behavior.
    :vartype source_setting: dict[str, str]
    :ivar target_setting: Target settings to tune target endpoint migration behavior.
    :vartype target_setting: dict[str, str]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "target_database_name": {"key": "targetDatabaseName", "type": "str"},
        "schema_name": {"key": "schemaName", "type": "str"},
        "table_map": {"key": "tableMap", "type": "{str}"},
        "migration_setting": {"key": "migrationSetting", "type": "{str}"},
        "source_setting": {"key": "sourceSetting", "type": "{str}"},
        "target_setting": {"key": "targetSetting", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        target_database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        table_map: Optional[Dict[str, str]] = None,
        migration_setting: Optional[Dict[str, str]] = None,
        source_setting: Optional[Dict[str, str]] = None,
        target_setting: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Unique identifier for database.
        :paramtype id: str
        :keyword name: Name of database.
        :paramtype name: str
        :keyword target_database_name: Target database name.
        :paramtype target_database_name: str
        :keyword schema_name: Schema name to be migrated.
        :paramtype schema_name: str
        :keyword table_map: Mapping of source to target tables.
        :paramtype table_map: dict[str, str]
        :keyword migration_setting: Migration settings which tune the migration behavior.
        :paramtype migration_setting: dict[str, str]
        :keyword source_setting: Source settings to tune source endpoint migration behavior.
        :paramtype source_setting: dict[str, str]
        :keyword target_setting: Target settings to tune target endpoint migration behavior.
        :paramtype target_setting: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.target_database_name = target_database_name
        self.schema_name = schema_name
        self.table_map = table_map
        self.migration_setting = migration_setting
        self.source_setting = source_setting
        self.target_setting = target_setting


class MigrateSqlServerSqlDbSyncTaskInput(SqlMigrationTaskInput):
    """Input for the task that migrates on-prem SQL Server databases to Azure SQL Database for online
    migrations.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Information for connecting to source. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar target_connection_info: Information for connecting to target. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar selected_databases: Databases to migrate. Required.
    :vartype selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbSyncDatabaseInput]
    :ivar validation_options: Validation options.
    :vartype validation_options: ~azure.mgmt.datamigration.models.MigrationValidationOptions
    """

    _validation = {
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
        "selected_databases": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "SqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "SqlConnectionInfo"},
        "selected_databases": {"key": "selectedDatabases", "type": "[MigrateSqlServerSqlDbSyncDatabaseInput]"},
        "validation_options": {"key": "validationOptions", "type": "MigrationValidationOptions"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.SqlConnectionInfo",
        target_connection_info: "_models.SqlConnectionInfo",
        selected_databases: List["_models.MigrateSqlServerSqlDbSyncDatabaseInput"],
        validation_options: Optional["_models.MigrationValidationOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Information for connecting to source. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword target_connection_info: Information for connecting to target. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword selected_databases: Databases to migrate. Required.
        :paramtype selected_databases:
         list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbSyncDatabaseInput]
        :keyword validation_options: Validation options.
        :paramtype validation_options: ~azure.mgmt.datamigration.models.MigrationValidationOptions
        """
        super().__init__(
            source_connection_info=source_connection_info, target_connection_info=target_connection_info, **kwargs
        )
        self.selected_databases = selected_databases
        self.validation_options = validation_options


class MigrateSqlServerSqlDbSyncTaskOutput(_serialization.Model):
    """Output for the task that migrates on-prem SQL Server databases to Azure SQL Database for online
    migrations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MigrateSqlServerSqlDbSyncTaskOutputDatabaseError,
    MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel, MigrateSqlServerSqlDbSyncTaskOutputError,
    MigrateSqlServerSqlDbSyncTaskOutputMigrationLevel,
    MigrateSqlServerSqlDbSyncTaskOutputTableLevel

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
    }

    _subtype_map = {
        "result_type": {
            "DatabaseLevelErrorOutput": "MigrateSqlServerSqlDbSyncTaskOutputDatabaseError",
            "DatabaseLevelOutput": "MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel",
            "ErrorOutput": "MigrateSqlServerSqlDbSyncTaskOutputError",
            "MigrationLevelOutput": "MigrateSqlServerSqlDbSyncTaskOutputMigrationLevel",
            "TableLevelOutput": "MigrateSqlServerSqlDbSyncTaskOutputTableLevel",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.result_type: Optional[str] = None


class MigrateSqlServerSqlDbSyncTaskOutputDatabaseError(
    MigrateSqlServerSqlDbSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlDbSyncTaskOutputDatabaseError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar error_message: Error message.
    :vartype error_message: str
    :ivar events: List of error events.
    :vartype events: list[~azure.mgmt.datamigration.models.SyncMigrationDatabaseErrorEvent]
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "events": {"key": "events", "type": "[SyncMigrationDatabaseErrorEvent]"},
    }

    def __init__(
        self,
        *,
        error_message: Optional[str] = None,
        events: Optional[List["_models.SyncMigrationDatabaseErrorEvent"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_message: Error message.
        :paramtype error_message: str
        :keyword events: List of error events.
        :paramtype events: list[~azure.mgmt.datamigration.models.SyncMigrationDatabaseErrorEvent]
        """
        super().__init__(**kwargs)
        self.result_type: str = "DatabaseLevelErrorOutput"
        self.error_message = error_message
        self.events = events


class MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel(
    MigrateSqlServerSqlDbSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar migration_state: Migration state that this database is in. Known values are: "UNDEFINED",
     "CONFIGURING", "INITIALIAZING", "STARTING", "RUNNING", "READY_TO_COMPLETE", "COMPLETING",
     "COMPLETE", "CANCELLING", "CANCELLED", "FAILED", "VALIDATING", "VALIDATION_COMPLETE",
     "VALIDATION_FAILED", "RESTORE_IN_PROGRESS", "RESTORE_COMPLETED", "BACKUP_IN_PROGRESS", and
     "BACKUP_COMPLETED".
    :vartype migration_state: str or
     ~azure.mgmt.datamigration.models.SyncDatabaseMigrationReportingState
    :ivar incoming_changes: Number of incoming changes.
    :vartype incoming_changes: int
    :ivar applied_changes: Number of applied changes.
    :vartype applied_changes: int
    :ivar cdc_insert_counter: Number of cdc inserts.
    :vartype cdc_insert_counter: int
    :ivar cdc_delete_counter: Number of cdc deletes.
    :vartype cdc_delete_counter: int
    :ivar cdc_update_counter: Number of cdc updates.
    :vartype cdc_update_counter: int
    :ivar full_load_completed_tables: Number of tables completed in full load.
    :vartype full_load_completed_tables: int
    :ivar full_load_loading_tables: Number of tables loading in full load.
    :vartype full_load_loading_tables: int
    :ivar full_load_queued_tables: Number of tables queued in full load.
    :vartype full_load_queued_tables: int
    :ivar full_load_errored_tables: Number of tables errored in full load.
    :vartype full_load_errored_tables: int
    :ivar initialization_completed: Indicates if initial load (full load) has been completed.
    :vartype initialization_completed: bool
    :ivar latency: CDC apply latency.
    :vartype latency: int
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "database_name": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "migration_state": {"readonly": True},
        "incoming_changes": {"readonly": True},
        "applied_changes": {"readonly": True},
        "cdc_insert_counter": {"readonly": True},
        "cdc_delete_counter": {"readonly": True},
        "cdc_update_counter": {"readonly": True},
        "full_load_completed_tables": {"readonly": True},
        "full_load_loading_tables": {"readonly": True},
        "full_load_queued_tables": {"readonly": True},
        "full_load_errored_tables": {"readonly": True},
        "initialization_completed": {"readonly": True},
        "latency": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "migration_state": {"key": "migrationState", "type": "str"},
        "incoming_changes": {"key": "incomingChanges", "type": "int"},
        "applied_changes": {"key": "appliedChanges", "type": "int"},
        "cdc_insert_counter": {"key": "cdcInsertCounter", "type": "int"},
        "cdc_delete_counter": {"key": "cdcDeleteCounter", "type": "int"},
        "cdc_update_counter": {"key": "cdcUpdateCounter", "type": "int"},
        "full_load_completed_tables": {"key": "fullLoadCompletedTables", "type": "int"},
        "full_load_loading_tables": {"key": "fullLoadLoadingTables", "type": "int"},
        "full_load_queued_tables": {"key": "fullLoadQueuedTables", "type": "int"},
        "full_load_errored_tables": {"key": "fullLoadErroredTables", "type": "int"},
        "initialization_completed": {"key": "initializationCompleted", "type": "bool"},
        "latency": {"key": "latency", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "DatabaseLevelOutput"
        self.database_name: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.migration_state: Optional[Union[str, "_models.SyncDatabaseMigrationReportingState"]] = None
        self.incoming_changes: Optional[int] = None
        self.applied_changes: Optional[int] = None
        self.cdc_insert_counter: Optional[int] = None
        self.cdc_delete_counter: Optional[int] = None
        self.cdc_update_counter: Optional[int] = None
        self.full_load_completed_tables: Optional[int] = None
        self.full_load_loading_tables: Optional[int] = None
        self.full_load_queued_tables: Optional[int] = None
        self.full_load_errored_tables: Optional[int] = None
        self.initialization_completed: Optional[bool] = None
        self.latency: Optional[int] = None


class MigrateSqlServerSqlDbSyncTaskOutputError(MigrateSqlServerSqlDbSyncTaskOutput):
    """MigrateSqlServerSqlDbSyncTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "error": {"key": "error", "type": "ReportableException"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "ErrorOutput"
        self.error: Optional["_models.ReportableException"] = None


class MigrateSqlServerSqlDbSyncTaskOutputMigrationLevel(
    MigrateSqlServerSqlDbSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlDbSyncTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server: Source server name.
    :vartype source_server: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server: Target server name.
    :vartype target_server: str
    :ivar database_count: Count of databases.
    :vartype database_count: int
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "source_server_version": {"readonly": True},
        "source_server": {"readonly": True},
        "target_server_version": {"readonly": True},
        "target_server": {"readonly": True},
        "database_count": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "source_server_version": {"key": "sourceServerVersion", "type": "str"},
        "source_server": {"key": "sourceServer", "type": "str"},
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "target_server": {"key": "targetServer", "type": "str"},
        "database_count": {"key": "databaseCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "MigrationLevelOutput"
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.source_server_version: Optional[str] = None
        self.source_server: Optional[str] = None
        self.target_server_version: Optional[str] = None
        self.target_server: Optional[str] = None
        self.database_count: Optional[int] = None


class MigrateSqlServerSqlDbSyncTaskOutputTableLevel(
    MigrateSqlServerSqlDbSyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlDbSyncTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar table_name: Name of the table.
    :vartype table_name: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar cdc_insert_counter: Number of applied inserts.
    :vartype cdc_insert_counter: int
    :ivar cdc_update_counter: Number of applied updates.
    :vartype cdc_update_counter: int
    :ivar cdc_delete_counter: Number of applied deletes.
    :vartype cdc_delete_counter: int
    :ivar full_load_est_finish_time: Estimate to finish full load.
    :vartype full_load_est_finish_time: ~datetime.datetime
    :ivar full_load_started_on: Full load start time.
    :vartype full_load_started_on: ~datetime.datetime
    :ivar full_load_ended_on: Full load end time.
    :vartype full_load_ended_on: ~datetime.datetime
    :ivar full_load_total_rows: Number of rows applied in full load.
    :vartype full_load_total_rows: int
    :ivar state: Current state of the table migration. Known values are: "BEFORE_LOAD",
     "FULL_LOAD", "COMPLETED", "CANCELED", "ERROR", and "FAILED".
    :vartype state: str or ~azure.mgmt.datamigration.models.SyncTableMigrationState
    :ivar total_changes_applied: Total number of applied changes.
    :vartype total_changes_applied: int
    :ivar data_errors_counter: Number of data errors occurred.
    :vartype data_errors_counter: int
    :ivar last_modified_time: Last modified time on target.
    :vartype last_modified_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "table_name": {"readonly": True},
        "database_name": {"readonly": True},
        "cdc_insert_counter": {"readonly": True},
        "cdc_update_counter": {"readonly": True},
        "cdc_delete_counter": {"readonly": True},
        "full_load_est_finish_time": {"readonly": True},
        "full_load_started_on": {"readonly": True},
        "full_load_ended_on": {"readonly": True},
        "full_load_total_rows": {"readonly": True},
        "state": {"readonly": True},
        "total_changes_applied": {"readonly": True},
        "data_errors_counter": {"readonly": True},
        "last_modified_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "table_name": {"key": "tableName", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "cdc_insert_counter": {"key": "cdcInsertCounter", "type": "int"},
        "cdc_update_counter": {"key": "cdcUpdateCounter", "type": "int"},
        "cdc_delete_counter": {"key": "cdcDeleteCounter", "type": "int"},
        "full_load_est_finish_time": {"key": "fullLoadEstFinishTime", "type": "iso-8601"},
        "full_load_started_on": {"key": "fullLoadStartedOn", "type": "iso-8601"},
        "full_load_ended_on": {"key": "fullLoadEndedOn", "type": "iso-8601"},
        "full_load_total_rows": {"key": "fullLoadTotalRows", "type": "int"},
        "state": {"key": "state", "type": "str"},
        "total_changes_applied": {"key": "totalChangesApplied", "type": "int"},
        "data_errors_counter": {"key": "dataErrorsCounter", "type": "int"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "TableLevelOutput"
        self.table_name: Optional[str] = None
        self.database_name: Optional[str] = None
        self.cdc_insert_counter: Optional[int] = None
        self.cdc_update_counter: Optional[int] = None
        self.cdc_delete_counter: Optional[int] = None
        self.full_load_est_finish_time: Optional[datetime.datetime] = None
        self.full_load_started_on: Optional[datetime.datetime] = None
        self.full_load_ended_on: Optional[datetime.datetime] = None
        self.full_load_total_rows: Optional[int] = None
        self.state: Optional[Union[str, "_models.SyncTableMigrationState"]] = None
        self.total_changes_applied: Optional[int] = None
        self.data_errors_counter: Optional[int] = None
        self.last_modified_time: Optional[datetime.datetime] = None


class MigrateSqlServerSqlDbSyncTaskProperties(ProjectTaskProperties):
    """Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database for
    online migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbSyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbSyncTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "MigrateSqlServerSqlDbSyncTaskInput"},
        "output": {"key": "output", "type": "[MigrateSqlServerSqlDbSyncTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.MigrateSqlServerSqlDbSyncTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbSyncTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Migrate.SqlServer.AzureSqlDb.Sync"
        self.input = input
        self.output: Optional[List["_models.MigrateSqlServerSqlDbSyncTaskOutput"]] = None


class MigrateSqlServerSqlDbTaskInput(SqlMigrationTaskInput):
    """Input for the task that migrates on-prem SQL Server databases to Azure SQL Database.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Information for connecting to source. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar target_connection_info: Information for connecting to target. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar selected_databases: Databases to migrate. Required.
    :vartype selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbDatabaseInput]
    :ivar validation_options: Options for enabling various post migration validations. Available
     options,
      1.) Data Integrity Check: Performs a checksum based comparison on source and target tables
     after the migration to ensure the correctness of the data.
      2.) Schema Validation: Performs a thorough schema comparison between the source and target
     tables and provides a list of differences between the source and target database, 3.) Query
     Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or
     Query Store and execute them and compares the execution time between the source and target
     database.
    :vartype validation_options: ~azure.mgmt.datamigration.models.MigrationValidationOptions
    :ivar started_on: Date and time relative to UTC when the migration was started on.
    :vartype started_on: str
    :ivar encrypted_key_for_secure_fields: encrypted key for secure fields.
    :vartype encrypted_key_for_secure_fields: str
    """

    _validation = {
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
        "selected_databases": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "SqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "SqlConnectionInfo"},
        "selected_databases": {"key": "selectedDatabases", "type": "[MigrateSqlServerSqlDbDatabaseInput]"},
        "validation_options": {"key": "validationOptions", "type": "MigrationValidationOptions"},
        "started_on": {"key": "startedOn", "type": "str"},
        "encrypted_key_for_secure_fields": {"key": "encryptedKeyForSecureFields", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.SqlConnectionInfo",
        target_connection_info: "_models.SqlConnectionInfo",
        selected_databases: List["_models.MigrateSqlServerSqlDbDatabaseInput"],
        validation_options: Optional["_models.MigrationValidationOptions"] = None,
        started_on: Optional[str] = None,
        encrypted_key_for_secure_fields: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Information for connecting to source. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword target_connection_info: Information for connecting to target. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword selected_databases: Databases to migrate. Required.
        :paramtype selected_databases:
         list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbDatabaseInput]
        :keyword validation_options: Options for enabling various post migration validations. Available
         options,
          1.) Data Integrity Check: Performs a checksum based comparison on source and target tables
         after the migration to ensure the correctness of the data.
          2.) Schema Validation: Performs a thorough schema comparison between the source and target
         tables and provides a list of differences between the source and target database, 3.) Query
         Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or
         Query Store and execute them and compares the execution time between the source and target
         database.
        :paramtype validation_options: ~azure.mgmt.datamigration.models.MigrationValidationOptions
        :keyword started_on: Date and time relative to UTC when the migration was started on.
        :paramtype started_on: str
        :keyword encrypted_key_for_secure_fields: encrypted key for secure fields.
        :paramtype encrypted_key_for_secure_fields: str
        """
        super().__init__(
            source_connection_info=source_connection_info, target_connection_info=target_connection_info, **kwargs
        )
        self.selected_databases = selected_databases
        self.validation_options = validation_options
        self.started_on = started_on
        self.encrypted_key_for_secure_fields = encrypted_key_for_secure_fields


class MigrateSqlServerSqlDbTaskOutput(_serialization.Model):
    """Output for the task that migrates on-prem SQL Server databases to Azure SQL Database.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MigrateSqlServerSqlDbTaskOutputDatabaseLevel, MigrateSqlServerSqlDbTaskOutputError,
    MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult,
    MigrateSqlServerSqlDbTaskOutputMigrationLevel, MigrateSqlServerSqlDbTaskOutputValidationResult,
    MigrateSqlServerSqlDbTaskOutputTableLevel

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
    }

    _subtype_map = {
        "result_type": {
            "DatabaseLevelOutput": "MigrateSqlServerSqlDbTaskOutputDatabaseLevel",
            "ErrorOutput": "MigrateSqlServerSqlDbTaskOutputError",
            "MigrationDatabaseLevelValidationOutput": "MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult",
            "MigrationLevelOutput": "MigrateSqlServerSqlDbTaskOutputMigrationLevel",
            "MigrationValidationOutput": "MigrateSqlServerSqlDbTaskOutputValidationResult",
            "TableLevelOutput": "MigrateSqlServerSqlDbTaskOutputTableLevel",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.result_type: Optional[str] = None


class MigrateSqlServerSqlDbTaskOutputDatabaseLevel(MigrateSqlServerSqlDbTaskOutput):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlDbTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar database_name: Name of the item.
    :vartype database_name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar state: Current state of migration. Known values are: "None", "InProgress", "Failed",
     "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar stage: Migration stage that this database is in. Known values are: "None", "Initialize",
     "Backup", "FileCopy", "Restore", and "Completed".
    :vartype stage: str or ~azure.mgmt.datamigration.models.DatabaseMigrationStage
    :ivar status_message: Status message.
    :vartype status_message: str
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar number_of_objects: Number of objects.
    :vartype number_of_objects: int
    :ivar number_of_objects_completed: Number of successfully completed objects.
    :vartype number_of_objects_completed: int
    :ivar error_count: Number of database/object errors.
    :vartype error_count: int
    :ivar error_prefix: Wildcard string prefix to use for querying all errors of the item.
    :vartype error_prefix: str
    :ivar result_prefix: Wildcard string prefix to use for querying all sub-tem results of the
     item.
    :vartype result_prefix: str
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar object_summary: Summary of object results in the migration.
    :vartype object_summary: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "database_name": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "state": {"readonly": True},
        "stage": {"readonly": True},
        "status_message": {"readonly": True},
        "message": {"readonly": True},
        "number_of_objects": {"readonly": True},
        "number_of_objects_completed": {"readonly": True},
        "error_count": {"readonly": True},
        "error_prefix": {"readonly": True},
        "result_prefix": {"readonly": True},
        "exceptions_and_warnings": {"readonly": True},
        "object_summary": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "state": {"key": "state", "type": "str"},
        "stage": {"key": "stage", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "number_of_objects": {"key": "numberOfObjects", "type": "int"},
        "number_of_objects_completed": {"key": "numberOfObjectsCompleted", "type": "int"},
        "error_count": {"key": "errorCount", "type": "int"},
        "error_prefix": {"key": "errorPrefix", "type": "str"},
        "result_prefix": {"key": "resultPrefix", "type": "str"},
        "exceptions_and_warnings": {"key": "exceptionsAndWarnings", "type": "[ReportableException]"},
        "object_summary": {"key": "objectSummary", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "DatabaseLevelOutput"
        self.database_name: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.state: Optional[Union[str, "_models.MigrationState"]] = None
        self.stage: Optional[Union[str, "_models.DatabaseMigrationStage"]] = None
        self.status_message: Optional[str] = None
        self.message: Optional[str] = None
        self.number_of_objects: Optional[int] = None
        self.number_of_objects_completed: Optional[int] = None
        self.error_count: Optional[int] = None
        self.error_prefix: Optional[str] = None
        self.result_prefix: Optional[str] = None
        self.exceptions_and_warnings: Optional[List["_models.ReportableException"]] = None
        self.object_summary: Optional[str] = None


class MigrationValidationDatabaseLevelResult(_serialization.Model):
    """Database level validation results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar migration_id: Migration Identifier.
    :vartype migration_id: str
    :ivar source_database_name: Name of the source database.
    :vartype source_database_name: str
    :ivar target_database_name: Name of the target database.
    :vartype target_database_name: str
    :ivar started_on: Validation start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Validation end time.
    :vartype ended_on: ~datetime.datetime
    :ivar data_integrity_validation_result: Provides data integrity validation result between the
     source and target tables that are migrated.
    :vartype data_integrity_validation_result:
     ~azure.mgmt.datamigration.models.DataIntegrityValidationResult
    :ivar schema_validation_result: Provides schema comparison result between source and target
     database.
    :vartype schema_validation_result:
     ~azure.mgmt.datamigration.models.SchemaComparisonValidationResult
    :ivar query_analysis_validation_result: Results of some of the query execution result between
     source and target database.
    :vartype query_analysis_validation_result:
     ~azure.mgmt.datamigration.models.QueryAnalysisValidationResult
    :ivar status: Current status of validation at the database level. Known values are: "Default",
     "NotStarted", "Initialized", "InProgress", "Completed", "CompletedWithIssues", "Stopped", and
     "Failed".
    :vartype status: str or ~azure.mgmt.datamigration.models.ValidationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "migration_id": {"readonly": True},
        "source_database_name": {"readonly": True},
        "target_database_name": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "data_integrity_validation_result": {"readonly": True},
        "schema_validation_result": {"readonly": True},
        "query_analysis_validation_result": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "migration_id": {"key": "migrationId", "type": "str"},
        "source_database_name": {"key": "sourceDatabaseName", "type": "str"},
        "target_database_name": {"key": "targetDatabaseName", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "data_integrity_validation_result": {
            "key": "dataIntegrityValidationResult",
            "type": "DataIntegrityValidationResult",
        },
        "schema_validation_result": {"key": "schemaValidationResult", "type": "SchemaComparisonValidationResult"},
        "query_analysis_validation_result": {
            "key": "queryAnalysisValidationResult",
            "type": "QueryAnalysisValidationResult",
        },
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.migration_id: Optional[str] = None
        self.source_database_name: Optional[str] = None
        self.target_database_name: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.data_integrity_validation_result: Optional["_models.DataIntegrityValidationResult"] = None
        self.schema_validation_result: Optional["_models.SchemaComparisonValidationResult"] = None
        self.query_analysis_validation_result: Optional["_models.QueryAnalysisValidationResult"] = None
        self.status: Optional[Union[str, "_models.ValidationStatus"]] = None


class MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult(
    MigrateSqlServerSqlDbTaskOutput, MigrationValidationDatabaseLevelResult
):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar migration_id: Migration Identifier.
    :vartype migration_id: str
    :ivar source_database_name: Name of the source database.
    :vartype source_database_name: str
    :ivar target_database_name: Name of the target database.
    :vartype target_database_name: str
    :ivar started_on: Validation start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Validation end time.
    :vartype ended_on: ~datetime.datetime
    :ivar data_integrity_validation_result: Provides data integrity validation result between the
     source and target tables that are migrated.
    :vartype data_integrity_validation_result:
     ~azure.mgmt.datamigration.models.DataIntegrityValidationResult
    :ivar schema_validation_result: Provides schema comparison result between source and target
     database.
    :vartype schema_validation_result:
     ~azure.mgmt.datamigration.models.SchemaComparisonValidationResult
    :ivar query_analysis_validation_result: Results of some of the query execution result between
     source and target database.
    :vartype query_analysis_validation_result:
     ~azure.mgmt.datamigration.models.QueryAnalysisValidationResult
    :ivar status: Current status of validation at the database level. Known values are: "Default",
     "NotStarted", "Initialized", "InProgress", "Completed", "CompletedWithIssues", "Stopped", and
     "Failed".
    :vartype status: str or ~azure.mgmt.datamigration.models.ValidationStatus
    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    """

    _validation = {
        "migration_id": {"readonly": True},
        "source_database_name": {"readonly": True},
        "target_database_name": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "data_integrity_validation_result": {"readonly": True},
        "schema_validation_result": {"readonly": True},
        "query_analysis_validation_result": {"readonly": True},
        "status": {"readonly": True},
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "migration_id": {"key": "migrationId", "type": "str"},
        "source_database_name": {"key": "sourceDatabaseName", "type": "str"},
        "target_database_name": {"key": "targetDatabaseName", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "data_integrity_validation_result": {
            "key": "dataIntegrityValidationResult",
            "type": "DataIntegrityValidationResult",
        },
        "schema_validation_result": {"key": "schemaValidationResult", "type": "SchemaComparisonValidationResult"},
        "query_analysis_validation_result": {
            "key": "queryAnalysisValidationResult",
            "type": "QueryAnalysisValidationResult",
        },
        "status": {"key": "status", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.migration_id: Optional[str] = None
        self.source_database_name: Optional[str] = None
        self.target_database_name: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.data_integrity_validation_result: Optional["_models.DataIntegrityValidationResult"] = None
        self.schema_validation_result: Optional["_models.SchemaComparisonValidationResult"] = None
        self.query_analysis_validation_result: Optional["_models.QueryAnalysisValidationResult"] = None
        self.status: Optional[Union[str, "_models.ValidationStatus"]] = None
        self.result_type: str = "MigrationDatabaseLevelValidationOutput"
        self.id: Optional[str] = None


class MigrateSqlServerSqlDbTaskOutputError(MigrateSqlServerSqlDbTaskOutput):
    """MigrateSqlServerSqlDbTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "error": {"key": "error", "type": "ReportableException"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "ErrorOutput"
        self.error: Optional["_models.ReportableException"] = None


class MigrateSqlServerSqlDbTaskOutputMigrationLevel(MigrateSqlServerSqlDbTaskOutput):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlDbTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar duration_in_seconds: Duration of task execution in seconds.
    :vartype duration_in_seconds: int
    :ivar status: Current status of migration. Known values are: "Default", "Connecting",
     "SourceAndTargetSelected", "SelectLogins", "Configured", "Running", "Error", "Stopped",
     "Completed", and "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.datamigration.models.MigrationStatus
    :ivar status_message: Migration status message.
    :vartype status_message: str
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar databases: Selected databases as a map from database name to database id.
    :vartype databases: str
    :ivar database_summary: Summary of database results in the migration.
    :vartype database_summary: str
    :ivar migration_validation_result: Migration Validation Results.
    :vartype migration_validation_result:
     ~azure.mgmt.datamigration.models.MigrationValidationResult
    :ivar migration_report_result: Migration Report Result, provides unique url for downloading
     your migration report.
    :vartype migration_report_result: ~azure.mgmt.datamigration.models.MigrationReportResult
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "duration_in_seconds": {"readonly": True},
        "status": {"readonly": True},
        "status_message": {"readonly": True},
        "message": {"readonly": True},
        "databases": {"readonly": True},
        "database_summary": {"readonly": True},
        "source_server_version": {"readonly": True},
        "source_server_brand_version": {"readonly": True},
        "target_server_version": {"readonly": True},
        "target_server_brand_version": {"readonly": True},
        "exceptions_and_warnings": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "duration_in_seconds": {"key": "durationInSeconds", "type": "int"},
        "status": {"key": "status", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "databases": {"key": "databases", "type": "str"},
        "database_summary": {"key": "databaseSummary", "type": "str"},
        "migration_validation_result": {"key": "migrationValidationResult", "type": "MigrationValidationResult"},
        "migration_report_result": {"key": "migrationReportResult", "type": "MigrationReportResult"},
        "source_server_version": {"key": "sourceServerVersion", "type": "str"},
        "source_server_brand_version": {"key": "sourceServerBrandVersion", "type": "str"},
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "target_server_brand_version": {"key": "targetServerBrandVersion", "type": "str"},
        "exceptions_and_warnings": {"key": "exceptionsAndWarnings", "type": "[ReportableException]"},
    }

    def __init__(
        self,
        *,
        migration_validation_result: Optional["_models.MigrationValidationResult"] = None,
        migration_report_result: Optional["_models.MigrationReportResult"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword migration_validation_result: Migration Validation Results.
        :paramtype migration_validation_result:
         ~azure.mgmt.datamigration.models.MigrationValidationResult
        :keyword migration_report_result: Migration Report Result, provides unique url for downloading
         your migration report.
        :paramtype migration_report_result: ~azure.mgmt.datamigration.models.MigrationReportResult
        """
        super().__init__(**kwargs)
        self.result_type: str = "MigrationLevelOutput"
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.duration_in_seconds: Optional[int] = None
        self.status: Optional[Union[str, "_models.MigrationStatus"]] = None
        self.status_message: Optional[str] = None
        self.message: Optional[str] = None
        self.databases: Optional[str] = None
        self.database_summary: Optional[str] = None
        self.migration_validation_result = migration_validation_result
        self.migration_report_result = migration_report_result
        self.source_server_version: Optional[str] = None
        self.source_server_brand_version: Optional[str] = None
        self.target_server_version: Optional[str] = None
        self.target_server_brand_version: Optional[str] = None
        self.exceptions_and_warnings: Optional[List["_models.ReportableException"]] = None


class MigrateSqlServerSqlDbTaskOutputTableLevel(MigrateSqlServerSqlDbTaskOutput):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlDbTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar object_name: Name of the item.
    :vartype object_name: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar state: Current state of migration. Known values are: "None", "InProgress", "Failed",
     "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar status_message: Status message.
    :vartype status_message: str
    :ivar items_count: Number of items.
    :vartype items_count: int
    :ivar items_completed_count: Number of successfully completed items.
    :vartype items_completed_count: int
    :ivar error_prefix: Wildcard string prefix to use for querying all errors of the item.
    :vartype error_prefix: str
    :ivar result_prefix: Wildcard string prefix to use for querying all sub-tem results of the
     item.
    :vartype result_prefix: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "object_name": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "state": {"readonly": True},
        "status_message": {"readonly": True},
        "items_count": {"readonly": True},
        "items_completed_count": {"readonly": True},
        "error_prefix": {"readonly": True},
        "result_prefix": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "object_name": {"key": "objectName", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "state": {"key": "state", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "str"},
        "items_count": {"key": "itemsCount", "type": "int"},
        "items_completed_count": {"key": "itemsCompletedCount", "type": "int"},
        "error_prefix": {"key": "errorPrefix", "type": "str"},
        "result_prefix": {"key": "resultPrefix", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "TableLevelOutput"
        self.object_name: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.state: Optional[Union[str, "_models.MigrationState"]] = None
        self.status_message: Optional[str] = None
        self.items_count: Optional[int] = None
        self.items_completed_count: Optional[int] = None
        self.error_prefix: Optional[str] = None
        self.result_prefix: Optional[str] = None


class MigrationValidationResult(_serialization.Model):
    """Migration Validation Result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Migration validation result identifier.
    :vartype id: str
    :ivar migration_id: Migration Identifier.
    :vartype migration_id: str
    :ivar summary_results: Validation summary results for each database.
    :vartype summary_results: dict[str,
     ~azure.mgmt.datamigration.models.MigrationValidationDatabaseSummaryResult]
    :ivar status: Current status of validation at the migration level. Status from the database
     validation result status will be aggregated here. Known values are: "Default", "NotStarted",
     "Initialized", "InProgress", "Completed", "CompletedWithIssues", "Stopped", and "Failed".
    :vartype status: str or ~azure.mgmt.datamigration.models.ValidationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "migration_id": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "migration_id": {"key": "migrationId", "type": "str"},
        "summary_results": {"key": "summaryResults", "type": "{MigrationValidationDatabaseSummaryResult}"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        summary_results: Optional[Dict[str, "_models.MigrationValidationDatabaseSummaryResult"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword summary_results: Validation summary results for each database.
        :paramtype summary_results: dict[str,
         ~azure.mgmt.datamigration.models.MigrationValidationDatabaseSummaryResult]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.migration_id: Optional[str] = None
        self.summary_results = summary_results
        self.status: Optional[Union[str, "_models.ValidationStatus"]] = None


class MigrateSqlServerSqlDbTaskOutputValidationResult(
    MigrateSqlServerSqlDbTaskOutput, MigrationValidationResult
):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlDbTaskOutputValidationResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar migration_id: Migration Identifier.
    :vartype migration_id: str
    :ivar summary_results: Validation summary results for each database.
    :vartype summary_results: dict[str,
     ~azure.mgmt.datamigration.models.MigrationValidationDatabaseSummaryResult]
    :ivar status: Current status of validation at the migration level. Status from the database
     validation result status will be aggregated here. Known values are: "Default", "NotStarted",
     "Initialized", "InProgress", "Completed", "CompletedWithIssues", "Stopped", and "Failed".
    :vartype status: str or ~azure.mgmt.datamigration.models.ValidationStatus
    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    """

    _validation = {
        "migration_id": {"readonly": True},
        "status": {"readonly": True},
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "migration_id": {"key": "migrationId", "type": "str"},
        "summary_results": {"key": "summaryResults", "type": "{MigrationValidationDatabaseSummaryResult}"},
        "status": {"key": "status", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
    }

    def __init__(
        self,
        *,
        summary_results: Optional[Dict[str, "_models.MigrationValidationDatabaseSummaryResult"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword summary_results: Validation summary results for each database.
        :paramtype summary_results: dict[str,
         ~azure.mgmt.datamigration.models.MigrationValidationDatabaseSummaryResult]
        """
        super().__init__(summary_results=summary_results, **kwargs)
        self.migration_id: Optional[str] = None
        self.summary_results = summary_results
        self.status: Optional[Union[str, "_models.ValidationStatus"]] = None
        self.result_type: str = "MigrationValidationOutput"
        self.id: Optional[str] = None


class MigrateSqlServerSqlDbTaskProperties(ProjectTaskProperties):
    """Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbTaskOutput]
    :ivar task_id: task id.
    :vartype task_id: str
    :ivar is_cloneable: whether the task can be cloned or not.
    :vartype is_cloneable: bool
    :ivar created_on: DateTime in UTC when the task was created.
    :vartype created_on: str
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "MigrateSqlServerSqlDbTaskInput"},
        "output": {"key": "output", "type": "[MigrateSqlServerSqlDbTaskOutput]"},
        "task_id": {"key": "taskId", "type": "str"},
        "is_cloneable": {"key": "isCloneable", "type": "bool"},
        "created_on": {"key": "createdOn", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.MigrateSqlServerSqlDbTaskInput"] = None,
        task_id: Optional[str] = None,
        is_cloneable: Optional[bool] = None,
        created_on: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbTaskInput
        :keyword task_id: task id.
        :paramtype task_id: str
        :keyword is_cloneable: whether the task can be cloned or not.
        :paramtype is_cloneable: bool
        :keyword created_on: DateTime in UTC when the task was created.
        :paramtype created_on: str
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Migrate.SqlServer.SqlDb"
        self.input = input
        self.output: Optional[List["_models.MigrateSqlServerSqlDbTaskOutput"]] = None
        self.task_id = task_id
        self.is_cloneable = is_cloneable
        self.created_on = created_on


class MigrateSqlServerSqlMIDatabaseInput(_serialization.Model):
    """Database specific information for SQL to Azure SQL DB Managed Instance migration task inputs.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the database. Required.
    :vartype name: str
    :ivar restore_database_name: Name of the database at destination. Required.
    :vartype restore_database_name: str
    :ivar backup_file_share: Backup file share information for backing up this database.
    :vartype backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :ivar backup_file_paths: The list of backup files to be used in case of existing backups.
    :vartype backup_file_paths: list[str]
    :ivar id: id of the database.
    :vartype id: str
    """

    _validation = {
        "name": {"required": True},
        "restore_database_name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "restore_database_name": {"key": "restoreDatabaseName", "type": "str"},
        "backup_file_share": {"key": "backupFileShare", "type": "FileShare"},
        "backup_file_paths": {"key": "backupFilePaths", "type": "[str]"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        restore_database_name: str,
        backup_file_share: Optional["_models.FileShare"] = None,
        backup_file_paths: Optional[List[str]] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the database. Required.
        :paramtype name: str
        :keyword restore_database_name: Name of the database at destination. Required.
        :paramtype restore_database_name: str
        :keyword backup_file_share: Backup file share information for backing up this database.
        :paramtype backup_file_share: ~azure.mgmt.datamigration.models.FileShare
        :keyword backup_file_paths: The list of backup files to be used in case of existing backups.
        :paramtype backup_file_paths: list[str]
        :keyword id: id of the database.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.restore_database_name = restore_database_name
        self.backup_file_share = backup_file_share
        self.backup_file_paths = backup_file_paths
        self.id = id


class SqlServerSqlMISyncTaskInput(_serialization.Model):
    """Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online
    scenario.

    All required parameters must be populated in order to send to server.

    :ivar selected_databases: Databases to migrate. Required.
    :vartype selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMIDatabaseInput]
    :ivar backup_file_share: Backup file share information for all selected databases.
    :vartype backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :ivar storage_resource_id: Fully qualified resourceId of storage. Required.
    :vartype storage_resource_id: str
    :ivar source_connection_info: Connection information for source SQL Server. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar target_connection_info: Connection information for Azure SQL Database Managed Instance.
     Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.MiSqlConnectionInfo
    :ivar azure_app: Azure Active Directory Application the DMS (classic) instance will use to
     connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage
     Account. Required.
    :vartype azure_app: ~azure.mgmt.datamigration.models.AzureActiveDirectoryApp
    """

    _validation = {
        "selected_databases": {"required": True},
        "storage_resource_id": {"required": True},
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
        "azure_app": {"required": True},
    }

    _attribute_map = {
        "selected_databases": {"key": "selectedDatabases", "type": "[MigrateSqlServerSqlMIDatabaseInput]"},
        "backup_file_share": {"key": "backupFileShare", "type": "FileShare"},
        "storage_resource_id": {"key": "storageResourceId", "type": "str"},
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "SqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "MiSqlConnectionInfo"},
        "azure_app": {"key": "azureApp", "type": "AzureActiveDirectoryApp"},
    }

    def __init__(
        self,
        *,
        selected_databases: List["_models.MigrateSqlServerSqlMIDatabaseInput"],
        storage_resource_id: str,
        source_connection_info: "_models.SqlConnectionInfo",
        target_connection_info: "_models.MiSqlConnectionInfo",
        azure_app: "_models.AzureActiveDirectoryApp",
        backup_file_share: Optional["_models.FileShare"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword selected_databases: Databases to migrate. Required.
        :paramtype selected_databases:
         list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMIDatabaseInput]
        :keyword backup_file_share: Backup file share information for all selected databases.
        :paramtype backup_file_share: ~azure.mgmt.datamigration.models.FileShare
        :keyword storage_resource_id: Fully qualified resourceId of storage. Required.
        :paramtype storage_resource_id: str
        :keyword source_connection_info: Connection information for source SQL Server. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword target_connection_info: Connection information for Azure SQL Database Managed
         Instance. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.MiSqlConnectionInfo
        :keyword azure_app: Azure Active Directory Application the DMS (classic) instance will use to
         connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage
         Account. Required.
        :paramtype azure_app: ~azure.mgmt.datamigration.models.AzureActiveDirectoryApp
        """
        super().__init__(**kwargs)
        self.selected_databases = selected_databases
        self.backup_file_share = backup_file_share
        self.storage_resource_id = storage_resource_id
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info
        self.azure_app = azure_app


class MigrateSqlServerSqlMISyncTaskInput(SqlServerSqlMISyncTaskInput):
    """Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online
    scenario.

    All required parameters must be populated in order to send to server.

    :ivar selected_databases: Databases to migrate. Required.
    :vartype selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMIDatabaseInput]
    :ivar backup_file_share: Backup file share information for all selected databases.
    :vartype backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :ivar storage_resource_id: Fully qualified resourceId of storage. Required.
    :vartype storage_resource_id: str
    :ivar source_connection_info: Connection information for source SQL Server. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar target_connection_info: Connection information for Azure SQL Database Managed Instance.
     Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.MiSqlConnectionInfo
    :ivar azure_app: Azure Active Directory Application the DMS (classic) instance will use to
     connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage
     Account. Required.
    :vartype azure_app: ~azure.mgmt.datamigration.models.AzureActiveDirectoryApp
    :ivar number_of_parallel_database_migrations: Number of database migrations to start in
     parallel.
    :vartype number_of_parallel_database_migrations: float
    """

    _validation = {
        "selected_databases": {"required": True},
        "storage_resource_id": {"required": True},
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
        "azure_app": {"required": True},
    }

    _attribute_map = {
        "selected_databases": {"key": "selectedDatabases", "type": "[MigrateSqlServerSqlMIDatabaseInput]"},
        "backup_file_share": {"key": "backupFileShare", "type": "FileShare"},
        "storage_resource_id": {"key": "storageResourceId", "type": "str"},
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "SqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "MiSqlConnectionInfo"},
        "azure_app": {"key": "azureApp", "type": "AzureActiveDirectoryApp"},
        "number_of_parallel_database_migrations": {"key": "numberOfParallelDatabaseMigrations", "type": "float"},
    }

    def __init__(
        self,
        *,
        selected_databases: List["_models.MigrateSqlServerSqlMIDatabaseInput"],
        storage_resource_id: str,
        source_connection_info: "_models.SqlConnectionInfo",
        target_connection_info: "_models.MiSqlConnectionInfo",
        azure_app: "_models.AzureActiveDirectoryApp",
        backup_file_share: Optional["_models.FileShare"] = None,
        number_of_parallel_database_migrations: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword selected_databases: Databases to migrate. Required.
        :paramtype selected_databases:
         list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMIDatabaseInput]
        :keyword backup_file_share: Backup file share information for all selected databases.
        :paramtype backup_file_share: ~azure.mgmt.datamigration.models.FileShare
        :keyword storage_resource_id: Fully qualified resourceId of storage. Required.
        :paramtype storage_resource_id: str
        :keyword source_connection_info: Connection information for source SQL Server. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword target_connection_info: Connection information for Azure SQL Database Managed
         Instance. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.MiSqlConnectionInfo
        :keyword azure_app: Azure Active Directory Application the DMS (classic) instance will use to
         connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage
         Account. Required.
        :paramtype azure_app: ~azure.mgmt.datamigration.models.AzureActiveDirectoryApp
        :keyword number_of_parallel_database_migrations: Number of database migrations to start in
         parallel.
        :paramtype number_of_parallel_database_migrations: float
        """
        super().__init__(
            selected_databases=selected_databases,
            backup_file_share=backup_file_share,
            storage_resource_id=storage_resource_id,
            source_connection_info=source_connection_info,
            target_connection_info=target_connection_info,
            azure_app=azure_app,
            **kwargs
        )
        self.number_of_parallel_database_migrations = number_of_parallel_database_migrations


class MigrateSqlServerSqlMISyncTaskOutput(_serialization.Model):
    """Output for task that migrates SQL Server databases to Azure SQL Database Managed Instance using
    Log Replay Service.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel, MigrateSqlServerSqlMISyncTaskOutputError,
    MigrateSqlServerSqlMISyncTaskOutputMigrationLevel

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
    }

    _subtype_map = {
        "result_type": {
            "DatabaseLevelOutput": "MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel",
            "ErrorOutput": "MigrateSqlServerSqlMISyncTaskOutputError",
            "MigrationLevelOutput": "MigrateSqlServerSqlMISyncTaskOutputMigrationLevel",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.result_type: Optional[str] = None


class MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel(
    MigrateSqlServerSqlMISyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar source_database_name: Name of the database.
    :vartype source_database_name: str
    :ivar migration_state: Current state of database. Known values are: "UNDEFINED", "INITIAL",
     "FULL_BACKUP_UPLOAD_START", "LOG_SHIPPING_START", "UPLOAD_LOG_FILES_START", "CUTOVER_START",
     "POST_CUTOVER_COMPLETE", "COMPLETED", "CANCELLED", and "FAILED".
    :vartype migration_state: str or ~azure.mgmt.datamigration.models.DatabaseMigrationState
    :ivar started_on: Database migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Database migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar full_backup_set_info: Details of full backup set.
    :vartype full_backup_set_info: ~azure.mgmt.datamigration.models.BackupSetInfo
    :ivar last_restored_backup_set_info: Last applied backup set information.
    :vartype last_restored_backup_set_info: ~azure.mgmt.datamigration.models.BackupSetInfo
    :ivar active_backup_sets: Backup sets that are currently active (Either being uploaded or
     getting restored).
    :vartype active_backup_sets: list[~azure.mgmt.datamigration.models.BackupSetInfo]
    :ivar container_name: Name of container created in the Azure Storage account where backups are
     copied to.
    :vartype container_name: str
    :ivar error_prefix: prefix string to use for querying errors for this database.
    :vartype error_prefix: str
    :ivar is_full_backup_restored: Whether full backup has been applied to the target database or
     not.
    :vartype is_full_backup_restored: bool
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "source_database_name": {"readonly": True},
        "migration_state": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "full_backup_set_info": {"readonly": True},
        "last_restored_backup_set_info": {"readonly": True},
        "active_backup_sets": {"readonly": True},
        "container_name": {"readonly": True},
        "error_prefix": {"readonly": True},
        "is_full_backup_restored": {"readonly": True},
        "exceptions_and_warnings": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "source_database_name": {"key": "sourceDatabaseName", "type": "str"},
        "migration_state": {"key": "migrationState", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "full_backup_set_info": {"key": "fullBackupSetInfo", "type": "BackupSetInfo"},
        "last_restored_backup_set_info": {"key": "lastRestoredBackupSetInfo", "type": "BackupSetInfo"},
        "active_backup_sets": {"key": "activeBackupSets", "type": "[BackupSetInfo]"},
        "container_name": {"key": "containerName", "type": "str"},
        "error_prefix": {"key": "errorPrefix", "type": "str"},
        "is_full_backup_restored": {"key": "isFullBackupRestored", "type": "bool"},
        "exceptions_and_warnings": {"key": "exceptionsAndWarnings", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "DatabaseLevelOutput"
        self.source_database_name: Optional[str] = None
        self.migration_state: Optional[Union[str, "_models.DatabaseMigrationState"]] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.full_backup_set_info: Optional["_models.BackupSetInfo"] = None
        self.last_restored_backup_set_info: Optional["_models.BackupSetInfo"] = None
        self.active_backup_sets: Optional[List["_models.BackupSetInfo"]] = None
        self.container_name: Optional[str] = None
        self.error_prefix: Optional[str] = None
        self.is_full_backup_restored: Optional[bool] = None
        self.exceptions_and_warnings: Optional[List["_models.ReportableException"]] = None


class MigrateSqlServerSqlMISyncTaskOutputError(MigrateSqlServerSqlMISyncTaskOutput):
    """MigrateSqlServerSqlMISyncTaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "error": {"key": "error", "type": "ReportableException"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "ErrorOutput"
        self.error: Optional["_models.ReportableException"] = None


class MigrateSqlServerSqlMISyncTaskOutputMigrationLevel(
    MigrateSqlServerSqlMISyncTaskOutput
):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlMISyncTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar database_count: Count of databases.
    :vartype database_count: int
    :ivar state: Current state of migration. Known values are: "None", "InProgress", "Failed",
     "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar source_server_name: Source server name.
    :vartype source_server_name: str
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar target_server_name: Target server name.
    :vartype target_server_name: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar database_error_count: Number of database level errors.
    :vartype database_error_count: int
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "database_count": {"readonly": True},
        "state": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "source_server_name": {"readonly": True},
        "source_server_version": {"readonly": True},
        "source_server_brand_version": {"readonly": True},
        "target_server_name": {"readonly": True},
        "target_server_version": {"readonly": True},
        "target_server_brand_version": {"readonly": True},
        "database_error_count": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "database_count": {"key": "databaseCount", "type": "int"},
        "state": {"key": "state", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "source_server_name": {"key": "sourceServerName", "type": "str"},
        "source_server_version": {"key": "sourceServerVersion", "type": "str"},
        "source_server_brand_version": {"key": "sourceServerBrandVersion", "type": "str"},
        "target_server_name": {"key": "targetServerName", "type": "str"},
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "target_server_brand_version": {"key": "targetServerBrandVersion", "type": "str"},
        "database_error_count": {"key": "databaseErrorCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "MigrationLevelOutput"
        self.database_count: Optional[int] = None
        self.state: Optional[Union[str, "_models.MigrationState"]] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.source_server_name: Optional[str] = None
        self.source_server_version: Optional[str] = None
        self.source_server_brand_version: Optional[str] = None
        self.target_server_name: Optional[str] = None
        self.target_server_version: Optional[str] = None
        self.target_server_brand_version: Optional[str] = None
        self.database_error_count: Optional[int] = None


class MigrateSqlServerSqlMISyncTaskProperties(ProjectTaskProperties):
    """Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance
    sync scenario.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.MigrateSqlServerSqlMISyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMISyncTaskOutput]
    :ivar created_on: DateTime in UTC when the task was created.
    :vartype created_on: str
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "MigrateSqlServerSqlMISyncTaskInput"},
        "output": {"key": "output", "type": "[MigrateSqlServerSqlMISyncTaskOutput]"},
        "created_on": {"key": "createdOn", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.MigrateSqlServerSqlMISyncTaskInput"] = None,
        created_on: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.MigrateSqlServerSqlMISyncTaskInput
        :keyword created_on: DateTime in UTC when the task was created.
        :paramtype created_on: str
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS"
        self.input = input
        self.output: Optional[List["_models.MigrateSqlServerSqlMISyncTaskOutput"]] = None
        self.created_on = created_on


class MigrateSqlServerSqlMITaskInput(SqlMigrationTaskInput):
    """Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Information for connecting to source. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar target_connection_info: Information for connecting to target. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar selected_databases: Databases to migrate. Required.
    :vartype selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMIDatabaseInput]
    :ivar started_on: Date and time relative to UTC when the migration was started on.
    :vartype started_on: str
    :ivar selected_logins: Logins to migrate.
    :vartype selected_logins: list[str]
    :ivar selected_agent_jobs: Agent Jobs to migrate.
    :vartype selected_agent_jobs: list[str]
    :ivar backup_file_share: Backup file share information for all selected databases.
    :vartype backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :ivar backup_blob_share: SAS URI of Azure Storage Account Container to be used for storing
     backup files. Required.
    :vartype backup_blob_share: ~azure.mgmt.datamigration.models.BlobShare
    :ivar backup_mode: Backup Mode to specify whether to use existing backup or create new backup.
     If using existing backups, backup file paths are required to be provided in selectedDatabases.
     Known values are: "CreateBackup" and "ExistingBackup".
    :vartype backup_mode: str or ~azure.mgmt.datamigration.models.BackupMode
    :ivar aad_domain_name: Azure Active Directory domain name in the format of 'contoso.com' for
     federated Azure AD or 'contoso.onmicrosoft.com' for managed domain, required if and only if
     Windows logins are selected.
    :vartype aad_domain_name: str
    :ivar encrypted_key_for_secure_fields: encrypted key for secure fields.
    :vartype encrypted_key_for_secure_fields: str
    """

    _validation = {
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
        "selected_databases": {"required": True},
        "backup_blob_share": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "SqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "SqlConnectionInfo"},
        "selected_databases": {"key": "selectedDatabases", "type": "[MigrateSqlServerSqlMIDatabaseInput]"},
        "started_on": {"key": "startedOn", "type": "str"},
        "selected_logins": {"key": "selectedLogins", "type": "[str]"},
        "selected_agent_jobs": {"key": "selectedAgentJobs", "type": "[str]"},
        "backup_file_share": {"key": "backupFileShare", "type": "FileShare"},
        "backup_blob_share": {"key": "backupBlobShare", "type": "BlobShare"},
        "backup_mode": {"key": "backupMode", "type": "str"},
        "aad_domain_name": {"key": "aadDomainName", "type": "str"},
        "encrypted_key_for_secure_fields": {"key": "encryptedKeyForSecureFields", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.SqlConnectionInfo",
        target_connection_info: "_models.SqlConnectionInfo",
        selected_databases: List["_models.MigrateSqlServerSqlMIDatabaseInput"],
        backup_blob_share: "_models.BlobShare",
        started_on: Optional[str] = None,
        selected_logins: Optional[List[str]] = None,
        selected_agent_jobs: Optional[List[str]] = None,
        backup_file_share: Optional["_models.FileShare"] = None,
        backup_mode: Optional[Union[str, "_models.BackupMode"]] = None,
        aad_domain_name: Optional[str] = None,
        encrypted_key_for_secure_fields: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Information for connecting to source. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword target_connection_info: Information for connecting to target. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword selected_databases: Databases to migrate. Required.
        :paramtype selected_databases:
         list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMIDatabaseInput]
        :keyword started_on: Date and time relative to UTC when the migration was started on.
        :paramtype started_on: str
        :keyword selected_logins: Logins to migrate.
        :paramtype selected_logins: list[str]
        :keyword selected_agent_jobs: Agent Jobs to migrate.
        :paramtype selected_agent_jobs: list[str]
        :keyword backup_file_share: Backup file share information for all selected databases.
        :paramtype backup_file_share: ~azure.mgmt.datamigration.models.FileShare
        :keyword backup_blob_share: SAS URI of Azure Storage Account Container to be used for storing
         backup files. Required.
        :paramtype backup_blob_share: ~azure.mgmt.datamigration.models.BlobShare
        :keyword backup_mode: Backup Mode to specify whether to use existing backup or create new
         backup. If using existing backups, backup file paths are required to be provided in
         selectedDatabases. Known values are: "CreateBackup" and "ExistingBackup".
        :paramtype backup_mode: str or ~azure.mgmt.datamigration.models.BackupMode
        :keyword aad_domain_name: Azure Active Directory domain name in the format of 'contoso.com' for
         federated Azure AD or 'contoso.onmicrosoft.com' for managed domain, required if and only if
         Windows logins are selected.
        :paramtype aad_domain_name: str
        :keyword encrypted_key_for_secure_fields: encrypted key for secure fields.
        :paramtype encrypted_key_for_secure_fields: str
        """
        super().__init__(
            source_connection_info=source_connection_info, target_connection_info=target_connection_info, **kwargs
        )
        self.selected_databases = selected_databases
        self.started_on = started_on
        self.selected_logins = selected_logins
        self.selected_agent_jobs = selected_agent_jobs
        self.backup_file_share = backup_file_share
        self.backup_blob_share = backup_blob_share
        self.backup_mode = backup_mode
        self.aad_domain_name = aad_domain_name
        self.encrypted_key_for_secure_fields = encrypted_key_for_secure_fields


class MigrateSqlServerSqlMITaskOutput(_serialization.Model):
    """Output for task that migrates SQL Server databases to Azure SQL Database Managed Instance.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MigrateSqlServerSqlMITaskOutputAgentJobLevel, MigrateSqlServerSqlMITaskOutputDatabaseLevel,
    MigrateSqlServerSqlMITaskOutputError, MigrateSqlServerSqlMITaskOutputLoginLevel,
    MigrateSqlServerSqlMITaskOutputMigrationLevel

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
    }

    _subtype_map = {
        "result_type": {
            "AgentJobLevelOutput": "MigrateSqlServerSqlMITaskOutputAgentJobLevel",
            "DatabaseLevelOutput": "MigrateSqlServerSqlMITaskOutputDatabaseLevel",
            "ErrorOutput": "MigrateSqlServerSqlMITaskOutputError",
            "LoginLevelOutput": "MigrateSqlServerSqlMITaskOutputLoginLevel",
            "MigrationLevelOutput": "MigrateSqlServerSqlMITaskOutputMigrationLevel",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.result_type: Optional[str] = None


class MigrateSqlServerSqlMITaskOutputAgentJobLevel(MigrateSqlServerSqlMITaskOutput):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlMITaskOutputAgentJobLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar name: Agent Job name.
    :vartype name: str
    :ivar is_enabled: The state of the original Agent Job.
    :vartype is_enabled: bool
    :ivar state: Current state of migration. Known values are: "None", "InProgress", "Failed",
     "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar exceptions_and_warnings: Migration errors and warnings per job.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "name": {"readonly": True},
        "is_enabled": {"readonly": True},
        "state": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "message": {"readonly": True},
        "exceptions_and_warnings": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "state": {"key": "state", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "exceptions_and_warnings": {"key": "exceptionsAndWarnings", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "AgentJobLevelOutput"
        self.name: Optional[str] = None
        self.is_enabled: Optional[bool] = None
        self.state: Optional[Union[str, "_models.MigrationState"]] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.message: Optional[str] = None
        self.exceptions_and_warnings: Optional[List["_models.ReportableException"]] = None


class MigrateSqlServerSqlMITaskOutputDatabaseLevel(MigrateSqlServerSqlMITaskOutput):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlMITaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar size_mb: Size of the database in megabytes.
    :vartype size_mb: float
    :ivar state: Current state of migration. Known values are: "None", "InProgress", "Failed",
     "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar stage: Current stage of migration. Known values are: "None", "Initialize", "Backup",
     "FileCopy", "Restore", and "Completed".
    :vartype stage: str or ~azure.mgmt.datamigration.models.DatabaseMigrationStage
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "database_name": {"readonly": True},
        "size_mb": {"readonly": True},
        "state": {"readonly": True},
        "stage": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "message": {"readonly": True},
        "exceptions_and_warnings": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "size_mb": {"key": "sizeMB", "type": "float"},
        "state": {"key": "state", "type": "str"},
        "stage": {"key": "stage", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "exceptions_and_warnings": {"key": "exceptionsAndWarnings", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "DatabaseLevelOutput"
        self.database_name: Optional[str] = None
        self.size_mb: Optional[float] = None
        self.state: Optional[Union[str, "_models.MigrationState"]] = None
        self.stage: Optional[Union[str, "_models.DatabaseMigrationStage"]] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.message: Optional[str] = None
        self.exceptions_and_warnings: Optional[List["_models.ReportableException"]] = None


class MigrateSqlServerSqlMITaskOutputError(MigrateSqlServerSqlMITaskOutput):
    """MigrateSqlServerSqlMITaskOutputError.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar error: Migration error.
    :vartype error: ~azure.mgmt.datamigration.models.ReportableException
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "error": {"key": "error", "type": "ReportableException"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "ErrorOutput"
        self.error: Optional["_models.ReportableException"] = None


class MigrateSqlServerSqlMITaskOutputLoginLevel(MigrateSqlServerSqlMITaskOutput):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlMITaskOutputLoginLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar login_name: Login name.
    :vartype login_name: str
    :ivar state: Current state of login. Known values are: "None", "InProgress", "Failed",
     "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar stage: Current stage of login. Known values are: "None", "Initialize", "LoginMigration",
     "EstablishUserMapping", "AssignRoleMembership", "AssignRoleOwnership",
     "EstablishServerPermissions", "EstablishObjectPermissions", and "Completed".
    :vartype stage: str or ~azure.mgmt.datamigration.models.LoginMigrationStage
    :ivar started_on: Login migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Login migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar message: Login migration progress message.
    :vartype message: str
    :ivar exceptions_and_warnings: Login migration errors and warnings per login.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "login_name": {"readonly": True},
        "state": {"readonly": True},
        "stage": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "message": {"readonly": True},
        "exceptions_and_warnings": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "login_name": {"key": "loginName", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "stage": {"key": "stage", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "exceptions_and_warnings": {"key": "exceptionsAndWarnings", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "LoginLevelOutput"
        self.login_name: Optional[str] = None
        self.state: Optional[Union[str, "_models.MigrationState"]] = None
        self.stage: Optional[Union[str, "_models.LoginMigrationStage"]] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.message: Optional[str] = None
        self.exceptions_and_warnings: Optional[List["_models.ReportableException"]] = None


class MigrateSqlServerSqlMITaskOutputMigrationLevel(MigrateSqlServerSqlMITaskOutput):  # pylint: disable=name-too-long
    """MigrateSqlServerSqlMITaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar status: Current status of migration. Known values are: "Default", "Connecting",
     "SourceAndTargetSelected", "SelectLogins", "Configured", "Running", "Error", "Stopped",
     "Completed", and "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.datamigration.models.MigrationStatus
    :ivar state: Current state of migration. Known values are: "None", "InProgress", "Failed",
     "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar agent_jobs: Selected agent jobs as a map from name to id.
    :vartype agent_jobs: str
    :ivar logins: Selected logins as a map from name to id.
    :vartype logins: str
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar server_role_results: Map of server role migration results.
    :vartype server_role_results: str
    :ivar orphaned_users_info: List of orphaned users.
    :vartype orphaned_users_info: list[~azure.mgmt.datamigration.models.OrphanedUserInfo]
    :ivar databases: Selected databases as a map from database name to database id.
    :vartype databases: str
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "status": {"readonly": True},
        "state": {"readonly": True},
        "agent_jobs": {"readonly": True},
        "logins": {"readonly": True},
        "message": {"readonly": True},
        "server_role_results": {"readonly": True},
        "orphaned_users_info": {"readonly": True},
        "databases": {"readonly": True},
        "source_server_version": {"readonly": True},
        "source_server_brand_version": {"readonly": True},
        "target_server_version": {"readonly": True},
        "target_server_brand_version": {"readonly": True},
        "exceptions_and_warnings": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "agent_jobs": {"key": "agentJobs", "type": "str"},
        "logins": {"key": "logins", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "server_role_results": {"key": "serverRoleResults", "type": "str"},
        "orphaned_users_info": {"key": "orphanedUsersInfo", "type": "[OrphanedUserInfo]"},
        "databases": {"key": "databases", "type": "str"},
        "source_server_version": {"key": "sourceServerVersion", "type": "str"},
        "source_server_brand_version": {"key": "sourceServerBrandVersion", "type": "str"},
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "target_server_brand_version": {"key": "targetServerBrandVersion", "type": "str"},
        "exceptions_and_warnings": {"key": "exceptionsAndWarnings", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "MigrationLevelOutput"
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.status: Optional[Union[str, "_models.MigrationStatus"]] = None
        self.state: Optional[Union[str, "_models.MigrationState"]] = None
        self.agent_jobs: Optional[str] = None
        self.logins: Optional[str] = None
        self.message: Optional[str] = None
        self.server_role_results: Optional[str] = None
        self.orphaned_users_info: Optional[List["_models.OrphanedUserInfo"]] = None
        self.databases: Optional[str] = None
        self.source_server_version: Optional[str] = None
        self.source_server_brand_version: Optional[str] = None
        self.target_server_version: Optional[str] = None
        self.target_server_brand_version: Optional[str] = None
        self.exceptions_and_warnings: Optional[List["_models.ReportableException"]] = None


class MigrateSqlServerSqlMITaskProperties(ProjectTaskProperties):
    """Properties for task that migrates SQL Server databases to Azure SQL Database Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.MigrateSqlServerSqlMITaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMITaskOutput]
    :ivar task_id: task id.
    :vartype task_id: str
    :ivar created_on: DateTime in UTC when the task was created.
    :vartype created_on: str
    :ivar parent_task_id: parent task id.
    :vartype parent_task_id: str
    :ivar is_cloneable: whether the task can be cloned or not.
    :vartype is_cloneable: bool
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "MigrateSqlServerSqlMITaskInput"},
        "output": {"key": "output", "type": "[MigrateSqlServerSqlMITaskOutput]"},
        "task_id": {"key": "taskId", "type": "str"},
        "created_on": {"key": "createdOn", "type": "str"},
        "parent_task_id": {"key": "parentTaskId", "type": "str"},
        "is_cloneable": {"key": "isCloneable", "type": "bool"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.MigrateSqlServerSqlMITaskInput"] = None,
        task_id: Optional[str] = None,
        created_on: Optional[str] = None,
        parent_task_id: Optional[str] = None,
        is_cloneable: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.MigrateSqlServerSqlMITaskInput
        :keyword task_id: task id.
        :paramtype task_id: str
        :keyword created_on: DateTime in UTC when the task was created.
        :paramtype created_on: str
        :keyword parent_task_id: parent task id.
        :paramtype parent_task_id: str
        :keyword is_cloneable: whether the task can be cloned or not.
        :paramtype is_cloneable: bool
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Migrate.SqlServer.AzureSqlDbMI"
        self.input = input
        self.output: Optional[List["_models.MigrateSqlServerSqlMITaskOutput"]] = None
        self.task_id = task_id
        self.created_on = created_on
        self.parent_task_id = parent_task_id
        self.is_cloneable = is_cloneable


class MigrateSsisTaskInput(SqlMigrationTaskInput):
    """Input for task that migrates SSIS packages from SQL Server to Azure SQL Database Managed
    Instance.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Information for connecting to source. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar target_connection_info: Information for connecting to target. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar ssis_migration_info: SSIS package migration information. Required.
    :vartype ssis_migration_info: ~azure.mgmt.datamigration.models.SsisMigrationInfo
    """

    _validation = {
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
        "ssis_migration_info": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "SqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "SqlConnectionInfo"},
        "ssis_migration_info": {"key": "ssisMigrationInfo", "type": "SsisMigrationInfo"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.SqlConnectionInfo",
        target_connection_info: "_models.SqlConnectionInfo",
        ssis_migration_info: "_models.SsisMigrationInfo",
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Information for connecting to source. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword target_connection_info: Information for connecting to target. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword ssis_migration_info: SSIS package migration information. Required.
        :paramtype ssis_migration_info: ~azure.mgmt.datamigration.models.SsisMigrationInfo
        """
        super().__init__(
            source_connection_info=source_connection_info, target_connection_info=target_connection_info, **kwargs
        )
        self.ssis_migration_info = ssis_migration_info


class MigrateSsisTaskOutput(_serialization.Model):
    """Output for task that migrates SSIS packages from SQL Server to Azure SQL Database Managed
    Instance.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MigrateSsisTaskOutputMigrationLevel, MigrateSsisTaskOutputProjectLevel

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
    }

    _subtype_map = {
        "result_type": {
            "MigrationLevelOutput": "MigrateSsisTaskOutputMigrationLevel",
            "SsisProjectLevelOutput": "MigrateSsisTaskOutputProjectLevel",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.result_type: Optional[str] = None


class MigrateSsisTaskOutputMigrationLevel(MigrateSsisTaskOutput):
    """MigrateSsisTaskOutputMigrationLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar status: Current status of migration. Known values are: "Default", "Connecting",
     "SourceAndTargetSelected", "SelectLogins", "Configured", "Running", "Error", "Stopped",
     "Completed", and "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.datamigration.models.MigrationStatus
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar source_server_version: Source server version.
    :vartype source_server_version: str
    :ivar source_server_brand_version: Source server brand version.
    :vartype source_server_brand_version: str
    :ivar target_server_version: Target server version.
    :vartype target_server_version: str
    :ivar target_server_brand_version: Target server brand version.
    :vartype target_server_brand_version: str
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar stage: Stage of SSIS migration. Known values are: "None", "Initialize", "InProgress", and
     "Completed".
    :vartype stage: str or ~azure.mgmt.datamigration.models.SsisMigrationStage
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "status": {"readonly": True},
        "message": {"readonly": True},
        "source_server_version": {"readonly": True},
        "source_server_brand_version": {"readonly": True},
        "target_server_version": {"readonly": True},
        "target_server_brand_version": {"readonly": True},
        "exceptions_and_warnings": {"readonly": True},
        "stage": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "source_server_version": {"key": "sourceServerVersion", "type": "str"},
        "source_server_brand_version": {"key": "sourceServerBrandVersion", "type": "str"},
        "target_server_version": {"key": "targetServerVersion", "type": "str"},
        "target_server_brand_version": {"key": "targetServerBrandVersion", "type": "str"},
        "exceptions_and_warnings": {"key": "exceptionsAndWarnings", "type": "[ReportableException]"},
        "stage": {"key": "stage", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "MigrationLevelOutput"
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.status: Optional[Union[str, "_models.MigrationStatus"]] = None
        self.message: Optional[str] = None
        self.source_server_version: Optional[str] = None
        self.source_server_brand_version: Optional[str] = None
        self.target_server_version: Optional[str] = None
        self.target_server_brand_version: Optional[str] = None
        self.exceptions_and_warnings: Optional[List["_models.ReportableException"]] = None
        self.stage: Optional[Union[str, "_models.SsisMigrationStage"]] = None


class MigrateSsisTaskOutputProjectLevel(MigrateSsisTaskOutput):
    """MigrateSsisTaskOutputProjectLevel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar folder_name: Name of the folder.
    :vartype folder_name: str
    :ivar project_name: Name of the project.
    :vartype project_name: str
    :ivar state: Current state of migration. Known values are: "None", "InProgress", "Failed",
     "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar stage: Stage of SSIS migration. Known values are: "None", "Initialize", "InProgress", and
     "Completed".
    :vartype stage: str or ~azure.mgmt.datamigration.models.SsisMigrationStage
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar message: Migration progress message.
    :vartype message: str
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "result_type": {"required": True},
        "folder_name": {"readonly": True},
        "project_name": {"readonly": True},
        "state": {"readonly": True},
        "stage": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "message": {"readonly": True},
        "exceptions_and_warnings": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "folder_name": {"key": "folderName", "type": "str"},
        "project_name": {"key": "projectName", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "stage": {"key": "stage", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "exceptions_and_warnings": {"key": "exceptionsAndWarnings", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_type: str = "SsisProjectLevelOutput"
        self.folder_name: Optional[str] = None
        self.project_name: Optional[str] = None
        self.state: Optional[Union[str, "_models.MigrationState"]] = None
        self.stage: Optional[Union[str, "_models.SsisMigrationStage"]] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.message: Optional[str] = None
        self.exceptions_and_warnings: Optional[List["_models.ReportableException"]] = None


class MigrateSsisTaskProperties(ProjectTaskProperties):
    """Properties for task that migrates SSIS packages from SQL Server databases to Azure SQL Database
    Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.MigrateSsisTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.MigrateSsisTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "MigrateSsisTaskInput"},
        "output": {"key": "output", "type": "[MigrateSsisTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.MigrateSsisTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.MigrateSsisTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Migrate.Ssis"
        self.input = input
        self.output: Optional[List["_models.MigrateSsisTaskOutput"]] = None


class MigrateSyncCompleteCommandInput(_serialization.Model):
    """Input for command that completes sync migration for a database.

    All required parameters must be populated in order to send to server.

    :ivar database_name: Name of database. Required.
    :vartype database_name: str
    :ivar commit_time_stamp: Time stamp to complete.
    :vartype commit_time_stamp: ~datetime.datetime
    """

    _validation = {
        "database_name": {"required": True},
    }

    _attribute_map = {
        "database_name": {"key": "databaseName", "type": "str"},
        "commit_time_stamp": {"key": "commitTimeStamp", "type": "iso-8601"},
    }

    def __init__(
        self, *, database_name: str, commit_time_stamp: Optional[datetime.datetime] = None, **kwargs: Any
    ) -> None:
        """
        :keyword database_name: Name of database. Required.
        :paramtype database_name: str
        :keyword commit_time_stamp: Time stamp to complete.
        :paramtype commit_time_stamp: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.database_name = database_name
        self.commit_time_stamp = commit_time_stamp


class MigrateSyncCompleteCommandOutput(_serialization.Model):
    """Output for command that completes sync migration for a database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar errors: List of errors that happened during the command execution.
    :vartype errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "errors": {"key": "errors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.errors: Optional[List["_models.ReportableException"]] = None


class MigrateSyncCompleteCommandProperties(CommandProperties):
    """Properties for the command that completes sync migration for a database.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar command_type: Command type. Required. Known values are: "Migrate.Sync.Complete.Database",
     "Migrate.SqlServer.AzureDbSqlMi.Complete", "cancel", "finish", and "restart".
    :vartype command_type: str or ~azure.mgmt.datamigration.models.CommandType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the command. This is ignored if submitted. Known values are:
     "Unknown", "Accepted", "Running", "Succeeded", and "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.CommandState
    :ivar input: Command input.
    :vartype input: ~azure.mgmt.datamigration.models.MigrateSyncCompleteCommandInput
    :ivar output: Command output. This is ignored if submitted.
    :vartype output: ~azure.mgmt.datamigration.models.MigrateSyncCompleteCommandOutput
    :ivar command_id: Command id.
    :vartype command_id: str
    """

    _validation = {
        "command_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "command_type": {"key": "commandType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "input": {"key": "input", "type": "MigrateSyncCompleteCommandInput"},
        "output": {"key": "output", "type": "MigrateSyncCompleteCommandOutput"},
        "command_id": {"key": "commandId", "type": "str"},
    }

    def __init__(
        self,
        *,
        input: Optional["_models.MigrateSyncCompleteCommandInput"] = None,
        command_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword input: Command input.
        :paramtype input: ~azure.mgmt.datamigration.models.MigrateSyncCompleteCommandInput
        :keyword command_id: Command id.
        :paramtype command_id: str
        """
        super().__init__(**kwargs)
        self.command_type: str = "Migrate.Sync.Complete.Database"
        self.input = input
        self.output: Optional["_models.MigrateSyncCompleteCommandOutput"] = None
        self.command_id = command_id


class MigrationEligibilityInfo(_serialization.Model):
    """Information about migration eligibility of a server object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_eligible_for_migration: Whether object is eligible for migration or not.
    :vartype is_eligible_for_migration: bool
    :ivar validation_messages: Information about eligibility failure for the server object.
    :vartype validation_messages: list[str]
    """

    _validation = {
        "is_eligible_for_migration": {"readonly": True},
        "validation_messages": {"readonly": True},
    }

    _attribute_map = {
        "is_eligible_for_migration": {"key": "isEligibleForMigration", "type": "bool"},
        "validation_messages": {"key": "validationMessages", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.is_eligible_for_migration: Optional[bool] = None
        self.validation_messages: Optional[List[str]] = None


class MigrationOperationInput(_serialization.Model):
    """Migration Operation Input.

    :ivar migration_operation_id: ID tracking migration operation.
    :vartype migration_operation_id: str
    """

    _attribute_map = {
        "migration_operation_id": {"key": "migrationOperationId", "type": "str"},
    }

    def __init__(self, *, migration_operation_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword migration_operation_id: ID tracking migration operation.
        :paramtype migration_operation_id: str
        """
        super().__init__(**kwargs)
        self.migration_operation_id = migration_operation_id


class MigrationReportResult(_serialization.Model):
    """Migration validation report result, contains the url for downloading the generated report.

    :ivar id: Migration validation result identifier.
    :vartype id: str
    :ivar report_url: The url of the report.
    :vartype report_url: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "report_url": {"key": "reportUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        report_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Migration validation result identifier.
        :paramtype id: str
        :keyword report_url: The url of the report.
        :paramtype report_url: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.report_url = report_url


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class MigrationService(TrackedResource):
    """A Migration Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: Provisioning state to track the async operation status. Known values
     are: "Provisioning", "Updating", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.datamigration.models.ProvisioningState
    :ivar integration_runtime_state: Current state of the Integration runtime.
    :vartype integration_runtime_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "integration_runtime_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "integration_runtime_state": {"key": "properties.integrationRuntimeState", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.integration_runtime_state: Optional[str] = None


class MigrationServiceListResult(_serialization.Model):
    """A list of Migration Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.datamigration.models.MigrationService]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MigrationService]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.MigrationService"]] = None
        self.next_link: Optional[str] = None


class MigrationServiceUpdate(_serialization.Model):
    """An update to a Migration Service.

    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class MigrationStatusDetails(_serialization.Model):
    """Detailed status of current migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar migration_state: Current State of Migration.
    :vartype migration_state: str
    :ivar full_backup_set_info: Details of full backup set.
    :vartype full_backup_set_info: ~azure.mgmt.datamigration.models.SqlBackupSetInfo
    :ivar last_restored_backup_set_info: Last applied backup set information.
    :vartype last_restored_backup_set_info: ~azure.mgmt.datamigration.models.SqlBackupSetInfo
    :ivar active_backup_sets: Backup sets that are currently active.
    :vartype active_backup_sets: list[~azure.mgmt.datamigration.models.SqlBackupSetInfo]
    :ivar invalid_files: Files that are not valid backup files.
    :vartype invalid_files: list[str]
    :ivar blob_container_name: Name of blob container.
    :vartype blob_container_name: str
    :ivar is_full_backup_restored: Whether full backup has been applied to the target database or
     not.
    :vartype is_full_backup_restored: bool
    :ivar restore_blocking_reason: Restore blocking reason, if any.
    :vartype restore_blocking_reason: str
    :ivar complete_restore_error_message: Complete restore error message, if any.
    :vartype complete_restore_error_message: str
    :ivar file_upload_blocking_errors: File upload blocking errors, if any.
    :vartype file_upload_blocking_errors: list[str]
    :ivar current_restoring_filename: File name that is currently being restored.
    :vartype current_restoring_filename: str
    :ivar last_restored_filename: Last restored file name.
    :vartype last_restored_filename: str
    :ivar pending_log_backups_count: Total pending log backups.
    :vartype pending_log_backups_count: int
    """

    _validation = {
        "migration_state": {"readonly": True},
        "full_backup_set_info": {"readonly": True},
        "last_restored_backup_set_info": {"readonly": True},
        "active_backup_sets": {"readonly": True},
        "invalid_files": {"readonly": True},
        "blob_container_name": {"readonly": True},
        "is_full_backup_restored": {"readonly": True},
        "restore_blocking_reason": {"readonly": True},
        "complete_restore_error_message": {"readonly": True},
        "file_upload_blocking_errors": {"readonly": True},
        "current_restoring_filename": {"readonly": True},
        "last_restored_filename": {"readonly": True},
        "pending_log_backups_count": {"readonly": True},
    }

    _attribute_map = {
        "migration_state": {"key": "migrationState", "type": "str"},
        "full_backup_set_info": {"key": "fullBackupSetInfo", "type": "SqlBackupSetInfo"},
        "last_restored_backup_set_info": {"key": "lastRestoredBackupSetInfo", "type": "SqlBackupSetInfo"},
        "active_backup_sets": {"key": "activeBackupSets", "type": "[SqlBackupSetInfo]"},
        "invalid_files": {"key": "invalidFiles", "type": "[str]"},
        "blob_container_name": {"key": "blobContainerName", "type": "str"},
        "is_full_backup_restored": {"key": "isFullBackupRestored", "type": "bool"},
        "restore_blocking_reason": {"key": "restoreBlockingReason", "type": "str"},
        "complete_restore_error_message": {"key": "completeRestoreErrorMessage", "type": "str"},
        "file_upload_blocking_errors": {"key": "fileUploadBlockingErrors", "type": "[str]"},
        "current_restoring_filename": {"key": "currentRestoringFilename", "type": "str"},
        "last_restored_filename": {"key": "lastRestoredFilename", "type": "str"},
        "pending_log_backups_count": {"key": "pendingLogBackupsCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.migration_state: Optional[str] = None
        self.full_backup_set_info: Optional["_models.SqlBackupSetInfo"] = None
        self.last_restored_backup_set_info: Optional["_models.SqlBackupSetInfo"] = None
        self.active_backup_sets: Optional[List["_models.SqlBackupSetInfo"]] = None
        self.invalid_files: Optional[List[str]] = None
        self.blob_container_name: Optional[str] = None
        self.is_full_backup_restored: Optional[bool] = None
        self.restore_blocking_reason: Optional[str] = None
        self.complete_restore_error_message: Optional[str] = None
        self.file_upload_blocking_errors: Optional[List[str]] = None
        self.current_restoring_filename: Optional[str] = None
        self.last_restored_filename: Optional[str] = None
        self.pending_log_backups_count: Optional[int] = None


class MigrationTableMetadata(_serialization.Model):
    """Metadata for tables selected in migration project.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source_table_name: Source table name.
    :vartype source_table_name: str
    :ivar target_table_name: Target table name.
    :vartype target_table_name: str
    """

    _validation = {
        "source_table_name": {"readonly": True},
        "target_table_name": {"readonly": True},
    }

    _attribute_map = {
        "source_table_name": {"key": "sourceTableName", "type": "str"},
        "target_table_name": {"key": "targetTableName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.source_table_name: Optional[str] = None
        self.target_table_name: Optional[str] = None


class MigrationValidationDatabaseSummaryResult(_serialization.Model):
    """Migration Validation Database level summary result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar migration_id: Migration Identifier.
    :vartype migration_id: str
    :ivar source_database_name: Name of the source database.
    :vartype source_database_name: str
    :ivar target_database_name: Name of the target database.
    :vartype target_database_name: str
    :ivar started_on: Validation start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Validation end time.
    :vartype ended_on: ~datetime.datetime
    :ivar status: Current status of validation at the database level. Known values are: "Default",
     "NotStarted", "Initialized", "InProgress", "Completed", "CompletedWithIssues", "Stopped", and
     "Failed".
    :vartype status: str or ~azure.mgmt.datamigration.models.ValidationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "migration_id": {"readonly": True},
        "source_database_name": {"readonly": True},
        "target_database_name": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "migration_id": {"key": "migrationId", "type": "str"},
        "source_database_name": {"key": "sourceDatabaseName", "type": "str"},
        "target_database_name": {"key": "targetDatabaseName", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.migration_id: Optional[str] = None
        self.source_database_name: Optional[str] = None
        self.target_database_name: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.status: Optional[Union[str, "_models.ValidationStatus"]] = None


class MigrationValidationOptions(_serialization.Model):
    """Types of validations to run after the migration.

    :ivar enable_schema_validation: Allows to compare the schema information between source and
     target.
    :vartype enable_schema_validation: bool
    :ivar enable_data_integrity_validation: Allows to perform a checksum based data integrity
     validation between source and target for the selected database / tables .
    :vartype enable_data_integrity_validation: bool
    :ivar enable_query_analysis_validation: Allows to perform a quick and intelligent query
     analysis by retrieving queries from the source database and executes them in the target. The
     result will have execution statistics for executions in source and target databases for the
     extracted queries.
    :vartype enable_query_analysis_validation: bool
    """

    _attribute_map = {
        "enable_schema_validation": {"key": "enableSchemaValidation", "type": "bool"},
        "enable_data_integrity_validation": {"key": "enableDataIntegrityValidation", "type": "bool"},
        "enable_query_analysis_validation": {"key": "enableQueryAnalysisValidation", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enable_schema_validation: Optional[bool] = None,
        enable_data_integrity_validation: Optional[bool] = None,
        enable_query_analysis_validation: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_schema_validation: Allows to compare the schema information between source and
         target.
        :paramtype enable_schema_validation: bool
        :keyword enable_data_integrity_validation: Allows to perform a checksum based data integrity
         validation between source and target for the selected database / tables .
        :paramtype enable_data_integrity_validation: bool
        :keyword enable_query_analysis_validation: Allows to perform a quick and intelligent query
         analysis by retrieving queries from the source database and executes them in the target. The
         result will have execution statistics for executions in source and target databases for the
         extracted queries.
        :paramtype enable_query_analysis_validation: bool
        """
        super().__init__(**kwargs)
        self.enable_schema_validation = enable_schema_validation
        self.enable_data_integrity_validation = enable_data_integrity_validation
        self.enable_query_analysis_validation = enable_query_analysis_validation


class MiSqlConnectionInfo(ConnectionInfo):
    """Properties required to create a connection to Azure SQL database Managed instance.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of connection info. Required.
    :vartype type: str
    :ivar user_name: User name.
    :vartype user_name: str
    :ivar password: Password credential.
    :vartype password: str
    :ivar managed_instance_resource_id: Resource id for Azure SQL database Managed instance.
     Required.
    :vartype managed_instance_resource_id: str
    """

    _validation = {
        "type": {"required": True},
        "managed_instance_resource_id": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "managed_instance_resource_id": {"key": "managedInstanceResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        managed_instance_resource_id: str,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_name: User name.
        :paramtype user_name: str
        :keyword password: Password credential.
        :paramtype password: str
        :keyword managed_instance_resource_id: Resource id for Azure SQL database Managed instance.
         Required.
        :paramtype managed_instance_resource_id: str
        """
        super().__init__(user_name=user_name, password=password, **kwargs)
        self.type: str = "MiSqlConnectionInfo"
        self.managed_instance_resource_id = managed_instance_resource_id


class MongoConnectionInformation(_serialization.Model):
    """Mongo Connection.

    :ivar host: Host of mongo connection.
    :vartype host: str
    :ivar port: Port of mongo connection.
    :vartype port: int
    :ivar user_name: User name to connect to Mongo.
    :vartype user_name: str
    :ivar password: Password to connect to Mongo.
    :vartype password: str
    :ivar use_ssl: Whether to UseSsl or UseTls to connect to Mongo. Default is true.
    :vartype use_ssl: bool
    :ivar connection_string: ConnectionString to connect to Mongo.
    :vartype connection_string: str
    """

    _attribute_map = {
        "host": {"key": "host", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "use_ssl": {"key": "useSsl", "type": "bool"},
        "connection_string": {"key": "connectionString", "type": "str"},
    }

    def __init__(
        self,
        *,
        host: Optional[str] = None,
        port: Optional[int] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        use_ssl: Optional[bool] = None,
        connection_string: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host: Host of mongo connection.
        :paramtype host: str
        :keyword port: Port of mongo connection.
        :paramtype port: int
        :keyword user_name: User name to connect to Mongo.
        :paramtype user_name: str
        :keyword password: Password to connect to Mongo.
        :paramtype password: str
        :keyword use_ssl: Whether to UseSsl or UseTls to connect to Mongo. Default is true.
        :paramtype use_ssl: bool
        :keyword connection_string: ConnectionString to connect to Mongo.
        :paramtype connection_string: str
        """
        super().__init__(**kwargs)
        self.host = host
        self.port = port
        self.user_name = user_name
        self.password = password
        self.use_ssl = use_ssl
        self.connection_string = connection_string


class MongoDbCancelCommand(CommandProperties):
    """Properties for the command that cancels a migration in whole or in part.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar command_type: Command type. Required. Known values are: "Migrate.Sync.Complete.Database",
     "Migrate.SqlServer.AzureDbSqlMi.Complete", "cancel", "finish", and "restart".
    :vartype command_type: str or ~azure.mgmt.datamigration.models.CommandType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the command. This is ignored if submitted. Known values are:
     "Unknown", "Accepted", "Running", "Succeeded", and "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.CommandState
    :ivar input: Command input.
    :vartype input: ~azure.mgmt.datamigration.models.MongoDbCommandInput
    """

    _validation = {
        "command_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "command_type": {"key": "commandType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "input": {"key": "input", "type": "MongoDbCommandInput"},
    }

    def __init__(self, *, input: Optional["_models.MongoDbCommandInput"] = None, **kwargs: Any) -> None:
        """
        :keyword input: Command input.
        :paramtype input: ~azure.mgmt.datamigration.models.MongoDbCommandInput
        """
        super().__init__(**kwargs)
        self.command_type: str = "cancel"
        self.input = input


class MongoDbClusterInfo(_serialization.Model):
    """Describes a MongoDB data source.

    All required parameters must be populated in order to send to server.

    :ivar databases: A list of non-system databases in the cluster. Required.
    :vartype databases: list[~azure.mgmt.datamigration.models.MongoDbDatabaseInfo]
    :ivar supports_sharding: Whether the cluster supports sharded collections. Required.
    :vartype supports_sharding: bool
    :ivar type: The type of data source. Required. Known values are: "BlobContainer", "CosmosDb",
     and "MongoDb".
    :vartype type: str or ~azure.mgmt.datamigration.models.MongoDbClusterType
    :ivar version: The version of the data source in the form x.y.z (e.g. 3.6.7). Not used if Type
     is BlobContainer. Required.
    :vartype version: str
    """

    _validation = {
        "databases": {"required": True},
        "supports_sharding": {"required": True},
        "type": {"required": True},
        "version": {"required": True},
    }

    _attribute_map = {
        "databases": {"key": "databases", "type": "[MongoDbDatabaseInfo]"},
        "supports_sharding": {"key": "supportsSharding", "type": "bool"},
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        databases: List["_models.MongoDbDatabaseInfo"],
        supports_sharding: bool,
        type: Union[str, "_models.MongoDbClusterType"],
        version: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword databases: A list of non-system databases in the cluster. Required.
        :paramtype databases: list[~azure.mgmt.datamigration.models.MongoDbDatabaseInfo]
        :keyword supports_sharding: Whether the cluster supports sharded collections. Required.
        :paramtype supports_sharding: bool
        :keyword type: The type of data source. Required. Known values are: "BlobContainer",
         "CosmosDb", and "MongoDb".
        :paramtype type: str or ~azure.mgmt.datamigration.models.MongoDbClusterType
        :keyword version: The version of the data source in the form x.y.z (e.g. 3.6.7). Not used if
         Type is BlobContainer. Required.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.databases = databases
        self.supports_sharding = supports_sharding
        self.type = type
        self.version = version


class MongoDbObjectInfo(_serialization.Model):
    """Describes a database or collection within a MongoDB data source.

    All required parameters must be populated in order to send to server.

    :ivar average_document_size: The average document size, or -1 if the average size is unknown.
     Required.
    :vartype average_document_size: int
    :ivar data_size: The estimated total data size, in bytes, or -1 if the size is unknown.
     Required.
    :vartype data_size: int
    :ivar document_count: The estimated total number of documents, or -1 if the document count is
     unknown. Required.
    :vartype document_count: int
    :ivar name: The unqualified name of the database or collection. Required.
    :vartype name: str
    :ivar qualified_name: The qualified name of the database or collection. For a collection, this
     is the database-qualified name. Required.
    :vartype qualified_name: str
    """

    _validation = {
        "average_document_size": {"required": True},
        "data_size": {"required": True},
        "document_count": {"required": True},
        "name": {"required": True},
        "qualified_name": {"required": True},
    }

    _attribute_map = {
        "average_document_size": {"key": "averageDocumentSize", "type": "int"},
        "data_size": {"key": "dataSize", "type": "int"},
        "document_count": {"key": "documentCount", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "qualified_name": {"key": "qualifiedName", "type": "str"},
    }

    def __init__(
        self,
        *,
        average_document_size: int,
        data_size: int,
        document_count: int,
        name: str,
        qualified_name: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword average_document_size: The average document size, or -1 if the average size is
         unknown. Required.
        :paramtype average_document_size: int
        :keyword data_size: The estimated total data size, in bytes, or -1 if the size is unknown.
         Required.
        :paramtype data_size: int
        :keyword document_count: The estimated total number of documents, or -1 if the document count
         is unknown. Required.
        :paramtype document_count: int
        :keyword name: The unqualified name of the database or collection. Required.
        :paramtype name: str
        :keyword qualified_name: The qualified name of the database or collection. For a collection,
         this is the database-qualified name. Required.
        :paramtype qualified_name: str
        """
        super().__init__(**kwargs)
        self.average_document_size = average_document_size
        self.data_size = data_size
        self.document_count = document_count
        self.name = name
        self.qualified_name = qualified_name


class MongoDbCollectionInfo(MongoDbObjectInfo):
    """Describes a supported collection within a MongoDB database.

    All required parameters must be populated in order to send to server.

    :ivar average_document_size: The average document size, or -1 if the average size is unknown.
     Required.
    :vartype average_document_size: int
    :ivar data_size: The estimated total data size, in bytes, or -1 if the size is unknown.
     Required.
    :vartype data_size: int
    :ivar document_count: The estimated total number of documents, or -1 if the document count is
     unknown. Required.
    :vartype document_count: int
    :ivar name: The unqualified name of the database or collection. Required.
    :vartype name: str
    :ivar qualified_name: The qualified name of the database or collection. For a collection, this
     is the database-qualified name. Required.
    :vartype qualified_name: str
    :ivar database_name: The name of the database containing the collection. Required.
    :vartype database_name: str
    :ivar is_capped: Whether the collection is a capped collection (i.e. whether it has a fixed
     size and acts like a circular buffer). Required.
    :vartype is_capped: bool
    :ivar is_system_collection: Whether the collection is system collection. Required.
    :vartype is_system_collection: bool
    :ivar is_view: Whether the collection is a view of another collection. Required.
    :vartype is_view: bool
    :ivar shard_key: The shard key on the collection, or null if the collection is not sharded.
    :vartype shard_key: ~azure.mgmt.datamigration.models.MongoDbShardKeyInfo
    :ivar supports_sharding: Whether the database has sharding enabled. Note that the migration
     task will enable sharding on the target if necessary. Required.
    :vartype supports_sharding: bool
    :ivar view_of: The name of the collection that this is a view of, if IsView is true.
    :vartype view_of: str
    """

    _validation = {
        "average_document_size": {"required": True},
        "data_size": {"required": True},
        "document_count": {"required": True},
        "name": {"required": True},
        "qualified_name": {"required": True},
        "database_name": {"required": True},
        "is_capped": {"required": True},
        "is_system_collection": {"required": True},
        "is_view": {"required": True},
        "supports_sharding": {"required": True},
    }

    _attribute_map = {
        "average_document_size": {"key": "averageDocumentSize", "type": "int"},
        "data_size": {"key": "dataSize", "type": "int"},
        "document_count": {"key": "documentCount", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "qualified_name": {"key": "qualifiedName", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "is_capped": {"key": "isCapped", "type": "bool"},
        "is_system_collection": {"key": "isSystemCollection", "type": "bool"},
        "is_view": {"key": "isView", "type": "bool"},
        "shard_key": {"key": "shardKey", "type": "MongoDbShardKeyInfo"},
        "supports_sharding": {"key": "supportsSharding", "type": "bool"},
        "view_of": {"key": "viewOf", "type": "str"},
    }

    def __init__(
        self,
        *,
        average_document_size: int,
        data_size: int,
        document_count: int,
        name: str,
        qualified_name: str,
        database_name: str,
        is_capped: bool,
        is_system_collection: bool,
        is_view: bool,
        supports_sharding: bool,
        shard_key: Optional["_models.MongoDbShardKeyInfo"] = None,
        view_of: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword average_document_size: The average document size, or -1 if the average size is
         unknown. Required.
        :paramtype average_document_size: int
        :keyword data_size: The estimated total data size, in bytes, or -1 if the size is unknown.
         Required.
        :paramtype data_size: int
        :keyword document_count: The estimated total number of documents, or -1 if the document count
         is unknown. Required.
        :paramtype document_count: int
        :keyword name: The unqualified name of the database or collection. Required.
        :paramtype name: str
        :keyword qualified_name: The qualified name of the database or collection. For a collection,
         this is the database-qualified name. Required.
        :paramtype qualified_name: str
        :keyword database_name: The name of the database containing the collection. Required.
        :paramtype database_name: str
        :keyword is_capped: Whether the collection is a capped collection (i.e. whether it has a fixed
         size and acts like a circular buffer). Required.
        :paramtype is_capped: bool
        :keyword is_system_collection: Whether the collection is system collection. Required.
        :paramtype is_system_collection: bool
        :keyword is_view: Whether the collection is a view of another collection. Required.
        :paramtype is_view: bool
        :keyword shard_key: The shard key on the collection, or null if the collection is not sharded.
        :paramtype shard_key: ~azure.mgmt.datamigration.models.MongoDbShardKeyInfo
        :keyword supports_sharding: Whether the database has sharding enabled. Note that the migration
         task will enable sharding on the target if necessary. Required.
        :paramtype supports_sharding: bool
        :keyword view_of: The name of the collection that this is a view of, if IsView is true.
        :paramtype view_of: str
        """
        super().__init__(
            average_document_size=average_document_size,
            data_size=data_size,
            document_count=document_count,
            name=name,
            qualified_name=qualified_name,
            **kwargs
        )
        self.database_name = database_name
        self.is_capped = is_capped
        self.is_system_collection = is_system_collection
        self.is_view = is_view
        self.shard_key = shard_key
        self.supports_sharding = supports_sharding
        self.view_of = view_of


class MongoDbProgress(_serialization.Model):
    """Base class for MongoDB migration outputs.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MongoDbCollectionProgress, MongoDbDatabaseProgress, MongoDbMigrationProgress

    All required parameters must be populated in order to send to server.

    :ivar bytes_copied: The number of document bytes copied during the Copying stage. Required.
    :vartype bytes_copied: int
    :ivar documents_copied: The number of documents copied during the Copying stage. Required.
    :vartype documents_copied: int
    :ivar elapsed_time: The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan
     format). Required.
    :vartype elapsed_time: str
    :ivar errors: The errors and warnings that have occurred for the current object. The keys are
     the error codes. Required.
    :vartype errors: dict[str, ~azure.mgmt.datamigration.models.MongoDbError]
    :ivar events_pending: The number of oplog events awaiting replay. Required.
    :vartype events_pending: int
    :ivar events_replayed: The number of oplog events replayed so far. Required.
    :vartype events_replayed: int
    :ivar last_event_time: The timestamp of the last oplog event received, or null if no oplog
     event has been received yet.
    :vartype last_event_time: ~datetime.datetime
    :ivar last_replay_time: The timestamp of the last oplog event replayed, or null if no oplog
     event has been replayed yet.
    :vartype last_replay_time: ~datetime.datetime
    :ivar name: The name of the progress object. For a collection, this is the unqualified
     collection name. For a database, this is the database name. For the overall migration, this is
     null.
    :vartype name: str
    :ivar qualified_name: The qualified name of the progress object. For a collection, this is the
     database-qualified name. For a database, this is the database name. For the overall migration,
     this is null.
    :vartype qualified_name: str
    :ivar result_type: The type of progress object. Required. Known values are: "Migration",
     "Database", and "Collection".
    :vartype result_type: str or ~azure.mgmt.datamigration.models.MongoDbProgressResultType
    :ivar state: Required. Known values are: "NotStarted", "ValidatingInput", "Initializing",
     "Restarting", "Copying", "InitialReplay", "Replaying", "Finalizing", "Complete", "Canceled",
     and "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.MongoDbMigrationState
    :ivar total_bytes: The total number of document bytes on the source at the beginning of the
     Copying stage, or -1 if the total size was unknown. Required.
    :vartype total_bytes: int
    :ivar total_documents: The total number of documents on the source at the beginning of the
     Copying stage, or -1 if the total count was unknown. Required.
    :vartype total_documents: int
    """

    _validation = {
        "bytes_copied": {"required": True},
        "documents_copied": {"required": True},
        "elapsed_time": {"required": True},
        "errors": {"required": True},
        "events_pending": {"required": True},
        "events_replayed": {"required": True},
        "result_type": {"required": True},
        "state": {"required": True},
        "total_bytes": {"required": True},
        "total_documents": {"required": True},
    }

    _attribute_map = {
        "bytes_copied": {"key": "bytesCopied", "type": "int"},
        "documents_copied": {"key": "documentsCopied", "type": "int"},
        "elapsed_time": {"key": "elapsedTime", "type": "str"},
        "errors": {"key": "errors", "type": "{MongoDbError}"},
        "events_pending": {"key": "eventsPending", "type": "int"},
        "events_replayed": {"key": "eventsReplayed", "type": "int"},
        "last_event_time": {"key": "lastEventTime", "type": "iso-8601"},
        "last_replay_time": {"key": "lastReplayTime", "type": "iso-8601"},
        "name": {"key": "name", "type": "str"},
        "qualified_name": {"key": "qualifiedName", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "total_bytes": {"key": "totalBytes", "type": "int"},
        "total_documents": {"key": "totalDocuments", "type": "int"},
    }

    _subtype_map = {
        "result_type": {
            "Collection": "MongoDbCollectionProgress",
            "Database": "MongoDbDatabaseProgress",
            "Migration": "MongoDbMigrationProgress",
        }
    }

    def __init__(
        self,
        *,
        bytes_copied: int,
        documents_copied: int,
        elapsed_time: str,
        errors: Dict[str, "_models.MongoDbError"],
        events_pending: int,
        events_replayed: int,
        state: Union[str, "_models.MongoDbMigrationState"],
        total_bytes: int,
        total_documents: int,
        last_event_time: Optional[datetime.datetime] = None,
        last_replay_time: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        qualified_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bytes_copied: The number of document bytes copied during the Copying stage. Required.
        :paramtype bytes_copied: int
        :keyword documents_copied: The number of documents copied during the Copying stage. Required.
        :paramtype documents_copied: int
        :keyword elapsed_time: The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan
         format). Required.
        :paramtype elapsed_time: str
        :keyword errors: The errors and warnings that have occurred for the current object. The keys
         are the error codes. Required.
        :paramtype errors: dict[str, ~azure.mgmt.datamigration.models.MongoDbError]
        :keyword events_pending: The number of oplog events awaiting replay. Required.
        :paramtype events_pending: int
        :keyword events_replayed: The number of oplog events replayed so far. Required.
        :paramtype events_replayed: int
        :keyword last_event_time: The timestamp of the last oplog event received, or null if no oplog
         event has been received yet.
        :paramtype last_event_time: ~datetime.datetime
        :keyword last_replay_time: The timestamp of the last oplog event replayed, or null if no oplog
         event has been replayed yet.
        :paramtype last_replay_time: ~datetime.datetime
        :keyword name: The name of the progress object. For a collection, this is the unqualified
         collection name. For a database, this is the database name. For the overall migration, this is
         null.
        :paramtype name: str
        :keyword qualified_name: The qualified name of the progress object. For a collection, this is
         the database-qualified name. For a database, this is the database name. For the overall
         migration, this is null.
        :paramtype qualified_name: str
        :keyword state: Required. Known values are: "NotStarted", "ValidatingInput", "Initializing",
         "Restarting", "Copying", "InitialReplay", "Replaying", "Finalizing", "Complete", "Canceled",
         and "Failed".
        :paramtype state: str or ~azure.mgmt.datamigration.models.MongoDbMigrationState
        :keyword total_bytes: The total number of document bytes on the source at the beginning of the
         Copying stage, or -1 if the total size was unknown. Required.
        :paramtype total_bytes: int
        :keyword total_documents: The total number of documents on the source at the beginning of the
         Copying stage, or -1 if the total count was unknown. Required.
        :paramtype total_documents: int
        """
        super().__init__(**kwargs)
        self.bytes_copied = bytes_copied
        self.documents_copied = documents_copied
        self.elapsed_time = elapsed_time
        self.errors = errors
        self.events_pending = events_pending
        self.events_replayed = events_replayed
        self.last_event_time = last_event_time
        self.last_replay_time = last_replay_time
        self.name = name
        self.qualified_name = qualified_name
        self.result_type: Optional[str] = None
        self.state = state
        self.total_bytes = total_bytes
        self.total_documents = total_documents


class MongoDbCollectionProgress(MongoDbProgress):
    """Describes the progress of a collection.

    All required parameters must be populated in order to send to server.

    :ivar bytes_copied: The number of document bytes copied during the Copying stage. Required.
    :vartype bytes_copied: int
    :ivar documents_copied: The number of documents copied during the Copying stage. Required.
    :vartype documents_copied: int
    :ivar elapsed_time: The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan
     format). Required.
    :vartype elapsed_time: str
    :ivar errors: The errors and warnings that have occurred for the current object. The keys are
     the error codes. Required.
    :vartype errors: dict[str, ~azure.mgmt.datamigration.models.MongoDbError]
    :ivar events_pending: The number of oplog events awaiting replay. Required.
    :vartype events_pending: int
    :ivar events_replayed: The number of oplog events replayed so far. Required.
    :vartype events_replayed: int
    :ivar last_event_time: The timestamp of the last oplog event received, or null if no oplog
     event has been received yet.
    :vartype last_event_time: ~datetime.datetime
    :ivar last_replay_time: The timestamp of the last oplog event replayed, or null if no oplog
     event has been replayed yet.
    :vartype last_replay_time: ~datetime.datetime
    :ivar name: The name of the progress object. For a collection, this is the unqualified
     collection name. For a database, this is the database name. For the overall migration, this is
     null.
    :vartype name: str
    :ivar qualified_name: The qualified name of the progress object. For a collection, this is the
     database-qualified name. For a database, this is the database name. For the overall migration,
     this is null.
    :vartype qualified_name: str
    :ivar result_type: The type of progress object. Required. Known values are: "Migration",
     "Database", and "Collection".
    :vartype result_type: str or ~azure.mgmt.datamigration.models.MongoDbProgressResultType
    :ivar state: Required. Known values are: "NotStarted", "ValidatingInput", "Initializing",
     "Restarting", "Copying", "InitialReplay", "Replaying", "Finalizing", "Complete", "Canceled",
     and "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.MongoDbMigrationState
    :ivar total_bytes: The total number of document bytes on the source at the beginning of the
     Copying stage, or -1 if the total size was unknown. Required.
    :vartype total_bytes: int
    :ivar total_documents: The total number of documents on the source at the beginning of the
     Copying stage, or -1 if the total count was unknown. Required.
    :vartype total_documents: int
    """

    _validation = {
        "bytes_copied": {"required": True},
        "documents_copied": {"required": True},
        "elapsed_time": {"required": True},
        "errors": {"required": True},
        "events_pending": {"required": True},
        "events_replayed": {"required": True},
        "result_type": {"required": True},
        "state": {"required": True},
        "total_bytes": {"required": True},
        "total_documents": {"required": True},
    }

    _attribute_map = {
        "bytes_copied": {"key": "bytesCopied", "type": "int"},
        "documents_copied": {"key": "documentsCopied", "type": "int"},
        "elapsed_time": {"key": "elapsedTime", "type": "str"},
        "errors": {"key": "errors", "type": "{MongoDbError}"},
        "events_pending": {"key": "eventsPending", "type": "int"},
        "events_replayed": {"key": "eventsReplayed", "type": "int"},
        "last_event_time": {"key": "lastEventTime", "type": "iso-8601"},
        "last_replay_time": {"key": "lastReplayTime", "type": "iso-8601"},
        "name": {"key": "name", "type": "str"},
        "qualified_name": {"key": "qualifiedName", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "total_bytes": {"key": "totalBytes", "type": "int"},
        "total_documents": {"key": "totalDocuments", "type": "int"},
    }

    def __init__(
        self,
        *,
        bytes_copied: int,
        documents_copied: int,
        elapsed_time: str,
        errors: Dict[str, "_models.MongoDbError"],
        events_pending: int,
        events_replayed: int,
        state: Union[str, "_models.MongoDbMigrationState"],
        total_bytes: int,
        total_documents: int,
        last_event_time: Optional[datetime.datetime] = None,
        last_replay_time: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        qualified_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bytes_copied: The number of document bytes copied during the Copying stage. Required.
        :paramtype bytes_copied: int
        :keyword documents_copied: The number of documents copied during the Copying stage. Required.
        :paramtype documents_copied: int
        :keyword elapsed_time: The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan
         format). Required.
        :paramtype elapsed_time: str
        :keyword errors: The errors and warnings that have occurred for the current object. The keys
         are the error codes. Required.
        :paramtype errors: dict[str, ~azure.mgmt.datamigration.models.MongoDbError]
        :keyword events_pending: The number of oplog events awaiting replay. Required.
        :paramtype events_pending: int
        :keyword events_replayed: The number of oplog events replayed so far. Required.
        :paramtype events_replayed: int
        :keyword last_event_time: The timestamp of the last oplog event received, or null if no oplog
         event has been received yet.
        :paramtype last_event_time: ~datetime.datetime
        :keyword last_replay_time: The timestamp of the last oplog event replayed, or null if no oplog
         event has been replayed yet.
        :paramtype last_replay_time: ~datetime.datetime
        :keyword name: The name of the progress object. For a collection, this is the unqualified
         collection name. For a database, this is the database name. For the overall migration, this is
         null.
        :paramtype name: str
        :keyword qualified_name: The qualified name of the progress object. For a collection, this is
         the database-qualified name. For a database, this is the database name. For the overall
         migration, this is null.
        :paramtype qualified_name: str
        :keyword state: Required. Known values are: "NotStarted", "ValidatingInput", "Initializing",
         "Restarting", "Copying", "InitialReplay", "Replaying", "Finalizing", "Complete", "Canceled",
         and "Failed".
        :paramtype state: str or ~azure.mgmt.datamigration.models.MongoDbMigrationState
        :keyword total_bytes: The total number of document bytes on the source at the beginning of the
         Copying stage, or -1 if the total size was unknown. Required.
        :paramtype total_bytes: int
        :keyword total_documents: The total number of documents on the source at the beginning of the
         Copying stage, or -1 if the total count was unknown. Required.
        :paramtype total_documents: int
        """
        super().__init__(
            bytes_copied=bytes_copied,
            documents_copied=documents_copied,
            elapsed_time=elapsed_time,
            errors=errors,
            events_pending=events_pending,
            events_replayed=events_replayed,
            last_event_time=last_event_time,
            last_replay_time=last_replay_time,
            name=name,
            qualified_name=qualified_name,
            state=state,
            total_bytes=total_bytes,
            total_documents=total_documents,
            **kwargs
        )
        self.result_type: str = "Collection"


class MongoDbCollectionSettings(_serialization.Model):
    """Describes how an individual MongoDB collection should be migrated.

    :ivar can_delete: Whether the migrator is allowed to drop the target collection in the course
     of performing a migration. The default is true.
    :vartype can_delete: bool
    :ivar shard_key: Describes a MongoDB shard key.
    :vartype shard_key: ~azure.mgmt.datamigration.models.MongoDbShardKeySetting
    :ivar target_r_us: The RUs that should be configured on a CosmosDB target, or null to use the
     default. This has no effect on non-CosmosDB targets.
    :vartype target_r_us: int
    """

    _attribute_map = {
        "can_delete": {"key": "canDelete", "type": "bool"},
        "shard_key": {"key": "shardKey", "type": "MongoDbShardKeySetting"},
        "target_r_us": {"key": "targetRUs", "type": "int"},
    }

    def __init__(
        self,
        *,
        can_delete: Optional[bool] = None,
        shard_key: Optional["_models.MongoDbShardKeySetting"] = None,
        target_r_us: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword can_delete: Whether the migrator is allowed to drop the target collection in the
         course of performing a migration. The default is true.
        :paramtype can_delete: bool
        :keyword shard_key: Describes a MongoDB shard key.
        :paramtype shard_key: ~azure.mgmt.datamigration.models.MongoDbShardKeySetting
        :keyword target_r_us: The RUs that should be configured on a CosmosDB target, or null to use
         the default. This has no effect on non-CosmosDB targets.
        :paramtype target_r_us: int
        """
        super().__init__(**kwargs)
        self.can_delete = can_delete
        self.shard_key = shard_key
        self.target_r_us = target_r_us


class MongoDbCommandInput(_serialization.Model):
    """Describes the input to the 'cancel' and 'restart' MongoDB migration commands.

    :ivar object_name: The qualified name of a database or collection to act upon, or null to act
     upon the entire migration.
    :vartype object_name: str
    """

    _attribute_map = {
        "object_name": {"key": "objectName", "type": "str"},
    }

    def __init__(self, *, object_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword object_name: The qualified name of a database or collection to act upon, or null to
         act upon the entire migration.
        :paramtype object_name: str
        """
        super().__init__(**kwargs)
        self.object_name = object_name


class MongoDbConnectionInfo(ConnectionInfo):
    """Describes a connection to a MongoDB data source.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of connection info. Required.
    :vartype type: str
    :ivar user_name: User name.
    :vartype user_name: str
    :ivar password: Password credential.
    :vartype password: str
    :ivar connection_string: A MongoDB connection string or blob container URL. The user name and
     password can be specified here or in the userName and password properties. Required.
    :vartype connection_string: str
    :ivar data_source: Data source.
    :vartype data_source: str
    :ivar encrypt_connection: Whether to encrypt the connection.
    :vartype encrypt_connection: bool
    :ivar server_brand_version: server brand version.
    :vartype server_brand_version: str
    :ivar server_version: server version.
    :vartype server_version: str
    :ivar server_name: name of the server.
    :vartype server_name: str
    :ivar trust_server_certificate: Whether to trust the server certificate.
    :vartype trust_server_certificate: bool
    :ivar enforce_ssl:
    :vartype enforce_ssl: bool
    :ivar port: port for server.
    :vartype port: int
    :ivar additional_settings: Additional connection settings.
    :vartype additional_settings: str
    :ivar authentication: Authentication type to use for connection. Known values are: "None",
     "WindowsAuthentication", "SqlAuthentication", "ActiveDirectoryIntegrated", and
     "ActiveDirectoryPassword".
    :vartype authentication: str or ~azure.mgmt.datamigration.models.AuthenticationType
    """

    _validation = {
        "type": {"required": True},
        "connection_string": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "connection_string": {"key": "connectionString", "type": "str"},
        "data_source": {"key": "dataSource", "type": "str"},
        "encrypt_connection": {"key": "encryptConnection", "type": "bool"},
        "server_brand_version": {"key": "serverBrandVersion", "type": "str"},
        "server_version": {"key": "serverVersion", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "trust_server_certificate": {"key": "trustServerCertificate", "type": "bool"},
        "enforce_ssl": {"key": "enforceSSL", "type": "bool"},
        "port": {"key": "port", "type": "int"},
        "additional_settings": {"key": "additionalSettings", "type": "str"},
        "authentication": {"key": "authentication", "type": "str"},
    }

    def __init__(
        self,
        *,
        connection_string: str,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        data_source: Optional[str] = None,
        encrypt_connection: Optional[bool] = None,
        server_brand_version: Optional[str] = None,
        server_version: Optional[str] = None,
        server_name: Optional[str] = None,
        trust_server_certificate: bool = False,
        enforce_ssl: Optional[bool] = None,
        port: Optional[int] = None,
        additional_settings: Optional[str] = None,
        authentication: Optional[Union[str, "_models.AuthenticationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_name: User name.
        :paramtype user_name: str
        :keyword password: Password credential.
        :paramtype password: str
        :keyword connection_string: A MongoDB connection string or blob container URL. The user name
         and password can be specified here or in the userName and password properties. Required.
        :paramtype connection_string: str
        :keyword data_source: Data source.
        :paramtype data_source: str
        :keyword encrypt_connection: Whether to encrypt the connection.
        :paramtype encrypt_connection: bool
        :keyword server_brand_version: server brand version.
        :paramtype server_brand_version: str
        :keyword server_version: server version.
        :paramtype server_version: str
        :keyword server_name: name of the server.
        :paramtype server_name: str
        :keyword trust_server_certificate: Whether to trust the server certificate.
        :paramtype trust_server_certificate: bool
        :keyword enforce_ssl:
        :paramtype enforce_ssl: bool
        :keyword port: port for server.
        :paramtype port: int
        :keyword additional_settings: Additional connection settings.
        :paramtype additional_settings: str
        :keyword authentication: Authentication type to use for connection. Known values are: "None",
         "WindowsAuthentication", "SqlAuthentication", "ActiveDirectoryIntegrated", and
         "ActiveDirectoryPassword".
        :paramtype authentication: str or ~azure.mgmt.datamigration.models.AuthenticationType
        """
        super().__init__(user_name=user_name, password=password, **kwargs)
        self.type: str = "MongoDbConnectionInfo"
        self.connection_string = connection_string
        self.data_source = data_source
        self.encrypt_connection = encrypt_connection
        self.server_brand_version = server_brand_version
        self.server_version = server_version
        self.server_name = server_name
        self.trust_server_certificate = trust_server_certificate
        self.enforce_ssl = enforce_ssl
        self.port = port
        self.additional_settings = additional_settings
        self.authentication = authentication


class MongoDbDatabaseInfo(MongoDbObjectInfo):
    """Describes a database within a MongoDB data source.

    All required parameters must be populated in order to send to server.

    :ivar average_document_size: The average document size, or -1 if the average size is unknown.
     Required.
    :vartype average_document_size: int
    :ivar data_size: The estimated total data size, in bytes, or -1 if the size is unknown.
     Required.
    :vartype data_size: int
    :ivar document_count: The estimated total number of documents, or -1 if the document count is
     unknown. Required.
    :vartype document_count: int
    :ivar name: The unqualified name of the database or collection. Required.
    :vartype name: str
    :ivar qualified_name: The qualified name of the database or collection. For a collection, this
     is the database-qualified name. Required.
    :vartype qualified_name: str
    :ivar collections: A list of supported collections in a MongoDB database. Required.
    :vartype collections: list[~azure.mgmt.datamigration.models.MongoDbCollectionInfo]
    :ivar supports_sharding: Whether the database has sharding enabled. Note that the migration
     task will enable sharding on the target if necessary. Required.
    :vartype supports_sharding: bool
    """

    _validation = {
        "average_document_size": {"required": True},
        "data_size": {"required": True},
        "document_count": {"required": True},
        "name": {"required": True},
        "qualified_name": {"required": True},
        "collections": {"required": True},
        "supports_sharding": {"required": True},
    }

    _attribute_map = {
        "average_document_size": {"key": "averageDocumentSize", "type": "int"},
        "data_size": {"key": "dataSize", "type": "int"},
        "document_count": {"key": "documentCount", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "qualified_name": {"key": "qualifiedName", "type": "str"},
        "collections": {"key": "collections", "type": "[MongoDbCollectionInfo]"},
        "supports_sharding": {"key": "supportsSharding", "type": "bool"},
    }

    def __init__(
        self,
        *,
        average_document_size: int,
        data_size: int,
        document_count: int,
        name: str,
        qualified_name: str,
        collections: List["_models.MongoDbCollectionInfo"],
        supports_sharding: bool,
        **kwargs: Any
    ) -> None:
        """
        :keyword average_document_size: The average document size, or -1 if the average size is
         unknown. Required.
        :paramtype average_document_size: int
        :keyword data_size: The estimated total data size, in bytes, or -1 if the size is unknown.
         Required.
        :paramtype data_size: int
        :keyword document_count: The estimated total number of documents, or -1 if the document count
         is unknown. Required.
        :paramtype document_count: int
        :keyword name: The unqualified name of the database or collection. Required.
        :paramtype name: str
        :keyword qualified_name: The qualified name of the database or collection. For a collection,
         this is the database-qualified name. Required.
        :paramtype qualified_name: str
        :keyword collections: A list of supported collections in a MongoDB database. Required.
        :paramtype collections: list[~azure.mgmt.datamigration.models.MongoDbCollectionInfo]
        :keyword supports_sharding: Whether the database has sharding enabled. Note that the migration
         task will enable sharding on the target if necessary. Required.
        :paramtype supports_sharding: bool
        """
        super().__init__(
            average_document_size=average_document_size,
            data_size=data_size,
            document_count=document_count,
            name=name,
            qualified_name=qualified_name,
            **kwargs
        )
        self.collections = collections
        self.supports_sharding = supports_sharding


class MongoDbDatabaseProgress(MongoDbProgress):
    """Describes the progress of a database.

    All required parameters must be populated in order to send to server.

    :ivar bytes_copied: The number of document bytes copied during the Copying stage. Required.
    :vartype bytes_copied: int
    :ivar documents_copied: The number of documents copied during the Copying stage. Required.
    :vartype documents_copied: int
    :ivar elapsed_time: The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan
     format). Required.
    :vartype elapsed_time: str
    :ivar errors: The errors and warnings that have occurred for the current object. The keys are
     the error codes. Required.
    :vartype errors: dict[str, ~azure.mgmt.datamigration.models.MongoDbError]
    :ivar events_pending: The number of oplog events awaiting replay. Required.
    :vartype events_pending: int
    :ivar events_replayed: The number of oplog events replayed so far. Required.
    :vartype events_replayed: int
    :ivar last_event_time: The timestamp of the last oplog event received, or null if no oplog
     event has been received yet.
    :vartype last_event_time: ~datetime.datetime
    :ivar last_replay_time: The timestamp of the last oplog event replayed, or null if no oplog
     event has been replayed yet.
    :vartype last_replay_time: ~datetime.datetime
    :ivar name: The name of the progress object. For a collection, this is the unqualified
     collection name. For a database, this is the database name. For the overall migration, this is
     null.
    :vartype name: str
    :ivar qualified_name: The qualified name of the progress object. For a collection, this is the
     database-qualified name. For a database, this is the database name. For the overall migration,
     this is null.
    :vartype qualified_name: str
    :ivar result_type: The type of progress object. Required. Known values are: "Migration",
     "Database", and "Collection".
    :vartype result_type: str or ~azure.mgmt.datamigration.models.MongoDbProgressResultType
    :ivar state: Required. Known values are: "NotStarted", "ValidatingInput", "Initializing",
     "Restarting", "Copying", "InitialReplay", "Replaying", "Finalizing", "Complete", "Canceled",
     and "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.MongoDbMigrationState
    :ivar total_bytes: The total number of document bytes on the source at the beginning of the
     Copying stage, or -1 if the total size was unknown. Required.
    :vartype total_bytes: int
    :ivar total_documents: The total number of documents on the source at the beginning of the
     Copying stage, or -1 if the total count was unknown. Required.
    :vartype total_documents: int
    :ivar collections: The progress of the collections in the database. The keys are the
     unqualified names of the collections.
    :vartype collections: dict[str, ~azure.mgmt.datamigration.models.MongoDbCollectionProgress]
    """

    _validation = {
        "bytes_copied": {"required": True},
        "documents_copied": {"required": True},
        "elapsed_time": {"required": True},
        "errors": {"required": True},
        "events_pending": {"required": True},
        "events_replayed": {"required": True},
        "result_type": {"required": True},
        "state": {"required": True},
        "total_bytes": {"required": True},
        "total_documents": {"required": True},
    }

    _attribute_map = {
        "bytes_copied": {"key": "bytesCopied", "type": "int"},
        "documents_copied": {"key": "documentsCopied", "type": "int"},
        "elapsed_time": {"key": "elapsedTime", "type": "str"},
        "errors": {"key": "errors", "type": "{MongoDbError}"},
        "events_pending": {"key": "eventsPending", "type": "int"},
        "events_replayed": {"key": "eventsReplayed", "type": "int"},
        "last_event_time": {"key": "lastEventTime", "type": "iso-8601"},
        "last_replay_time": {"key": "lastReplayTime", "type": "iso-8601"},
        "name": {"key": "name", "type": "str"},
        "qualified_name": {"key": "qualifiedName", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "total_bytes": {"key": "totalBytes", "type": "int"},
        "total_documents": {"key": "totalDocuments", "type": "int"},
        "collections": {"key": "collections", "type": "{MongoDbCollectionProgress}"},
    }

    def __init__(
        self,
        *,
        bytes_copied: int,
        documents_copied: int,
        elapsed_time: str,
        errors: Dict[str, "_models.MongoDbError"],
        events_pending: int,
        events_replayed: int,
        state: Union[str, "_models.MongoDbMigrationState"],
        total_bytes: int,
        total_documents: int,
        last_event_time: Optional[datetime.datetime] = None,
        last_replay_time: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        qualified_name: Optional[str] = None,
        collections: Optional[Dict[str, "_models.MongoDbCollectionProgress"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bytes_copied: The number of document bytes copied during the Copying stage. Required.
        :paramtype bytes_copied: int
        :keyword documents_copied: The number of documents copied during the Copying stage. Required.
        :paramtype documents_copied: int
        :keyword elapsed_time: The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan
         format). Required.
        :paramtype elapsed_time: str
        :keyword errors: The errors and warnings that have occurred for the current object. The keys
         are the error codes. Required.
        :paramtype errors: dict[str, ~azure.mgmt.datamigration.models.MongoDbError]
        :keyword events_pending: The number of oplog events awaiting replay. Required.
        :paramtype events_pending: int
        :keyword events_replayed: The number of oplog events replayed so far. Required.
        :paramtype events_replayed: int
        :keyword last_event_time: The timestamp of the last oplog event received, or null if no oplog
         event has been received yet.
        :paramtype last_event_time: ~datetime.datetime
        :keyword last_replay_time: The timestamp of the last oplog event replayed, or null if no oplog
         event has been replayed yet.
        :paramtype last_replay_time: ~datetime.datetime
        :keyword name: The name of the progress object. For a collection, this is the unqualified
         collection name. For a database, this is the database name. For the overall migration, this is
         null.
        :paramtype name: str
        :keyword qualified_name: The qualified name of the progress object. For a collection, this is
         the database-qualified name. For a database, this is the database name. For the overall
         migration, this is null.
        :paramtype qualified_name: str
        :keyword state: Required. Known values are: "NotStarted", "ValidatingInput", "Initializing",
         "Restarting", "Copying", "InitialReplay", "Replaying", "Finalizing", "Complete", "Canceled",
         and "Failed".
        :paramtype state: str or ~azure.mgmt.datamigration.models.MongoDbMigrationState
        :keyword total_bytes: The total number of document bytes on the source at the beginning of the
         Copying stage, or -1 if the total size was unknown. Required.
        :paramtype total_bytes: int
        :keyword total_documents: The total number of documents on the source at the beginning of the
         Copying stage, or -1 if the total count was unknown. Required.
        :paramtype total_documents: int
        :keyword collections: The progress of the collections in the database. The keys are the
         unqualified names of the collections.
        :paramtype collections: dict[str, ~azure.mgmt.datamigration.models.MongoDbCollectionProgress]
        """
        super().__init__(
            bytes_copied=bytes_copied,
            documents_copied=documents_copied,
            elapsed_time=elapsed_time,
            errors=errors,
            events_pending=events_pending,
            events_replayed=events_replayed,
            last_event_time=last_event_time,
            last_replay_time=last_replay_time,
            name=name,
            qualified_name=qualified_name,
            state=state,
            total_bytes=total_bytes,
            total_documents=total_documents,
            **kwargs
        )
        self.result_type: str = "Database"
        self.collections = collections


class MongoDbDatabaseSettings(_serialization.Model):
    """Describes how an individual MongoDB database should be migrated.

    All required parameters must be populated in order to send to server.

    :ivar collections: The collections on the source database to migrate to the target. The keys
     are the unqualified names of the collections. Required.
    :vartype collections: dict[str, ~azure.mgmt.datamigration.models.MongoDbCollectionSettings]
    :ivar target_r_us: The RUs that should be configured on a CosmosDB target, or null to use the
     default, or 0 if throughput should not be provisioned for the database. This has no effect on
     non-CosmosDB targets.
    :vartype target_r_us: int
    """

    _validation = {
        "collections": {"required": True},
    }

    _attribute_map = {
        "collections": {"key": "collections", "type": "{MongoDbCollectionSettings}"},
        "target_r_us": {"key": "targetRUs", "type": "int"},
    }

    def __init__(
        self,
        *,
        collections: Dict[str, "_models.MongoDbCollectionSettings"],
        target_r_us: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword collections: The collections on the source database to migrate to the target. The keys
         are the unqualified names of the collections. Required.
        :paramtype collections: dict[str, ~azure.mgmt.datamigration.models.MongoDbCollectionSettings]
        :keyword target_r_us: The RUs that should be configured on a CosmosDB target, or null to use
         the default, or 0 if throughput should not be provisioned for the database. This has no effect
         on non-CosmosDB targets.
        :paramtype target_r_us: int
        """
        super().__init__(**kwargs)
        self.collections = collections
        self.target_r_us = target_r_us


class MongoDbError(_serialization.Model):
    """Describes an error or warning that occurred during a MongoDB migration.

    :ivar code: The non-localized, machine-readable code that describes the error or warning.
    :vartype code: str
    :ivar count: The number of times the error or warning has occurred.
    :vartype count: int
    :ivar message: The localized, human-readable message that describes the error or warning.
    :vartype message: str
    :ivar type: The type of error or warning. Known values are: "Error", "ValidationError", and
     "Warning".
    :vartype type: str or ~azure.mgmt.datamigration.models.MongoDbErrorType
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "message": {"key": "message", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        count: Optional[int] = None,
        message: Optional[str] = None,
        type: Optional[Union[str, "_models.MongoDbErrorType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: The non-localized, machine-readable code that describes the error or warning.
        :paramtype code: str
        :keyword count: The number of times the error or warning has occurred.
        :paramtype count: int
        :keyword message: The localized, human-readable message that describes the error or warning.
        :paramtype message: str
        :keyword type: The type of error or warning. Known values are: "Error", "ValidationError", and
         "Warning".
        :paramtype type: str or ~azure.mgmt.datamigration.models.MongoDbErrorType
        """
        super().__init__(**kwargs)
        self.code = code
        self.count = count
        self.message = message
        self.type = type


class MongoDbFinishCommand(CommandProperties):
    """Properties for the command that finishes a migration in whole or in part.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar command_type: Command type. Required. Known values are: "Migrate.Sync.Complete.Database",
     "Migrate.SqlServer.AzureDbSqlMi.Complete", "cancel", "finish", and "restart".
    :vartype command_type: str or ~azure.mgmt.datamigration.models.CommandType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the command. This is ignored if submitted. Known values are:
     "Unknown", "Accepted", "Running", "Succeeded", and "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.CommandState
    :ivar input: Command input.
    :vartype input: ~azure.mgmt.datamigration.models.MongoDbFinishCommandInput
    """

    _validation = {
        "command_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "command_type": {"key": "commandType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "input": {"key": "input", "type": "MongoDbFinishCommandInput"},
    }

    def __init__(self, *, input: Optional["_models.MongoDbFinishCommandInput"] = None, **kwargs: Any) -> None:
        """
        :keyword input: Command input.
        :paramtype input: ~azure.mgmt.datamigration.models.MongoDbFinishCommandInput
        """
        super().__init__(**kwargs)
        self.command_type: str = "finish"
        self.input = input


class MongoDbFinishCommandInput(MongoDbCommandInput):
    """Describes the input to the 'finish' MongoDB migration command.

    All required parameters must be populated in order to send to server.

    :ivar object_name: The qualified name of a database or collection to act upon, or null to act
     upon the entire migration.
    :vartype object_name: str
    :ivar immediate: If true, replication for the affected objects will be stopped immediately. If
     false, the migrator will finish replaying queued events before finishing the replication.
     Required.
    :vartype immediate: bool
    """

    _validation = {
        "immediate": {"required": True},
    }

    _attribute_map = {
        "object_name": {"key": "objectName", "type": "str"},
        "immediate": {"key": "immediate", "type": "bool"},
    }

    def __init__(self, *, immediate: bool, object_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword object_name: The qualified name of a database or collection to act upon, or null to
         act upon the entire migration.
        :paramtype object_name: str
        :keyword immediate: If true, replication for the affected objects will be stopped immediately.
         If false, the migrator will finish replaying queued events before finishing the replication.
         Required.
        :paramtype immediate: bool
        """
        super().__init__(object_name=object_name, **kwargs)
        self.immediate = immediate


class MongoDbMigrationProgress(MongoDbProgress):
    """Describes the progress of the overall migration.

    All required parameters must be populated in order to send to server.

    :ivar bytes_copied: The number of document bytes copied during the Copying stage. Required.
    :vartype bytes_copied: int
    :ivar documents_copied: The number of documents copied during the Copying stage. Required.
    :vartype documents_copied: int
    :ivar elapsed_time: The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan
     format). Required.
    :vartype elapsed_time: str
    :ivar errors: The errors and warnings that have occurred for the current object. The keys are
     the error codes. Required.
    :vartype errors: dict[str, ~azure.mgmt.datamigration.models.MongoDbError]
    :ivar events_pending: The number of oplog events awaiting replay. Required.
    :vartype events_pending: int
    :ivar events_replayed: The number of oplog events replayed so far. Required.
    :vartype events_replayed: int
    :ivar last_event_time: The timestamp of the last oplog event received, or null if no oplog
     event has been received yet.
    :vartype last_event_time: ~datetime.datetime
    :ivar last_replay_time: The timestamp of the last oplog event replayed, or null if no oplog
     event has been replayed yet.
    :vartype last_replay_time: ~datetime.datetime
    :ivar name: The name of the progress object. For a collection, this is the unqualified
     collection name. For a database, this is the database name. For the overall migration, this is
     null.
    :vartype name: str
    :ivar qualified_name: The qualified name of the progress object. For a collection, this is the
     database-qualified name. For a database, this is the database name. For the overall migration,
     this is null.
    :vartype qualified_name: str
    :ivar result_type: The type of progress object. Required. Known values are: "Migration",
     "Database", and "Collection".
    :vartype result_type: str or ~azure.mgmt.datamigration.models.MongoDbProgressResultType
    :ivar state: Required. Known values are: "NotStarted", "ValidatingInput", "Initializing",
     "Restarting", "Copying", "InitialReplay", "Replaying", "Finalizing", "Complete", "Canceled",
     and "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.MongoDbMigrationState
    :ivar total_bytes: The total number of document bytes on the source at the beginning of the
     Copying stage, or -1 if the total size was unknown. Required.
    :vartype total_bytes: int
    :ivar total_documents: The total number of documents on the source at the beginning of the
     Copying stage, or -1 if the total count was unknown. Required.
    :vartype total_documents: int
    :ivar databases: The progress of the databases in the migration. The keys are the names of the
     databases.
    :vartype databases: dict[str, ~azure.mgmt.datamigration.models.MongoDbDatabaseProgress]
    """

    _validation = {
        "bytes_copied": {"required": True},
        "documents_copied": {"required": True},
        "elapsed_time": {"required": True},
        "errors": {"required": True},
        "events_pending": {"required": True},
        "events_replayed": {"required": True},
        "result_type": {"required": True},
        "state": {"required": True},
        "total_bytes": {"required": True},
        "total_documents": {"required": True},
    }

    _attribute_map = {
        "bytes_copied": {"key": "bytesCopied", "type": "int"},
        "documents_copied": {"key": "documentsCopied", "type": "int"},
        "elapsed_time": {"key": "elapsedTime", "type": "str"},
        "errors": {"key": "errors", "type": "{MongoDbError}"},
        "events_pending": {"key": "eventsPending", "type": "int"},
        "events_replayed": {"key": "eventsReplayed", "type": "int"},
        "last_event_time": {"key": "lastEventTime", "type": "iso-8601"},
        "last_replay_time": {"key": "lastReplayTime", "type": "iso-8601"},
        "name": {"key": "name", "type": "str"},
        "qualified_name": {"key": "qualifiedName", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "total_bytes": {"key": "totalBytes", "type": "int"},
        "total_documents": {"key": "totalDocuments", "type": "int"},
        "databases": {"key": "databases", "type": "{MongoDbDatabaseProgress}"},
    }

    def __init__(
        self,
        *,
        bytes_copied: int,
        documents_copied: int,
        elapsed_time: str,
        errors: Dict[str, "_models.MongoDbError"],
        events_pending: int,
        events_replayed: int,
        state: Union[str, "_models.MongoDbMigrationState"],
        total_bytes: int,
        total_documents: int,
        last_event_time: Optional[datetime.datetime] = None,
        last_replay_time: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        qualified_name: Optional[str] = None,
        databases: Optional[Dict[str, "_models.MongoDbDatabaseProgress"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bytes_copied: The number of document bytes copied during the Copying stage. Required.
        :paramtype bytes_copied: int
        :keyword documents_copied: The number of documents copied during the Copying stage. Required.
        :paramtype documents_copied: int
        :keyword elapsed_time: The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan
         format). Required.
        :paramtype elapsed_time: str
        :keyword errors: The errors and warnings that have occurred for the current object. The keys
         are the error codes. Required.
        :paramtype errors: dict[str, ~azure.mgmt.datamigration.models.MongoDbError]
        :keyword events_pending: The number of oplog events awaiting replay. Required.
        :paramtype events_pending: int
        :keyword events_replayed: The number of oplog events replayed so far. Required.
        :paramtype events_replayed: int
        :keyword last_event_time: The timestamp of the last oplog event received, or null if no oplog
         event has been received yet.
        :paramtype last_event_time: ~datetime.datetime
        :keyword last_replay_time: The timestamp of the last oplog event replayed, or null if no oplog
         event has been replayed yet.
        :paramtype last_replay_time: ~datetime.datetime
        :keyword name: The name of the progress object. For a collection, this is the unqualified
         collection name. For a database, this is the database name. For the overall migration, this is
         null.
        :paramtype name: str
        :keyword qualified_name: The qualified name of the progress object. For a collection, this is
         the database-qualified name. For a database, this is the database name. For the overall
         migration, this is null.
        :paramtype qualified_name: str
        :keyword state: Required. Known values are: "NotStarted", "ValidatingInput", "Initializing",
         "Restarting", "Copying", "InitialReplay", "Replaying", "Finalizing", "Complete", "Canceled",
         and "Failed".
        :paramtype state: str or ~azure.mgmt.datamigration.models.MongoDbMigrationState
        :keyword total_bytes: The total number of document bytes on the source at the beginning of the
         Copying stage, or -1 if the total size was unknown. Required.
        :paramtype total_bytes: int
        :keyword total_documents: The total number of documents on the source at the beginning of the
         Copying stage, or -1 if the total count was unknown. Required.
        :paramtype total_documents: int
        :keyword databases: The progress of the databases in the migration. The keys are the names of
         the databases.
        :paramtype databases: dict[str, ~azure.mgmt.datamigration.models.MongoDbDatabaseProgress]
        """
        super().__init__(
            bytes_copied=bytes_copied,
            documents_copied=documents_copied,
            elapsed_time=elapsed_time,
            errors=errors,
            events_pending=events_pending,
            events_replayed=events_replayed,
            last_event_time=last_event_time,
            last_replay_time=last_replay_time,
            name=name,
            qualified_name=qualified_name,
            state=state,
            total_bytes=total_bytes,
            total_documents=total_documents,
            **kwargs
        )
        self.result_type: str = "Migration"
        self.databases = databases


class MongoDbMigrationSettings(_serialization.Model):
    """Describes how a MongoDB data migration should be performed.

    All required parameters must be populated in order to send to server.

    :ivar boost_r_us: The RU limit on a CosmosDB target that collections will be temporarily
     increased to (if lower) during the initial copy of a migration, from 10,000 to 1,000,000, or 0
     to use the default boost (which is generally the maximum), or null to not boost the RUs. This
     setting has no effect on non-CosmosDB targets.
    :vartype boost_r_us: int
    :ivar databases: The databases on the source cluster to migrate to the target. The keys are the
     names of the databases. Required.
    :vartype databases: dict[str, ~azure.mgmt.datamigration.models.MongoDbDatabaseSettings]
    :ivar replication: Describes how changes will be replicated from the source to the target. The
     default is OneTime. Known values are: "Disabled", "OneTime", and "Continuous".
    :vartype replication: str or ~azure.mgmt.datamigration.models.MongoDbReplication
    :ivar source: Settings used to connect to the source cluster. Required.
    :vartype source: ~azure.mgmt.datamigration.models.MongoDbConnectionInfo
    :ivar target: Settings used to connect to the target cluster. Required.
    :vartype target: ~azure.mgmt.datamigration.models.MongoDbConnectionInfo
    :ivar throttling: Settings used to limit the resource usage of the migration.
    :vartype throttling: ~azure.mgmt.datamigration.models.MongoDbThrottlingSettings
    """

    _validation = {
        "databases": {"required": True},
        "source": {"required": True},
        "target": {"required": True},
    }

    _attribute_map = {
        "boost_r_us": {"key": "boostRUs", "type": "int"},
        "databases": {"key": "databases", "type": "{MongoDbDatabaseSettings}"},
        "replication": {"key": "replication", "type": "str"},
        "source": {"key": "source", "type": "MongoDbConnectionInfo"},
        "target": {"key": "target", "type": "MongoDbConnectionInfo"},
        "throttling": {"key": "throttling", "type": "MongoDbThrottlingSettings"},
    }

    def __init__(
        self,
        *,
        databases: Dict[str, "_models.MongoDbDatabaseSettings"],
        source: "_models.MongoDbConnectionInfo",
        target: "_models.MongoDbConnectionInfo",
        boost_r_us: Optional[int] = None,
        replication: Optional[Union[str, "_models.MongoDbReplication"]] = None,
        throttling: Optional["_models.MongoDbThrottlingSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword boost_r_us: The RU limit on a CosmosDB target that collections will be temporarily
         increased to (if lower) during the initial copy of a migration, from 10,000 to 1,000,000, or 0
         to use the default boost (which is generally the maximum), or null to not boost the RUs. This
         setting has no effect on non-CosmosDB targets.
        :paramtype boost_r_us: int
        :keyword databases: The databases on the source cluster to migrate to the target. The keys are
         the names of the databases. Required.
        :paramtype databases: dict[str, ~azure.mgmt.datamigration.models.MongoDbDatabaseSettings]
        :keyword replication: Describes how changes will be replicated from the source to the target.
         The default is OneTime. Known values are: "Disabled", "OneTime", and "Continuous".
        :paramtype replication: str or ~azure.mgmt.datamigration.models.MongoDbReplication
        :keyword source: Settings used to connect to the source cluster. Required.
        :paramtype source: ~azure.mgmt.datamigration.models.MongoDbConnectionInfo
        :keyword target: Settings used to connect to the target cluster. Required.
        :paramtype target: ~azure.mgmt.datamigration.models.MongoDbConnectionInfo
        :keyword throttling: Settings used to limit the resource usage of the migration.
        :paramtype throttling: ~azure.mgmt.datamigration.models.MongoDbThrottlingSettings
        """
        super().__init__(**kwargs)
        self.boost_r_us = boost_r_us
        self.databases = databases
        self.replication = replication
        self.source = source
        self.target = target
        self.throttling = throttling


class MongoDbRestartCommand(CommandProperties):
    """Properties for the command that restarts a migration in whole or in part.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar command_type: Command type. Required. Known values are: "Migrate.Sync.Complete.Database",
     "Migrate.SqlServer.AzureDbSqlMi.Complete", "cancel", "finish", and "restart".
    :vartype command_type: str or ~azure.mgmt.datamigration.models.CommandType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the command. This is ignored if submitted. Known values are:
     "Unknown", "Accepted", "Running", "Succeeded", and "Failed".
    :vartype state: str or ~azure.mgmt.datamigration.models.CommandState
    :ivar input: Command input.
    :vartype input: ~azure.mgmt.datamigration.models.MongoDbCommandInput
    """

    _validation = {
        "command_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "command_type": {"key": "commandType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "input": {"key": "input", "type": "MongoDbCommandInput"},
    }

    def __init__(self, *, input: Optional["_models.MongoDbCommandInput"] = None, **kwargs: Any) -> None:
        """
        :keyword input: Command input.
        :paramtype input: ~azure.mgmt.datamigration.models.MongoDbCommandInput
        """
        super().__init__(**kwargs)
        self.command_type: str = "restart"
        self.input = input


class MongoDbShardKeyField(_serialization.Model):
    """Describes a field reference within a MongoDB shard key.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the field. Required.
    :vartype name: str
    :ivar order: The field ordering. Required. Known values are: "Forward", "Reverse", and
     "Hashed".
    :vartype order: str or ~azure.mgmt.datamigration.models.MongoDbShardKeyOrder
    """

    _validation = {
        "name": {"required": True},
        "order": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "order": {"key": "order", "type": "str"},
    }

    def __init__(self, *, name: str, order: Union[str, "_models.MongoDbShardKeyOrder"], **kwargs: Any) -> None:
        """
        :keyword name: The name of the field. Required.
        :paramtype name: str
        :keyword order: The field ordering. Required. Known values are: "Forward", "Reverse", and
         "Hashed".
        :paramtype order: str or ~azure.mgmt.datamigration.models.MongoDbShardKeyOrder
        """
        super().__init__(**kwargs)
        self.name = name
        self.order = order


class MongoDbShardKeyInfo(_serialization.Model):
    """Describes a MongoDB shard key.

    All required parameters must be populated in order to send to server.

    :ivar fields: The fields within the shard key. Required.
    :vartype fields: list[~azure.mgmt.datamigration.models.MongoDbShardKeyField]
    :ivar is_unique: Whether the shard key is unique. Required.
    :vartype is_unique: bool
    """

    _validation = {
        "fields": {"required": True},
        "is_unique": {"required": True},
    }

    _attribute_map = {
        "fields": {"key": "fields", "type": "[MongoDbShardKeyField]"},
        "is_unique": {"key": "isUnique", "type": "bool"},
    }

    def __init__(self, *, fields: List["_models.MongoDbShardKeyField"], is_unique: bool, **kwargs: Any) -> None:
        """
        :keyword fields: The fields within the shard key. Required.
        :paramtype fields: list[~azure.mgmt.datamigration.models.MongoDbShardKeyField]
        :keyword is_unique: Whether the shard key is unique. Required.
        :paramtype is_unique: bool
        """
        super().__init__(**kwargs)
        self.fields = fields
        self.is_unique = is_unique


class MongoDbShardKeySetting(_serialization.Model):
    """Describes a MongoDB shard key.

    All required parameters must be populated in order to send to server.

    :ivar fields: The fields within the shard key. Required.
    :vartype fields: list[~azure.mgmt.datamigration.models.MongoDbShardKeyField]
    :ivar is_unique: Whether the shard key is unique.
    :vartype is_unique: bool
    """

    _validation = {
        "fields": {"required": True},
    }

    _attribute_map = {
        "fields": {"key": "fields", "type": "[MongoDbShardKeyField]"},
        "is_unique": {"key": "isUnique", "type": "bool"},
    }

    def __init__(
        self, *, fields: List["_models.MongoDbShardKeyField"], is_unique: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword fields: The fields within the shard key. Required.
        :paramtype fields: list[~azure.mgmt.datamigration.models.MongoDbShardKeyField]
        :keyword is_unique: Whether the shard key is unique.
        :paramtype is_unique: bool
        """
        super().__init__(**kwargs)
        self.fields = fields
        self.is_unique = is_unique


class MongoDbThrottlingSettings(_serialization.Model):
    """Specifies resource limits for the migration.

    :ivar min_free_cpu: The percentage of CPU time that the migrator will try to avoid using, from
     0 to 100.
    :vartype min_free_cpu: int
    :ivar min_free_memory_mb: The number of megabytes of RAM that the migrator will try to avoid
     using.
    :vartype min_free_memory_mb: int
    :ivar max_parallelism: The maximum number of work items (e.g. collection copies) that will be
     processed in parallel.
    :vartype max_parallelism: int
    """

    _attribute_map = {
        "min_free_cpu": {"key": "minFreeCpu", "type": "int"},
        "min_free_memory_mb": {"key": "minFreeMemoryMb", "type": "int"},
        "max_parallelism": {"key": "maxParallelism", "type": "int"},
    }

    def __init__(
        self,
        *,
        min_free_cpu: Optional[int] = None,
        min_free_memory_mb: Optional[int] = None,
        max_parallelism: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword min_free_cpu: The percentage of CPU time that the migrator will try to avoid using,
         from 0 to 100.
        :paramtype min_free_cpu: int
        :keyword min_free_memory_mb: The number of megabytes of RAM that the migrator will try to avoid
         using.
        :paramtype min_free_memory_mb: int
        :keyword max_parallelism: The maximum number of work items (e.g. collection copies) that will
         be processed in parallel.
        :paramtype max_parallelism: int
        """
        super().__init__(**kwargs)
        self.min_free_cpu = min_free_cpu
        self.min_free_memory_mb = min_free_memory_mb
        self.max_parallelism = max_parallelism


class MongoMigrationCollection(_serialization.Model):
    """Mongo source and target database and collection details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source_database: Source database name.
    :vartype source_database: str
    :ivar source_collection: Source collection name.
    :vartype source_collection: str
    :ivar target_database: Target database name.
    :vartype target_database: str
    :ivar target_collection: Target collection name.
    :vartype target_collection: str
    :ivar migration_progress_details: Detailed migration status. Not included by default.
    :vartype migration_progress_details:
     ~azure.mgmt.datamigration.models.MongoMigrationProgressDetails
    """

    _validation = {
        "migration_progress_details": {"readonly": True},
    }

    _attribute_map = {
        "source_database": {"key": "sourceDatabase", "type": "str"},
        "source_collection": {"key": "sourceCollection", "type": "str"},
        "target_database": {"key": "targetDatabase", "type": "str"},
        "target_collection": {"key": "targetCollection", "type": "str"},
        "migration_progress_details": {"key": "migrationProgressDetails", "type": "MongoMigrationProgressDetails"},
    }

    def __init__(
        self,
        *,
        source_database: Optional[str] = None,
        source_collection: Optional[str] = None,
        target_database: Optional[str] = None,
        target_collection: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_database: Source database name.
        :paramtype source_database: str
        :keyword source_collection: Source collection name.
        :paramtype source_collection: str
        :keyword target_database: Target database name.
        :paramtype target_database: str
        :keyword target_collection: Target collection name.
        :paramtype target_collection: str
        """
        super().__init__(**kwargs)
        self.source_database = source_database
        self.source_collection = source_collection
        self.target_database = target_database
        self.target_collection = target_collection
        self.migration_progress_details: Optional["_models.MongoMigrationProgressDetails"] = None


class MongoMigrationProgressDetails(_serialization.Model):
    """Detailed status of collection migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar migration_status: Migration Status. Known values are: "NotStarted", "InProgress",
     "Completed", "Failed", and "Canceled".
    :vartype migration_status: str or ~azure.mgmt.datamigration.models.MongoMigrationStatus
    :ivar migration_error: Migration Error.
    :vartype migration_error: str
    :ivar source_document_count: Source Document Count.
    :vartype source_document_count: int
    :ivar processed_document_count: Processed Document Count.
    :vartype processed_document_count: int
    :ivar duration_in_seconds: Migration duration.
    :vartype duration_in_seconds: int
    """

    _validation = {
        "migration_status": {"readonly": True},
        "migration_error": {"readonly": True},
        "source_document_count": {"readonly": True},
        "processed_document_count": {"readonly": True},
        "duration_in_seconds": {"readonly": True},
    }

    _attribute_map = {
        "migration_status": {"key": "migrationStatus", "type": "str"},
        "migration_error": {"key": "migrationError", "type": "str"},
        "source_document_count": {"key": "sourceDocumentCount", "type": "int"},
        "processed_document_count": {"key": "processedDocumentCount", "type": "int"},
        "duration_in_seconds": {"key": "durationInSeconds", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.migration_status: Optional[Union[str, "_models.MongoMigrationStatus"]] = None
        self.migration_error: Optional[str] = None
        self.source_document_count: Optional[int] = None
        self.processed_document_count: Optional[int] = None
        self.duration_in_seconds: Optional[int] = None


class MySqlConnectionInfo(ConnectionInfo):
    """Information for connecting to MySQL server.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of connection info. Required.
    :vartype type: str
    :ivar user_name: User name.
    :vartype user_name: str
    :ivar password: Password credential.
    :vartype password: str
    :ivar server_name: Name of the server. Required.
    :vartype server_name: str
    :ivar data_source: Data source.
    :vartype data_source: str
    :ivar port: Port for Server. Required.
    :vartype port: int
    :ivar encrypt_connection: Whether to encrypt the connection.
    :vartype encrypt_connection: bool
    :ivar authentication: Authentication type to use for connection. Known values are: "None",
     "WindowsAuthentication", "SqlAuthentication", "ActiveDirectoryIntegrated", and
     "ActiveDirectoryPassword".
    :vartype authentication: str or ~azure.mgmt.datamigration.models.AuthenticationType
    :ivar additional_settings: Additional connection settings.
    :vartype additional_settings: str
    """

    _validation = {
        "type": {"required": True},
        "server_name": {"required": True},
        "port": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "data_source": {"key": "dataSource", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "encrypt_connection": {"key": "encryptConnection", "type": "bool"},
        "authentication": {"key": "authentication", "type": "str"},
        "additional_settings": {"key": "additionalSettings", "type": "str"},
    }

    def __init__(
        self,
        *,
        server_name: str,
        port: int,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        data_source: Optional[str] = None,
        encrypt_connection: bool = True,
        authentication: Optional[Union[str, "_models.AuthenticationType"]] = None,
        additional_settings: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_name: User name.
        :paramtype user_name: str
        :keyword password: Password credential.
        :paramtype password: str
        :keyword server_name: Name of the server. Required.
        :paramtype server_name: str
        :keyword data_source: Data source.
        :paramtype data_source: str
        :keyword port: Port for Server. Required.
        :paramtype port: int
        :keyword encrypt_connection: Whether to encrypt the connection.
        :paramtype encrypt_connection: bool
        :keyword authentication: Authentication type to use for connection. Known values are: "None",
         "WindowsAuthentication", "SqlAuthentication", "ActiveDirectoryIntegrated", and
         "ActiveDirectoryPassword".
        :paramtype authentication: str or ~azure.mgmt.datamigration.models.AuthenticationType
        :keyword additional_settings: Additional connection settings.
        :paramtype additional_settings: str
        """
        super().__init__(user_name=user_name, password=password, **kwargs)
        self.type: str = "MySqlConnectionInfo"
        self.server_name = server_name
        self.data_source = data_source
        self.port = port
        self.encrypt_connection = encrypt_connection
        self.authentication = authentication
        self.additional_settings = additional_settings


class NameAvailabilityRequest(_serialization.Model):
    """A resource type and proposed name.

    :ivar name: The proposed resource name.
    :vartype name: str
    :ivar type: The resource type chain (e.g. virtualMachines/extensions).
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The proposed resource name.
        :paramtype name: str
        :keyword type: The resource type chain (e.g. virtualMachines/extensions).
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class NameAvailabilityResponse(_serialization.Model):
    """Indicates whether a proposed resource name is available.

    :ivar name_available: If true, the name is valid and available. If false, 'reason' describes
     why not.
    :vartype name_available: bool
    :ivar reason: The reason why the name is not available, if nameAvailable is false. Known values
     are: "AlreadyExists" and "Invalid".
    :vartype reason: str or ~azure.mgmt.datamigration.models.NameCheckFailureReason
    :ivar message: The localized reason why the name is not available, if nameAvailable is false.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.NameCheckFailureReason"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: If true, the name is valid and available. If false, 'reason' describes
         why not.
        :paramtype name_available: bool
        :keyword reason: The reason why the name is not available, if nameAvailable is false. Known
         values are: "AlreadyExists" and "Invalid".
        :paramtype reason: str or ~azure.mgmt.datamigration.models.NameCheckFailureReason
        :keyword message: The localized reason why the name is not available, if nameAvailable is
         false.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class NodeMonitoringData(_serialization.Model):
    """NodeMonitoringData.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized in this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar node_name: Name of the integration runtime node.
    :vartype node_name: str
    :ivar available_memory_in_mb: Available memory (MB) on the integration runtime node.
    :vartype available_memory_in_mb: int
    :ivar cpu_utilization: CPU percentage on the integration runtime node.
    :vartype cpu_utilization: int
    :ivar concurrent_jobs_limit: Maximum concurrent jobs on the integration runtime node.
    :vartype concurrent_jobs_limit: int
    :ivar concurrent_jobs_running: The number of jobs currently running on the integration runtime
     node.
    :vartype concurrent_jobs_running: int
    :ivar max_concurrent_jobs: The maximum concurrent jobs in this integration runtime.
    :vartype max_concurrent_jobs: int
    :ivar sent_bytes: Sent bytes on the integration runtime node.
    :vartype sent_bytes: float
    :ivar received_bytes: Received bytes on the integration runtime node.
    :vartype received_bytes: float
    """

    _validation = {
        "additional_properties": {"readonly": True},
        "node_name": {"readonly": True},
        "available_memory_in_mb": {"readonly": True},
        "cpu_utilization": {"readonly": True},
        "concurrent_jobs_limit": {"readonly": True},
        "concurrent_jobs_running": {"readonly": True},
        "max_concurrent_jobs": {"readonly": True},
        "sent_bytes": {"readonly": True},
        "received_bytes": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "additionalProperties", "type": "{object}"},
        "node_name": {"key": "nodeName", "type": "str"},
        "available_memory_in_mb": {"key": "availableMemoryInMB", "type": "int"},
        "cpu_utilization": {"key": "cpuUtilization", "type": "int"},
        "concurrent_jobs_limit": {"key": "concurrentJobsLimit", "type": "int"},
        "concurrent_jobs_running": {"key": "concurrentJobsRunning", "type": "int"},
        "max_concurrent_jobs": {"key": "maxConcurrentJobs", "type": "int"},
        "sent_bytes": {"key": "sentBytes", "type": "float"},
        "received_bytes": {"key": "receivedBytes", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.additional_properties: Optional[Dict[str, JSON]] = None
        self.node_name: Optional[str] = None
        self.available_memory_in_mb: Optional[int] = None
        self.cpu_utilization: Optional[int] = None
        self.concurrent_jobs_limit: Optional[int] = None
        self.concurrent_jobs_running: Optional[int] = None
        self.max_concurrent_jobs: Optional[int] = None
        self.sent_bytes: Optional[float] = None
        self.received_bytes: Optional[float] = None


class NonSqlDataMigrationTable(_serialization.Model):
    """Defines metadata for table to be migrated.

    :ivar source_name: Source table name.
    :vartype source_name: str
    """

    _attribute_map = {
        "source_name": {"key": "sourceName", "type": "str"},
    }

    def __init__(self, *, source_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword source_name: Source table name.
        :paramtype source_name: str
        """
        super().__init__(**kwargs)
        self.source_name = source_name


class NonSqlDataMigrationTableResult(_serialization.Model):
    """Object used to report the data migration results of a table.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar result_code: Result code of the data migration. Known values are: "Initial", "Completed",
     "ObjectNotExistsInSource", "ObjectNotExistsInTarget", "TargetObjectIsInaccessible", and
     "FatalError".
    :vartype result_code: str or ~azure.mgmt.datamigration.models.DataMigrationResultCode
    :ivar source_name: Name of the source table.
    :vartype source_name: str
    :ivar target_name: Name of the target table.
    :vartype target_name: str
    :ivar source_row_count: Number of rows in the source table.
    :vartype source_row_count: int
    :ivar target_row_count: Number of rows in the target table.
    :vartype target_row_count: int
    :ivar elapsed_time_in_miliseconds: Time taken to migrate the data.
    :vartype elapsed_time_in_miliseconds: float
    :ivar errors: List of errors, if any, during migration.
    :vartype errors: list[~azure.mgmt.datamigration.models.DataMigrationError]
    """

    _validation = {
        "result_code": {"readonly": True},
        "source_name": {"readonly": True},
        "target_name": {"readonly": True},
        "source_row_count": {"readonly": True},
        "target_row_count": {"readonly": True},
        "elapsed_time_in_miliseconds": {"readonly": True},
        "errors": {"readonly": True},
    }

    _attribute_map = {
        "result_code": {"key": "resultCode", "type": "str"},
        "source_name": {"key": "sourceName", "type": "str"},
        "target_name": {"key": "targetName", "type": "str"},
        "source_row_count": {"key": "sourceRowCount", "type": "int"},
        "target_row_count": {"key": "targetRowCount", "type": "int"},
        "elapsed_time_in_miliseconds": {"key": "elapsedTimeInMiliseconds", "type": "float"},
        "errors": {"key": "errors", "type": "[DataMigrationError]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result_code: Optional[Union[str, "_models.DataMigrationResultCode"]] = None
        self.source_name: Optional[str] = None
        self.target_name: Optional[str] = None
        self.source_row_count: Optional[int] = None
        self.target_row_count: Optional[int] = None
        self.elapsed_time_in_miliseconds: Optional[float] = None
        self.errors: Optional[List["_models.DataMigrationError"]] = None


class NonSqlMigrationTaskInput(_serialization.Model):
    """Base class for non sql migration task input.

    All required parameters must be populated in order to send to server.

    :ivar target_connection_info: Information for connecting to target. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar target_database_name: Target database name. Required.
    :vartype target_database_name: str
    :ivar project_name: Name of the migration project. Required.
    :vartype project_name: str
    :ivar project_location: A URL that points to the drop location to access project artifacts.
     Required.
    :vartype project_location: str
    :ivar selected_tables: Metadata of the tables selected for migration. Required.
    :vartype selected_tables: list[~azure.mgmt.datamigration.models.NonSqlDataMigrationTable]
    """

    _validation = {
        "target_connection_info": {"required": True},
        "target_database_name": {"required": True},
        "project_name": {"required": True},
        "project_location": {"required": True},
        "selected_tables": {"required": True},
    }

    _attribute_map = {
        "target_connection_info": {"key": "targetConnectionInfo", "type": "SqlConnectionInfo"},
        "target_database_name": {"key": "targetDatabaseName", "type": "str"},
        "project_name": {"key": "projectName", "type": "str"},
        "project_location": {"key": "projectLocation", "type": "str"},
        "selected_tables": {"key": "selectedTables", "type": "[NonSqlDataMigrationTable]"},
    }

    def __init__(
        self,
        *,
        target_connection_info: "_models.SqlConnectionInfo",
        target_database_name: str,
        project_name: str,
        project_location: str,
        selected_tables: List["_models.NonSqlDataMigrationTable"],
        **kwargs: Any
    ) -> None:
        """
        :keyword target_connection_info: Information for connecting to target. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword target_database_name: Target database name. Required.
        :paramtype target_database_name: str
        :keyword project_name: Name of the migration project. Required.
        :paramtype project_name: str
        :keyword project_location: A URL that points to the drop location to access project artifacts.
         Required.
        :paramtype project_location: str
        :keyword selected_tables: Metadata of the tables selected for migration. Required.
        :paramtype selected_tables: list[~azure.mgmt.datamigration.models.NonSqlDataMigrationTable]
        """
        super().__init__(**kwargs)
        self.target_connection_info = target_connection_info
        self.target_database_name = target_database_name
        self.project_name = project_name
        self.project_location = project_location
        self.selected_tables = selected_tables


class NonSqlMigrationTaskOutput(_serialization.Model):
    """Base class for non sql migration task output.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar started_on: Migration start time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Migration end time.
    :vartype ended_on: ~datetime.datetime
    :ivar status: Current state of migration. Known values are: "Default", "Connecting",
     "SourceAndTargetSelected", "SelectLogins", "Configured", "Running", "Error", "Stopped",
     "Completed", and "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.datamigration.models.MigrationStatus
    :ivar data_migration_table_results: Results of the migration. The key contains the table name
     and the value the table result object.
    :vartype data_migration_table_results: str
    :ivar progress_message: Message about the progress of the migration.
    :vartype progress_message: str
    :ivar source_server_name: Name of source server.
    :vartype source_server_name: str
    :ivar target_server_name: Name of target server.
    :vartype target_server_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "started_on": {"readonly": True},
        "ended_on": {"readonly": True},
        "status": {"readonly": True},
        "data_migration_table_results": {"readonly": True},
        "progress_message": {"readonly": True},
        "source_server_name": {"readonly": True},
        "target_server_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "started_on": {"key": "startedOn", "type": "iso-8601"},
        "ended_on": {"key": "endedOn", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "data_migration_table_results": {"key": "dataMigrationTableResults", "type": "str"},
        "progress_message": {"key": "progressMessage", "type": "str"},
        "source_server_name": {"key": "sourceServerName", "type": "str"},
        "target_server_name": {"key": "targetServerName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.started_on: Optional[datetime.datetime] = None
        self.ended_on: Optional[datetime.datetime] = None
        self.status: Optional[Union[str, "_models.MigrationStatus"]] = None
        self.data_migration_table_results: Optional[str] = None
        self.progress_message: Optional[str] = None
        self.source_server_name: Optional[str] = None
        self.target_server_name: Optional[str] = None


class ODataError(_serialization.Model):
    """Error information in OData format.

    :ivar code: The machine-readable description of the error, such as 'InvalidRequest' or
     'InternalServerError'.
    :vartype code: str
    :ivar message: The human-readable description of the error.
    :vartype message: str
    :ivar details: Inner errors that caused this error.
    :vartype details: list[~azure.mgmt.datamigration.models.ODataError]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ODataError]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[List["_models.ODataError"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: The machine-readable description of the error, such as 'InvalidRequest' or
         'InternalServerError'.
        :paramtype code: str
        :keyword message: The human-readable description of the error.
        :paramtype message: str
        :keyword details: Inner errors that caused this error.
        :paramtype details: list[~azure.mgmt.datamigration.models.ODataError]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class OfflineConfiguration(_serialization.Model):
    """Offline configuration.

    :ivar offline: Offline migration.
    :vartype offline: bool
    :ivar last_backup_name: Last backup name for offline migration. This is optional for migrations
     from file share. If it is not provided, then the service will determine the last backup file
     name based on latest backup files present in file share.
    :vartype last_backup_name: str
    """

    _attribute_map = {
        "offline": {"key": "offline", "type": "bool"},
        "last_backup_name": {"key": "lastBackupName", "type": "str"},
    }

    def __init__(
        self, *, offline: Optional[bool] = None, last_backup_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword offline: Offline migration.
        :paramtype offline: bool
        :keyword last_backup_name: Last backup name for offline migration. This is optional for
         migrations from file share. If it is not provided, then the service will determine the last
         backup file name based on latest backup files present in file share.
        :paramtype last_backup_name: str
        """
        super().__init__(**kwargs)
        self.offline = offline
        self.last_backup_name = last_backup_name


class OperationListResult(_serialization.Model):
    """Result of the request to list SQL operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.datamigration.models.OperationsDefinition]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationsDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.OperationsDefinition"]] = None
        self.next_link: Optional[str] = None


class OperationsDefinition(_serialization.Model):
    """OperationsDefinition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name:
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display:
    :vartype display: ~azure.mgmt.datamigration.models.OperationsDisplayDefinition
    :ivar origin: Known values are: "user" and "system".
    :vartype origin: str or ~azure.mgmt.datamigration.models.OperationOrigin
    :ivar properties: Dictionary of :code:`<AnyObject>`.
    :vartype properties: dict[str, JSON]
    """

    _validation = {
        "name": {"readonly": True},
        "display": {"readonly": True},
        "origin": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationsDisplayDefinition"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "{object}"},
    }

    def __init__(self, *, is_data_action: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.is_data_action = is_data_action
        self.display: Optional["_models.OperationsDisplayDefinition"] = None
        self.origin: Optional[Union[str, "_models.OperationOrigin"]] = None
        self.properties: Optional[Dict[str, JSON]] = None


class OperationsDisplayDefinition(_serialization.Model):
    """OperationsDisplayDefinition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider:
    :vartype provider: str
    :ivar resource:
    :vartype resource: str
    :ivar operation:
    :vartype operation: str
    :ivar description:
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider: Optional[str] = None
        self.resource: Optional[str] = None
        self.operation: Optional[str] = None
        self.description: Optional[str] = None


class OracleConnectionInfo(ConnectionInfo):
    """Information for connecting to Oracle server.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of connection info. Required.
    :vartype type: str
    :ivar user_name: User name.
    :vartype user_name: str
    :ivar password: Password credential.
    :vartype password: str
    :ivar data_source: EZConnect or TNSName connection string. Required.
    :vartype data_source: str
    :ivar server_name: name of the server.
    :vartype server_name: str
    :ivar server_version: server version.
    :vartype server_version: str
    :ivar port: port for server.
    :vartype port: int
    :ivar authentication: Authentication type to use for connection. Known values are: "None",
     "WindowsAuthentication", "SqlAuthentication", "ActiveDirectoryIntegrated", and
     "ActiveDirectoryPassword".
    :vartype authentication: str or ~azure.mgmt.datamigration.models.AuthenticationType
    """

    _validation = {
        "type": {"required": True},
        "data_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "data_source": {"key": "dataSource", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "server_version": {"key": "serverVersion", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "authentication": {"key": "authentication", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_source: str,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        server_name: Optional[str] = None,
        server_version: Optional[str] = None,
        port: Optional[int] = None,
        authentication: Optional[Union[str, "_models.AuthenticationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_name: User name.
        :paramtype user_name: str
        :keyword password: Password credential.
        :paramtype password: str
        :keyword data_source: EZConnect or TNSName connection string. Required.
        :paramtype data_source: str
        :keyword server_name: name of the server.
        :paramtype server_name: str
        :keyword server_version: server version.
        :paramtype server_version: str
        :keyword port: port for server.
        :paramtype port: int
        :keyword authentication: Authentication type to use for connection. Known values are: "None",
         "WindowsAuthentication", "SqlAuthentication", "ActiveDirectoryIntegrated", and
         "ActiveDirectoryPassword".
        :paramtype authentication: str or ~azure.mgmt.datamigration.models.AuthenticationType
        """
        super().__init__(user_name=user_name, password=password, **kwargs)
        self.type: str = "OracleConnectionInfo"
        self.data_source = data_source
        self.server_name = server_name
        self.server_version = server_version
        self.port = port
        self.authentication = authentication


class OracleOCIDriverInfo(_serialization.Model):
    """Information about an Oracle OCI driver.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar driver_name: The name of the driver package.
    :vartype driver_name: str
    :ivar driver_size: The size in bytes of the driver package.
    :vartype driver_size: str
    :ivar archive_checksum: The MD5 Base64 encoded checksum for the driver package.
    :vartype archive_checksum: str
    :ivar oracle_checksum: The checksum for the driver package provided by Oracle.
    :vartype oracle_checksum: str
    :ivar assembly_version: Version listed in the OCI assembly 'oci.dll'.
    :vartype assembly_version: str
    :ivar supported_oracle_versions: List of Oracle database versions supported by this driver.
     Only major minor of the version is listed.
    :vartype supported_oracle_versions: list[str]
    """

    _validation = {
        "driver_name": {"readonly": True},
        "driver_size": {"readonly": True},
        "archive_checksum": {"readonly": True},
        "oracle_checksum": {"readonly": True},
        "assembly_version": {"readonly": True},
        "supported_oracle_versions": {"readonly": True},
    }

    _attribute_map = {
        "driver_name": {"key": "driverName", "type": "str"},
        "driver_size": {"key": "driverSize", "type": "str"},
        "archive_checksum": {"key": "archiveChecksum", "type": "str"},
        "oracle_checksum": {"key": "oracleChecksum", "type": "str"},
        "assembly_version": {"key": "assemblyVersion", "type": "str"},
        "supported_oracle_versions": {"key": "supportedOracleVersions", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.driver_name: Optional[str] = None
        self.driver_size: Optional[str] = None
        self.archive_checksum: Optional[str] = None
        self.oracle_checksum: Optional[str] = None
        self.assembly_version: Optional[str] = None
        self.supported_oracle_versions: Optional[List[str]] = None


class OrphanedUserInfo(_serialization.Model):
    """Information of orphaned users on the SQL server database.

    :ivar name: Name of the orphaned user.
    :vartype name: str
    :ivar database_name: Parent database of the user.
    :vartype database_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, database_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the orphaned user.
        :paramtype name: str
        :keyword database_name: Parent database of the user.
        :paramtype database_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.database_name = database_name


class PostgreSqlConnectionInfo(ConnectionInfo):
    """Information for connecting to PostgreSQL server.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of connection info. Required.
    :vartype type: str
    :ivar user_name: User name.
    :vartype user_name: str
    :ivar password: Password credential.
    :vartype password: str
    :ivar server_name: Name of the server. Required.
    :vartype server_name: str
    :ivar data_source: Data source.
    :vartype data_source: str
    :ivar server_version: server version.
    :vartype server_version: str
    :ivar database_name: Name of the database.
    :vartype database_name: str
    :ivar port: Port for Server. Required.
    :vartype port: int
    :ivar encrypt_connection: Whether to encrypt the connection.
    :vartype encrypt_connection: bool
    :ivar trust_server_certificate: Whether to trust the server certificate.
    :vartype trust_server_certificate: bool
    :ivar additional_settings: Additional connection settings.
    :vartype additional_settings: str
    :ivar server_brand_version: server brand version.
    :vartype server_brand_version: str
    :ivar authentication: Authentication type to use for connection. Known values are: "None",
     "WindowsAuthentication", "SqlAuthentication", "ActiveDirectoryIntegrated", and
     "ActiveDirectoryPassword".
    :vartype authentication: str or ~azure.mgmt.datamigration.models.AuthenticationType
    """

    _validation = {
        "type": {"required": True},
        "server_name": {"required": True},
        "port": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "data_source": {"key": "dataSource", "type": "str"},
        "server_version": {"key": "serverVersion", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "encrypt_connection": {"key": "encryptConnection", "type": "bool"},
        "trust_server_certificate": {"key": "trustServerCertificate", "type": "bool"},
        "additional_settings": {"key": "additionalSettings", "type": "str"},
        "server_brand_version": {"key": "serverBrandVersion", "type": "str"},
        "authentication": {"key": "authentication", "type": "str"},
    }

    def __init__(
        self,
        *,
        server_name: str,
        port: int,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        data_source: Optional[str] = None,
        server_version: Optional[str] = None,
        database_name: Optional[str] = None,
        encrypt_connection: bool = True,
        trust_server_certificate: bool = False,
        additional_settings: Optional[str] = None,
        server_brand_version: Optional[str] = None,
        authentication: Optional[Union[str, "_models.AuthenticationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_name: User name.
        :paramtype user_name: str
        :keyword password: Password credential.
        :paramtype password: str
        :keyword server_name: Name of the server. Required.
        :paramtype server_name: str
        :keyword data_source: Data source.
        :paramtype data_source: str
        :keyword server_version: server version.
        :paramtype server_version: str
        :keyword database_name: Name of the database.
        :paramtype database_name: str
        :keyword port: Port for Server. Required.
        :paramtype port: int
        :keyword encrypt_connection: Whether to encrypt the connection.
        :paramtype encrypt_connection: bool
        :keyword trust_server_certificate: Whether to trust the server certificate.
        :paramtype trust_server_certificate: bool
        :keyword additional_settings: Additional connection settings.
        :paramtype additional_settings: str
        :keyword server_brand_version: server brand version.
        :paramtype server_brand_version: str
        :keyword authentication: Authentication type to use for connection. Known values are: "None",
         "WindowsAuthentication", "SqlAuthentication", "ActiveDirectoryIntegrated", and
         "ActiveDirectoryPassword".
        :paramtype authentication: str or ~azure.mgmt.datamigration.models.AuthenticationType
        """
        super().__init__(user_name=user_name, password=password, **kwargs)
        self.type: str = "PostgreSqlConnectionInfo"
        self.server_name = server_name
        self.data_source = data_source
        self.server_version = server_version
        self.database_name = database_name
        self.port = port
        self.encrypt_connection = encrypt_connection
        self.trust_server_certificate = trust_server_certificate
        self.additional_settings = additional_settings
        self.server_brand_version = server_brand_version
        self.authentication = authentication


class Project(TrackedResourceAutoGenerated):
    """A project resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location:
    :vartype location: str
    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar system_data:
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemDataAutoGenerated
    :ivar etag: HTTP strong entity tag value. This is ignored if submitted.
    :vartype etag: str
    :ivar source_platform: Source platform for the project. Known values are: "SQL", "MySQL",
     "PostgreSql", "MongoDb", and "Unknown".
    :vartype source_platform: str or ~azure.mgmt.datamigration.models.ProjectSourcePlatform
    :ivar azure_authentication_info: Field that defines the Azure active directory application
     info, used to connect to the target Azure resource.
    :vartype azure_authentication_info: ~azure.mgmt.datamigration.models.AzureActiveDirectoryApp
    :ivar target_platform: Target platform for the project. Known values are: "SQLDB", "SQLMI",
     "AzureDbForMySql", "AzureDbForPostgreSql", "MongoDb", and "Unknown".
    :vartype target_platform: str or ~azure.mgmt.datamigration.models.ProjectTargetPlatform
    :ivar creation_time: UTC Date and time when project was created.
    :vartype creation_time: ~datetime.datetime
    :ivar source_connection_info: Information for connecting to source.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.ConnectionInfo
    :ivar target_connection_info: Information for connecting to target.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.ConnectionInfo
    :ivar databases_info: List of DatabaseInfo.
    :vartype databases_info: list[~azure.mgmt.datamigration.models.DatabaseInfo]
    :ivar provisioning_state: The project's provisioning state. Known values are: "Deleting" and
     "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.datamigration.models.ProjectProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemDataAutoGenerated"},
        "etag": {"key": "etag", "type": "str"},
        "source_platform": {"key": "properties.sourcePlatform", "type": "str"},
        "azure_authentication_info": {"key": "properties.azureAuthenticationInfo", "type": "AzureActiveDirectoryApp"},
        "target_platform": {"key": "properties.targetPlatform", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
        "source_connection_info": {"key": "properties.sourceConnectionInfo", "type": "ConnectionInfo"},
        "target_connection_info": {"key": "properties.targetConnectionInfo", "type": "ConnectionInfo"},
        "databases_info": {"key": "properties.databasesInfo", "type": "[DatabaseInfo]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        source_platform: Optional[Union[str, "_models.ProjectSourcePlatform"]] = None,
        azure_authentication_info: Optional["_models.AzureActiveDirectoryApp"] = None,
        target_platform: Optional[Union[str, "_models.ProjectTargetPlatform"]] = None,
        source_connection_info: Optional["_models.ConnectionInfo"] = None,
        target_connection_info: Optional["_models.ConnectionInfo"] = None,
        databases_info: Optional[List["_models.DatabaseInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location:
        :paramtype location: str
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword etag: HTTP strong entity tag value. This is ignored if submitted.
        :paramtype etag: str
        :keyword source_platform: Source platform for the project. Known values are: "SQL", "MySQL",
         "PostgreSql", "MongoDb", and "Unknown".
        :paramtype source_platform: str or ~azure.mgmt.datamigration.models.ProjectSourcePlatform
        :keyword azure_authentication_info: Field that defines the Azure active directory application
         info, used to connect to the target Azure resource.
        :paramtype azure_authentication_info: ~azure.mgmt.datamigration.models.AzureActiveDirectoryApp
        :keyword target_platform: Target platform for the project. Known values are: "SQLDB", "SQLMI",
         "AzureDbForMySql", "AzureDbForPostgreSql", "MongoDb", and "Unknown".
        :paramtype target_platform: str or ~azure.mgmt.datamigration.models.ProjectTargetPlatform
        :keyword source_connection_info: Information for connecting to source.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.ConnectionInfo
        :keyword target_connection_info: Information for connecting to target.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.ConnectionInfo
        :keyword databases_info: List of DatabaseInfo.
        :paramtype databases_info: list[~azure.mgmt.datamigration.models.DatabaseInfo]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.etag = etag
        self.source_platform = source_platform
        self.azure_authentication_info = azure_authentication_info
        self.target_platform = target_platform
        self.creation_time: Optional[datetime.datetime] = None
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info
        self.databases_info = databases_info
        self.provisioning_state: Optional[Union[str, "_models.ProjectProvisioningState"]] = None


class ResourceAutoGenerated(_serialization.Model):
    """ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class ProjectFile(ResourceAutoGenerated):
    """A file resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: HTTP strong entity tag value. This is ignored if submitted.
    :vartype etag: str
    :ivar properties: Custom file properties.
    :vartype properties: ~azure.mgmt.datamigration.models.ProjectFileProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemDataAutoGenerated
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "properties": {"key": "properties", "type": "ProjectFileProperties"},
        "system_data": {"key": "systemData", "type": "SystemDataAutoGenerated"},
    }

    def __init__(
        self, *, etag: Optional[str] = None, properties: Optional["_models.ProjectFileProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword etag: HTTP strong entity tag value. This is ignored if submitted.
        :paramtype etag: str
        :keyword properties: Custom file properties.
        :paramtype properties: ~azure.mgmt.datamigration.models.ProjectFileProperties
        """
        super().__init__(**kwargs)
        self.etag = etag
        self.properties = properties
        self.system_data: Optional["_models.SystemDataAutoGenerated"] = None


class ProjectFileProperties(_serialization.Model):
    """Base class for file properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar extension: Optional File extension. If submitted it should not have a leading period and
     must match the extension from filePath.
    :vartype extension: str
    :ivar file_path: Relative path of this file resource. This property can be set when creating or
     updating the file resource.
    :vartype file_path: str
    :ivar last_modified: Modification DateTime.
    :vartype last_modified: ~datetime.datetime
    :ivar media_type: File content type. This property can be modified to reflect the file content
     type.
    :vartype media_type: str
    :ivar size: File size.
    :vartype size: int
    """

    _validation = {
        "last_modified": {"readonly": True},
        "size": {"readonly": True},
    }

    _attribute_map = {
        "extension": {"key": "extension", "type": "str"},
        "file_path": {"key": "filePath", "type": "str"},
        "last_modified": {"key": "lastModified", "type": "iso-8601"},
        "media_type": {"key": "mediaType", "type": "str"},
        "size": {"key": "size", "type": "int"},
    }

    def __init__(
        self,
        *,
        extension: Optional[str] = None,
        file_path: Optional[str] = None,
        media_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extension: Optional File extension. If submitted it should not have a leading period
         and must match the extension from filePath.
        :paramtype extension: str
        :keyword file_path: Relative path of this file resource. This property can be set when creating
         or updating the file resource.
        :paramtype file_path: str
        :keyword media_type: File content type. This property can be modified to reflect the file
         content type.
        :paramtype media_type: str
        """
        super().__init__(**kwargs)
        self.extension = extension
        self.file_path = file_path
        self.last_modified: Optional[datetime.datetime] = None
        self.media_type = media_type
        self.size: Optional[int] = None


class ProjectList(_serialization.Model):
    """OData page of project resources.

    :ivar value: List of projects.
    :vartype value: list[~azure.mgmt.datamigration.models.Project]
    :ivar next_link: URL to load the next page of projects.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Project]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Project"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of projects.
        :paramtype value: list[~azure.mgmt.datamigration.models.Project]
        :keyword next_link: URL to load the next page of projects.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProjectTask(ResourceAutoGenerated):
    """A task resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: HTTP strong entity tag value. This is ignored if submitted.
    :vartype etag: str
    :ivar properties: Custom task properties.
    :vartype properties: ~azure.mgmt.datamigration.models.ProjectTaskProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemDataAutoGenerated
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "properties": {"key": "properties", "type": "ProjectTaskProperties"},
        "system_data": {"key": "systemData", "type": "SystemDataAutoGenerated"},
    }

    def __init__(
        self, *, etag: Optional[str] = None, properties: Optional["_models.ProjectTaskProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword etag: HTTP strong entity tag value. This is ignored if submitted.
        :paramtype etag: str
        :keyword properties: Custom task properties.
        :paramtype properties: ~azure.mgmt.datamigration.models.ProjectTaskProperties
        """
        super().__init__(**kwargs)
        self.etag = etag
        self.properties = properties
        self.system_data: Optional["_models.SystemDataAutoGenerated"] = None


class QueryAnalysisValidationResult(_serialization.Model):
    """Results for query analysis comparison between the source and target.

    :ivar query_results: List of queries executed and it's execution results in source and target.
    :vartype query_results: ~azure.mgmt.datamigration.models.QueryExecutionResult
    :ivar validation_errors: Errors that are part of the execution.
    :vartype validation_errors: ~azure.mgmt.datamigration.models.ValidationError
    """

    _attribute_map = {
        "query_results": {"key": "queryResults", "type": "QueryExecutionResult"},
        "validation_errors": {"key": "validationErrors", "type": "ValidationError"},
    }

    def __init__(
        self,
        *,
        query_results: Optional["_models.QueryExecutionResult"] = None,
        validation_errors: Optional["_models.ValidationError"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword query_results: List of queries executed and it's execution results in source and
         target.
        :paramtype query_results: ~azure.mgmt.datamigration.models.QueryExecutionResult
        :keyword validation_errors: Errors that are part of the execution.
        :paramtype validation_errors: ~azure.mgmt.datamigration.models.ValidationError
        """
        super().__init__(**kwargs)
        self.query_results = query_results
        self.validation_errors = validation_errors


class QueryExecutionResult(_serialization.Model):
    """Describes query analysis results for execution in source and target.

    :ivar query_text: Query text retrieved from the source server.
    :vartype query_text: str
    :ivar statements_in_batch: Total no. of statements in the batch.
    :vartype statements_in_batch: int
    :ivar source_result: Query analysis result from the source.
    :vartype source_result: ~azure.mgmt.datamigration.models.ExecutionStatistics
    :ivar target_result: Query analysis result from the target.
    :vartype target_result: ~azure.mgmt.datamigration.models.ExecutionStatistics
    """

    _attribute_map = {
        "query_text": {"key": "queryText", "type": "str"},
        "statements_in_batch": {"key": "statementsInBatch", "type": "int"},
        "source_result": {"key": "sourceResult", "type": "ExecutionStatistics"},
        "target_result": {"key": "targetResult", "type": "ExecutionStatistics"},
    }

    def __init__(
        self,
        *,
        query_text: Optional[str] = None,
        statements_in_batch: Optional[int] = None,
        source_result: Optional["_models.ExecutionStatistics"] = None,
        target_result: Optional["_models.ExecutionStatistics"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword query_text: Query text retrieved from the source server.
        :paramtype query_text: str
        :keyword statements_in_batch: Total no. of statements in the batch.
        :paramtype statements_in_batch: int
        :keyword source_result: Query analysis result from the source.
        :paramtype source_result: ~azure.mgmt.datamigration.models.ExecutionStatistics
        :keyword target_result: Query analysis result from the target.
        :paramtype target_result: ~azure.mgmt.datamigration.models.ExecutionStatistics
        """
        super().__init__(**kwargs)
        self.query_text = query_text
        self.statements_in_batch = statements_in_batch
        self.source_result = source_result
        self.target_result = target_result


class Quota(_serialization.Model):
    """Describes a quota for or usage details about a resource.

    :ivar current_value: The current value of the quota. If null or missing, the current value
     cannot be determined in the context of the request.
    :vartype current_value: float
    :ivar id: The resource ID of the quota object.
    :vartype id: str
    :ivar limit: The maximum value of the quota. If null or missing, the quota has no maximum, in
     which case it merely tracks usage.
    :vartype limit: float
    :ivar name: The name of the quota.
    :vartype name: ~azure.mgmt.datamigration.models.QuotaName
    :ivar unit: The unit for the quota, such as Count, Bytes, BytesPerSecond, etc.
    :vartype unit: str
    """

    _attribute_map = {
        "current_value": {"key": "currentValue", "type": "float"},
        "id": {"key": "id", "type": "str"},
        "limit": {"key": "limit", "type": "float"},
        "name": {"key": "name", "type": "QuotaName"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(
        self,
        *,
        current_value: Optional[float] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        limit: Optional[float] = None,
        name: Optional["_models.QuotaName"] = None,
        unit: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword current_value: The current value of the quota. If null or missing, the current value
         cannot be determined in the context of the request.
        :paramtype current_value: float
        :keyword id: The resource ID of the quota object.
        :paramtype id: str
        :keyword limit: The maximum value of the quota. If null or missing, the quota has no maximum,
         in which case it merely tracks usage.
        :paramtype limit: float
        :keyword name: The name of the quota.
        :paramtype name: ~azure.mgmt.datamigration.models.QuotaName
        :keyword unit: The unit for the quota, such as Count, Bytes, BytesPerSecond, etc.
        :paramtype unit: str
        """
        super().__init__(**kwargs)
        self.current_value = current_value
        self.id = id
        self.limit = limit
        self.name = name
        self.unit = unit


class QuotaList(_serialization.Model):
    """OData page of quota objects.

    :ivar value: List of quotas.
    :vartype value: list[~azure.mgmt.datamigration.models.Quota]
    :ivar next_link: URL to load the next page of quotas, or null or missing if this is the last
     page.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Quota]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Quota"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of quotas.
        :paramtype value: list[~azure.mgmt.datamigration.models.Quota]
        :keyword next_link: URL to load the next page of quotas, or null or missing if this is the last
         page.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class QuotaName(_serialization.Model):
    """The name of the quota.

    :ivar localized_value: The localized name of the quota.
    :vartype localized_value: str
    :ivar value: The unlocalized name (or ID) of the quota.
    :vartype value: str
    """

    _attribute_map = {
        "localized_value": {"key": "localizedValue", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, localized_value: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword localized_value: The localized name of the quota.
        :paramtype localized_value: str
        :keyword value: The unlocalized name (or ID) of the quota.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.localized_value = localized_value
        self.value = value


class RegenAuthKeys(_serialization.Model):
    """An authentication key to regenerate.

    :ivar key_name: The name of authentication key to generate.
    :vartype key_name: str
    :ivar auth_key1: The first authentication key.
    :vartype auth_key1: str
    :ivar auth_key2: The second authentication key.
    :vartype auth_key2: str
    """

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
        "auth_key1": {"key": "authKey1", "type": "str"},
        "auth_key2": {"key": "authKey2", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        auth_key1: Optional[str] = None,
        auth_key2: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_name: The name of authentication key to generate.
        :paramtype key_name: str
        :keyword auth_key1: The first authentication key.
        :paramtype auth_key1: str
        :keyword auth_key2: The second authentication key.
        :paramtype auth_key2: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name
        self.auth_key1 = auth_key1
        self.auth_key2 = auth_key2


class ReportableException(_serialization.Model):
    """Exception object for all custom exceptions.

    :ivar message: Error message.
    :vartype message: str
    :ivar actionable_message: Actionable steps for this exception.
    :vartype actionable_message: str
    :ivar file_path: The path to the file where exception occurred.
    :vartype file_path: str
    :ivar line_number: The line number where exception occurred.
    :vartype line_number: str
    :ivar h_result: Coded numerical value that is assigned to a specific exception.
    :vartype h_result: int
    :ivar stack_trace: Stack trace.
    :vartype stack_trace: str
    """

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "actionable_message": {"key": "actionableMessage", "type": "str"},
        "file_path": {"key": "filePath", "type": "str"},
        "line_number": {"key": "lineNumber", "type": "str"},
        "h_result": {"key": "hResult", "type": "int"},
        "stack_trace": {"key": "stackTrace", "type": "str"},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        actionable_message: Optional[str] = None,
        file_path: Optional[str] = None,
        line_number: Optional[str] = None,
        h_result: Optional[int] = None,
        stack_trace: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword message: Error message.
        :paramtype message: str
        :keyword actionable_message: Actionable steps for this exception.
        :paramtype actionable_message: str
        :keyword file_path: The path to the file where exception occurred.
        :paramtype file_path: str
        :keyword line_number: The line number where exception occurred.
        :paramtype line_number: str
        :keyword h_result: Coded numerical value that is assigned to a specific exception.
        :paramtype h_result: int
        :keyword stack_trace: Stack trace.
        :paramtype stack_trace: str
        """
        super().__init__(**kwargs)
        self.message = message
        self.actionable_message = actionable_message
        self.file_path = file_path
        self.line_number = line_number
        self.h_result = h_result
        self.stack_trace = stack_trace


class ResourceSku(_serialization.Model):
    """Describes an available DMS (classic) SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: The name of SKU.
    :vartype name: str
    :ivar tier: Specifies the tier of DMS (classic) in a scale set.
    :vartype tier: str
    :ivar size: The Size of the SKU.
    :vartype size: str
    :ivar family: The Family of this particular SKU.
    :vartype family: str
    :ivar kind: The Kind of resources that are supported in this SKU.
    :vartype kind: str
    :ivar capacity: Not used.
    :vartype capacity: ~azure.mgmt.datamigration.models.ResourceSkuCapacity
    :ivar locations: The set of locations that the SKU is available.
    :vartype locations: list[str]
    :ivar api_versions: The api versions that support this SKU.
    :vartype api_versions: list[str]
    :ivar costs: Metadata for retrieving price info.
    :vartype costs: list[~azure.mgmt.datamigration.models.ResourceSkuCosts]
    :ivar capabilities: A name value pair to describe the capability.
    :vartype capabilities: list[~azure.mgmt.datamigration.models.ResourceSkuCapabilities]
    :ivar restrictions: The restrictions because of which SKU cannot be used. This is empty if
     there are no restrictions.
    :vartype restrictions: list[~azure.mgmt.datamigration.models.ResourceSkuRestrictions]
    """

    _validation = {
        "resource_type": {"readonly": True},
        "name": {"readonly": True},
        "tier": {"readonly": True},
        "size": {"readonly": True},
        "family": {"readonly": True},
        "kind": {"readonly": True},
        "capacity": {"readonly": True},
        "locations": {"readonly": True},
        "api_versions": {"readonly": True},
        "costs": {"readonly": True},
        "capabilities": {"readonly": True},
        "restrictions": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "capacity": {"key": "capacity", "type": "ResourceSkuCapacity"},
        "locations": {"key": "locations", "type": "[str]"},
        "api_versions": {"key": "apiVersions", "type": "[str]"},
        "costs": {"key": "costs", "type": "[ResourceSkuCosts]"},
        "capabilities": {"key": "capabilities", "type": "[ResourceSkuCapabilities]"},
        "restrictions": {"key": "restrictions", "type": "[ResourceSkuRestrictions]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_type: Optional[str] = None
        self.name: Optional[str] = None
        self.tier: Optional[str] = None
        self.size: Optional[str] = None
        self.family: Optional[str] = None
        self.kind: Optional[str] = None
        self.capacity: Optional["_models.ResourceSkuCapacity"] = None
        self.locations: Optional[List[str]] = None
        self.api_versions: Optional[List[str]] = None
        self.costs: Optional[List["_models.ResourceSkuCosts"]] = None
        self.capabilities: Optional[List["_models.ResourceSkuCapabilities"]] = None
        self.restrictions: Optional[List["_models.ResourceSkuRestrictions"]] = None


class ResourceSkuCapabilities(_serialization.Model):
    """Describes The SKU capabilities object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: An invariant to describe the feature.
    :vartype name: str
    :ivar value: An invariant if the feature is measured by quantity.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.value: Optional[str] = None


class ResourceSkuCapacity(_serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: int
    :ivar maximum: The maximum capacity.
    :vartype maximum: int
    :ivar default: The default capacity.
    :vartype default: int
    :ivar scale_type: The scale type applicable to the SKU. Known values are: "Automatic",
     "Manual", and "None".
    :vartype scale_type: str or ~azure.mgmt.datamigration.models.ResourceSkuCapacityScaleType
    """

    _validation = {
        "minimum": {"readonly": True},
        "maximum": {"readonly": True},
        "default": {"readonly": True},
        "scale_type": {"readonly": True},
    }

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default": {"key": "default", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.minimum: Optional[int] = None
        self.maximum: Optional[int] = None
        self.default: Optional[int] = None
        self.scale_type: Optional[Union[str, "_models.ResourceSkuCapacityScaleType"]] = None


class ResourceSkuCosts(_serialization.Model):
    """Describes metadata for retrieving price info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar meter_id: Used for querying price from commerce.
    :vartype meter_id: str
    :ivar quantity: The multiplier is needed to extend the base metered cost.
    :vartype quantity: int
    :ivar extended_unit: An invariant to show the extended unit.
    :vartype extended_unit: str
    """

    _validation = {
        "meter_id": {"readonly": True},
        "quantity": {"readonly": True},
        "extended_unit": {"readonly": True},
    }

    _attribute_map = {
        "meter_id": {"key": "meterID", "type": "str"},
        "quantity": {"key": "quantity", "type": "int"},
        "extended_unit": {"key": "extendedUnit", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.meter_id: Optional[str] = None
        self.quantity: Optional[int] = None
        self.extended_unit: Optional[str] = None


class ResourceSkuRestrictions(_serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. "location"
    :vartype type: str or ~azure.mgmt.datamigration.models.ResourceSkuRestrictionsType
    :ivar values: The value of restrictions. If the restriction type is set to location. This would
     be different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar reason_code: The reason code for restriction. Known values are: "QuotaId" and
     "NotAvailableForSubscription".
    :vartype reason_code: str or ~azure.mgmt.datamigration.models.ResourceSkuRestrictionsReasonCode
    """

    _validation = {
        "type": {"readonly": True},
        "values": {"readonly": True},
        "reason_code": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
        "reason_code": {"key": "reasonCode", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[Union[str, "_models.ResourceSkuRestrictionsType"]] = None
        self.values: Optional[List[str]] = None
        self.reason_code: Optional[Union[str, "_models.ResourceSkuRestrictionsReasonCode"]] = None


class ResourceSkusResult(_serialization.Model):
    """The DMS (classic) List SKUs operation response.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of SKUs available for the subscription. Required.
    :vartype value: list[~azure.mgmt.datamigration.models.ResourceSku]
    :ivar next_link: The uri to fetch the next page of DMS (classic) SKUs. Call ListNext() with
     this to fetch the next page of DMS (classic) SKUs.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ResourceSku"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of SKUs available for the subscription. Required.
        :paramtype value: list[~azure.mgmt.datamigration.models.ResourceSku]
        :keyword next_link: The uri to fetch the next page of DMS (classic) SKUs. Call ListNext() with
         this to fetch the next page of DMS (classic) SKUs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SchemaComparisonValidationResult(_serialization.Model):
    """Results for schema comparison between the source and target.

    :ivar schema_differences: List of schema differences between the source and target databases.
    :vartype schema_differences:
     ~azure.mgmt.datamigration.models.SchemaComparisonValidationResultType
    :ivar validation_errors: List of errors that happened while performing schema compare
     validation.
    :vartype validation_errors: ~azure.mgmt.datamigration.models.ValidationError
    :ivar source_database_object_count: Count of source database objects.
    :vartype source_database_object_count: dict[str, int]
    :ivar target_database_object_count: Count of target database objects.
    :vartype target_database_object_count: dict[str, int]
    """

    _attribute_map = {
        "schema_differences": {"key": "schemaDifferences", "type": "SchemaComparisonValidationResultType"},
        "validation_errors": {"key": "validationErrors", "type": "ValidationError"},
        "source_database_object_count": {"key": "sourceDatabaseObjectCount", "type": "{int}"},
        "target_database_object_count": {"key": "targetDatabaseObjectCount", "type": "{int}"},
    }

    def __init__(
        self,
        *,
        schema_differences: Optional["_models.SchemaComparisonValidationResultType"] = None,
        validation_errors: Optional["_models.ValidationError"] = None,
        source_database_object_count: Optional[Dict[str, int]] = None,
        target_database_object_count: Optional[Dict[str, int]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword schema_differences: List of schema differences between the source and target
         databases.
        :paramtype schema_differences:
         ~azure.mgmt.datamigration.models.SchemaComparisonValidationResultType
        :keyword validation_errors: List of errors that happened while performing schema compare
         validation.
        :paramtype validation_errors: ~azure.mgmt.datamigration.models.ValidationError
        :keyword source_database_object_count: Count of source database objects.
        :paramtype source_database_object_count: dict[str, int]
        :keyword target_database_object_count: Count of target database objects.
        :paramtype target_database_object_count: dict[str, int]
        """
        super().__init__(**kwargs)
        self.schema_differences = schema_differences
        self.validation_errors = validation_errors
        self.source_database_object_count = source_database_object_count
        self.target_database_object_count = target_database_object_count


class SchemaComparisonValidationResultType(_serialization.Model):
    """Description about the errors happen while performing migration validation.

    :ivar object_name: Name of the object that has the difference.
    :vartype object_name: str
    :ivar object_type: Type of the object that has the difference. e.g
     (Table/View/StoredProcedure). Known values are: "StoredProcedures", "Table", "User", "View",
     and "Function".
    :vartype object_type: str or ~azure.mgmt.datamigration.models.ObjectType
    :ivar update_action: Update action type with respect to target. Known values are:
     "DeletedOnTarget", "ChangedOnTarget", and "AddedOnTarget".
    :vartype update_action: str or ~azure.mgmt.datamigration.models.UpdateActionType
    """

    _attribute_map = {
        "object_name": {"key": "objectName", "type": "str"},
        "object_type": {"key": "objectType", "type": "str"},
        "update_action": {"key": "updateAction", "type": "str"},
    }

    def __init__(
        self,
        *,
        object_name: Optional[str] = None,
        object_type: Optional[Union[str, "_models.ObjectType"]] = None,
        update_action: Optional[Union[str, "_models.UpdateActionType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword object_name: Name of the object that has the difference.
        :paramtype object_name: str
        :keyword object_type: Type of the object that has the difference. e.g
         (Table/View/StoredProcedure). Known values are: "StoredProcedures", "Table", "User", "View",
         and "Function".
        :paramtype object_type: str or ~azure.mgmt.datamigration.models.ObjectType
        :keyword update_action: Update action type with respect to target. Known values are:
         "DeletedOnTarget", "ChangedOnTarget", and "AddedOnTarget".
        :paramtype update_action: str or ~azure.mgmt.datamigration.models.UpdateActionType
        """
        super().__init__(**kwargs)
        self.object_name = object_name
        self.object_type = object_type
        self.update_action = update_action


class SchemaMigrationSetting(_serialization.Model):
    """Settings for migrating schema from source to target.

    :ivar schema_option: Option on how to migrate the schema. Known values are: "None",
     "ExtractFromSource", and "UseStorageFile".
    :vartype schema_option: str or ~azure.mgmt.datamigration.models.SchemaMigrationOption
    :ivar file_id: Resource Identifier of a file resource containing the uploaded schema file.
    :vartype file_id: str
    :ivar file_name: Name of the file resource containing the uploaded schema file.
    :vartype file_name: str
    """

    _attribute_map = {
        "schema_option": {"key": "schemaOption", "type": "str"},
        "file_id": {"key": "fileId", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
    }

    def __init__(
        self,
        *,
        schema_option: Optional[Union[str, "_models.SchemaMigrationOption"]] = None,
        file_id: Optional[str] = None,
        file_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword schema_option: Option on how to migrate the schema. Known values are: "None",
         "ExtractFromSource", and "UseStorageFile".
        :paramtype schema_option: str or ~azure.mgmt.datamigration.models.SchemaMigrationOption
        :keyword file_id: Resource Identifier of a file resource containing the uploaded schema file.
        :paramtype file_id: str
        :keyword file_name: Name of the file resource containing the uploaded schema file.
        :paramtype file_name: str
        """
        super().__init__(**kwargs)
        self.schema_option = schema_option
        self.file_id = file_id
        self.file_name = file_name


class SelectedCertificateInput(_serialization.Model):
    """Info for certificate to be exported for TDE enabled databases.

    All required parameters must be populated in order to send to server.

    :ivar certificate_name: Name of certificate to be exported. Required.
    :vartype certificate_name: str
    :ivar password: Password to use for encrypting the exported certificate. Required.
    :vartype password: str
    """

    _validation = {
        "certificate_name": {"required": True},
        "password": {"required": True},
    }

    _attribute_map = {
        "certificate_name": {"key": "certificateName", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(self, *, certificate_name: str, password: str, **kwargs: Any) -> None:
        """
        :keyword certificate_name: Name of certificate to be exported. Required.
        :paramtype certificate_name: str
        :keyword password: Password to use for encrypting the exported certificate. Required.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.certificate_name = certificate_name
        self.password = password


class ServerProperties(_serialization.Model):
    """Server properties for MySQL type source.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar server_platform: Name of the server platform.
    :vartype server_platform: str
    :ivar server_name: Name of the server.
    :vartype server_name: str
    :ivar server_version: Version of the database server.
    :vartype server_version: str
    :ivar server_edition: Edition of the database server.
    :vartype server_edition: str
    :ivar server_operating_system_version: Version of the operating system.
    :vartype server_operating_system_version: str
    :ivar server_database_count: Number of databases in the server.
    :vartype server_database_count: int
    """

    _validation = {
        "server_platform": {"readonly": True},
        "server_name": {"readonly": True},
        "server_version": {"readonly": True},
        "server_edition": {"readonly": True},
        "server_operating_system_version": {"readonly": True},
        "server_database_count": {"readonly": True},
    }

    _attribute_map = {
        "server_platform": {"key": "serverPlatform", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "server_version": {"key": "serverVersion", "type": "str"},
        "server_edition": {"key": "serverEdition", "type": "str"},
        "server_operating_system_version": {"key": "serverOperatingSystemVersion", "type": "str"},
        "server_database_count": {"key": "serverDatabaseCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.server_platform: Optional[str] = None
        self.server_name: Optional[str] = None
        self.server_version: Optional[str] = None
        self.server_edition: Optional[str] = None
        self.server_operating_system_version: Optional[str] = None
        self.server_database_count: Optional[int] = None


class ServiceOperation(_serialization.Model):
    """Description of an action supported by the Azure Database Migration Service (classic).

    :ivar name: The fully qualified action name, e.g. Microsoft.DataMigration/services/read.
    :vartype name: str
    :ivar display: Localized display text.
    :vartype display: ~azure.mgmt.datamigration.models.ServiceOperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "ServiceOperationDisplay"},
    }

    def __init__(
        self, *, name: Optional[str] = None, display: Optional["_models.ServiceOperationDisplay"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The fully qualified action name, e.g. Microsoft.DataMigration/services/read.
        :paramtype name: str
        :keyword display: Localized display text.
        :paramtype display: ~azure.mgmt.datamigration.models.ServiceOperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class ServiceOperationDisplay(_serialization.Model):
    """Localized display text.

    :ivar provider: The localized resource provider name.
    :vartype provider: str
    :ivar resource: The localized resource type name.
    :vartype resource: str
    :ivar operation: The localized operation name.
    :vartype operation: str
    :ivar description: The localized operation description.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: The localized resource provider name.
        :paramtype provider: str
        :keyword resource: The localized resource type name.
        :paramtype resource: str
        :keyword operation: The localized operation name.
        :paramtype operation: str
        :keyword description: The localized operation description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ServiceOperationList(_serialization.Model):
    """OData page of action (operation) objects.

    :ivar value: List of actions.
    :vartype value: list[~azure.mgmt.datamigration.models.ServiceOperation]
    :ivar next_link: URL to load the next page of actions.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ServiceOperation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ServiceOperation"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of actions.
        :paramtype value: list[~azure.mgmt.datamigration.models.ServiceOperation]
        :keyword next_link: URL to load the next page of actions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceSku(_serialization.Model):
    """An Azure SKU instance.

    :ivar name: The unique name of the SKU, such as 'P3'.
    :vartype name: str
    :ivar tier: The tier of the SKU, such as 'Basic', 'General Purpose', or 'Business Critical'.
    :vartype tier: str
    :ivar family: The SKU family, used when the service has multiple performance classes within a
     tier, such as 'A', 'D', etc. for virtual machines.
    :vartype family: str
    :ivar size: The size of the SKU, used when the name alone does not denote a service size or
     when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines.
    :vartype size: str
    :ivar capacity: The capacity of the SKU, if it supports scaling.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        family: Optional[str] = None,
        size: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The unique name of the SKU, such as 'P3'.
        :paramtype name: str
        :keyword tier: The tier of the SKU, such as 'Basic', 'General Purpose', or 'Business Critical'.
        :paramtype tier: str
        :keyword family: The SKU family, used when the service has multiple performance classes within
         a tier, such as 'A', 'D', etc. for virtual machines.
        :paramtype family: str
        :keyword size: The size of the SKU, used when the name alone does not denote a service size or
         when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines.
        :paramtype size: str
        :keyword capacity: The capacity of the SKU, if it supports scaling.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.family = family
        self.size = size
        self.capacity = capacity


class ServiceSkuList(_serialization.Model):
    """OData page of available SKUs.

    :ivar value: List of service SKUs.
    :vartype value: list[~azure.mgmt.datamigration.models.AvailableServiceSku]
    :ivar next_link: URL to load the next page of service SKUs.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailableServiceSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AvailableServiceSku"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of service SKUs.
        :paramtype value: list[~azure.mgmt.datamigration.models.AvailableServiceSku]
        :keyword next_link: URL to load the next page of service SKUs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SourceLocation(_serialization.Model):
    """Source Location details of backups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar file_share: Source File share.
    :vartype file_share: ~azure.mgmt.datamigration.models.SqlFileShare
    :ivar azure_blob: Source Azure Blob.
    :vartype azure_blob: ~azure.mgmt.datamigration.models.AzureBlob
    :ivar file_storage_type: Backup storage Type.
    :vartype file_storage_type: str
    """

    _validation = {
        "file_storage_type": {"readonly": True},
    }

    _attribute_map = {
        "file_share": {"key": "fileShare", "type": "SqlFileShare"},
        "azure_blob": {"key": "azureBlob", "type": "AzureBlob"},
        "file_storage_type": {"key": "fileStorageType", "type": "str"},
    }

    def __init__(
        self,
        *,
        file_share: Optional["_models.SqlFileShare"] = None,
        azure_blob: Optional["_models.AzureBlob"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword file_share: Source File share.
        :paramtype file_share: ~azure.mgmt.datamigration.models.SqlFileShare
        :keyword azure_blob: Source Azure Blob.
        :paramtype azure_blob: ~azure.mgmt.datamigration.models.AzureBlob
        """
        super().__init__(**kwargs)
        self.file_share = file_share
        self.azure_blob = azure_blob
        self.file_storage_type: Optional[str] = None


class SqlBackupFileInfo(_serialization.Model):
    """Information of backup file.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar file_name: File name.
    :vartype file_name: str
    :ivar status: Status of the file. (Initial, Uploading, Uploaded, Restoring, Restored or
     Skipped).
    :vartype status: str
    :ivar total_size: File size in bytes.
    :vartype total_size: int
    :ivar data_read: Bytes read.
    :vartype data_read: int
    :ivar data_written: Bytes written.
    :vartype data_written: int
    :ivar copy_throughput: Copy throughput in KBps.
    :vartype copy_throughput: float
    :ivar copy_duration: Copy Duration in seconds.
    :vartype copy_duration: int
    :ivar family_sequence_number: Media family sequence number.
    :vartype family_sequence_number: int
    """

    _validation = {
        "file_name": {"readonly": True},
        "status": {"readonly": True},
        "total_size": {"readonly": True},
        "data_read": {"readonly": True},
        "data_written": {"readonly": True},
        "copy_throughput": {"readonly": True},
        "copy_duration": {"readonly": True},
        "family_sequence_number": {"readonly": True},
    }

    _attribute_map = {
        "file_name": {"key": "fileName", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "total_size": {"key": "totalSize", "type": "int"},
        "data_read": {"key": "dataRead", "type": "int"},
        "data_written": {"key": "dataWritten", "type": "int"},
        "copy_throughput": {"key": "copyThroughput", "type": "float"},
        "copy_duration": {"key": "copyDuration", "type": "int"},
        "family_sequence_number": {"key": "familySequenceNumber", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.file_name: Optional[str] = None
        self.status: Optional[str] = None
        self.total_size: Optional[int] = None
        self.data_read: Optional[int] = None
        self.data_written: Optional[int] = None
        self.copy_throughput: Optional[float] = None
        self.copy_duration: Optional[int] = None
        self.family_sequence_number: Optional[int] = None


class SqlBackupSetInfo(_serialization.Model):
    """Information of backup set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar backup_set_id: Backup set id.
    :vartype backup_set_id: str
    :ivar first_lsn: First LSN of the backup set.
    :vartype first_lsn: str
    :ivar last_lsn: Last LSN of the backup set.
    :vartype last_lsn: str
    :ivar backup_type: Backup type.
    :vartype backup_type: str
    :ivar list_of_backup_files: List of files in the backup set.
    :vartype list_of_backup_files: list[~azure.mgmt.datamigration.models.SqlBackupFileInfo]
    :ivar backup_start_date: Backup start date.
    :vartype backup_start_date: ~datetime.datetime
    :ivar backup_finish_date: Backup end time.
    :vartype backup_finish_date: ~datetime.datetime
    :ivar is_backup_restored: Whether this backup set has been restored or not.
    :vartype is_backup_restored: bool
    :ivar has_backup_checksums: Has Backup Checksums.
    :vartype has_backup_checksums: bool
    :ivar family_count: Media family count.
    :vartype family_count: int
    :ivar ignore_reasons: The reasons why the backup set is ignored.
    :vartype ignore_reasons: list[str]
    """

    _validation = {
        "backup_set_id": {"readonly": True},
        "first_lsn": {"readonly": True},
        "last_lsn": {"readonly": True},
        "backup_type": {"readonly": True},
        "list_of_backup_files": {"readonly": True},
        "backup_start_date": {"readonly": True},
        "backup_finish_date": {"readonly": True},
        "is_backup_restored": {"readonly": True},
        "has_backup_checksums": {"readonly": True},
        "family_count": {"readonly": True},
        "ignore_reasons": {"readonly": True},
    }

    _attribute_map = {
        "backup_set_id": {"key": "backupSetId", "type": "str"},
        "first_lsn": {"key": "firstLSN", "type": "str"},
        "last_lsn": {"key": "lastLSN", "type": "str"},
        "backup_type": {"key": "backupType", "type": "str"},
        "list_of_backup_files": {"key": "listOfBackupFiles", "type": "[SqlBackupFileInfo]"},
        "backup_start_date": {"key": "backupStartDate", "type": "iso-8601"},
        "backup_finish_date": {"key": "backupFinishDate", "type": "iso-8601"},
        "is_backup_restored": {"key": "isBackupRestored", "type": "bool"},
        "has_backup_checksums": {"key": "hasBackupChecksums", "type": "bool"},
        "family_count": {"key": "familyCount", "type": "int"},
        "ignore_reasons": {"key": "ignoreReasons", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.backup_set_id: Optional[str] = None
        self.first_lsn: Optional[str] = None
        self.last_lsn: Optional[str] = None
        self.backup_type: Optional[str] = None
        self.list_of_backup_files: Optional[List["_models.SqlBackupFileInfo"]] = None
        self.backup_start_date: Optional[datetime.datetime] = None
        self.backup_finish_date: Optional[datetime.datetime] = None
        self.is_backup_restored: Optional[bool] = None
        self.has_backup_checksums: Optional[bool] = None
        self.family_count: Optional[int] = None
        self.ignore_reasons: Optional[List[str]] = None


class SqlConnectionInfo(ConnectionInfo):
    """Information for connecting to SQL database server.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of connection info. Required.
    :vartype type: str
    :ivar user_name: User name.
    :vartype user_name: str
    :ivar password: Password credential.
    :vartype password: str
    :ivar data_source: Data source in the format
     Protocol:MachineName\\SQLServerInstanceName,PortNumber. Required.
    :vartype data_source: str
    :ivar server_name: name of the server.
    :vartype server_name: str
    :ivar port: Port for Server.
    :vartype port: int
    :ivar server_version: server version.
    :vartype server_version: str
    :ivar server_brand_version: server brand version.
    :vartype server_brand_version: str
    :ivar resource_id: Represents the ID of an HTTP resource represented by an Azure resource
     provider.
    :vartype resource_id: str
    :ivar authentication: Authentication type to use for connection. Known values are: "None",
     "WindowsAuthentication", "SqlAuthentication", "ActiveDirectoryIntegrated", and
     "ActiveDirectoryPassword".
    :vartype authentication: str or ~azure.mgmt.datamigration.models.AuthenticationType
    :ivar encrypt_connection: Whether to encrypt the connection.
    :vartype encrypt_connection: bool
    :ivar additional_settings: Additional connection settings.
    :vartype additional_settings: str
    :ivar trust_server_certificate: Whether to trust the server certificate.
    :vartype trust_server_certificate: bool
    :ivar platform: Server platform type for connection. "SqlOnPrem"
    :vartype platform: str or ~azure.mgmt.datamigration.models.SqlSourcePlatform
    """

    _validation = {
        "type": {"required": True},
        "data_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "data_source": {"key": "dataSource", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "server_version": {"key": "serverVersion", "type": "str"},
        "server_brand_version": {"key": "serverBrandVersion", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "authentication": {"key": "authentication", "type": "str"},
        "encrypt_connection": {"key": "encryptConnection", "type": "bool"},
        "additional_settings": {"key": "additionalSettings", "type": "str"},
        "trust_server_certificate": {"key": "trustServerCertificate", "type": "bool"},
        "platform": {"key": "platform", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_source: str,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        server_name: Optional[str] = None,
        port: Optional[int] = None,
        server_version: Optional[str] = None,
        server_brand_version: Optional[str] = None,
        resource_id: Optional[str] = None,
        authentication: Optional[Union[str, "_models.AuthenticationType"]] = None,
        encrypt_connection: bool = True,
        additional_settings: Optional[str] = None,
        trust_server_certificate: bool = False,
        platform: Optional[Union[str, "_models.SqlSourcePlatform"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_name: User name.
        :paramtype user_name: str
        :keyword password: Password credential.
        :paramtype password: str
        :keyword data_source: Data source in the format
         Protocol:MachineName\\SQLServerInstanceName,PortNumber. Required.
        :paramtype data_source: str
        :keyword server_name: name of the server.
        :paramtype server_name: str
        :keyword port: Port for Server.
        :paramtype port: int
        :keyword server_version: server version.
        :paramtype server_version: str
        :keyword server_brand_version: server brand version.
        :paramtype server_brand_version: str
        :keyword resource_id: Represents the ID of an HTTP resource represented by an Azure resource
         provider.
        :paramtype resource_id: str
        :keyword authentication: Authentication type to use for connection. Known values are: "None",
         "WindowsAuthentication", "SqlAuthentication", "ActiveDirectoryIntegrated", and
         "ActiveDirectoryPassword".
        :paramtype authentication: str or ~azure.mgmt.datamigration.models.AuthenticationType
        :keyword encrypt_connection: Whether to encrypt the connection.
        :paramtype encrypt_connection: bool
        :keyword additional_settings: Additional connection settings.
        :paramtype additional_settings: str
        :keyword trust_server_certificate: Whether to trust the server certificate.
        :paramtype trust_server_certificate: bool
        :keyword platform: Server platform type for connection. "SqlOnPrem"
        :paramtype platform: str or ~azure.mgmt.datamigration.models.SqlSourcePlatform
        """
        super().__init__(user_name=user_name, password=password, **kwargs)
        self.type: str = "SqlConnectionInfo"
        self.data_source = data_source
        self.server_name = server_name
        self.port = port
        self.server_version = server_version
        self.server_brand_version = server_brand_version
        self.resource_id = resource_id
        self.authentication = authentication
        self.encrypt_connection = encrypt_connection
        self.additional_settings = additional_settings
        self.trust_server_certificate = trust_server_certificate
        self.platform = platform


class SqlConnectionInformation(_serialization.Model):
    """Source SQL Connection.

    :ivar data_source: Data source.
    :vartype data_source: str
    :ivar authentication: Authentication type.
    :vartype authentication: str
    :ivar user_name: User name to connect to source SQL.
    :vartype user_name: str
    :ivar password: Password to connect to source SQL.
    :vartype password: str
    :ivar encrypt_connection: Whether to encrypt connection or not.
    :vartype encrypt_connection: bool
    :ivar trust_server_certificate: Whether to trust server certificate or not.
    :vartype trust_server_certificate: bool
    """

    _attribute_map = {
        "data_source": {"key": "dataSource", "type": "str"},
        "authentication": {"key": "authentication", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "encrypt_connection": {"key": "encryptConnection", "type": "bool"},
        "trust_server_certificate": {"key": "trustServerCertificate", "type": "bool"},
    }

    def __init__(
        self,
        *,
        data_source: Optional[str] = None,
        authentication: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        encrypt_connection: Optional[bool] = None,
        trust_server_certificate: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword data_source: Data source.
        :paramtype data_source: str
        :keyword authentication: Authentication type.
        :paramtype authentication: str
        :keyword user_name: User name to connect to source SQL.
        :paramtype user_name: str
        :keyword password: Password to connect to source SQL.
        :paramtype password: str
        :keyword encrypt_connection: Whether to encrypt connection or not.
        :paramtype encrypt_connection: bool
        :keyword trust_server_certificate: Whether to trust server certificate or not.
        :paramtype trust_server_certificate: bool
        """
        super().__init__(**kwargs)
        self.data_source = data_source
        self.authentication = authentication
        self.user_name = user_name
        self.password = password
        self.encrypt_connection = encrypt_connection
        self.trust_server_certificate = trust_server_certificate


class SqlDbMigrationStatusDetails(_serialization.Model):
    """Detailed status of current Sql Db migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar migration_state: Current State of Migration.
    :vartype migration_state: str
    :ivar sql_data_copy_errors: Sql Data Copy errors, if any.
    :vartype sql_data_copy_errors: list[str]
    :ivar list_of_copy_progress_details: Details on progress of ADF copy activities.
    :vartype list_of_copy_progress_details:
     list[~azure.mgmt.datamigration.models.CopyProgressDetails]
    """

    _validation = {
        "migration_state": {"readonly": True},
        "sql_data_copy_errors": {"readonly": True},
        "list_of_copy_progress_details": {"readonly": True},
    }

    _attribute_map = {
        "migration_state": {"key": "migrationState", "type": "str"},
        "sql_data_copy_errors": {"key": "sqlDataCopyErrors", "type": "[str]"},
        "list_of_copy_progress_details": {"key": "listOfCopyProgressDetails", "type": "[CopyProgressDetails]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.migration_state: Optional[str] = None
        self.sql_data_copy_errors: Optional[List[str]] = None
        self.list_of_copy_progress_details: Optional[List["_models.CopyProgressDetails"]] = None


class SqlDbOfflineConfiguration(_serialization.Model):
    """Offline configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar offline: Offline migration.
    :vartype offline: bool
    """

    _validation = {
        "offline": {"readonly": True},
    }

    _attribute_map = {
        "offline": {"key": "offline", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offline: Optional[bool] = None


class SqlFileShare(_serialization.Model):
    """File share.

    :ivar path: Location as SMB share or local drive where backups are placed.
    :vartype path: str
    :ivar username: Username to access the file share location for backups.
    :vartype username: str
    :ivar password: Password for username to access file share location.
    :vartype password: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: Location as SMB share or local drive where backups are placed.
        :paramtype path: str
        :keyword username: Username to access the file share location for backups.
        :paramtype username: str
        :keyword password: Password for username to access file share location.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.path = path
        self.username = username
        self.password = password


class SqlMigrationListResult(_serialization.Model):
    """A list of SQL Migration Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.datamigration.models.SqlMigrationService]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlMigrationService]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SqlMigrationService"]] = None
        self.next_link: Optional[str] = None


class SqlMigrationService(TrackedResourceAutoGenerated):
    """A SQL Migration Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location:
    :vartype location: str
    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar system_data:
    :vartype system_data: ~azure.mgmt.datamigration.models.SystemDataAutoGenerated
    :ivar provisioning_state: Provisioning state to track the async operation status.
    :vartype provisioning_state: str
    :ivar integration_runtime_state: Current state of the Integration runtime.
    :vartype integration_runtime_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "integration_runtime_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemDataAutoGenerated"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "integration_runtime_state": {"key": "properties.integrationRuntimeState", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location:
        :paramtype location: str
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state: Optional[str] = None
        self.integration_runtime_state: Optional[str] = None


class SqlMigrationServiceUpdate(_serialization.Model):
    """An update to a SQL Migration Service.

    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class SsisMigrationInfo(_serialization.Model):
    """SSIS migration info with SSIS store type, overwrite policy.

    :ivar ssis_store_type: The SSIS store type of source, only SSIS catalog is supported now in DMS
     (classic). "SsisCatalog"
    :vartype ssis_store_type: str or ~azure.mgmt.datamigration.models.SsisStoreType
    :ivar project_overwrite_option: The overwrite option for the SSIS project migration. Known
     values are: "Ignore" and "Overwrite".
    :vartype project_overwrite_option: str or
     ~azure.mgmt.datamigration.models.SsisMigrationOverwriteOption
    :ivar environment_overwrite_option: The overwrite option for the SSIS environment migration.
     Known values are: "Ignore" and "Overwrite".
    :vartype environment_overwrite_option: str or
     ~azure.mgmt.datamigration.models.SsisMigrationOverwriteOption
    """

    _attribute_map = {
        "ssis_store_type": {"key": "ssisStoreType", "type": "str"},
        "project_overwrite_option": {"key": "projectOverwriteOption", "type": "str"},
        "environment_overwrite_option": {"key": "environmentOverwriteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        ssis_store_type: Optional[Union[str, "_models.SsisStoreType"]] = None,
        project_overwrite_option: Optional[Union[str, "_models.SsisMigrationOverwriteOption"]] = None,
        environment_overwrite_option: Optional[Union[str, "_models.SsisMigrationOverwriteOption"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ssis_store_type: The SSIS store type of source, only SSIS catalog is supported now in
         DMS (classic). "SsisCatalog"
        :paramtype ssis_store_type: str or ~azure.mgmt.datamigration.models.SsisStoreType
        :keyword project_overwrite_option: The overwrite option for the SSIS project migration. Known
         values are: "Ignore" and "Overwrite".
        :paramtype project_overwrite_option: str or
         ~azure.mgmt.datamigration.models.SsisMigrationOverwriteOption
        :keyword environment_overwrite_option: The overwrite option for the SSIS environment migration.
         Known values are: "Ignore" and "Overwrite".
        :paramtype environment_overwrite_option: str or
         ~azure.mgmt.datamigration.models.SsisMigrationOverwriteOption
        """
        super().__init__(**kwargs)
        self.ssis_store_type = ssis_store_type
        self.project_overwrite_option = project_overwrite_option
        self.environment_overwrite_option = environment_overwrite_option


class StartMigrationScenarioServerRoleResult(_serialization.Model):
    """Server role migration result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of server role.
    :vartype name: str
    :ivar state: Current state of migration. Known values are: "None", "InProgress", "Failed",
     "Warning", "Completed", "Skipped", and "Stopped".
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar exceptions_and_warnings: Migration exceptions and warnings.
    :vartype exceptions_and_warnings: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "name": {"readonly": True},
        "state": {"readonly": True},
        "exceptions_and_warnings": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "exceptions_and_warnings": {"key": "exceptionsAndWarnings", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.state: Optional[Union[str, "_models.MigrationState"]] = None
        self.exceptions_and_warnings: Optional[List["_models.ReportableException"]] = None


class SyncMigrationDatabaseErrorEvent(_serialization.Model):
    """Database migration errors for online migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp_string: String value of timestamp.
    :vartype timestamp_string: str
    :ivar event_type_string: Event type.
    :vartype event_type_string: str
    :ivar event_text: Event text.
    :vartype event_text: str
    """

    _validation = {
        "timestamp_string": {"readonly": True},
        "event_type_string": {"readonly": True},
        "event_text": {"readonly": True},
    }

    _attribute_map = {
        "timestamp_string": {"key": "timestampString", "type": "str"},
        "event_type_string": {"key": "eventTypeString", "type": "str"},
        "event_text": {"key": "eventText", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.timestamp_string: Optional[str] = None
        self.event_type_string: Optional[str] = None
        self.event_text: Optional[str] = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.datamigration.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.datamigration.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.datamigration.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.datamigration.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class SystemDataAutoGenerated(_serialization.Model):
    """SystemDataAutoGenerated.

    :ivar created_by:
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.datamigration.models.CreatedByType
    :ivar created_at:
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by:
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.datamigration.models.CreatedByType
    :ivar last_modified_at:
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by:
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.datamigration.models.CreatedByType
        :keyword created_at:
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by:
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that created the resource. Known values
         are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.datamigration.models.CreatedByType
        :keyword last_modified_at:
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TargetLocation(_serialization.Model):
    """Target Location details for optional copy of backups.

    :ivar storage_account_resource_id: Resource Id of the storage account copying backups.
    :vartype storage_account_resource_id: str
    :ivar account_key: Storage Account Key.
    :vartype account_key: str
    """

    _attribute_map = {
        "storage_account_resource_id": {"key": "storageAccountResourceId", "type": "str"},
        "account_key": {"key": "accountKey", "type": "str"},
    }

    def __init__(
        self, *, storage_account_resource_id: Optional[str] = None, account_key: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword storage_account_resource_id: Resource Id of the storage account copying backups.
        :paramtype storage_account_resource_id: str
        :keyword account_key: Storage Account Key.
        :paramtype account_key: str
        """
        super().__init__(**kwargs)
        self.storage_account_resource_id = storage_account_resource_id
        self.account_key = account_key


class TaskList(_serialization.Model):
    """OData page of tasks.

    :ivar value: List of tasks.
    :vartype value: list[~azure.mgmt.datamigration.models.ProjectTask]
    :ivar next_link: URL to load the next page of tasks.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ProjectTask]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ProjectTask"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of tasks.
        :paramtype value: list[~azure.mgmt.datamigration.models.ProjectTask]
        :keyword next_link: URL to load the next page of tasks.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UploadOCIDriverTaskInput(_serialization.Model):
    """Input for the service task to upload an OCI driver.

    :ivar driver_share: File share information for the OCI driver archive.
    :vartype driver_share: ~azure.mgmt.datamigration.models.FileShare
    """

    _attribute_map = {
        "driver_share": {"key": "driverShare", "type": "FileShare"},
    }

    def __init__(self, *, driver_share: Optional["_models.FileShare"] = None, **kwargs: Any) -> None:
        """
        :keyword driver_share: File share information for the OCI driver archive.
        :paramtype driver_share: ~azure.mgmt.datamigration.models.FileShare
        """
        super().__init__(**kwargs)
        self.driver_share = driver_share


class UploadOCIDriverTaskOutput(_serialization.Model):
    """Output for the service task to upload an OCI driver.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar driver_package_name: The name of the driver package that was validated and uploaded.
    :vartype driver_package_name: str
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "driver_package_name": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "driver_package_name": {"key": "driverPackageName", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.driver_package_name: Optional[str] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class UploadOCIDriverTaskProperties(ProjectTaskProperties):
    """Properties for the task that uploads an OCI driver.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Input for the service task to upload an OCI driver.
    :vartype input: ~azure.mgmt.datamigration.models.UploadOCIDriverTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output: list[~azure.mgmt.datamigration.models.UploadOCIDriverTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "UploadOCIDriverTaskInput"},
        "output": {"key": "output", "type": "[UploadOCIDriverTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.UploadOCIDriverTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Input for the service task to upload an OCI driver.
        :paramtype input: ~azure.mgmt.datamigration.models.UploadOCIDriverTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Service.Upload.OCI"
        self.input = input
        self.output: Optional[List["_models.UploadOCIDriverTaskOutput"]] = None


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class ValidateMigrationInputSqlServerSqlDbSyncTaskProperties(ProjectTaskProperties):  # pylint: disable=name-too-long
    """Properties for task that validates migration input for SQL to Azure SQL DB sync migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.ValidateSyncMigrationInputSqlServerTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.ValidateSyncMigrationInputSqlServerTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ValidateSyncMigrationInputSqlServerTaskInput"},
        "output": {"key": "output", "type": "[ValidateSyncMigrationInputSqlServerTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ValidateSyncMigrationInputSqlServerTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input: ~azure.mgmt.datamigration.models.ValidateSyncMigrationInputSqlServerTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ValidateMigrationInput.SqlServer.SqlDb.Sync"
        self.input = input
        self.output: Optional[List["_models.ValidateSyncMigrationInputSqlServerTaskOutput"]] = None


class ValidateMigrationInputSqlServerSqlMISyncTaskInput(SqlServerSqlMISyncTaskInput):  # pylint: disable=name-too-long
    """Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online
    scenario.

    All required parameters must be populated in order to send to server.

    :ivar selected_databases: Databases to migrate. Required.
    :vartype selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMIDatabaseInput]
    :ivar backup_file_share: Backup file share information for all selected databases.
    :vartype backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :ivar storage_resource_id: Fully qualified resourceId of storage. Required.
    :vartype storage_resource_id: str
    :ivar source_connection_info: Connection information for source SQL Server. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar target_connection_info: Connection information for Azure SQL Database Managed Instance.
     Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.MiSqlConnectionInfo
    :ivar azure_app: Azure Active Directory Application the DMS (classic) instance will use to
     connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage
     Account. Required.
    :vartype azure_app: ~azure.mgmt.datamigration.models.AzureActiveDirectoryApp
    """


class ValidateMigrationInputSqlServerSqlMISyncTaskOutput(_serialization.Model):  # pylint: disable=name-too-long
    """Output for task that validates migration input for Azure SQL Database Managed Instance online
    migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Database identifier.
    :vartype id: str
    :ivar name: Name of database.
    :vartype name: str
    :ivar validation_errors: Errors associated with a selected database object.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class ValidateMigrationInputSqlServerSqlMISyncTaskProperties(ProjectTaskProperties):  # pylint: disable=name-too-long
    """Properties for task that validates migration input for SQL to Azure SQL Database Managed
    Instance sync scenario.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input:
     ~azure.mgmt.datamigration.models.ValidateMigrationInputSqlServerSqlMISyncTaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.ValidateMigrationInputSqlServerSqlMISyncTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ValidateMigrationInputSqlServerSqlMISyncTaskInput"},
        "output": {"key": "output", "type": "[ValidateMigrationInputSqlServerSqlMISyncTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ValidateMigrationInputSqlServerSqlMISyncTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input:
         ~azure.mgmt.datamigration.models.ValidateMigrationInputSqlServerSqlMISyncTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS"
        self.input = input
        self.output: Optional[List["_models.ValidateMigrationInputSqlServerSqlMISyncTaskOutput"]] = None


class ValidateMigrationInputSqlServerSqlMITaskInput(_serialization.Model):  # pylint: disable=name-too-long
    """Input for task that validates migration input for SQL to Azure SQL Managed Instance.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Information for connecting to source. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar target_connection_info: Information for connecting to target. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar selected_databases: Databases to migrate. Required.
    :vartype selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMIDatabaseInput]
    :ivar selected_logins: Logins to migrate.
    :vartype selected_logins: list[str]
    :ivar backup_file_share: Backup file share information for all selected databases.
    :vartype backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :ivar backup_blob_share: SAS URI of Azure Storage Account Container to be used for storing
     backup files. Required.
    :vartype backup_blob_share: ~azure.mgmt.datamigration.models.BlobShare
    :ivar backup_mode: Backup Mode to specify whether to use existing backup or create new backup.
     Known values are: "CreateBackup" and "ExistingBackup".
    :vartype backup_mode: str or ~azure.mgmt.datamigration.models.BackupMode
    """

    _validation = {
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
        "selected_databases": {"required": True},
        "backup_blob_share": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "SqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "SqlConnectionInfo"},
        "selected_databases": {"key": "selectedDatabases", "type": "[MigrateSqlServerSqlMIDatabaseInput]"},
        "selected_logins": {"key": "selectedLogins", "type": "[str]"},
        "backup_file_share": {"key": "backupFileShare", "type": "FileShare"},
        "backup_blob_share": {"key": "backupBlobShare", "type": "BlobShare"},
        "backup_mode": {"key": "backupMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.SqlConnectionInfo",
        target_connection_info: "_models.SqlConnectionInfo",
        selected_databases: List["_models.MigrateSqlServerSqlMIDatabaseInput"],
        backup_blob_share: "_models.BlobShare",
        selected_logins: Optional[List[str]] = None,
        backup_file_share: Optional["_models.FileShare"] = None,
        backup_mode: Optional[Union[str, "_models.BackupMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Information for connecting to source. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword target_connection_info: Information for connecting to target. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword selected_databases: Databases to migrate. Required.
        :paramtype selected_databases:
         list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlMIDatabaseInput]
        :keyword selected_logins: Logins to migrate.
        :paramtype selected_logins: list[str]
        :keyword backup_file_share: Backup file share information for all selected databases.
        :paramtype backup_file_share: ~azure.mgmt.datamigration.models.FileShare
        :keyword backup_blob_share: SAS URI of Azure Storage Account Container to be used for storing
         backup files. Required.
        :paramtype backup_blob_share: ~azure.mgmt.datamigration.models.BlobShare
        :keyword backup_mode: Backup Mode to specify whether to use existing backup or create new
         backup. Known values are: "CreateBackup" and "ExistingBackup".
        :paramtype backup_mode: str or ~azure.mgmt.datamigration.models.BackupMode
        """
        super().__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info
        self.selected_databases = selected_databases
        self.selected_logins = selected_logins
        self.backup_file_share = backup_file_share
        self.backup_blob_share = backup_blob_share
        self.backup_mode = backup_mode


class ValidateMigrationInputSqlServerSqlMITaskOutput(_serialization.Model):  # pylint: disable=name-too-long
    """Output for task that validates migration input for SQL to Azure SQL Managed Instance
    migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Result identifier.
    :vartype id: str
    :ivar name: Name of database.
    :vartype name: str
    :ivar restore_database_name_errors: Errors associated with the RestoreDatabaseName.
    :vartype restore_database_name_errors:
     list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar backup_folder_errors: Errors associated with the BackupFolder path.
    :vartype backup_folder_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar backup_share_credentials_errors: Errors associated with backup share user name and
     password credentials.
    :vartype backup_share_credentials_errors:
     list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar backup_storage_account_errors: Errors associated with the storage account provided.
    :vartype backup_storage_account_errors:
     list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar existing_backup_errors: Errors associated with existing backup files.
    :vartype existing_backup_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    :ivar database_backup_info: Information about backup files when existing backup mode is used.
    :vartype database_backup_info: ~azure.mgmt.datamigration.models.DatabaseBackupInfo
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "restore_database_name_errors": {"readonly": True},
        "backup_folder_errors": {"readonly": True},
        "backup_share_credentials_errors": {"readonly": True},
        "backup_storage_account_errors": {"readonly": True},
        "existing_backup_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "restore_database_name_errors": {"key": "restoreDatabaseNameErrors", "type": "[ReportableException]"},
        "backup_folder_errors": {"key": "backupFolderErrors", "type": "[ReportableException]"},
        "backup_share_credentials_errors": {"key": "backupShareCredentialsErrors", "type": "[ReportableException]"},
        "backup_storage_account_errors": {"key": "backupStorageAccountErrors", "type": "[ReportableException]"},
        "existing_backup_errors": {"key": "existingBackupErrors", "type": "[ReportableException]"},
        "database_backup_info": {"key": "databaseBackupInfo", "type": "DatabaseBackupInfo"},
    }

    def __init__(self, *, database_backup_info: Optional["_models.DatabaseBackupInfo"] = None, **kwargs: Any) -> None:
        """
        :keyword database_backup_info: Information about backup files when existing backup mode is
         used.
        :paramtype database_backup_info: ~azure.mgmt.datamigration.models.DatabaseBackupInfo
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.restore_database_name_errors: Optional[List["_models.ReportableException"]] = None
        self.backup_folder_errors: Optional[List["_models.ReportableException"]] = None
        self.backup_share_credentials_errors: Optional[List["_models.ReportableException"]] = None
        self.backup_storage_account_errors: Optional[List["_models.ReportableException"]] = None
        self.existing_backup_errors: Optional[List["_models.ReportableException"]] = None
        self.database_backup_info = database_backup_info


class ValidateMigrationInputSqlServerSqlMITaskProperties(ProjectTaskProperties):  # pylint: disable=name-too-long
    """Properties for task that validates migration input for SQL to Azure SQL Database Managed
    Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Task input.
    :vartype input: ~azure.mgmt.datamigration.models.ValidateMigrationInputSqlServerSqlMITaskInput
    :ivar output: Task output. This is ignored if submitted.
    :vartype output:
     list[~azure.mgmt.datamigration.models.ValidateMigrationInputSqlServerSqlMITaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "ValidateMigrationInputSqlServerSqlMITaskInput"},
        "output": {"key": "output", "type": "[ValidateMigrationInputSqlServerSqlMITaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.ValidateMigrationInputSqlServerSqlMITaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Task input.
        :paramtype input:
         ~azure.mgmt.datamigration.models.ValidateMigrationInputSqlServerSqlMITaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "ValidateMigrationInput.SqlServer.AzureSqlDbMI"
        self.input = input
        self.output: Optional[List["_models.ValidateMigrationInputSqlServerSqlMITaskOutput"]] = None


class ValidateMongoDbTaskProperties(ProjectTaskProperties):
    """Properties for the task that validates a migration between MongoDB data sources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Describes how a MongoDB data migration should be performed.
    :vartype input: ~azure.mgmt.datamigration.models.MongoDbMigrationSettings
    :ivar output: An array containing a single MongoDbMigrationProgress object.
    :vartype output: list[~azure.mgmt.datamigration.models.MongoDbMigrationProgress]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "MongoDbMigrationSettings"},
        "output": {"key": "output", "type": "[MongoDbMigrationProgress]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.MongoDbMigrationSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Describes how a MongoDB data migration should be performed.
        :paramtype input: ~azure.mgmt.datamigration.models.MongoDbMigrationSettings
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Validate.MongoDb"
        self.input = input
        self.output: Optional[List["_models.MongoDbMigrationProgress"]] = None


class ValidateOracleAzureDbForPostgreSqlSyncTaskProperties(ProjectTaskProperties):  # pylint: disable=name-too-long
    """Properties for the task that validates a migration for Oracle to Azure Database for PostgreSQL
    for online migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_type: Task type. Required. Known values are: "Connect.MongoDb",
     "ConnectToSource.SqlServer", "ConnectToSource.SqlServer.Sync",
     "ConnectToSource.PostgreSql.Sync", "ConnectToSource.MySql", "ConnectToSource.Oracle.Sync",
     "ConnectToTarget.SqlDb", "ConnectToTarget.SqlDb.Sync",
     "ConnectToTarget.AzureDbForPostgreSql.Sync",
     "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync", "ConnectToTarget.AzureSqlDbMI",
     "ConnectToTarget.AzureSqlDbMI.Sync.LRS", "ConnectToTarget.AzureDbForMySql",
     "GetUserTables.Sql", "GetUserTables.AzureSqlDb.Sync", "GetUserTablesOracle",
     "GetUserTablesPostgreSql", "GetUserTablesMySql", "Migrate.MongoDb",
     "Migrate.SqlServer.AzureSqlDbMI", "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS",
     "Migrate.SqlServer.SqlDb", "Migrate.SqlServer.AzureSqlDb.Sync",
     "Migrate.MySql.AzureDbForMySql.Sync", "Migrate.MySql.AzureDbForMySql",
     "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2", "Migrate.Oracle.AzureDbForPostgreSql.Sync",
     "ValidateMigrationInput.SqlServer.SqlDb.Sync", "ValidateMigrationInput.SqlServer.AzureSqlDbMI",
     "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS", "Validate.MongoDb",
     "Validate.Oracle.AzureDbPostgreSql.Sync", "GetTDECertificates.Sql", "Migrate.Ssis",
     "Service.Check.OCI", "Service.Upload.OCI", "Service.Install.OCI", and
     "MigrateSchemaSqlServerSqlDb".
    :vartype task_type: str or ~azure.mgmt.datamigration.models.TaskType
    :ivar errors: Array of errors. This is ignored if submitted.
    :vartype errors: list[~azure.mgmt.datamigration.models.ODataError]
    :ivar state: The state of the task. This is ignored if submitted. Known values are: "Unknown",
     "Queued", "Running", "Canceled", "Succeeded", "Failed", "FailedInputValidation", and "Faulted".
    :vartype state: str or ~azure.mgmt.datamigration.models.TaskState
    :ivar commands: Array of command properties.
    :vartype commands: list[~azure.mgmt.datamigration.models.CommandProperties]
    :ivar client_data: Key value pairs of client data to attach meta data information to task.
    :vartype client_data: dict[str, str]
    :ivar input: Input for the task that migrates Oracle databases to Azure Database for PostgreSQL
     for online migrations.
    :vartype input: ~azure.mgmt.datamigration.models.MigrateOracleAzureDbPostgreSqlSyncTaskInput
    :ivar output: An array containing a single validation error response object.
    :vartype output:
     list[~azure.mgmt.datamigration.models.ValidateOracleAzureDbPostgreSqlSyncTaskOutput]
    """

    _validation = {
        "task_type": {"required": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "commands": {"readonly": True},
        "output": {"readonly": True},
    }

    _attribute_map = {
        "task_type": {"key": "taskType", "type": "str"},
        "errors": {"key": "errors", "type": "[ODataError]"},
        "state": {"key": "state", "type": "str"},
        "commands": {"key": "commands", "type": "[CommandProperties]"},
        "client_data": {"key": "clientData", "type": "{str}"},
        "input": {"key": "input", "type": "MigrateOracleAzureDbPostgreSqlSyncTaskInput"},
        "output": {"key": "output", "type": "[ValidateOracleAzureDbPostgreSqlSyncTaskOutput]"},
    }

    def __init__(
        self,
        *,
        client_data: Optional[Dict[str, str]] = None,
        input: Optional["_models.MigrateOracleAzureDbPostgreSqlSyncTaskInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_data: Key value pairs of client data to attach meta data information to task.
        :paramtype client_data: dict[str, str]
        :keyword input: Input for the task that migrates Oracle databases to Azure Database for
         PostgreSQL for online migrations.
        :paramtype input: ~azure.mgmt.datamigration.models.MigrateOracleAzureDbPostgreSqlSyncTaskInput
        """
        super().__init__(client_data=client_data, **kwargs)
        self.task_type: str = "Validate.Oracle.AzureDbPostgreSql.Sync"
        self.input = input
        self.output: Optional[List["_models.ValidateOracleAzureDbPostgreSqlSyncTaskOutput"]] = None


class ValidateOracleAzureDbPostgreSqlSyncTaskOutput(_serialization.Model):  # pylint: disable=name-too-long
    """Output for task that validates migration input for Oracle to Azure Database for PostgreSQL for
    online migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar validation_errors: Errors associated with a selected database object.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class ValidateSyncMigrationInputSqlServerTaskInput(_serialization.Model):  # pylint: disable=name-too-long
    """Input for task that validates migration input for SQL sync migrations.

    All required parameters must be populated in order to send to server.

    :ivar source_connection_info: Information for connecting to source SQL server. Required.
    :vartype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar target_connection_info: Information for connecting to target. Required.
    :vartype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :ivar selected_databases: Databases to migrate. Required.
    :vartype selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbSyncDatabaseInput]
    """

    _validation = {
        "source_connection_info": {"required": True},
        "target_connection_info": {"required": True},
        "selected_databases": {"required": True},
    }

    _attribute_map = {
        "source_connection_info": {"key": "sourceConnectionInfo", "type": "SqlConnectionInfo"},
        "target_connection_info": {"key": "targetConnectionInfo", "type": "SqlConnectionInfo"},
        "selected_databases": {"key": "selectedDatabases", "type": "[MigrateSqlServerSqlDbSyncDatabaseInput]"},
    }

    def __init__(
        self,
        *,
        source_connection_info: "_models.SqlConnectionInfo",
        target_connection_info: "_models.SqlConnectionInfo",
        selected_databases: List["_models.MigrateSqlServerSqlDbSyncDatabaseInput"],
        **kwargs: Any
    ) -> None:
        """
        :keyword source_connection_info: Information for connecting to source SQL server. Required.
        :paramtype source_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword target_connection_info: Information for connecting to target. Required.
        :paramtype target_connection_info: ~azure.mgmt.datamigration.models.SqlConnectionInfo
        :keyword selected_databases: Databases to migrate. Required.
        :paramtype selected_databases:
         list[~azure.mgmt.datamigration.models.MigrateSqlServerSqlDbSyncDatabaseInput]
        """
        super().__init__(**kwargs)
        self.source_connection_info = source_connection_info
        self.target_connection_info = target_connection_info
        self.selected_databases = selected_databases


class ValidateSyncMigrationInputSqlServerTaskOutput(_serialization.Model):  # pylint: disable=name-too-long
    """Output for task that validates migration input for SQL sync migrations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Database identifier.
    :vartype id: str
    :ivar name: Name of database.
    :vartype name: str
    :ivar validation_errors: Errors associated with a selected database object.
    :vartype validation_errors: list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "validation_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[ReportableException]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.validation_errors: Optional[List["_models.ReportableException"]] = None


class ValidationError(_serialization.Model):
    """Description about the errors happen while performing migration validation.

    :ivar text: Error Text.
    :vartype text: str
    :ivar severity: Severity of the error. Known values are: "Message", "Warning", and "Error".
    :vartype severity: str or ~azure.mgmt.datamigration.models.Severity
    """

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
    }

    def __init__(
        self, *, text: Optional[str] = None, severity: Optional[Union[str, "_models.Severity"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword text: Error Text.
        :paramtype text: str
        :keyword severity: Severity of the error. Known values are: "Message", "Warning", and "Error".
        :paramtype severity: str or ~azure.mgmt.datamigration.models.Severity
        """
        super().__init__(**kwargs)
        self.text = text
        self.severity = severity


class WaitStatistics(_serialization.Model):
    """Wait statistics gathered during query batch execution.

    :ivar wait_type: Type of the Wait.
    :vartype wait_type: str
    :ivar wait_time_ms: Total wait time in millisecond(s).
    :vartype wait_time_ms: float
    :ivar wait_count: Total no. of waits.
    :vartype wait_count: int
    """

    _attribute_map = {
        "wait_type": {"key": "waitType", "type": "str"},
        "wait_time_ms": {"key": "waitTimeMs", "type": "float"},
        "wait_count": {"key": "waitCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        wait_type: Optional[str] = None,
        wait_time_ms: float = 0,
        wait_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword wait_type: Type of the Wait.
        :paramtype wait_type: str
        :keyword wait_time_ms: Total wait time in millisecond(s).
        :paramtype wait_time_ms: float
        :keyword wait_count: Total no. of waits.
        :paramtype wait_count: int
        """
        super().__init__(**kwargs)
        self.wait_type = wait_type
        self.wait_time_ms = wait_time_ms
        self.wait_count = wait_count
