# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.durabletask.aio import DurableTaskMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDurableTaskMgmtTaskHubsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DurableTaskMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_task_hubs_get(self, resource_group):
        response = await self.client.task_hubs.get(
            resource_group_name=resource_group.name,
            scheduler_name="str",
            task_hub_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_task_hubs_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.task_hubs.begin_create_or_update(
                resource_group_name=resource_group.name,
                scheduler_name="str",
                task_hub_name="str",
                resource={
                    "id": "str",
                    "name": "str",
                    "properties": {"dashboardUrl": "str", "provisioningState": "str"},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_task_hubs_begin_delete(self, resource_group):
        response = await (
            await self.client.task_hubs.begin_delete(
                resource_group_name=resource_group.name,
                scheduler_name="str",
                task_hub_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_task_hubs_list_by_scheduler(self, resource_group):
        response = self.client.task_hubs.list_by_scheduler(
            resource_group_name=resource_group.name,
            scheduler_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
