# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class BrokerAuthenticationMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Broker Authentication Mode."""

    CUSTOM = "Custom"
    """Custom authentication configuration."""
    SERVICE_ACCOUNT_TOKEN = "ServiceAccountToken"
    """ServiceAccountToken authentication configuration."""
    X509 = "X509"
    """X.509 authentication configuration."""


class BrokerMemoryProfile(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The memory profile settings of the Broker."""

    TINY = "Tiny"
    """Tiny memory profile."""
    LOW = "Low"
    """Low memory profile."""
    MEDIUM = "Medium"
    """Medium memory profile."""
    HIGH = "High"
    """High memory profile."""


class BrokerProtocolType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Broker Protocol types."""

    MQTT = "Mqtt"
    """protocol broker"""
    WEB_SOCKETS = "WebSockets"
    """protocol websocket"""


class BrokerResourceDefinitionMethods(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BrokerResourceDefinitionMethods methods allowed."""

    CONNECT = "Connect"
    """Allowed Connecting to Broker"""
    PUBLISH = "Publish"
    """Allowed Publishing to Broker"""
    SUBSCRIBE = "Subscribe"
    """Allowed Subscribing to Broker"""


class CertManagerIssuerKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CertManagerIssuerKind properties."""

    ISSUER = "Issuer"
    """Issuer kind."""
    CLUSTER_ISSUER = "ClusterIssuer"
    """ClusterIssuer kind."""


class CloudEventAttributeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """How to map events to the cloud."""

    PROPAGATE = "Propagate"
    """Propagate type"""
    CREATE_OR_REMAP = "CreateOrRemap"
    """CreateOrRemap type"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DataExplorerAuthMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DataflowEndpoint Data Explorer Authentication Method properties."""

    SYSTEM_ASSIGNED_MANAGED_IDENTITY = "SystemAssignedManagedIdentity"
    """SystemAssignedManagedIdentity type"""
    USER_ASSIGNED_MANAGED_IDENTITY = "UserAssignedManagedIdentity"
    """UserAssignedManagedIdentity type"""


class DataflowEndpointAuthenticationSaslType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DataflowEndpoint Authentication Sasl Type properties."""

    PLAIN = "Plain"
    """PLAIN Type"""
    SCRAM_SHA256 = "ScramSha256"
    """SCRAM_SHA_256 Type"""
    SCRAM_SHA512 = "ScramSha512"
    """SCRAM_SHA_512 Type"""


class DataflowEndpointFabricPathType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DataflowEndpoint Fabric Path Type properties."""

    FILES = "Files"
    """FILES Type"""
    TABLES = "Tables"
    """TABLES Type"""


class DataflowEndpointKafkaAcks(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DataflowEndpoint Kafka Acks properties."""

    ZERO = "Zero"
    """ZERO Option"""
    ONE = "One"
    """ONE Option"""
    ALL = "All"
    """ALL Option"""


class DataflowEndpointKafkaCompression(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kafka endpoint Compression properties."""

    NONE = "None"
    """NONE Option"""
    GZIP = "Gzip"
    """Gzip Option"""
    SNAPPY = "Snappy"
    """SNAPPY Option"""
    LZ4 = "Lz4"
    """LZ4 Option"""


class DataflowEndpointKafkaPartitionStrategy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DataflowEndpoint Kafka Partition Strategy properties."""

    DEFAULT = "Default"
    """Default: Assigns messages to random partitions, using a round-robin algorithm."""
    STATIC = "Static"
    """Static: Assigns messages to a fixed partition number that's derived from the instance ID of the
    dataflow."""
    TOPIC = "Topic"
    """TOPIC Option"""
    PROPERTY = "Property"
    """PROPERTY Option"""


class DataflowMappingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Dataflow type mapping properties."""

    NEW_PROPERTIES = "NewProperties"
    """New Properties type"""
    RENAME = "Rename"
    """Rename type"""
    COMPUTE = "Compute"
    """Compute type"""
    PASS_THROUGH = "PassThrough"
    """Pass-through type"""
    BUILT_IN_FUNCTION = "BuiltInFunction"
    """Built in function type"""


class DataLakeStorageAuthMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DataflowEndpoint Data Lake Storage Authentication Method properties."""

    SYSTEM_ASSIGNED_MANAGED_IDENTITY = "SystemAssignedManagedIdentity"
    """SystemAssignedManagedIdentity type"""
    USER_ASSIGNED_MANAGED_IDENTITY = "UserAssignedManagedIdentity"
    """UserAssignedManagedIdentity type"""
    ACCESS_TOKEN = "AccessToken"
    """AccessToken Option"""


class EndpointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DataflowEndpoint Type properties."""

    DATA_EXPLORER = "DataExplorer"
    """Azure Data Explorer Type"""
    DATA_LAKE_STORAGE = "DataLakeStorage"
    """Azure Data Lake Type"""
    FABRIC_ONE_LAKE = "FabricOneLake"
    """Microsoft Fabric Type"""
    KAFKA = "Kafka"
    """Kafka Type"""
    LOCAL_STORAGE = "LocalStorage"
    """Local Storage Type"""
    MQTT = "Mqtt"
    """Broker Type"""


class ExtendedLocationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The enum defining type of ExtendedLocation accepted."""

    CUSTOM_LOCATION = "CustomLocation"
    """CustomLocation type"""


class FabricOneLakeAuthMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DataflowEndpoint Fabric One Lake Authentication Method properties."""

    SYSTEM_ASSIGNED_MANAGED_IDENTITY = "SystemAssignedManagedIdentity"
    """SystemAssignedManagedIdentity type"""
    USER_ASSIGNED_MANAGED_IDENTITY = "UserAssignedManagedIdentity"
    """UserAssignedManagedIdentity type"""


class FilterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Filter Type properties."""

    FILTER = "Filter"
    """Filter type"""


class KafkaAuthMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DataflowEndpoint Kafka Authentication Method properties."""

    SYSTEM_ASSIGNED_MANAGED_IDENTITY = "SystemAssignedManagedIdentity"
    """SystemAssignedManagedIdentity type"""
    USER_ASSIGNED_MANAGED_IDENTITY = "UserAssignedManagedIdentity"
    """UserAssignedManagedIdentity type"""
    SASL = "Sasl"
    """Sasl Option"""
    X509_CERTIFICATE = "X509Certificate"
    """x509Certificate Option"""
    ANONYMOUS = "Anonymous"
    """Anonymous Option"""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class MqttAuthMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DataflowEndpoint Mqtt Authentication Method properties."""

    SYSTEM_ASSIGNED_MANAGED_IDENTITY = "SystemAssignedManagedIdentity"
    """SystemAssignedManagedIdentity type"""
    USER_ASSIGNED_MANAGED_IDENTITY = "UserAssignedManagedIdentity"
    """UserAssignedManagedIdentity type"""
    SERVICE_ACCOUNT_TOKEN = "ServiceAccountToken"
    """ServiceAccountToken Option"""
    X509_CERTIFICATE = "X509Certificate"
    """x509Certificate Option"""
    ANONYMOUS = "Anonymous"
    """Anonymous Option"""


class MqttRetainType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Broker Retain types."""

    KEEP = "Keep"
    """Retain the messages."""
    NEVER = "Never"
    """Never retain messages."""


class OperationalMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Mode properties."""

    ENABLED = "Enabled"
    """Enabled is equivalent to True"""
    DISABLED = "Disabled"
    """Disabled is equivalent to False."""


class OperationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Dataflow Operation Type properties."""

    SOURCE = "Source"
    """Dataflow Source Operation"""
    DESTINATION = "Destination"
    """Dataflow Destination Operation"""
    BUILT_IN_TRANSFORMATION = "BuiltInTransformation"
    """Dataflow BuiltIn Transformation Operation"""


class OperatorValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Valid operators are In, NotIn, Exists and DoesNotExist."""

    IN = "In"
    """In operator."""
    NOT_IN = "NotIn"
    """NotIn operator."""
    EXISTS = "Exists"
    """Exists operator."""
    DOES_NOT_EXIST = "DoesNotExist"
    """DoesNotExist operator."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PrivateKeyAlgorithm(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Private key algorithm types."""

    EC256 = "Ec256"
    """Algorithm - ec256."""
    EC384 = "Ec384"
    """Algorithm - ec384."""
    EC521 = "Ec521"
    """Algorithm - ec521."""
    ED25519 = "Ed25519"
    """Algorithm - ed25519."""
    RSA2048 = "Rsa2048"
    """Algorithm - rsa2048."""
    RSA4096 = "Rsa4096"
    """Algorithm - rsa4096."""
    RSA8192 = "Rsa8192"
    """Algorithm - rsa8192."""


class PrivateKeyRotationPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Private key rotation policy."""

    ALWAYS = "Always"
    """Rotation Policy - Always."""
    NEVER = "Never"
    """Rotation Policy - Never."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The enum defining status of resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    PROVISIONING = "Provisioning"
    """Resource is getting provisioned."""
    UPDATING = "Updating"
    """Resource is Updating."""
    DELETING = "Deleting"
    """Resource is Deleting."""
    ACCEPTED = "Accepted"
    """Resource has been Accepted."""


class ServiceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kubernetes Service Types supported by Listener."""

    CLUSTER_IP = "ClusterIp"
    """Cluster IP Service."""
    LOAD_BALANCER = "LoadBalancer"
    """Load Balancer Service."""
    NODE_PORT = "NodePort"
    """Node Port Service."""


class SourceSerializationFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Serialization Format properties."""

    JSON = "Json"
    """JSON Format"""


class StateStoreResourceDefinitionMethods(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """StateStoreResourceDefinitionMethods methods allowed."""

    READ = "Read"
    """Get/KeyNotify from Store"""
    WRITE = "Write"
    """Set/Delete in Store"""
    READ_WRITE = "ReadWrite"
    """Allowed all operations on Store - Get/KeyNotify/Set/Delete"""


class StateStoreResourceKeyTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """StateStoreResourceKeyTypes properties."""

    PATTERN = "Pattern"
    """Key type - pattern"""
    STRING = "String"
    """Key type - string"""
    BINARY = "Binary"
    """Key type - binary"""


class SubscriberMessageDropStrategy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The enum defining strategies for dropping messages from the subscriber queue."""

    NONE = "None"
    """Messages are never dropped."""
    DROP_OLDEST = "DropOldest"
    """The oldest message is dropped."""


class TlsCertMethodMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Broker Authentication Mode."""

    AUTOMATIC = "Automatic"
    """Automatic TLS server certificate configuration."""
    MANUAL = "Manual"
    """Manual TLS server certificate configuration."""


class TransformationSerializationFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Transformation Format properties."""

    DELTA = "Delta"
    """Delta Format"""
    JSON = "Json"
    """JSON Format"""
    PARQUET = "Parquet"
    """Parquet Format"""
