# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dns.aio import DnsManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDnsManagementRecordSetsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DnsManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_record_sets_update(self, resource_group):
        response = await self.client.record_sets.update(
            resource_group_name=resource_group.name,
            zone_name="str",
            relative_record_set_name="str",
            record_type="str",
            parameters={
                "AAAARecords": [{"ipv6Address": "str"}],
                "ARecords": [{"ipv4Address": "str"}],
                "CNAMERecord": {"cname": "str"},
                "MXRecords": [{"exchange": "str", "preference": 0}],
                "NSRecords": [{"nsdname": "str"}],
                "PTRRecords": [{"ptrdname": "str"}],
                "SOARecord": {
                    "email": "str",
                    "expireTime": 0,
                    "host": "str",
                    "minimumTTL": 0,
                    "refreshTime": 0,
                    "retryTime": 0,
                    "serialNumber": 0,
                },
                "SRVRecords": [{"port": 0, "priority": 0, "target": "str", "weight": 0}],
                "TTL": 0,
                "TXTRecords": [{"value": ["str"]}],
                "caaRecords": [{"flags": 0, "tag": "str", "value": "str"}],
                "etag": "str",
                "fqdn": "str",
                "id": "str",
                "metadata": {"str": "str"},
                "name": "str",
                "provisioningState": "str",
                "targetResource": {"id": "str"},
                "type": "str",
            },
            api_version="2018-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_record_sets_create_or_update(self, resource_group):
        response = await self.client.record_sets.create_or_update(
            resource_group_name=resource_group.name,
            zone_name="str",
            relative_record_set_name="str",
            record_type="str",
            parameters={
                "AAAARecords": [{"ipv6Address": "str"}],
                "ARecords": [{"ipv4Address": "str"}],
                "CNAMERecord": {"cname": "str"},
                "MXRecords": [{"exchange": "str", "preference": 0}],
                "NSRecords": [{"nsdname": "str"}],
                "PTRRecords": [{"ptrdname": "str"}],
                "SOARecord": {
                    "email": "str",
                    "expireTime": 0,
                    "host": "str",
                    "minimumTTL": 0,
                    "refreshTime": 0,
                    "retryTime": 0,
                    "serialNumber": 0,
                },
                "SRVRecords": [{"port": 0, "priority": 0, "target": "str", "weight": 0}],
                "TTL": 0,
                "TXTRecords": [{"value": ["str"]}],
                "caaRecords": [{"flags": 0, "tag": "str", "value": "str"}],
                "etag": "str",
                "fqdn": "str",
                "id": "str",
                "metadata": {"str": "str"},
                "name": "str",
                "provisioningState": "str",
                "targetResource": {"id": "str"},
                "type": "str",
            },
            api_version="2018-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_record_sets_delete(self, resource_group):
        response = await self.client.record_sets.delete(
            resource_group_name=resource_group.name,
            zone_name="str",
            relative_record_set_name="str",
            record_type="str",
            api_version="2018-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_record_sets_get(self, resource_group):
        response = await self.client.record_sets.get(
            resource_group_name=resource_group.name,
            zone_name="str",
            relative_record_set_name="str",
            record_type="str",
            api_version="2018-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_record_sets_list_by_type(self, resource_group):
        response = self.client.record_sets.list_by_type(
            resource_group_name=resource_group.name,
            zone_name="str",
            record_type="str",
            api_version="2018-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_record_sets_list_by_dns_zone(self, resource_group):
        response = self.client.record_sets.list_by_dns_zone(
            resource_group_name=resource_group.name,
            zone_name="str",
            api_version="2018-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_record_sets_list_all_by_dns_zone(self, resource_group):
        response = self.client.record_sets.list_all_by_dns_zone(
            resource_group_name=resource_group.name,
            zone_name="str",
            api_version="2018-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
