# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security.aio import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterPrivateLinksOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_private_links_list_by_subscription(self, resource_group):
        response = self.client.private_links.list_by_subscription(
            api_version="2025-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_private_links_list(self, resource_group):
        response = self.client.private_links.list(
            resource_group_name=resource_group.name,
            api_version="2025-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_private_links_get(self, resource_group):
        response = await self.client.private_links.get(
            resource_group_name=resource_group.name,
            private_link_parameters={"privateLinkName": "str"},
            api_version="2025-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_private_links_head(self, resource_group):
        response = await self.client.private_links.head(
            resource_group_name=resource_group.name,
            private_link_parameters={"privateLinkName": "str"},
            api_version="2025-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_private_links_begin_create(self, resource_group):
        response = await (
            await self.client.private_links.begin_create(
                resource_group_name=resource_group.name,
                private_link_parameters={"privateLinkName": "str"},
                private_link={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "privateEndpointConnections": [
                        {
                            "groupIds": ["str"],
                            "id": "str",
                            "name": "str",
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {
                                "actionsRequired": "str",
                                "description": "str",
                                "status": "str",
                            },
                            "provisioningState": "str",
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "privateLinkResources": [
                        {
                            "groupId": "str",
                            "id": "str",
                            "name": "str",
                            "requiredMembers": ["str"],
                            "requiredZoneNames": ["str"],
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2025-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_private_links_update(self, resource_group):
        response = await self.client.private_links.update(
            resource_group_name=resource_group.name,
            private_link_parameters={"privateLinkName": "str"},
            private_link={"tags": {"str": "str"}},
            api_version="2025-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_private_links_begin_delete(self, resource_group):
        response = await (
            await self.client.private_links.begin_delete(
                resource_group_name=resource_group.name,
                private_link_parameters={"privateLinkName": "str"},
                api_version="2025-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
