# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class MessageContentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Content type for HTTP headers in message operations (closed union for HTTP compliance)."""

    APPLICATION_JSON = "application/json"
    """Content Type 'application/json'"""
    APPLICATION_OCTET_STREAM = "application/octet-stream"
    """Content Type 'application/octet-stream'"""
    TEXT_PLAIN = "text/plain"
    """Content Type 'text/plain'"""


class ResponseContentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Content type for response headers (closed union for HTTP compliance)."""

    APPLICATION_JSON = "application/json"
    """Content Type 'application/json'"""
    TEXT_JSON = "text/json"
    """Content Type 'text/json'"""


class WebPubSubClientType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Web PubSub client type."""

    DEFAULT = "Default"
    """Default value."""
    MQTT = "mqtt"
    """MQTT client."""


class WebPubSubPermission(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Web PubSub permission."""

    SEND_TO_GROUP = "sendToGroup"
    """The permission to send messages to groups."""
    JOIN_LEAVE_GROUP = "joinLeaveGroup"
    """The permission to join/leave groups."""
