# GeoPandas Project Code of Conduct

Behind the GeoPandas Project is an engaged and respectful community made up of people
from all over the world and with a wide range of backgrounds.
Naturally, this implies diversity of ideas and perspectives on often complex
problems. Disagreement and healthy discussion of conflicting viewpoints is
welcome: the best solutions to hard problems rarely come from a single angle.
But disagreement is not an excuse for aggression: humans tend to take
disagreement personally and easily drift into behavior that ultimately degrades
a community. This is particularly acute with online communication across
language and cultural gaps, where many cues of human behavior are unavailable.
We are outlining here a set of principles and processes to support a
healthy community in the face of these challenges.

Fundamentally, we are committed to fostering a productive, harassment-free
environment for everyone. Rather than considering this code an exhaustive list
of things that you can’t do, take it in the spirit it is intended - a guide to
make it easier to enrich all of us and the communities in which we participate.

Importantly: as a member of our community, *you are also a steward of these
values*.  Not all problems need to be resolved via formal processes, and often
a quick, friendly but clear word on an online forum or in person can help
resolve a misunderstanding and de-escalate things.

However, sometimes these informal processes may be inadequate: they fail to
work, there is urgency or risk to someone, nobody is intervening publicly and
you don't feel comfortable speaking in public, etc.  For these or other
reasons, structured follow-up may be necessary and here we provide the means
for that: we welcome reports by emailing
[*geopandas-conduct@googlegroups.com*](mailto:geopandas-conduct@googlegroups.com)
or by filling out
[this form](https://docs.google.com/forms/d/e/1FAIpQLSd8Tbi2zNl1i2N9COX0yavHEqTGFIPQ1_cLcy1A3JgVc1OrAQ/viewform).

This code applies equally to founders, developers, mentors and new community
members, in all spaces managed by the GeoPandas Project. This
includes the mailing lists, our GitHub organization, our chat room, in-person
events, and any other forums created by the project team. In addition,
violations of this code outside these spaces may affect a person's ability to
participate within them.

By embracing the following principles, guidelines and actions to follow or
avoid, you will help us make the GeoPandas Project a welcoming and productive community. Feel
free to contact the Code of Conduct Committee at
[*geopandas-conduct@googlegroups.com*](mailto:geopandas-conduct@googlegroups.com)  with any questions.


1. **Be friendly and patient**.

2. **Be welcoming**. We strive to be a community that welcomes and supports
   people of all backgrounds and identities. This includes, but is not limited
   to, members of any race, ethnicity, culture, national origin, color,
   immigration status, social and economic class, educational level, sex, sexual
   orientation, gender identity and expression, age, physical appearance, family
   status, technological or professional choices, academic
   discipline, religion, mental ability, and physical ability.

3. **Be considerate**. Your work will be used by other people, and you in turn
   will depend on the work of others. Any decision you take will affect users
   and colleagues, and you should take those consequences into account when
   making decisions. Remember that we're a world-wide community. You may be
   communicating with someone with a different primary language or cultural
   background.

4. **Be respectful**. Not all of us will agree all the time, but disagreement is
   no excuse for poor behavior or poor manners. We might all experience some
   frustration now and then, but we cannot allow that frustration to turn into a
   personal attack. It’s important to remember that a community where people
   feel uncomfortable or threatened is not a productive one.

5. **Be careful in the words that you choose**. Be kind to others. Do not insult
   or put down other community members. Harassment and other exclusionary
   behavior are not acceptable. This includes, but is not limited to:
   * Violent threats or violent language directed against another person
   * Discriminatory jokes and language
   * Posting sexually explicit or violent material
   * Posting (or threatening to post) other people's personally identifying
     information ("doxing")
   * Personal insults, especially those using racist, sexist, and xenophobic terms
   * Unwelcome sexual attention
   * Advocating for, or encouraging, any of the above behavior
   * Repeated harassment of others. In general, if someone asks you to stop,
     then stop

6. **Moderate your expectations**. Please respect that community members choose
   how they spend their time in the project. A thoughtful question about your
   expectations is preferable to demands for another person's time.

7. **When we disagree, try to understand why**. Disagreements, both social and
   technical, happen all the time and the GeoPandas Project is no exception.  Try to
   understand where others are coming from, as seeing a question from their
   viewpoint may help find a new path forward.  And don’t forget that it is
   human to err: blaming each other doesn’t get us anywhere, while we can learn
   from mistakes to find better solutions.

8. **A simple apology can go a long way**. It can often de-escalate a situation,
   and telling someone that you are sorry is an act of empathy that doesn’t
   automatically imply an admission of guilt.


## Reporting

If you believe someone is violating the code of conduct, please report this in
a timely manner. Code of conduct violations reduce the value of the community
for everyone and we take them seriously.

You can file a report by emailing
[*geopandas-conduct@googlegroups.com*](mailto:geopandas-conduct@googlegroups.com) or by filing out
[this form](https://docs.google.com/forms/d/e/1FAIpQLSd8Tbi2zNl1i2N9COX0yavHEqTGFIPQ1_cLcy1A3JgVc1OrAQ/viewform).

The online form gives you the option to keep your report anonymous or request
that we follow up with you directly. While we cannot follow up on an anonymous
report, we will take appropriate action.

Messages sent to the e-mail address or through the form will be sent
only to the Code of Conduct Committee, which currently consists of:

* Hannah Aizenman
* Joris Van den Bossche
* Martin Fleischmann


## Enforcement

Enforcement procedures within the GeoPandas Project follow Project Jupyter's
[*Enforcement Manual*](https://github.com/jupyter/governance/blob/master/conduct/enforcement.md). For information on enforcement, please view the [original manual](https://github.com/jupyter/governance/blob/master/conduct/enforcement.md).

Original text courtesy of the [*Speak
Up!*](http://web.archive.org/web/20141109123859/http://speakup.io/coc.html),
[*Django*](https://www.djangoproject.com/conduct) and [*Jupyter*](https://github.com/jupyter/governance/blob/master/conduct/code_of_conduct.md) Projects,
modified by the GeoPandas Project. We are grateful to those projects for contributing these materials under open licensing terms for us to easily reuse.

All content on this page is licensed under a [*Creative Commons
Attribution*](http://creativecommons.org/licenses/by/3.0/) license.
