from typing import Callable

from ._memray import PymallocDomain as PymallocDomain

class MemoryAllocator:
    def __init__(self) -> None: ...
    def free(self) -> None: ...
    def malloc(self, size: int) -> bool: ...
    def calloc(self, size: int) -> bool: ...
    def realloc(self, size: int) -> bool: ...
    def posix_memalign(self, size: int) -> bool: ...
    def aligned_alloc(self, size: int) -> bool: ...
    def memalign(self, size: int) -> bool: ...
    def valloc(self, size: int) -> bool: ...
    def pvalloc(self, size: int) -> bool: ...
    def run_in_pthread(self, callback: Callable[[], None]) -> None: ...

class PymallocMemoryAllocator:
    def __init__(self, domain: PymallocDomain) -> None: ...
    def free(self) -> None: ...
    def malloc(self, size: int) -> None: ...
    def calloc(self, size: int) -> None: ...
    def realloc(self, size: int) -> None: ...

class MmapAllocator:
    def __init__(self, size: int, address: int = 0) -> None: ...
    @property
    def address(self) -> int: ...
    def munmap(self, length: int, offset: int = 0) -> None: ...

def _cython_nested_allocation(
    allocator_fn: Callable[[int], None], size: int
) -> None: ...
def _cython_allocate_in_two_places(size: int) -> None: ...
def set_thread_name(name: str) -> int: ...
def function_caller(func: Callable[[], None]) -> None: ...
def allocate_without_gil_held(wake_up_main_fd: int, wake_up_thread_fd: int) -> None: ...
def allocate_cpp_vector(size: int) -> int: ...
def fill_cpp_vector(size: int) -> int: ...
def exit(py_finalize: bool = False) -> None: ...

class PrimeCaches:
    def __init__(self, size: int) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, *args: object) -> None: ...
