import OCP.StepAP203
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
import OCP.StepBasic
import OCP.Standard
import OCP.StepRepr
import OCP.StepData
import OCP.TCollection
__all__  = [
"StepAP203_ApprovedItem",
"StepAP203_Array1OfApprovedItem",
"StepAP203_Array1OfCertifiedItem",
"StepAP203_Array1OfChangeRequestItem",
"StepAP203_Array1OfClassifiedItem",
"StepAP203_Array1OfContractedItem",
"StepAP203_Array1OfDateTimeItem",
"StepAP203_Array1OfPersonOrganizationItem",
"StepAP203_Array1OfSpecifiedItem",
"StepAP203_Array1OfStartRequestItem",
"StepAP203_Array1OfWorkItem",
"StepAP203_CcDesignApproval",
"StepAP203_CcDesignCertification",
"StepAP203_CcDesignContract",
"StepAP203_CcDesignDateAndTimeAssignment",
"StepAP203_CcDesignPersonAndOrganizationAssignment",
"StepAP203_CcDesignSecurityClassification",
"StepAP203_CcDesignSpecificationReference",
"StepAP203_CertifiedItem",
"StepAP203_Change",
"StepAP203_ChangeRequest",
"StepAP203_ChangeRequestItem",
"StepAP203_ClassifiedItem",
"StepAP203_ContractedItem",
"StepAP203_DateTimeItem",
"StepAP203_HArray1OfApprovedItem",
"StepAP203_HArray1OfCertifiedItem",
"StepAP203_HArray1OfChangeRequestItem",
"StepAP203_HArray1OfClassifiedItem",
"StepAP203_HArray1OfContractedItem",
"StepAP203_HArray1OfDateTimeItem",
"StepAP203_HArray1OfPersonOrganizationItem",
"StepAP203_HArray1OfSpecifiedItem",
"StepAP203_HArray1OfStartRequestItem",
"StepAP203_HArray1OfWorkItem",
"StepAP203_PersonOrganizationItem",
"StepAP203_SpecifiedItem",
"StepAP203_StartRequest",
"StepAP203_StartRequestItem",
"StepAP203_StartWork",
"StepAP203_WorkItem"
]
class StepAP203_ApprovedItem(OCP.StepData.StepData_SelectType):
    """
    Representation of STEP SELECT type ApprovedItem
    """
    def Boolean(self) -> bool: 
        """
        None
        """
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a kind of ApprovedItem select type 1 -> ProductDefinitionFormation from StepBasic 2 -> ProductDefinition from StepBasic 3 -> ConfigurationEffectivity from StepRepr 4 -> ConfigurationItem from StepRepr 5 -> SecurityClassification from StepBasic 6 -> ChangeRequest from StepAP203 7 -> Change from StepAP203 8 -> StartRequest from StepAP203 9 -> StartWork from StepAP203 10 -> Certification from StepBasic 11 -> Contract from StepBasic 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def Certification(self) -> OCP.StepBasic.StepBasic_Certification: 
        """
        Returns Value as Certification (or Null if another type)
        """
    def Change(self) -> StepAP203_Change: 
        """
        Returns Value as Change (or Null if another type)
        """
    def ChangeRequest(self) -> StepAP203_ChangeRequest: 
        """
        Returns Value as ChangeRequest (or Null if another type)
        """
    def ConfigurationEffectivity(self) -> OCP.StepRepr.StepRepr_ConfigurationEffectivity: 
        """
        Returns Value as ConfigurationEffectivity (or Null if another type)
        """
    def ConfigurationItem(self) -> OCP.StepRepr.StepRepr_ConfigurationItem: 
        """
        Returns Value as ConfigurationItem (or Null if another type)
        """
    def Contract(self) -> OCP.StepBasic.StepBasic_Contract: 
        """
        Returns Value as Contract (or Null if another type)
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: 
        """
        None
        """
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def ProductDefinition(self) -> OCP.StepBasic.StepBasic_ProductDefinition: 
        """
        Returns Value as ProductDefinition (or Null if another type)
        """
    def ProductDefinitionFormation(self) -> OCP.StepBasic.StepBasic_ProductDefinitionFormation: 
        """
        Returns Value as ProductDefinitionFormation (or Null if another type)
        """
    def Real(self) -> float: 
        """
        None
        """
    def SecurityClassification(self) -> OCP.StepBasic.StepBasic_SecurityClassification: 
        """
        Returns Value as SecurityClassification (or Null if another type)
        """
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: 
        """
        None
        """
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: 
        """
        None
        """
    def SetReal(self,val : float,name : str='') -> None: 
        """
        None
        """
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.
        """
    def StartRequest(self) -> StepAP203_StartRequest: 
        """
        Returns Value as StartRequest (or Null if another type)
        """
    def StartWork(self) -> StepAP203_StartWork: 
        """
        Returns Value as StartWork (or Null if another type)
        """
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
class StepAP203_Array1OfApprovedItem():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepAP203_Array1OfApprovedItem) -> StepAP203_Array1OfApprovedItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def Init(self,theValue : StepAP203_ApprovedItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfApprovedItem) -> StepAP203_Array1OfApprovedItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_ApprovedItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_ApprovedItem: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfApprovedItem) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_ApprovedItem]: ...
    def __len__(self) -> int: ...
    pass
class StepAP203_Array1OfCertifiedItem():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepAP203_Array1OfCertifiedItem) -> StepAP203_Array1OfCertifiedItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def Init(self,theValue : StepAP203_CertifiedItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfCertifiedItem) -> StepAP203_Array1OfCertifiedItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_CertifiedItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_CertifiedItem: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfCertifiedItem) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_CertifiedItem]: ...
    def __len__(self) -> int: ...
    pass
class StepAP203_Array1OfChangeRequestItem():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepAP203_Array1OfChangeRequestItem) -> StepAP203_Array1OfChangeRequestItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def Init(self,theValue : StepAP203_ChangeRequestItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfChangeRequestItem) -> StepAP203_Array1OfChangeRequestItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_ChangeRequestItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_ChangeRequestItem: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfChangeRequestItem) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_ChangeRequestItem]: ...
    def __len__(self) -> int: ...
    pass
class StepAP203_Array1OfClassifiedItem():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepAP203_Array1OfClassifiedItem) -> StepAP203_Array1OfClassifiedItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def Init(self,theValue : StepAP203_ClassifiedItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfClassifiedItem) -> StepAP203_Array1OfClassifiedItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_ClassifiedItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_ClassifiedItem: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfClassifiedItem) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_ClassifiedItem]: ...
    def __len__(self) -> int: ...
    pass
class StepAP203_Array1OfContractedItem():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepAP203_Array1OfContractedItem) -> StepAP203_Array1OfContractedItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def Init(self,theValue : StepAP203_ContractedItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfContractedItem) -> StepAP203_Array1OfContractedItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_ContractedItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_ContractedItem: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfContractedItem) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_ContractedItem]: ...
    def __len__(self) -> int: ...
    pass
class StepAP203_Array1OfDateTimeItem():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepAP203_Array1OfDateTimeItem) -> StepAP203_Array1OfDateTimeItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def Init(self,theValue : StepAP203_DateTimeItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfDateTimeItem) -> StepAP203_Array1OfDateTimeItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_DateTimeItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_DateTimeItem: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfDateTimeItem) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_DateTimeItem]: ...
    def __len__(self) -> int: ...
    pass
class StepAP203_Array1OfPersonOrganizationItem():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepAP203_Array1OfPersonOrganizationItem) -> StepAP203_Array1OfPersonOrganizationItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def Init(self,theValue : StepAP203_PersonOrganizationItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfPersonOrganizationItem) -> StepAP203_Array1OfPersonOrganizationItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_PersonOrganizationItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_PersonOrganizationItem: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfPersonOrganizationItem) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_PersonOrganizationItem]: ...
    def __len__(self) -> int: ...
    pass
class StepAP203_Array1OfSpecifiedItem():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepAP203_Array1OfSpecifiedItem) -> StepAP203_Array1OfSpecifiedItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def Init(self,theValue : StepAP203_SpecifiedItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfSpecifiedItem) -> StepAP203_Array1OfSpecifiedItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_SpecifiedItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_SpecifiedItem: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfSpecifiedItem) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_SpecifiedItem]: ...
    def __len__(self) -> int: ...
    pass
class StepAP203_Array1OfStartRequestItem():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepAP203_Array1OfStartRequestItem) -> StepAP203_Array1OfStartRequestItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def Init(self,theValue : StepAP203_StartRequestItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfStartRequestItem) -> StepAP203_Array1OfStartRequestItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_StartRequestItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_StartRequestItem: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfStartRequestItem) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_StartRequestItem]: ...
    def __len__(self) -> int: ...
    pass
class StepAP203_Array1OfWorkItem():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepAP203_Array1OfWorkItem) -> StepAP203_Array1OfWorkItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def Init(self,theValue : StepAP203_WorkItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfWorkItem) -> StepAP203_Array1OfWorkItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_WorkItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_WorkItem: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfWorkItem) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_WorkItem]: ...
    def __len__(self) -> int: ...
    pass
class StepAP203_CcDesignApproval(OCP.StepBasic.StepBasic_ApprovalAssignment, OCP.Standard.Standard_Transient):
    """
    Representation of STEP entity CcDesignApprovalRepresentation of STEP entity CcDesignApprovalRepresentation of STEP entity CcDesignApproval
    """
    def AssignedApproval(self) -> OCP.StepBasic.StepBasic_Approval: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aApprovalAssignment_AssignedApproval : OCP.StepBasic.StepBasic_Approval,aItems : StepAP203_HArray1OfApprovedItem) -> None: 
        """
        Initialize all fields (own and inherited)
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Items(self) -> StepAP203_HArray1OfApprovedItem: 
        """
        Returns field Items
        """
    def SetAssignedApproval(self,aAssignedApproval : OCP.StepBasic.StepBasic_Approval) -> None: 
        """
        None
        """
    def SetItems(self,Items : StepAP203_HArray1OfApprovedItem) -> None: 
        """
        Set field Items
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_CcDesignCertification(OCP.StepBasic.StepBasic_CertificationAssignment, OCP.Standard.Standard_Transient):
    """
    Representation of STEP entity CcDesignCertificationRepresentation of STEP entity CcDesignCertificationRepresentation of STEP entity CcDesignCertification
    """
    def AssignedCertification(self) -> OCP.StepBasic.StepBasic_Certification: 
        """
        Returns field AssignedCertification
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aCertificationAssignment_AssignedCertification : OCP.StepBasic.StepBasic_Certification,aItems : StepAP203_HArray1OfCertifiedItem) -> None: 
        """
        Initialize all fields (own and inherited)
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Items(self) -> StepAP203_HArray1OfCertifiedItem: 
        """
        Returns field Items
        """
    def SetAssignedCertification(self,AssignedCertification : OCP.StepBasic.StepBasic_Certification) -> None: 
        """
        Set field AssignedCertification
        """
    def SetItems(self,Items : StepAP203_HArray1OfCertifiedItem) -> None: 
        """
        Set field Items
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_CcDesignContract(OCP.StepBasic.StepBasic_ContractAssignment, OCP.Standard.Standard_Transient):
    """
    Representation of STEP entity CcDesignContractRepresentation of STEP entity CcDesignContractRepresentation of STEP entity CcDesignContract
    """
    def AssignedContract(self) -> OCP.StepBasic.StepBasic_Contract: 
        """
        Returns field AssignedContract
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aContractAssignment_AssignedContract : OCP.StepBasic.StepBasic_Contract,aItems : StepAP203_HArray1OfContractedItem) -> None: 
        """
        Initialize all fields (own and inherited)
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Items(self) -> StepAP203_HArray1OfContractedItem: 
        """
        Returns field Items
        """
    def SetAssignedContract(self,AssignedContract : OCP.StepBasic.StepBasic_Contract) -> None: 
        """
        Set field AssignedContract
        """
    def SetItems(self,Items : StepAP203_HArray1OfContractedItem) -> None: 
        """
        Set field Items
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_CcDesignDateAndTimeAssignment(OCP.StepBasic.StepBasic_DateAndTimeAssignment, OCP.Standard.Standard_Transient):
    """
    Representation of STEP entity CcDesignDateAndTimeAssignmentRepresentation of STEP entity CcDesignDateAndTimeAssignmentRepresentation of STEP entity CcDesignDateAndTimeAssignment
    """
    def AssignedDateAndTime(self) -> OCP.StepBasic.StepBasic_DateAndTime: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aDateAndTimeAssignment_AssignedDateAndTime : OCP.StepBasic.StepBasic_DateAndTime,aDateAndTimeAssignment_Role : OCP.StepBasic.StepBasic_DateTimeRole,aItems : StepAP203_HArray1OfDateTimeItem) -> None: 
        """
        Initialize all fields (own and inherited)
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Items(self) -> StepAP203_HArray1OfDateTimeItem: 
        """
        Returns field Items
        """
    def Role(self) -> OCP.StepBasic.StepBasic_DateTimeRole: 
        """
        None
        """
    def SetAssignedDateAndTime(self,aAssignedDateAndTime : OCP.StepBasic.StepBasic_DateAndTime) -> None: 
        """
        None
        """
    def SetItems(self,Items : StepAP203_HArray1OfDateTimeItem) -> None: 
        """
        Set field Items
        """
    def SetRole(self,aRole : OCP.StepBasic.StepBasic_DateTimeRole) -> None: 
        """
        None
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_CcDesignPersonAndOrganizationAssignment(OCP.StepBasic.StepBasic_PersonAndOrganizationAssignment, OCP.Standard.Standard_Transient):
    """
    Representation of STEP entity CcDesignPersonAndOrganizationAssignmentRepresentation of STEP entity CcDesignPersonAndOrganizationAssignmentRepresentation of STEP entity CcDesignPersonAndOrganizationAssignment
    """
    def AssignedPersonAndOrganization(self) -> OCP.StepBasic.StepBasic_PersonAndOrganization: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aPersonAndOrganizationAssignment_AssignedPersonAndOrganization : OCP.StepBasic.StepBasic_PersonAndOrganization,aPersonAndOrganizationAssignment_Role : OCP.StepBasic.StepBasic_PersonAndOrganizationRole,aItems : StepAP203_HArray1OfPersonOrganizationItem) -> None: 
        """
        Initialize all fields (own and inherited)
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Items(self) -> StepAP203_HArray1OfPersonOrganizationItem: 
        """
        Returns field Items
        """
    def Role(self) -> OCP.StepBasic.StepBasic_PersonAndOrganizationRole: 
        """
        None
        """
    def SetAssignedPersonAndOrganization(self,aAssignedPersonAndOrganization : OCP.StepBasic.StepBasic_PersonAndOrganization) -> None: 
        """
        None
        """
    def SetItems(self,Items : StepAP203_HArray1OfPersonOrganizationItem) -> None: 
        """
        Set field Items
        """
    def SetRole(self,aRole : OCP.StepBasic.StepBasic_PersonAndOrganizationRole) -> None: 
        """
        None
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_CcDesignSecurityClassification(OCP.StepBasic.StepBasic_SecurityClassificationAssignment, OCP.Standard.Standard_Transient):
    """
    Representation of STEP entity CcDesignSecurityClassificationRepresentation of STEP entity CcDesignSecurityClassificationRepresentation of STEP entity CcDesignSecurityClassification
    """
    def AssignedSecurityClassification(self) -> OCP.StepBasic.StepBasic_SecurityClassification: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aSecurityClassificationAssignment_AssignedSecurityClassification : OCP.StepBasic.StepBasic_SecurityClassification,aItems : StepAP203_HArray1OfClassifiedItem) -> None: 
        """
        Initialize all fields (own and inherited)
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Items(self) -> StepAP203_HArray1OfClassifiedItem: 
        """
        Returns field Items
        """
    def SetAssignedSecurityClassification(self,aAssignedSecurityClassification : OCP.StepBasic.StepBasic_SecurityClassification) -> None: 
        """
        None
        """
    def SetItems(self,Items : StepAP203_HArray1OfClassifiedItem) -> None: 
        """
        Set field Items
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_CcDesignSpecificationReference(OCP.StepBasic.StepBasic_DocumentReference, OCP.Standard.Standard_Transient):
    """
    Representation of STEP entity CcDesignSpecificationReferenceRepresentation of STEP entity CcDesignSpecificationReferenceRepresentation of STEP entity CcDesignSpecificationReference
    """
    def AssignedDocument(self) -> OCP.StepBasic.StepBasic_Document: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aDocumentReference_AssignedDocument : OCP.StepBasic.StepBasic_Document,aDocumentReference_Source : OCP.TCollection.TCollection_HAsciiString,aItems : StepAP203_HArray1OfSpecifiedItem) -> None: 
        """
        Initialize all fields (own and inherited)
        """
    def Init0(self,aAssignedDocument : OCP.StepBasic.StepBasic_Document,aSource : OCP.TCollection.TCollection_HAsciiString) -> None: 
        """
        None
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Items(self) -> StepAP203_HArray1OfSpecifiedItem: 
        """
        Returns field Items
        """
    def SetAssignedDocument(self,aAssignedDocument : OCP.StepBasic.StepBasic_Document) -> None: 
        """
        None
        """
    def SetItems(self,Items : StepAP203_HArray1OfSpecifiedItem) -> None: 
        """
        Set field Items
        """
    def SetSource(self,aSource : OCP.TCollection.TCollection_HAsciiString) -> None: 
        """
        None
        """
    def Source(self) -> OCP.TCollection.TCollection_HAsciiString: 
        """
        None
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_CertifiedItem(OCP.StepData.StepData_SelectType):
    """
    Representation of STEP SELECT type CertifiedItem
    """
    def Boolean(self) -> bool: 
        """
        None
        """
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a kind of CertifiedItem select type 1 -> SuppliedPartRelationship from StepRepr 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: 
        """
        None
        """
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def Real(self) -> float: 
        """
        None
        """
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: 
        """
        None
        """
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: 
        """
        None
        """
    def SetReal(self,val : float,name : str='') -> None: 
        """
        None
        """
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.
        """
    def SuppliedPartRelationship(self) -> OCP.StepRepr.StepRepr_SuppliedPartRelationship: 
        """
        Returns Value as SuppliedPartRelationship (or Null if another type)
        """
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
class StepAP203_Change(OCP.StepBasic.StepBasic_ActionAssignment, OCP.Standard.Standard_Transient):
    """
    Representation of STEP entity ChangeRepresentation of STEP entity ChangeRepresentation of STEP entity Change
    """
    def AssignedAction(self) -> OCP.StepBasic.StepBasic_Action: 
        """
        Returns field AssignedAction
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aActionAssignment_AssignedAction : OCP.StepBasic.StepBasic_Action,aItems : StepAP203_HArray1OfWorkItem) -> None: 
        """
        Initialize all fields (own and inherited)
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Items(self) -> StepAP203_HArray1OfWorkItem: 
        """
        Returns field Items
        """
    def SetAssignedAction(self,AssignedAction : OCP.StepBasic.StepBasic_Action) -> None: 
        """
        Set field AssignedAction
        """
    def SetItems(self,Items : StepAP203_HArray1OfWorkItem) -> None: 
        """
        Set field Items
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_ChangeRequest(OCP.StepBasic.StepBasic_ActionRequestAssignment, OCP.Standard.Standard_Transient):
    """
    Representation of STEP entity ChangeRequestRepresentation of STEP entity ChangeRequestRepresentation of STEP entity ChangeRequest
    """
    def AssignedActionRequest(self) -> OCP.StepBasic.StepBasic_VersionedActionRequest: 
        """
        Returns field AssignedActionRequest
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aActionRequestAssignment_AssignedActionRequest : OCP.StepBasic.StepBasic_VersionedActionRequest,aItems : StepAP203_HArray1OfChangeRequestItem) -> None: 
        """
        Initialize all fields (own and inherited)
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Items(self) -> StepAP203_HArray1OfChangeRequestItem: 
        """
        Returns field Items
        """
    def SetAssignedActionRequest(self,AssignedActionRequest : OCP.StepBasic.StepBasic_VersionedActionRequest) -> None: 
        """
        Set field AssignedActionRequest
        """
    def SetItems(self,Items : StepAP203_HArray1OfChangeRequestItem) -> None: 
        """
        Set field Items
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_ChangeRequestItem(OCP.StepData.StepData_SelectType):
    """
    Representation of STEP SELECT type ChangeRequestItem
    """
    def Boolean(self) -> bool: 
        """
        None
        """
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a kind of ChangeRequestItem select type 1 -> ProductDefinitionFormation from StepBasic 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: 
        """
        None
        """
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def ProductDefinitionFormation(self) -> OCP.StepBasic.StepBasic_ProductDefinitionFormation: 
        """
        Returns Value as ProductDefinitionFormation (or Null if another type)
        """
    def Real(self) -> float: 
        """
        None
        """
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: 
        """
        None
        """
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: 
        """
        None
        """
    def SetReal(self,val : float,name : str='') -> None: 
        """
        None
        """
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.
        """
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
class StepAP203_ClassifiedItem(OCP.StepData.StepData_SelectType):
    """
    Representation of STEP SELECT type ClassifiedItem
    """
    def AssemblyComponentUsage(self) -> OCP.StepRepr.StepRepr_AssemblyComponentUsage: 
        """
        Returns Value as AssemblyComponentUsage (or Null if another type)
        """
    def Boolean(self) -> bool: 
        """
        None
        """
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a kind of ClassifiedItem select type 1 -> ProductDefinitionFormation from StepBasic 2 -> AssemblyComponentUsage from StepRepr 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: 
        """
        None
        """
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def ProductDefinitionFormation(self) -> OCP.StepBasic.StepBasic_ProductDefinitionFormation: 
        """
        Returns Value as ProductDefinitionFormation (or Null if another type)
        """
    def Real(self) -> float: 
        """
        None
        """
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: 
        """
        None
        """
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: 
        """
        None
        """
    def SetReal(self,val : float,name : str='') -> None: 
        """
        None
        """
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.
        """
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
class StepAP203_ContractedItem(OCP.StepData.StepData_SelectType):
    """
    Representation of STEP SELECT type ContractedItem
    """
    def Boolean(self) -> bool: 
        """
        None
        """
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a kind of ContractedItem select type 1 -> ProductDefinitionFormation from StepBasic 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: 
        """
        None
        """
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def ProductDefinitionFormation(self) -> OCP.StepBasic.StepBasic_ProductDefinitionFormation: 
        """
        Returns Value as ProductDefinitionFormation (or Null if another type)
        """
    def Real(self) -> float: 
        """
        None
        """
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: 
        """
        None
        """
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: 
        """
        None
        """
    def SetReal(self,val : float,name : str='') -> None: 
        """
        None
        """
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.
        """
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
class StepAP203_DateTimeItem(OCP.StepData.StepData_SelectType):
    """
    Representation of STEP SELECT type DateTimeItem
    """
    def ApprovalPersonOrganization(self) -> OCP.StepBasic.StepBasic_ApprovalPersonOrganization: 
        """
        Returns Value as ApprovalPersonOrganization (or Null if another type)
        """
    def Boolean(self) -> bool: 
        """
        None
        """
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a kind of DateTimeItem select type 1 -> ProductDefinition from StepBasic 2 -> ChangeRequest from StepAP203 3 -> StartRequest from StepAP203 4 -> Change from StepAP203 5 -> StartWork from StepAP203 6 -> ApprovalPersonOrganization from StepBasic 7 -> Contract from StepBasic 8 -> SecurityClassification from StepBasic 9 -> Certification from StepBasic 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def Certification(self) -> OCP.StepBasic.StepBasic_Certification: 
        """
        Returns Value as Certification (or Null if another type)
        """
    def Change(self) -> StepAP203_Change: 
        """
        Returns Value as Change (or Null if another type)
        """
    def ChangeRequest(self) -> StepAP203_ChangeRequest: 
        """
        Returns Value as ChangeRequest (or Null if another type)
        """
    def Contract(self) -> OCP.StepBasic.StepBasic_Contract: 
        """
        Returns Value as Contract (or Null if another type)
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: 
        """
        None
        """
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def ProductDefinition(self) -> OCP.StepBasic.StepBasic_ProductDefinition: 
        """
        Returns Value as ProductDefinition (or Null if another type)
        """
    def Real(self) -> float: 
        """
        None
        """
    def SecurityClassification(self) -> OCP.StepBasic.StepBasic_SecurityClassification: 
        """
        Returns Value as SecurityClassification (or Null if another type)
        """
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: 
        """
        None
        """
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: 
        """
        None
        """
    def SetReal(self,val : float,name : str='') -> None: 
        """
        None
        """
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.
        """
    def StartRequest(self) -> StepAP203_StartRequest: 
        """
        Returns Value as StartRequest (or Null if another type)
        """
    def StartWork(self) -> StepAP203_StartWork: 
        """
        Returns Value as StartWork (or Null if another type)
        """
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
class StepAP203_HArray1OfApprovedItem(StepAP203_Array1OfApprovedItem, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepAP203_Array1OfApprovedItem: 
        """
        None
        """
    def Assign(self,theOther : StepAP203_Array1OfApprovedItem) -> StepAP203_Array1OfApprovedItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepAP203_Array1OfApprovedItem: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepAP203_ApprovedItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfApprovedItem) -> StepAP203_Array1OfApprovedItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_ApprovedItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_ApprovedItem: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepAP203_ApprovedItem) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfApprovedItem) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theBegin : StepAP203_ApprovedItem,theLower : int,theUpper : int,arg4 : bool) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_ApprovedItem]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_HArray1OfCertifiedItem(StepAP203_Array1OfCertifiedItem, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepAP203_Array1OfCertifiedItem: 
        """
        None
        """
    def Assign(self,theOther : StepAP203_Array1OfCertifiedItem) -> StepAP203_Array1OfCertifiedItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepAP203_Array1OfCertifiedItem: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepAP203_CertifiedItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfCertifiedItem) -> StepAP203_Array1OfCertifiedItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_CertifiedItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_CertifiedItem: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfCertifiedItem) -> None: ...
    @overload
    def __init__(self,theBegin : StepAP203_CertifiedItem,theLower : int,theUpper : int,arg4 : bool) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepAP203_CertifiedItem) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_CertifiedItem]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_HArray1OfChangeRequestItem(StepAP203_Array1OfChangeRequestItem, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepAP203_Array1OfChangeRequestItem: 
        """
        None
        """
    def Assign(self,theOther : StepAP203_Array1OfChangeRequestItem) -> StepAP203_Array1OfChangeRequestItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepAP203_Array1OfChangeRequestItem: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepAP203_ChangeRequestItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfChangeRequestItem) -> StepAP203_Array1OfChangeRequestItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_ChangeRequestItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_ChangeRequestItem: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepAP203_ChangeRequestItem) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theBegin : StepAP203_ChangeRequestItem,theLower : int,theUpper : int,arg4 : bool) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfChangeRequestItem) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_ChangeRequestItem]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_HArray1OfClassifiedItem(StepAP203_Array1OfClassifiedItem, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepAP203_Array1OfClassifiedItem: 
        """
        None
        """
    def Assign(self,theOther : StepAP203_Array1OfClassifiedItem) -> StepAP203_Array1OfClassifiedItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepAP203_Array1OfClassifiedItem: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepAP203_ClassifiedItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfClassifiedItem) -> StepAP203_Array1OfClassifiedItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_ClassifiedItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_ClassifiedItem: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepAP203_ClassifiedItem) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfClassifiedItem) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theBegin : StepAP203_ClassifiedItem,theLower : int,theUpper : int,arg4 : bool) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_ClassifiedItem]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_HArray1OfContractedItem(StepAP203_Array1OfContractedItem, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepAP203_Array1OfContractedItem: 
        """
        None
        """
    def Assign(self,theOther : StepAP203_Array1OfContractedItem) -> StepAP203_Array1OfContractedItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepAP203_Array1OfContractedItem: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepAP203_ContractedItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfContractedItem) -> StepAP203_Array1OfContractedItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_ContractedItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_ContractedItem: ...
    @overload
    def __init__(self,theBegin : StepAP203_ContractedItem,theLower : int,theUpper : int,arg4 : bool) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepAP203_ContractedItem) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfContractedItem) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_ContractedItem]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_HArray1OfDateTimeItem(StepAP203_Array1OfDateTimeItem, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepAP203_Array1OfDateTimeItem: 
        """
        None
        """
    def Assign(self,theOther : StepAP203_Array1OfDateTimeItem) -> StepAP203_Array1OfDateTimeItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepAP203_Array1OfDateTimeItem: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepAP203_DateTimeItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfDateTimeItem) -> StepAP203_Array1OfDateTimeItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_DateTimeItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_DateTimeItem: ...
    @overload
    def __init__(self,theBegin : StepAP203_DateTimeItem,theLower : int,theUpper : int,arg4 : bool) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepAP203_DateTimeItem) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfDateTimeItem) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_DateTimeItem]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_HArray1OfPersonOrganizationItem(StepAP203_Array1OfPersonOrganizationItem, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepAP203_Array1OfPersonOrganizationItem: 
        """
        None
        """
    def Assign(self,theOther : StepAP203_Array1OfPersonOrganizationItem) -> StepAP203_Array1OfPersonOrganizationItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepAP203_Array1OfPersonOrganizationItem: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepAP203_PersonOrganizationItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfPersonOrganizationItem) -> StepAP203_Array1OfPersonOrganizationItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_PersonOrganizationItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_PersonOrganizationItem: ...
    @overload
    def __init__(self,theBegin : StepAP203_PersonOrganizationItem,theLower : int,theUpper : int,arg4 : bool) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepAP203_PersonOrganizationItem) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfPersonOrganizationItem) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_PersonOrganizationItem]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_HArray1OfSpecifiedItem(StepAP203_Array1OfSpecifiedItem, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepAP203_Array1OfSpecifiedItem: 
        """
        None
        """
    def Assign(self,theOther : StepAP203_Array1OfSpecifiedItem) -> StepAP203_Array1OfSpecifiedItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepAP203_Array1OfSpecifiedItem: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepAP203_SpecifiedItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfSpecifiedItem) -> StepAP203_Array1OfSpecifiedItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_SpecifiedItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_SpecifiedItem: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfSpecifiedItem) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepAP203_SpecifiedItem) -> None: ...
    @overload
    def __init__(self,theBegin : StepAP203_SpecifiedItem,theLower : int,theUpper : int,arg4 : bool) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_SpecifiedItem]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_HArray1OfStartRequestItem(StepAP203_Array1OfStartRequestItem, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepAP203_Array1OfStartRequestItem: 
        """
        None
        """
    def Assign(self,theOther : StepAP203_Array1OfStartRequestItem) -> StepAP203_Array1OfStartRequestItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepAP203_Array1OfStartRequestItem: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepAP203_StartRequestItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfStartRequestItem) -> StepAP203_Array1OfStartRequestItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_StartRequestItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_StartRequestItem: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepAP203_StartRequestItem) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfStartRequestItem) -> None: ...
    @overload
    def __init__(self,theBegin : StepAP203_StartRequestItem,theLower : int,theUpper : int,arg4 : bool) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_StartRequestItem]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_HArray1OfWorkItem(StepAP203_Array1OfWorkItem, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepAP203_Array1OfWorkItem: 
        """
        None
        """
    def Assign(self,theOther : StepAP203_Array1OfWorkItem) -> StepAP203_Array1OfWorkItem: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepAP203_Array1OfWorkItem: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepAP203_WorkItem) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepAP203_Array1OfWorkItem) -> StepAP203_Array1OfWorkItem: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepAP203_WorkItem) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepAP203_WorkItem: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theOther : StepAP203_Array1OfWorkItem) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepAP203_WorkItem) -> None: ...
    @overload
    def __init__(self,theBegin : StepAP203_WorkItem,theLower : int,theUpper : int,arg4 : bool) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    def __iter__(self) -> Iterator[StepAP203_WorkItem]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_PersonOrganizationItem(OCP.StepData.StepData_SelectType):
    """
    Representation of STEP SELECT type PersonOrganizationItem
    """
    def Boolean(self) -> bool: 
        """
        None
        """
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a kind of PersonOrganizationItem select type 1 -> Change from StepAP203 2 -> StartWork from StepAP203 3 -> ChangeRequest from StepAP203 4 -> StartRequest from StepAP203 5 -> ConfigurationItem from StepRepr 6 -> Product from StepBasic 7 -> ProductDefinitionFormation from StepBasic 8 -> ProductDefinition from StepBasic 9 -> Contract from StepBasic 10 -> SecurityClassification from StepBasic 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def Change(self) -> StepAP203_Change: 
        """
        Returns Value as Change (or Null if another type)
        """
    def ChangeRequest(self) -> StepAP203_ChangeRequest: 
        """
        Returns Value as ChangeRequest (or Null if another type)
        """
    def ConfigurationItem(self) -> OCP.StepRepr.StepRepr_ConfigurationItem: 
        """
        Returns Value as ConfigurationItem (or Null if another type)
        """
    def Contract(self) -> OCP.StepBasic.StepBasic_Contract: 
        """
        Returns Value as Contract (or Null if another type)
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: 
        """
        None
        """
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def Product(self) -> OCP.StepBasic.StepBasic_Product: 
        """
        Returns Value as Product (or Null if another type)
        """
    def ProductDefinition(self) -> OCP.StepBasic.StepBasic_ProductDefinition: 
        """
        Returns Value as ProductDefinition (or Null if another type)
        """
    def ProductDefinitionFormation(self) -> OCP.StepBasic.StepBasic_ProductDefinitionFormation: 
        """
        Returns Value as ProductDefinitionFormation (or Null if another type)
        """
    def Real(self) -> float: 
        """
        None
        """
    def SecurityClassification(self) -> OCP.StepBasic.StepBasic_SecurityClassification: 
        """
        Returns Value as SecurityClassification (or Null if another type)
        """
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: 
        """
        None
        """
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: 
        """
        None
        """
    def SetReal(self,val : float,name : str='') -> None: 
        """
        None
        """
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.
        """
    def StartRequest(self) -> StepAP203_StartRequest: 
        """
        Returns Value as StartRequest (or Null if another type)
        """
    def StartWork(self) -> StepAP203_StartWork: 
        """
        Returns Value as StartWork (or Null if another type)
        """
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
class StepAP203_SpecifiedItem(OCP.StepData.StepData_SelectType):
    """
    Representation of STEP SELECT type SpecifiedItem
    """
    def Boolean(self) -> bool: 
        """
        None
        """
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a kind of SpecifiedItem select type 1 -> ProductDefinition from StepBasic 2 -> ShapeAspect from StepRepr 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: 
        """
        None
        """
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def ProductDefinition(self) -> OCP.StepBasic.StepBasic_ProductDefinition: 
        """
        Returns Value as ProductDefinition (or Null if another type)
        """
    def Real(self) -> float: 
        """
        None
        """
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: 
        """
        None
        """
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: 
        """
        None
        """
    def SetReal(self,val : float,name : str='') -> None: 
        """
        None
        """
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.
        """
    def ShapeAspect(self) -> OCP.StepRepr.StepRepr_ShapeAspect: 
        """
        Returns Value as ShapeAspect (or Null if another type)
        """
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
class StepAP203_StartRequest(OCP.StepBasic.StepBasic_ActionRequestAssignment, OCP.Standard.Standard_Transient):
    """
    Representation of STEP entity StartRequestRepresentation of STEP entity StartRequestRepresentation of STEP entity StartRequest
    """
    def AssignedActionRequest(self) -> OCP.StepBasic.StepBasic_VersionedActionRequest: 
        """
        Returns field AssignedActionRequest
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aActionRequestAssignment_AssignedActionRequest : OCP.StepBasic.StepBasic_VersionedActionRequest,aItems : StepAP203_HArray1OfStartRequestItem) -> None: 
        """
        Initialize all fields (own and inherited)
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Items(self) -> StepAP203_HArray1OfStartRequestItem: 
        """
        Returns field Items
        """
    def SetAssignedActionRequest(self,AssignedActionRequest : OCP.StepBasic.StepBasic_VersionedActionRequest) -> None: 
        """
        Set field AssignedActionRequest
        """
    def SetItems(self,Items : StepAP203_HArray1OfStartRequestItem) -> None: 
        """
        Set field Items
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_StartRequestItem(OCP.StepData.StepData_SelectType):
    """
    Representation of STEP SELECT type StartRequestItem
    """
    def Boolean(self) -> bool: 
        """
        None
        """
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a kind of StartRequestItem select type 1 -> ProductDefinitionFormation from StepBasic 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: 
        """
        None
        """
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def ProductDefinitionFormation(self) -> OCP.StepBasic.StepBasic_ProductDefinitionFormation: 
        """
        Returns Value as ProductDefinitionFormation (or Null if another type)
        """
    def Real(self) -> float: 
        """
        None
        """
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: 
        """
        None
        """
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: 
        """
        None
        """
    def SetReal(self,val : float,name : str='') -> None: 
        """
        None
        """
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.
        """
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
class StepAP203_StartWork(OCP.StepBasic.StepBasic_ActionAssignment, OCP.Standard.Standard_Transient):
    """
    Representation of STEP entity StartWorkRepresentation of STEP entity StartWorkRepresentation of STEP entity StartWork
    """
    def AssignedAction(self) -> OCP.StepBasic.StepBasic_Action: 
        """
        Returns field AssignedAction
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aActionAssignment_AssignedAction : OCP.StepBasic.StepBasic_Action,aItems : StepAP203_HArray1OfWorkItem) -> None: 
        """
        Initialize all fields (own and inherited)
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Items(self) -> StepAP203_HArray1OfWorkItem: 
        """
        Returns field Items
        """
    def SetAssignedAction(self,AssignedAction : OCP.StepBasic.StepBasic_Action) -> None: 
        """
        Set field AssignedAction
        """
    def SetItems(self,Items : StepAP203_HArray1OfWorkItem) -> None: 
        """
        Set field Items
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class StepAP203_WorkItem(OCP.StepData.StepData_SelectType):
    """
    Representation of STEP SELECT type WorkItem
    """
    def Boolean(self) -> bool: 
        """
        None
        """
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a kind of WorkItem select type 1 -> ProductDefinitionFormation from StepBasic 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: 
        """
        None
        """
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def ProductDefinitionFormation(self) -> OCP.StepBasic.StepBasic_ProductDefinitionFormation: 
        """
        Returns Value as ProductDefinitionFormation (or Null if another type)
        """
    def Real(self) -> float: 
        """
        None
        """
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: 
        """
        None
        """
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: 
        """
        None
        """
    def SetReal(self,val : float,name : str='') -> None: 
        """
        None
        """
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.
        """
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
