% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listFiles.R
\name{listFiles}
\alias{listFiles}
\title{List files for a version}
\usage{
listFiles(
  project,
  asset,
  version,
  prefix = NULL,
  include.. = TRUE,
  url = restUrl(),
  config = NULL
)
}
\arguments{
\item{project}{String containing the project name.}

\item{asset}{String containing the asset name.}

\item{version}{String containing the version name.}

\item{prefix}{String containing the remaining prefix for the object key.
If provided, a file is only listed if its object key starts with \code{{project}/{asset}/{version}/{prefix}}.
If \code{NULL}, all files associated with this version of the asset are listed.}

\item{include..}{Logical scalar indicating whether to list files with \code{/..} in their object keys.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{config}{Deprecated and ignored.}
}
\value{
Character vector of relative paths of files associated with the versioned asset.
}
\description{
List files belonging to a version of a project asset.
}
\examples{
listFiles("test-R", "basic", "v1")

}
\author{
Aaron Lun
}
