% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_context.R
\name{type_context}
\alias{type_context}
\title{Retrieve context of base substitution types}
\usage{
type_context(vcf, ref_genome, extension = 1)
}
\arguments{
\item{vcf}{A CollapsedVCF object}

\item{ref_genome}{Reference genome}

\item{extension}{The number of bases, that's extracted upstream and
downstream of the base substitutions. (Default: 1).}
}
\value{
Mutation types and context character vectors in a named list
}
\description{
A function to extract the bases 3' upstream and 5' downstream of the base
substitution types.
}
\examples{
## See the 'read_vcfs_as_granges()' example for how we obtained the
## following data:
vcfs <- readRDS(system.file("states/read_vcfs_as_granges_output.rds",
  package = "MutationalPatterns"
))

## Load the corresponding reference genome.
ref_genome <- "BSgenome.Hsapiens.UCSC.hg19"
library(ref_genome, character.only = TRUE)

## Get type context
type_context <- type_context(vcfs[[1]], ref_genome)

## Get larger type context
type_context_larger <- type_context(vcfs[[1]], ref_genome, extension = 2)
}
\seealso{
\code{\link{read_vcfs_as_granges}},
\code{\link{mut_context}}
}
