% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrievers.R
\name{retrieveCDNA}
\alias{retrieveCDNA}
\title{Retrieve the cDNA transcript sequence for a SummarizedExperiment}
\usage{
retrieveCDNA(se, quiet = FALSE)
}
\arguments{
\item{se}{the SummarizedExperiment}

\item{quiet}{logical, suppress messages}
}
\value{
a DNAStringSet object
}
\description{
This helper function retrieves the cDNA sequence of
the transcripts used for expression quantification.
This function either downloads or loads the transcript
sequence from cache, it does not re-order or check against
the rows of the SummarizedExperiment (which could be
already summarized to genes for example).
}
\examples{

example(tximeta)
cdna <- retrieveCDNA(se)

}
