% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update.brmsfit_multiple}
\alias{update.brmsfit_multiple}
\title{Update \pkg{brms} models based on multiple data sets}
\usage{
\method{update}{brmsfit_multiple}(object, formula., newdata = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit_multiple}.}

\item{formula.}{Changes to the formula; for details see 
\code{\link{update.formula}} and \code{\link{brmsformula}}.}

\item{newdata}{List of \code{data.frames} to update the model with new data.
Currently required even if the original data should be used.}

\item{...}{Other arguments passed to \code{\link{update.brmsfit}}
and \code{\link{brm_multiple}}.}
}
\description{
This method allows to update an existing \code{brmsfit_multiple} object.
}
\examples{
\dontrun{
library(mice)
imp <- mice(nhanes2)

# initially fit the model 
fit_imp1 <- brm_multiple(bmi ~ age + hyp + chl, data = imp, chains = 1)
summary(fit_imp1)

# update the model using fewer predictors
fit_imp2 <- update(fit_imp1, formula. = . ~ hyp + chl, newdata = imp)
summary(fit_imp2)
}

}
