% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_remove_intercept.R
\name{tidy_remove_intercept}
\alias{tidy_remove_intercept}
\title{Remove intercept(s)}
\usage{
tidy_remove_intercept(x, model = tidy_get_model(x))
}
\arguments{
\item{x}{(\code{data.frame})\cr
A tidy tibble as produced by \verb{tidy_*()} functions.}

\item{model}{(a model object, e.g. \code{glm})\cr
The corresponding model, if not attached to \code{x}.}
}
\description{
Will remove terms where \code{var_type == "intercept"}.
}
\details{
If the \code{variable} column is not yet available in \code{x},
\code{\link[=tidy_identify_variables]{tidy_identify_variables()}} will be automatically applied.
}
\examples{
df <- Titanic |>
  dplyr::as_tibble() |>
  dplyr::mutate(Survived = factor(Survived))
glm(Survived ~ Class + Age + Sex, data = df, weights = df$n, family = binomial) |>
  tidy_and_attach() |>
  tidy_remove_intercept()
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_coefficients_type}()},
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_n}()},
\code{\link{tidy_add_pairwise_contrasts}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_disambiguate_terms}()},
\code{\link{tidy_group_by}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_plus_plus}()},
\code{\link{tidy_select_variables}()}
}
\concept{tidy_helpers}
