% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmds.R
\docType{class}
\name{nMDS-class}
\alias{nMDS-class}
\alias{nMDS}
\title{Non-Metric Dimensional Scaling}
\description{
An S4 Class implementing Non-Metric Dimensional Scaling.
}
\details{
A non-linear extension of MDS using monotonic regression
}
\section{Slots}{

\describe{
\item{\code{fun}}{A function that does the embedding and returns a
dimRedResult object.}

\item{\code{stdpars}}{The standard parameters for the function.}
}}

\section{General usage}{

Dimensionality reduction methods are S4 Classes that either be used
directly, in which case they have to be initialized and a full
list with parameters has to be handed to the \code{@fun()}
slot, or the method name be passed to the embed function and
parameters can be given to the \code{...}, in which case
missing parameters will be replaced by the ones in the
\code{@stdpars}.
}

\section{Parameters}{

nMDS can take the following parameters:
\describe{
  \item{d}{A distance function.}
  \item{ndim}{The number of embedding dimensions.}
}
}

\section{Implementation}{

Wraps around the
\code{\link[vegan]{monoMDS}}. For parameters that are not
available here, the standard configuration is used.
}

\examples{
if(requireNamespace("vegan", quietly = TRUE)) {

dat <- loadDataSet("3D S Curve", n = 300)
emb <- embed(dat, "nMDS")
plot(emb, type = "2vars")

}
}
\references{
Kruskal, J.B., 1964. Nonmetric multidimensional scaling: A numerical method.
Psychometrika 29, 115-129. https://doi.org/10.1007/BF02289694
}
\seealso{
Other dimensionality reduction methods: 
\code{\link{AutoEncoder-class}},
\code{\link{DRR-class}},
\code{\link{DiffusionMaps-class}},
\code{\link{DrL-class}},
\code{\link{FastICA-class}},
\code{\link{FruchtermanReingold-class}},
\code{\link{HLLE-class}},
\code{\link{Isomap-class}},
\code{\link{KamadaKawai-class}},
\code{\link{MDS-class}},
\code{\link{NNMF-class}},
\code{\link{PCA-class}},
\code{\link{PCA_L1-class}},
\code{\link{UMAP-class}},
\code{\link{dimRedMethod-class}},
\code{\link{dimRedMethodList}()},
\code{\link{kPCA-class}},
\code{\link{tSNE-class}}
}
\concept{dimensionality reduction methods}
