% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section_fun.R
\name{section_fun}
\alias{section_fun}
\alias{set_default}
\alias{section_fun_sub}
\alias{section_fun_env}
\alias{get_section}
\alias{get_fun}
\title{Section a function and set default values in function}
\usage{
set_default(fun, nms, vls = NULL)

section_fun(fun, nms, vls = NULL, method = "args")

section_fun_sub(fun, nms, vls = NULL, envir = parent.frame())

section_fun_env(fun, nms, vls = NULL)

get_section(object)

get_fun(object)
}
\arguments{
\item{fun}{Function to be sectioned}

\item{nms}{Either a named list of the form name=value where each
name is the name of an argument of the function (in which case
\code{vls} is ignored) or a character vector of names of arguments.}

\item{vls}{A vector or list of values of the arguments}

\item{method}{One of the following: 1) "args" (default); based on
substituting fixed values into the function argument list as
default values). For backward compatibility can also be "def".
2) "body" for substituting fixed values into the function
body. For backward compatibility can also be "sub". 3) "env":
(for environment); using an auxillary argument for storing
sectioned values.}

\item{envir}{Environment}

\item{object}{An object from section_fun (a scaffold object).}
}
\value{
A new function: The input function \code{fun} but with certain
arguments fixed at specific values.
}
\description{
Section a functions domain by fixing certain
arguments of a function call.
}
\details{
Let E be a subset of the cartesian product X x Y where X
and Y are some sets. Consider a function f(x,y) defined on
E. Then for any x in X, the section of E defined by x (denoted
Ex) is the set of $y$s in Y such that (x, y) is in
E. Correspondingly, the section of f(x,y) defined by x is the
function $f_x$ defined on Ex given by $f_x(y)=f(x,y)$.

\code{section_fun} is a wrapper for calling \code{set_default} (default
method), \code{section_fun_env} or \code{section_fun_sub}. Notice that
creating a sectioned function with \code{section_fun_sub} can be
time consuming.
}
\examples{

f  <- function(x, y){x + y}

f_ <- section_fun(f, list(y = 10),    method="args") ## "def"" is default
f_ <- section_fun(f, nms="y", vls=10, method="args") ## SAME AS ABOVE
f_
f_(x=1)

f_ <- section_fun(f, list(y = 10),    method="body") ## 
f_ <- section_fun(f, nms="y", vls=10, method="body") ## SAME AS ABOVE
f_
f_(x=1)

f_ <- section_fun(f, list(y = 10),    method="env")
f_ <- section_fun(f, nms="y", vls=10, method="env") ## SAME AS ABOVE
f_
f_(x=1)
get_section(f_)
get_fun(f_)

 
## With more complicated values:
g <- function(A, B) {
  A + B
}
g_ <- section_fun(g, list(A = matrix(1:4, nrow=2)))
g_ <- section_fun(g, "A", list(matrix(1:4, nrow=2)))
g_(diag(1, 2))

g_ <- section_fun(g, list(A = matrix(1:4, nrow=2)))

## Using built in function
set.seed(123)
rnorm5 <- section_fun(rnorm, list(n=5)) 
rnorm5(0, 1)

set.seed(123)
rnorm(5)


}
\seealso{
\code{\link[=bquote_fun_list]{bquote_fun_list()}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk} based on code
adapted from the curry package.
}
