% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-plots.R
\name{ggally_cor}
\alias{ggally_cor}
\title{Correlation value plot}
\usage{
ggally_cor(
  data,
  mapping,
  ...,
  stars = TRUE,
  method = "pearson",
  display_grid = FALSE,
  digits = 3,
  title_args = list(...),
  group_args = list(...),
  justify_labels = "right",
  align_percent = 0.5,
  title = "Corr",
  na.rm = NA,
  use = deprecated(),
  alignPercent = deprecated(),
  displayGrid = deprecated()
)
}
\arguments{
\item{data}{data set using}

\item{mapping}{aesthetics being used}

\item{...}{other arguments being supplied to \code{\link[ggplot2]{geom_text}()} for the title and groups}

\item{stars}{logical value which determines if the significance stars should be displayed.  Given the \code{\link[stats]{cor.test}} p-values, display \describe{
\item{\code{"***"}}{if the p-value is \verb{< 0.001}}
\item{\code{"**"}}{if the p-value is \verb{< 0.01}}
\item{\code{"*"}}{if the p-value is \verb{< 0.05}}
\item{\code{"."}}{if the p-value is \verb{< 0.10}}
\item{\code{""}}{otherwise}
}}

\item{method}{\code{method} supplied to cor function}

\item{display_grid}{if \code{TRUE}, display aligned panel grid lines. If \code{FALSE} (default), display a thin panel border.}

\item{digits}{number of digits to be displayed after the decimal point. See \code{\link[base]{formatC}} for how numbers are calculated.}

\item{title_args}{arguments being supplied to the title's \code{\link[ggplot2]{geom_text}()}}

\item{group_args}{arguments being supplied to the split-by-color group's \code{\link[ggplot2]{geom_text}()}}

\item{justify_labels}{\code{justify} argument supplied when \code{\link[base]{format}}ting the labels}

\item{align_percent}{relative align position of the text. When \code{justify_labels = 0.5}, this should not be needed to be set.}

\item{title}{title text to be displayed}

\item{na.rm}{logical value which determines if \code{NA} values are removed. If \code{TRUE}, no warning message will be displayed.}

\item{use}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}. This variable is not used internally. Please remove it from your code.}

\item{alignPercent, displayGrid}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}. Please use their snake-case counterparts.}
}
\description{
Estimate correlation from the given data. If a color variable is supplied, the correlation will also be calculated per group.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

data(tips)
p_(ggally_cor(tips, mapping = ggplot2::aes(total_bill, tip)))
# display with grid
p_(ggally_cor(
  tips,
  mapping = ggplot2::aes(total_bill, tip),
  display_grid = TRUE
))
# change text attributes
p_(ggally_cor(
  tips,
  mapping = ggplot2::aes(x = total_bill, y = tip),
  size = 15,
  colour = I("red"),
  title = "Correlation"
))
# split by a variable
p_(ggally_cor(
  tips,
  mapping = ggplot2::aes(total_bill, tip, color = sex),
  size = 5
))
}
\seealso{
\code{\link{ggally_statistic}}, \code{\link{ggally_cor_v1_5}}
}
\author{
Barret Schloerke
}
\keyword{hplot}
