% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{knn}
\alias{knn}
\alias{graph.knn}
\title{Average nearest neighbor degree}
\usage{
knn(
  graph,
  vids = V(graph),
  mode = c("all", "out", "in", "total"),
  neighbor.degree.mode = c("all", "out", "in", "total"),
  weights = NULL
)
}
\arguments{
\item{graph}{The input graph. It may be directed.}

\item{vids}{The vertices for which the calculation is performed. Normally it
includes all vertices. Note, that if not all vertices are given here, then
both \sQuote{\code{knn}} and \sQuote{\code{knnk}} will be calculated based
on the given vertices only.}

\item{mode}{Character constant to indicate the type of neighbors to consider
in directed graphs. \code{out} considers out-neighbors, \verb{in} considers
in-neighbors and \code{all} ignores edge directions.}

\item{neighbor.degree.mode}{The type of degree to average in directed graphs.
\code{out} averages out-degrees, \verb{in} averages in-degrees and \code{all}
ignores edge directions for the degree calculation.}

\item{weights}{Weight vector. If the graph has a \code{weight} edge
attribute, then this is used by default. If this argument is given, then
vertex strength (see \code{\link[=strength]{strength()}}) is used instead of vertex
degree. But note that \code{knnk} is still given in the function of the
normal vertex degree.
Weights are are used to calculate a weighted degree (also called
\code{\link[=strength]{strength()}}) instead of the degree.}
}
\value{
A list with two members: \item{knn}{A numeric vector giving the
average nearest neighbor degree for all vertices in \code{vids}.}
\item{knnk}{A numeric vector, its length is the maximum (total) vertex
degree in the graph. The first element is the average nearest neighbor
degree of vertices with degree one, etc.  }
}
\description{
Calculate the average nearest neighbor degree of the given vertices and the
same quantity in the function of vertex degree
}
\details{
Note that for zero degree vertices the answer in \sQuote{\code{knn}} is
\code{NaN} (zero divided by zero), the same is true for \sQuote{\code{knnk}}
if a given degree never appears in the network.

The weighted version computes a weighted average of the neighbor degrees as

\deqn{k_{nn,u} = \frac{1}{s_u} \sum_v w_{uv} k_v,}{k_nn_u = 1/s_u sum_v w_uv k_v,}

where \eqn{s_u = \sum_v w_{uv}}{s_u = sum_v w_uv} is the sum of the incident
edge weights of vertex \code{u}, i.e. its strength.
The sum runs over the neighbors \code{v} of vertex \code{u}
as indicated by \code{mode}. \eqn{w_{uv}}{w_uv} denotes the weighted adjacency matrix
and \eqn{k_v}{k_v} is the neighbors' degree, specified by \code{neighbor_degree_mode}.
}
\examples{

# Some trivial ones
g <- make_ring(10)
knn(g)
g2 <- make_star(10)
knn(g2)

# A scale-free one, try to plot 'knnk'
g3 <- sample_pa(1000, m = 5)
knn(g3)

# A random graph
g4 <- sample_gnp(1000, p = 5 / 1000)
knn(g4)

# A weighted graph
g5 <- make_star(10)
E(g5)$weight <- seq(ecount(g5))
knn(g5)
}
\references{
Alain Barrat, Marc Barthelemy, Romualdo Pastor-Satorras,
Alessandro Vespignani: The architecture of complex weighted networks, Proc.
Natl. Acad. Sci. USA 101, 3747 (2004)
}
\seealso{
Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{girth}()},
\code{\link{is_acyclic}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{laplacian_matrix}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{structural.properties}
\keyword{graphs}
