% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{as_name}
\alias{as_name}
\alias{as_call}
\title{Coerce an object to a name or call.}
\usage{
as_name(x)

as_call(x)
}
\arguments{
\item{x}{An object to coerce}
}
\description{
These are a S3 generics with built-in methods for names, calls, formuals,
and strings. The distinction between a name and a call is particularly
important when coercing from a string. Coercing to a call will parse the
string, coercing to a name will create a (potentially) non-syntactic name.
}
\examples{
as_name("x + y")
as_call("x + y")

as_call(~ f)
as_name(~ f())
}
