% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access.R
\name{permute.vertexIDs}
\alias{permute.vertexIDs}
\title{Permute (Relabel) the Vertices Within a Network}
\usage{
permute.vertexIDs(x, vids)
}
\arguments{
\item{x}{an object of class \code{\link{network}}.}

\item{vids}{a vector of vertex IDs, in the order to which they are to be
permuted.}
}
\value{
Invisibly, a pointer to the permuted network.
\code{permute.vertexIDs} modifies its argument in place.
}
\description{
\code{permute.vertexIDs} permutes the vertices within a given network in the
specified fashion.  Since this occurs internally (at the level of vertex
IDs), it is rarely of interest to end-users.
}
\details{
\code{permute.vertexIDs} alters the internal ordering of vertices within a
\code{\link{network}}.  For most practical applications, this should not be
necessary -- de facto permutation can be accomplished by altering the
appropriate vertex attributes.  \code{permute.vertexIDs} is needed for
certain other routines (such as \code{\link{delete.vertices}}), where it is
used in various arcane and ineffable ways.
}
\examples{

data(flo)                     #Load the Florentine Families data
nflo<-network(flo)                      #Create a network object
n<-network.size(nflo)                #Get the number of vertices
permute.vertexIDs(nflo,n:1)                #Reverse the vertices
all(flo[n:1,n:1]==as.sociomatrix(nflo))          #Should be TRUE

}
\references{
Butts, C. T.  (2008).  \dQuote{network: a Package for Managing
Relational Data in R.} \emph{Journal of Statistical Software}, 24(2).
\url{https://www.jstatsoft.org/v24/i02/}
}
\seealso{
\code{\link{network}}
}
\author{
Carter T. Butts \email{buttsc@uci.edu}
}
\keyword{graphs}
\keyword{manip}
