% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PB-refdist.R
\name{pb-refdist}
\alias{PBrefdist}
\alias{PBrefdist.lm}
\alias{PBrefdist.mer}
\alias{PBrefdist.merMod}
\alias{pb-refdist}
\title{Calculate reference distribution using parametric bootstrap}
\usage{
PBrefdist(largeModel, smallModel, nsim = 1000, seed = NULL, cl = NULL,
  details = 0)

\method{PBrefdist}{lm}(largeModel, smallModel, nsim = 1000, seed = NULL,
  cl = NULL, details = 0)

\method{PBrefdist}{merMod}(largeModel, smallModel, nsim = 1000, seed = NULL,
  cl = NULL, details = 0)

\method{PBrefdist}{mer}(largeModel, smallModel, nsim = 1000, seed = NULL,
  cl = NULL, details = 0)
}
\arguments{
\item{largeModel}{A linear mixed effects model as fitted with the
\code{lmer()} function in the \pkg{lme4} package. This model muse be
larger than \code{smallModel} (see below).}

\item{smallModel}{A linear mixed effects model as fitted with the
\code{lmer()} function in the \pkg{lme4} package. This model muse be
smaller than \code{largeModel} (see above).}

\item{nsim}{The number of simulations to form the reference distribution.}

\item{seed}{Seed for the random number generation.}

\item{cl}{A vector identifying a cluster; used for calculating the reference
distribution using several cores. See examples below.}

\item{details}{The amount of output produced. Mainly relevant for debugging
purposes.}
}
\value{
A numeric vector
}
\description{
Calculate reference distribution of likelihood ratio statistic
    in mixed effects models using parametric bootstrap
}
\details{
The model \code{object} must be fitted with maximum likelihood
    (i.e. with \code{REML=FALSE}). If the object is fitted with restricted
    maximum likelihood (i.e. with \code{REML=TRUE}) then the model is
    refitted with \code{REML=FALSE} before the p-values are calculated. Put
    differently, the user needs not worry about this issue.
}
\examples{

data(beets)
head(beets)
beet0 <- lmer(sugpct ~ block + sow + harvest + (1|block : harvest), data=beets, REML=FALSE)
beet_no.harv <- update(beet0, .~.-harvest)
rr <- PBrefdist(beet0, beet_no.harv, nsim=20)
rr

## Note: Many more simulations must be made in practice.

## Computations can be made in parallel using several processors:
\dontrun{
cl <- makeSOCKcluster(rep("localhost", 4))
clusterEvalQ(cl, library(lme4))
clusterSetupSPRNG(cl)
rr <- PBrefdist(beet0, beet_no.harv, nsim=20)
stopCluster(cl)
}
## Above, 4 cpu's are used and 5 simulations are made on each cpu.

}
\author{
Søren Højsgaard \email{sorenh@math.aau.dk}
}
\references{
Ulrich Halekoh, Søren Højsgaard (2014)., A Kenward-Roger
    Approximation and Parametric Bootstrap Methods for Tests in Linear Mixed
    Models - The R Package pbkrtest., Journal of Statistical Software,
    58(10), 1-30., \url{http://www.jstatsoft.org/v59/i09/}
}
\seealso{
\code{\link{PBmodcomp}}, \code{\link{KRmodcomp}}
}
\keyword{inference}
\keyword{models}

