% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tof2mass-functions.R
\name{.tof2mass}
\alias{.tof2mass}
\title{Calculates mass from time-of-flight values.}
\usage{
.tof2mass(tof, c1, c2, c3)
}
\arguments{
\item{tof}{\code{double}, vector with times-of-flight}

\item{c1}{metaData$calibrationConstants[1]}

\item{c2}{metaData$calibrationConstants[2]}

\item{c3}{metaData$calibrationConstants[3]}
}
\value{
\code{double}, calculated mass
}
\description{
This function calculates mass from time of flight values
based on the following article:
 Titulaer, M. K. and Siccama, I. and Dekker, J. L. and
 van Rijswijk, A. L. and Heeren R. M. and Sillevis Smitt, P. A. and
 Luider, T. M. (2006) \cr
 \dQuote{A database application for pre-processing, storage and comparison
 of mass spectra derived from patients and controls},
 \emph{BMC Bioinformatics}, \bold{7}: 403
 \url{http://www.ncbi.nlm.nih.gov/pubmed/16953879}
}
\details{
Arguments are imported from metadata (acqu-file).
}
\references{
Titulaer, M. K. and Siccama, I. and Dekker, J. L. and
 van Rijswijk, A. L. and Heeren R. M. and Sillevis Smitt, P. A. and
 Luider, T. M. (2006) \cr
 \dQuote{A database application for pre-processing, storage and comparison
 of mass spectra derived from patients and controls},
 \emph{BMC Bioinformatics}, \bold{7}: 403
 \url{http://www.ncbi.nlm.nih.gov/pubmed/16953879}
}
\keyword{internal}

