% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabsel_par.R
\name{stabsel_par}
\alias{stabsel_par}
\title{Stability selection, parallelized version}
\usage{
stabsel_par(data, model, det.range = FALSE, from, to, times = 50,
  jump = 0.01, detr.nlambda = 20, n.lambda = 40, n.boot = 100,
  det.thr = FALSE, p = 0.8, p.from = 0.5, p.to = 1,
  p.jump = 0.05, p.method = "aic", type = "lasso",
  pars_pen = "regressions", ...)
}
\arguments{
\item{data}{data frame}

\item{model}{lavaan syntax model.}

\item{det.range}{Whether to determine the range of penalization values for stability selection through bootstrapping. Default is FALSE, from and to arguments are then needed. If set to TRUE, then jump, times and detr.nlambda arguments will be needed.}

\item{from}{Minimum value of penalization values for stability selection.}

\item{to}{Maximum value of penalization values for stability selection.}

\item{times}{Number of bootstrapping sample used to determine the range. Default is 50.}

\item{jump}{Amount to increase penalization each iteration. Default is 0.01}

\item{detr.nlambda}{Number of penalization values to test for determing range.}

\item{n.lambda}{Number of penalization values to test for stability selection.}

\item{n.boot}{Number of bootstrap samples needed for stability selection.}

\item{det.thr}{Whether to determine the probability threshold value. Default is FALSE, p is then needed. If set to TRUE, p.from, p.to, p.method arguments will be needed.}

\item{p}{Probability threshold: above which selection probability is the path kept in the modle. Default value is 0.8.}

\item{p.from}{Lower bound of probability threshold to test. Default is 0.5.}

\item{p.to}{Upper bound of probability threshold to test. Default is 1.}

\item{p.jump}{Amount to increase threshold each iteration. Default is 0.05.}

\item{p.method}{Which fit index to use to choose a final model?}

\item{type}{Penalty type}

\item{pars_pen}{Parameter indicators to penalize.}

\item{...}{Any additional arguments to pass to regsem() or cv_regsem().}
}
\description{
Stability selection, parallelized version
}
