% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbBegin_SQLiteConnection.R,
%   R/dbCommit_SQLiteConnection.R, R/dbRollback_SQLiteConnection.R,
%   R/transactions.R
\name{dbBegin_SQLiteConnection}
\alias{dbBegin_SQLiteConnection}
\alias{dbBegin,SQLiteConnection-method}
\alias{dbCommit_SQLiteConnection}
\alias{dbCommit,SQLiteConnection-method}
\alias{dbRollback_SQLiteConnection}
\alias{dbRollback,SQLiteConnection-method}
\alias{sqlite-transaction}
\alias{sqliteIsTransacting}
\title{SQLite transaction management}
\usage{
\S4method{dbBegin}{SQLiteConnection}(conn, .name = NULL, ..., name = NULL)

\S4method{dbCommit}{SQLiteConnection}(conn, .name = NULL, ..., name = NULL)

\S4method{dbRollback}{SQLiteConnection}(conn, .name = NULL, ..., name = NULL)

sqliteIsTransacting(conn)
}
\arguments{
\item{conn}{a \code{\linkS4class{SQLiteConnection}} object, produced by
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{.name}{For backward compatibility, do not use.}

\item{...}{Needed for compatibility with generic. Otherwise ignored.}

\item{name}{Supply a name to use a named savepoint. This allows you to
nest multiple transaction}
}
\description{
By default, SQLite is in auto-commit mode. \code{dbBegin()} starts
a SQLite transaction and turns auto-commit off. \code{dbCommit()} and
\code{dbRollback()} commit and rollback the transaction, respectively and turn
auto-commit on.
\code{\link[DBI:dbWithTransaction]{DBI::dbWithTransaction()}} is a convenient wrapper that makes sure that
\code{dbCommit()} or \code{dbRollback()} is called.
A helper function \code{sqliteIsTransacting()} is available to check the current
transaction status of the connection.
}
\examples{
library(DBI)
con <- dbConnect(SQLite(), ":memory:")
dbWriteTable(con, "arrests", datasets::USArrests)
dbGetQuery(con, "select count(*) from arrests")

dbBegin(con)
rs <- dbSendStatement(con, "DELETE from arrests WHERE Murder > 1")
dbGetRowsAffected(rs)
dbClearResult(rs)

dbGetQuery(con, "select count(*) from arrests")

dbRollback(con)
dbGetQuery(con, "select count(*) from arrests")[1, ]

dbBegin(con)
rs <- dbSendStatement(con, "DELETE FROM arrests WHERE Murder > 5")
dbClearResult(rs)
dbCommit(con)
dbGetQuery(con, "SELECT count(*) FROM arrests")[1, ]

# Named savepoints can be nested --------------------------------------------
dbBegin(con, name = "a")
dbBegin(con, name = "b")
sqliteIsTransacting(con)
dbRollback(con, name = "b")
dbCommit(con, name = "a")

dbDisconnect(con)
}
\seealso{
The corresponding generic functions \code{\link[DBI:transactions]{DBI::dbBegin()}}, \code{\link[DBI:transactions]{DBI::dbCommit()}},
and \code{\link[DBI:transactions]{DBI::dbRollback()}}.
}
