% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_mark_significant.R
\name{cor_mark_significant}
\alias{cor_mark_significant}
\title{Add Significance Levels To a Correlation Matrix}
\usage{
cor_mark_significant(
  x,
  cutpoints = c(0, 1e-04, 0.001, 0.01, 0.05, 1),
  symbols = c("****", "***", "**", "*", "")
)
}
\arguments{
\item{x}{an object of class \code{\link{cor_mat}()}.}

\item{cutpoints}{numeric vector used for intervals.}

\item{symbols}{character vector, one shorter than cutpoints, used as
significance symbols.}
}
\value{
a data frame containing the lower triangular part of the correlation
  matrix marked by significance symbols.
}
\description{
Combines correlation coefficients and significance levels in a
  correlation matrix data.
}
\examples{
mtcars \%>\%
  select(mpg, disp, hp, drat, wt, qsec) \%>\%
  cor_mat() \%>\%
  cor_mark_significant()
}
