% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{VariableFeaturePlot}
\alias{VariableFeaturePlot}
\alias{VariableGenePlot}
\alias{MeanVarPlot}
\title{View variable features}
\usage{
VariableFeaturePlot(
  object,
  cols = c("black", "red"),
  pt.size = 1,
  log = NULL,
  selection.method = NULL,
  assay = NULL,
  raster = NULL,
  raster.dpi = c(512, 512)
)
}
\arguments{
\item{object}{Seurat object}

\item{cols}{Colors to specify non-variable/variable status}

\item{pt.size}{Size of the points on the plot}

\item{log}{Plot the x-axis in log scale}

\item{selection.method}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{assay}{Assay to pull variable features from}

\item{raster}{Convert points to raster format, default is \code{NULL}
which will automatically use raster if the number of points plotted is greater than
100,000}

\item{raster.dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(512, 512).}
}
\value{
A ggplot object
}
\description{
View variable features
}
\examples{
data("pbmc_small")
VariableFeaturePlot(object = pbmc_small)

}
\seealso{
\code{\link{FindVariableFeatures}}
}
\concept{visualization}
