% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reroute.R
\name{reroute}
\alias{reroute}
\title{Change terminal nodes of edges}
\usage{
reroute(.data, from = NULL, to = NULL, subset = NULL)
}
\arguments{
\item{.data}{A tbl_graph or morphed_tbl_graph object. grouped_tbl_graph will
be ungrouped prior to rerouting}

\item{from, to}{The new indexes of the terminal nodes. If \code{NULL} nothing will
be changed}

\item{subset}{An expression evaluating to an indexing vector in the context
of the edge data.}
}
\value{
An object of the same class as .data
}
\description{
The reroute verb lets you change the beginning and end node of edges by
specifying the new indexes of the start and/or end node(s). Optionally only
a subset of the edges can be rerouted using the subset argument, which should
be an expression that are to be evaluated in the context of the edge data and
should return an index compliant vector (either logical or integer).
}
\examples{
# Switch direction of edges
create_notable('meredith') \%>\%
  activate(edges) \%>\%
  reroute(from = to, to = from)

# Using subset
create_notable('meredith') \%>\%
  activate(edges) \%>\%
  reroute(from = 1, subset = to > 10)
}
