% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAR.R
\name{SAR}
\alias{SAR}
\title{Parabolic Stop-and-Reverse}
\usage{
SAR(HL, accel = c(0.02, 0.2))
}
\arguments{
\item{HL}{Object that is coercible to xts or matrix and contains High-Low
prices.}

\item{accel}{accel[1]: Acceleration factor.\cr accel[2]: Maximum acceleration
factor.}
}
\value{
A object of the same class as \code{HL} or a vector (if
\code{try.xts} fails) containing the Parabolic Stop and Reverse values.
}
\description{
The Parabolic Stop-and-Reverse calculates a trailing stop.  Developed by J.
Welles Wilder.
}
\details{
The calculation for the SAR is quite complex.  See the URLs in the references
section for calculation notes.

The SAR assumes that you are always in the market, and calculates the Stop
And Reverse point when you would close a long position and open a short
position or vice versa.
}
\examples{

 data(ttrc)
 sar <- SAR(ttrc[,c("High","Low")])

}
\references{
The following site(s) were used to code/document this
indicator:\cr
\url{https://www.linnsoft.com/techind/parabolic-sar-sar}\cr
\url{https://www.fmlabs.com/reference/SAR.htm}\cr
\url{https://school.stockcharts.com/doku.php?id=technical_indicators:parabolic_sar}\cr
\url{https://www.metastock.com/Customer/Resources/TAAZ/?p=87}
}
\seealso{
See \code{\link{ATR}} and \code{\link{ADX}}, which were also
developed by Welles Wilder.
}
\author{
Joshua Ulrich
}
\keyword{ts}
