% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type.R
\name{vec_ptype}
\alias{vec_ptype}
\alias{vec_ptype_common}
\alias{vec_ptype_show}
\title{Find the prototype of a set of vectors}
\usage{
vec_ptype(x)

vec_ptype_common(..., .ptype = NULL)

vec_ptype_show(...)
}
\arguments{
\item{..., x}{Vectors inputs}

\item{.ptype}{If \code{NULL}, the default, the output type is determined by
computing the common type across all elements of \code{...}.

Alternatively, you can supply \code{.ptype} to give the output known type.
If \code{getOption("vctrs.no_guessing")} is \code{TRUE} you must supply this value:
this is a convenient way to make production code demand fixed types.}
}
\value{
\code{vec_ptype()} and \code{vec_ptype_common()} return a prototype
(a size-0 vector)
}
\description{
\code{vec_ptype()} returns the unfinalised prototype of a single vector.
\code{vec_ptype_common()} finds the common type of multiple vectors.
\code{vec_ptype_show()} nicely prints the common type of any number of
inputs, and is designed for interactive exploration.
}
\section{\code{vec_ptype()}}{

\code{vec_ptype()} returns \link[=vec_size]{size} 0 vectors potentially
containing attributes but no data. Generally, this is just
\code{vec_slice(x, 0L)}, but some inputs require special
handling.
\itemize{
\item While you can't slice \code{NULL}, the prototype of \code{NULL} is
itself. This is because we treat \code{NULL} as an identity value in
the \code{vec_ptype2()} monoid.
\item The prototype of logical vectors that only contain missing values
is the special \link{unspecified} type, which can be coerced to any
other 1d type. This allows bare \code{NA}s to represent missing values
for any 1d vector type.
}

See \link{internal-faq-ptype2-identity} for more information about
identity values.

Because it may contain unspecified vectors, the prototype returned
by \code{vec_ptype()} is said to be \strong{unfinalised}. Call
\code{\link[=vec_ptype_finalise]{vec_ptype_finalise()}} to finalise it. Commonly you will need the
finalised prototype as returned by \code{vec_slice(x, 0L)}.
}

\section{\code{vec_ptype_common()}}{

\code{vec_ptype_common()} first finds the prototype of each input, then
successively calls \code{\link[=vec_ptype2]{vec_ptype2()}} to find a common type. It returns
a \link[=vec_ptype_finalise]{finalised} prototype.
}

\examples{
# Unknown types ------------------------------------------
vec_ptype_show()
vec_ptype_show(NA)
vec_ptype_show(NULL)

# Vectors ------------------------------------------------
vec_ptype_show(1:10)
vec_ptype_show(letters)
vec_ptype_show(TRUE)

vec_ptype_show(Sys.Date())
vec_ptype_show(Sys.time())
vec_ptype_show(factor("a"))
vec_ptype_show(ordered("a"))

# Matrices -----------------------------------------------
# The prototype of a matrix includes the number of columns
vec_ptype_show(array(1, dim = c(1, 2)))
vec_ptype_show(array("x", dim = c(1, 2)))

# Data frames --------------------------------------------
# The prototype of a data frame includes the prototype of
# every column
vec_ptype_show(iris)

# The prototype of multiple data frames includes the prototype
# of every column that in any data frame
vec_ptype_show(
  data.frame(x = TRUE),
  data.frame(y = 2),
  data.frame(z = "a")
)
}
