% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{page_backlinks}
\alias{page_backlinks}
\title{Retrieve a page's backlinks}
\usage{
page_backlinks(
  language = NULL,
  project = NULL,
  domain = NULL,
  page,
  limit = 50,
  direction = "ascending",
  namespaces = NULL,
  clean_response = FALSE,
  ...
)
}
\arguments{
\item{language}{The language code of the project you wish to query,
if appropriate.}

\item{project}{The project you wish to query ("wikiquote"), if appropriate.
Should be provided in conjunction with \code{language}.}

\item{domain}{as an alternative to a \code{language} and \code{project} combination,
you can also provide a domain ("rationalwiki.org") to the URL constructor, allowing
for the querying of non-Wikimedia MediaWiki instances.}

\item{page}{the title of the page you want the backlinks of.}

\item{limit}{the number of backlinks to return. Set to 50 (the maximum) by default.}

\item{direction}{the direction to order the backlinks in, by linking page ID: "ascending"
or "descending". Set to "ascending" by default.}

\item{namespaces}{The namespaces to filter to. By default, backlinks from any namespace
are retrieved: alternately, a numeric vector of accepted namespaces (which are described
\href{https://www.mediawiki.org/wiki/Manual:Namespace#Built-in_namespaces}{here}) can be
provided, and only backlinks from pages within those namespaces will be returned.}

\item{clean_response}{whether to do some basic sanitising of the resulting data structure.
Set to FALSE by default.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
page_backlinks, when provided with a page title, retrieves backlinks to that
page. Output can be filtered to specific namespaces.
}
\section{Warnings}{
 as with \code{\link{pages_in_category}}, if the page
you are linking to does not exist, an empty list will be returned, without
any indication of an error.
}

\examples{
\dontrun{
#Backlink
all_bls <- page_backlinks("en","wikipedia", page = "Aaron Halfaker")

#Namespace-specific backlinks
mainspace_bls <- page_backlinks("en","wikipedia", page = "Aaron Halfaker", namespaces = 0)
}
}
